% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train.R
\name{train}
\alias{train}
\title{Train a learning algorithm.}
\usage{
train(learner, task, subset = NULL, weights = NULL)
}
\arguments{
\item{learner}{(\link{Learner} | \code{character(1)})\cr
The learner.
If you pass a string the learner will be created via \link{makeLearner}.}

\item{task}{(\link{Task})\cr
The task.}

\item{subset}{(\link{integer} | \link{logical} | \code{NULL})\cr
Selected cases. Either a logical or an index vector.
By default \code{NULL} if all observations are used.}

\item{weights}{(\link{numeric})\cr
Optional, non-negative case weight vector to be used during fitting.
If given, must be of same length as \code{subset} and in corresponding order.
By default \code{NULL} which means no weights are used unless specified in the task (\link{Task}).
Weights from the task will be overwritten.}
}
\value{
(\link{WrappedModel}).
}
\description{
Given a \link{Task}, creates a model for the learning machine
which can be used for predictions on new data.
}
\examples{
training.set = sample(seq_len(nrow(iris)), nrow(iris) / 2)

## use linear discriminant analysis to classify iris data
task = makeClassifTask(data = iris, target = "Species")
learner = makeLearner("classif.lda", method = "mle")
mod = train(learner, task, subset = training.set)
print(mod)

## use random forest to classify iris data
task = makeClassifTask(data = iris, target = "Species")
learner = makeLearner("classif.rpart", minsplit = 7, predict.type = "prob")
mod = train(learner, task, subset = training.set)
print(mod)
}
\seealso{
\link{predict.WrappedModel}
}
