% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractFDAFeaturesMethods.R
\name{extractFDATsfeatures}
\alias{extractFDATsfeatures}
\title{Time-Series Feature Heuristics}
\usage{
extractFDATsfeatures(
  scale = TRUE,
  trim = FALSE,
  trim_amount = 0.1,
  parallel = FALSE,
  na.action = na.pass,
  feats = NULL,
  ...
)
}
\arguments{
\item{scale}{(\code{logical(1)})\cr
If TRUE, time series are scaled to mean 0 and sd 1 before features are computed.}

\item{trim}{(\code{logical(1)})\cr
If TRUE, time series are trimmed by \code{trim_amount} before features are computed.
Values larger than trim_amount in absolute value are set to NA.}

\item{trim_amount}{(\code{numeric(1)})\cr
Default level of trimming if \code{trim==TRUE}.}

\item{parallel}{(\code{logical(1)})\cr
If \code{TRUE}, multiple cores (or multiple sessions) will be used.
This only speeds things up when there are a large number of time series.}

\item{na.action}{(\code{logical(1)})\cr
A function to handle missing values. Use \code{na.interp} to estimate missing values}

\item{feats}{(\code{character})\cr
A character vector of function names to apply to each time-series in order to extract features.\cr
Default:\cr
feats = c("frequency", "stl_features", "entropy", "acf_features", "arch_stat",
"crossing_points", "flat_spots", "hurst",  "holt_parameters", "lumpiness",
"max_kl_shift", "max_var_shift", "max_level_shift", "stability", "nonlinearity")}

\item{...}{(any)\cr
Further arguments passed on to the respective tsfeatures functions.}
}
\value{
(\link{data.frame})
}
\description{
The function extracts features from functional data based on known Heuristics.
For more details refer to \code{\link[tsfeatures:tsfeatures]{tsfeatures::tsfeatures()}}.
Under the hood this function uses the package \code{\link[tsfeatures:tsfeatures]{tsfeatures::tsfeatures()}}.
For more information see Hyndman, Wang and Laptev, Large-Scale Unusual Time Series Detection, ICDM 2015.

Note: Currently computes the following features:\cr
"frequency", "stl_features", "entropy", "acf_features", "arch_stat",
"crossing_points", "flat_spots", "hurst",  "holt_parameters", "lumpiness",
"max_kl_shift", "max_var_shift", "max_level_shift", "stability", "nonlinearity"
}
\references{
Hyndman, Wang and Laptev, Large-Scale Unusual Time Series Detection, ICDM 2015.
}
\seealso{
Other fda_featextractor: 
\code{\link{extractFDABsignal}()},
\code{\link{extractFDADTWKernel}()},
\code{\link{extractFDAFPCA}()},
\code{\link{extractFDAFourier}()},
\code{\link{extractFDAMultiResFeatures}()},
\code{\link{extractFDAWavelets}()}
}
\concept{fda_featextractor}
