use pipeline::Pipeline;

pub fn make_pipeline() -> Pipeline {
    Pipeline {
        queue: vec![
            ("trimmer-fi".into(), trimmer),
            ("stopWordFilter-fi".into(), stop_word_filter),
            ("stemmer-fi".into(), stemmer),
        ],
    }
}

make_trimmer!(
    "A-Za-z\\xAA\\xBA\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02B8\\u02E0-\\u02E4\\u1D00-\\u1D25\
     \\u1D2C-\\u1D5C\\u1D62-\\u1D65\\u1D6B-\\u1D77\\u1D79-\\u1DBE\\u1E00-\\u1EFF\\u2071\\u207F\
     \\u2090-\\u209C\\u212A\\u212B\\u2132\\u214E\\u2160-\\u2188\\u2C60-\\u2C7F\\uA722-\\uA787\
     \\uA78B-\\uA7AD\\uA7B0-\\uA7B7\\uA7F7-\\uA7FF\\uAB30-\\uAB5A\\uAB5C-\\uAB64\\uFB00-\\uFB06\
     \\uFF21-\\uFF3A\\uFF41-\\uFF5A"
);

make_stop_word_filter!([
    "",
    "ei",
    "eivät",
    "emme",
    "en",
    "et",
    "ette",
    "että",
    "he",
    "heidän",
    "heidät",
    "heihin",
    "heille",
    "heillä",
    "heiltä",
    "heissä",
    "heistä",
    "heitä",
    "hän",
    "häneen",
    "hänelle",
    "hänellä",
    "häneltä",
    "hänen",
    "hänessä",
    "hänestä",
    "hänet",
    "häntä",
    "itse",
    "ja",
    "johon",
    "joiden",
    "joihin",
    "joiksi",
    "joilla",
    "joille",
    "joilta",
    "joina",
    "joissa",
    "joista",
    "joita",
    "joka",
    "joksi",
    "jolla",
    "jolle",
    "jolta",
    "jona",
    "jonka",
    "jos",
    "jossa",
    "josta",
    "jota",
    "jotka",
    "kanssa",
    "keiden",
    "keihin",
    "keiksi",
    "keille",
    "keillä",
    "keiltä",
    "keinä",
    "keissä",
    "keistä",
    "keitä",
    "keneen",
    "keneksi",
    "kenelle",
    "kenellä",
    "keneltä",
    "kenen",
    "kenenä",
    "kenessä",
    "kenestä",
    "kenet",
    "ketkä",
    "ketkä",
    "ketä",
    "koska",
    "kuin",
    "kuka",
    "kun",
    "me",
    "meidän",
    "meidät",
    "meihin",
    "meille",
    "meillä",
    "meiltä",
    "meissä",
    "meistä",
    "meitä",
    "mihin",
    "miksi",
    "mikä",
    "mille",
    "millä",
    "miltä",
    "minkä",
    "minkä",
    "minua",
    "minulla",
    "minulle",
    "minulta",
    "minun",
    "minussa",
    "minusta",
    "minut",
    "minuun",
    "minä",
    "minä",
    "missä",
    "mistä",
    "mitkä",
    "mitä",
    "mukaan",
    "mutta",
    "ne",
    "niiden",
    "niihin",
    "niiksi",
    "niille",
    "niillä",
    "niiltä",
    "niin",
    "niin",
    "niinä",
    "niissä",
    "niistä",
    "niitä",
    "noiden",
    "noihin",
    "noiksi",
    "noilla",
    "noille",
    "noilta",
    "noin",
    "noina",
    "noissa",
    "noista",
    "noita",
    "nuo",
    "nyt",
    "näiden",
    "näihin",
    "näiksi",
    "näille",
    "näillä",
    "näiltä",
    "näinä",
    "näissä",
    "näistä",
    "näitä",
    "nämä",
    "ole",
    "olemme",
    "olen",
    "olet",
    "olette",
    "oli",
    "olimme",
    "olin",
    "olisi",
    "olisimme",
    "olisin",
    "olisit",
    "olisitte",
    "olisivat",
    "olit",
    "olitte",
    "olivat",
    "olla",
    "olleet",
    "ollut",
    "on",
    "ovat",
    "poikki",
    "se",
    "sekä",
    "sen",
    "siihen",
    "siinä",
    "siitä",
    "siksi",
    "sille",
    "sillä",
    "sillä",
    "siltä",
    "sinua",
    "sinulla",
    "sinulle",
    "sinulta",
    "sinun",
    "sinussa",
    "sinusta",
    "sinut",
    "sinuun",
    "sinä",
    "sinä",
    "sitä",
    "tai",
    "te",
    "teidän",
    "teidät",
    "teihin",
    "teille",
    "teillä",
    "teiltä",
    "teissä",
    "teistä",
    "teitä",
    "tuo",
    "tuohon",
    "tuoksi",
    "tuolla",
    "tuolle",
    "tuolta",
    "tuon",
    "tuona",
    "tuossa",
    "tuosta",
    "tuota",
    "tähän",
    "täksi",
    "tälle",
    "tällä",
    "tältä",
    "tämä",
    "tämän",
    "tänä",
    "tässä",
    "tästä",
    "tätä",
    "vaan",
    "vai",
    "vaikka",
    "yli"
]);

make_stemmer!(Algorithm::Finnish);
