#### Note: this error code is no longer emitted by the compiler.

The `Default` trait was derived on an enum.

Erroneous code example:

```compile_fail
#[derive(Default)]
enum Food {
    Sweet,
    Salty,
}
```

The `Default` cannot be derived on an enum for the simple reason that the
compiler doesn't know which value to pick by default whereas it can for a
struct as long as all its fields implement the `Default` trait as well.

If you still want to implement `Default` on your enum, you'll have to do it "by
hand":

```
enum Food {
    Sweet,
    Salty,
}

impl Default for Food {
    fn default() -> Food {
        Food::Sweet
    }
}
```
