// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2008 - INRIA - Pierre MARECHAL
// Copyright (C) 2014 - Scilab Enterprises - Antoine ELIAS
//
// Copyright (C) 2012 - 2016 - Scilab Enterprises
//
// This file is hereby licensed under the terms of the GNU GPL v2.0,
// pursuant to article 5.3.4 of the CeCILL v.2.1.
// This file was originally licensed under the terms of the CeCILL v2.1,
// and continues to be available under such terms.
// For more information, see the COPYING file which you should have received
// along with this program.
//

function uicontrol_plot3d()
    demo_plot3d = figure( ...
        "dockable", "off", ...
        "infobar_visible", "off", ...
        "toolbar_visible", "off", ...
        "toolbar", "none", ...
        "menubar_visible", "on", ...
        "menubar", "none", ...
        "default_axes", "off", ...
        "layout", "border", ...
        "visible", "off");

    fakeframe_height = 10;
    demo_plot3d.figure_id       = 100001;
    demo_plot3d.background      = -2;
    demo_plot3d.color_map       = jetcolormap(128);
    demo_plot3d.figure_position = [0 0];
    demo_plot3d.figure_name     = gettext("Control Plot3d");
    demo_plot3d.axes_size       = [900 450];

    // New menu
    h = uimenu(demo_plot3d, ...
        "label" , gettext("File"));

    uimenu(h, ...
        "label"     , gettext("Close"), ...
        "callback"  , "demo_plot3d=findobj(""figure_id"",100001);delete(demo_plot3d);", ...
        "tag"       , "close_menu");

    demo_viewCode(SCI+ "/modules/gui/demos/cb_uicontrol_plot3d.dem.sci");

    frame_left = uicontrol(demo_plot3d, ...
        "style", "frame", ...
        "constraints", createConstraints("border", "left", [250, 0]), ...
        "border", createBorder("titled", createBorder("line", "lightGray", 1), _("Control Panel"), "center", "below_top", createBorderFont("", 16, "normal"), "black"), ...
        "backgroundcolor", [1 1 1], ...
        "layout", "gridbag");

    //angle
    frame_angle = uicontrol(frame_left, ...
        "style", "frame", ...
        "backgroundcolor", [1 1 1], ...
        "constraints", createConstraints("gridbag", [1, 2, 1, 1], [0, 0], "both", "center"), ...
        "border", createBorder("titled", createBorder("line", "lightGray", 1), _("Rotation angle"), "center", "top", createBorderFont("", 11, "normal"), "black"), ...
        "layout", "border");

    uicontrol(frame_angle, ...
        "style", "slider", ...
        "backgroundcolor", [1 1 1], ...
        "value", 70, ...
        "min", 0, ...
        "max", 360, ...
        "sliderstep", [2, 30], ...
        "callback", "update_plot3d_angle");

    //colormap
    frame_colormap = uicontrol(frame_left, ...
        "style", "frame", ...
        "backgroundcolor", [1 1 1], ...
        "constraints", createConstraints("gridbag", [1, 3, 1, 1], [0, 0], "both", "center"), ...
        "border", createBorder("titled", createBorder("line", "lightGray", 1), _("Colormap"), "center", "top", createBorderFont("", 11, "normal"), "black"), ...
        "layout_options", createLayoutOptions("grid", [3, 1]));

    frame_colormap.layout = "grid";

    uicontrol(frame_colormap, ...
        "style", "radiobutton", ...
        "backgroundcolor", [1 1 1], ...
        "tag", "graycolormap", ...
        "string", "Graycolormap", ...
        "groupname", "colormap", ...
        "callback", "update_colormap");

    uicontrol(frame_colormap, ...
        "style", "radiobutton", ...
        "backgroundcolor", [1 1 1], ...
        "tag", "hotcolormap", ...
        "string", "Hotcolormap", ...
        "groupname", "colormap", ...
        "callback", "update_colormap");

    jet = uicontrol(frame_colormap, ...
        "tag", "jetcolormap", ...
        "backgroundcolor", [1 1 1], ...
        "style", "radiobutton", ...
        "string", "Jetcolormap", ...
        "groupname", "colormap", ...
        "callback", "update_colormap");

    jet.value = 1;

    //background
    frame_background = uicontrol(frame_left, ...
        "style", "frame", ...
        "backgroundcolor", [1 1 1], ...
        "constraints", createConstraints("gridbag", [1, 4, 1, 1], [0, 0], "both", "center"), ...
        "border", createBorder("titled", createBorder("line", "lightGray", 1), _("Background Color"), "center", "top", createBorderFont("", 11, "normal"), "black"), ..
        "layout", "border");

    uicontrol(frame_background, ...
        "tag", "button", ...
        "style", "pushbutton", ...
        "backgroundcolor", [1 1 1], ...
        "relief", "raised", ...
        "constraints", createConstraints("border", "center", [30 30]), ...
        "string", "Color picker", ...
        "callback", "update_background_color");

    //Show/hide
    frame_style = uicontrol(frame_left, ...
        "style", "frame", ...
        "backgroundcolor", [1 1 1], ...
        "constraints", createConstraints("gridbag", [1, 5, 1, 1], [1, 0], "both", "center"), ...
        "border", createBorder("titled", createBorder("line", "lightGray", 1), _("Show / Hide"), "center", "top", createBorderFont("", 11, "normal"), "black"), ...
        "layout_options", createLayoutOptions("grid", [4, 1]));

    frame_style.layout = "grid";

    uicontrol(frame_style, ...
        "style", "checkbox", ...
        "backgroundcolor", [1 1 1], ...
        "value", 1, ...
        "string", "Edges", ...
        "callback", "update_edges_visible");

    uicontrol(frame_style, ...
        "style", "checkbox", ...
        "backgroundcolor", [1 1 1], ...
        "value", 1, ...
        "string", "Labels", ...
        "callback", "update_labels_visible");

    uicontrol(frame_style, ...
        "style", "checkbox", ...
        "backgroundcolor", [1 1 1], ...
        "value", 1, ...
        "string", "Title", ...
        "callback", "update_title_visible");

    uicontrol(frame_style, ...
        "style", "checkbox", ...
        "backgroundcolor", [1 1 1], ...
        "value", 1, ...
        "string", "Tics", ...
        "callback", "update_tics_visible");

    //Title
    frame_style = uicontrol(frame_left, ...
        "style", "frame", ...
        "backgroundcolor", [1 1 1], ...
        "constraints", createConstraints("gridbag", [1, 6, 1, 1], [1, 0], "both", "center"), ...
        "border", createBorder("titled", createBorder("line", "lightGray", 1), _("Title"), "center", "top", createBorderFont("", 11, "normal"), "black"), ...
        "layout", "border");

    uicontrol(frame_style, ...
        "style", "edit", ...
        "backgroundcolor", [1 1 1], ...
        "string", "My Beautiful Plot", ...
        "callback", "update_title_string", ...
        "tag", "title");

    frame_style = uicontrol(frame_left, ...
        "style", "frame", ...
        "backgroundcolor", [1 1 1], ...
        "constraints", createConstraints("gridbag", [1, 7, 1, 1], [1, 1], "both", "center"));

    //Plot
    frame_right = uicontrol(demo_plot3d, ...
        "style", "frame", ...
        "layout", "border", ...
        "constraints", createConstraints("border", "center"));


    newaxes(frame_right);
    demo_plot3d.immediate_drawing = "off";
    plot3d();

    a = gca();
    a.tag                   = "plot";
    a.title.text            = "My Beautiful Plot";
    a.title.font_size       = 5;
    a.rotation_angles(1)    = 70;

    a.x_label.text          = "X";
    a.y_label.text          = "Y";
    a.z_label.text          = "Z";

    demo_plot3d.immediate_drawing     = "on";

    demo_plot3d.visible     = "on";
endfunction





function update_plot3d_angle()

    my_plot_axes = gca();
    my_new_angle = get(gcbo,"value");

    if( my_new_angle>0 & my_new_angle<360 ) then
        my_plot_axes.rotation_angles(2) = my_new_angle;
    end

endfunction

function update_colormap()

    my_figure    = gcf();
    my_plot_axes = gca();

    my_cur_color_map    = my_figure.color_map;
    my_cur_bg_color_id  = my_plot_axes.background;

    if my_cur_bg_color_id > 32 then
        my_cur_bg_color_r = my_cur_color_map(my_cur_bg_color_id,1);
        my_cur_bg_color_g = my_cur_color_map(my_cur_bg_color_id,2);
        my_cur_bg_color_b = my_cur_color_map(my_cur_bg_color_id,3);
    end

    if get(gcbo, "tag") == "jetcolormap" then
        my_figure.color_map = jetcolormap(128);
    elseif get(gcbo, "tag") == "hotcolormap" then
        my_figure.color_map = hotcolormap(128);
    elseif get(gcbo, "tag") == "graycolormap" then
        my_figure.color_map = graycolormap(128);
    end

    if my_cur_bg_color_id > 32 then

        color_id = color( ..
        my_cur_bg_color_r*255, ..
        my_cur_bg_color_g*255, ..
        my_cur_bg_color_b*255  ..
        );

        my_plot_axes.background = color_id;
    end

endfunction

function update_background_color()

    // Lancement du colorchooser
    [my_red, my_green, my_blue] = uigetcolor();

    if( (my_red<>[]) & (my_green<>[]) & (my_blue<>[]) ) then

        set(gcbo,"BackgroundColor",[ my_red/255 my_green/255 my_blue/255 ]);

        my_plot_axes            = gca();
        color_id                = color(my_red,my_green,my_blue);
        my_plot_axes.background = color_id;

    end

endfunction

function update_tics_visible()

    my_plot_axes = gca();

    if get(gcbo,"value") == 0 then
        my_plot_axes.axes_visible = ["off" "off" "off" ];
    else
        my_plot_axes.axes_visible = ["on" "on" "on" ];
    end

endfunction

function update_title_visible()

    my_plot_axes = gca();

    if get(gcbo,"value") == 0 then
        my_plot_axes.title.visible = "off";
    else
        my_plot_axes.title.visible = "on";
    end

endfunction

function update_labels_visible()

    my_plot_axes = gca();

    if get(gcbo,"value") == 0 then
        my_plot_axes.x_label.visible = "off";
        my_plot_axes.y_label.visible = "off";
        my_plot_axes.z_label.visible = "off";
    else
        my_plot_axes.x_label.visible = "on";
        my_plot_axes.y_label.visible = "on";
        my_plot_axes.z_label.visible = "on";
    end

endfunction

function update_edges_visible()

    my_plot_axes = gca();
    my_plot3d    = my_plot_axes.children($);

    if get(gcbo,"value") == 0 then
        my_plot3d.color_mode = -1;
    else
        my_plot3d.color_mode = +1;
    end

endfunction

function update_title_string

    my_plot_axes = gca();
    my_plot_axes.title.text = get(gcbo,"string");

endfunction
