---
title: Purgatory/TraceExporterJar
permalink: /Purgatory/TraceExporterJar/
---

Full name: **traceExporter / auto-nomos**

## Introduction

This text covers how to convert netstate dumps from sumo for use in ns2
with help of the tool traceExporter. TraceExporter is written in Java.
Hence, Java 1.5 Runtime Environment is required.

A compiled jar-file is included in the sumo release 0.9.5 as well as in
the actual SVN developer repository. However, generating a trace file
that covers all penetration rates in one single file is included in the
SVN-version only.

Since ns2 allows only positive x- and y-coordinates, the scenario is
shifted accordingly if negative coordinates are used in the Sumo
scenario.

As output you get three files: config, activity and mobility. All are
tcl source files. Thus, they can be included into the tcl file that
controls your ns2 simulation using the `source` command. The config file
is used to set some opt( )-variables describing the simulation scenario.
The times in which vehicles do their first and last movement are put
into the activity-file to start and stop the according agents. The
movements itself written into the mobility file. See below for exemplary
output files.

## Usage

The program is `traceExporter.jar` is located under tools/traceExporter.
So, you have to change to this directory and type in the following
command:

```
 java -jar traceExporter.jar ns2
      -n NET_FILE
      -t TRACE_FILE
      -a ACTIVITY_FILE
      -m MOBILITY_FILE
      -c CONFIG_FILE
      -p PENTRATION_LEVEL
      -s SEED_VALUE
      -b BEGIN_TIME  -e END_TIME
```

Whereby the parameters has to be filles as follows:

**`-n <NET_FILE>`**

Set <NET_FILE\> to your sumo input. Required, type:filename

**`-t <TRACE_FILE>`**

Set as <TRACE_FILE\> the tracefile you want to be converted. Required,
type:filename

**`-a <ACTIVITY_FILE>`**

In <ACTIVITY_FILE\> will be written, when vehicles will be activated and
deactivated in simulation. Required, type:filename

**`-m <MOBILITY_FILE>`**

In <MOBILITY_FILE\> you will find, when vehicles are moved and the
corresponding position. Required, type:filename

**`-c <CONFIG_FILE>`**

<CONFIG_FILE\> holds information about simulation settings like extend,
start/ stop time and number of vehicles in output. Required,
type:filename

**`-p <PENETRATION_LEVEL>`**

Pentration level means the ratio of selecting vehicles that will be
traced for output. Penetration level of 1 equals no filtering and 0
means no vehicles will be selected. Required, type:float in \[0, 1\]

\[SVN-version only\] If you omit this flag, a single trace file is
generated that includes all penetration rates.

**`-s <SEED_VALUE>`**

Defines seed value for random number generator. Random numbers are used
for selecting vehicles if penetration < 1. Same seed results in same
output, different seeds results in different output. Optional
(pregiven), type:integer, default:0

**`-b BEGIN_TIME -e END_TIME`**

The desired begin and end times must be given with parameters -b and -e.

## Example

After executing the following sumo commands to accomplish the Sumo
simulation:

```
sumo-netconvert -n=nodes.xml -e=edges.xml --output-file=net.xml --disable-normalize-node-positions
sumo-duarouter --flow-defs=flow.xml --net=net.xml --output-file=routes.xml
sumo -n net.xml -r routes.xml --netstate-dump netstate.xml
```

You will get:

- <NET_FILE\> = net.xml
- <TRACE_FILE\> = netstate.xml

Now you can use:

```
java -jar traceExporter.jar ns2 -n net.xml -t netstate.xml -a activity.tcl -m mobility.tcl -c config.tcl -p 1
```

And get:

- <CONFIG_FILE\> = config.tcl
- <ACTIVITY_FILE\> = activity.tcl
- <MOBILITY_FILE\> = mobility.tcl

### Examplary Config File

This file should be included first using the tcl `source` command. It
establishes a few variables that describes the simulation. Especially
the number of node is stored in opt(nn).

```
# set number of nodes
set opt(nn) 75
# set activity file
set opt(af) $opt(config-path)
append opt(af) /activity_0.05
# set mobility file
set opt(mf) $opt(config-path)
append opt(mf) /mobility_0.05
# set start/stop time
set opt(start) 0.0
set opt(stop) 960.0
# set floor size
set opt(x) 20505
set opt(y) 105
set opt(min-x) 9495
set opt(min-y) 95
```

If the -p flag is omitted, all penetration rates are availabe through
one set of files. The penetration rate for a certain ns2 simulation
needs to be put into the tcl variable `opt(penetration)` before
including the config file. The resulting number of nodes is then
generated by a bunch of lines as the following:

```
if { $opt(penetration) > 0.0 } { set opt(nn) 1 }
if { $opt(penetration) > 6.756756756756757E-4 } { set opt(nn) 2 }
if { $opt(penetration) > 0.0013513513513513514 } { set opt(nn) 3 }
if { $opt(penetration) > 0.002027027027027027 } { set opt(nn) 4 }
if { $opt(penetration) > 0.002702702702702703 } { set opt(nn) 5 }
...
if { $opt(penetration) > 0.9972972972972973 } { set opt(nn) 1477 }
if { $opt(penetration) > 0.9979729729729729 } { set opt(nn) 1478 }
if { $opt(penetration) > 0.9986486486486487 } { set opt(nn) 1479 }
if { $opt(penetration) > 0.9993243243243243 } { set opt(nn) 1480 }
```

### Examplary Mobility File

After setting up an adequate number of nodes (see opt(nn)) into a
`node_()` array with ascending indeces, the mobility file can be read.
It sets the nodes to their initial position ...

```
$node_(0) set X_ 10010.621
$node_(0) set Y_ 95.05
$node_(0) set Z_ 0.0
$node_(1) set X_ 14103.43
$node_(1) set Y_ 95.05
$node_(1) set Z_ 0.0
...
```

... and moves them to new positions on a per second base:

```
$ns_ at 0.0 "$node_(0) setdest 10016.319 95.05 5.69794"
$ns_ at 0.0 "$node_(1) setdest 14130.41 95.05 26.983"
$ns_ at 1.0 "$node_(0) setdest 10022.548 95.05 6.22927"
$ns_ at 1.0 "$node_(1) setdest 14157.391 95.05 26.9835"
$ns_ at 2.0 "$node_(0) setdest 10029.239 95.05 6.69121"
$ns_ at 2.0 "$node_(1) setdest 14184.391 95.05 26.9942"
...
```

The lines are a little bit unsorted throughout the file. Thereby the
conversion time is accelerated. It shouldn't influence ns2.

### Examplary Activity File

The activity file can be used to toggle agents on and off, just when
their according node enters or leave the scenario. To make use of this,
agents need to be put in an array called g(). It is assumed, that agents
indeces accord to their associated nodes.

```
$ns_ at 0.0 "$g(0) start"
$ns_ at 417.0 "$g(0) stop"
$ns_ at 0.0 "$g(1) start"
$ns_ at 238.0 "$g(1) stop"
...
```

-----

## Availability

Source: The sources can be found within the SUMO-distribution
(***<SUMO_DIST\>*/tools/traceExporter**)

Portable: yes (uses Java/Python)