--
--  countries.sql
--
--  $Id$
--
--  Creates a countries database
--
--  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)
--  project.
--
--  Copyright (C) 1998-2024 OpenLink Software
--
--  This project is free software; you can redistribute it and/or modify it
--  under the terms of the GNU General Public License as published by the
--  Free Software Foundation; only version 2 of the License, dated June 1991.
--
--  This program is distributed in the hope that it will be useful, but
--  WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
--  General Public License for more details.
--
--  You should have received a copy of the GNU General Public License along
--  with this program; if not, write to the Free Software Foundation, Inc.,
--  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
--
--

ECHO BOTH "Loading Countries Database\n";

USE Demo;


DROP TABLE demo.Flags;
DROP TABLE demo.Provinces;
DROP TABLE demo.Countries;

CREATE TABLE demo.Countries
	(Name VARCHAR NOT NULL,
	 Code VARCHAR not null unique,
	 SmallFlagDAVResourceName varchar,
	 LargeFlagDAVResourceName varchar,
	 SmallFlagDAVResourceURI varchar,
	 LargeFlagDAVResourceURI varchar,
	 Lat REAL,
	 Lng REAL,
	 PRIMARY KEY(Name));

CREATE TABLE demo.Flags
	(CountryCode VARCHAR(128) references Countries (Code) on update cascade on delete cascade,
	 LargeFlag LONG VARBINARY,
	 SmallFlag LONG VARBINARY,
	 PRIMARY KEY(CountryCode));

CREATE TABLE demo.Provinces
	(CountryCode VARCHAR NOT NULL references Countries (Code) on update cascade on delete cascade,
	 Province VARCHAR NOT NULL,
	 PRIMARY KEY(CountryCode, Province));

INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Afghanistan',33,65,'af','af-flag.gif','af-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Akrotiri',NULL,NULL,'ax','ax-flag.gif','ax-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Albania',41,20,'al','al-flag.gif','al-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Algeria',28,3,'ag','ag-flag.gif','ag-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('American Samoa',-14.33333301544189,-170,'aq','aq-flag.gif','aq-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Andorra',42.5,1.5,'an','an-flag.gif','an-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Angola',-12.5,18.5,'ao','ao-flag.gif','ao-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Anguilla',18.25,-63.16666793823242,'av','av-flag.gif','av-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Antarctica',-90,0,'ay',null,null);
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Antigua and Barbuda',17.04999923706055,-61.79999923706055,'ac','ac-flag.gif','ac-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Arctic Ocean',90,0,'xq',null,null);
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Argentina',-34,-64,'ar','ar-flag.gif','ar-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Armenia',40,45,'am','am-flag.gif','am-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Aruba',12.5,-69.96666717529297,'aa','aa-flag.gif','aa-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Ashmore and Cartier Islands',-12.23333358764648,123.0833358764648,'at','at-flag.gif','at-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Atlantic Ocean',0,-25,'zh',null,null);
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Australia',-27,133,'as','as-flag.gif','as-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Austria',47.33333206176758,13.33333301544189,'au','au-flag.gif','au-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Azerbaijan',40.5,47.5,'aj','aj-flag.gif','aj-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Bahamas, The',24.25,-76,'bf','bf-flag.gif','bf-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Bahrain',26,50.54999923706055,'ba','ba-flag.gif','ba-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Baker Island',0.2166666686534882,-176.5166625976562,'fq','fq-flag.gif','fq-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Bangladesh',24,90,'bg','bg-flag.gif','bg-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Barbados',13.16666698455811,-59.53333282470703,'bb','bb-flag.gif','bb-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Bassas da India',-21.5,39.83333206176758,'bs','bs-flag.gif','bs-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Belarus',53,28,'bo','bo-flag.gif','bo-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Belgium',50.83333206176758,4,'be','be-flag.gif','be-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Belize',NULL,NULL,'bh','bh-flag.gif','bh-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Benin',9.5,2.25,'bn','bn-flag.gif','bn-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Bermuda',32.33333206176758,-64.75,'bd','bd-flag.gif','bd-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Bhutan',27.5,90.5,'bt','bt-flag.gif','bt-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Bolivia',-17,-65,'bl','bl-flag.gif','bl-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Bosnia and Herzegovina',44,18,'bk','bk-flag.gif','bk-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Botswana',-22,24,'bc','bc-flag.gif','bc-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Bouvet Island',-54.43333435058594,3.400000095367432,'bv','bv-flag.gif','bv-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Brazil',-10,-55,'br','br-flag.gif','br-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('British Indian Ocean Territory',-6,71.5,'io','io-flag.gif','io-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('British Virgin Islands',18.5,-64.5,'vi','vi-flag.gif','vi-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Brunei',4.5,114.6666641235352,'bx','bx-flag.gif','bx-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Bulgaria',43,25,'bu','bu-flag.gif','bu-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Burkina Faso',13,-2,'uv','uv-flag.gif','uv-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Burma',22,98,'bm','bm-flag.gif','bm-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Burundi',-3.5,30,'by','by-flag.gif','by-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Cambodia',13,105,'cb','cb-flag.gif','cb-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Cameroon',6,12,'cm','cm-flag.gif','cm-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Canada',60,-95,'ca','ca-flag.gif','ca-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Cape Verde',16,-24,'cv','cv-flag.gif','cv-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Cayman Islands',19.5,-80.5,'cj','cj-flag.gif','cj-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Central African Republic',7,21,'ct','ct-flag.gif','ct-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Chad',15,19,'cd','cd-flag.gif','cd-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Chile',-30,-71,'ci','ci-flag.gif','ci-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('China',35,105,'ch','ch-flag.gif','ch-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Christmas Island',-10.5,105.6666641235352,'kt','kt-flag.gif','kt-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Clipperton Island',10.28333377838135,-109.216667175293,'ip','ip-flag.gif','ip-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Cocos (Keeling) Islands',-12.5,96.83333587646484,'ck','ck-flag.gif','ck-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Colombia',4,-72,'co','co-flag.gif','co-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Comoros',-12.16666698455811,44.25,'cn','cn-flag.gif','cn-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Congo, Democratic Republic of the',0,25,'cg','cg-flag.gif','cg-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Congo, Republic of the',-1,15,'cf','cf-flag.gif','cf-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Cook Islands',-21.23333358764648,-159.7666625976562,'cw','cw-flag.gif','cw-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Coral Sea Islands',-18,152,'cr','cr-flag.gif','cr-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Costa Rica',10,-84,'cs','cs-flag.gif','cs-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Cote d\47Ivoire',NULL,NULL,'iv','iv-flag.gif','iv-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Croatia',45.16666793823242,15.5,'hr','hr-flag.gif','hr-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Cuba',21.5,-80,'cu','cu-flag.gif','cu-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Cyprus',35,33,'cy','cy-flag.gif','cy-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Czech Republic',49.75,15.5,'ez','ez-flag.gif','ez-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Denmark',56,10,'da','da-flag.gif','da-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Dhekelia',NULL,NULL,'dx','dx-flag.gif','dx-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Djibouti',11.5,43,'dj','dj-flag.gif','dj-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Dominica',15.41666698455811,-61.33333206176758,'do','do-flag.gif','do-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Dominican Republic',19,-70.66666412353516,'dr','dr-flag.gif','dr-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('East Timor',NULL,NULL,'tt','tt-flag.gif','tt-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Ecuador',-2,-77.5,'ec','ec-flag.gif','ec-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Egypt',27,30,'eg','eg-flag.gif','eg-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('El Salvador',13.83333301544189,-88.91666412353516,'es','es-flag.gif','es-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Equatorial Guinea',2,10,'ek','ek-flag.gif','ek-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Eritrea',15,39,'er','er-flag.gif','er-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Estonia',59,26,'en','en-flag.gif','en-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Ethiopia',8,38,'et','et-flag.gif','et-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Europa Island',-22.33333396911621,40.36666488647461,'eu','eu-flag.gif','eu-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('European Union',NULL,NULL,'ee','ee-flag.gif','ee-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Falkland Islands (Islas Malvinas)',-51.75,-59,'fk','fk-flag.gif','fk-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Faroe Islands',62,-7,'fo','fo-flag.gif','fo-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Fiji',-18,175,'fj','fj-flag.gif','fj-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Finland',64,26,'fi','fi-flag.gif','fi-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('France',46,2,'fr','fr-flag.gif','fr-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('French Guiana',4,-53,'fg','fg-flag.gif','fg-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('French Polynesia',-15,-140,'fp','fp-flag.gif','fp-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('French Southern and Antarctic Lands',-43,67,'fs','fs-flag.gif','fs-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Gabon',-1,11.75,'gb','gb-flag.gif','gb-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Gambia, The',13.46666622161865,-16.5666675567627,'ga','ga-flag.gif','ga-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Gaza Strip',31.41666603088379,34.33333206176758,'gz','gz-flag.gif','gz-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Georgia',42,43.5,'gg','gg-flag.gif','gg-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Germany',51,9,'gm','gm-flag.gif','gm-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Ghana',8,-2,'gh','gh-flag.gif','gh-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Gibraltar',36.18333435058594,-5.366666793823242,'gi','gi-flag.gif','gi-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Glorioso Islands',-11.5,47.33333206176758,'go','go-flag.gif','go-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Greece',39,22,'gr','gr-flag.gif','gr-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Greenland',72,-40,'gl','gl-flag.gif','gl-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Grenada',12.11666679382324,-61.66666793823242,'gj','gj-flag.gif','gj-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Guadeloupe',16.25,-61.58333206176758,'gp','gp-flag.gif','gp-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Guam',NULL,NULL,'gq','gq-flag.gif','gq-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Guatemala',15.5,-90.25,'gt','gt-flag.gif','gt-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Guernsey',49.46666717529297,-2.583333253860474,'gk','gk-flag.gif','gk-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Guinea',11,-10,'gv','gv-flag.gif','gv-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Guinea-Bissau',12,-15,'pu','pu-flag.gif','pu-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Guyana',5,-59,'gy','gy-flag.gif','gy-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Haiti',19,-72.41666412353516,'ha','ha-flag.gif','ha-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Heard Island and McDonald Islands',-53.09999847412109,72.51667022705078,'hm','hm-flag.gif','hm-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Holy See (Vatican City)',41.90000152587891,12.44999980926514,'vt','vt-flag.gif','vt-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Honduras',15,-86.5,'ho','ho-flag.gif','ho-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Hong Kong',22.25,114.1666641235352,'hk','hk-flag.gif','hk-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Howland Island',0.800000011920929,-176.6333312988281,'hq','hq-flag.gif','hq-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Hungary',47,20,'hu','hu-flag.gif','hu-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Iceland',65,-18,'ic','ic-flag.gif','ic-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('India',20,77,'in','in-flag.gif','in-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Indian Ocean',-20,80,'xo','xo-flag.gif','xo-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Indonesia',-5,120,'id','id-flag.gif','id-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Iran',32,53,'ir','ir-flag.gif','ir-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Iraq',33,44,'iz','iz-flag.gif','iz-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Ireland',53,-8,'ei','ei-flag.gif','ei-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Israel',31.5,34.75,'is','is-flag.gif','is-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Italy',42.83333206176758,12.83333301544189,'it','it-flag.gif','it-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Jamaica',18.25,-77.5,'jm','jm-flag.gif','jm-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Jan Mayen',71,-8,'jn','jn-flag.gif','jn-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Japan',36,138,'ja','ja-flag.gif','ja-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Jarvis Island',-0.3666666746139526,-160.0500030517578,'dq','dq-flag.gif','dq-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Jersey',49.25,-2.166666746139526,'je','je-flag.gif','je-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Johnston Atoll',16.75,-169.5166625976562,'jq','jq-flag.gif','jq-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Jordan',31,36,'jo','jo-flag.gif','jo-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Juan de Nova Island',-17.04999923706055,42.75,'ju','ju-flag.gif','ju-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Kazakhstan',48,68,'kz','kz-flag.gif','kz-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Kenya',1,38,'ke','ke-flag.gif','ke-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Kingman Reef',6.400000095367432,-162.3999938964844,'kq','kq-flag.gif','kq-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Kiribati',1.416666626930237,173,'kr','kr-flag.gif','kr-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Korea, North',40,127,'kn','kn-flag.gif','kn-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Korea, South',37,127.5,'ks','ks-flag.gif','ks-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Kuwait',29.5,45.75,'ku','ku-flag.gif','ku-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Kyrgyzstan',41,75,'kg','kg-flag.gif','kg-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Laos',18,105,'la','la-flag.gif','la-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Latvia',57,25,'lg','lg-flag.gif','lg-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Lebanon',33.83333206176758,35.83333206176758,'le','le-flag.gif','le-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Lesotho',-29.5,28.5,'lt','lt-flag.gif','lt-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Liberia',6.5,-9.5,'li','li-flag.gif','li-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Libya',25,17,'ly','ly-flag.gif','ly-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Liechtenstein',47.16666793823242,9.533333778381348,'ls','ls-flag.gif','ls-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Lithuania',56,24,'lh','lh-flag.gif','lh-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Luxembourg',49.75,6.166666507720947,'lu','lu-flag.gif','lu-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Macau',22.16666603088379,113.5500030517578,'mc','mc-flag.gif','mc-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Macedonia',NULL,NULL,'mk','mk-flag.gif','mk-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Madagascar',-20,47,'ma','ma-flag.gif','ma-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Malawi',-13.5,34,'mi','mi-flag.gif','mi-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Malaysia',2.5,112.5,'my','my-flag.gif','my-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Maldives',3.25,73,'mv','mv-flag.gif','mv-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Mali',17,-4,'ml','ml-flag.gif','ml-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Malta',35.83333206176758,14.58333301544189,'mt','mt-flag.gif','mt-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Man, Isle of',54.25,-4.5,'im','im-flag.gif','im-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Marshall Islands',9,168,'rm','rm-flag.gif','rm-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Martinique',14.66666698455811,-61,'mb','mb-flag.gif','mb-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Mauritania',20,-12,'mr','mr-flag.gif','mr-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Mauritius',-20.28333282470703,57.54999923706055,'mp','mp-flag.gif','mp-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Mayotte',-12.83333301544189,45.16666793823242,'mf','mf-flag.gif','mf-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Mexico',23,-102,'mx','mx-flag.gif','mx-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Micronesia, Federated States of',6.916666507720947,158.25,'fm','fm-flag.gif','fm-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Midway Islands',28.21666717529297,-177.3666687011719,'mq','mq-flag.gif','mq-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Moldova',47,29,'md','md-flag.gif','md-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Monaco',43.73333358764648,7.400000095367432,'mn','mn-flag.gif','mn-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Mongolia',46,105,'mg','mg-flag.gif','mg-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Montserrat',16.75,-62.20000076293945,'mh','mh-flag.gif','mh-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Morocco',32,-5,'mo','mo-flag.gif','mo-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Mozambique',-18.25,35,'mz','mz-flag.gif','mz-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Namibia',-22,17,'wa','wa-flag.gif','wa-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Nauru',-0.5333333611488342,166.9166717529297,'nr','nr-flag.gif','nr-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Navassa Island',18.41666603088379,-75.03333282470703,'bq','bq-flag.gif','bq-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Nepal',28,84,'np','np-flag.gif','np-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Netherlands',52.5,5.75,'nl','nl-flag.gif','nl-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Netherlands Antilles',12.25,-68.75,'nt','nt-flag.gif','nt-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('New Caledonia',-21.5,165.5,'nc','nc-flag.gif','nc-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('New Zealand',-41,174,'nz','nz-flag.gif','nz-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Nicaragua',13,-85,'nu','nu-flag.gif','nu-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Niger',16,8,'ng','ng-flag.gif','ng-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Nigeria',10,8,'ni','ni-flag.gif','ni-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Niue',-19.03333282470703,-169.8666687011719,'ne','ne-flag.gif','ne-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Norfolk Island',-29.03333282470703,167.9499969482422,'nf','nf-flag.gif','nf-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Northern Mariana Islands',15.19999980926514,145.75,'cq','cq-flag.gif','cq-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Norway',62,10,'no','no-flag.gif','no-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Oman',21,57,'mu','mu-flag.gif','mu-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Other',NULL,NULL,NULL,null,null);
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Pacific Ocean',0,-160,'zn','zn-flag.gif','zn-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Pakistan',30,70,'pk','pk-flag.gif','pk-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Palau',7.5,134.5,'ps','ps-flag.gif','ps-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Palmyra Atoll',5.866666793823242,-162.1000061035156,'lq','lq-flag.gif','lq-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Panama',9,-80,'pm','pm-flag.gif','pm-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Papua New Guinea',-6,147,'pp','pp-flag.gif','pp-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Paracel Islands',16.5,112,'pf','pf-flag.gif','pf-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Paraguay',-23,-58,'pa','pa-flag.gif','pa-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Peru',-10,-76,'pe','pe-flag.gif','pe-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Philippines',13,122,'rp','rp-flag.gif','rp-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Pitcairn Islands',-25.0666675567627,-130.1000061035156,'pc','pc-flag.gif','pc-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Poland',52,20,'pl','pl-flag.gif','pl-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Portugal',39.5,-8,'po','po-flag.gif','po-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Puerto Rico',18.25,-66.5,'rq','rq-flag.gif','rq-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Qatar',25.5,51.25,'qa','qa-flag.gif','qa-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Reunion',-21.10000038146973,55.59999847412109,'re','re-flag.gif','re-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Romania',46,25,'ro','ro-flag.gif','ro-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Russia',60,100,'rs','rs-flag.gif','rs-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Rwanda',-2,30,'rw','rw-flag.gif','rw-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Saint Helena',-15.93333339691162,-5.699999809265137,'sh','sh-flag.gif','sh-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Saint Kitts and Nevis',17.33333396911621,-62.75,'sc','sc-flag.gif','sc-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Saint Lucia',13.88333320617676,-61.13333511352539,'st','st-flag.gif','st-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Saint Pierre and Miquelon',46.83333206176758,-56.33333206176758,'sb','sb-flag.gif','sb-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Saint Vincent and the Grenadines',13.25,-61.20000076293945,'vc','vc-flag.gif','vc-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Samoa',-13.58333301544189,-172.3333282470703,'ws','ws-flag.gif','ws-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('San Marino',43.76666641235352,12.41666698455811,'sm','sm-flag.gif','sm-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Sao Tome and Principe',1,7,'tp','tp-flag.gif','tp-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Saudi Arabia',25,45,'sa','sa-flag.gif','sa-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Senegal',14,-14,'sg','sg-flag.gif','sg-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Serbia and Montenegro',NULL,NULL,'yi','yi-flag.gif','yi-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Seychelles',-4.583333492279053,55.66666793823242,'se','se-flag.gif','se-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Sierra Leone',8.5,-11.5,'sl','sl-flag.gif','sl-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Singapore',1.366666674613953,103.8000030517578,'sn','sn-flag.gif','sn-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Slovakia',48.66666793823242,19.5,'lo','lo-flag.gif','lo-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Slovenia',46,15,'si','si-flag.gif','si-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Solomon Islands',-8,159,'bp','bp-flag.gif','bp-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Somalia',10,49,'so','so-flag.gif','so-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('South Africa',-29,24,'sf','sf-flag.gif','sf-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('South Georgia and the South Sandwich Islands',-54.5,-37,'sx','sx-flag.gif','sx-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Southern Ocean',-65,0,'oo','oo-flag.gif','oo-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Spain',40,-4,'sp','sp-flag.gif','sp-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Spratly Islands',8.633333206176758,111.9166641235352,'pg','pg-flag.gif','pg-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Sri Lanka',7,81,'ce','ce-flag.gif','ce-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Sudan',15,30,'su','su-flag.gif','su-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Suriname',4,-56,'ns','ns-flag.gif','ns-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Svalbard',78,20,'sv','sv-flag.gif','sv-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Swaziland',-26.5,31.5,'wz','wz-flag.gif','wz-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Sweden',62,15,'sw','sw-flag.gif','sw-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Switzerland',47,8,'sz','sz-flag.gif','sz-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Syria',35,38,'sy','sy-flag.gif','sy-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Taiwan',23.5,121,'tw','tw-flag.gif','tw-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Tajikistan',39,71,'ti','ti-flag.gif','ti-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Tanzania',-6,35,'tz','tz-flag.gif','tz-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Thailand',15,100,'th','th-flag.gif','th-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Togo',8,1.166666626930237,'to','to-flag.gif','to-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Tokelau',-9,-172,'tl','tl-flag.gif','tl-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Tonga',-20,-175,'tn','tn-flag.gif','tn-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Trinidad and Tobago',11,-61,'td','td-flag.gif','td-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Tromelin Island',-15.86666679382324,54.41666793823242,'te','te-flag.gif','te-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Tunisia',34,9,'ts','ts-flag.gif','ts-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Turkey',39,35,'tu','tu-flag.gif','tu-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Turkmenistan',40,60,'tx','tx-flag.gif','tx-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Turks and Caicos Islands',21.75,-71.58333587646484,'tk','tk-flag.gif','tk-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Tuvalu',-8,178,'tv','tv-flag.gif','tv-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Uganda',1,32,'ug','ug-flag.gif','ug-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Ukraine',49,32,'up','up-flag.gif','up-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('United Arab Emirates',24,54,'ae','ae-flag.gif','ae-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('United Kingdom',54,-2,'uk','uk-flag.gif','uk-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('United States',38,-97,'us','us-flag.gif','us-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Uruguay',-33,-56,'uy','uy-flag.gif','uy-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Uzbekistan',41,64,'uz','uz-flag.gif','uz-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Vanuatu',-16,167,'nh','nh-flag.gif','nh-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Venezuela',8,-66,'ve','ve-flag.gif','ve-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Vietnam',16,106,'vm','vm-flag.gif','vm-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Virgin Islands',18.33333396911621,-64.83333587646484,'vq','vq-flag.gif','vq-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Wake Island',19.28333282470703,166.6000061035156,'wq','wq-flag.gif','wq-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Wallis and Futuna',-13.30000019073486,-176.1999969482422,'wf','wf-flag.gif','wf-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('West Bank',32,35.25,'we','we-flag.gif','we-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Western Sahara',24.5,-13,'wi','wi-flag.gif','wi-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Yemen',15,48,'ym','ym-flag.gif','ym-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Zambia',-15,30,'za','za-flag.gif','za-lgflag.gif');
INSERT INTO Demo.demo.Countries(Name,LAT,LNG,Code,SmallFlagDAVResourceName,LargeFlagDAVResourceName) VALUES('Zimbabwe',-20,30,'zi','zi-flag.gif','zi-lgflag.gif');

select count(*) from Countries;
ECHO BOTH $IF $EQU $LAST[1] 270 "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": " $LAST[1] " Countries loaded\n";

create procedure fill_flags_and_country_code ()
{
  declare rc int;
  declare pwd any;
  pwd := (select pwd_magic_calc (U_NAME, U_PASSWORD, 1) from DB.DBA.SYS_USERS where U_NAME = 'dav');
  DB.DBA.DAV_COL_CREATE ('/DAV/sample_data/', '110100100', http_dav_uid(), http_dav_uid() + 1, 'dav', pwd);
  DB.DBA.DAV_COL_CREATE ('/DAV/sample_data/images/', '110100100', http_dav_uid(), http_dav_uid() + 1, 'dav', pwd);
  DB.DBA.DAV_COL_CREATE ('/DAV/sample_data/images/flags/', '110100100', http_dav_uid(), http_dav_uid() + 1, 'dav', pwd);
  for select SmallFlagDAVResourceName, LargeFlagDAVResourceName, Code from Demo..Countries do
    {
      if (SmallFlagDAVResourceName is not null and LargeFlagDAVResourceName is not null and isstring (file_stat ('flags/'||LargeFlagDAVResourceName)))
	{
	  DB.DBA.DAV_RES_UPLOAD ('/DAV/sample_data/images/flags/'||LargeFlagDAVResourceName, file_to_string ('flags/'||LargeFlagDAVResourceName), '', '110100100NN', http_dav_uid(), http_dav_uid() + 1, 'dav', pwd);
	  DB.DBA.DAV_RES_UPLOAD ('/DAV/sample_data/images/flags/'||SmallFlagDAVResourceName, file_to_string ('flags/'||SmallFlagDAVResourceName), '', '110100100NN', http_dav_uid(), http_dav_uid() + 1, 'dav', pwd);
	  insert into Demo.demo.Flags (CountryCode, LargeFlag, SmallFlag)
	      values (Code, file_to_string ('flags/'||LargeFlagDAVResourceName), file_to_string ('flags/'||SmallFlagDAVResourceName));
	}
    }
  update Demo..Countries set SmallFlagDAVResourceURI = '/DAV/sample_data/images/flags/'||SmallFlagDAVResourceName,
	 LargeFlagDAVResourceURI = '/DAV/sample_data/images/flags/' || LargeFlagDAVResourceName
	     where SmallFlagDAVResourceName is not null and LargeFlagDAVResourceName is not null;
  update Demo.demo.Suppliers set CountryCode = (select Code from Demo.demo.Countries where Name = Country);
  update Demo.demo.Customers set CountryCode = (select Code from Demo.demo.Countries where Name = Country);
  update Demo.demo.Employees set CountryCode = (select Code from Demo.demo.Countries where Name = Country);
  update Demo.demo.Orders set ShipCountryCode = (select Code from Demo.demo.Countries where Name = ShipCountry);
};

fill_flags_and_country_code ();

drop procedure fill_flags_and_country_code;

select count(*) from Flags;
ECHO BOTH $IF $EQU $LAST[1] 260 "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": " $LAST[1] " Flags loaded\n";

select count(*) from WS.WS.SYS_DAV_RES where RES_FULL_PATH like '/DAV/sample_data/images/flags/%';
ECHO BOTH $IF $EQU $LAST[1] 520 "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": " $LAST[1] " Flags images loaded into the WebDAV\n";

INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Barbuda','ac');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Redonda','ac');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint George','ac');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint John','ac');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Mary','ac');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Paul','ac');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Peter','ac');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Philip','ac');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Abu Zaby (Abu Dhabi)','ae');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ajman','ae');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Fujayrah','ae');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ash Shariqah (Sharjah)','ae');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dubayy (Dubai)','ae');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ra s al Khaymah','ae');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Umm al Qaywayn','ae');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Badakhshan','af');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Badghis','af');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Baghlan','af');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Balkh','af');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bamian','af');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Farah','af');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Faryab','af');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ghazni','af');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ghowr','af');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Helmand','af');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Herat','af');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jowzjan','af');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kabol','af');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kandahar','af');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kapisa','af');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Konar','af');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kondoz','af');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Laghman','af');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lowgar','af');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nangarhar','af');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nimruz','af');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Oruzgan','af');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Paktia','af');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Paktika','af');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Parvan','af');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Samangan','af');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sar-e Pol','af');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Takhar','af');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vardak','af');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zabol','af');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Adrar','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ain Defla','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ain Temouchent','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Alger','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Annaba','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Batna','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bechar','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bejaia','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Biskra','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Blida','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bordj Bou Arreridj','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bouira','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Boumerdes','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chlef','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Constantine','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Djelfa','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('El Bayadh','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('El Oued','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('El Tarf','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ghardaia','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Guelma','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Illizi','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jijel','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Khenchela','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Laghouat','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('M Sila','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mascara','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Medea','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mila','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mostaganem','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Naama','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Oran','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ouargla','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Oum el Bouaghi','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Relizane','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saida','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Setif','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sidi Bel Abbes','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Skikda','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Souk Ahras','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tamanghasset','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tebessa','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tiaret','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tindouf','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tipaza','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tissemsilt','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tizi Ouzou','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tlemcen','ag');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Abseron Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Agcabadi Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Agdam Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Agdas Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Agstafa Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Agsu Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ali Bayramli Sahari','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Astara Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Baki Sahari','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Balakan Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Barda Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Beylaqan Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bilasuvar Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cabrayil Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Calilabad Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Daskasan Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Davaci Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Fuzuli Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gadabay Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ganca Sahari','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Goranboy Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Goycay Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Haciqabul Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Imisli Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ismayilli Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kalbacar Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kurdamir Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lacin Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lankaran Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lankaran Sahari','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lerik Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Masalli Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mingacevir Sahari','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Naftalan Sahari','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Neftcala Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Oguz Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Qabala Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Qax Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Qazax Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Qobustan Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Quba Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Qubadli Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Qusar Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saatli Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sabirabad Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saki Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saki Sahari','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Salyan Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Samaxi Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Samkir Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Samux Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Siyazan Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sumqayit Sahari','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Susa Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Susa Sahari','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tartar Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tovuz Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ucar Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Xacmaz Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Xankandi Sahari','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Xanlar Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Xizi Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Xocali Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Xocavand Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yardimli Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yevlax Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yevlax Sahari','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zangilan Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zaqatala Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zardab Rayonu','aj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Berat','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bulqize','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Delvine','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Devoll (Bilisht)','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Diber (Peshkopi)','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Durres','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Elbasan','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Fier','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gjirokaster','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gramsh','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Has (Krume)','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kavaje','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kolonje (Erseke)','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Korce','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kruje','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kucove','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kukes','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kurbin','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lezhe','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Librazhd','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lushnje','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Malesi e Madhe (Koplik)','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mallakaster (Ballsh)','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mat (Burrel)','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mirdite (Rreshen)','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Peqin','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Permet','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pogradec','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Puke','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sarande','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Shkoder','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Skrapar (Corovode)','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tepelene','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tirane (Tirana)','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tirane* (Tirana)','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tropoje (Bajram Curri)','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vlore','al');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aragatsotn','am');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ararat','am');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Armavir','am');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Geghark unik','am');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kotayk','am');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lorri','am');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Shirak','am');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Syunik','am');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tavush','am');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vayots  Dzor','am');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yerevan','am');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Andorra la Vella','an');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Canillo','an');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Encamp','an');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Escaldes-Engordany','an');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('La Massana','an');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ordino','an');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sant Julia de Loria','an');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bengo','ao');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Benguela','ao');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bie','ao');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cabinda','ao');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cuando Cubango','ao');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cuanza Norte','ao');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cuanza Sul','ao');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cunene','ao');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Huambo','ao');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Huila','ao');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Luanda','ao');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lunda Norte','ao');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lunda Sul','ao');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Malanje','ao');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Moxico','ao');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Namibe','ao');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Uige','ao');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zaire','ao');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Eastern','aq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Manu a','aq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rose Island','aq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Swains Island','aq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Western','aq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Antartica e Islas del Atlantico Sur','ar');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Buenos Aires','ar');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Buenos Aires Capital Federal','ar');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Catamarca','ar');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chaco','ar');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chubut','ar');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cordoba','ar');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Corrientes','ar');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Entre Rios','ar');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Formosa','ar');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jujuy','ar');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('La Pampa','ar');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('La Rioja','ar');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mendoza','ar');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Misiones','ar');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Neuquen','ar');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rio Negro','ar');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Salta','ar');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('San Juan','ar');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('San Luis','ar');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Santa Cruz','ar');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Santa Fe','ar');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Santiago del Estero','ar');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tierra del Fuego,','ar');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tucuman ,','ar');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Australian Capital Territory','as');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('New South Wales','as');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Northern Territory','as');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Queensland','as');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('South Australia','as');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tasmania','as');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Victoria','as');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Western Australia','as');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Burgenland','au');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kaernten','au');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Niederoesterreich','au');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Oberoesterreich','au');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Salzburg','au');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Steiermark','au');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tirol','au');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vorarlberg','au');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Wien','au');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Hadd','ba');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Manamah','ba');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Mintaqah al Gharbiyah','ba');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Mintaqah al Wusta','ba');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Mintaqah ash Shamaliyah','ba');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Muharraq','ba');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ar Rifa  wa al Mintaqah al Janubiyah','ba');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jidd Hafs','ba');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Juzur Hawar','ba');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Madinat  Isa','ba');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Madinat Hamad','ba');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sitrah','ba');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Christ Church','bb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Andrew','bb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint George','bb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint James','bb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint John','bb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Joseph','bb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Lucy','bb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Michael','bb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Peter','bb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Philip','bb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Thomas','bb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Central','bc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chobe','bc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Francistown','bc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gaborone','bc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ghanzi','bc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kgalagadi','bc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kgatleng','bc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kweneng','bc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lobatse','bc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ngamiland','bc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('North-East','bc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Selebi-Pikwe','bc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('South-East','bc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Southern','bc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Devonshire','bd');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hamilton','bd');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Paget','bd');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pembroke','bd');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint George','bd');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Georges','bd');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sandys','bd');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Smiths','bd');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Southampton','bd');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Warwick','bd');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Antwerpen','be');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Brabant Wallon','be');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Flemish- provincien','be');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hainaut','be');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Liege','be');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Limburg','be');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Luxembourg','be');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Namur','be');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Oost-Vlaanderen','be');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vlaams Brabant','be');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('West-Vlaanderen','be');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Acklins and Crooked Islands','bf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bimini','bf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cat Island','bf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Exuma','bf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Freeport','bf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Fresh Creek','bf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Governor s Harbour','bf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Green Turtle Cay','bf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Harbour Island','bf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('High Rock','bf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Inagua','bf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kemps Bay','bf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Long Island','bf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Marsh Harbour','bf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mayaguana','bf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('New Providence','bf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nicholls Town and Berry Islands','bf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ragged Island','bf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rock Sound','bf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('San Salvador and Rum Cay','bf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sandy Point','bf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Barisal','bg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chittagong','bg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dhaka','bg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Khulna','bg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rajshahi','bg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Beni','bl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chuquisaca','bl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cochabamba','bl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('La Paz','bl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Oruro','bl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pando','bl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Potosi','bl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Santa Cruz','bl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tarija','bl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ayeyarwady','bm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bago','bm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chin State','bm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kachin State','bm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kayah State','bm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kayin State','bm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Magway','bm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mandalay','bm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mon State','bm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rakhine State','bm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sagaing','bm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Shan State','bm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tanintharyi','bm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yangon','bm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Atakora','bn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Atlantique','bn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Borgou','bn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Collines','bn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Couffo','bn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Donga','bn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Littoral','bn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mono','bn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Oueme','bn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zou','bn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Brestskaya (Brest)','bo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Homyel skaya (Homyel )','bo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Horad Minsk','bo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hrodzyenskaya (Hrodna)','bo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mahilyowskaya (Mahilyow)','bo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Minskaya','bo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vitsyebskaya (Vitsyebsk)','bo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Central','bp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Guadalcanal','bp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Honiara','bp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Isabel','bp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Makira','bp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Malaita','bp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Temotu','bp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Western','bp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Acre','br');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Alagoas','br');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Amapa','br');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Amazonas','br');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bahia','br');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ceara','br');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Distrito Federal','br');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Espirito Santo','br');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Goias','br');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Maranhao','br');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mato Grosso','br');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mato Grosso do Sul','br');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Minas Gerais','br');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Para','br');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Paraiba','br');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Parana','br');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pernambuco','br');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Piaui','br');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rio Grande do Norte','br');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rio Grande do Sul','br');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rio de Janeiro','br');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rondonia','br');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Roraima','br');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Santa Catarina','br');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sao Paulo','br');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sergipe','br');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tocantins','br');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bumthang','bt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chhukha','bt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chirang','bt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Daga','bt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Geylegphug','bt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ha','bt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lhuntshi','bt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mongar','bt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Paro','bt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pemagatsel','bt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Punakha','bt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Samchi','bt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Samdrup Jongkhar','bt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Shemgang','bt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tashigang','bt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Thimphu','bt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tongsa','bt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Wangdi Phodrang','bt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Blagoevgrad','bu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Burgas','bu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dobrich','bu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gabrovo','bu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Khaskovo','bu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kurdzhali','bu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kyustendil','bu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lovech','bu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Montana','bu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pazardzhik','bu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pernik','bu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pleven','bu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Plovdiv','bu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Razgrad','bu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ruse','bu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Shumen','bu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Silistra','bu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sliven','bu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Smolyan','bu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sofiya','bu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sofiya-Grad','bu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Stara Zagora','bu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Turgovishte','bu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Varna','bu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Veliko Turnovo','bu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vidin','bu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vratsa','bu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yambol','bu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Belait','bx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Brunei and Muara','bx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Temburong','bx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tutong','bx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bubanza','by');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bujumbura','by');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bururi','by');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cankuzo','by');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cibitoke','by');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gitega','by');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Karuzi','by');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kayanza','by');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kirundo','by');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Makamba','by');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Muramvya','by');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Muyinga','by');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mwaro','by');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ngozi','by');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rutana','by');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ruyigi','by');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Alberta','ca');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('British Columbia','ca');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Manitoba','ca');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('New Brunswick','ca');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Newfoundland','ca');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Northwest Territories','ca');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nova Scotia','ca');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nunavut','ca');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ontario','ca');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Prince Edward Island','ca');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Quebec','ca');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saskatchewan','ca');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yukon Territory','ca');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Banteay Mean Cheay','cb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Batdambang','cb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kampong Cham','cb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kampong Chhnang','cb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kampong Spoe','cb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kampong Thum','cb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kampot','cb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kandal','cb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kaoh Kong','cb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Keb','cb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kracheh','cb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mondol Kiri','cb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Otdar Mean Cheay','cb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pailin','cb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Phnum Penh','cb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pouthisat','cb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Preah Seihanu* (Sihanoukville)','cb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Preah Vihear','cb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Prey Veng','cb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rotanah Kiri','cb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Siem Reab','cb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Stoeng Treng','cb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Svay Rieng','cb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Takev','cb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Batha','cd');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Biltine','cd');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Borkou-Ennedi-Tibesti','cd');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chari-Baguirmi','cd');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Guera','cd');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kanem','cd');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lac','cd');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Logone Occidental','cd');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Logone Oriental','cd');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mayo-Kebbi','cd');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Moyen-Chari','cd');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ouaddai','cd');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Salamat','cd');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tandjile','cd');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Central','ce');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('North Central','ce');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('North Eastern','ce');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('North Western','ce');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sabaragamuwa','ce');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Southern','ce');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Uva','ce');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Western','ce');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bouenza','cf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Brazzaville','cf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cuvette','cf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kouilou','cf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lekoumou','cf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Likouala','cf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Niari','cf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Plateaux','cf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pool','cf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sangha','cf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bandundu','cg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bas-Congo','cg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Equateur','cg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kasai-Occidental','cg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kasai-Oriental','cg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Katanga','cg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kinshasa','cg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Maniema','cg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nord-Kivu','cg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Orientale','cg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sud-Kivu','cg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Anhui','ch');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Fujian','ch');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gansu','ch');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Guangdong','ch');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Guangxi','ch');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Guizhou','ch');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hainan','ch');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hebei','ch');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Heilongjiang','ch');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Henan','ch');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hubei','ch');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hunan','ch');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jiangsu','ch');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jiangxi','ch');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jilin','ch');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Liaoning','ch');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nei Mongol','ch');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ningxia','ch');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Qinghai','ch');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Shaanxi','ch');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Shandong','ch');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Shanxi','ch');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sichuan','ch');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Xinjiang','ch');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Xizang* (Tibet)','ch');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yunnan','ch');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zhejiang','ch');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aisen del General Carlos Ibanez del Campo','ci');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Antofagasta','ci');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Araucania','ci');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Atacama','ci');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bio-Bio','ci');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Coquimbo','ci');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Libertador General Bernardo O Higgins','ci');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Los Lagos','ci');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Magallanes y de la Antartica Chilena','ci');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Maule','ci');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Region Metropolitana (Santiago)','ci');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tarapaca','ci');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Valparaiso','ci');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Creek','cj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Eastern','cj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Midland','cj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('South Town','cj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Spot Bay','cj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Stake Bay','cj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('West End','cj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Western','cj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Adamaoua','cm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Centre','cm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Est','cm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Extreme-Nord','cm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Littoral','cm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nord','cm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nord-Ouest','cm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ouest','cm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sud','cm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sud-Ouest','cm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Anjouan (Nzwani)','cn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Fomboni','cn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Grande Comore (Njazidja)','cn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Moroni','cn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Amazonas','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Antioquia','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Arauca','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Atlantico','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bolivar','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Boyaca','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Caldas','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Caqueta','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Casanare','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cauca','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cesar','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Choco','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cordoba','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cundinamarca','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Distrito Capital de Santa Fe de Bogota','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Guainia','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Guaviare','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Huila','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('La Guajira','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Magdalena','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Meta','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Narino','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Norte de Santander','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Putumayo','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Quindio','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Risaralda','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('San Andres y Providencia','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Santander','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sucre','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tolima','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Valle del Cauca','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vaupes','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vichada','co');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Northern Islands','cq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rota','cq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saipan','cq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tinian','cq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Alajuela','cs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cartago','cs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Guanacaste','cs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Heredia','cs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Limon','cs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Puntarenas','cs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('San Jose','cs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bamingui-Bangoran','ct');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Basse-Kotto','ct');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gribingui','ct');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Haut-Mbomou','ct');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Haute-Kotto','ct');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Haute-Sangha','ct');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kemo-Gribingui','ct');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lobaye','ct');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mbomou','ct');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nana-Mambere','ct');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ombella-Mpoko','ct');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ouaka','ct');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ouham','ct');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ouham-Pende','ct');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sangha','ct');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vakaga','ct');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Camaguey','cu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ciego de Avila','cu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cienfuegos','cu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ciudad de La Habana','cu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Granma','cu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Guantanamo','cu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Holguin','cu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Isla de la Juventud','cu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('La Habana','cu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Las Tunas','cu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Matanzas','cu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pinar del Rio','cu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sancti Spiritus','cu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Santiago de Cuba','cu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Villa Clara','cu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Boa Vista','cv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Brava','cv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Fogo','cv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Maio','cv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mosteiros','cv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Paul','cv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Porto Novo','cv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Praia','cv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ribeira Grande','cv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sal','cv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Santa Catarina','cv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Santa Cruz','cv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sao Domingos','cv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sao Filipe','cv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sao Nicolau','cv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sao Vicente','cv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tarrafal','cv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tarrafal)','cv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Famagusta','cy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kyrenia','cy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Larnaca','cy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Limassol','cy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nicosia','cy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Paphos','cy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Arhus','da');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bornholm','da');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Fredericksberg','da');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Frederiksborg','da');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Fyn','da');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kobenhavn','da');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kobenhavns','da');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nordjylland','da');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ribe','da');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ringkobing','da');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Roskilde','da');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sonderjylland','da');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Storstrom','da');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vejle','da');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vestsjalland','da');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Viborg','da');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ali Sabih','dj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dikhil','dj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Djibouti','dj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Obock','dj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tadjoura','dj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Andrew','do');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint David','do');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint George','do');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint John','do');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Joseph','do');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Luke','do');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Mark','do');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Patrick','do');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Paul','do');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Peter','do');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Azua','dr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Baoruco','dr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Barahona','dr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dajabon','dr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Distrito Nacional','dr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Duarte','dr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('El Seibo','dr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Elias Pina','dr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Espaillat','dr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hato Mayor','dr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Independencia','dr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('La Altagracia','dr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('La Romana','dr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('La Vega','dr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Maria Trinidad Sanchez','dr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Monsenor Nouel','dr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Monte Cristi','dr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Monte Plata','dr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pedernales','dr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Peravia','dr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Puerto Plata','dr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Salcedo','dr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Samana','dr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('San Cristobal','dr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('San Juan','dr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('San Pedro de Macoris','dr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sanchez Ramirez','dr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Santiago','dr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Santiago Rodriguez','dr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Valverde','dr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Azuay','ec');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bolivar','ec');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Canar','ec');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Carchi','ec');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chimborazo','ec');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cotopaxi','ec');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('El Oro','ec');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Esmeraldas','ec');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Galapagos','ec');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Guayas','ec');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Imbabura','ec');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Loja','ec');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Los Rios','ec');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Manabi','ec');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Morona-Santiago','ec');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Napo','ec');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Orellana','ec');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pastaza','ec');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pichincha','ec');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sucumbios','ec');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tungurahua','ec');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zamora-Chinchipe','ec');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ad Daqahliyah','eg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Bahr al Ahmar','eg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Buhayrah','eg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Fayyum','eg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Gharbiyah','eg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Iskandariyah','eg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Isma iliyah','eg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Jizah','eg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Minufiyah','eg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Minya','eg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Qahirah','eg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Qalyubiyah','eg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Wadi al Jadid','eg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('As Suways','eg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ash Sharqiyah','eg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aswan','eg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Asyut','eg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bani Suwayf','eg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bur Sa id','eg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dumyat','eg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Janub Sina','eg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kafr ash Shaykh','eg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Matruh','eg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Qina','eg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Shamal Sina','eg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Suhaj','eg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Carlow','ei');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cavan','ei');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Clare','ei');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cork','ei');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Donegal','ei');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dublin','ei');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Galway','ei');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kerry','ei');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kildare','ei');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kilkenny','ei');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Laois','ei');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Leitrim','ei');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Limerick','ei');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Longford','ei');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Louth','ei');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mayo','ei');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Meath','ei');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Monaghan','ei');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Offaly','ei');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Roscommon','ei');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sligo','ei');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tipperary','ei');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Waterford','ei');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Westmeath','ei');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Wexford','ei');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Wicklow','ei');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Annobon','ek');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bioko Norte','ek');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bioko Sur','ek');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Centro Sur','ek');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kie-Ntem','ek');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Litoral','ek');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Wele-Nzas','ek');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Akale Guzay','er');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Anseba','er');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Barka','er');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Debub','er');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Debubawi Keyih Bahri','er');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Denkel','er');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gash-Barka','er');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hamasen','er');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Maakel','er');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Northern Red Sea','er');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sahil','er');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Semhar','er');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Senhit','er');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Seraye','er');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Southern','er');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ahuachapan','es');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cabanas','es');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chalatenango','es');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cuscatlan','es');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('La Libertad','es');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('La Paz','es');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('La Union','es');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Morazan','es');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('San Miguel','es');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('San Salvador','es');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('San Vicente','es');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Santa Ana','es');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sonsonate','es');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Usulutan','es');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Afar','et');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Amara','et');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Binshangul Gumuz','et');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dire Dawa','et');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gambela Hizboch','et');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hareri Hizb','et');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nationalities','et');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Oromiya','et');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sumale','et');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tigray','et');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('YeDebub Biheroch Bihereseboch na Hizboch (Southern Nations','et');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Brnensky','ez');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Budejovicky','ez');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jihlavsky','ez');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Karlovarsky','ez');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kralovehradecky','ez');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Liberecky','ez');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Olomoucky','ez');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ostravsky','ez');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pardubicky','ez');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Plzensky','ez');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Praha','ez');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Stredocesky','ez');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ustecky','ez');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zlinsky','ez');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aland','fi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Etela-Suomen Laani','fi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ita-Suomen Laani','fi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lansi-Suomen Laani','fi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lappi','fi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Oulun Laani','fi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Central','fj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Eastern','fj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Northern','fj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rotuma','fj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Western','fj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chuuk (Truk)','fm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kosrae','fm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pohnpei','fm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yap','fm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Archipel des Tuamotu','fp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Archipel des Tubuai','fp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Iles du Vent','fp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Alsace','fr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aquitaine','fr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Auvergne','fr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Basse-Normandie','fr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bourgogne','fr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bretagne','fr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Centre','fr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Champagne-Ardenne','fr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Corse','fr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Franche-Comte','fr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Guadeloupe','fr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Haute-Normandie','fr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ile-de-France','fr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Languedoc-Roussillon','fr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Limousin','fr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lorraine','fr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Martinique','fr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Midi-Pyrenees','fr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nord-Pas-de-Calais','fr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pays de la Loire','fr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Picardie','fr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Poitou-Charentes','fr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Provence-Alpes-Cote d Azur','fr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Reunion) and the overseas territorial collectivities (Mayotte','fr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rhone-Alpes','fr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Pierre and Miquelon)','fr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Iles Kerguelen','fs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Banjul','ga');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Central River','ga');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lower River','ga');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('North Bank','ga');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Upper River','ga');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Western','ga');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Estuaire','gb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Haut-Ogooue','gb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Moyen-Ogooue','gb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ngounie','gb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nyanga','gb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ogooue-Ivindo','gb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ogooue-Lolo','gb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ogooue-Maritime','gb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Woleu-Ntem','gb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Abashis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Adigenis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Akhalgoris','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Akhalk alak is','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Akhalts ikhis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Akhmetis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ambrolauris','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aspindzis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Baghdat is','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bolnisis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Borjomis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ch khorotsqus','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ch okhatauris','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chiat ura','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dedop listsqaros','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dmanisis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dushet is','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gardabanis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gori','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Goris','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gurjaanis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Javis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('K arelis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('K ut aisi','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kaspis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kharagaulis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Khashuris','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Khobis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Khonis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lagodekhis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lanch khut is','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lentekhis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Marneulis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Martvilis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mestiis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mts khet is','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ninotsmindis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Onis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ozurget is','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('P ot i','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Qazbegis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Qvarlis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rust avi','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sach kheris','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sagarejos','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Samtrediis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Senakis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sighnaghis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('T bilisi','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('T elavis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('T erjolis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('T et ritsqaros','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('T ianet is','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tqibuli','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ts ageris','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tsalenjikhis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tsalkis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tsqaltubo','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vanis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zestap onis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zugdidi','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zugdidis','gg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ashanti','gh');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Brong-Ahafo','gh');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Central','gh');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Eastern','gh');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Greater Accra','gh');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Northern','gh');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Upper East','gh');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Upper West','gh');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Volta','gh');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Western','gh');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Carriacou and Petit Martinique','gj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Andrew','gj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint David','gj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint George','gj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint John','gj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Mark','gj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Patrick','gj');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Castel','gk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Forest','gk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('St. Andrew','gk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('St. Martin','gk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('St. Pierre du Bois','gk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('St. Sampson','gk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('St. Saviour','gk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Torteval','gk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vale','gk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Avannaa (Nordgronland)','gl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kitaa (Vestgronland)','gl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tunu (Ostgronland)','gl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Baden-Wuerttemberg','gm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bayern','gm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Berlin','gm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Brandenburg','gm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bremen','gm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hamburg','gm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hessen','gm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mecklenburg-Vorpommern','gm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Niedersachsen','gm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nordrhein-Westfalen','gm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rheinland-Pfalz','gm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saarland','gm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sachsen','gm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sachsen-Anhalt','gm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Schleswig-Holstein','gm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Thueringen','gm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aitolia kai Akarnania','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Akhaia','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Argolis','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Arkadhia','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Arta','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Attiki','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ayion Oros* (Mt. Athos)','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dhodhekanisos','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Drama','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Evritania','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Evros','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Evvoia','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Florina','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Fokis','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Fthiotis','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Grevena','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ilia','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Imathia','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ioannina','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Irakleion','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kardhitsa','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kastoria','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kavala','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kefallinia','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kerkyra','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Khalkidhiki','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Khania','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Khios','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kikladhes','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kilkis','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Korinthia','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kozani','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lakonia','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Larisa','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lasithi','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lesvos','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Levkas','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Magnisia','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Messinia','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pella','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pieria','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Preveza','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rethimni','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rodhopi','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Samos','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Serrai','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Thesprotia','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Thessaloniki','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Trikala','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Voiotia','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Xanthi','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zakinthos','gr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Alta Verapaz','gt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Baja Verapaz','gt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chimaltenango','gt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chiquimula','gt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('El Progreso','gt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Escuintla','gt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Guatemala','gt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Huehuetenango','gt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Izabal','gt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jalapa','gt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jutiapa','gt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Peten','gt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Quetzaltenango','gt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Quiche','gt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Retalhuleu','gt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sacatepequez','gt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('San Marcos','gt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Santa Rosa','gt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Solola','gt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Suchitepequez','gt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Totonicapan','gt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zacapa','gt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Beyla','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Boffa','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Boke','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Conakry','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Coyah','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dabola','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dalaba','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dinguiraye','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dubreka','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Faranah','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Forecariah','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Fria','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gaoual','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gueckedou','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kankan','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kerouane','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kindia','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kissidougou','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Koubia','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Koundara','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kouroussa','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Labe','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lelouma','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lola','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Macenta','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mali','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mamou','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mandiana','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nzerekore','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pita','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Siguiri','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Telimele','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tougue','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yomou','gv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Barima-Waini','gy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cuyuni-Mazaruni','gy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Demerara-Mahaica','gy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('East Berbice-Corentyne','gy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Essequibo Islands-West Demerara','gy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mahaica-Berbice','gy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pomeroon-Supenaam','gy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Potaro-Siparuni','gy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Upper Demerara-Berbice','gy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Upper Takutu-Upper Essequibo','gy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Artibonite','ha');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Centre','ha');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Grand Anse','ha');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nord','ha');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nord-Est','ha');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nord-Ouest','ha');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ouest','ha');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sud','ha');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sud-Est','ha');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Atlantida','ho');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Choluteca','ho');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Colon','ho');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Comayagua','ho');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Copan','ho');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cortes','ho');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('El Paraiso','ho');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Francisco Morazan','ho');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gracias a Dios','ho');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Intibuca','ho');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Islas de la Bahia','ho');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('La Paz','ho');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lempira','ho');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ocotepeque','ho');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Olancho','ho');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Santa Barbara','ho');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Valle','ho');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yoro','ho');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bacs-Kiskun','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Baranya','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bekes','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bekescsaba','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Borsod-Abauj-Zemplen','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Csongrad','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Debrecen','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dunaujvaros','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Eger','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Fejer','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gyor','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gyor-Moson-Sopron','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hajdu-Bihar','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Heves','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hodmezovasarhely','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jasz-Nagykun-Szolnok','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kaposvar','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kecskemet','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Komarom-Esztergom','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Miskolc','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nagykanizsa','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nograd','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nyiregyhaza','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pecs','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pest','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Somogy','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sopron','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Szabolcs-Szatmar-Bereg','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Szeged','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Szekesfehervar','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Szolnok','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Szombathely','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tatabanya','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tolna','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vas','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Veszprem','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zala','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zalaegerszeg','hu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Akranes','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Akureyri','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Arnessysla','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Austur-Bardhastrandarsysla','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Austur-Hunavatnssysla','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Austur-Skaftafellssysla','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Borgarfjardharsysla','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dalasysla','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Eyjafjardharsysla','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gullbringusysla','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hafnarfjordhur','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Husavik','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Isafjordhur','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Keflavik','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kjosarsysla','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kopavogur','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Myrasysla','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Neskaupstadhur','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nordhur-Isafjardharsysla','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nordhur-Mulasys-la','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nordhur-Thingeyjarsysla','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Olafsfjordhur','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rangarvallasysla','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Reykjavik','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saudharkrokur','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Seydhisfjordhur','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Siglufjordhur','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Skagafjardharsysla','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Snaefellsnes-og Hnappadalssysla','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Strandasysla','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sudhur-Mulasysla','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sudhur-Thingeyjarsysla','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vesttmannaeyjar','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vestur-Bardhastrandarsysla','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vestur-Hunavatnssysla','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vestur-Isafjardharsysla','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vestur-Skaftafellssysla','ic');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aceh','id');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bali','id');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Banten','id');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bengkulu','id');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('East Timor is under UN administration pending its formal independence','id');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gorontalo','id');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Irian Jaya','id');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jambi','id');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jawa Barat','id');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jawa Tengah','id');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jawa Timur','id');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kalimantan Barat','id');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kalimantan Selatan','id');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kalimantan Tengah','id');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kalimantan Timur','id');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kepulauan Bangka Belitung','id');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lampung','id');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Maluku','id');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Maluku Utara','id');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nusa Tenggara Barat','id');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nusa Tenggara Timur','id');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Riau','id');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sulawesi Selatan','id');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sulawesi Tengah','id');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sulawesi Tenggara','id');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sulawesi Utara','id');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sumatera Barat','id');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sumatera Selatan','id');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sumatera Utara','id');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yogyakarta','id');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Andaman and Nicobar Islands','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Andhra Pradesh','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Arunachal Pradesh','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Assam','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bihar','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chandigarh','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chhattisgarh','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dadra and Nagar Haveli','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Daman and Diu','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Delhi','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Goa','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gujarat','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Haryana','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Himachal Pradesh','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jammu and Kashmir','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jharkhand','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Karnataka','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kerala','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lakshadweep','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Madhya Pradesh','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Maharashtra','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Manipur','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Meghalaya','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mizoram','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nagaland','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Orissa','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pondicherry','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Punjab','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rajasthan','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sikkim','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tamil Nadu','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tripura','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Uttar Pradesh','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Uttaranchal','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('West Bengal','in');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ardabil','ir');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Azarbayjan-e Gharbi','ir');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Azarbayjan-e Sharqi','ir');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bushehr','ir');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chahar Mahall va Bakhtiari','ir');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Esfahan','ir');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Fars','ir');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gilan','ir');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Golestan','ir');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hamadan','ir');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hormozgan','ir');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ilam','ir');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kerman','ir');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kermanshah','ir');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Khorasan','ir');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Khuzestan','ir');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kohgiluyeh va Buyer Ahmad','ir');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kordestan','ir');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lorestan','ir');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Markazi','ir');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mazandaran','ir');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Qazvin','ir');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Qom','ir');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Semnan','ir');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sistan va Baluchestan','ir');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tehran','ir');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yazd','ir');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zanjan','ir');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Central','is');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Haifa','is');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jerusalem','is');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Northern','is');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Southern','is');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tel Aviv','is');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Abruzzi','it');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Basilicata','it');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Calabria','it');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Campania','it');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Emilia-Romagna','it');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Friuli-Venezia Giulia','it');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lazio','it');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Liguria','it');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lombardia','it');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Marche','it');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Molise','it');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Piemonte','it');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Puglia','it');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sardegna','it');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sicilia','it');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Toscana','it');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Trentino-Alto Adige','it');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Umbria','it');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Valle d Aosta','it');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Veneto','it');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Anbar','iz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Basrah','iz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Muthanna','iz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Qadisiyah','iz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('An Najaf','iz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Arbil','iz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('As Sulaymaniyah','iz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('At Ta mim','iz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Babil','iz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Baghdad','iz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dahuk','iz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dhi Qar','iz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Diyala','iz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Karbala','iz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Maysan','iz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ninawa','iz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Salah ad Din','iz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Wasit','iz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aichi','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Akita','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aomori','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chiba','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ehime','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Fukui','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Fukuoka','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Fukushima','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gifu','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gumma','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hiroshima','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hokkaido','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hyogo','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ibaraki','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ishikawa','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Iwate','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kagawa','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kagoshima','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kanagawa','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kochi','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kumamoto','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kyoto','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mie','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Miyagi','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Miyazaki','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nagano','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nagasaki','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nara','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Niigata','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Oita','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Okayama','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Okinawa','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Osaka','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saga','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saitama','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Shiga','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Shimane','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Shizuoka','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tochigi','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tokushima','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tokyo','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tottori','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Toyama','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Wakayama','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yamagata','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yamaguchi','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yamanashi','ja');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Clarendon','jm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hanover','jm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kingston','jm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Manchester','jm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Portland','jm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Andrew','jm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Ann','jm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Catherine','jm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Elizabeth','jm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint James','jm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Mary','jm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Thomas','jm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Trelawny','jm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Westmoreland','jm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ajlun','jo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al  Aqabah','jo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Balqa','jo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Karak','jo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Mafraq','jo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Amman','jo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('At Tafilah','jo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Az Zarqa','jo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Irbid','jo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jarash','jo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ma an','jo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Madaba','jo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Central','ke');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Coast','ke');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Eastern','ke');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nairobi Area','ke');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('North Eastern','ke');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nyanza','ke');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rift Valley','ke');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Western','ke');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Batken Oblasty','kg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bishkek Shaary','kg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chuy Oblasty (Bishkek)','kg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jalal-Abad Oblasty','kg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Naryn Oblasty','kg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Osh Oblasty','kg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Talas Oblasty','kg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ysyk-Kol Oblasty (Karakol)','kg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chagang-do (Chagang Province)','kn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hamgyong-bukto (North Hamgyong Province)','kn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hamgyong-namdo (South Hamgyong Province)','kn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hwanghae-bukto (North Hwanghae Province)','kn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hwanghae-namdo (South Hwanghae Province)','kn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kaesong-si* (Kaesong City)','kn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kangwon-do (Kangwon Province)','kn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Namp o-si* (Namp o City)','kn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('P yongan-bukto (North P yongan Province)','kn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('P yongan-namdo (South P yongan Province)','kn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('P yongyang-si* (P yongyang City)','kn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yanggang-do (Yanggang Province)','kn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Abemama','kr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aranuka','kr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Arorae','kr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Banaba','kr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Beru','kr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Butaritari','kr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Central Gilberts','kr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gilbert Islands','kr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kanton','kr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kiritimati','kr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kuria','kr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Line Islands','kr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Maiana','kr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Makin','kr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Marakei','kr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nikunau','kr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nonouti','kr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Northern Gilberts','kr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Onotoa','kr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Phoenix Islands','kr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Southern Gilberts','kr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tabiteuea','kr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tabuaeran','kr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tamana','kr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tarawa','kr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Teraina)','kr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ch ungch ong-bukto','ks');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ch ungch ong-namdo','ks');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cheju-do','ks');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cholla-bukto','ks');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cholla-namdo','ks');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Inch on-gwangyoksi','ks');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kangwon-do','ks');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kwangju-gwangyoksi','ks');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kyonggi-do','ks');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kyongsang-bukto','ks');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kyongsang-namdo','ks');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pusan-gwangyoksi','ks');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Soul-t ukpyolsi','ks');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Taegu-gwangyoksi','ks');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Taejon-gwangyoksi','ks');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ulsan-gwangyoksi','ks');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al  Asimah','ku');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Ahmadi','ku');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Farwaniyah','ku');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Jahra','ku');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hawalli','ku');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Almaty','kz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aqmola (Astana)','kz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aqtobe','kz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Astana','kz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Atyrau','kz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Batys Qazaqstan (Oral)','kz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bayqongyr','kz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mangghystau (Aqtau','kz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ongtustik Qazaqstan (Shymkent)','kz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pavlodar','kz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Qaraghandy','kz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Qostanay','kz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Qyzylorda','kz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Shyghys Qazaqstan (Oskemen','kz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Soltustik Qazaqstan (Petropavl)','kz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zhambyl (Taraz','kz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Attapu','la');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bokeo','la');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bolikhamxai','la');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Champasak','la');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Houaphan','la');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Khammouan','la');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Louangnamtha','la');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Louangphabang','la');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Oudomxai','la');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Phongsali','la');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Salavan','la');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Savannakhet','la');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Viangchan','la');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Xaignabouli','la');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Xekong','la');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Xiangkhoang','la');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Beyrouth','le');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ech Chimal','le');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ej Jnoub','le');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('El Bekaa','le');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jabal Loubnane','le');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bomi','li');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bong','li');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Grand Bassa','li');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Grand Cape Mount','li');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Grand Gedeh','li');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Grand Kru','li');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lofa','li');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Margibi','li');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Maryland','li');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Montserrado','li');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nimba','li');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('River Cess','li');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sinoe','li');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Banskobystricky','lo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bratislavsky','lo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kosicky','lo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nitriansky','lo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Presovsky','lo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Trenciansky','lo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Trnavsky','lo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zilinsky','lo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Balzers','ls');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Eschen','ls');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gamprin','ls');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mauren','ls');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Planken','ls');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ruggell','ls');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Schaan','ls');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Schellenberg','ls');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Triesen','ls');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Triesenberg','ls');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vaduz','ls');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Berea','lt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Butha-Buthe','lt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Leribe','lt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mafeteng','lt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Maseru','lt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mohales Hoek','lt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mokhotlong','lt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Qacha s Nek','lt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Quthing','lt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Thaba-Tseka','lt');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Diekirch','lu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Grevenmacher','lu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Luxembourg','lu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ajdabiya','ly');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al  Aziziyah','ly');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Fatih','ly');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Jabal al Akhdar','ly');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Jufrah','ly');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Khums','ly');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Kufrah','ly');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('An Nuqat al Khams','ly');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ash Shati','ly');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Awbari','ly');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Az Zawiyah','ly');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Banghazi','ly');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Darnah','ly');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ghadamis','ly');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gharyan','ly');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Misratah','ly');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Murzuq','ly');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sabha','ly');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sawfajjin','ly');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Surt','ly');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tarabulus','ly');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tarhunah','ly');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tubruq','ly');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yafran','ly');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zlitan','ly');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Antananarivo','ma');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Antsiranana','ma');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Fianarantsoa','ma');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mahajanga','ma');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Toamasina','ma');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Toliara','ma');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Balti','md');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cahul','md');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chisinau','md');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dubasari','md');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Edinet','md');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lapusna','md');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Orhei','md');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Soroca','md');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tighina','md');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ungheni','md');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Arhangay','mg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bayan-Olgiy','mg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bayanhongor','mg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bulgan','mg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Darhan','mg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dornod','mg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dornogovi','mg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dundgovi','mg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dzavhan','mg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Erdenet','mg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Govi-Altay','mg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hentiy','mg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hovd','mg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hovsgol','mg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Omnogovi','mg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ovorhangay','mg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Selenge','mg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Suhbaatar','mg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tov','mg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ulaanbaatar','mg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Uvs','mg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Anthony','mh');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Georges','mh');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Peter s','mh');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Blantyre','mi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chikwawa','mi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chiradzulu','mi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chitipa','mi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dedza','mi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dowa','mi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Karonga','mi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kasungu','mi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Likoma','mi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lilongwe','mi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Machinga (Kasupe)','mi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mangochi','mi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mchinji','mi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mulanje','mi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mwanza','mi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mzimba','mi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nkhata Bay','mi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nkhotakota','mi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nsanje','mi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ntcheu','mi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ntchisi','mi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rumphi','mi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Salima','mi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Thyolo','mi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zomba','mi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gao','ml');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kayes','ml');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kidal','ml');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Koulikoro','ml');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mopti','ml');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Segou','ml');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sikasso','ml');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tombouctou','ml');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Fontvieille','mn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('La Condamine','mn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Monaco-Ville','mn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Monte-Carlo','mn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Agadir','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Hoceima','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Azilal','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ben Slimane','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Beni Mellal','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Boulemane','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Casablanca','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chaouen','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('El Jadida','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('El Kelaa des Srarhna','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Er Rachidia','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Essaouira','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Fes','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Figuig','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Guelmim','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ifrane','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kenitra','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Khemisset','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Khenifra','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Khouribga','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Laayoune','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Larache','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Marrakech','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Meknes','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nador','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ouarzazate','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Oujda','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rabat-Sale','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Safi','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Settat','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sidi Kacem','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tan-Tan','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tanger','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Taounate','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Taroudannt','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tata','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Taza','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tetouan','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tiznit','mo');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Agalega Islands','mp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Black River','mp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cargados Carajos Shoals','mp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Flacq','mp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Grand Port','mp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Moka','mp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pamplemousses','mp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Plaines Wilhems','mp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Port Louis','mp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Riviere du Rempart','mp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rodrigues','mp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Savanne','mp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Adrar','mr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Assaba','mr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Brakna','mr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dakhlet Nouadhibou','mr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gorgol','mr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Guidimaka','mr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hodh Ech Chargui','mr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hodh El Gharbi','mr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Inchiri','mr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nouakchott','mr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tagant','mr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tiris Zemmour','mr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Trarza','mr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Alifu','mv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Baa','mv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dhaalu','mv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Faafu','mv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gaafu Alifu','mv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gaafu Dhaalu','mv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gnaviyani','mv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Haa Alifu','mv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Haa Dhaalu','mv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kaafu','mv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Laamu','mv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lhaviyani','mv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Maale','mv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Meemu','mv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Noonu','mv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Raa','mv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Seenu','mv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Shaviyani','mv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Thaa','mv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vaavu','mv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aguascalientes','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Baja California','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Baja California Sur','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Campeche','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chiapas','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chihuahua','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Coahuila de Zaragoza','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Colima','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Distrito Federal','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Durango','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Guanajuato','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Guerrero','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hidalgo','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jalisco','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mexico','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Michoacan de Ocampo','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Morelos','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nayarit','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nuevo Leon','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Oaxaca','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Puebla','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Queretaro de Arteaga','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Quintana Roo','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('San Luis Potosi','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sinaloa','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sonora','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tabasco','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tamaulipas','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tlaxcala','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Veracruz-Llave','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yucatan','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zacatecas','mx');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Johor','my');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kedah','my');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kelantan','my');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Labuan','my');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Melaka','my');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Negeri Sembilan','my');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pahang','my');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Perak','my');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Perlis','my');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pulau Pinang','my');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sabah','my');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sarawak','my');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Selangor','my');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Terengganu','my');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Wilayah Persekutuan','my');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cabo Delgado','mz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gaza','mz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Inhambane','mz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Manica','mz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Maputo','mz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nampula','mz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Niassa','mz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sofala','mz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tete','mz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zambezia','mz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nord','nc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Agadez','ng');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Diffa','ng');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dosso','ng');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Maradi','ng');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Niamey','ng');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tahoua','ng');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tillaberi','ng');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zinder','ng');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Malampa','nh');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Penama','nh');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sanma','nh');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Shefa','nh');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tafea','nh');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Torba','nh');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Abia','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Abuja Federal Capital Territory','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Adamawa','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Akwa Ibom','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Anambra','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bauchi','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bayelsa','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Benue','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Borno','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cross River','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Delta','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ebonyi','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Edo','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ekiti','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Enugu','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gombe','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Imo','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jigawa','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kaduna','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kano','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Katsina','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kebbi','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kogi','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kwara','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lagos','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nassarawa','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Niger','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ogun','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ondo','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Osun','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Oyo','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Plateau','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rivers','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sokoto','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Taraba','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yobe','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zamfara','ni');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Drenthe','nl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Flevoland','nl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Friesland','nl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gelderland','nl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Groningen','nl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Limburg','nl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Noord-Brabant','nl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Noord-Holland','nl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Overijssel','nl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Utrecht','nl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zeeland','nl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zuid-Holland','nl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Akershus','no');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aust-Agder','no');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Buskerud','no');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Finnmark','no');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hedmark','no');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hordaland','no');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('More og Romsdal','no');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nord-Trondelag','no');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nordland','no');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Oppland','no');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Oslo','no');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ostfold','no');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rogaland','no');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sogn og Fjordane','no');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sor-Trondelag','no');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Telemark','no');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Troms','no');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vest-Agder','no');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vestfold','no');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bagmati','np');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bheri','np');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dhawalagiri','np');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gandaki','np');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Janakpur','np');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Karnali','np');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kosi','np');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lumbini','np');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mahakali','np');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mechi','np');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Narayani','np');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rapti','np');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sagarmatha','np');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Seti','np');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aiwo','nr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Anabar','nr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Anetan','nr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Anibare','nr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Baiti','nr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Boe','nr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Buada','nr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Denigomodu','nr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ewa','nr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ijuw','nr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Meneng','nr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nibok','nr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Uaboe','nr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yaren','nr');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Brokopondo','ns');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Commewijne','ns');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Coronie','ns');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Marowijne','ns');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nickerie','ns');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Para','ns');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Paramaribo','ns');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saramacca','ns');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sipaliwini','ns');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Wanica','ns');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Atlantico Norte','nu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Atlantico Sur','nu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Boaco','nu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Carazo','nu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chinandega','nu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chontales','nu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Esteli','nu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Granada','nu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jinotega','nu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Leon','nu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Madriz','nu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Managua','nu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Masaya','nu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Matagalpa','nu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nueva Segovia','nu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rio San Juan','nu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rivas','nu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Akaroa','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Amuri','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ashburton','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Auckland','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Banks Peninsula','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bay of Islands','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bay of Plenty','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bruce','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Buller','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Canterbury','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Carterton','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Central Hawke s Bay','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Central Otago','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chatham Islands','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cheviot','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Christchurch','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Clifton','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Clutha','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cook','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dannevirke','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dunedin','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Egmont','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Eketahuna','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ellesmere','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Eltham','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Eyre','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Far North','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Featherston','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Franklin','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gisborne','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Golden Bay','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gore','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Great Barrier Island','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Grey','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hamilton','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hastings','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hauraki','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hauraki Plains','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hawera','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hawke s Bay','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Heathcote','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hobson','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hokianga','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Horowhenua','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hurunui','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hutt','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Inangahua','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Inglewood','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Invercargill','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kaikoura','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kaipara','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kairanga','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kapiti Coast','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kawerau','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kiwitea','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lake','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mackenzie','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Malvern','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Manawatu','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mangonui','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Maniototo','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Manukau','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Marlborough','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Masterton','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Matamata','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Matamata Piako','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mount Herbert','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Napier','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nelson','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('New Plymouth','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('North Shore','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Northland','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ohinemuri','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Opotiki','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Oroua','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Otago','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Otamatea','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Otorohanga','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Oxford','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pahiatua','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Palmerston North','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Papakura','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Paparua','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Patea','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Piako','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pohangina','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Porirua','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Queenstown Lakes','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Raglan','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rangiora','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rangitikei','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rodney','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rotorua','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ruapehu','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Runanga','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Kilda','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Selwyn','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Silverpeaks','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('South Taranaki','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('South Waikato','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('South Wairarapa','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Southland','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Stewart Island','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Stratford','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Strathallan','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Taranaki','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tararua','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tasman','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Taumarunui','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Taupo','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tauranga','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Thames Coromandel','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Thames-Coromandel','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Timaru','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tuapeka','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Upper Hutt','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vincent','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Waiapu','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Waiheke','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Waihemo','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Waikato','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Waikohu','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Waimairi','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Waimakariri','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Waimarino','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Waimate','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Waimate West','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Waimea','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Waipa','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Waipawa','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Waipukurau','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Wairarapa South','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Wairewa','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Wairoa','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Waitakere','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Waitaki','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Waitomo','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Waitotara','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Wallace','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Wanganui','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Wanganui-Manawatu','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Wellington','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Western Bay of Plenty','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Westland','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Whakatane','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Whangarei','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Whangarei)','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Whangaroa','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Woodville','nz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Alto Paraguay','pa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Alto Parana','pa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Amambay','pa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Asuncion (city)','pa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Boqueron','pa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Caaguazu','pa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Caazapa','pa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Canindeyu','pa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Central','pa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Concepcion','pa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cordillera','pa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Guaira','pa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Itapua','pa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Misiones','pa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Neembucu','pa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Paraguari','pa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Presidente Hayes','pa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('San Pedro','pa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Amazonas','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Amazonas)','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ancash','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Andres Avelino Caceres (from Huanuco','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Apurimac','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Apurimac)','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Arequipa','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Arequipa (from Arequipa)','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ayacucho','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cajamarca','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Callao','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chavin (from Ancash)','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cusco','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Grau (from Tumbes','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Huancavelica','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Huancavelica)','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Huanuco','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ica','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Inca (from Cusco','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Junin','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Junin)','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('La Libertad','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('La Libertad (from La Libertad)','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lambayeque','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lima','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Loreto','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Los Libertadores-Huari (from Ica','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Madre de Dios','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mariategui (from Moquegua','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Moquegua','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nor Oriental del Maranon (from Lambayeque','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pasco','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Piura','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Piura)','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Puno','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Puno)','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('San Martin','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('San Martin (from San Martin)','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tacna','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tumbes','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ucayali','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ucayali (from Ucayali)','pe');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Balochistan','pk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Federally Administered Tribal Areas','pk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('North-West Frontier Province','pk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Punjab','pk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sindh','pk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dolnoslaskie','pl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kujawsko-Pomorskie','pl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lodzkie','pl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lubelskie','pl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lubuskie','pl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Malopolskie','pl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mazowieckie','pl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Opolskie','pl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Podkarpackie','pl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Podlaskie','pl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pomorskie','pl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Slaskie','pl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Swietokrzyskie','pl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Warminsko-Mazurskie','pl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Wielkopolskie','pl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zachodniopomorskie','pl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bocas del Toro','pm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chiriqui','pm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cocle','pm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Colon','pm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Darien','pm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Herrera','pm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Los Santos','pm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Panama','pm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('San Blas','pm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Acores (Azores)','po');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aveiro','po');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Beja','po');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Braga','po');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Braganca','po');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Castelo Branco','po');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Coimbra','po');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Evora','po');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Faro','po');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Guarda','po');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Leiria','po');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lisboa','po');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Madeira','po');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Portalegre','po');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Porto','po');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Santarem','po');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Setubal','po');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Viana do Castelo','po');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vila Real','po');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Viseu','po');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bougainville','pp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Central','pp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chimbu','pp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('East New Britain','pp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('East Sepik','pp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Eastern Highlands','pp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Enga','pp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gulf','pp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Madang','pp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Manus','pp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Milne Bay','pp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Morobe','pp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('National Capital','pp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('New Ireland','pp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Northern','pp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sandaun','pp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Southern Highlands','pp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('West New Britain','pp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Western','pp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Western Highlands','pp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aimeliik','ps');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Airai','ps');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Angaur','ps');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hatobohei','ps');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kayangel','ps');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Koror','ps');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Melekeok','ps');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ngaraard','ps');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ngarchelong','ps');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ngardmau','ps');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ngatpang','ps');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ngchesar','ps');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ngeremlengui','ps');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ngiwal','ps');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Palau Island','ps');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Peleliu','ps');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sonsoral','ps');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tobi','ps');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bafata','pu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Biombo','pu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bissau','pu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bolama','pu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cacheu','pu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gabu','pu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Oio','pu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Quinara','pu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tombali','pu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ad Dawhah','qa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Ghuwayriyah','qa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Jumayliyah','qa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Khawr','qa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Wakrah','qa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ar Rayyan','qa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jarayan al Batinah','qa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Madinat ash Shamal','qa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Umm Salal','qa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ailinginae','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ailinglaplap','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ailuk','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Arno','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aur','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bikar','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bikini','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bokak','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ebon','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Enewetak','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Erikub','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jabat','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jaluit','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jemo','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kili','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kwajalein','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lae','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lib','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Likiep','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Majuro','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Maloelap','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mejit','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mili','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Namorik','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Namu','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rongelap','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rongrik','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Toke','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ujae','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ujelang','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Utirik','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Wotho','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Wotje','rm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Alba','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Arad','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Arges','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bacau','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bihor','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bistrita-Nasaud','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Botosani','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Braila','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Brasov','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bucuresti','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Buzau','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Calarasi','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Caras-Severin','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cluj','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Constanta','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Covasna','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dimbovita','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dolj','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Galati','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Giurgiu','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gorj','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Harghita','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hunedoara','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ialomita','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Iasi','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Maramures','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mehedinti','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mures','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Neamt','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Olt','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Prahova','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Salaj','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Satu Mare','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sibiu','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Suceava','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Teleorman','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Timis','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tulcea','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vaslui','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vilcea','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vrancea','ro');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Abra','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Agusan del Norte','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Agusan del Sur','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aklan','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Albay','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Angeles','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Antique','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aurora','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bacolod','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bago','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Baguio','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bais','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Basilan','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Basilan City','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bataan','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Batanes','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Batangas','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Batangas City','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Benguet','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bohol','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bukidnon','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bulacan','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Butuan','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cabanatuan','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cadiz','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cagayan','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cagayan de Oro','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Calbayog','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Caloocan','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Camarines Norte','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Camarines Sur','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Camiguin','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Canlaon','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Capiz','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Catanduanes','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cavite','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cavite City','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cebu','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cebu City','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cotabato','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dagupan','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Danao','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dapitan','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Davao City* Davao','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Davao Oriental','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Davao del Sur','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dipolog','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dumaguete','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Eastern Samar','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('General Santos','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gingoog','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ifugao','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Iligan','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ilocos Norte','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ilocos Sur','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Iloilo','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Iloilo City','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Iriga','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Isabela','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kalinga-Apayao','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('La Carlota','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('La Union','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Laguna','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lanao del Norte','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lanao del Sur','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Laoag','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lapu-Lapu','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Legaspi','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Leyte','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lipa','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lucena','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Maguindanao','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mandaue','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Manila','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Marawi','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Marinduque','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Masbate','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mindoro Occidental','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mindoro Oriental','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Misamis Occidental','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Misamis Oriental','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mountain','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Naga','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Negros Occidental','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Negros Oriental','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('North Cotabato','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Northern Samar','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nueva Ecija','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nueva Vizcaya','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Olongapo','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ormoc','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Oroquieta','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ozamis','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pagadian','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Palawan','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Palayan','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pampanga','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pangasinan','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pasay','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Puerto Princesa','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Quezon','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Quezon City','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Quirino','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rizal','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Romblon','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Roxas','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Samar','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('San Carlos* (in Negros Occidental)','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('San Carlos* (in Pangasinan)','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('San Jose','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('San Pablo','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Silay','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Siquijor','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sorsogon','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('South Cotabato','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Southern Leyte','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sultan Kudarat','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sulu','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Surigao','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Surigao del Norte','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Surigao del Sur','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tacloban','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tagaytay','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tagbilaran','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tangub','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tarlac','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tawitawi','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Toledo','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Trece Martires','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zambales','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zamboanga','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zamboanga del Norte','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zamboanga del Sur','rp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Adjuntas','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aguada','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aguadilla','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aguas Buenas','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aibonito','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Anasco','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Arecibo','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Arroyo','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Barceloneta','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Barranquitas','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bayamon','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cabo Rojo','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Caguas','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Camuy','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Canovanas','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Carolina','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Catano','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cayey','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ceiba','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ciales','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cidra','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Coamo','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Comerio','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Corozal','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Culebra','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dorado','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Fajardo','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Florida','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Guanica','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Guayama','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Guayanilla','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Guaynabo','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gurabo','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hatillo','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hormigueros','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Humacao','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Isabela','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jayuya','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Juana Diaz','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Juncos','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lajas','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lares','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Las Marias','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Las Piedras','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Loiza','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Luquillo','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Manati','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Maricao','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Maunabo','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mayaguez','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Moca','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Morovis','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Naguabo','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Naranjito','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Orocovis','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Patillas','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Penuelas','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ponce','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Quebradillas','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rincon','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rio Grande','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sabana Grande','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Salinas','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('San German','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('San Juan','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('San Lorenzo','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('San Sebastian','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Santa Isabel','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Toa Alta','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Toa Baja','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Trujillo Alto','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Utuado','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vega Alta','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vega Baja','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vieques','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Villalba','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yabucoa','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yauco','rq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Adygeya (Maykop)','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Altay (Gorno-Altaysk)','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Amurskaya (Blagoveshchensk)','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Arkhangel skaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Astrakhanskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bashkortostan (Ufa)','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Belgorodskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bryanskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Buryatiya (Ulan-Ude)','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chechnya (Groznyy)','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chelyabinskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chitinskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chuvashiya (Cheboksary)','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dagestan (Makhachkala)','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ingushetiya (Nazran )','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Irkutskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ivanovskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kabardino-Balkariya (Nal chik)','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kaliningradskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kalmykiya (Elista)','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kaluzhskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kamchatskaya (Petropavlovsk-Kamchatskiy)','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Karachayevo-Cherkesiya (Cherkessk)','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kareliya (Petrozavodsk)','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kemerovskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Khakasiya (Abakan)','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kirovskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Komi (Syktyvkar)','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kostromskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kurganskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kurskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Leningradskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lipetskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Magadanskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mariy-El (Yoshkar-Ola)','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mordoviya (Saransk)','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Moskovskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Murmanskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nizhegorodskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Novgorodskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Novosibirskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Omskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Orenburgskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Orlovskaya (Orel)','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Penzenskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Permskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pskovskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rostovskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ryazanskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sakha (Yakutsk)','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sakhalinskaya (Yuzhno-Sakhalinsk)','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Samarskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saratovskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Severnaya Osetiya-Alaniya [North Ossetia] (Vladikavkaz)','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Smolenskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sverdlovskaya (Yekaterinburg)','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tambovskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tatarstan (Kazan )','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tomskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tul skaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tverskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tyumenskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tyva (Kyzyl)','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Udmurtiya (Izhevsk)','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ul yanovskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vladimirskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Volgogradskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vologodskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Voronezhskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yaroslavskaya','rs');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Butare','rw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Byumba','rw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cyangugu','rw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gikongoro','rw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gisenyi','rw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gitarama','rw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kibungo','rw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kibuye','rw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kigali Rurale','rw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kigali-ville','rw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ruhengeri','rw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Umutara','rw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Bahah','sa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Hudud ash Shamaliyah','sa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Jawf','sa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Madinah','sa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Qasim','sa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ar Riyad','sa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ash Sharqiyah (Eastern Province)','sa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Asir','sa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ha il','sa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jizan','sa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Makkah','sa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Najran','sa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tabuk','sa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Miquelon','sb');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Christ Church Nichola Town','sc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Anne Sandy Point','sc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint George Basseterre','sc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint George Gingerland','sc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint James Windward','sc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint John Capisterre','sc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint John Figtree','sc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Mary Cayon','sc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Paul Capisterre','sc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Paul Charlestown','sc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Peter Basseterre','sc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Thomas Lowland','sc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Thomas Middle Island','sc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Trinity Palmetto Point','sc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Anse Boileau','se');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Anse Etoile','se');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Anse Louis','se');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Anse Royale','se');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Anse aux Pins','se');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Baie Lazare','se');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Baie Sainte Anne','se');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Beau Vallon','se');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bel Air','se');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bel Ombre','se');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cascade','se');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Glacis','se');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Grand  Anse (on Mahe)','se');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Grand  Anse (on Praslin)','se');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('La Digue','se');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('La Riviere Anglaise','se');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mont Buxton','se');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mont Fleuri','se');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Plaisance','se');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pointe La Rue','se');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Port Glaud','se');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Louis','se');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Takamaka','se');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Eastern Cape','sf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Free State','sf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gauteng','sf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('KwaZulu-Natal','sf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mpumalanga','sf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('North-West','sf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Northern Cape','sf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Northern Province','sf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Western Cape','sf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dakar','sg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Diourbel','sg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Fatick','sg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kaolack','sg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kolda','sg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Louga','sg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint-Louis','sg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tambacounda','sg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Thies','sg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ziguinchor','sg');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ascension','sh');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Helena','sh');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tristan da Cunha','sh');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Eastern','sl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Northern','sl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Southern','sl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Western','sl');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Acquaviva','sm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Borgo Maggiore','sm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chiesanuova','sm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Domagnano','sm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Faetano','sm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Fiorentino','sm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Monte Giardino','sm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('San Marino','sm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Serravalle','sm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Awdal','so');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bakool','so');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Banaadir','so');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bari','so');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bay','so');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Galguduud','so');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gedo','so');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hiiraan','so');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jubbada Dhexe','so');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jubbada Hoose','so');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mudug','so');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nugaal','so');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sanaag','so');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Shabeellaha Dhexe','so');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Shabeellaha Hoose','so');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sool','so');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Togdheer','so');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Woqooyi Galbeed','so');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Andalucia','sp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aragon','sp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Asturias','sp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Baleares (Balearic Islands)','sp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Canarias (Canary Islands)','sp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cantabria','sp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Castilla y Leon','sp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Castilla-La Mancha','sp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cataluna','sp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Communidad Valencian','sp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Extremadura','sp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Galicia','sp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('La Rioja','sp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Madrid','sp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Murcia','sp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Navarra','sp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pais Vasco (Basque Country)','sp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Anse-la-Raye','st');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Castries','st');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Choiseul','st');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dauphin','st');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dennery','st');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gros Islet','st');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Laborie','st');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Micoud','st');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Praslin','st');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Soufriere','st');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vieux Fort','st');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('A ali an Nil','su');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Bahr al Ahmar','su');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Buhayrat','su');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Jazirah','su');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Khartum','su');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Qadarif','su');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Wahdah','su');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('An Nil al Abyad','su');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('An Nil al Azraq','su');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ash Shamaliyah','su');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bahr al Jabal','su');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gharb Bahr al Ghazal','su');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gharb Darfur','su');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gharb Kurdufan','su');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gharb al Istiwa iyah','su');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Janub Darfur','su');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Janub Kurdufan','su');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Junqali','su');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kassala','su');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nahr an Nil','su');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Shamal Bahr al Ghazal','su');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Shamal Darfur','su');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Shamal Kurdufan','su');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sharq al Istiwa iyah','su');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sinnar','su');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Warab','su');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Blekinge','sw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dalarnas','sw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gavleborgs','sw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gotlands','sw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hallands','sw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jamtlands','sw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jonkopings','sw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kalmar','sw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kronobergs','sw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Norrbottens','sw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Orebro','sw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ostergotlands','sw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Skane','sw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sodermanlands','sw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Stockholms','sw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Uppsala','sw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Varmlands','sw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vasterbottens','sw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vasternorrlands','sw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vastmanlands','sw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vastra Gotalands','sw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Hasakah','sy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Ladhiqiyah','sy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Qunaytirah','sy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ar Raqqah','sy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('As Suwayda','sy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dar a','sy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dayr az Zawr','sy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dimashq','sy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Halab','sy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hamah','sy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hims','sy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Idlib','sy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rif Dimashq','sy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tartus','sy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aargau','sz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ausser-Rhoden','sz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Basel-Landschaft','sz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Basel-Stadt','sz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bern','sz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Fribourg','sz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Geneve','sz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Glarus','sz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Graubunden','sz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Inner-Rhoden','sz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jura','sz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Luzern','sz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Neuchatel','sz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nidwalden','sz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Obwalden','sz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sankt Gallen','sz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Schaffhausen','sz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Schwyz','sz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Solothurn','sz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Thurgau','sz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ticino','sz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Uri','sz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Valais','sz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vaud','sz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zug','sz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zurich','sz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Arima','td');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Caroni','td');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mayaro','td');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nariva','td');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Port-of-Spain','td');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Andrew','td');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint David','td');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint George','td');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Patrick','td');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('San Fernando','td');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Victoria','td');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Amnat Charoen','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ang Thong','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Buriram','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chachoengsao','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chai Nat','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chaiyaphum','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chanthaburi','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chiang Mai','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chiang Rai','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chon Buri','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chumphon','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kalasin','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kamphaeng Phet','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kanchanaburi','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Khon Kaen','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Krabi','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Krung Thep Mahanakhon (Bangkok)','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lampang','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lamphun','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Loei','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lop Buri','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mae Hong Son','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Maha Sarakham','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mukdahan','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nakhon Nayok','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nakhon Pathom','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nakhon Phanom','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nakhon Ratchasima','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nakhon Sawan','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nakhon Si Thammarat','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nan','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Narathiwat','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nong Bua Lamphu','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nong Khai','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nonthaburi','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pathum Thani','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pattani','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Phangnga','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Phatthalung','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Phayao','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Phetchabun','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Phetchaburi','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Phichit','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Phitsanulok','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Phra Nakhon Si Ayutthaya','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Phrae','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Phuket','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Prachin Buri','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Prachuap Khiri Khan','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ranong','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ratchaburi','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rayong','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Roi Et','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sa Kaeo','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sakon Nakhon','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Samut Prakan','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Samut Sakhon','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Samut Songkhram','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sara Buri','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Satun','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sing Buri','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sisaket','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Songkhla','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sukhothai','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Suphan Buri','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Surat Thani','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Surin','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tak','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Trang','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Trat','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ubon Ratchathani','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Udon Thani','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Uthai Thani','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Uttaradit','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yala','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yasothon','th');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Viloyati Khatlon (Qurghonteppa - formerly Kurgan-Tyube)','ti');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Viloyati Leninobod (Khujand - formerly Leninabad)','ti');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Viloyati Mukhtori Kuhistoni Badakhshon* (Khorugh - formerly Khorog)','ti');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ha apai','tn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tongatapu','tn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vava u','tn');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('De La Kara','to');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Des Plateaux','to');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Des Savanes','to');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Du Centre','to');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Maritime','to');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Principe','tp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sao Tome','tp');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ariana (Aryanah)','ts');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Beja (Bajah)','ts');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ben Arous (Bin  Arus)','ts');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bizerte (Banzart)','ts');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('El Kef (Al Kaf)','ts');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gabes (Qabis)','ts');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gafsa (Qafsah)','ts');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jendouba (Jundubah)','ts');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kairouan (Al Qayrawan)','ts');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kasserine (Al Qasrayn)','ts');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kebili (Qibili)','ts');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mahdia (Al Mahdiyah)','ts');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Medenine (Madanin)','ts');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Monastir (Al Munastir)','ts');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nabeul (Nabul)','ts');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sfax (Safaqis)','ts');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sidi Bou Zid (Sidi Bu Zayd)','ts');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Siliana (Silyanah)','ts');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sousse (Susah)','ts');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tataouine (Tatawin)','ts');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tozeur (Tawzar)','ts');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tunis','ts');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zaghouan (Zaghwan)','ts');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Adana','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Adiyaman','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Afyon','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Agri','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aksaray','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Amasya','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ankara','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Antalya','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ardahan','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Artvin','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aydin','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Balikesir','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bartin','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Batman','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bayburt','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bilecik','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bingol','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bitlis','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bolu','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Burdur','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bursa','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Canakkale','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cankiri','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Corum','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Denizli','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Diyarbakir','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Edirne','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Elazig','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Erzincan','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Erzurum','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Eskisehir','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gaziantep','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Giresun','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gumushane','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hakkari','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hatay','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Icel','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Igdir','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Isparta','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Istanbul','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Izmir','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kahramanmaras','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Karabuk','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Karaman','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kars','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kastamonu','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kayseri','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kilis','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kirikkale','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kirklareli','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kirsehir','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kocaeli','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Konya','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kutahya','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Malatya','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Manisa','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mardin','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mugla','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mus','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nevsehir','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nigde','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ordu','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Osmaniye','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rize','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sakarya','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Samsun','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sanliurfa','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Siirt','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sinop','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sirnak','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sivas','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tekirdag','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tokat','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Trabzon','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tunceli','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Usak','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Van','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yalova','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yozgat','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zonguldak','tu');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chang-hua','tw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chi-lung','tw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chia-i','tw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hsin-chu','tw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hua-lien','tw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('I-lan','tw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kao-hsiung','tw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Miao-li','tw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nan-t ou','tw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('P eng-hu','tw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('P ing-tung','tw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('T ai-chung','tw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('T ai-nan','tw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('T ai-pei','tw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('T ai-tung','tw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('T ao-yuan','tw');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Arusha','tz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dar es Salaam','tz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dodoma','tz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Iringa','tz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kagera','tz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kigoma','tz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kilimanjaro','tz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lindi','tz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mara','tz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mbeya','tz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Morogoro','tz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mtwara','tz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mwanza','tz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pemba North','tz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pemba South','tz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pwani','tz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rukwa','tz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ruvuma','tz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Shinyanga','tz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Singida','tz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tabora','tz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tanga','tz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zanzibar Central/South','tz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zanzibar North','tz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zanzibar Urban/West','tz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Adjumani','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Apac','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Arua','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bugiri','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bundibugyo','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bushenyi','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Busia','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gulu','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hoima','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Iganga','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jinja','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kabale','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kabarole','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kalangala','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kampala','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kamuli','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kapchorwa','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kasese','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Katakwi','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kibale','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kiboga','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kisoro','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kitgum','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kotido','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kumi','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lira','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Luwero','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Masaka','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Masindi','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mbale','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mbarara','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Moroto','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Moyo','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mpigi','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mubende','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mukono','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nakasongola','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nebbi','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ntungamo','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pallisa','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rakai','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rukungiri','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sembabule','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Soroti','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tororo','ug');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aberdeen City','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aberdeenshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Angus','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Antrim','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ards','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Argyll and Bute','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Armagh','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ballymena','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ballymoney','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Banbridge','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Barnsley','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bedfordshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Belfast','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Blackburn with Darwen','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Blackpool','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Blaenau Gwent','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bolton','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bournemouth','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bracknell Forest','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bridgend','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Brighton and Hove','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Buckinghamshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bury','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Caerphilly','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Calderdale','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cambridgeshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Carmarthenshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Carrickfergus','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Castlereagh','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ceredigion','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cheshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('City of Edinburgh','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Clackmannanshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Coleraine','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Conwy','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cookstown','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cornwall','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Craigavon','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cumbria','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Darlington','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Denbighshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Derbyshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Derry','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Devon','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Doncaster','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dorset','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Down','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dudley','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dumfries and Galloway','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dundee City','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dungannon','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Durham','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('East Ayrshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('East Dunbartonshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('East Lothian','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('East Renfrewshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('East Sussex','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Eilean Siar (Western Isles)','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Essex','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Falkirk','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Fermanagh','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Fife','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Flintshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gateshead','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Glasgow City','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gloucestershire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Greater Manchester','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gwynedd','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Halton','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hampshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hartlepool','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Herefordshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hertfordshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Highland','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Inverclyde','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Isle of Anglesey','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Isle of Wight','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kent','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kirklees','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Knowsley','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lancashire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Larne','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Leicestershire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Limavady','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lincolnshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lisburn','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Luton','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Magherafelt','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Medway','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Merseyside','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Merthyr Tydfil','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Middlesbrough','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Midlothian','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Milton Keynes','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Monmouthshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Moray','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Moyle','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Neath Port Talbot','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Newport','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Newry and Mourne','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Newtownabbey','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Norfolk','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('North Ayrshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('North Down','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('North Lanarkshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('North Tyneside','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('North Yorkshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Northamptonshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Northumberland','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nottinghamshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Oldham','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Omagh','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Orkney Islands','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Oxfordshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pembrokeshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Perth and Kinross','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Poole','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Powys','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Reading','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Redcar and Cleveland','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Renfrewshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rhondda Cynon Taff','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rochdale','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rotherham','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sandwell','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sefton','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Shetland Islands','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Shropshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Slough','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Solihull','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Somerset','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('South Ayrshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('South Lanarkshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('South Tyneside','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('South Yorkshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Southend-on-Sea','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('St. Helens','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Staffordshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Stirling','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Stockport','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Stockton-on-Tees','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Strabane','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Suffolk','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Surrey','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Swindon','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tameside','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('The Scottish Borders','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('The Vale of Glamorgan','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Thurrock','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Torbay','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Torfaen','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Trafford','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tyne and Wear','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Walsall','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Warrington','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Warwickshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('West Dunbartonshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('West Lothian','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('West Midlands','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('West Sussex','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('West Yorkshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Wigan','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Wiltshire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Wirral','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Wolverhampton','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Worcestershire','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Wrexham','uk');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Avtonomna Respublika Krym* (Simferopol )','up');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cherkas ka (Cherkasy)','up');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chernihivs ka (Chernihiv)','up');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Chernivets ka (Chernivtsi)','up');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dnipropetrovs ka (Dnipropetrovs k)','up');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Donets ka (Donets k)','up');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ivano-Frankivs ka (Ivano-Frankivs k)','up');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kharkivs ka (Kharkiv)','up');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Khersons ka (Kherson)','up');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Khmel nyts ka (Khmel nyts kyy)','up');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kirovohrads ka (Kirovohrad)','up');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kyyivs ka (Kiev)','up');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('L vivs ka (L viv)','up');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Luhans ka (Luhans k)','up');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mykolayivs ka (Mykolayiv)','up');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Odes ka (Odesa)','up');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Poltavs ka (Poltava)','up');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rivnens ka (Rivne)','up');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sums ka (Sumy)','up');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ternopil s ka (Ternopil )','up');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vinnyts ka (Vinnytsya)','up');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Volyns ka (Luts k)','up');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zakarpats ka (Uzhhorod)','up');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zaporiz ka (Zaporizhzhya)','up');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zhytomyrs ka (Zhytomyr)','up');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Alabama','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Alaska','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Arizona','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Arkansas','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('California','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Colorado','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Connecticut','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Delaware','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('District of Columbia','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Florida','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Georgia','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hawaii','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Idaho','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Illinois','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Indiana','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Iowa','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kansas','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kentucky','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Louisiana','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Maine','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Maryland','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Massachusetts','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Michigan','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Minnesota','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mississippi','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Missouri','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Montana','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nebraska','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nevada','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('New Hampshire','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('New Jersey','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('New Mexico','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('New York','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('North Carolina','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('North Dakota','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ohio','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Oklahoma','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Oregon','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Pennsylvania','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rhode Island','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('South Carolina','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('South Dakota','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tennessee','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Texas','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Utah','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vermont','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Virginia','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Washington','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('West Virginia','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Wisconsin','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Wyoming','us');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bam','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Banwa','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bazega','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bougouriba','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Boulgou','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Boulkiemde','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Comoe','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ganzourgou','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gnagna','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gourma','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Houe','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Houet','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ioba','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kadiogo','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kenedougou','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Komandjari','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Komoe','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kompienga','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kossi','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Koupelogo','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kouritenga','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kourweogo','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Leraba','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Loroum','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mouhoun','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nahouri','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Namentenga','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Naouri','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Naumbiel','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nayala','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Oubritenga','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Oudalan','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Passore','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Poni','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Samentenga','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sanguie','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sanmatenga','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Seno','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sissili','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Soum','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sourou','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tapoa','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tuy','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yagha','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yatenga','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ziro','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zondomo','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zoundweogo','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zoundweogo)','uv');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Artigas','uy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Canelones','uy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cerro Largo','uy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Colonia','uy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Durazno','uy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Flores','uy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Florida','uy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lavalleja','uy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Maldonado','uy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Montevideo','uy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Paysandu','uy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rio Negro','uy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rivera','uy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Rocha','uy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Salto','uy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('San Jose','uy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Soriano','uy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tacuarembo','uy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Treinta y Tres','uy');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Andijon Wiloyati','uz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bukhoro Wiloyati','uz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Farghona Wiloyati','uz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Jizzakh Wiloyati','uz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Khorazm Wiloyati (Urganch)','uz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Namangan Wiloyati','uz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nawoiy Wiloyati','uz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Qashqadaryo Wiloyati (Qarshi)','uz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Qoraqalpoghiston* (Nukus)','uz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Samarqand Wiloyati','uz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sirdaryo Wiloyati (Guliston)','uz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Surkhondaryo Wiloyati (Termiz)','uz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Toshkent Wiloyati','uz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Charlotte','vc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Grenadines','vc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Andrew','vc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint David','vc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint George','vc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Patrick','vc');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Amazonas','ve');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Anzoategui','ve');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Apure','ve');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aragua','ve');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Barinas','ve');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bolivar','ve');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Carabobo','ve');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cojedes','ve');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Delta Amacuro','ve');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Distrito Federal','ve');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Falcon','ve');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Guarico','ve');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lara','ve');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Merida','ve');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Miranda','ve');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Monagas','ve');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nueva Esparta','ve');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Portuguesa','ve');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sucre','ve');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tachira','ve');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Trujillo','ve');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vargas','ve');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yaracuy','ve');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Zulia','ve');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('An Giang','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ba Ria-Vung Tau','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bac Giang','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bac Kan','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bac Lieu','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bac Ninh','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ben Tre','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Binh Dinh','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Binh Duong','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Binh Phuoc','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Binh Thuan','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ca Mau','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Can Tho','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Cao Bang','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Da Nang','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dac Lak','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dong Nai','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dong Thap','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gia Lai','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ha Giang','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ha Nam','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ha Noi','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ha Tay','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ha Tinh','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hai Duong','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hai Phong','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ho Chi Minh','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hoa Binh','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hung Yen','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Khanh Hoa','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kien Giang','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kon Tum','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lai Chau','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lam Dong','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lang Son','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lao Cai','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Long An','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nam Dinh','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Nghe An','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ninh Binh','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ninh Thuan','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Phu Tho','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Phu Yen','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Quang Binh','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Quang Nam','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Quang Ngai','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Quang Ninh','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Quang Tri','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Soc Trang','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Son La','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tay Ninh','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Thai Binh','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Thai Nguyen','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Thanh Hoa','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Thua Thien-Hue','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tien Giang','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tra Vinh','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tuyen Quang','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vinh Long','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vinh Phuc','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Yen Bai','vm');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Croix','vq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint John','vq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Saint Thomas','vq');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Caprivi','wa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Erongo','wa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hardap','wa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Karas','wa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Khomas','wa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Kunene','wa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ohangwena','wa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Okavango','wa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Omaheke','wa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Omusati','wa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Oshana','wa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Oshikoto','wa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Otjozondjupa','wa');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sigave','wf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Wallis','wf');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('A ana','ws');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Aiga-i-le-Tai','ws');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Atua','ws');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Fa asaleleaga','ws');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gaga emauga','ws');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Gagaifomauga','ws');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Palauli','ws');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Satupa itea','ws');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Tuamasaga','ws');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Va a-o-Fonoti','ws');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Vaisigano','ws');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hhohho','wz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lubombo','wz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Manzini','wz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Shiselweni','wz');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Abyan','ym');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Adan','ym');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Bayda','ym');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Hudaydah','ym');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Jawf','ym');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Mahrah','ym');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Al Mahwit','ym');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ataq','ym');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Dhamar','ym');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hadhramawt','ym');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Hajjah','ym');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ibb','ym');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lahij','ym');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ma rib','ym');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Sa dah','ym');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('San a','ym');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Ta izz','ym');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Central','za');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Copperbelt','za');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Eastern','za');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Luapula','za');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Lusaka','za');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('North-Western','za');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Northern','za');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Southern','za');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Western','za');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Bulawayo','zi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Harare','zi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Manicaland','zi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mashonaland Central','zi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mashonaland East','zi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Mashonaland West','zi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Masvingo','zi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Matabeleland North','zi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Matabeleland South','zi');
INSERT INTO Demo.demo.Provinces(Province,CountryCode) VALUES('Midlands','zi');

select count(*) from Provinces;
ECHO BOTH $IF $EQU $LAST[1] 3754 "PASSED" "***FAILED";
SET ARGV[$LIF] $+ $ARGV[$LIF] 1;
ECHO BOTH ": " $LAST[1] " Provinces loaded\n";

ECHO BOTH "Loading Countries Database Complete\n";
