/*
 * Copyright (c) 2016 The Khronos Group Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

/** OMX_ComponentExt.h - OpenMax IL version 1.1.2
 * The OMX_ComponentExt header file contains extensions to the definitions used
 * by both the application and the component to access common items.
 */

#ifndef OMX_ComponentExt_h
#define OMX_ComponentExt_h

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* Each OMX header must include all required header files to allow the
 * header to compile without errors.  The includes below are required
 * for this header file to compile successfully
 */
#include <OMX_Types.h>
#include <OMX_ComponentAlg.h>

/** Set/query the commit mode */
typedef struct OMX_CONFIG_COMMITMODETYPE
{
  OMX_U32 nSize;
  OMX_VERSIONTYPE nVersion;
  OMX_BOOL bDeferred;
}OMX_CONFIG_COMMITMODETYPE;

/** Explicit commit */
typedef struct OMX_CONFIG_COMMITTYPE
{
  OMX_U32 nSize;
  OMX_VERSIONTYPE nVersion;
}OMX_CONFIG_COMMITTYPE;

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* OMX_ComponentExt_h */

