.\" dpkg manual page - dpkg-architecture(1)
.\"
.\" Copyright © 2005 Marcus Brinkmann <brinkmd@debian.org>
.\" Copyright © 2005 Scott James Remnant <scott@netsplit.com>
.\" Copyright © 2006-2015 Guillem Jover <guillem@debian.org>
.\" Copyright © 2009-2012 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.TH dpkg\-architecture 1 "%RELEASE_DATE%" "%VERSION%" "dpkg suite"
.nh
.SH NAME
dpkg\-architecture \- set and determine the architecture for package building
.
.SH SYNOPSIS
.B dpkg\-architecture
.RI [ option "...] [" command ]
.PP
.
.SH DESCRIPTION
.B dpkg\-architecture
provides a facility to determine and set the build and
host architecture for package building.
.PP
The build architecture is always determined by an external call to
\fBdpkg\fP(1), and cannot be set at the command line.
.PP
You can specify the host architecture by providing one or both of the options
\fB\-\-host\-arch\fR and \fB\-\-host\-type\fR. The default is determined by
an external call to
.BR gcc (1),
or the same as the build architecture if \fBCC\fP or gcc are both not
available. One out of \fB\-\-host\-arch\fR and \fB\-\-host\-type\fR is
sufficient, the value of the
other will be set to a usable default. Indeed, it is often better to only
specify one, because \fBdpkg\-architecture\fP will warn you if your choice
does not match the default.
.
.SH COMMANDS
.TP
.BR \-l ", " \-\-list
Print the environment variables, one each line, in the format
\fIVARIABLE=value\fP. This is the default action.
.TP
.BR \-e ", " \-\-equal " \fIarchitecture\fP"
Check for equality of architecture (since dpkg 1.13.13).
It compares the current or specified Debian host architecture against
\fIarchitecture\fP, to check if they are equal.
This action will not expand the architecture wildcards.
Command finishes with an exit status of 0 if matched, 1 if not matched.

.TP
.BR \-i ", " \-\-is " \fIarchitecture-wildcard\fP"
Check for identity of architecture (since dpkg 1.13.13).
It compares the current or specified Debian host architecture against
\fIarchitecture-wildcard\fP after having expanded it as an architecture
wildcard, to check if they match.
Command finishes with an exit status of 0 if matched, 1 if not matched.
.TP
.BR \-q ", " \-\-query " \fIvariable-name\fP"
Print the value of a single variable.
.TP
.BR \-s ", " \-\-print\-set
Print an export command. This can be used to set the environment variables
using eval.
.TP
.BR \-u ", " \-\-print\-unset
Print a similar command to \fB\-\-print\-unset\fP but to unset all variables.
.TP
.BR \-c ", " \-\-command " \fIcommand-string\fP"
Execute a \fIcommand-string\fP in an environment which has all variables
set to the determined value.
.TP
.BR \-L ", " \-\-list\-known
Print a list of valid architecture names.
Possibly restricted by one or more of the matching options
\fB\-\-match\-wildcard\fP, \fB\-\-match\-bits\fP or \fB\-\-match\-endian\fP
(since dpkg 1.17.14).
.TP
.BR \-? ", " \-\-help
Show the usage message and exit.
.TP
.B \-\-version
Show the version and exit.
.
.SH OPTIONS
.TP
.BR \-a ", " \-\-host\-arch " \fIarchitecture\fP"
Set the host Debian architecture.
.TP
.BR \-t ", " \-\-host\-type " \fIgnu-system-type\fP"
Set the host GNU system type.
.TP
.BR \-A ", " \-\-target\-arch " \fIarchitecture\fP"
Set the target Debian architecture (since dpkg 1.17.14).
.TP
.BR \-T ", " \-\-target\-type " \fIgnu-system-type\fP"
Set the target GNU system type (since dpkg 1.17.14).
.TP
.BR \-W ", " \-\-match\-wildcard " \fIarchitecture-wildcard\fP"
Restrict the architectures listed by \fB\-\-list\-known\fP to ones matching
the specified architecture wildcard (since dpkg 1.17.14).
.TP
.BR \-B ", " \-\-match\-bits " \fIarchitecture-bits\fP"
Restrict the architectures listed by \fB\-\-list\-known\fP to ones with the
specified CPU bits (since dpkg 1.17.14). Either \fB32\fP or \fB64\fP.
.TP
.BR \-E ", " \-\-match\-endian " \fIarchitecture-endianness\fP"
Restrict the architectures listed by \fB\-\-list\-known\fP to ones with the
specified endianness (since dpkg 1.17.14). Either \fBlittle\fP or \fBbig\fP.
.TP
.BR \-f ", " \-\-force
Values set by existing environment variables with the same name as used by
the scripts are honored (i.e. used by \fBdpkg\-architecture\fP), except if
this force flag is present. This allows the user
to override a value even when the call to \fBdpkg\-architecture\fP is buried
in some other script (for example \fBdpkg\-buildpackage\fP(1)).
.
.SH TERMS
.IP "build machine" 4
The machine the package is built on.
.IP "host machine" 4
The machine the package is built for.
.IP "target machine" 4
The machine the compiler is building for.
This is only needed when building a cross-toolchain, one that will be built
on the build architecture, to be run on the host architecture, and to build
code for the target architecture.
.IP "Debian architecture" 4
The Debian architecture string, which specifies the binary tree in the
FTP archive. Examples: i386, sparc, hurd\-i386.
.IP "Debian architecture tuple" 4
A Debian architecture tuple is the fully qualified architecture with all its
components spelled out.
This differs with Debian architectures in that at least the \fIcpu\fP
component does not embed the \fIabi\fP.
The current tuple has the form \fIabi\fP\-\fIlibc\fP\-\fIos\fP\-\fIcpu\fP.
Examples: base\-gnu\-linux\-amd64, eabihf\-musl\-linux\-arm.
.IP "Debian architecture wildcard" 4
A Debian architecture wildcard is a special architecture string that will
match any real architecture being part of it.
The general form is a Debian architecture tuple with four or less elements,
and with at least one of them being \fBany\fP.
Missing elements of the tuple are prefixed implicitly as \fBany\fP, and thus
the following pairs are equivalent:
.nf
    \fBany\fP\-\fBany\fP\-\fBany\fP\-\fBany\fP = \fBany\fP
    \fBany\fP\-\fBany\fP\-\fIos\fP\-\fBany\fP = \fIos\fP\-\fBany\fP
    \fBany\fP\-\fIlibc\fP\-\fBany\fP\-\fBany\fP = \fIlibc\fP\-\fBany\fP\-\fBany\fP
.fi
Examples: linux\-any, any\-i386, hurd\-any, eabi\-any\-any\-arm,
musl\-any\-any.
.IP "GNU system type" 4
An architecture specification string consisting of two parts separated by
a hyphen: cpu and system.
Examples: i586\-linux\-gnu, sparc\-linux\-gnu, i686\-gnu, x86_64\-netbsd.
.IP "multiarch triplet" 4
The clarified GNU system type, used for filesystem paths.
This triplet does not change even when the baseline ISA gets bumped,
so that the resulting paths are stable over time.
The only current difference with the GNU system type is that the CPU part
for i386 based systems is always i386.
Examples: i386\-linux\-gnu, x86_64\-linux\-gnu.
Example paths: /lib/powerpc64le-linux-gnu/, /usr/lib/i386-kfreebsd-gnu/.
.
.SH VARIABLES
The following variables are set by \fBdpkg\-architecture\fP (see the
\fBTERMS\fP section for a description of the naming scheme):
.IP "\fBDEB_BUILD_ARCH\fP" 4
The Debian architecture of the build machine.
.IP "\fBDEB_BUILD_ARCH_ABI\fP" 4
The Debian abi name of the build machine (since dpkg 1.18.11).
.IP "\fBDEB_BUILD_ARCH_LIBC\fP" 4
The Debian libc name of the build machine (since dpkg 1.18.11).
.IP "\fBDEB_BUILD_ARCH_OS\fP" 4
The Debian system name of the build machine (since dpkg 1.13.2).
.IP "\fBDEB_BUILD_ARCH_CPU\fP" 4
The Debian cpu name of the build machine (since dpkg 1.13.2).
.IP "\fBDEB_BUILD_ARCH_BITS\fP" 4
The pointer size of the build machine (in bits; since dpkg 1.15.4).
.IP "\fBDEB_BUILD_ARCH_ENDIAN\fP" 4
The endianness of the build machine (little / big; since dpkg 1.15.4).
.IP "\fBDEB_BUILD_GNU_CPU\fP" 4
The CPU part of \fBDEB_BUILD_GNU_TYPE\fP.
.IP "\fBDEB_BUILD_GNU_SYSTEM\fP" 4
The System part of \fBDEB_BUILD_GNU_TYPE\fP.
.IP "\fBDEB_BUILD_GNU_TYPE\fP" 4
The GNU system type of the build machine.
.IP "\fBDEB_BUILD_MULTIARCH\fP" 4
The clarified GNU system type of the build machine, used for filesystem
paths (since dpkg 1.16.0).
.IP "\fBDEB_HOST_ARCH\fP" 4
The Debian architecture of the host machine.
.IP "\fBDEB_HOST_ARCH_ABI\fP" 4
The Debian abi name of the host machine (since dpkg 1.18.11).
.IP "\fBDEB_HOST_ARCH_LIBC\fP" 4
The Debian libc name of the host machine (since dpkg 1.18.11).
.IP "\fBDEB_HOST_ARCH_OS\fP" 4
The Debian system name of the host machine (since dpkg 1.13.2).
.IP "\fBDEB_HOST_ARCH_CPU\fP" 4
The Debian cpu name of the host machine (since dpkg 1.13.2).
.IP "\fBDEB_HOST_ARCH_BITS\fP" 4
The pointer size of the host machine (in bits; since dpkg 1.15.4).
.IP "\fBDEB_HOST_ARCH_ENDIAN\fP" 4
The endianness of the host machine (little / big; since dpkg 1.15.4).
.IP "\fBDEB_HOST_GNU_CPU\fP" 4
The CPU part of \fBDEB_HOST_GNU_TYPE\fP.
.IP "\fBDEB_HOST_GNU_SYSTEM\fP" 4
The System part of \fBDEB_HOST_GNU_TYPE\fP.
.IP "\fBDEB_HOST_GNU_TYPE\fP" 4
The GNU system type of the host machine.
.IP "\fBDEB_HOST_MULTIARCH\fP" 4
The clarified GNU system type of the host machine, used for filesystem
paths (since dpkg 1.16.0).
.IP "\fBDEB_TARGET_ARCH\fP" 4
The Debian architecture of the target machine (since dpkg 1.17.14).
.IP "\fBDEB_TARGET_ARCH_ABI\fP" 4
The Debian abi name of the target machine (since dpkg 1.18.11).
.IP "\fBDEB_TARGET_ARCH_LIBC\fP" 4
The Debian libc name of the target machine (since dpkg 1.18.11).
.IP "\fBDEB_TARGET_ARCH_OS\fP" 4
The Debian system name of the target machine (since dpkg 1.17.14).
.IP "\fBDEB_TARGET_ARCH_CPU\fP" 4
The Debian cpu name of the target machine (since dpkg 1.17.14).
.IP "\fBDEB_TARGET_ARCH_BITS\fP" 4
The pointer size of the target machine (in bits; since dpkg 1.17.14).
.IP "\fBDEB_TARGET_ARCH_ENDIAN\fP" 4
The endianness of the target machine (little / big; since dpkg 1.17.14).
.IP "\fBDEB_TARGET_GNU_CPU\fP" 4
The CPU part of \fBDEB_TARGET_GNU_TYPE\fP (since dpkg 1.17.14).
.IP "\fBDEB_TARGET_GNU_SYSTEM\fP" 4
The System part of \fBDEB_TARGET_GNU_TYPE\fP (since dpkg 1.17.14).
.IP "\fBDEB_TARGET_GNU_TYPE\fP" 4
The GNU system type of the target machine (since dpkg 1.17.14).
.IP "\fBDEB_TARGET_MULTIARCH\fP" 4
The clarified GNU system type of the target machine, used for filesystem
paths (since dpkg 1.17.14).
.
.SH FILES
.SS Architecture tables
All these files have to be present for \fBdpkg\-architecture\fP to
work. Their location can be overridden at runtime with the environment
variable \fBDPKG_DATADIR\fP.
These tables contain a format \fBVersion\fP pseudo-field on their first
line to mark their format, so that parsers can check if they understand
it, such as "# Version=1.0".
.TP
.I %PKGDATADIR%/cputable
Table of known CPU names and mapping to their GNU name.
Format version 1.0 (since dpkg 1.13.2).
.TP
.I %PKGDATADIR%/ostable
Table of known operating system names and mapping to their GNU name.
Format version 2.0 (since dpkg 1.18.11).
.TP
.I %PKGDATADIR%/tupletable
Mapping between Debian architecture tuples and Debian architecture
names.
Format version 1.0 (since dpkg 1.18.11).
.TP
.I %PKGDATADIR%/abitable
Table of Debian architecture ABI attribute overrides.
Format version 2.0 (since dpkg 1.18.11).
.SS Packaging support
.TP
.I %PKGDATADIR%/architecture.mk
Makefile snippet that properly sets and exports all the variables that
\fBdpkg\-architecture\fP outputs (since dpkg 1.16.1).
.
.SH EXAMPLES
\fBdpkg\-buildpackage\fP accepts the \fB\-a\fR option and passes it to
\fBdpkg\-architecture\fP. Other examples:
.IP
CC=i386\-gnu\-gcc dpkg\-architecture \-c debian/rules build
.IP
eval \`dpkg\-architecture \-u\`
.PP
Check if the current or specified host architecture is equal to an
architecture:
.IP
dpkg\-architecture \-elinux\-alpha
.IP
dpkg\-architecture \-amips \-elinux\-mips
.PP
Check if the current or specified host architecture is a Linux system:
.IP
dpkg\-architecture \-ilinux\-any
.IP
dpkg\-architecture \-ai386 \-ilinux\-any
.
.SS Usage in debian/rules
The environment variables set by \fBdpkg\-architecture\fP are passed to
\fIdebian/rules\fP as make variables (see make documentation). However,
you should not rely on them, as this breaks manual invocation of the
script. Instead, you should always initialize them using
\fBdpkg\-architecture\fP with the \fB\-q\fP option. Here are some examples,
which also show how you can improve the cross compilation support in your
package:
.PP
Retrieving the GNU system type and forwarding it to ./configure:
.PP
.RS 4
.nf
DEB_BUILD_GNU_TYPE ?= $(shell dpkg\-architecture \-qDEB_BUILD_GNU_TYPE)
DEB_HOST_GNU_TYPE ?= $(shell dpkg\-architecture \-qDEB_HOST_GNU_TYPE)
[...]
ifeq ($(DEB_BUILD_GNU_TYPE), $(DEB_HOST_GNU_TYPE))
  confflags += \-\-build=$(DEB_HOST_GNU_TYPE)
else
  confflags += \-\-build=$(DEB_BUILD_GNU_TYPE) \\
               \-\-host=$(DEB_HOST_GNU_TYPE)
endif
[...]
\&./configure $(confflags)
.fi
.RE
.PP
Doing something only for a specific architecture:
.PP
.RS 4
.nf
DEB_HOST_ARCH ?= $(shell dpkg\-architecture \-qDEB_HOST_ARCH)

ifeq ($(DEB_HOST_ARCH),alpha)
  [...]
endif
.fi
.RE
.PP
or if you only need to check the CPU or OS type, use the
\fBDEB_HOST_ARCH_CPU\fP or \fBDEB_HOST_ARCH_OS\fP variables.
.PP
Note that you can also rely on an external Makefile snippet to properly
set all the variables that \fBdpkg\-architecture\fP can provide:
.PP
.RS 4
.nf
include %PKGDATADIR%/architecture.mk

ifeq ($(DEB_HOST_ARCH),alpha)
  [...]
endif
.fi
.RE
.PP
In any case, you should never use \fBdpkg \-\-print\-architecture\fP to get
architecture information during a package build.
.
.SH ENVIRONMENT
.TP
.B DPKG_DATADIR
If set, it will be used as the \fBdpkg\fP data directory, where the
architecture tables are located (since dpkg 1.14.17).
Defaults to «%PKGDATADIR%».
.TP
.B DPKG_COLORS
Sets the color mode (since dpkg 1.18.5).
The currently accepted values are: \fBauto\fP (default), \fBalways\fP and
\fBnever\fP.
.TP
.B DPKG_NLS
If set, it will be used to decide whether to activate Native Language Support,
also known as internationalization (or i18n) support (since dpkg 1.19.0).
The accepted values are: \fB0\fP and \fB1\fP (default).
.
.SH NOTES
All long command and option names available only since dpkg 1.17.17.
.
.SH SEE ALSO
.BR dpkg\-buildpackage (1).
