; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -O2 -mtriple=x86_64-linux-android -mattr=+mmx -enable-legalize-types-checking | FileCheck %s
; RUN: llc < %s -O2 -mtriple=x86_64-linux-gnu -mattr=+mmx -enable-legalize-types-checking | FileCheck %s

; Test the softened result of extractelement op code.
define fp128 @TestExtract(<2 x double> %x) nounwind {
; CHECK-LABEL: TestExtract:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subq $40, %rsp
; CHECK-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; CHECK-NEXT:    callq __extenddftf2
; CHECK-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; CHECK-NEXT:    callq __extenddftf2
; CHECK-NEXT:    movaps %xmm0, %xmm1
; CHECK-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; CHECK-NEXT:    addq $40, %rsp
; CHECK-NEXT:    jmp __multf3 # TAILCALL
entry:
  ; Simplified instruction pattern from the output of llvm before r289042,
  ; for a boost function ...::insert<...>::traverse<...>().
  %a = fpext <2 x double> %x to <2 x fp128>
  %0 = extractelement <2 x fp128> %a, i32 0
  %1 = extractelement <2 x fp128> %a, i32 1
  %2 = fmul fp128 %0, %1
  ret fp128 %2
}
