; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -mtriple=amdgcn-amd-amdhsa -instcombine -S | FileCheck %s

; Simplify to +0.0.
define float @test_zero(float %x) {
; CHECK-LABEL: @test_zero(
; CHECK-NEXT:    ret float 0.000000e+00
;
  %call = call float @llvm.amdgcn.fmul.legacy(float %x, float 0.0)
  ret float %call
}

; Simplify to +0.0.
define float @test_negzero(float %y) {
; CHECK-LABEL: @test_negzero(
; CHECK-NEXT:    ret float 0.000000e+00
;
  %call = call float @llvm.amdgcn.fmul.legacy(float -0.0, float %y)
  ret float %call
}

; Combine to fmul because the constant is finite and non-zero.
define float @test_const(float %x) {
; CHECK-LABEL: @test_const(
; CHECK-NEXT:    [[CALL:%.*]] = fmul float [[X:%.*]], 9.950000e+01
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.amdgcn.fmul.legacy(float %x, float 99.5)
  ret float %call
}

; Combine to fmul because the constant is finite and non-zero, preserving fmf.
define float @test_const_fmf(float %x) {
; CHECK-LABEL: @test_const_fmf(
; CHECK-NEXT:    [[CALL:%.*]] = fmul contract float [[X:%.*]], 9.950000e+01
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call contract float @llvm.amdgcn.fmul.legacy(float %x, float 99.5)
  ret float %call
}

; Combine to fmul because neither argument can be infinity or NaN.
define float @test_finite(i32 %x, i32 %y) {
; CHECK-LABEL: @test_finite(
; CHECK-NEXT:    [[XF:%.*]] = sitofp i32 [[X:%.*]] to float
; CHECK-NEXT:    [[YF:%.*]] = sitofp i32 [[Y:%.*]] to float
; CHECK-NEXT:    [[CALL:%.*]] = fmul float [[XF]], [[YF]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %xf = sitofp i32 %x to float
  %yf = sitofp i32 %y to float
  %call = call float @llvm.amdgcn.fmul.legacy(float %xf, float %yf)
  ret float %call
}

declare float @llvm.amdgcn.fmul.legacy(float, float)
