; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-POSTP8,CHECK-P10
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-POSTP8,CHECK-P10
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-POSTP8,CHECK-PREP10,CHECK-P9
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-POSTP8,CHECK-PREP10,CHECK-P9
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr8 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-PREP10,CHECK-P8
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr8 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-PREP10,CHECK-P8

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_0_double_uint8_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_0_double_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    lxsibzx f0, 0, r3
; CHECK-POSTP8-NEXT:    xscvuxddp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_0_double_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lbz r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to i8*
  %1 = load i8, i8* %0, align 1
  %conv = uitofp i8 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_align16_double_uint8_t(i8* nocapture readonly %ptr) {
; CHECK-POSTP8-LABEL: ld_align16_double_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    addi r3, r3, 8
; CHECK-POSTP8-NEXT:    lxsibzx f0, 0, r3
; CHECK-POSTP8-NEXT:    xscvuxddp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_align16_double_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lbz r3, 8(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 8
  %0 = load i8, i8* %add.ptr, align 1
  %conv = uitofp i8 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_align32_double_uint8_t(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_double_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    lxsibzx f0, r3, r4
; CHECK-P10-NEXT:    xscvuxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_align32_double_uint8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 1525
; CHECK-P9-NEXT:    ori r4, r4, 56600
; CHECK-P9-NEXT:    lxsibzx f0, r3, r4
; CHECK-P9-NEXT:    xscvuxddp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_align32_double_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, 1525
; CHECK-P8-NEXT:    ori r4, r4, 56600
; CHECK-P8-NEXT:    lbzx r3, r3, r4
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999000
  %0 = load i8, i8* %add.ptr, align 1
  %conv = uitofp i8 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_align64_double_uint8_t(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_double_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lxsibzx f0, r3, r4
; CHECK-P10-NEXT:    xscvuxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_align64_double_uint8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    lxsibzx f0, r3, r4
; CHECK-P9-NEXT:    xscvuxddp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_align64_double_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    lbzx r3, r3, r4
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000000
  %0 = load i8, i8* %add.ptr, align 1
  %conv = uitofp i8 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_reg_double_uint8_t(i8* nocapture readonly %ptr, i64 %off) {
; CHECK-POSTP8-LABEL: ld_reg_double_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    lxsibzx f0, r3, r4
; CHECK-POSTP8-NEXT:    xscvuxddp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_reg_double_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lbzx r3, r3, r4
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %off
  %0 = load i8, i8* %add.ptr, align 1
  %conv = uitofp i8 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_or_double_uint8_t(i64 %ptr, i8 zeroext %off) {
; CHECK-POSTP8-LABEL: ld_or_double_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    or r3, r4, r3
; CHECK-POSTP8-NEXT:    lxsibzx f0, 0, r3
; CHECK-POSTP8-NEXT:    xscvuxddp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_or_double_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    or r3, r4, r3
; CHECK-P8-NEXT:    lbz r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to i8*
  %1 = load i8, i8* %0, align 1
  %conv1 = uitofp i8 %1 to double
  ret double %conv1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_not_disjoint16_double_uint8_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_not_disjoint16_double_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    ori r3, r3, 6
; CHECK-POSTP8-NEXT:    lxsibzx f0, 0, r3
; CHECK-POSTP8-NEXT:    xscvuxddp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_not_disjoint16_double_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    ori r3, r3, 6
; CHECK-P8-NEXT:    lbz r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to i8*
  %1 = load i8, i8* %0, align 1
  %conv = uitofp i8 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_disjoint_align16_double_uint8_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_disjoint_align16_double_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-POSTP8-NEXT:    ori r3, r3, 24
; CHECK-POSTP8-NEXT:    lxsibzx f0, 0, r3
; CHECK-POSTP8-NEXT:    xscvuxddp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align16_double_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-NEXT:    lbz r3, 24(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to i8*
  %1 = load i8, i8* %0, align 8
  %conv = uitofp i8 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_not_disjoint32_double_uint8_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_not_disjoint32_double_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    ori r3, r3, 34463
; CHECK-POSTP8-NEXT:    oris r3, r3, 1
; CHECK-POSTP8-NEXT:    lxsibzx f0, 0, r3
; CHECK-POSTP8-NEXT:    xscvuxddp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_not_disjoint32_double_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    ori r3, r3, 34463
; CHECK-P8-NEXT:    oris r3, r3, 1
; CHECK-P8-NEXT:    lbz r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to i8*
  %1 = load i8, i8* %0, align 1
  %conv = uitofp i8 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_disjoint_align32_double_uint8_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_double_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    lxsibzx f0, r3, r4
; CHECK-P10-NEXT:    xscvuxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_align32_double_uint8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    lxsibzx f0, r3, r4
; CHECK-P9-NEXT:    xscvuxddp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align32_double_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r5, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r4, r5, 41712
; CHECK-P8-NEXT:    lbzx r3, r3, r4
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to i8*
  %1 = load i8, i8* %0, align 16
  %conv = uitofp i8 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_not_disjoint64_double_uint8_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_double_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lxsibzx f0, 0, r3
; CHECK-P10-NEXT:    xscvuxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_not_disjoint64_double_uint8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 29
; CHECK-P9-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-NEXT:    oris r4, r4, 54437
; CHECK-P9-NEXT:    ori r4, r4, 4097
; CHECK-P9-NEXT:    or r3, r3, r4
; CHECK-P9-NEXT:    lxsibzx f0, 0, r3
; CHECK-P9-NEXT:    xscvuxddp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_not_disjoint64_double_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r4, 29
; CHECK-P8-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-NEXT:    oris r4, r4, 54437
; CHECK-P8-NEXT:    ori r4, r4, 4097
; CHECK-P8-NEXT:    or r3, r3, r4
; CHECK-P8-NEXT:    lbz r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to i8*
  %1 = load i8, i8* %0, align 1
  %conv = uitofp i8 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_disjoint_align64_double_uint8_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_double_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lxsibzx f0, r3, r4
; CHECK-P10-NEXT:    xscvuxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_align64_double_uint8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    lxsibzx f0, r3, r4
; CHECK-P9-NEXT:    xscvuxddp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align64_double_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    lbzx r3, r3, r4
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to i8*
  %1 = load i8, i8* %0, align 4096
  %conv = uitofp i8 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_cst_align16_double_uint8_t() {
; CHECK-POSTP8-LABEL: ld_cst_align16_double_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    li r3, 4080
; CHECK-POSTP8-NEXT:    lxsibzx f0, 0, r3
; CHECK-POSTP8-NEXT:    xscvuxddp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_cst_align16_double_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lbz r3, 4080(0)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i8, i8* inttoptr (i64 4080 to i8*), align 16
  %conv = uitofp i8 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_cst_align32_double_uint8_t() {
; CHECK-P10-LABEL: ld_cst_align32_double_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 9999900
; CHECK-P10-NEXT:    lxsibzx f0, 0, r3
; CHECK-P10-NEXT:    xscvuxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_cst_align32_double_uint8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r3, 152
; CHECK-P9-NEXT:    ori r3, r3, 38428
; CHECK-P9-NEXT:    lxsibzx f0, 0, r3
; CHECK-P9-NEXT:    xscvuxddp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_cst_align32_double_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r3, 153
; CHECK-P8-NEXT:    lbz r3, -27108(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i8, i8* inttoptr (i64 9999900 to i8*), align 4
  %conv = uitofp i8 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_cst_align64_double_uint8_t() {
; CHECK-P10-LABEL: ld_cst_align64_double_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lxsibzx f0, 0, r3
; CHECK-P10-NEXT:    xscvuxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_cst_align64_double_uint8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r3, 3725
; CHECK-P9-NEXT:    ori r3, r3, 19025
; CHECK-P9-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-NEXT:    lxsibzx f0, 0, r3
; CHECK-P9-NEXT:    xscvuxddp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_cst_align64_double_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r3, 3725
; CHECK-P8-NEXT:    ori r3, r3, 19025
; CHECK-P8-NEXT:    rldic r3, r3, 12, 24
; CHECK-P8-NEXT:    lbz r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i8, i8* inttoptr (i64 1000000000000 to i8*), align 4096
  %conv = uitofp i8 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_0_double_int8_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_0_double_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    lxsibzx v2, 0, r3
; CHECK-POSTP8-NEXT:    vextsb2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxddp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_0_double_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lbz r3, 0(r3)
; CHECK-P8-NEXT:    extsb r3, r3
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to i8*
  %1 = load i8, i8* %0, align 1
  %conv = sitofp i8 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_align16_double_int8_t(i8* nocapture readonly %ptr) {
; CHECK-POSTP8-LABEL: ld_align16_double_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    addi r3, r3, 8
; CHECK-POSTP8-NEXT:    lxsibzx v2, 0, r3
; CHECK-POSTP8-NEXT:    vextsb2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxddp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_align16_double_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lbz r3, 8(r3)
; CHECK-P8-NEXT:    extsb r3, r3
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 8
  %0 = load i8, i8* %add.ptr, align 1
  %conv = sitofp i8 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_align32_double_int8_t(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_double_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    lxsibzx v2, r3, r4
; CHECK-P10-NEXT:    vextsb2d v2, v2
; CHECK-P10-NEXT:    xscvsxddp f1, v2
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_align32_double_int8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 1525
; CHECK-P9-NEXT:    ori r4, r4, 56600
; CHECK-P9-NEXT:    lxsibzx v2, r3, r4
; CHECK-P9-NEXT:    vextsb2d v2, v2
; CHECK-P9-NEXT:    xscvsxddp f1, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_align32_double_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, 1525
; CHECK-P8-NEXT:    ori r4, r4, 56600
; CHECK-P8-NEXT:    lbzx r3, r3, r4
; CHECK-P8-NEXT:    extsb r3, r3
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999000
  %0 = load i8, i8* %add.ptr, align 1
  %conv = sitofp i8 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_align64_double_int8_t(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_double_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lxsibzx v2, r3, r4
; CHECK-P10-NEXT:    vextsb2d v2, v2
; CHECK-P10-NEXT:    xscvsxddp f1, v2
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_align64_double_int8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    lxsibzx v2, r3, r4
; CHECK-P9-NEXT:    vextsb2d v2, v2
; CHECK-P9-NEXT:    xscvsxddp f1, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_align64_double_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    lbzx r3, r3, r4
; CHECK-P8-NEXT:    extsb r3, r3
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000000
  %0 = load i8, i8* %add.ptr, align 1
  %conv = sitofp i8 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_reg_double_int8_t(i8* nocapture readonly %ptr, i64 %off) {
; CHECK-POSTP8-LABEL: ld_reg_double_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    lxsibzx v2, r3, r4
; CHECK-POSTP8-NEXT:    vextsb2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxddp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_reg_double_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lbzx r3, r3, r4
; CHECK-P8-NEXT:    extsb r3, r3
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %off
  %0 = load i8, i8* %add.ptr, align 1
  %conv = sitofp i8 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_or_double_int8_t(i64 %ptr, i8 zeroext %off) {
; CHECK-POSTP8-LABEL: ld_or_double_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    or r3, r4, r3
; CHECK-POSTP8-NEXT:    lxsibzx v2, 0, r3
; CHECK-POSTP8-NEXT:    vextsb2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxddp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_or_double_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    or r3, r4, r3
; CHECK-P8-NEXT:    lbz r3, 0(r3)
; CHECK-P8-NEXT:    extsb r3, r3
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to i8*
  %1 = load i8, i8* %0, align 1
  %conv1 = sitofp i8 %1 to double
  ret double %conv1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_not_disjoint16_double_int8_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_not_disjoint16_double_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    ori r3, r3, 6
; CHECK-POSTP8-NEXT:    lxsibzx v2, 0, r3
; CHECK-POSTP8-NEXT:    vextsb2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxddp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_not_disjoint16_double_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    ori r3, r3, 6
; CHECK-P8-NEXT:    lbz r3, 0(r3)
; CHECK-P8-NEXT:    extsb r3, r3
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to i8*
  %1 = load i8, i8* %0, align 1
  %conv = sitofp i8 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_disjoint_align16_double_int8_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_disjoint_align16_double_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-POSTP8-NEXT:    ori r3, r3, 24
; CHECK-POSTP8-NEXT:    lxsibzx v2, 0, r3
; CHECK-POSTP8-NEXT:    vextsb2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxddp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align16_double_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-NEXT:    lbz r3, 24(r3)
; CHECK-P8-NEXT:    extsb r3, r3
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to i8*
  %1 = load i8, i8* %0, align 8
  %conv = sitofp i8 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_not_disjoint32_double_int8_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_not_disjoint32_double_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    ori r3, r3, 34463
; CHECK-POSTP8-NEXT:    oris r3, r3, 1
; CHECK-POSTP8-NEXT:    lxsibzx v2, 0, r3
; CHECK-POSTP8-NEXT:    vextsb2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxddp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_not_disjoint32_double_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    ori r3, r3, 34463
; CHECK-P8-NEXT:    oris r3, r3, 1
; CHECK-P8-NEXT:    lbz r3, 0(r3)
; CHECK-P8-NEXT:    extsb r3, r3
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to i8*
  %1 = load i8, i8* %0, align 1
  %conv = sitofp i8 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_disjoint_align32_double_int8_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_double_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    lxsibzx v2, r3, r4
; CHECK-P10-NEXT:    vextsb2d v2, v2
; CHECK-P10-NEXT:    xscvsxddp f1, v2
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_align32_double_int8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    lxsibzx v2, r3, r4
; CHECK-P9-NEXT:    vextsb2d v2, v2
; CHECK-P9-NEXT:    xscvsxddp f1, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align32_double_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r5, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r4, r5, 41712
; CHECK-P8-NEXT:    lbzx r3, r3, r4
; CHECK-P8-NEXT:    extsb r3, r3
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to i8*
  %1 = load i8, i8* %0, align 16
  %conv = sitofp i8 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_not_disjoint64_double_int8_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_double_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lxsibzx v2, 0, r3
; CHECK-P10-NEXT:    vextsb2d v2, v2
; CHECK-P10-NEXT:    xscvsxddp f1, v2
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_not_disjoint64_double_int8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 29
; CHECK-P9-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-NEXT:    oris r4, r4, 54437
; CHECK-P9-NEXT:    ori r4, r4, 4097
; CHECK-P9-NEXT:    or r3, r3, r4
; CHECK-P9-NEXT:    lxsibzx v2, 0, r3
; CHECK-P9-NEXT:    vextsb2d v2, v2
; CHECK-P9-NEXT:    xscvsxddp f1, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_not_disjoint64_double_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r4, 29
; CHECK-P8-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-NEXT:    oris r4, r4, 54437
; CHECK-P8-NEXT:    ori r4, r4, 4097
; CHECK-P8-NEXT:    or r3, r3, r4
; CHECK-P8-NEXT:    lbz r3, 0(r3)
; CHECK-P8-NEXT:    extsb r3, r3
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to i8*
  %1 = load i8, i8* %0, align 1
  %conv = sitofp i8 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_disjoint_align64_double_int8_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_double_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lxsibzx v2, r3, r4
; CHECK-P10-NEXT:    vextsb2d v2, v2
; CHECK-P10-NEXT:    xscvsxddp f1, v2
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_align64_double_int8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    lxsibzx v2, r3, r4
; CHECK-P9-NEXT:    vextsb2d v2, v2
; CHECK-P9-NEXT:    xscvsxddp f1, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align64_double_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    lbzx r3, r3, r4
; CHECK-P8-NEXT:    extsb r3, r3
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to i8*
  %1 = load i8, i8* %0, align 4096
  %conv = sitofp i8 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_cst_align16_double_int8_t() {
; CHECK-POSTP8-LABEL: ld_cst_align16_double_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    li r3, 4080
; CHECK-POSTP8-NEXT:    lxsibzx v2, 0, r3
; CHECK-POSTP8-NEXT:    vextsb2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxddp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_cst_align16_double_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lbz r3, 4080(0)
; CHECK-P8-NEXT:    extsb r3, r3
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i8, i8* inttoptr (i64 4080 to i8*), align 16
  %conv = sitofp i8 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_cst_align32_double_int8_t() {
; CHECK-P10-LABEL: ld_cst_align32_double_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 9999900
; CHECK-P10-NEXT:    lxsibzx v2, 0, r3
; CHECK-P10-NEXT:    vextsb2d v2, v2
; CHECK-P10-NEXT:    xscvsxddp f1, v2
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_cst_align32_double_int8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r3, 152
; CHECK-P9-NEXT:    ori r3, r3, 38428
; CHECK-P9-NEXT:    lxsibzx v2, 0, r3
; CHECK-P9-NEXT:    vextsb2d v2, v2
; CHECK-P9-NEXT:    xscvsxddp f1, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_cst_align32_double_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r3, 153
; CHECK-P8-NEXT:    lbz r3, -27108(r3)
; CHECK-P8-NEXT:    extsb r3, r3
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i8, i8* inttoptr (i64 9999900 to i8*), align 4
  %conv = sitofp i8 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_cst_align64_double_int8_t() {
; CHECK-P10-LABEL: ld_cst_align64_double_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lxsibzx v2, 0, r3
; CHECK-P10-NEXT:    vextsb2d v2, v2
; CHECK-P10-NEXT:    xscvsxddp f1, v2
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_cst_align64_double_int8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r3, 3725
; CHECK-P9-NEXT:    ori r3, r3, 19025
; CHECK-P9-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-NEXT:    lxsibzx v2, 0, r3
; CHECK-P9-NEXT:    vextsb2d v2, v2
; CHECK-P9-NEXT:    xscvsxddp f1, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_cst_align64_double_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r3, 3725
; CHECK-P8-NEXT:    ori r3, r3, 19025
; CHECK-P8-NEXT:    rldic r3, r3, 12, 24
; CHECK-P8-NEXT:    lbz r3, 0(r3)
; CHECK-P8-NEXT:    extsb r3, r3
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i8, i8* inttoptr (i64 1000000000000 to i8*), align 4096
  %conv = sitofp i8 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_0_double_uint16_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_0_double_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    lxsihzx f0, 0, r3
; CHECK-POSTP8-NEXT:    xscvuxddp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_0_double_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lhz r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to i16*
  %1 = load i16, i16* %0, align 2
  %conv = uitofp i16 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_align16_double_uint16_t(i8* nocapture readonly %ptr) {
; CHECK-POSTP8-LABEL: ld_align16_double_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    addi r3, r3, 8
; CHECK-POSTP8-NEXT:    lxsihzx f0, 0, r3
; CHECK-POSTP8-NEXT:    xscvuxddp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_align16_double_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lhz r3, 8(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 8
  %0 = bitcast i8* %add.ptr to i16*
  %1 = load i16, i16* %0, align 2
  %conv = uitofp i16 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_align32_double_uint16_t(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_double_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    lxsihzx f0, r3, r4
; CHECK-P10-NEXT:    xscvuxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_align32_double_uint16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 1525
; CHECK-P9-NEXT:    ori r4, r4, 56600
; CHECK-P9-NEXT:    lxsihzx f0, r3, r4
; CHECK-P9-NEXT:    xscvuxddp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_align32_double_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, 1525
; CHECK-P8-NEXT:    ori r4, r4, 56600
; CHECK-P8-NEXT:    lhzx r3, r3, r4
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999000
  %0 = bitcast i8* %add.ptr to i16*
  %1 = load i16, i16* %0, align 2
  %conv = uitofp i16 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_align64_double_uint16_t(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_double_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lxsihzx f0, r3, r4
; CHECK-P10-NEXT:    xscvuxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_align64_double_uint16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    lxsihzx f0, r3, r4
; CHECK-P9-NEXT:    xscvuxddp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_align64_double_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    lhzx r3, r3, r4
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000000
  %0 = bitcast i8* %add.ptr to i16*
  %1 = load i16, i16* %0, align 2
  %conv = uitofp i16 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_reg_double_uint16_t(i8* nocapture readonly %ptr, i64 %off) {
; CHECK-POSTP8-LABEL: ld_reg_double_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    lxsihzx f0, r3, r4
; CHECK-POSTP8-NEXT:    xscvuxddp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_reg_double_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lhzx r3, r3, r4
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %off
  %0 = bitcast i8* %add.ptr to i16*
  %1 = load i16, i16* %0, align 2
  %conv = uitofp i16 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_or_double_uint16_t(i64 %ptr, i8 zeroext %off) {
; CHECK-POSTP8-LABEL: ld_or_double_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    or r3, r4, r3
; CHECK-POSTP8-NEXT:    lxsihzx f0, 0, r3
; CHECK-POSTP8-NEXT:    xscvuxddp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_or_double_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    or r3, r4, r3
; CHECK-P8-NEXT:    lhz r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to i16*
  %1 = load i16, i16* %0, align 2
  %conv1 = uitofp i16 %1 to double
  ret double %conv1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_not_disjoint16_double_uint16_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_not_disjoint16_double_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    ori r3, r3, 6
; CHECK-POSTP8-NEXT:    lxsihzx f0, 0, r3
; CHECK-POSTP8-NEXT:    xscvuxddp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_not_disjoint16_double_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    ori r3, r3, 6
; CHECK-P8-NEXT:    lhz r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to i16*
  %1 = load i16, i16* %0, align 2
  %conv = uitofp i16 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_disjoint_align16_double_uint16_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_disjoint_align16_double_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-POSTP8-NEXT:    ori r3, r3, 24
; CHECK-POSTP8-NEXT:    lxsihzx f0, 0, r3
; CHECK-POSTP8-NEXT:    xscvuxddp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align16_double_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-NEXT:    lhz r3, 24(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to i16*
  %1 = load i16, i16* %0, align 8
  %conv = uitofp i16 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_not_disjoint32_double_uint16_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_not_disjoint32_double_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    ori r3, r3, 34463
; CHECK-POSTP8-NEXT:    oris r3, r3, 1
; CHECK-POSTP8-NEXT:    lxsihzx f0, 0, r3
; CHECK-POSTP8-NEXT:    xscvuxddp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_not_disjoint32_double_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    ori r3, r3, 34463
; CHECK-P8-NEXT:    oris r3, r3, 1
; CHECK-P8-NEXT:    lhz r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to i16*
  %1 = load i16, i16* %0, align 2
  %conv = uitofp i16 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_disjoint_align32_double_uint16_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_double_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    lxsihzx f0, r3, r4
; CHECK-P10-NEXT:    xscvuxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_align32_double_uint16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    lxsihzx f0, r3, r4
; CHECK-P9-NEXT:    xscvuxddp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align32_double_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r5, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r4, r5, 41712
; CHECK-P8-NEXT:    lhzx r3, r3, r4
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to i16*
  %1 = load i16, i16* %0, align 16
  %conv = uitofp i16 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_not_disjoint64_double_uint16_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_double_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lxsihzx f0, 0, r3
; CHECK-P10-NEXT:    xscvuxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_not_disjoint64_double_uint16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 29
; CHECK-P9-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-NEXT:    oris r4, r4, 54437
; CHECK-P9-NEXT:    ori r4, r4, 4097
; CHECK-P9-NEXT:    or r3, r3, r4
; CHECK-P9-NEXT:    lxsihzx f0, 0, r3
; CHECK-P9-NEXT:    xscvuxddp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_not_disjoint64_double_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r4, 29
; CHECK-P8-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-NEXT:    oris r4, r4, 54437
; CHECK-P8-NEXT:    ori r4, r4, 4097
; CHECK-P8-NEXT:    or r3, r3, r4
; CHECK-P8-NEXT:    lhz r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to i16*
  %1 = load i16, i16* %0, align 2
  %conv = uitofp i16 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_disjoint_align64_double_uint16_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_double_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lxsihzx f0, r3, r4
; CHECK-P10-NEXT:    xscvuxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_align64_double_uint16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    lxsihzx f0, r3, r4
; CHECK-P9-NEXT:    xscvuxddp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align64_double_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    lhzx r3, r3, r4
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to i16*
  %1 = load i16, i16* %0, align 4096
  %conv = uitofp i16 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_cst_align16_double_uint16_t() {
; CHECK-POSTP8-LABEL: ld_cst_align16_double_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    li r3, 4080
; CHECK-POSTP8-NEXT:    lxsihzx f0, 0, r3
; CHECK-POSTP8-NEXT:    xscvuxddp f1, f0
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_cst_align16_double_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lhz r3, 4080(0)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i16, i16* inttoptr (i64 4080 to i16*), align 16
  %conv = uitofp i16 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_cst_align32_double_uint16_t() {
; CHECK-P10-LABEL: ld_cst_align32_double_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 9999900
; CHECK-P10-NEXT:    lxsihzx f0, 0, r3
; CHECK-P10-NEXT:    xscvuxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_cst_align32_double_uint16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r3, 152
; CHECK-P9-NEXT:    ori r3, r3, 38428
; CHECK-P9-NEXT:    lxsihzx f0, 0, r3
; CHECK-P9-NEXT:    xscvuxddp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_cst_align32_double_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r3, 153
; CHECK-P8-NEXT:    lhz r3, -27108(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i16, i16* inttoptr (i64 9999900 to i16*), align 4
  %conv = uitofp i16 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_cst_align64_double_uint16_t() {
; CHECK-P10-LABEL: ld_cst_align64_double_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lxsihzx f0, 0, r3
; CHECK-P10-NEXT:    xscvuxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_cst_align64_double_uint16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r3, 3725
; CHECK-P9-NEXT:    ori r3, r3, 19025
; CHECK-P9-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-NEXT:    lxsihzx f0, 0, r3
; CHECK-P9-NEXT:    xscvuxddp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_cst_align64_double_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r3, 3725
; CHECK-P8-NEXT:    ori r3, r3, 19025
; CHECK-P8-NEXT:    rldic r3, r3, 12, 24
; CHECK-P8-NEXT:    lhz r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwz f0, r3
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i16, i16* inttoptr (i64 1000000000000 to i16*), align 4096
  %conv = uitofp i16 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_0_double_int16_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_0_double_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    lxsihzx v2, 0, r3
; CHECK-POSTP8-NEXT:    vextsh2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxddp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_0_double_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lha r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to i16*
  %1 = load i16, i16* %0, align 2
  %conv = sitofp i16 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_align16_double_int16_t(i8* nocapture readonly %ptr) {
; CHECK-POSTP8-LABEL: ld_align16_double_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    addi r3, r3, 8
; CHECK-POSTP8-NEXT:    lxsihzx v2, 0, r3
; CHECK-POSTP8-NEXT:    vextsh2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxddp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_align16_double_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lha r3, 8(r3)
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 8
  %0 = bitcast i8* %add.ptr to i16*
  %1 = load i16, i16* %0, align 2
  %conv = sitofp i16 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_align32_double_int16_t(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_double_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    lxsihzx v2, r3, r4
; CHECK-P10-NEXT:    vextsh2d v2, v2
; CHECK-P10-NEXT:    xscvsxddp f1, v2
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_align32_double_int16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 1525
; CHECK-P9-NEXT:    ori r4, r4, 56600
; CHECK-P9-NEXT:    lxsihzx v2, r3, r4
; CHECK-P9-NEXT:    vextsh2d v2, v2
; CHECK-P9-NEXT:    xscvsxddp f1, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_align32_double_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, 1525
; CHECK-P8-NEXT:    ori r4, r4, 56600
; CHECK-P8-NEXT:    lhax r3, r3, r4
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999000
  %0 = bitcast i8* %add.ptr to i16*
  %1 = load i16, i16* %0, align 2
  %conv = sitofp i16 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_align64_double_int16_t(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_double_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lxsihzx v2, r3, r4
; CHECK-P10-NEXT:    vextsh2d v2, v2
; CHECK-P10-NEXT:    xscvsxddp f1, v2
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_align64_double_int16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    lxsihzx v2, r3, r4
; CHECK-P9-NEXT:    vextsh2d v2, v2
; CHECK-P9-NEXT:    xscvsxddp f1, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_align64_double_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    lhax r3, r3, r4
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000000
  %0 = bitcast i8* %add.ptr to i16*
  %1 = load i16, i16* %0, align 2
  %conv = sitofp i16 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_reg_double_int16_t(i8* nocapture readonly %ptr, i64 %off) {
; CHECK-POSTP8-LABEL: ld_reg_double_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    lxsihzx v2, r3, r4
; CHECK-POSTP8-NEXT:    vextsh2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxddp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_reg_double_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lhax r3, r3, r4
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %off
  %0 = bitcast i8* %add.ptr to i16*
  %1 = load i16, i16* %0, align 2
  %conv = sitofp i16 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_or_double_int16_t(i64 %ptr, i8 zeroext %off) {
; CHECK-POSTP8-LABEL: ld_or_double_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    or r3, r4, r3
; CHECK-POSTP8-NEXT:    lxsihzx v2, 0, r3
; CHECK-POSTP8-NEXT:    vextsh2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxddp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_or_double_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    or r3, r4, r3
; CHECK-P8-NEXT:    lha r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to i16*
  %1 = load i16, i16* %0, align 2
  %conv1 = sitofp i16 %1 to double
  ret double %conv1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_not_disjoint16_double_int16_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_not_disjoint16_double_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    ori r3, r3, 6
; CHECK-POSTP8-NEXT:    lxsihzx v2, 0, r3
; CHECK-POSTP8-NEXT:    vextsh2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxddp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_not_disjoint16_double_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    ori r3, r3, 6
; CHECK-P8-NEXT:    lha r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to i16*
  %1 = load i16, i16* %0, align 2
  %conv = sitofp i16 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_disjoint_align16_double_int16_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_disjoint_align16_double_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-POSTP8-NEXT:    ori r3, r3, 24
; CHECK-POSTP8-NEXT:    lxsihzx v2, 0, r3
; CHECK-POSTP8-NEXT:    vextsh2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxddp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align16_double_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-NEXT:    lha r3, 24(r3)
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to i16*
  %1 = load i16, i16* %0, align 8
  %conv = sitofp i16 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_not_disjoint32_double_int16_t(i64 %ptr) {
; CHECK-POSTP8-LABEL: ld_not_disjoint32_double_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    ori r3, r3, 34463
; CHECK-POSTP8-NEXT:    oris r3, r3, 1
; CHECK-POSTP8-NEXT:    lxsihzx v2, 0, r3
; CHECK-POSTP8-NEXT:    vextsh2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxddp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_not_disjoint32_double_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    ori r3, r3, 34463
; CHECK-P8-NEXT:    oris r3, r3, 1
; CHECK-P8-NEXT:    lha r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to i16*
  %1 = load i16, i16* %0, align 2
  %conv = sitofp i16 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_disjoint_align32_double_int16_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_double_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    lxsihzx v2, r3, r4
; CHECK-P10-NEXT:    vextsh2d v2, v2
; CHECK-P10-NEXT:    xscvsxddp f1, v2
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_align32_double_int16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    lxsihzx v2, r3, r4
; CHECK-P9-NEXT:    vextsh2d v2, v2
; CHECK-P9-NEXT:    xscvsxddp f1, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align32_double_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r5, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r4, r5, 41712
; CHECK-P8-NEXT:    lhax r3, r3, r4
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to i16*
  %1 = load i16, i16* %0, align 16
  %conv = sitofp i16 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_not_disjoint64_double_int16_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_double_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lxsihzx v2, 0, r3
; CHECK-P10-NEXT:    vextsh2d v2, v2
; CHECK-P10-NEXT:    xscvsxddp f1, v2
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_not_disjoint64_double_int16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 29
; CHECK-P9-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-NEXT:    oris r4, r4, 54437
; CHECK-P9-NEXT:    ori r4, r4, 4097
; CHECK-P9-NEXT:    or r3, r3, r4
; CHECK-P9-NEXT:    lxsihzx v2, 0, r3
; CHECK-P9-NEXT:    vextsh2d v2, v2
; CHECK-P9-NEXT:    xscvsxddp f1, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_not_disjoint64_double_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r4, 29
; CHECK-P8-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-NEXT:    oris r4, r4, 54437
; CHECK-P8-NEXT:    ori r4, r4, 4097
; CHECK-P8-NEXT:    or r3, r3, r4
; CHECK-P8-NEXT:    lha r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to i16*
  %1 = load i16, i16* %0, align 2
  %conv = sitofp i16 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_disjoint_align64_double_int16_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_double_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lxsihzx v2, r3, r4
; CHECK-P10-NEXT:    vextsh2d v2, v2
; CHECK-P10-NEXT:    xscvsxddp f1, v2
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_align64_double_int16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    lxsihzx v2, r3, r4
; CHECK-P9-NEXT:    vextsh2d v2, v2
; CHECK-P9-NEXT:    xscvsxddp f1, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align64_double_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    lhax r3, r3, r4
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to i16*
  %1 = load i16, i16* %0, align 4096
  %conv = sitofp i16 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_cst_align16_double_int16_t() {
; CHECK-POSTP8-LABEL: ld_cst_align16_double_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    li r3, 4080
; CHECK-POSTP8-NEXT:    lxsihzx v2, 0, r3
; CHECK-POSTP8-NEXT:    vextsh2d v2, v2
; CHECK-POSTP8-NEXT:    xscvsxddp f1, v2
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: ld_cst_align16_double_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lha r3, 4080(0)
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i16, i16* inttoptr (i64 4080 to i16*), align 16
  %conv = sitofp i16 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_cst_align32_double_int16_t() {
; CHECK-P10-LABEL: ld_cst_align32_double_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 9999900
; CHECK-P10-NEXT:    lxsihzx v2, 0, r3
; CHECK-P10-NEXT:    vextsh2d v2, v2
; CHECK-P10-NEXT:    xscvsxddp f1, v2
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_cst_align32_double_int16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r3, 152
; CHECK-P9-NEXT:    ori r3, r3, 38428
; CHECK-P9-NEXT:    lxsihzx v2, 0, r3
; CHECK-P9-NEXT:    vextsh2d v2, v2
; CHECK-P9-NEXT:    xscvsxddp f1, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_cst_align32_double_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r3, 153
; CHECK-P8-NEXT:    lha r3, -27108(r3)
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i16, i16* inttoptr (i64 9999900 to i16*), align 4
  %conv = sitofp i16 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_cst_align64_double_int16_t() {
; CHECK-P10-LABEL: ld_cst_align64_double_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lxsihzx v2, 0, r3
; CHECK-P10-NEXT:    vextsh2d v2, v2
; CHECK-P10-NEXT:    xscvsxddp f1, v2
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_cst_align64_double_int16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r3, 3725
; CHECK-P9-NEXT:    ori r3, r3, 19025
; CHECK-P9-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-NEXT:    lxsihzx v2, 0, r3
; CHECK-P9-NEXT:    vextsh2d v2, v2
; CHECK-P9-NEXT:    xscvsxddp f1, v2
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_cst_align64_double_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r3, 3725
; CHECK-P8-NEXT:    ori r3, r3, 19025
; CHECK-P8-NEXT:    rldic r3, r3, 12, 24
; CHECK-P8-NEXT:    lha r3, 0(r3)
; CHECK-P8-NEXT:    mtfprwa f0, r3
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i16, i16* inttoptr (i64 1000000000000 to i16*), align 4096
  %conv = sitofp i16 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_0_double_uint32_t(i64 %ptr) {
; CHECK-LABEL: ld_0_double_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfiwzx f0, 0, r3
; CHECK-NEXT:    xscvuxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to i32*
  %1 = load i32, i32* %0, align 4
  %conv = uitofp i32 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_align16_double_uint32_t(i8* nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16_double_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi r3, r3, 8
; CHECK-NEXT:    lfiwzx f0, 0, r3
; CHECK-NEXT:    xscvuxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 8
  %0 = bitcast i8* %add.ptr to i32*
  %1 = load i32, i32* %0, align 4
  %conv = uitofp i32 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_align32_double_uint32_t(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_double_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    lfiwzx f0, r3, r4
; CHECK-P10-NEXT:    xscvuxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32_double_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    lfiwzx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvuxddp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999000
  %0 = bitcast i8* %add.ptr to i32*
  %1 = load i32, i32* %0, align 4
  %conv = uitofp i32 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_align64_double_uint32_t(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_double_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfiwzx f0, r3, r4
; CHECK-P10-NEXT:    xscvuxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64_double_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfiwzx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvuxddp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000000
  %0 = bitcast i8* %add.ptr to i32*
  %1 = load i32, i32* %0, align 4
  %conv = uitofp i32 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_reg_double_uint32_t(i8* nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg_double_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfiwzx f0, r3, r4
; CHECK-NEXT:    xscvuxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %off
  %0 = bitcast i8* %add.ptr to i32*
  %1 = load i32, i32* %0, align 4
  %conv = uitofp i32 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_or_double_uint32_t(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or_double_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    lfiwzx f0, 0, r3
; CHECK-NEXT:    xscvuxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to i32*
  %1 = load i32, i32* %0, align 4
  %conv1 = uitofp i32 %1 to double
  ret double %conv1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_not_disjoint16_double_uint32_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16_double_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    lfiwzx f0, 0, r3
; CHECK-NEXT:    xscvuxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to i32*
  %1 = load i32, i32* %0, align 4
  %conv = uitofp i32 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_disjoint_align16_double_uint32_t(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16_double_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    ori r3, r3, 24
; CHECK-NEXT:    lfiwzx f0, 0, r3
; CHECK-NEXT:    xscvuxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to i32*
  %1 = load i32, i32* %0, align 8
  %conv = uitofp i32 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_not_disjoint32_double_uint32_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32_double_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    lfiwzx f0, 0, r3
; CHECK-NEXT:    xscvuxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to i32*
  %1 = load i32, i32* %0, align 4
  %conv = uitofp i32 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_disjoint_align32_double_uint32_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_double_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    lfiwzx f0, r3, r4
; CHECK-P10-NEXT:    xscvuxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_align32_double_uint32_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    lfiwzx f0, r3, r4
; CHECK-P9-NEXT:    xscvuxddp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align32_double_uint32_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r5, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r4, r5, 41712
; CHECK-P8-NEXT:    lfiwzx f0, r3, r4
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to i32*
  %1 = load i32, i32* %0, align 16
  %conv = uitofp i32 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_not_disjoint64_double_uint32_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_double_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lfiwzx f0, 0, r3
; CHECK-P10-NEXT:    xscvuxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64_double_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    lfiwzx f0, 0, r3
; CHECK-PREP10-NEXT:    xscvuxddp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to i32*
  %1 = load i32, i32* %0, align 4
  %conv = uitofp i32 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_disjoint_align64_double_uint32_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_double_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfiwzx f0, r3, r4
; CHECK-P10-NEXT:    xscvuxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align64_double_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfiwzx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvuxddp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to i32*
  %1 = load i32, i32* %0, align 4096
  %conv = uitofp i32 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_cst_align16_double_uint32_t() {
; CHECK-LABEL: ld_cst_align16_double_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    li r3, 4080
; CHECK-NEXT:    lfiwzx f0, 0, r3
; CHECK-NEXT:    xscvuxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %0 = load i32, i32* inttoptr (i64 4080 to i32*), align 16
  %conv = uitofp i32 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_cst_align32_double_uint32_t() {
; CHECK-P10-LABEL: ld_cst_align32_double_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 9999900
; CHECK-P10-NEXT:    lfiwzx f0, 0, r3
; CHECK-P10-NEXT:    xscvuxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align32_double_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 152
; CHECK-PREP10-NEXT:    ori r3, r3, 38428
; CHECK-PREP10-NEXT:    lfiwzx f0, 0, r3
; CHECK-PREP10-NEXT:    xscvuxddp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load i32, i32* inttoptr (i64 9999900 to i32*), align 4
  %conv = uitofp i32 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_cst_align64_double_uint32_t() {
; CHECK-P10-LABEL: ld_cst_align64_double_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lfiwzx f0, 0, r3
; CHECK-P10-NEXT:    xscvuxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align64_double_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    lfiwzx f0, 0, r3
; CHECK-PREP10-NEXT:    xscvuxddp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load i32, i32* inttoptr (i64 1000000000000 to i32*), align 4096
  %conv = uitofp i32 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_0_double_int32_t(i64 %ptr) {
; CHECK-LABEL: ld_0_double_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfiwax f0, 0, r3
; CHECK-NEXT:    xscvsxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to i32*
  %1 = load i32, i32* %0, align 4
  %conv = sitofp i32 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_align16_double_int32_t(i8* nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16_double_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi r3, r3, 8
; CHECK-NEXT:    lfiwax f0, 0, r3
; CHECK-NEXT:    xscvsxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 8
  %0 = bitcast i8* %add.ptr to i32*
  %1 = load i32, i32* %0, align 4
  %conv = sitofp i32 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_align32_double_int32_t(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_double_int32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    lfiwax f0, r3, r4
; CHECK-P10-NEXT:    xscvsxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32_double_int32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    lfiwax f0, r3, r4
; CHECK-PREP10-NEXT:    xscvsxddp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999000
  %0 = bitcast i8* %add.ptr to i32*
  %1 = load i32, i32* %0, align 4
  %conv = sitofp i32 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_align64_double_int32_t(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_double_int32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfiwax f0, r3, r4
; CHECK-P10-NEXT:    xscvsxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64_double_int32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfiwax f0, r3, r4
; CHECK-PREP10-NEXT:    xscvsxddp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000000
  %0 = bitcast i8* %add.ptr to i32*
  %1 = load i32, i32* %0, align 4
  %conv = sitofp i32 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_reg_double_int32_t(i8* nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg_double_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfiwax f0, r3, r4
; CHECK-NEXT:    xscvsxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %off
  %0 = bitcast i8* %add.ptr to i32*
  %1 = load i32, i32* %0, align 4
  %conv = sitofp i32 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_or_double_int32_t(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or_double_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    lfiwax f0, 0, r3
; CHECK-NEXT:    xscvsxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to i32*
  %1 = load i32, i32* %0, align 4
  %conv1 = sitofp i32 %1 to double
  ret double %conv1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_not_disjoint16_double_int32_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16_double_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    lfiwax f0, 0, r3
; CHECK-NEXT:    xscvsxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to i32*
  %1 = load i32, i32* %0, align 4
  %conv = sitofp i32 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_disjoint_align16_double_int32_t(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16_double_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    ori r3, r3, 24
; CHECK-NEXT:    lfiwax f0, 0, r3
; CHECK-NEXT:    xscvsxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to i32*
  %1 = load i32, i32* %0, align 8
  %conv = sitofp i32 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_not_disjoint32_double_int32_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32_double_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    lfiwax f0, 0, r3
; CHECK-NEXT:    xscvsxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to i32*
  %1 = load i32, i32* %0, align 4
  %conv = sitofp i32 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_disjoint_align32_double_int32_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_double_int32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    lfiwax f0, r3, r4
; CHECK-P10-NEXT:    xscvsxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_align32_double_int32_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    lfiwax f0, r3, r4
; CHECK-P9-NEXT:    xscvsxddp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align32_double_int32_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r5, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r4, r5, 41712
; CHECK-P8-NEXT:    lfiwax f0, r3, r4
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to i32*
  %1 = load i32, i32* %0, align 16
  %conv = sitofp i32 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_not_disjoint64_double_int32_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_double_int32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lfiwax f0, 0, r3
; CHECK-P10-NEXT:    xscvsxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64_double_int32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    lfiwax f0, 0, r3
; CHECK-PREP10-NEXT:    xscvsxddp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to i32*
  %1 = load i32, i32* %0, align 4
  %conv = sitofp i32 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_disjoint_align64_double_int32_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_double_int32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfiwax f0, r3, r4
; CHECK-P10-NEXT:    xscvsxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align64_double_int32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfiwax f0, r3, r4
; CHECK-PREP10-NEXT:    xscvsxddp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to i32*
  %1 = load i32, i32* %0, align 4096
  %conv = sitofp i32 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_cst_align16_double_int32_t() {
; CHECK-LABEL: ld_cst_align16_double_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    li r3, 4080
; CHECK-NEXT:    lfiwax f0, 0, r3
; CHECK-NEXT:    xscvsxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %0 = load i32, i32* inttoptr (i64 4080 to i32*), align 16
  %conv = sitofp i32 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_cst_align32_double_int32_t() {
; CHECK-P10-LABEL: ld_cst_align32_double_int32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 9999900
; CHECK-P10-NEXT:    lfiwax f0, 0, r3
; CHECK-P10-NEXT:    xscvsxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align32_double_int32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 152
; CHECK-PREP10-NEXT:    ori r3, r3, 38428
; CHECK-PREP10-NEXT:    lfiwax f0, 0, r3
; CHECK-PREP10-NEXT:    xscvsxddp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load i32, i32* inttoptr (i64 9999900 to i32*), align 4
  %conv = sitofp i32 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_cst_align64_double_int32_t() {
; CHECK-P10-LABEL: ld_cst_align64_double_int32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lfiwax f0, 0, r3
; CHECK-P10-NEXT:    xscvsxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align64_double_int32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    lfiwax f0, 0, r3
; CHECK-PREP10-NEXT:    xscvsxddp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load i32, i32* inttoptr (i64 1000000000000 to i32*), align 4096
  %conv = sitofp i32 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_0_double_uint64_t(i64 %ptr) {
; CHECK-LABEL: ld_0_double_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfd f0, 0(r3)
; CHECK-NEXT:    xscvuxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to i64*
  %1 = load i64, i64* %0, align 8
  %conv = uitofp i64 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_align16_double_uint64_t(i8* nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16_double_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfd f0, 8(r3)
; CHECK-NEXT:    xscvuxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 8
  %0 = bitcast i8* %add.ptr to i64*
  %1 = load i64, i64* %0, align 8
  %conv = uitofp i64 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_align32_double_uint64_t(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_double_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    lfdx f0, r3, r4
; CHECK-P10-NEXT:    xscvuxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32_double_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    lfdx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvuxddp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999000
  %0 = bitcast i8* %add.ptr to i64*
  %1 = load i64, i64* %0, align 8
  %conv = uitofp i64 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_align64_double_uint64_t(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_double_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfdx f0, r3, r4
; CHECK-P10-NEXT:    xscvuxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64_double_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfdx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvuxddp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000000
  %0 = bitcast i8* %add.ptr to i64*
  %1 = load i64, i64* %0, align 8
  %conv = uitofp i64 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_reg_double_uint64_t(i8* nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg_double_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfdx f0, r3, r4
; CHECK-NEXT:    xscvuxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %off
  %0 = bitcast i8* %add.ptr to i64*
  %1 = load i64, i64* %0, align 8
  %conv = uitofp i64 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_or_double_uint64_t(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or_double_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    lfd f0, 0(r3)
; CHECK-NEXT:    xscvuxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to i64*
  %1 = load i64, i64* %0, align 8
  %conv1 = uitofp i64 %1 to double
  ret double %conv1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_not_disjoint16_double_uint64_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16_double_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    lfd f0, 0(r3)
; CHECK-NEXT:    xscvuxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to i64*
  %1 = load i64, i64* %0, align 8
  %conv = uitofp i64 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_disjoint_align16_double_uint64_t(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16_double_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    lfd f0, 24(r3)
; CHECK-NEXT:    xscvuxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to i64*
  %1 = load i64, i64* %0, align 8
  %conv = uitofp i64 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_not_disjoint32_double_uint64_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32_double_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    lfd f0, 0(r3)
; CHECK-NEXT:    xscvuxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to i64*
  %1 = load i64, i64* %0, align 8
  %conv = uitofp i64 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_disjoint_align32_double_uint64_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_double_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    lfdx f0, r3, r4
; CHECK-P10-NEXT:    xscvuxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_align32_double_uint64_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    lfdx f0, r3, r4
; CHECK-P9-NEXT:    xscvuxddp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align32_double_uint64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r5, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r4, r5, 41712
; CHECK-P8-NEXT:    lfdx f0, r3, r4
; CHECK-P8-NEXT:    xscvuxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to i64*
  %1 = load i64, i64* %0, align 16
  %conv = uitofp i64 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_not_disjoint64_double_uint64_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_double_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lfd f0, 0(r3)
; CHECK-P10-NEXT:    xscvuxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64_double_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    lfd f0, 0(r3)
; CHECK-PREP10-NEXT:    xscvuxddp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to i64*
  %1 = load i64, i64* %0, align 8
  %conv = uitofp i64 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_disjoint_align64_double_uint64_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_double_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfdx f0, r3, r4
; CHECK-P10-NEXT:    xscvuxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align64_double_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfdx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvuxddp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to i64*
  %1 = load i64, i64* %0, align 4096
  %conv = uitofp i64 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_cst_align16_double_uint64_t() {
; CHECK-LABEL: ld_cst_align16_double_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfd f0, 4080(0)
; CHECK-NEXT:    xscvuxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %0 = load i64, i64* inttoptr (i64 4080 to i64*), align 16
  %conv = uitofp i64 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_cst_align32_double_uint64_t() {
; CHECK-LABEL: ld_cst_align32_double_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    lfd f0, -27108(r3)
; CHECK-NEXT:    xscvuxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %0 = load i64, i64* inttoptr (i64 9999900 to i64*), align 8
  %conv = uitofp i64 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_cst_align64_double_uint64_t() {
; CHECK-P10-LABEL: ld_cst_align64_double_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lfd f0, 0(r3)
; CHECK-P10-NEXT:    xscvuxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align64_double_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    lfd f0, 0(r3)
; CHECK-PREP10-NEXT:    xscvuxddp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load i64, i64* inttoptr (i64 1000000000000 to i64*), align 4096
  %conv = uitofp i64 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_0_double_int64_t(i64 %ptr) {
; CHECK-LABEL: ld_0_double_int64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfd f0, 0(r3)
; CHECK-NEXT:    xscvsxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to i64*
  %1 = load i64, i64* %0, align 8
  %conv = sitofp i64 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_align16_double_int64_t(i8* nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16_double_int64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfd f0, 8(r3)
; CHECK-NEXT:    xscvsxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 8
  %0 = bitcast i8* %add.ptr to i64*
  %1 = load i64, i64* %0, align 8
  %conv = sitofp i64 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_align32_double_int64_t(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_double_int64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    lfdx f0, r3, r4
; CHECK-P10-NEXT:    xscvsxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32_double_int64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    lfdx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvsxddp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999000
  %0 = bitcast i8* %add.ptr to i64*
  %1 = load i64, i64* %0, align 8
  %conv = sitofp i64 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_align64_double_int64_t(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_double_int64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfdx f0, r3, r4
; CHECK-P10-NEXT:    xscvsxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64_double_int64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfdx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvsxddp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000000
  %0 = bitcast i8* %add.ptr to i64*
  %1 = load i64, i64* %0, align 8
  %conv = sitofp i64 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_reg_double_int64_t(i8* nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg_double_int64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfdx f0, r3, r4
; CHECK-NEXT:    xscvsxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %off
  %0 = bitcast i8* %add.ptr to i64*
  %1 = load i64, i64* %0, align 8
  %conv = sitofp i64 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_or_double_int64_t(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or_double_int64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    lfd f0, 0(r3)
; CHECK-NEXT:    xscvsxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to i64*
  %1 = load i64, i64* %0, align 8
  %conv1 = sitofp i64 %1 to double
  ret double %conv1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_not_disjoint16_double_int64_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16_double_int64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    lfd f0, 0(r3)
; CHECK-NEXT:    xscvsxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to i64*
  %1 = load i64, i64* %0, align 8
  %conv = sitofp i64 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_disjoint_align16_double_int64_t(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16_double_int64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    lfd f0, 24(r3)
; CHECK-NEXT:    xscvsxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to i64*
  %1 = load i64, i64* %0, align 8
  %conv = sitofp i64 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_not_disjoint32_double_int64_t(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32_double_int64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    lfd f0, 0(r3)
; CHECK-NEXT:    xscvsxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to i64*
  %1 = load i64, i64* %0, align 8
  %conv = sitofp i64 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_disjoint_align32_double_int64_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_double_int64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    lfdx f0, r3, r4
; CHECK-P10-NEXT:    xscvsxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_align32_double_int64_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    lfdx f0, r3, r4
; CHECK-P9-NEXT:    xscvsxddp f1, f0
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align32_double_int64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r5, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r4, r5, 41712
; CHECK-P8-NEXT:    lfdx f0, r3, r4
; CHECK-P8-NEXT:    xscvsxddp f1, f0
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to i64*
  %1 = load i64, i64* %0, align 16
  %conv = sitofp i64 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_not_disjoint64_double_int64_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_double_int64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lfd f0, 0(r3)
; CHECK-P10-NEXT:    xscvsxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64_double_int64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    lfd f0, 0(r3)
; CHECK-PREP10-NEXT:    xscvsxddp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to i64*
  %1 = load i64, i64* %0, align 8
  %conv = sitofp i64 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_disjoint_align64_double_int64_t(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_double_int64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfdx f0, r3, r4
; CHECK-P10-NEXT:    xscvsxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align64_double_int64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfdx f0, r3, r4
; CHECK-PREP10-NEXT:    xscvsxddp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to i64*
  %1 = load i64, i64* %0, align 4096
  %conv = sitofp i64 %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_cst_align16_double_int64_t() {
; CHECK-LABEL: ld_cst_align16_double_int64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfd f0, 4080(0)
; CHECK-NEXT:    xscvsxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %0 = load i64, i64* inttoptr (i64 4080 to i64*), align 16
  %conv = sitofp i64 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_cst_align32_double_int64_t() {
; CHECK-LABEL: ld_cst_align32_double_int64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    lfd f0, -27108(r3)
; CHECK-NEXT:    xscvsxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %0 = load i64, i64* inttoptr (i64 9999900 to i64*), align 8
  %conv = sitofp i64 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_cst_align64_double_int64_t() {
; CHECK-P10-LABEL: ld_cst_align64_double_int64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lfd f0, 0(r3)
; CHECK-P10-NEXT:    xscvsxddp f1, f0
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align64_double_int64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    lfd f0, 0(r3)
; CHECK-PREP10-NEXT:    xscvsxddp f1, f0
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load i64, i64* inttoptr (i64 1000000000000 to i64*), align 4096
  %conv = sitofp i64 %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_0_double_float(i64 %ptr) {
; CHECK-LABEL: ld_0_double_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfs f1, 0(r3)
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to float*
  %1 = load float, float* %0, align 4
  %conv = fpext float %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_align16_double_float(i8* nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16_double_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfs f1, 8(r3)
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 8
  %0 = bitcast i8* %add.ptr to float*
  %1 = load float, float* %0, align 4
  %conv = fpext float %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_align32_double_float(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_double_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    lfsx f1, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32_double_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    lfsx f1, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999000
  %0 = bitcast i8* %add.ptr to float*
  %1 = load float, float* %0, align 4
  %conv = fpext float %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_align64_double_float(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_double_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfsx f1, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64_double_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfsx f1, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000000
  %0 = bitcast i8* %add.ptr to float*
  %1 = load float, float* %0, align 4
  %conv = fpext float %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_reg_double_float(i8* nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg_double_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfsx f1, r3, r4
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %off
  %0 = bitcast i8* %add.ptr to float*
  %1 = load float, float* %0, align 4
  %conv = fpext float %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_or_double_float(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or_double_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    lfs f1, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to float*
  %1 = load float, float* %0, align 4
  %conv1 = fpext float %1 to double
  ret double %conv1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_not_disjoint16_double_float(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16_double_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    lfs f1, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to float*
  %1 = load float, float* %0, align 4
  %conv = fpext float %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_disjoint_align16_double_float(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16_double_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    lfs f1, 24(r3)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to float*
  %1 = load float, float* %0, align 8
  %conv = fpext float %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_not_disjoint32_double_float(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32_double_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    lfs f1, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to float*
  %1 = load float, float* %0, align 4
  %conv = fpext float %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_disjoint_align32_double_float(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_double_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    lfsx f1, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_align32_double_float:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    lfsx f1, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align32_double_float:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r5, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r4, r5, 41712
; CHECK-P8-NEXT:    lfsx f1, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to float*
  %1 = load float, float* %0, align 16
  %conv = fpext float %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_not_disjoint64_double_float(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_double_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lfs f1, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64_double_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    lfs f1, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to float*
  %1 = load float, float* %0, align 4
  %conv = fpext float %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_disjoint_align64_double_float(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_double_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfsx f1, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align64_double_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfsx f1, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to float*
  %1 = load float, float* %0, align 4096
  %conv = fpext float %1 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_cst_align16_double_float() {
; CHECK-LABEL: ld_cst_align16_double_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfs f1, 4080(0)
; CHECK-NEXT:    blr
entry:
  %0 = load float, float* inttoptr (i64 4080 to float*), align 16
  %conv = fpext float %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_cst_align32_double_float() {
; CHECK-LABEL: ld_cst_align32_double_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    lfs f1, -27108(r3)
; CHECK-NEXT:    blr
entry:
  %0 = load float, float* inttoptr (i64 9999900 to float*), align 4
  %conv = fpext float %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_cst_align64_double_float() {
; CHECK-P10-LABEL: ld_cst_align64_double_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lfs f1, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align64_double_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    lfs f1, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load float, float* inttoptr (i64 1000000000000 to float*), align 4096
  %conv = fpext float %0 to double
  ret double %conv
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_0_double_double(i64 %ptr) {
; CHECK-LABEL: ld_0_double_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfd f1, 0(r3)
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to double*
  %1 = load double, double* %0, align 8
  ret double %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_align16_double_double(i8* nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16_double_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfd f1, 8(r3)
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 8
  %0 = bitcast i8* %add.ptr to double*
  %1 = load double, double* %0, align 8
  ret double %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_align32_double_double(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_double_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    lfdx f1, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32_double_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    lfdx f1, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999000
  %0 = bitcast i8* %add.ptr to double*
  %1 = load double, double* %0, align 8
  ret double %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_align64_double_double(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_double_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfdx f1, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64_double_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfdx f1, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000000
  %0 = bitcast i8* %add.ptr to double*
  %1 = load double, double* %0, align 8
  ret double %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_reg_double_double(i8* nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg_double_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfdx f1, r3, r4
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %off
  %0 = bitcast i8* %add.ptr to double*
  %1 = load double, double* %0, align 8
  ret double %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_or_double_double(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or_double_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    lfd f1, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to double*
  %1 = load double, double* %0, align 8
  ret double %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_not_disjoint16_double_double(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16_double_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    lfd f1, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to double*
  %1 = load double, double* %0, align 8
  ret double %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_disjoint_align16_double_double(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16_double_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    lfd f1, 24(r3)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to double*
  %1 = load double, double* %0, align 8
  ret double %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_not_disjoint32_double_double(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32_double_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    lfd f1, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to double*
  %1 = load double, double* %0, align 8
  ret double %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_disjoint_align32_double_double(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_double_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    lfdx f1, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_align32_double_double:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    lfdx f1, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align32_double_double:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r5, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r4, r5, 41712
; CHECK-P8-NEXT:    lfdx f1, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to double*
  %1 = load double, double* %0, align 16
  ret double %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_not_disjoint64_double_double(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_double_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lfd f1, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64_double_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    lfd f1, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to double*
  %1 = load double, double* %0, align 8
  ret double %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_disjoint_align64_double_double(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_double_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lfdx f1, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align64_double_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    lfdx f1, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to double*
  %1 = load double, double* %0, align 4096
  ret double %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_cst_align16_double_double() {
; CHECK-LABEL: ld_cst_align16_double_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfd f1, 4080(0)
; CHECK-NEXT:    blr
entry:
  %0 = load double, double* inttoptr (i64 4080 to double*), align 16
  ret double %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_cst_align32_double_double() {
; CHECK-LABEL: ld_cst_align32_double_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    lfd f1, -27108(r3)
; CHECK-NEXT:    blr
entry:
  %0 = load double, double* inttoptr (i64 9999900 to double*), align 8
  ret double %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local double @ld_cst_align64_double_double() {
; CHECK-P10-LABEL: ld_cst_align64_double_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lfd f1, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_cst_align64_double_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    lfd f1, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %0 = load double, double* inttoptr (i64 1000000000000 to double*), align 4096
  ret double %0
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_double_uint8_t(i64 %ptr, double %str) {
; CHECK-POSTP8-LABEL: st_0_double_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxws f0, f1
; CHECK-POSTP8-NEXT:    stxsibx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_0_double_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    stb r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i8
  %0 = inttoptr i64 %ptr to i8*
  store i8 %conv, i8* %0, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_double_uint8_t(i8* nocapture %ptr, double %str) {
; CHECK-POSTP8-LABEL: st_align16_double_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxws f0, f1
; CHECK-POSTP8-NEXT:    addi r3, r3, 8
; CHECK-POSTP8-NEXT:    stxsibx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_align16_double_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    stb r4, 8(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i8
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 8
  store i8 %conv, i8* %add.ptr, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_double_uint8_t(i8* nocapture %ptr, double %str) {
; CHECK-P10-LABEL: st_align32_double_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxws f0, f1
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    stxsibx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_align32_double_uint8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpuxws f0, f1
; CHECK-P9-NEXT:    lis r4, 1525
; CHECK-P9-NEXT:    ori r4, r4, 56600
; CHECK-P9-NEXT:    stxsibx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_align32_double_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, 1525
; CHECK-P8-NEXT:    ori r4, r4, 56600
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    stbx r5, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i8
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999000
  store i8 %conv, i8* %add.ptr, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_double_uint8_t(i8* nocapture %ptr, double %str) {
; CHECK-P10-LABEL: st_align64_double_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxws f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stxsibx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_align64_double_uint8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpuxws f0, f1
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    stxsibx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_align64_double_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    stbx r5, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i8
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000000
  store i8 %conv, i8* %add.ptr, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_double_uint8_t(i8* nocapture %ptr, i64 %off, double %str) {
; CHECK-POSTP8-LABEL: st_reg_double_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxws f0, f1
; CHECK-POSTP8-NEXT:    stxsibx f0, r3, r4
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_reg_double_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    stbx r5, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i8
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %off
  store i8 %conv, i8* %add.ptr, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_double_uint8_t(i64 %ptr, i8 zeroext %off, double %str) {
; CHECK-POSTP8-LABEL: st_or1_double_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxws f0, f1
; CHECK-POSTP8-NEXT:    or r3, r4, r3
; CHECK-POSTP8-NEXT:    stxsibx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_or1_double_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    or r3, r4, r3
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    stb r5, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i8
  %conv1 = zext i8 %off to i64
  %or = or i64 %conv1, %ptr
  %0 = inttoptr i64 %or to i8*
  store i8 %conv, i8* %0, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_double_uint8_t(i64 %ptr, double %str) {
; CHECK-POSTP8-LABEL: st_not_disjoint16_double_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxws f0, f1
; CHECK-POSTP8-NEXT:    ori r3, r3, 6
; CHECK-POSTP8-NEXT:    stxsibx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint16_double_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    ori r3, r3, 6
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    stb r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i8
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to i8*
  store i8 %conv, i8* %0, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_double_uint8_t(i64 %ptr, double %str) {
; CHECK-POSTP8-LABEL: st_disjoint_align16_double_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxws f0, f1
; CHECK-POSTP8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-POSTP8-NEXT:    ori r3, r3, 24
; CHECK-POSTP8-NEXT:    stxsibx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align16_double_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    stb r4, 24(r3)
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = fptoui double %str to i8
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to i8*
  store i8 %conv, i8* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_double_uint8_t(i64 %ptr, double %str) {
; CHECK-POSTP8-LABEL: st_not_disjoint32_double_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxws f0, f1
; CHECK-POSTP8-NEXT:    ori r3, r3, 34463
; CHECK-POSTP8-NEXT:    oris r3, r3, 1
; CHECK-POSTP8-NEXT:    stxsibx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint32_double_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    ori r3, r3, 34463
; CHECK-P8-NEXT:    oris r3, r3, 1
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    stb r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i8
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to i8*
  store i8 %conv, i8* %0, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_double_uint8_t(i64 %ptr, double %str) {
; CHECK-P10-LABEL: st_disjoint_align32_double_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxws f0, f1
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    stxsibx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align32_double_uint8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpuxws f0, f1
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    stxsibx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align32_double_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r6, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r4, r6, 41712
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    stbx r5, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %conv = fptoui double %str to i8
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to i8*
  store i8 %conv, i8* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_double_uint8_t(i64 %ptr, double %str) {
; CHECK-P10-LABEL: st_not_disjoint64_double_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxws f0, f1
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    stxsibx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_not_disjoint64_double_uint8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 29
; CHECK-P9-NEXT:    xscvdpuxws f0, f1
; CHECK-P9-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-NEXT:    oris r4, r4, 54437
; CHECK-P9-NEXT:    ori r4, r4, 4097
; CHECK-P9-NEXT:    or r3, r3, r4
; CHECK-P9-NEXT:    stxsibx f0, 0, r3
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint64_double_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    li r4, 29
; CHECK-P8-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-NEXT:    oris r4, r4, 54437
; CHECK-P8-NEXT:    ori r4, r4, 4097
; CHECK-P8-NEXT:    or r3, r3, r4
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    stb r5, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i8
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to i8*
  store i8 %conv, i8* %0, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_double_uint8_t(i64 %ptr, double %str) {
; CHECK-P10-LABEL: st_disjoint_align64_double_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxws f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stxsibx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align64_double_uint8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpuxws f0, f1
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    stxsibx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align64_double_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    stbx r5, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %conv = fptoui double %str to i8
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to i8*
  store i8 %conv, i8* %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_double_uint8_t(double %str) {
; CHECK-POSTP8-LABEL: st_cst_align16_double_uint8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxws f0, f1
; CHECK-POSTP8-NEXT:    li r3, 4080
; CHECK-POSTP8-NEXT:    stxsibx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align16_double_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r3, f0
; CHECK-P8-NEXT:    stb r3, 4080(0)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i8
  store i8 %conv, i8* inttoptr (i64 4080 to i8*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_double_uint8_t(double %str) {
; CHECK-P10-LABEL: st_cst_align32_double_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxws f0, f1
; CHECK-P10-NEXT:    pli r3, 9999900
; CHECK-P10-NEXT:    stxsibx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_align32_double_uint8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpuxws f0, f1
; CHECK-P9-NEXT:    lis r3, 152
; CHECK-P9-NEXT:    ori r3, r3, 38428
; CHECK-P9-NEXT:    stxsibx f0, 0, r3
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align32_double_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, 153
; CHECK-P8-NEXT:    mffprwz r3, f0
; CHECK-P8-NEXT:    stb r3, -27108(r4)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i8
  store i8 %conv, i8* inttoptr (i64 9999900 to i8*), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_double_uint8_t(double %str) {
; CHECK-P10-LABEL: st_cst_align64_double_uint8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxws f0, f1
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    stxsibx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_align64_double_uint8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpuxws f0, f1
; CHECK-P9-NEXT:    lis r3, 3725
; CHECK-P9-NEXT:    ori r3, r3, 19025
; CHECK-P9-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-NEXT:    stxsibx f0, 0, r3
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align64_double_uint8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r3, 3725
; CHECK-P8-NEXT:    ori r3, r3, 19025
; CHECK-P8-NEXT:    rldic r3, r3, 12, 24
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    stb r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i8
  store i8 %conv, i8* inttoptr (i64 1000000000000 to i8*), align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_double_int8_t(i64 %ptr, double %str) {
; CHECK-POSTP8-LABEL: st_0_double_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxws f0, f1
; CHECK-POSTP8-NEXT:    stxsibx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_0_double_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    stb r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i8
  %0 = inttoptr i64 %ptr to i8*
  store i8 %conv, i8* %0, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_double_int8_t(i8* nocapture %ptr, double %str) {
; CHECK-POSTP8-LABEL: st_align16_double_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxws f0, f1
; CHECK-POSTP8-NEXT:    addi r3, r3, 8
; CHECK-POSTP8-NEXT:    stxsibx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_align16_double_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    stb r4, 8(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i8
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 8
  store i8 %conv, i8* %add.ptr, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_double_int8_t(i8* nocapture %ptr, double %str) {
; CHECK-P10-LABEL: st_align32_double_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxws f0, f1
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    stxsibx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_align32_double_int8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpsxws f0, f1
; CHECK-P9-NEXT:    lis r4, 1525
; CHECK-P9-NEXT:    ori r4, r4, 56600
; CHECK-P9-NEXT:    stxsibx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_align32_double_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, 1525
; CHECK-P8-NEXT:    ori r4, r4, 56600
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    stbx r5, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i8
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999000
  store i8 %conv, i8* %add.ptr, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_double_int8_t(i8* nocapture %ptr, double %str) {
; CHECK-P10-LABEL: st_align64_double_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxws f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stxsibx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_align64_double_int8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpsxws f0, f1
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    stxsibx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_align64_double_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    stbx r5, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i8
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000000
  store i8 %conv, i8* %add.ptr, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_double_int8_t(i8* nocapture %ptr, i64 %off, double %str) {
; CHECK-POSTP8-LABEL: st_reg_double_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxws f0, f1
; CHECK-POSTP8-NEXT:    stxsibx f0, r3, r4
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_reg_double_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    stbx r5, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i8
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %off
  store i8 %conv, i8* %add.ptr, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_double_int8_t(i64 %ptr, i8 zeroext %off, double %str) {
; CHECK-POSTP8-LABEL: st_or1_double_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxws f0, f1
; CHECK-POSTP8-NEXT:    or r3, r4, r3
; CHECK-POSTP8-NEXT:    stxsibx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_or1_double_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    or r3, r4, r3
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    stb r5, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i8
  %conv1 = zext i8 %off to i64
  %or = or i64 %conv1, %ptr
  %0 = inttoptr i64 %or to i8*
  store i8 %conv, i8* %0, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_double_int8_t(i64 %ptr, double %str) {
; CHECK-POSTP8-LABEL: st_not_disjoint16_double_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxws f0, f1
; CHECK-POSTP8-NEXT:    ori r3, r3, 6
; CHECK-POSTP8-NEXT:    stxsibx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint16_double_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    ori r3, r3, 6
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    stb r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i8
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to i8*
  store i8 %conv, i8* %0, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_double_int8_t(i64 %ptr, double %str) {
; CHECK-POSTP8-LABEL: st_disjoint_align16_double_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxws f0, f1
; CHECK-POSTP8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-POSTP8-NEXT:    ori r3, r3, 24
; CHECK-POSTP8-NEXT:    stxsibx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align16_double_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    stb r4, 24(r3)
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = fptosi double %str to i8
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to i8*
  store i8 %conv, i8* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_double_int8_t(i64 %ptr, double %str) {
; CHECK-POSTP8-LABEL: st_not_disjoint32_double_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxws f0, f1
; CHECK-POSTP8-NEXT:    ori r3, r3, 34463
; CHECK-POSTP8-NEXT:    oris r3, r3, 1
; CHECK-POSTP8-NEXT:    stxsibx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint32_double_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    ori r3, r3, 34463
; CHECK-P8-NEXT:    oris r3, r3, 1
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    stb r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i8
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to i8*
  store i8 %conv, i8* %0, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_double_int8_t(i64 %ptr, double %str) {
; CHECK-P10-LABEL: st_disjoint_align32_double_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxws f0, f1
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    stxsibx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align32_double_int8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpsxws f0, f1
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    stxsibx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align32_double_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r6, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r4, r6, 41712
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    stbx r5, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %conv = fptosi double %str to i8
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to i8*
  store i8 %conv, i8* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_double_int8_t(i64 %ptr, double %str) {
; CHECK-P10-LABEL: st_not_disjoint64_double_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxws f0, f1
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    stxsibx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_not_disjoint64_double_int8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 29
; CHECK-P9-NEXT:    xscvdpsxws f0, f1
; CHECK-P9-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-NEXT:    oris r4, r4, 54437
; CHECK-P9-NEXT:    ori r4, r4, 4097
; CHECK-P9-NEXT:    or r3, r3, r4
; CHECK-P9-NEXT:    stxsibx f0, 0, r3
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint64_double_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    li r4, 29
; CHECK-P8-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-NEXT:    oris r4, r4, 54437
; CHECK-P8-NEXT:    ori r4, r4, 4097
; CHECK-P8-NEXT:    or r3, r3, r4
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    stb r5, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i8
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to i8*
  store i8 %conv, i8* %0, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_double_int8_t(i64 %ptr, double %str) {
; CHECK-P10-LABEL: st_disjoint_align64_double_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxws f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stxsibx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align64_double_int8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpsxws f0, f1
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    stxsibx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align64_double_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    stbx r5, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %conv = fptosi double %str to i8
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to i8*
  store i8 %conv, i8* %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_double_int8_t(double %str) {
; CHECK-POSTP8-LABEL: st_cst_align16_double_int8_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxws f0, f1
; CHECK-POSTP8-NEXT:    li r3, 4080
; CHECK-POSTP8-NEXT:    stxsibx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align16_double_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r3, f0
; CHECK-P8-NEXT:    stb r3, 4080(0)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i8
  store i8 %conv, i8* inttoptr (i64 4080 to i8*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_double_int8_t(double %str) {
; CHECK-P10-LABEL: st_cst_align32_double_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxws f0, f1
; CHECK-P10-NEXT:    pli r3, 9999900
; CHECK-P10-NEXT:    stxsibx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_align32_double_int8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpsxws f0, f1
; CHECK-P9-NEXT:    lis r3, 152
; CHECK-P9-NEXT:    ori r3, r3, 38428
; CHECK-P9-NEXT:    stxsibx f0, 0, r3
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align32_double_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, 153
; CHECK-P8-NEXT:    mffprwz r3, f0
; CHECK-P8-NEXT:    stb r3, -27108(r4)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i8
  store i8 %conv, i8* inttoptr (i64 9999900 to i8*), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_double_int8_t(double %str) {
; CHECK-P10-LABEL: st_cst_align64_double_int8_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxws f0, f1
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    stxsibx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_align64_double_int8_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpsxws f0, f1
; CHECK-P9-NEXT:    lis r3, 3725
; CHECK-P9-NEXT:    ori r3, r3, 19025
; CHECK-P9-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-NEXT:    stxsibx f0, 0, r3
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align64_double_int8_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r3, 3725
; CHECK-P8-NEXT:    ori r3, r3, 19025
; CHECK-P8-NEXT:    rldic r3, r3, 12, 24
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    stb r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i8
  store i8 %conv, i8* inttoptr (i64 1000000000000 to i8*), align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_double_uint16_t(i64 %ptr, double %str) {
; CHECK-POSTP8-LABEL: st_0_double_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxws f0, f1
; CHECK-POSTP8-NEXT:    stxsihx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_0_double_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    sth r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i16
  %0 = inttoptr i64 %ptr to i16*
  store i16 %conv, i16* %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_double_uint16_t(i8* nocapture %ptr, double %str) {
; CHECK-POSTP8-LABEL: st_align16_double_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxws f0, f1
; CHECK-POSTP8-NEXT:    addi r3, r3, 8
; CHECK-POSTP8-NEXT:    stxsihx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_align16_double_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    sth r4, 8(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i16
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 8
  %0 = bitcast i8* %add.ptr to i16*
  store i16 %conv, i16* %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_double_uint16_t(i8* nocapture %ptr, double %str) {
; CHECK-P10-LABEL: st_align32_double_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxws f0, f1
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    stxsihx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_align32_double_uint16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpuxws f0, f1
; CHECK-P9-NEXT:    lis r4, 1525
; CHECK-P9-NEXT:    ori r4, r4, 56600
; CHECK-P9-NEXT:    stxsihx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_align32_double_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, 1525
; CHECK-P8-NEXT:    ori r4, r4, 56600
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    sthx r5, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i16
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999000
  %0 = bitcast i8* %add.ptr to i16*
  store i16 %conv, i16* %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_double_uint16_t(i8* nocapture %ptr, double %str) {
; CHECK-P10-LABEL: st_align64_double_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxws f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stxsihx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_align64_double_uint16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpuxws f0, f1
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    stxsihx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_align64_double_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    sthx r5, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i16
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000000
  %0 = bitcast i8* %add.ptr to i16*
  store i16 %conv, i16* %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_double_uint16_t(i8* nocapture %ptr, i64 %off, double %str) {
; CHECK-POSTP8-LABEL: st_reg_double_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxws f0, f1
; CHECK-POSTP8-NEXT:    stxsihx f0, r3, r4
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_reg_double_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    sthx r5, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i16
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %off
  %0 = bitcast i8* %add.ptr to i16*
  store i16 %conv, i16* %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_double_uint16_t(i64 %ptr, i8 zeroext %off, double %str) {
; CHECK-POSTP8-LABEL: st_or1_double_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxws f0, f1
; CHECK-POSTP8-NEXT:    or r3, r4, r3
; CHECK-POSTP8-NEXT:    stxsihx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_or1_double_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    or r3, r4, r3
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    sth r5, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i16
  %conv1 = zext i8 %off to i64
  %or = or i64 %conv1, %ptr
  %0 = inttoptr i64 %or to i16*
  store i16 %conv, i16* %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_double_uint16_t(i64 %ptr, double %str) {
; CHECK-POSTP8-LABEL: st_not_disjoint16_double_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxws f0, f1
; CHECK-POSTP8-NEXT:    ori r3, r3, 6
; CHECK-POSTP8-NEXT:    stxsihx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint16_double_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    ori r3, r3, 6
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    sth r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i16
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to i16*
  store i16 %conv, i16* %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_double_uint16_t(i64 %ptr, double %str) {
; CHECK-POSTP8-LABEL: st_disjoint_align16_double_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxws f0, f1
; CHECK-POSTP8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-POSTP8-NEXT:    ori r3, r3, 24
; CHECK-POSTP8-NEXT:    stxsihx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align16_double_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    sth r4, 24(r3)
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = fptoui double %str to i16
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to i16*
  store i16 %conv, i16* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_double_uint16_t(i64 %ptr, double %str) {
; CHECK-POSTP8-LABEL: st_not_disjoint32_double_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxws f0, f1
; CHECK-POSTP8-NEXT:    ori r3, r3, 34463
; CHECK-POSTP8-NEXT:    oris r3, r3, 1
; CHECK-POSTP8-NEXT:    stxsihx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint32_double_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    ori r3, r3, 34463
; CHECK-P8-NEXT:    oris r3, r3, 1
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    sth r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i16
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to i16*
  store i16 %conv, i16* %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_double_uint16_t(i64 %ptr, double %str) {
; CHECK-P10-LABEL: st_disjoint_align32_double_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxws f0, f1
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    stxsihx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align32_double_uint16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpuxws f0, f1
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    stxsihx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align32_double_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r6, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r4, r6, 41712
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    sthx r5, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %conv = fptoui double %str to i16
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to i16*
  store i16 %conv, i16* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_double_uint16_t(i64 %ptr, double %str) {
; CHECK-P10-LABEL: st_not_disjoint64_double_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxws f0, f1
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    stxsihx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_not_disjoint64_double_uint16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 29
; CHECK-P9-NEXT:    xscvdpuxws f0, f1
; CHECK-P9-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-NEXT:    oris r4, r4, 54437
; CHECK-P9-NEXT:    ori r4, r4, 4097
; CHECK-P9-NEXT:    or r3, r3, r4
; CHECK-P9-NEXT:    stxsihx f0, 0, r3
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint64_double_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    li r4, 29
; CHECK-P8-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-NEXT:    oris r4, r4, 54437
; CHECK-P8-NEXT:    ori r4, r4, 4097
; CHECK-P8-NEXT:    or r3, r3, r4
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    sth r5, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i16
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to i16*
  store i16 %conv, i16* %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_double_uint16_t(i64 %ptr, double %str) {
; CHECK-P10-LABEL: st_disjoint_align64_double_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxws f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stxsihx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align64_double_uint16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpuxws f0, f1
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    stxsihx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align64_double_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    sthx r5, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %conv = fptoui double %str to i16
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to i16*
  store i16 %conv, i16* %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_double_uint16_t(double %str) {
; CHECK-POSTP8-LABEL: st_cst_align16_double_uint16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxws f0, f1
; CHECK-POSTP8-NEXT:    li r3, 4080
; CHECK-POSTP8-NEXT:    stxsihx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align16_double_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r3, f0
; CHECK-P8-NEXT:    sth r3, 4080(0)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i16
  store i16 %conv, i16* inttoptr (i64 4080 to i16*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_double_uint16_t(double %str) {
; CHECK-P10-LABEL: st_cst_align32_double_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxws f0, f1
; CHECK-P10-NEXT:    pli r3, 9999900
; CHECK-P10-NEXT:    stxsihx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_align32_double_uint16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpuxws f0, f1
; CHECK-P9-NEXT:    lis r3, 152
; CHECK-P9-NEXT:    ori r3, r3, 38428
; CHECK-P9-NEXT:    stxsihx f0, 0, r3
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align32_double_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, 153
; CHECK-P8-NEXT:    mffprwz r3, f0
; CHECK-P8-NEXT:    sth r3, -27108(r4)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i16
  store i16 %conv, i16* inttoptr (i64 9999900 to i16*), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_double_uint16_t(double %str) {
; CHECK-P10-LABEL: st_cst_align64_double_uint16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxws f0, f1
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    stxsihx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_align64_double_uint16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpuxws f0, f1
; CHECK-P9-NEXT:    lis r3, 3725
; CHECK-P9-NEXT:    ori r3, r3, 19025
; CHECK-P9-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-NEXT:    stxsihx f0, 0, r3
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align64_double_uint16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r3, 3725
; CHECK-P8-NEXT:    ori r3, r3, 19025
; CHECK-P8-NEXT:    rldic r3, r3, 12, 24
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    sth r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i16
  store i16 %conv, i16* inttoptr (i64 1000000000000 to i16*), align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_double_int16_t(i64 %ptr, double %str) {
; CHECK-POSTP8-LABEL: st_0_double_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxws f0, f1
; CHECK-POSTP8-NEXT:    stxsihx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_0_double_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    sth r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i16
  %0 = inttoptr i64 %ptr to i16*
  store i16 %conv, i16* %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_double_int16_t(i8* nocapture %ptr, double %str) {
; CHECK-POSTP8-LABEL: st_align16_double_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxws f0, f1
; CHECK-POSTP8-NEXT:    addi r3, r3, 8
; CHECK-POSTP8-NEXT:    stxsihx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_align16_double_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    sth r4, 8(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i16
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 8
  %0 = bitcast i8* %add.ptr to i16*
  store i16 %conv, i16* %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_double_int16_t(i8* nocapture %ptr, double %str) {
; CHECK-P10-LABEL: st_align32_double_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxws f0, f1
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    stxsihx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_align32_double_int16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpsxws f0, f1
; CHECK-P9-NEXT:    lis r4, 1525
; CHECK-P9-NEXT:    ori r4, r4, 56600
; CHECK-P9-NEXT:    stxsihx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_align32_double_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, 1525
; CHECK-P8-NEXT:    ori r4, r4, 56600
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    sthx r5, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i16
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999000
  %0 = bitcast i8* %add.ptr to i16*
  store i16 %conv, i16* %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_double_int16_t(i8* nocapture %ptr, double %str) {
; CHECK-P10-LABEL: st_align64_double_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxws f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stxsihx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_align64_double_int16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpsxws f0, f1
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    stxsihx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_align64_double_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    sthx r5, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i16
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000000
  %0 = bitcast i8* %add.ptr to i16*
  store i16 %conv, i16* %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_double_int16_t(i8* nocapture %ptr, i64 %off, double %str) {
; CHECK-POSTP8-LABEL: st_reg_double_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxws f0, f1
; CHECK-POSTP8-NEXT:    stxsihx f0, r3, r4
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_reg_double_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    sthx r5, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i16
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %off
  %0 = bitcast i8* %add.ptr to i16*
  store i16 %conv, i16* %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_double_int16_t(i64 %ptr, i8 zeroext %off, double %str) {
; CHECK-POSTP8-LABEL: st_or1_double_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxws f0, f1
; CHECK-POSTP8-NEXT:    or r3, r4, r3
; CHECK-POSTP8-NEXT:    stxsihx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_or1_double_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    or r3, r4, r3
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    sth r5, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i16
  %conv1 = zext i8 %off to i64
  %or = or i64 %conv1, %ptr
  %0 = inttoptr i64 %or to i16*
  store i16 %conv, i16* %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_double_int16_t(i64 %ptr, double %str) {
; CHECK-POSTP8-LABEL: st_not_disjoint16_double_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxws f0, f1
; CHECK-POSTP8-NEXT:    ori r3, r3, 6
; CHECK-POSTP8-NEXT:    stxsihx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint16_double_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    ori r3, r3, 6
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    sth r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i16
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to i16*
  store i16 %conv, i16* %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_double_int16_t(i64 %ptr, double %str) {
; CHECK-POSTP8-LABEL: st_disjoint_align16_double_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxws f0, f1
; CHECK-POSTP8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-POSTP8-NEXT:    ori r3, r3, 24
; CHECK-POSTP8-NEXT:    stxsihx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align16_double_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    sth r4, 24(r3)
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = fptosi double %str to i16
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to i16*
  store i16 %conv, i16* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_double_int16_t(i64 %ptr, double %str) {
; CHECK-POSTP8-LABEL: st_not_disjoint32_double_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxws f0, f1
; CHECK-POSTP8-NEXT:    ori r3, r3, 34463
; CHECK-POSTP8-NEXT:    oris r3, r3, 1
; CHECK-POSTP8-NEXT:    stxsihx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint32_double_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    ori r3, r3, 34463
; CHECK-P8-NEXT:    oris r3, r3, 1
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    sth r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i16
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to i16*
  store i16 %conv, i16* %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_double_int16_t(i64 %ptr, double %str) {
; CHECK-P10-LABEL: st_disjoint_align32_double_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxws f0, f1
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    stxsihx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align32_double_int16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpsxws f0, f1
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    stxsihx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align32_double_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r6, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r4, r6, 41712
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    sthx r5, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %conv = fptosi double %str to i16
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to i16*
  store i16 %conv, i16* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_double_int16_t(i64 %ptr, double %str) {
; CHECK-P10-LABEL: st_not_disjoint64_double_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxws f0, f1
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    stxsihx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_not_disjoint64_double_int16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 29
; CHECK-P9-NEXT:    xscvdpsxws f0, f1
; CHECK-P9-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-NEXT:    oris r4, r4, 54437
; CHECK-P9-NEXT:    ori r4, r4, 4097
; CHECK-P9-NEXT:    or r3, r3, r4
; CHECK-P9-NEXT:    stxsihx f0, 0, r3
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint64_double_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    li r4, 29
; CHECK-P8-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-NEXT:    oris r4, r4, 54437
; CHECK-P8-NEXT:    ori r4, r4, 4097
; CHECK-P8-NEXT:    or r3, r3, r4
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    sth r5, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i16
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to i16*
  store i16 %conv, i16* %0, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_double_int16_t(i64 %ptr, double %str) {
; CHECK-P10-LABEL: st_disjoint_align64_double_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxws f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stxsihx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align64_double_int16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpsxws f0, f1
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    stxsihx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align64_double_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    mffprwz r5, f0
; CHECK-P8-NEXT:    sthx r5, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %conv = fptosi double %str to i16
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to i16*
  store i16 %conv, i16* %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_double_int16_t(double %str) {
; CHECK-POSTP8-LABEL: st_cst_align16_double_int16_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxws f0, f1
; CHECK-POSTP8-NEXT:    li r3, 4080
; CHECK-POSTP8-NEXT:    stxsihx f0, 0, r3
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align16_double_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    mffprwz r3, f0
; CHECK-P8-NEXT:    sth r3, 4080(0)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i16
  store i16 %conv, i16* inttoptr (i64 4080 to i16*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_double_int16_t(double %str) {
; CHECK-P10-LABEL: st_cst_align32_double_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxws f0, f1
; CHECK-P10-NEXT:    pli r3, 9999900
; CHECK-P10-NEXT:    stxsihx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_align32_double_int16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpsxws f0, f1
; CHECK-P9-NEXT:    lis r3, 152
; CHECK-P9-NEXT:    ori r3, r3, 38428
; CHECK-P9-NEXT:    stxsihx f0, 0, r3
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align32_double_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, 153
; CHECK-P8-NEXT:    mffprwz r3, f0
; CHECK-P8-NEXT:    sth r3, -27108(r4)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i16
  store i16 %conv, i16* inttoptr (i64 9999900 to i16*), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_double_int16_t(double %str) {
; CHECK-P10-LABEL: st_cst_align64_double_int16_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxws f0, f1
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    stxsihx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_align64_double_int16_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpsxws f0, f1
; CHECK-P9-NEXT:    lis r3, 3725
; CHECK-P9-NEXT:    ori r3, r3, 19025
; CHECK-P9-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-NEXT:    stxsihx f0, 0, r3
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align64_double_int16_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r3, 3725
; CHECK-P8-NEXT:    ori r3, r3, 19025
; CHECK-P8-NEXT:    rldic r3, r3, 12, 24
; CHECK-P8-NEXT:    mffprwz r4, f0
; CHECK-P8-NEXT:    sth r4, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i16
  store i16 %conv, i16* inttoptr (i64 1000000000000 to i16*), align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_double_uint32_t(i64 %ptr, double %str) {
; CHECK-LABEL: st_0_double_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpuxws f0, f1
; CHECK-NEXT:    stfiwx f0, 0, r3
; CHECK-NEXT:    blr
entry:
  %conv = fptoui double %str to i32
  %0 = inttoptr i64 %ptr to i32*
  store i32 %conv, i32* %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_double_uint32_t(i8* nocapture %ptr, double %str) {
; CHECK-LABEL: st_align16_double_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpuxws f0, f1
; CHECK-NEXT:    addi r3, r3, 8
; CHECK-NEXT:    stfiwx f0, 0, r3
; CHECK-NEXT:    blr
entry:
  %conv = fptoui double %str to i32
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 8
  %0 = bitcast i8* %add.ptr to i32*
  store i32 %conv, i32* %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_double_uint32_t(i8* nocapture %ptr, double %str) {
; CHECK-P10-LABEL: st_align32_double_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxws f0, f1
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    stfiwx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align32_double_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpuxws f0, f1
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    stfiwx f0, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fptoui double %str to i32
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999000
  %0 = bitcast i8* %add.ptr to i32*
  store i32 %conv, i32* %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_double_uint32_t(i8* nocapture %ptr, double %str) {
; CHECK-P10-LABEL: st_align64_double_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxws f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stfiwx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align64_double_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpuxws f0, f1
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    stfiwx f0, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fptoui double %str to i32
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000000
  %0 = bitcast i8* %add.ptr to i32*
  store i32 %conv, i32* %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_double_uint32_t(i8* nocapture %ptr, i64 %off, double %str) {
; CHECK-LABEL: st_reg_double_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpuxws f0, f1
; CHECK-NEXT:    stfiwx f0, r3, r4
; CHECK-NEXT:    blr
entry:
  %conv = fptoui double %str to i32
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %off
  %0 = bitcast i8* %add.ptr to i32*
  store i32 %conv, i32* %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_double_uint32_t(i64 %ptr, i8 zeroext %off, double %str) {
; CHECK-LABEL: st_or1_double_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpuxws f0, f1
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    stfiwx f0, 0, r3
; CHECK-NEXT:    blr
entry:
  %conv = fptoui double %str to i32
  %conv1 = zext i8 %off to i64
  %or = or i64 %conv1, %ptr
  %0 = inttoptr i64 %or to i32*
  store i32 %conv, i32* %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_double_uint32_t(i64 %ptr, double %str) {
; CHECK-LABEL: st_not_disjoint16_double_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpuxws f0, f1
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    stfiwx f0, 0, r3
; CHECK-NEXT:    blr
entry:
  %conv = fptoui double %str to i32
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to i32*
  store i32 %conv, i32* %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_double_uint32_t(i64 %ptr, double %str) {
; CHECK-LABEL: st_disjoint_align16_double_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpuxws f0, f1
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    ori r3, r3, 24
; CHECK-NEXT:    stfiwx f0, 0, r3
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = fptoui double %str to i32
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to i32*
  store i32 %conv, i32* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_double_uint32_t(i64 %ptr, double %str) {
; CHECK-LABEL: st_not_disjoint32_double_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpuxws f0, f1
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    stfiwx f0, 0, r3
; CHECK-NEXT:    blr
entry:
  %conv = fptoui double %str to i32
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to i32*
  store i32 %conv, i32* %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_double_uint32_t(i64 %ptr, double %str) {
; CHECK-P10-LABEL: st_disjoint_align32_double_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxws f0, f1
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    stfiwx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align32_double_uint32_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpuxws f0, f1
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    stfiwx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align32_double_uint32_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpuxws f0, f1
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r5, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r4, r5, 41712
; CHECK-P8-NEXT:    stfiwx f0, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %conv = fptoui double %str to i32
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to i32*
  store i32 %conv, i32* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_double_uint32_t(i64 %ptr, double %str) {
; CHECK-P10-LABEL: st_not_disjoint64_double_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxws f0, f1
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    stfiwx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_not_disjoint64_double_uint32_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 29
; CHECK-P9-NEXT:    xscvdpuxws f0, f1
; CHECK-P9-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-NEXT:    oris r4, r4, 54437
; CHECK-P9-NEXT:    ori r4, r4, 4097
; CHECK-P9-NEXT:    or r3, r3, r4
; CHECK-P9-NEXT:    stfiwx f0, 0, r3
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint64_double_uint32_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpuxws f0, f1
; CHECK-P8-NEXT:    li r4, 29
; CHECK-P8-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-NEXT:    oris r4, r4, 54437
; CHECK-P8-NEXT:    ori r4, r4, 4097
; CHECK-P8-NEXT:    or r3, r3, r4
; CHECK-P8-NEXT:    stfiwx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i32
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to i32*
  store i32 %conv, i32* %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_double_uint32_t(i64 %ptr, double %str) {
; CHECK-P10-LABEL: st_disjoint_align64_double_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxws f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stfiwx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align64_double_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpuxws f0, f1
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    stfiwx f0, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %conv = fptoui double %str to i32
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to i32*
  store i32 %conv, i32* %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_double_uint32_t(double %str) {
; CHECK-LABEL: st_cst_align16_double_uint32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpuxws f0, f1
; CHECK-NEXT:    li r3, 4080
; CHECK-NEXT:    stfiwx f0, 0, r3
; CHECK-NEXT:    blr
entry:
  %conv = fptoui double %str to i32
  store i32 %conv, i32* inttoptr (i64 4080 to i32*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_double_uint32_t(double %str) {
; CHECK-P10-LABEL: st_cst_align32_double_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxws f0, f1
; CHECK-P10-NEXT:    pli r3, 9999900
; CHECK-P10-NEXT:    stfiwx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_cst_align32_double_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpuxws f0, f1
; CHECK-PREP10-NEXT:    lis r3, 152
; CHECK-PREP10-NEXT:    ori r3, r3, 38428
; CHECK-PREP10-NEXT:    stfiwx f0, 0, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fptoui double %str to i32
  store i32 %conv, i32* inttoptr (i64 9999900 to i32*), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_double_uint32_t(double %str) {
; CHECK-P10-LABEL: st_cst_align64_double_uint32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxws f0, f1
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    stfiwx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_cst_align64_double_uint32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpuxws f0, f1
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    stfiwx f0, 0, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fptoui double %str to i32
  store i32 %conv, i32* inttoptr (i64 1000000000000 to i32*), align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_double_int32_t(i64 %ptr, double %str) {
; CHECK-LABEL: st_0_double_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpsxws f0, f1
; CHECK-NEXT:    stfiwx f0, 0, r3
; CHECK-NEXT:    blr
entry:
  %conv = fptosi double %str to i32
  %0 = inttoptr i64 %ptr to i32*
  store i32 %conv, i32* %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_double_int32_t(i8* nocapture %ptr, double %str) {
; CHECK-LABEL: st_align16_double_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpsxws f0, f1
; CHECK-NEXT:    addi r3, r3, 8
; CHECK-NEXT:    stfiwx f0, 0, r3
; CHECK-NEXT:    blr
entry:
  %conv = fptosi double %str to i32
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 8
  %0 = bitcast i8* %add.ptr to i32*
  store i32 %conv, i32* %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_double_int32_t(i8* nocapture %ptr, double %str) {
; CHECK-P10-LABEL: st_align32_double_int32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxws f0, f1
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    stfiwx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align32_double_int32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f1
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    stfiwx f0, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fptosi double %str to i32
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999000
  %0 = bitcast i8* %add.ptr to i32*
  store i32 %conv, i32* %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_double_int32_t(i8* nocapture %ptr, double %str) {
; CHECK-P10-LABEL: st_align64_double_int32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxws f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stfiwx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align64_double_int32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f1
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    stfiwx f0, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fptosi double %str to i32
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000000
  %0 = bitcast i8* %add.ptr to i32*
  store i32 %conv, i32* %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_double_int32_t(i8* nocapture %ptr, i64 %off, double %str) {
; CHECK-LABEL: st_reg_double_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpsxws f0, f1
; CHECK-NEXT:    stfiwx f0, r3, r4
; CHECK-NEXT:    blr
entry:
  %conv = fptosi double %str to i32
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %off
  %0 = bitcast i8* %add.ptr to i32*
  store i32 %conv, i32* %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_double_int32_t(i64 %ptr, i8 zeroext %off, double %str) {
; CHECK-LABEL: st_or1_double_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpsxws f0, f1
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    stfiwx f0, 0, r3
; CHECK-NEXT:    blr
entry:
  %conv = fptosi double %str to i32
  %conv1 = zext i8 %off to i64
  %or = or i64 %conv1, %ptr
  %0 = inttoptr i64 %or to i32*
  store i32 %conv, i32* %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_double_int32_t(i64 %ptr, double %str) {
; CHECK-LABEL: st_not_disjoint16_double_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpsxws f0, f1
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    stfiwx f0, 0, r3
; CHECK-NEXT:    blr
entry:
  %conv = fptosi double %str to i32
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to i32*
  store i32 %conv, i32* %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_double_int32_t(i64 %ptr, double %str) {
; CHECK-LABEL: st_disjoint_align16_double_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpsxws f0, f1
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    ori r3, r3, 24
; CHECK-NEXT:    stfiwx f0, 0, r3
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = fptosi double %str to i32
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to i32*
  store i32 %conv, i32* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_double_int32_t(i64 %ptr, double %str) {
; CHECK-LABEL: st_not_disjoint32_double_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpsxws f0, f1
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    stfiwx f0, 0, r3
; CHECK-NEXT:    blr
entry:
  %conv = fptosi double %str to i32
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to i32*
  store i32 %conv, i32* %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_double_int32_t(i64 %ptr, double %str) {
; CHECK-P10-LABEL: st_disjoint_align32_double_int32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxws f0, f1
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    stfiwx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align32_double_int32_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpsxws f0, f1
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    stfiwx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align32_double_int32_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r5, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r4, r5, 41712
; CHECK-P8-NEXT:    stfiwx f0, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %conv = fptosi double %str to i32
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to i32*
  store i32 %conv, i32* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_double_int32_t(i64 %ptr, double %str) {
; CHECK-P10-LABEL: st_not_disjoint64_double_int32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxws f0, f1
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    stfiwx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_not_disjoint64_double_int32_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 29
; CHECK-P9-NEXT:    xscvdpsxws f0, f1
; CHECK-P9-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-NEXT:    oris r4, r4, 54437
; CHECK-P9-NEXT:    ori r4, r4, 4097
; CHECK-P9-NEXT:    or r3, r3, r4
; CHECK-P9-NEXT:    stfiwx f0, 0, r3
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint64_double_int32_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxws f0, f1
; CHECK-P8-NEXT:    li r4, 29
; CHECK-P8-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-NEXT:    oris r4, r4, 54437
; CHECK-P8-NEXT:    ori r4, r4, 4097
; CHECK-P8-NEXT:    or r3, r3, r4
; CHECK-P8-NEXT:    stfiwx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i32
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to i32*
  store i32 %conv, i32* %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_double_int32_t(i64 %ptr, double %str) {
; CHECK-P10-LABEL: st_disjoint_align64_double_int32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxws f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stfiwx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align64_double_int32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f1
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    stfiwx f0, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %conv = fptosi double %str to i32
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to i32*
  store i32 %conv, i32* %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_double_int32_t(double %str) {
; CHECK-LABEL: st_cst_align16_double_int32_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpsxws f0, f1
; CHECK-NEXT:    li r3, 4080
; CHECK-NEXT:    stfiwx f0, 0, r3
; CHECK-NEXT:    blr
entry:
  %conv = fptosi double %str to i32
  store i32 %conv, i32* inttoptr (i64 4080 to i32*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_double_int32_t(double %str) {
; CHECK-P10-LABEL: st_cst_align32_double_int32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxws f0, f1
; CHECK-P10-NEXT:    pli r3, 9999900
; CHECK-P10-NEXT:    stfiwx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_cst_align32_double_int32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f1
; CHECK-PREP10-NEXT:    lis r3, 152
; CHECK-PREP10-NEXT:    ori r3, r3, 38428
; CHECK-PREP10-NEXT:    stfiwx f0, 0, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fptosi double %str to i32
  store i32 %conv, i32* inttoptr (i64 9999900 to i32*), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_double_int32_t(double %str) {
; CHECK-P10-LABEL: st_cst_align64_double_int32_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxws f0, f1
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    stfiwx f0, 0, r3
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_cst_align64_double_int32_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpsxws f0, f1
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    stfiwx f0, 0, r3
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fptosi double %str to i32
  store i32 %conv, i32* inttoptr (i64 1000000000000 to i32*), align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_double_uint64_t(i64 %ptr, double %str) {
; CHECK-POSTP8-LABEL: st_0_double_uint64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds v2, f1
; CHECK-POSTP8-NEXT:    stxsd v2, 0(r3)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_0_double_uint64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpuxds f0, f1
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i64
  %0 = inttoptr i64 %ptr to i64*
  store i64 %conv, i64* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_double_uint64_t(i8* nocapture %ptr, double %str) {
; CHECK-POSTP8-LABEL: st_align16_double_uint64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds v2, f1
; CHECK-POSTP8-NEXT:    stxsd v2, 8(r3)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_align16_double_uint64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpuxds f0, f1
; CHECK-P8-NEXT:    li r4, 8
; CHECK-P8-NEXT:    stxsdx f0, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i64
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 8
  %0 = bitcast i8* %add.ptr to i64*
  store i64 %conv, i64* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_double_uint64_t(i8* nocapture %ptr, double %str) {
; CHECK-P10-LABEL: st_align32_double_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxds f0, f1
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    stxsdx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align32_double_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpuxds f0, f1
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    stxsdx f0, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fptoui double %str to i64
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999000
  %0 = bitcast i8* %add.ptr to i64*
  store i64 %conv, i64* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_double_uint64_t(i8* nocapture %ptr, double %str) {
; CHECK-P10-LABEL: st_align64_double_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxds f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stxsdx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align64_double_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpuxds f0, f1
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    stxsdx f0, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fptoui double %str to i64
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000000
  %0 = bitcast i8* %add.ptr to i64*
  store i64 %conv, i64* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_double_uint64_t(i8* nocapture %ptr, i64 %off, double %str) {
; CHECK-LABEL: st_reg_double_uint64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpuxds f0, f1
; CHECK-NEXT:    stxsdx f0, r3, r4
; CHECK-NEXT:    blr
entry:
  %conv = fptoui double %str to i64
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %off
  %0 = bitcast i8* %add.ptr to i64*
  store i64 %conv, i64* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_double_uint64_t(i64 %ptr, i8 zeroext %off, double %str) {
; CHECK-POSTP8-LABEL: st_or1_double_uint64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds v2, f1
; CHECK-POSTP8-NEXT:    or r3, r4, r3
; CHECK-POSTP8-NEXT:    stxsd v2, 0(r3)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_or1_double_uint64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpuxds f0, f1
; CHECK-P8-NEXT:    or r3, r4, r3
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i64
  %conv1 = zext i8 %off to i64
  %or = or i64 %conv1, %ptr
  %0 = inttoptr i64 %or to i64*
  store i64 %conv, i64* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_double_uint64_t(i64 %ptr, double %str) {
; CHECK-POSTP8-LABEL: st_not_disjoint16_double_uint64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds v2, f1
; CHECK-POSTP8-NEXT:    ori r3, r3, 6
; CHECK-POSTP8-NEXT:    stxsd v2, 0(r3)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint16_double_uint64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpuxds f0, f1
; CHECK-P8-NEXT:    ori r3, r3, 6
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i64
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to i64*
  store i64 %conv, i64* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_double_uint64_t(i64 %ptr, double %str) {
; CHECK-POSTP8-LABEL: st_disjoint_align16_double_uint64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds v2, f1
; CHECK-POSTP8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-POSTP8-NEXT:    stxsd v2, 24(r3)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align16_double_uint64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpuxds f0, f1
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-NEXT:    ori r3, r3, 24
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = fptoui double %str to i64
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to i64*
  store i64 %conv, i64* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_double_uint64_t(i64 %ptr, double %str) {
; CHECK-POSTP8-LABEL: st_not_disjoint32_double_uint64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds v2, f1
; CHECK-POSTP8-NEXT:    ori r3, r3, 34463
; CHECK-POSTP8-NEXT:    oris r3, r3, 1
; CHECK-POSTP8-NEXT:    stxsd v2, 0(r3)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint32_double_uint64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpuxds f0, f1
; CHECK-P8-NEXT:    ori r3, r3, 34463
; CHECK-P8-NEXT:    oris r3, r3, 1
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i64
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to i64*
  store i64 %conv, i64* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_double_uint64_t(i64 %ptr, double %str) {
; CHECK-P10-LABEL: st_disjoint_align32_double_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxds f0, f1
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    stxsdx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align32_double_uint64_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpuxds f0, f1
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    stxsdx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align32_double_uint64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpuxds f0, f1
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r5, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r4, r5, 41712
; CHECK-P8-NEXT:    stxsdx f0, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %conv = fptoui double %str to i64
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to i64*
  store i64 %conv, i64* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_double_uint64_t(i64 %ptr, double %str) {
; CHECK-P10-LABEL: st_not_disjoint64_double_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxds v2, f1
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    stxsd v2, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_not_disjoint64_double_uint64_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 29
; CHECK-P9-NEXT:    xscvdpuxds v2, f1
; CHECK-P9-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-NEXT:    oris r4, r4, 54437
; CHECK-P9-NEXT:    ori r4, r4, 4097
; CHECK-P9-NEXT:    or r3, r3, r4
; CHECK-P9-NEXT:    stxsd v2, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint64_double_uint64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpuxds f0, f1
; CHECK-P8-NEXT:    li r4, 29
; CHECK-P8-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-NEXT:    oris r4, r4, 54437
; CHECK-P8-NEXT:    ori r4, r4, 4097
; CHECK-P8-NEXT:    or r3, r3, r4
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i64
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to i64*
  store i64 %conv, i64* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_double_uint64_t(i64 %ptr, double %str) {
; CHECK-P10-LABEL: st_disjoint_align64_double_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxds f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stxsdx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align64_double_uint64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpuxds f0, f1
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    stxsdx f0, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %conv = fptoui double %str to i64
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to i64*
  store i64 %conv, i64* %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_double_uint64_t(double %str) {
; CHECK-POSTP8-LABEL: st_cst_align16_double_uint64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds v2, f1
; CHECK-POSTP8-NEXT:    stxsd v2, 4080(0)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align16_double_uint64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpuxds f0, f1
; CHECK-P8-NEXT:    li r3, 4080
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i64
  store i64 %conv, i64* inttoptr (i64 4080 to i64*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_double_uint64_t(double %str) {
; CHECK-POSTP8-LABEL: st_cst_align32_double_uint64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpuxds v2, f1
; CHECK-POSTP8-NEXT:    lis r3, 153
; CHECK-POSTP8-NEXT:    stxsd v2, -27108(r3)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align32_double_uint64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpuxds f0, f1
; CHECK-P8-NEXT:    lis r3, 152
; CHECK-P8-NEXT:    ori r3, r3, 38428
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i64
  store i64 %conv, i64* inttoptr (i64 9999900 to i64*), align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_double_uint64_t(double %str) {
; CHECK-P10-LABEL: st_cst_align64_double_uint64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpuxds v2, f1
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    stxsd v2, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_align64_double_uint64_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpuxds v2, f1
; CHECK-P9-NEXT:    lis r3, 3725
; CHECK-P9-NEXT:    ori r3, r3, 19025
; CHECK-P9-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-NEXT:    stxsd v2, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align64_double_uint64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpuxds f0, f1
; CHECK-P8-NEXT:    lis r3, 3725
; CHECK-P8-NEXT:    ori r3, r3, 19025
; CHECK-P8-NEXT:    rldic r3, r3, 12, 24
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptoui double %str to i64
  store i64 %conv, i64* inttoptr (i64 1000000000000 to i64*), align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_double_int64_t(i64 %ptr, double %str) {
; CHECK-POSTP8-LABEL: st_0_double_int64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds v2, f1
; CHECK-POSTP8-NEXT:    stxsd v2, 0(r3)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_0_double_int64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxds f0, f1
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i64
  %0 = inttoptr i64 %ptr to i64*
  store i64 %conv, i64* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_double_int64_t(i8* nocapture %ptr, double %str) {
; CHECK-POSTP8-LABEL: st_align16_double_int64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds v2, f1
; CHECK-POSTP8-NEXT:    stxsd v2, 8(r3)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_align16_double_int64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxds f0, f1
; CHECK-P8-NEXT:    li r4, 8
; CHECK-P8-NEXT:    stxsdx f0, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i64
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 8
  %0 = bitcast i8* %add.ptr to i64*
  store i64 %conv, i64* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_double_int64_t(i8* nocapture %ptr, double %str) {
; CHECK-P10-LABEL: st_align32_double_int64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxds f0, f1
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    stxsdx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align32_double_int64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpsxds f0, f1
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    stxsdx f0, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fptosi double %str to i64
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999000
  %0 = bitcast i8* %add.ptr to i64*
  store i64 %conv, i64* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_double_int64_t(i8* nocapture %ptr, double %str) {
; CHECK-P10-LABEL: st_align64_double_int64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxds f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stxsdx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align64_double_int64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpsxds f0, f1
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    stxsdx f0, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fptosi double %str to i64
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000000
  %0 = bitcast i8* %add.ptr to i64*
  store i64 %conv, i64* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_double_int64_t(i8* nocapture %ptr, i64 %off, double %str) {
; CHECK-LABEL: st_reg_double_int64_t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpsxds f0, f1
; CHECK-NEXT:    stxsdx f0, r3, r4
; CHECK-NEXT:    blr
entry:
  %conv = fptosi double %str to i64
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %off
  %0 = bitcast i8* %add.ptr to i64*
  store i64 %conv, i64* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_double_int64_t(i64 %ptr, i8 zeroext %off, double %str) {
; CHECK-POSTP8-LABEL: st_or1_double_int64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds v2, f1
; CHECK-POSTP8-NEXT:    or r3, r4, r3
; CHECK-POSTP8-NEXT:    stxsd v2, 0(r3)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_or1_double_int64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxds f0, f1
; CHECK-P8-NEXT:    or r3, r4, r3
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i64
  %conv1 = zext i8 %off to i64
  %or = or i64 %conv1, %ptr
  %0 = inttoptr i64 %or to i64*
  store i64 %conv, i64* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_double_int64_t(i64 %ptr, double %str) {
; CHECK-POSTP8-LABEL: st_not_disjoint16_double_int64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds v2, f1
; CHECK-POSTP8-NEXT:    ori r3, r3, 6
; CHECK-POSTP8-NEXT:    stxsd v2, 0(r3)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint16_double_int64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxds f0, f1
; CHECK-P8-NEXT:    ori r3, r3, 6
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i64
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to i64*
  store i64 %conv, i64* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_double_int64_t(i64 %ptr, double %str) {
; CHECK-POSTP8-LABEL: st_disjoint_align16_double_int64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds v2, f1
; CHECK-POSTP8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-POSTP8-NEXT:    stxsd v2, 24(r3)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align16_double_int64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxds f0, f1
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-NEXT:    ori r3, r3, 24
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = fptosi double %str to i64
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to i64*
  store i64 %conv, i64* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_double_int64_t(i64 %ptr, double %str) {
; CHECK-POSTP8-LABEL: st_not_disjoint32_double_int64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds v2, f1
; CHECK-POSTP8-NEXT:    ori r3, r3, 34463
; CHECK-POSTP8-NEXT:    oris r3, r3, 1
; CHECK-POSTP8-NEXT:    stxsd v2, 0(r3)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint32_double_int64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxds f0, f1
; CHECK-P8-NEXT:    ori r3, r3, 34463
; CHECK-P8-NEXT:    oris r3, r3, 1
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i64
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to i64*
  store i64 %conv, i64* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_double_int64_t(i64 %ptr, double %str) {
; CHECK-P10-LABEL: st_disjoint_align32_double_int64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxds f0, f1
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    stxsdx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align32_double_int64_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpsxds f0, f1
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    stxsdx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align32_double_int64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxds f0, f1
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r5, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r4, r5, 41712
; CHECK-P8-NEXT:    stxsdx f0, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %conv = fptosi double %str to i64
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to i64*
  store i64 %conv, i64* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_double_int64_t(i64 %ptr, double %str) {
; CHECK-P10-LABEL: st_not_disjoint64_double_int64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxds v2, f1
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    stxsd v2, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_not_disjoint64_double_int64_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 29
; CHECK-P9-NEXT:    xscvdpsxds v2, f1
; CHECK-P9-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-NEXT:    oris r4, r4, 54437
; CHECK-P9-NEXT:    ori r4, r4, 4097
; CHECK-P9-NEXT:    or r3, r3, r4
; CHECK-P9-NEXT:    stxsd v2, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint64_double_int64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxds f0, f1
; CHECK-P8-NEXT:    li r4, 29
; CHECK-P8-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-NEXT:    oris r4, r4, 54437
; CHECK-P8-NEXT:    ori r4, r4, 4097
; CHECK-P8-NEXT:    or r3, r3, r4
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i64
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to i64*
  store i64 %conv, i64* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_double_int64_t(i64 %ptr, double %str) {
; CHECK-P10-LABEL: st_disjoint_align64_double_int64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxds f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stxsdx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align64_double_int64_t:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xscvdpsxds f0, f1
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    stxsdx f0, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %conv = fptosi double %str to i64
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to i64*
  store i64 %conv, i64* %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_double_int64_t(double %str) {
; CHECK-POSTP8-LABEL: st_cst_align16_double_int64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds v2, f1
; CHECK-POSTP8-NEXT:    stxsd v2, 4080(0)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align16_double_int64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxds f0, f1
; CHECK-P8-NEXT:    li r3, 4080
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i64
  store i64 %conv, i64* inttoptr (i64 4080 to i64*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_double_int64_t(double %str) {
; CHECK-POSTP8-LABEL: st_cst_align32_double_int64_t:
; CHECK-POSTP8:       # %bb.0: # %entry
; CHECK-POSTP8-NEXT:    xscvdpsxds v2, f1
; CHECK-POSTP8-NEXT:    lis r3, 153
; CHECK-POSTP8-NEXT:    stxsd v2, -27108(r3)
; CHECK-POSTP8-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align32_double_int64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxds f0, f1
; CHECK-P8-NEXT:    lis r3, 152
; CHECK-P8-NEXT:    ori r3, r3, 38428
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i64
  store i64 %conv, i64* inttoptr (i64 9999900 to i64*), align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_double_int64_t(double %str) {
; CHECK-P10-LABEL: st_cst_align64_double_int64_t:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xscvdpsxds v2, f1
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    stxsd v2, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_align64_double_int64_t:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xscvdpsxds v2, f1
; CHECK-P9-NEXT:    lis r3, 3725
; CHECK-P9-NEXT:    ori r3, r3, 19025
; CHECK-P9-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-NEXT:    stxsd v2, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align64_double_int64_t:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xscvdpsxds f0, f1
; CHECK-P8-NEXT:    lis r3, 3725
; CHECK-P8-NEXT:    ori r3, r3, 19025
; CHECK-P8-NEXT:    rldic r3, r3, 12, 24
; CHECK-P8-NEXT:    stxsdx f0, 0, r3
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptosi double %str to i64
  store i64 %conv, i64* inttoptr (i64 1000000000000 to i64*), align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_double_float(i64 %ptr, double %str) {
; CHECK-LABEL: st_0_double_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xsrsp f0, f1
; CHECK-NEXT:    stfs f0, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = fptrunc double %str to float
  %0 = inttoptr i64 %ptr to float*
  store float %conv, float* %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_double_float(i8* nocapture %ptr, double %str) {
; CHECK-LABEL: st_align16_double_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xsrsp f0, f1
; CHECK-NEXT:    stfs f0, 8(r3)
; CHECK-NEXT:    blr
entry:
  %conv = fptrunc double %str to float
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 8
  %0 = bitcast i8* %add.ptr to float*
  store float %conv, float* %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_double_float(i8* nocapture %ptr, double %str) {
; CHECK-P10-LABEL: st_align32_double_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xsrsp f0, f1
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    stfsx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align32_double_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xsrsp f0, f1
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    stfsx f0, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fptrunc double %str to float
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999000
  %0 = bitcast i8* %add.ptr to float*
  store float %conv, float* %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_double_float(i8* nocapture %ptr, double %str) {
; CHECK-P10-LABEL: st_align64_double_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xsrsp f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stfsx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align64_double_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xsrsp f0, f1
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    stfsx f0, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fptrunc double %str to float
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000000
  %0 = bitcast i8* %add.ptr to float*
  store float %conv, float* %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_double_float(i8* nocapture %ptr, i64 %off, double %str) {
; CHECK-LABEL: st_reg_double_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xsrsp f0, f1
; CHECK-NEXT:    stfsx f0, r3, r4
; CHECK-NEXT:    blr
entry:
  %conv = fptrunc double %str to float
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %off
  %0 = bitcast i8* %add.ptr to float*
  store float %conv, float* %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_double_float(i64 %ptr, i8 zeroext %off, double %str) {
; CHECK-LABEL: st_or1_double_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xsrsp f0, f1
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    stfs f0, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = fptrunc double %str to float
  %conv1 = zext i8 %off to i64
  %or = or i64 %conv1, %ptr
  %0 = inttoptr i64 %or to float*
  store float %conv, float* %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_double_float(i64 %ptr, double %str) {
; CHECK-LABEL: st_not_disjoint16_double_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xsrsp f0, f1
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    stfs f0, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = fptrunc double %str to float
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to float*
  store float %conv, float* %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_double_float(i64 %ptr, double %str) {
; CHECK-LABEL: st_disjoint_align16_double_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xsrsp f0, f1
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    stfs f0, 24(r3)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = fptrunc double %str to float
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to float*
  store float %conv, float* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_double_float(i64 %ptr, double %str) {
; CHECK-LABEL: st_not_disjoint32_double_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xsrsp f0, f1
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    stfs f0, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = fptrunc double %str to float
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to float*
  store float %conv, float* %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_double_float(i64 %ptr, double %str) {
; CHECK-P10-LABEL: st_disjoint_align32_double_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xsrsp f0, f1
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    stfsx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align32_double_float:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xsrsp f0, f1
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    stfsx f0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align32_double_float:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xsrsp f0, f1
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r5, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r4, r5, 41712
; CHECK-P8-NEXT:    stfsx f0, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %conv = fptrunc double %str to float
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to float*
  store float %conv, float* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_double_float(i64 %ptr, double %str) {
; CHECK-P10-LABEL: st_not_disjoint64_double_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xsrsp f0, f1
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    stfs f0, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_not_disjoint64_double_float:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 29
; CHECK-P9-NEXT:    xsrsp f0, f1
; CHECK-P9-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-NEXT:    oris r4, r4, 54437
; CHECK-P9-NEXT:    ori r4, r4, 4097
; CHECK-P9-NEXT:    or r3, r3, r4
; CHECK-P9-NEXT:    stfs f0, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_not_disjoint64_double_float:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xsrsp f0, f1
; CHECK-P8-NEXT:    li r4, 29
; CHECK-P8-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-NEXT:    oris r4, r4, 54437
; CHECK-P8-NEXT:    ori r4, r4, 4097
; CHECK-P8-NEXT:    or r3, r3, r4
; CHECK-P8-NEXT:    stfs f0, 0(r3)
; CHECK-P8-NEXT:    blr
entry:
  %conv = fptrunc double %str to float
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to float*
  store float %conv, float* %0, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_double_float(i64 %ptr, double %str) {
; CHECK-P10-LABEL: st_disjoint_align64_double_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xsrsp f0, f1
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stfsx f0, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align64_double_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xsrsp f0, f1
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    stfsx f0, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %conv = fptrunc double %str to float
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to float*
  store float %conv, float* %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_double_float(double %str) {
; CHECK-LABEL: st_cst_align16_double_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xsrsp f0, f1
; CHECK-NEXT:    stfs f0, 4080(0)
; CHECK-NEXT:    blr
entry:
  %conv = fptrunc double %str to float
  store float %conv, float* inttoptr (i64 4080 to float*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_double_float(double %str) {
; CHECK-LABEL: st_cst_align32_double_float:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xsrsp f0, f1
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    stfs f0, -27108(r3)
; CHECK-NEXT:    blr
entry:
  %conv = fptrunc double %str to float
  store float %conv, float* inttoptr (i64 9999900 to float*), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_double_float(double %str) {
; CHECK-P10-LABEL: st_cst_align64_double_float:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    xsrsp f0, f1
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    stfs f0, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_cst_align64_double_float:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    xsrsp f0, f1
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    stfs f0, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %conv = fptrunc double %str to float
  store float %conv, float* inttoptr (i64 1000000000000 to float*), align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_double_double(i64 %ptr, double %str) {
; CHECK-LABEL: st_0_double_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stfd f1, 0(r3)
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to double*
  store double %str, double* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_double_double(i8* nocapture %ptr, double %str) {
; CHECK-LABEL: st_align16_double_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stfd f1, 8(r3)
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 8
  %0 = bitcast i8* %add.ptr to double*
  store double %str, double* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_double_double(i8* nocapture %ptr, double %str) {
; CHECK-P10-LABEL: st_align32_double_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    stfdx f1, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align32_double_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    stfdx f1, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999000
  %0 = bitcast i8* %add.ptr to double*
  store double %str, double* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_double_double(i8* nocapture %ptr, double %str) {
; CHECK-P10-LABEL: st_align64_double_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stfdx f1, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align64_double_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    stfdx f1, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000000
  %0 = bitcast i8* %add.ptr to double*
  store double %str, double* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_double_double(i8* nocapture %ptr, i64 %off, double %str) {
; CHECK-LABEL: st_reg_double_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stfdx f1, r3, r4
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %off
  %0 = bitcast i8* %add.ptr to double*
  store double %str, double* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_double_double(i64 %ptr, i8 zeroext %off, double %str) {
; CHECK-LABEL: st_or1_double_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    stfd f1, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to double*
  store double %str, double* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_double_double(i64 %ptr, double %str) {
; CHECK-LABEL: st_not_disjoint16_double_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    stfd f1, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to double*
  store double %str, double* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_double_double(i64 %ptr, double %str) {
; CHECK-LABEL: st_disjoint_align16_double_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    stfd f1, 24(r3)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to double*
  store double %str, double* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_double_double(i64 %ptr, double %str) {
; CHECK-LABEL: st_not_disjoint32_double_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    stfd f1, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to double*
  store double %str, double* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_double_double(i64 %ptr, double %str) {
; CHECK-P10-LABEL: st_disjoint_align32_double_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    stfdx f1, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align32_double_double:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    stfdx f1, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align32_double_double:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, -15264
; CHECK-P8-NEXT:    lis r5, 15258
; CHECK-P8-NEXT:    and r3, r3, r4
; CHECK-P8-NEXT:    ori r4, r5, 41712
; CHECK-P8-NEXT:    stfdx f1, r3, r4
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to double*
  store double %str, double* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_double_double(i64 %ptr, double %str) {
; CHECK-P10-LABEL: st_not_disjoint64_double_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    stfd f1, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_not_disjoint64_double_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r4
; CHECK-PREP10-NEXT:    stfd f1, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to double*
  store double %str, double* %0, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_double_double(i64 %ptr, double %str) {
; CHECK-P10-LABEL: st_disjoint_align64_double_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stfdx f1, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_disjoint_align64_double_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    stfdx f1, r3, r4
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to double*
  store double %str, double* %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_double_double(double %str) {
; CHECK-LABEL: st_cst_align16_double_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stfd f1, 4080(0)
; CHECK-NEXT:    blr
entry:
  store double %str, double* inttoptr (i64 4080 to double*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_double_double(double %str) {
; CHECK-LABEL: st_cst_align32_double_double:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r3, 153
; CHECK-NEXT:    stfd f1, -27108(r3)
; CHECK-NEXT:    blr
entry:
  store double %str, double* inttoptr (i64 9999900 to double*), align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_double_double(double %str) {
; CHECK-P10-LABEL: st_cst_align64_double_double:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    stfd f1, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_cst_align64_double_double:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r3, 3725
; CHECK-PREP10-NEXT:    ori r3, r3, 19025
; CHECK-PREP10-NEXT:    rldic r3, r3, 12, 24
; CHECK-PREP10-NEXT:    stfd f1, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  store double %str, double* inttoptr (i64 1000000000000 to double*), align 4096
  ret void
}
