/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*- */
/* libwpd
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Major Contributor(s):
 * Copyright (C) 2002 William Lachance (wrlach@gmail.com)
 * Copyright (C) 2002 Marc Maurer (uwog@uwog.net)
 *
 * For minor contributions see the git repository.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libwpd.sourceforge.net
 */

/* "This product is not manufactured, approved, or supported by
 * Corel Corporation or Corel Corporation Limited."
 */

#include "WP6AttributeGroup.h"
#include "WP6Listener.h"
#include "libwpd_internal.h"

WP6AttributeGroup::WP6AttributeGroup(WPXInputStream *input, WPXEncryption *encryption, uint8_t groupID) :
	WP6FixedLengthGroup(groupID),
	m_attribute(0)
{
	_read(input, encryption);
}

void WP6AttributeGroup::_readContents(WPXInputStream *input, WPXEncryption *encryption)
{
	m_attribute = readU8(input, encryption);
}

WP6AttributeOnGroup::WP6AttributeOnGroup(WPXInputStream *input, WPXEncryption *encryption, uint8_t groupID)
	: WP6AttributeGroup(input, encryption, groupID)
{
}

void WP6AttributeOnGroup::parse(WP6Listener *listener)
{
	// FIXME: handle flags
	listener->attributeChange(true, getAttribute());
}

WP6AttributeOffGroup::WP6AttributeOffGroup(WPXInputStream *input, WPXEncryption *encryption, uint8_t groupID)
	: WP6AttributeGroup(input, encryption, groupID)
{
}

void WP6AttributeOffGroup::parse(WP6Listener *listener)
{
	// FIXME: handle flags
	listener->attributeChange(false, getAttribute());
}
/* vim:set shiftwidth=4 softtabstop=4 noexpandtab: */
