// Copyright 2020 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script_Extensions=Thai`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v13.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x000E01, 0x000E3A],
    [0x000E40, 0x000E5B]
  ]
});
testPropertyEscapes(
  /^\p{Script_Extensions=Thai}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Thai}"
);
testPropertyEscapes(
  /^\p{Script_Extensions=Thai}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Thai}"
);
testPropertyEscapes(
  /^\p{scx=Thai}+$/u,
  matchSymbols,
  "\\p{scx=Thai}"
);
testPropertyEscapes(
  /^\p{scx=Thai}+$/u,
  matchSymbols,
  "\\p{scx=Thai}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x000E00],
    [0x000E3B, 0x000E3F],
    [0x000E5C, 0x00DBFF],
    [0x00E000, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script_Extensions=Thai}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Thai}"
);
testPropertyEscapes(
  /^\P{Script_Extensions=Thai}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Thai}"
);
testPropertyEscapes(
  /^\P{scx=Thai}+$/u,
  nonMatchSymbols,
  "\\P{scx=Thai}"
);
testPropertyEscapes(
  /^\P{scx=Thai}+$/u,
  nonMatchSymbols,
  "\\P{scx=Thai}"
);

reportCompare(0, 0);
