/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramMethod;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.util.ClassUtil;
import proguard.evaluation.SimplifiedInvocationUnit;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TracedReferenceValue;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.ReferenceTracingInvocationUnit;
import proguard.optimize.info.ParameterEscapeMarker;

public class ParameterTracingInvocationUnit
extends ReferenceTracingInvocationUnit {
    private static final boolean DEBUG = false;
    private Value[] parameters = new Value[256];

    public ParameterTracingInvocationUnit(SimplifiedInvocationUnit simplifiedInvocationUnit) {
        super(simplifiedInvocationUnit);
    }

    @Override
    public void setMethodParameterValue(Clazz clazz, RefConstant refConstant, int n, Value value) {
        super.setMethodParameterValue(clazz, refConstant, n, value);
        this.parameters[n] = value;
    }

    @Override
    public Value getMethodReturnValue(Clazz clazz, RefConstant refConstant, String string) {
        Value value = super.getMethodReturnValue(clazz, refConstant, string);
        if (value.computationalType() != 5) {
            return value;
        }
        Method method = (Method)refConstant.referencedMember;
        if (method != null) {
            int n = ((TracedReferenceValue)value).getTraceValue().instructionOffsetValue().instructionOffset(0);
            InstructionOffsetValue instructionOffsetValue = ParameterEscapeMarker.returnsExternalValues(method) ? new InstructionOffsetValue(n | 0x4000000) : (ParameterEscapeMarker.returnsNewInstances(method) ? new InstructionOffsetValue(n | 0x8000000) : null);
            long l = ParameterEscapeMarker.getReturnedParameters(method);
            int n2 = ClassUtil.internalMethodParameterCount(refConstant.getType(clazz), this.isStatic);
            for (int i = 0; i < n2; ++i) {
                TracedReferenceValue tracedReferenceValue;
                Value value2;
                if ((l & 1L << i) == 0L || !((value2 = this.parameters[i]) instanceof TracedReferenceValue) || !this.mayReturnType(refConstant.referencedClass, method, tracedReferenceValue = (TracedReferenceValue)value2)) continue;
                InstructionOffsetValue instructionOffsetValue2 = tracedReferenceValue.getTraceValue().instructionOffsetValue();
                instructionOffsetValue = instructionOffsetValue == null ? instructionOffsetValue2 : instructionOffsetValue.generalize(instructionOffsetValue2);
            }
            if (instructionOffsetValue != null) {
                return this.trace(value, instructionOffsetValue);
            }
        }
        return value;
    }

    private boolean mayReturnType(Clazz clazz, Method method, ReferenceValue referenceValue) {
        String string = ClassUtil.internalMethodReturnType(method.getDescriptor(clazz));
        Clazz[] clazzArray = method instanceof ProgramMethod ? ((ProgramMethod)method).referencedClasses : ((LibraryMethod)method).referencedClasses;
        Clazz clazz2 = clazzArray == null || !ClassUtil.isInternalClassType(string) ? null : clazzArray[clazzArray.length - 1];
        return referenceValue.instanceOf(string, clazz2) != -1;
    }
}

