/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.SimpleScrollPane;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import javax.swing.plaf.basic.DefaultMenuLayout;

public class BasicJidePopupMenuUI
extends BasicPopupMenuUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicJidePopupMenuUI();
    }

    @Override
    public Popup getPopup(JPopupMenu jPopupMenu, int n, int n2) {
        Popup popup = BasicJidePopupMenuUI.addScrollPaneIfNecessary(jPopupMenu, n, n2);
        return popup == null ? super.getPopup(jPopupMenu, n, n2) : popup;
    }

    public static Popup addScrollPaneIfNecessary(final JPopupMenu jPopupMenu, int n, int n2) {
        final SimpleScrollPane simpleScrollPane = new SimpleScrollPane(jPopupMenu, 20, 31);
        if (jPopupMenu instanceof JidePopupMenu && jPopupMenu.getPreferredSize().height != ((JidePopupMenu)jPopupMenu).getPreferredScrollableViewportSize().height) {
            Component[] componentArray;
            if (jPopupMenu.getLayout() instanceof DefaultMenuLayout && SystemInfo.isJdk6Above()) {
                jPopupMenu.setLayout(new BoxLayout(jPopupMenu, ((DefaultMenuLayout)jPopupMenu.getLayout()).getAxis()));
            }
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            simpleScrollPane.getScrollUpButton().setOpaque(true);
            simpleScrollPane.getScrollDownButton().setOpaque(true);
            simpleScrollPane.setBorder(BorderFactory.createEmptyBorder());
            for (Component component : componentArray = jPopupMenu.getComponents()) {
                if (!(component instanceof JMenuItem)) continue;
                ((JMenuItem)component).addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        if (changeEvent.getSource() instanceof JMenuItem && ((JMenuItem)changeEvent.getSource()).getModel().isArmed()) {
                            jPopupMenu.scrollRectToVisible(((JMenuItem)changeEvent.getSource()).getBounds());
                            Point point = simpleScrollPane.getViewport().getViewPosition();
                            simpleScrollPane.getScrollUpButton().setEnabled(point.y > 2);
                            simpleScrollPane.getScrollDownButton().setEnabled(point.y < simpleScrollPane.getViewport().getViewSize().height - simpleScrollPane.getViewport().getViewRect().height - 2);
                        }
                    }
                });
            }
            return popupFactory.getPopup(jPopupMenu.getInvoker(), simpleScrollPane, n, n2);
        }
        return null;
    }
}

