/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.ForwardOnlyResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;

class OracleReturnResultSet
extends ForwardOnlyResultSet {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
    public static final boolean TRACE = false;

    OracleReturnResultSet(PhysicalConnection physicalConnection, OracleStatement oracleStatement) throws SQLException {
        super(physicalConnection, oracleStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            super.close();
            this.statement.currentResultSet = null;
            this.statement.returnParamsFetched = false;
            this.statement.rowsDmlReturned = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            if (!this.statement.isAutoGeneratedKey) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            AutoKeyInfo autoKeyInfo = this.statement.autoKeyInfo;
            autoKeyInfo.statement = this.statement;
            autoKeyInfo.connection = this.connection;
            autoKeyInfo.initMetaData(this);
            return autoKeyInfo;
        }
    }
}

