package it.eng.jhove;

import edu.harvard.hul.ois.jhove.HandlerBase;
import java.util.ArrayList;
import java.util.List;
import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.OutputHandler;
import java.util.Iterator;

/**
 *  NullHandler a pseudo output handler to collect RepInfo instances..
 *
 *
 * Created: Mon Oct 23 15:24:25 2006
 *
 * @author <a href="mailto:saint@eng.it">Gian Uberto Lauri</a>
 * @version $Revision: 1.3 $
 */
public class NullHandler extends HandlerBase {
    List infoList = new ArrayList();

    private static final String NAME = "VIEW";
    private static final String RELEASE = "1.0";
    private static final int [] DATE = {2004, 11, 2};
    private static final String NOTE = "This is the JHOVE null output " +
	"handler, useful for retrieving a RepInfo froma a recursive analysis";

    private static final String RIGHTS = "Copyright 2006 Engineering Ingengeria Informatica S.p.a." +
	"Released under the GNU Lesser General Public License." +
	"Cryptoserver Library Copyright Engiweb Security, all rights reserved";

    /**
     * Creates a new instance of <code>NullHandler</code> .
     */
    public NullHandler() {
	super (NAME, RELEASE, DATE, NOTE, RIGHTS);
    }

    /**
     * <code>show</code> used to store the RepInfo object passed as parameter
     *
     * @param repInfo a <code>RepInfo</code> the RepInfo object to store
     */
    public final void show(final RepInfo repInfo) {
	infoList.add(repInfo);
    }

    /**
     * <code>show</code> Unused
     *
     */
    public void show ()

    {
    }

    /**
     * <code>show</code> Unused
     *
     * @param app an <code>App</code> Unused
     */
    public void show (App app)
    {
    }

    /**
     * <code>show</code> Unused
     *
     * @param module a <code>Module</code> Unused
     */
    public void show (Module module)
    {
    }

    /**
     * <code>showFooter</code> Unused
     *
     */
    public void showFooter ()
    {
    }

    /**
     * <code>show</code> Unused
     *
     * @param handler an <code>OutputHandler</code> Unused
     */
    public void show (OutputHandler handler)
    {

    }

    /**
     * <code>getRepInfos</code> Unused
     *
     * @return an <code>Iterator</code> Unused
     */
    public Iterator getRepInfos() {
	return infoList.iterator();
    }


    /**
     * <code>showHeader</code> does nothing
     *
     */
    public final void showHeader() {


    }


}
