//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Data/MaskItemCatalog.cpp
//! @brief     Implements class MaskItemCatalog
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2022
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/Model/Data/MaskItemCatalog.h"
#include "GUI/Model/Data/MaskItems.h"

MaskItem* MaskItemCatalog::create(Type type)
{
    switch (type) {
    case Type::RegionOfInterest:
        return new RegionOfInterestItem();
    case Type::Rectangle:
        return new RectangleItem();
    case Type::Polygon:
        return new PolygonItem();
    case Type::VerticalLine:
        return new VerticalLineItem();
    case Type::HorizontalLine:
        return new HorizontalLineItem();
    case Type::MaskAll:
        return new MaskAllItem();
    case Type::Ellipse:
        return new EllipseItem();
    }
    ASSERT(false);
}

QVector<MaskItemCatalog::Type> MaskItemCatalog::types()
{
    return {Type::RegionOfInterest, Type::Rectangle, Type::Polygon, Type::VerticalLine,
            Type::HorizontalLine,   Type::MaskAll,   Type::Ellipse};
}

UiInfo MaskItemCatalog::uiInfo(Type type)
{
    switch (type) {
    case Type::RegionOfInterest:
        return {"Region of interest", "", ""};
    case Type::Rectangle:
        return {"Rectangle", "", ""};
    case Type::Polygon:
        return {"Polygon", "", ""};
    case Type::VerticalLine:
        return {"Vertical line", "", ""};
    case Type::HorizontalLine:
        return {"Horizontal line", "", ""};
    case Type::MaskAll:
        return {"Mask all", "", ""};
    case Type::Ellipse:
        return {"Ellipse", "", ""};
    }
    ASSERT(false);
}

MaskItemCatalog::Type MaskItemCatalog::type(const MaskItem* item)
{
    if (dynamic_cast<const RegionOfInterestItem*>(item)) // has to be before test for Rectangle!
        return Type::RegionOfInterest;
    if (dynamic_cast<const RectangleItem*>(item))
        return Type::Rectangle;
    if (dynamic_cast<const PolygonItem*>(item))
        return Type::Polygon;
    if (dynamic_cast<const VerticalLineItem*>(item))
        return Type::VerticalLine;
    if (dynamic_cast<const HorizontalLineItem*>(item))
        return Type::HorizontalLine;
    if (dynamic_cast<const MaskAllItem*>(item))
        return Type::MaskAll;
    if (dynamic_cast<const EllipseItem*>(item))
        return Type::Ellipse;

    ASSERT(false);
}
