//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Support/Util/Style.h
//! @brief     Defines GUI::StyleUtils namespace
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_SUPPORT_UTIL_STYLE_H
#define BORNAGAIN_GUI_SUPPORT_UTIL_STYLE_H

#include <QFont>
#include <QString>

class QTreeView;
class QWidget;
class QLayout;
class QWidget;

namespace GUI::Style {

//! Sets style for the tree to use in property editors.
void setPropertyStyle(QTreeView* tree);

//! Returns string representing the style of QTreeView intended for property editor.
QString propertyTreeStyle();

//! Returns font for sections.
QFont sectionFont(bool bold = false);

//! Returns font for labels.
QFont labelFont(bool bold = false);

//! Make modal dialog resizable.
void setResizable(QDialog* dialog);

//! Returns size of largest letter of default system font.
QSize SizeOfLetterM(const QWidget* widget = nullptr);

//! Returns size in points of default system font.
int SystemPointSize();

} // namespace GUI::Style

#endif // BORNAGAIN_GUI_SUPPORT_UTIL_STYLE_H
