<?php
/*
+--------------------------------------------------------------------+
| CiviCRM version 4.7                                                |
+--------------------------------------------------------------------+
| Copyright CiviCRM LLC (c) 2004-2017                                |
+--------------------------------------------------------------------+
| This file is a part of CiviCRM.                                    |
|                                                                    |
| CiviCRM is free software; you can copy, modify, and distribute it  |
| under the terms of the GNU Affero General Public License           |
| Version 3, 19 November 2007 and the CiviCRM Licensing Exception.   |
|                                                                    |
| CiviCRM is distributed in the hope that it will be useful, but     |
| WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               |
| See the GNU Affero General Public License for more details.        |
|                                                                    |
| You should have received a copy of the GNU Affero General Public   |
| License and the CiviCRM Licensing Exception along                  |
| with this program; if not, contact CiviCRM LLC                     |
| at info[AT]civicrm[DOT]org. If you have questions about the        |
| GNU Affero General Public License or the licensing of CiviCRM,     |
| see the CiviCRM license FAQ at http://civicrm.org/licensing        |
+--------------------------------------------------------------------+
*/
/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2017
 *
 * Generated from xml/schema/CRM/Core/File.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:996b2702471b24fb13c740ef104ea1f9)
 */
require_once 'CRM/Core/DAO.php';
require_once 'CRM/Utils/Type.php';
/**
 * CRM_Core_DAO_File constructor.
 */
class CRM_Core_DAO_File extends CRM_Core_DAO {
  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  static $_tableName = 'civicrm_file';
  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var boolean
   */
  static $_log = true;
  /**
   * Unique ID
   *
   * @var int unsigned
   */
  public $id;
  /**
   * Type of file (e.g. Transcript, Income Tax Return, etc). FK to civicrm_option_value.
   *
   * @var int unsigned
   */
  public $file_type_id;
  /**
   * mime type of the document
   *
   * @var string
   */
  public $mime_type;
  /**
   * uri of the file on disk
   *
   * @var string
   */
  public $uri;
  /**
   * contents of the document
   *
   * @var mediumblob
   */
  public $document;
  /**
   * Additional descriptive text regarding this attachment (optional).
   *
   * @var string
   */
  public $description;
  /**
   * Date and time that this attachment was uploaded or written to server.
   *
   * @var datetime
   */
  public $upload_date;
  /**
   * Class constructor.
   */
  function __construct() {
    $this->__table = 'civicrm_file';
    parent::__construct();
  }
  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = array(
        'id' => array(
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('File ID') ,
          'description' => 'Unique ID',
          'required' => true,
          'table_name' => 'civicrm_file',
          'entity' => 'File',
          'bao' => 'CRM_Core_BAO_File',
          'localizable' => 0,
        ) ,
        'file_type_id' => array(
          'name' => 'file_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('File Type') ,
          'description' => 'Type of file (e.g. Transcript, Income Tax Return, etc). FK to civicrm_option_value.',
          'table_name' => 'civicrm_file',
          'entity' => 'File',
          'bao' => 'CRM_Core_BAO_File',
          'localizable' => 0,
        ) ,
        'mime_type' => array(
          'name' => 'mime_type',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Mime Type') ,
          'description' => 'mime type of the document',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_file',
          'entity' => 'File',
          'bao' => 'CRM_Core_BAO_File',
          'localizable' => 0,
        ) ,
        'uri' => array(
          'name' => 'uri',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Path') ,
          'description' => 'uri of the file on disk',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_file',
          'entity' => 'File',
          'bao' => 'CRM_Core_BAO_File',
          'localizable' => 0,
        ) ,
        'document' => array(
          'name' => 'document',
          'type' => CRM_Utils_Type::T_MEDIUMBLOB,
          'title' => ts('File Contents') ,
          'description' => 'contents of the document',
          'table_name' => 'civicrm_file',
          'entity' => 'File',
          'bao' => 'CRM_Core_BAO_File',
          'localizable' => 0,
        ) ,
        'description' => array(
          'name' => 'description',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('File Description') ,
          'description' => 'Additional descriptive text regarding this attachment (optional).',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_file',
          'entity' => 'File',
          'bao' => 'CRM_Core_BAO_File',
          'localizable' => 0,
        ) ,
        'upload_date' => array(
          'name' => 'upload_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('File Upload Date') ,
          'description' => 'Date and time that this attachment was uploaded or written to server.',
          'table_name' => 'civicrm_file',
          'entity' => 'File',
          'bao' => 'CRM_Core_BAO_File',
          'localizable' => 0,
        ) ,
      );
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }
  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }
  /**
   * Returns the names of this table
   *
   * @return string
   */
  static function getTableName() {
    return self::$_tableName;
  }
  /**
   * Returns if this table needs to be logged
   *
   * @return boolean
   */
  function getLog() {
    return self::$_log;
  }
  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &import($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'file', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &export($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'file', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of indices
   */
  public static function indices($localize = TRUE) {
    $indices = array();
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }
}
