<?php
/*
 +--------------------------------------------------------------------+
 | Copyright CiviCRM LLC. All rights reserved.                        |
 |                                                                    |
 | This work is published under the GNU AGPLv3 license with some      |
 | permitted exceptions and without any warranty. For full license    |
 | and copyright information, see https://civicrm.org/licensing       |
 +--------------------------------------------------------------------+
 */

/**
 *
 * @package CRM
 * @copyright CiviCRM LLC
 * $Id$
 *
 */

/**
 * Generate a secure signature
 *
 * {code}
 * {crmSigner var=mySig extra=123}
 * var urlParams = ts={$mySig.ts}&extra={$mySig.extra}&sig={$mySig.signature}
 * {endcode}
 *
 * @param array $params
 *   Array with keys:
 *   - var: string, a smarty variable to generate
 *   - ts: int, the current time (if omitted, autogenerated)
 *   - any other vars are put into the signature (sorted)
 * @param $smarty
 */
function smarty_function_crmSigner($params, &$smarty) {
  $var = $params['var'];
  unset($params['var']);
  $params['ts'] = CRM_Utils_Time::getTimeRaw();

  $fields = array_keys($params);
  sort($fields);

  $signer = new CRM_Utils_Signer(CRM_Core_Key::privateKey(), $fields);
  $params['signature'] = $signer->sign($params);
  $smarty->assign($var, $params);
}
