# CiviCRM 5.31.0

Released November 4, 2020

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| **Require attention to configuration options?**                 | **yes** |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Implement more nuanced "Administer CiviCRM" permisions
  ([16482](https://github.com/civicrm/civicrm-core/pull/16482) and
  [18671](https://github.com/civicrm/civicrm-core/pull/18671))**

  Actions that required the "Administer CiviCRM" permission now require one of
  two separate permissions: "administer CiviCRM system" and "administer CiviCRM
  data".  The "Administer CiviCRM" permission still exists, and users having it
  are treated as implicitly having both of the new permissions.

  However, it is now possible to grant permission to configure profiles,
  scheduled reminders, and set admin-only price options independently of
  granting permission to configure scheduled jobs, install extensions, and view
  the system check.  An organization might grant the former to senior staff and
  the latter to technical staff.

- **Buttonrama ([18410](https://github.com/civicrm/civicrm-core/pull/18410),
  [18820](https://github.com/civicrm/civicrm-core/pull/18820),
  [18834](https://github.com/civicrm/civicrm-core/pull/18834),
  [18799](https://github.com/civicrm/civicrm-core/pull/18799), and
  [307](https://github.com/civicrm/civicrm-packages/pull/307))**

  This ensures icons and text within buttons are aligned vertically, and it
  makes form buttons appear consistent with links that are rendered to appear
  like buttons.

  Specifically, most buttons are now `<button>` elements rather than `<input
  type="button">`, and button styling now applies to the button itself rather
  than a wrapper.  Extension and theme developers should confirm that CSS and
  DOM selectors accurately identify the intended button elements.

- **Custom field form reform
  ([18419](https://github.com/civicrm/civicrm-core/pull/18419))**

  This improves the form for creating or updating custom fields by improving
  validation, making defaults easier to select, and allowing more flexibility
  around changing the widget type.

- **Add higher-level support for "bundles" and "collections" of resources
  ([18247](https://github.com/civicrm/civicrm-core/pull/18247))**

  "Resources" refers to CSS, Javascript, and DOM variables that developers can
  add to certain pages.  These can now be bundled together to reduce redundant
  code and can be modified with the new `hook_civicrm_alterBundle()`.

  The core styles and other resources are now included as bundles, allowing them
  to be modified in a standard way.

  In addition, page regions, bundles, and (to some extent) page resources are
  now treated as "collections" which share a common interface for adding and
  retrieving individual resources.

- **Bootstrap3 CSS
  ([dev/user-interface#27](https://lab.civicrm.org/dev/user-interface/-/issues/27):
  [18354](https://github.com/civicrm/civicrm-core/pull/18354),
  [18465](https://github.com/civicrm/civicrm-core/pull/18465),
  [18550](https://github.com/civicrm/civicrm-core/pull/18550),
  [18583](https://github.com/civicrm/civicrm-core/pull/18583), and
  [18579](https://github.com/civicrm/civicrm-core/pull/18579))**

  CiviCRM introduced a theming system several years ago, but the existing look
  and feel was left as a "default", with the *de facto* theming code spread
  throughout the application.  The new themes have generally used Bootstrap 3 as
  a user interface framework.

  A handful of new CiviCRM features have been developed that depend on Bootstrap
  3 for core functionality or at least for basic look and feel.  Sites lacking a
  newer theme need a way to load at least a minimal set of Bootstrap 3 code for
  these features to be functional and attractive.

  This change introduces a new CiviCRM theme extension, named "Greenwich", that
  is enabled and hidden by default for all sites.  It provides Bootstrap 3 when
  needed.  In addition, it can serve as a vehicle for moving theming code out of
  core.

- **APIv4 Search: Improve GROUP_CONCAT with :label prefix
  ([18572](https://github.com/civicrm/civicrm-core/pull/18572))**

  This improves the Search UI by exposing the DISTINCT modifier and fixing
  currency formatting.

- **Search ext: rename to Search Kit, mark as beta
  ([18672](https://github.com/civicrm/civicrm-core/pull/18672))**

  An extension to replace the search user interface has been included, but
  hidden, in CiviCRM for several months.  Named Search Kit, it is now available
  to be enabled for sites.

- **Search extension: edit smart groups
  ([18431](https://github.com/civicrm/civicrm-core/pull/18431))**

  Search Kit can now edit smart groups.  When installed, the "edit smart group
  criteria" link will open the classic search forms or Search Kit as
  appropriate.

- **Search ext: support complex joins & HAVING clause in api4 smart groups
  ([18644](https://github.com/civicrm/civicrm-core/pull/18644))**

  Improves the new search extension and APIv4 smart groups in core to support
  any entity that can join with Contact, including full support for calculated
  fields and the HAVING clause.

- **Select field fixes for screen reader
  ([17675](https://github.com/civicrm/civicrm-core/pull/17675),
  [18873](https://github.com/civicrm/civicrm-core/pull/18873),
  [18889](https://github.com/civicrm/civicrm-core/pull/18889))**

  The placeholder text for select drop-down fields now reflects the field label.
  The Select2 widget makes it difficult for screen readers to identify the
  field's label, so this helps identify the field for users who rely on screen
  readers.

- **Add modified_date to list of activity tokens
  ([18611](https://github.com/civicrm/civicrm-core/pull/18611))**

  Adds Modified date to the list of available activity tokens.

- **Add an 'Execute Now' button to the job log
  ([18593](https://github.com/civicrm/civicrm-core/pull/18593))**

  Adds an "Execute Now" button to the Job log to make it easier to rerun a
  scheduled job if needed.

- **Send email to contacts when clicking on their email address on the contact's
  card ([dev/core#1790](https://lab.civicrm.org/dev/core/-/issues/1790):
  [18623](https://github.com/civicrm/civicrm-core/pull/18623))**

  Improves the contact card by making the email a link which takes the user to a
  form to send an email to that contact.

- **Ability to Search Smart or Normal Group using additional filter on Manage
  Group page ([dev/report#45](https://lab.civicrm.org/dev/report/-/issues/45):
  [18379](https://github.com/civicrm/civicrm-core/pull/18379) and
  [18246](https://github.com/civicrm/civicrm-core/pull/18246))**

  Adds a filter "Group Type" to the Manage Groups page which can be used
  to filter by normal or smart groups.

- **Ability to Send Invoice with modified subject and CC it
  ([dev/user-interface#30](https://lab.civicrm.org/dev/user-interface/-/issues/30):
  [18286](https://github.com/civicrm/civicrm-core/pull/18286))**

  Adds the ability to edit the subject and cc fields when emailing an invoice
  from a contribution.

- **Add ability to segment query logs
  ([dev/core#2032](https://lab.civicrm.org/dev/core/-/issues/2032):
  [18471](https://github.com/civicrm/civicrm-core/pull/18471) and
  [309](https://github.com/civicrm/civicrm-packages/pull/309))**

  SQL queries can be sent to a debugging log when the `CIVICRM_DEBUG_LOG_QUERY`
  environment variable is set. Now, the value of that variable can specify a
  file name for the log.

### CiviContribute

- **Move ACls on LineItem create to financialacls core extension
  ([18339](https://github.com/civicrm/civicrm-core/pull/18339))**

  Simplifies the code base by moving the financial ACL handling from the
  LineItem BAO to the financialacls core extension.

- **Convert core processors to use Guzzle and bring them under CI (Work Towards
  [dev/financial#143](https://lab.civicrm.org/dev/financial/-/issues/143):
  [18350](https://github.com/civicrm/civicrm-core/pull/18350))**

  The PayPal Pro payment processor integration now uses the Guzzle library for
  HTTP requests.  This improves consistency and allows for unit testing of the
  request handling.

- **Migrate Eway(Single Currency) Payment Processor Type out into its own
  extension ([18349](https://github.com/civicrm/civicrm-core/pull/18349))**

  The Eway payment processor is now a separate extension, albeit shipped with
  core.

- **Make 'Record Payment' & 'Record Refund' visible regardless of whether the
  balance 'requires' one
  ([dev/financial#86](https://lab.civicrm.org/dev/financial/-/issues/86):
  [18417](https://github.com/civicrm/civicrm-core/pull/18417))**

  Makes it so the "Record Payment" and "Record Refund" links on Contributions
  are always visible.

- **Alter the default of send notification to contributor checkbox on cancel or
  edit recurring to off
  ([dev/core#1986](https://lab.civicrm.org/dev/core/-/issues/1986):
  [18537](https://github.com/civicrm/civicrm-core/pull/18537))**

  The "notify contributor" checkbox on the form to cancel or edit a recurring
  donation is now unchecked by default.

- **PCP action links support for hook_civicrm_links
  ([dev/core#2061](https://lab.civicrm.org/dev/core/-/issues/2061):
  [18570](https://github.com/civicrm/civicrm-core/pull/18570))**

  This allows `hook_civicrm_links` to be used by extension developers to modify the
  list of actions offered to personal campaign page creators.

- **Add Line Item v4 API
  ([dev/core#1980](https://lab.civicrm.org/dev/core/-/issues/1980):
  [18388](https://github.com/civicrm/civicrm-core/pull/18388) and
  [18352](https://github.com/civicrm/civicrm-core/pull/18352))**

  Adds the "Line Item" entity to APIv4.

- **Improve metadata on LineItem DAO
  ([18521](https://github.com/civicrm/civicrm-core/pull/18521))**

  Adds labels to line item meta data.

### CiviMail

- **Add options to Mail Account settings to improve inbound mail processing
  ([18624](https://github.com/civicrm/civicrm-core/pull/18624))**

  Two new options are added to the Mail Account settings form to improve inbound
  email processing:

  1. 'Skip emails which do not have a Case ID or Case token'
  2. 'Do not create new contacts when filing emails'

- **Change wording on the Opt Out and Unsubscribe pages
  ([18338](https://github.com/civicrm/civicrm-core/pull/18338))**

  Improves messaging to end user on Opt Out and Unsubscribe pages.

### CiviMember

- **Add custom field groups to Membership Contribution Detail report
  ([dev/report#49](https://lab.civicrm.org/dev/report/-/issues/49):
  [18420](https://github.com/civicrm/civicrm-core/pull/18420))**

  Contact custom fields are now available on the Membership Contribution Detail
  report.

### Drupal Integration

- **Drupal 9 deprecations
  ([dev/drupal#138](https://lab.civicrm.org/dev/drupal/-/issues/138):
  [18461](https://github.com/civicrm/civicrm-core/pull/18461))**

  Drupal now allows for smooth upgrades between major versions by gradually
  introducing new API functions and deprecating others through the cycle of a
  major version.  A new major version starts by simply removing deprecated
  function from the latest release of the prior major version.

  This removes the use of a number of functions that have been deprecated since
  Drupal 8.5 and are removed in Drupal 9.  The result is that CiviCRM 5.31 is no
  longer compatible with Drupal versions prior to 8.5 but is compatible with
  Drupal 9.

- **Finish allowing use of SSL to connect to database
  (Work Towards [dev/core#1926](https://lab.civicrm.org/dev/core/-/issues/1926):
  [18264](https://github.com/civicrm/civicrm-core/pull/18264))**

  The setup screen now attempts to identify if the Drupal database connection
  uses SSL and fills the configuration options to match.

- **drush civicrm-ext-list add ext's status filter and show version number
  ([597](https://github.com/civicrm/civicrm-drupal/pull/597))**

  Extends the drush command `drush civicrm-ext-list` so that users can:

   - Filter by the extension's status (installed, uninstalled, disabled)
   - Show the extension version number in the result list
   - Use the `--out` option to print results as json or as a pretty table

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **"Network Error" when sorting contact search results by City, Postcode or
  Country ([dev/core#2132](https://lab.civicrm.org/dev/core/-/issues/2132):
  [18857](https://github.com/civicrm/civicrm-core/pull/18857))**

- **Public contribution form and Checksums: billing information not loaded if
  using multiple processors
  ([dev/core#334](https://lab.civicrm.org/dev/core/-/issues/334):
  [18642](https://github.com/civicrm/civicrm-core/pull/18642))**

  Custom data tables for contacts are now created with the charset and collation
  to match the `civicrm_contact` table.

  This resolves a bug when the billing information is not filled when visiting a
  contribution page with multiple payment processors via a checksum link.

- **Deadlocks on acl_cache
  (Work Towards [dev/core#1486](https://lab.civicrm.org/dev/core/-/issues/1486):
  [18403](https://github.com/civicrm/civicrm-core/pull/18403))**

  Removes foreign keys from the ACL cache tables as they are likely to
  hinder performance.

- **APIv4 - revisit required parameters on location entities
  ([dev/core#2044](https://lab.civicrm.org/dev/core/-/issues/2044):
  [18575](https://github.com/civicrm/civicrm-core/pull/18575))**

  Makes it so that APIv4 can be used for creating event locations by making
  contact_id optional for the Address, Phone and Email entities.

- **Eliminate "No extensions available for this version of CiviCRM"
  ([dev/core#2063](https://lab.civicrm.org/dev/core/-/issues/2063):
  [18596](https://github.com/civicrm/civicrm-core/pull/18596))**

  Fixes warning thrown when no public extensions directory is found.

- **Group ids in profile fields are not correct
  ([dev/core#2125](https://lab.civicrm.org/dev/core/-/issues/2125):
  [18776](https://github.com/civicrm/civicrm-core/pull/18776))**

  Fixes DB errors when using the groups field in a profile.

- **Drupal 7 + 9 Groups dont show in edit with version 5.30.1
  ([dev/core#2136](https://lab.civicrm.org/dev/core/-/issues/2136):
  [18831](https://github.com/civicrm/civicrm-core/pull/18831))**

- **Rebuild triggers after utf8mb4 conversion
  ([18751](https://github.com/civicrm/civicrm-core/pull/18751))**

  When the `System.utf8conversion` API call is run, this ensures that the
  triggers for relationship_cache are updated to use the right encoding.

- **Remove explicit COLLATE utf8_bin from RelationshipCache trigger
  ([18721](https://github.com/civicrm/civicrm-core/pull/18721))**

  Ensure that relationship types can be edited after switching to utf8mb4.

- **Fix way of identifying custom serialized fields
  ([18360](https://github.com/civicrm/civicrm-core/pull/18360))**

  Removes references to field types that no longer exist, specifically the
  'Multi-Select', 'Multi-Select State/Province', and 'Multi-Select Country',
  custom field types, which were all removed in 5.27.

- **Exclude api4 from IDS check
  ([18695](https://github.com/civicrm/civicrm-core/pull/18695))**

  Fixes false-positive "suspicious activity" warnings in the IDS (Intrusion
  Detection System) when using APIv4.

- **Fix complexity on cache key
  ([18650](https://github.com/civicrm/civicrm-core/pull/18650))**

  Ensures that the cacheKey does not cross-populate values from different users.

- **Use title instead name in status message
  ([18406](https://github.com/civicrm/civicrm-core/pull/18406))**

  Fixes help text when an option group is saved to show the title of the option
  group instead of the name.

- **Export fix on long custom fields
  ([18146](https://github.com/civicrm/civicrm-core/pull/18146))**

  This resolves problems exporting custom fields that have long option values.

- **Contact form task delete php spelling fix
  ([18399](https://github.com/civicrm/civicrm-core/pull/18399))**

- **Component Titles are not translated on the Configuration Checklist page
  ([dev/translation#54](https://lab.civicrm.org/dev/translation/-/issues/54):
  [18690](https://github.com/civicrm/civicrm-core/pull/18690))**

- **Error when viewing contact merged to permanently deleted contact
  ([dev/core#1838](https://lab.civicrm.org/dev/core/-/issues/1838):
  [18564](https://github.com/civicrm/civicrm-core/pull/18564))**

  When one contact is merged to another contact, the first contact remains in
  the trash and refers to the second.  However, there was a bug preventing that
  first contact from being viewed if the second contact was deleted permanently.

- **E_WARNING when editing custom field with trigger-based logging turned on
  ([dev/core#1989](https://lab.civicrm.org/dev/core/-/issues/1989):
  [18386](https://github.com/civicrm/civicrm-core/pull/18386))**

- **Northern Ireland / Wales counties are out of date
  ([dev/core#2027](https://lab.civicrm.org/dev/core/-/issues/2027):
  [18470](https://github.com/civicrm/civicrm-core/pull/18470))**

- **Multiple email activity cc recipients get scrunched together in recorded
  activity details field
  ([dev/core#2040](https://lab.civicrm.org/dev/core/-/issues/2040):
  [18504](https://github.com/civicrm/civicrm-core/pull/18504))**

- **When exporting for composer-style deployment, exclude the `.gitignore` file
  ([18673](https://github.com/civicrm/civicrm-core/pull/18673))**

- **Fix patently silly code
  ([18652](https://github.com/civicrm/civicrm-core/pull/18652))**

- **Fix cache bypass
  ([18643](https://github.com/civicrm/civicrm-core/pull/18643))**

- **Fix bug in primary handling where TRUE rather than 1 used
  ([18598](https://github.com/civicrm/civicrm-core/pull/18598))**

- **Greenwich - fix conflict btw bootstrap & jQuery UI button
  ([18696](https://github.com/civicrm/civicrm-core/pull/18696))**

- **Remove double exception handling in repeattransaction
  ([18594](https://github.com/civicrm/civicrm-core/pull/18594))**

- **Preferred Language in a profile doesn't show/behave as required when so
  configured ([dev/core#1883](https://lab.civicrm.org/dev/core/-/issues/1883):
  [18595](https://github.com/civicrm/civicrm-core/pull/18595))**

- **Fix deprecation notice
  ([18541](https://github.com/civicrm/civicrm-core/pull/18541))**

- **Replace '&' to 'and' in button label
  ([18405](https://github.com/civicrm/civicrm-core/pull/18405))**

- **Performance - meta issue for hunting down memory leaks
  ([dev/core#2073](https://lab.civicrm.org/dev/core/-/issues/2073):
  [18640](https://github.com/civicrm/civicrm-core/pull/18640),
  [18701](https://github.com/civicrm/civicrm-core/pull/18701),
  [18699](https://github.com/civicrm/civicrm-core/pull/18699),
  [18702](https://github.com/civicrm/civicrm-core/pull/18702),
  [18700](https://github.com/civicrm/civicrm-core/pull/18700),
  [18692](https://github.com/civicrm/civicrm-core/pull/18692),
  [18693](https://github.com/civicrm/civicrm-core/pull/18693),
  [18633](https://github.com/civicrm/civicrm-core/pull/18633),
  [18641](https://github.com/civicrm/civicrm-core/pull/18641) and
  [18632](https://github.com/civicrm/civicrm-core/pull/18632))**

- **E_NOTICE viewing an activity that has no details contents
  ([dev/core#2075](https://lab.civicrm.org/dev/core/-/issues/2075):
  [18637](https://github.com/civicrm/civicrm-core/pull/18637))**

- **Undefined index on contact's activity tab when there's an activity that has
  no With Contact
  ([dev/core#2090](https://lab.civicrm.org/dev/core/-/issues/2090):
  [18669](https://github.com/civicrm/civicrm-core/pull/18669))**

- **Undefined index 'class' on new individual form
  ([dev/core#2093](https://lab.civicrm.org/dev/core/-/issues/2093):
  [18678](https://github.com/civicrm/civicrm-core/pull/18678))**

- **Deprecation warnings when making thank-you letters
  ([dev/core#2108](https://lab.civicrm.org/dev/core/-/issues/2108):
  [18717](https://github.com/civicrm/civicrm-core/pull/18717) and
  [18716](https://github.com/civicrm/civicrm-core/pull/18716))**

  This affects all PDF letters.

- **Fix the output of the full text custom search form
  ([18890](https://github.com/civicrm/civicrm-core/pull/18890))**

  This resolves styling issues on the full text search form.

- **For countries without a province N/A is not accepted as a state in a profile
  ([dev/core#2149](https://lab.civicrm.org/dev/core/-/issues/2149):
  [18877](https://github.com/civicrm/civicrm-core/pull/18877))**

- **IN operator not working in Search
  ([dev/core#2147](https://lab.civicrm.org/dev/core/-/issues/2147):
  [18898](https://github.com/civicrm/civicrm-core/pull/18898))**

  This changes the group search field in the basic "Find Contacts" search back
  to a plain select drop-down rather than a Select2 widget.

### CiviCampaign

- **Fix default report permissions when creating reports from CiviCampaign
  ([18493](https://github.com/civicrm/civicrm-core/pull/18493))**

  Ensures that CiviCampaign report titles are not accessible to users without
  proper permissions to view the report.

### CiviCase

- **Incorrect comparison of status_id when changing status of linked cases
  ([dev/core#1979](https://lab.civicrm.org/dev/core/-/issues/1979):
  [18309](https://github.com/civicrm/civicrm-core/pull/18309))**

### CiviContribute

- **View Payment owned by Different contact on Membership and Participant View.
  ([dev/report#48](https://lab.civicrm.org/dev/report/-/issues/48):
  [18281](https://github.com/civicrm/civicrm-core/pull/18281))**

  This ensures that related payments are displayed when viewing a Membership or
  Participant even if they come from a different contact.

- **Dropdown for country seems to have reverted to a regular select instead of
  select2 ([dev/core#2030](https://lab.civicrm.org/dev/core/-/issues/2030):
  [18533](https://github.com/civicrm/civicrm-core/pull/18533))**

  This resolves a bug in the display of the Country field in the billing address
  section of a contribution page.

- **Fix formatLocaleNumericRoundedByCurrency
  ([18409](https://github.com/civicrm/civicrm-core/pull/18409))**

  Ensures that currencies are rounded to the correct decimal point instead of
  always 2 decimal points.

- **change civicrm_price_set.min_amount to float
  ([18677](https://github.com/civicrm/civicrm-core/pull/18677))**

  Updates the price set minimum amount field to be float (not int).

- **Incorrect rounding up with priceset fields
  ([dev/core#2003](https://lab.civicrm.org/dev/core/-/issues/2003):
  [18297](https://github.com/civicrm/civicrm-core/pull/18297) and
  [18416](https://github.com/civicrm/civicrm-core/pull/18416))**

  Ensures the amount is saved to the database correctly for price field values
  when a value is entered longer than two decimals.

- **Display url_site and url_recur based on if the form elements exist
  ([18324](https://github.com/civicrm/civicrm-core/pull/18324))**

  Ensures developers can remove fields from the payment processor configuration
  form using the build form hook.

- **LineItem pre Hook non-standard on edit
  ([dev/core#1994](https://lab.civicrm.org/dev/core/-/issues/1994):
  [18340](https://github.com/civicrm/civicrm-core/pull/18340))**

  This resolves a bug in the entity ID sent to `hook_civicrm_pre` when editing
  line items.

- **Performance - do not retrieve soft credits & pcps when not required
  ([dev/core#2056](https://lab.civicrm.org/dev/core/-/issues/2056):
  [18556](https://github.com/civicrm/civicrm-core/pull/18556))**

- **Remove ajax timeout from contribution page on behalf of
  ([18140](https://github.com/civicrm/civicrm-core/pull/18140))**

- **property bag's setAmount should ensure dot decimal point
  ([18429](https://github.com/civicrm/civicrm-core/pull/18429))**

### CiviEvent

- **Contact Dashboard does not show event registrations for non-admins
  ([dev/event#43](https://lab.civicrm.org/dev/event/-/issues/43):
  [18758](https://github.com/civicrm/civicrm-core/pull/18758))**

- **Set participant status notification to false by default
  ([18544](https://github.com/civicrm/civicrm-core/pull/18544))**

  The "Send Notification" checkbox is now always unchecked when editing a participant's status.  Previously it would be checked by default when changing a status to "Cancelled" or from "Waitlist" or "Pending waitlist".

- **ParticipantListing Report: only display the View link for web, unhardcode
  others ([18704](https://github.com/civicrm/civicrm-core/pull/18704))**

  Ensures that when exporting the Participant Listing report the view links are
  not included.

- **Scheduled reminder: "Additional recipients" receive reminders under
  circumstances where they ought not to
  ([dev/core#1590](https://lab.civicrm.org/dev/core/-/issues/1590):
  [17641](https://github.com/civicrm/civicrm-core/pull/17641))**

  Ensures that "Additional recipients" do not receive reminders for deleted
  events.

- **Email & Phone storage issues in event location
  ([dev/core#1973](https://lab.civicrm.org/dev/core/-/issues/1973):
  [18488](https://github.com/civicrm/civicrm-core/pull/18488))**

  Ensures second email and phone values are saved for event locations.

- **Creating new event without email fails
  ([dev/core#2096](https://lab.civicrm.org/dev/core/-/issues/2096):
  [18710](https://github.com/civicrm/civicrm-core/pull/18710))**

- **Changing address on event hangs
  ([dev/core#2102](https://lab.civicrm.org/dev/core/-/issues/2102):
  [18713](https://github.com/civicrm/civicrm-core/pull/18713))**

### CiviGrant

- **Grant dashboard counts trashed contacts
  ([dev/core#2009](https://lab.civicrm.org/dev/core/-/issues/2009):
  [18428](https://github.com/civicrm/civicrm-core/pull/18428))**

### CiviMail

- **Possible regression on deleted contacts
  ([dev/core#2119](https://lab.civicrm.org/dev/core/-/issues/2119):
  [18763](https://github.com/civicrm/civicrm-core/pull/18763))**

  Ensures contacts deleted after a mailing is created do not get the mailing.

### CiviMember

- **Membership Renewal form re 'fixMembershipBeforeRenew'
  ([dev/membership#27](https://lab.civicrm.org/dev/membership/-/issues/27):
  [18621](https://github.com/civicrm/civicrm-core/pull/18621))**

  The status of an existing membership is now recalculated prior to loading the
  renewal form.  This allows an accurate status to be displayed and used for
  calculating renewal dates.

- **Membership status does not get updated during membership import when status
  override is set
  ([dev/membership#30](https://lab.civicrm.org/dev/membership/-/issues/30):
  [18821](https://github.com/civicrm/civicrm-core/pull/18821))**

- **Bug When Restoring Overridden Status on Related Memberships
  ([dev/core#1854](https://lab.civicrm.org/dev/core/-/issues/1854):
  [17742](https://github.com/civicrm/civicrm-core/pull/17742))**

  Ensures related memberships do not get deleted when running the membership
  status calculation scheduled job.

- **Fix for ongoing issues with static upsetting the apple cart
  ([18245](https://github.com/civicrm/civicrm-core/pull/18245))**

  Ensures that inherited relationships are created more reliably.

- **Multiple Memberships Status Not updated when payment status changed from
  pending to Completed
  ([dev/core#1942](https://lab.civicrm.org/dev/core/-/issues/1942):
  [18232](https://github.com/civicrm/civicrm-core/pull/18232))**

- **Make period_type mandatory for MembershipType
  ([18395](https://github.com/civicrm/civicrm-core/pull/18395))**

### Backdrop Integration

- **Check if BACKDROP_ROOT is defined already
  ([18545](https://github.com/civicrm/civicrm-core/pull/18545))**

  Fixes the "Constant BACKDROP_ROOT already defined..." notice.

### Drupal Integration

- **Make symfony aliased services public
  ([18443](https://github.com/civicrm/civicrm-core/pull/18443))**

  Fixes a warning on the extensions form for Drupal 8 sites.

- **Tarball includes a symlink that goes nowhere, which causes alternate drupal
  install method to fail
  ([dev/core#1393](https://lab.civicrm.org/dev/core/-/issues/1393):
  [18472](https://github.com/civicrm/civicrm-core/pull/18472),
  [18605](https://github.com/civicrm/civicrm-core/pull/18605) and
  [18659](https://github.com/civicrm/civicrm-core/pull/18659))**

- **Exception handling - 'Allowed memory size' exhasted issues
  ([dev/drupal#119](https://lab.civicrm.org/dev/drupal/-/issues/119):
  [18610](https://github.com/civicrm/civicrm-core/pull/18610))**

  Avoid crashes from recursion on unhandled exceptions (most often an issue in
  Drupal 8).

- **inheritLocale regression
  ([dev/translation#51](https://lab.civicrm.org/dev/translation/-/issues/51):
  [18447](https://github.com/civicrm/civicrm-core/pull/18447))**

  Ensures that CiviCRM in multilingual mode respects the Drupal language.

- **Do not block user incase 'Require approval' is checked
  ([18329](https://github.com/civicrm/civicrm-core/pull/18329))**

  Ensures users created via a profile are set to active in Drupal8 to prevent
  issues with the email verification step.

- **Fix customGroup getTableNameByEntityName to recognize all entities
  ([18546](https://github.com/civicrm/civicrm-core/pull/18546))**

  This ensures that all entities are recognized by Webform integration.

- **Custom field values not showing in Drupal 7 Views filter
  ([dev/core#1929](https://lab.civicrm.org/dev/core/-/issues/1929):
  [611](https://github.com/civicrm/civicrm-drupal/pull/611))**

- **Fix theme configuration section on Display preference and improve
  `isFrontendPage` function for Drupal CMS
  ([dev/core#1987](https://lab.civicrm.org/dev/core/-/issues/1987):
  [18396](https://github.com/civicrm/civicrm-core/pull/18396) and
  [18397](https://github.com/civicrm/civicrm-core/pull/18397))**

- **Drupal 7 - Groups children now get shown with SPAN CSS error
  ([dev/core#2105](https://lab.civicrm.org/dev/core/-/issues/2105):
  [18719](https://github.com/civicrm/civicrm-core/pull/18719))**

- **composer.json - Update compile-lib and compile-plugin
  ([18670](https://github.com/civicrm/civicrm-core/pull/18670))**

## <a name="misc"></a>Miscellany

- **Take the guesswork out of rendering clientside CRM variables
  ([18262](https://github.com/civicrm/civicrm-core/pull/18262))**

- **Improve consistency of metadata type declarations
  ([18147](https://github.com/civicrm/civicrm-core/pull/18147))**

- **Use eventID rather than the object in completeTransaction
  ([18358](https://github.com/civicrm/civicrm-core/pull/18358))**

- **Load event title from participantID
  ([18376](https://github.com/civicrm/civicrm-core/pull/18376))**

- **Fix Invoice class to not call validateData
  ([18372](https://github.com/civicrm/civicrm-core/pull/18372))**

- **Finish deprecating BaseIPN->completeTransaction
  ([18381](https://github.com/civicrm/civicrm-core/pull/18381))**

- **Add postAssert to check payments and contributions are valid on all tests.
  ([18317](https://github.com/civicrm/civicrm-core/pull/18317))**

- **Switch frontend contribution form to cached/non-deprecated functions for
  membershipTypes
  ([18404](https://github.com/civicrm/civicrm-core/pull/18404))**

- **Ensure DAO base class contains functions to be removed from generated files
  ([18492](https://github.com/civicrm/civicrm-core/pull/18492))**

- **Switch backend membership form to use non-deprecated/cached functions to get
  membership types
  ([18427](https://github.com/civicrm/civicrm-core/pull/18427))**

- **Fix civi version for greenwich
  ([18542](https://github.com/civicrm/civicrm-core/pull/18542))**

- **Switch to passing payment_processor_id as input param to completeOrder
  ([18528](https://github.com/civicrm/civicrm-core/pull/18528))**

- **Switch membership BAO to use non-deprecated cached functions to get
  membershipType details
  ([18515](https://github.com/civicrm/civicrm-core/pull/18515))**

- **Separate export into separate classes to allow unravelling of component
  handling (Member)
  ([18512](https://github.com/civicrm/civicrm-core/pull/18512))**

- **Simplify CRM_Core_BAO_Location::createLocBlock by moving eventLocation
  specific handling back to the class
  ([18578](https://github.com/civicrm/civicrm-core/pull/18578))**

- **Update the post-upgrade thank you message to include URLs to CiviCRM
  contributors, CiviCRM members and minor rewrite
  ([18559](https://github.com/civicrm/civicrm-core/pull/18559))**

- **Simplify call to loadRelatedObjects in repeat/completetransaction
  ([18613](https://github.com/civicrm/civicrm-core/pull/18613))**

- **Move membership tab add/submit membership buttons to PHP layer
  ([18143](https://github.com/civicrm/civicrm-core/pull/18143))**

- **Remove extraneous UF match queries
  ([dev/core#2087](https://lab.civicrm.org/dev/core/-/issues/2087):
  [18667](https://github.com/civicrm/civicrm-core/pull/18667) and
  [18675](https://github.com/civicrm/civicrm-core/pull/18675))**

- **Can't send SMS to mailing group whose parent isn't a mailing group (Clean up
  [dev/core#2053](https://lab.civicrm.org/dev/core/-/issues/2053):
  [18698](https://github.com/civicrm/civicrm-core/pull/18698))**

- **Merge - ensure location entities remaining on deleted contacts have
  is_primary integrity
  (Clean up [dev/core#2047](https://lab.civicrm.org/dev/core/-/issues/2047):
  [18499](https://github.com/civicrm/civicrm-core/pull/18499) and
  [18500](https://github.com/civicrm/civicrm-core/pull/18500))**

- **[cq] Do not pass by reference where avoidable
  (Work Towards [dev/core#2043](https://lab.civicrm.org/dev/core/-/issues/2043):
  [18484](https://github.com/civicrm/civicrm-core/pull/18484) and
  [18485](https://github.com/civicrm/civicrm-core/pull/18485))**

- **Fix the Test Result (1 failure / -190)
  E2E.Core.PrevNextTest.testDeleteByCacheKey recurring test issue
  ([dev/core#2029](https://lab.civicrm.org/dev/core/-/issues/2029):
  [18587](https://github.com/civicrm/civicrm-core/pull/18587) and
  [18565](https://github.com/civicrm/civicrm-core/pull/18565))**

- **SyntaxConformance::testSqlOperators cleanup fix - ensure entities are
  deleted ([18569](https://github.com/civicrm/civicrm-core/pull/18569))**

- **Move afform to be a core extension
  ([dev/core#2000](https://lab.civicrm.org/dev/core/-/issues/2000):
  [18423](https://github.com/civicrm/civicrm-core/pull/18423))**

- **Upgrade Angular from 1.5 => 1.8
  ([dev/core#1818](https://lab.civicrm.org/dev/core/-/issues/1818):
  [18635](https://github.com/civicrm/civicrm-core/pull/18635))**

- **Extraneous queries - activities (Work Towards
  [dev/core#2057](https://lab.civicrm.org/dev/core/-/issues/2057):
  [18625](https://github.com/civicrm/civicrm-core/pull/18625),
  [18566](https://github.com/civicrm/civicrm-core/pull/18566),
  [18609](https://github.com/civicrm/civicrm-core/pull/18609),
  [18636](https://github.com/civicrm/civicrm-core/pull/18636) and
  [18567](https://github.com/civicrm/civicrm-core/pull/18567))**

- **Eliminate unused query on CRM_Core_BAO_CustomQuery::_construct
  ([dev/core#2079](https://lab.civicrm.org/dev/core/-/issues/2079):
  [18654](https://github.com/civicrm/civicrm-core/pull/18654),
  [18653](https://github.com/civicrm/civicrm-core/pull/18653),
  [18665](https://github.com/civicrm/civicrm-core/pull/18665),
  [18664](https://github.com/civicrm/civicrm-core/pull/18664),
  [18656](https://github.com/civicrm/civicrm-core/pull/18656),
  [18657](https://github.com/civicrm/civicrm-core/pull/18657) and
  [18655](https://github.com/civicrm/civicrm-core/pull/18655))**

- **Rationalise BAO create vs add functions (Work Towards
  [dev/core#2046](https://lab.civicrm.org/dev/core/-/issues/2046):
  [18682](https://github.com/civicrm/civicrm-core/pull/18682),
  [18658](https://github.com/civicrm/civicrm-core/pull/18658),
  [18495](https://github.com/civicrm/civicrm-core/pull/18495),
  [18588](https://github.com/civicrm/civicrm-core/pull/18588),
  [18661](https://github.com/civicrm/civicrm-core/pull/18661),
  [18607](https://github.com/civicrm/civicrm-core/pull/18607) and
  [18606](https://github.com/civicrm/civicrm-core/pull/18606))**

- **Address extraneous location queries
  ([dev/core#2039](https://lab.civicrm.org/dev/core/-/issues/2039):
  [18496](https://github.com/civicrm/civicrm-core/pull/18496),
  [18498](https://github.com/civicrm/civicrm-core/pull/18498),
  [18497](https://github.com/civicrm/civicrm-core/pull/18497),
  [18494](https://github.com/civicrm/civicrm-core/pull/18494),
  [18501](https://github.com/civicrm/civicrm-core/pull/18501),
  [18480](https://github.com/civicrm/civicrm-core/pull/18480),
  [18489](https://github.com/civicrm/civicrm-core/pull/18489),
  [18684](https://github.com/civicrm/civicrm-core/pull/18684) and
  [18663](https://github.com/civicrm/civicrm-core/pull/18663))**

- **Remove unused functions (Work Towards
  [dev/core#2017](https://lab.civicrm.org/dev/core/-/issues/2017):
  [18662](https://github.com/civicrm/civicrm-core/pull/18662),
  [18430](https://github.com/civicrm/civicrm-core/pull/18430),
  [18433](https://github.com/civicrm/civicrm-core/pull/18433),
  [18463](https://github.com/civicrm/civicrm-core/pull/18463),
  [18458](https://github.com/civicrm/civicrm-core/pull/18458))**

- **Remove unneccessary isoToDate function
  ([dev/core#1921](https://lab.civicrm.org/dev/core/-/issues/1921):
  [18422](https://github.com/civicrm/civicrm-core/pull/18422),
  [18576](https://github.com/civicrm/civicrm-core/pull/18576),
  [18359](https://github.com/civicrm/civicrm-core/pull/18359),
  [18469](https://github.com/civicrm/civicrm-core/pull/18469),
  [18456](https://github.com/civicrm/civicrm-core/pull/18456),
  [18457](https://github.com/civicrm/civicrm-core/pull/18457),
  [18374](https://github.com/civicrm/civicrm-core/pull/18374),
  [18383](https://github.com/civicrm/civicrm-core/pull/18383) and
  [18468](https://github.com/civicrm/civicrm-core/pull/18468))**

- **Deprecate BaseIPN functions validateData & LoadObject (Work Towards
  [dev/financial#148](https://lab.civicrm.org/dev/financial/-/issues/148):
  [18479](https://github.com/civicrm/civicrm-core/pull/18479) and
  [18571](https://github.com/civicrm/civicrm-core/pull/18571))**

- **Separate out Search participant register form from backoffice form
  ([dev/event#42](https://lab.civicrm.org/dev/event/-/issues/42):
  [18486](https://github.com/civicrm/civicrm-core/pull/18486))**

- **Add try catch to main loops on core ipn classes
  ([18384](https://github.com/civicrm/civicrm-core/pull/18384))**

- **Rename variable $key to $participantID to make it clear what it is
  ([18371](https://github.com/civicrm/civicrm-core/pull/18371))**

- **Stop passing / using object when all we need is the id
  ([18331](https://github.com/civicrm/civicrm-core/pull/18331))**

- **Minor code cleanup - this is only ever called from one place so component is
  always event ([18343](https://github.com/civicrm/civicrm-core/pull/18343))**

- **Membership form test cleanup, date cleanup on form
  ([18413](https://github.com/civicrm/civicrm-core/pull/18413))**

- **Search ext: misc cleanup & fixes
  ([18723](https://github.com/civicrm/civicrm-core/pull/18723))**

- **Switch to non-deprecated/cached functions for membership pricesets
  ([18568](https://github.com/civicrm/civicrm-core/pull/18568))**

- **Fix parameters for MembershipTest
  ([18467](https://github.com/civicrm/civicrm-core/pull/18467))**

- **Update code comments
  ([18460](https://github.com/civicrm/civicrm-core/pull/18460))**

- **Pass in activity type rather than calculate it
  ([18450](https://github.com/civicrm/civicrm-core/pull/18450))**

- **Move definition of userName to where it is used and remove an unused
  parameter ([18452](https://github.com/civicrm/civicrm-core/pull/18452))**

- **Minor code simplification on date handling in getMembershipStatusByDate
  ([18421](https://github.com/civicrm/civicrm-core/pull/18421))**

- **Offer singular entity titles
  ([18434](https://github.com/civicrm/civicrm-core/pull/18434))**

- **(REF) GenerateData - Make it possible to call this via PHP
  ([18491](https://github.com/civicrm/civicrm-core/pull/18491))**

- **[REF] Simplify array construction
  ([18432](https://github.com/civicrm/civicrm-core/pull/18432))**

- **[REF] minor tidy up on membershipStatus::create & add
  ([18435](https://github.com/civicrm/civicrm-core/pull/18435))**

- **[REF] Folllow up cleanup - remove now unused param
  ([18438](https://github.com/civicrm/civicrm-core/pull/18438))**

- **[REF] Start the process of separating the search action from the participant
  form ([18464](https://github.com/civicrm/civicrm-core/pull/18464))**

- **[Ref] Code simplification - remove conditional chunk
  ([18445](https://github.com/civicrm/civicrm-core/pull/18445))**

- **[ref] Extract failContribution code
  ([18418](https://github.com/civicrm/civicrm-core/pull/18418))**

- **[REF] Fix visibility of afform_scanner container service for Symfony …
  ([18505](https://github.com/civicrm/civicrm-core/pull/18505))**

- **[REF] Refactor price field form to allow for unit testing of the form
  ([18414](https://github.com/civicrm/civicrm-core/pull/18414))**

- **[REF] Minor readability fix
  ([18415](https://github.com/civicrm/civicrm-core/pull/18415))**

- **[REF] change deprecated function to API4 call
  ([18076](https://github.com/civicrm/civicrm-core/pull/18076))**

- **[NFC] Cleanup in test class
  ([18539](https://github.com/civicrm/civicrm-core/pull/18539))**

- **[REF] Remove now used parameter & make function protected
  ([18543](https://github.com/civicrm/civicrm-core/pull/18543))**

- **[REF] Consolidate input params that are primarily used for the membership
  entity action to an array
  ([18451](https://github.com/civicrm/civicrm-core/pull/18451))**

- **[REF] Extract the code to determine the DAO name into a functions
  ([18513](https://github.com/civicrm/civicrm-core/pull/18513))**

- **[REF] Fix deprecated array and string offset access using curly brace…
  ([18529](https://github.com/civicrm/civicrm-core/pull/18529))**

- **[REF] Code cleanup on membership renewal & test
  ([18365](https://github.com/civicrm/civicrm-core/pull/18365))**

- **[REF] Improve the human readable name of the eway upgrade step to be …
  ([18401](https://github.com/civicrm/civicrm-core/pull/18401))**

- **[REF] Simplify loading of related objects in transition components
  ([18373](https://github.com/civicrm/civicrm-core/pull/18373))**

- **[REF] simplify interaction with objects in complete order
  ([18385](https://github.com/civicrm/civicrm-core/pull/18385))**

- **[REF] Mark CRM_Contribute_BAO_Contribution_Utils::formatAmount deprec…
  ([18387](https://github.com/civicrm/civicrm-core/pull/18387))**

- **[REF] Swap out CRM_Utils_Array::value() - partial pull out from PR 18207
  ([18391](https://github.com/civicrm/civicrm-core/pull/18391))**

- **[REF] Remove unused lines from loadObjects
  ([18389](https://github.com/civicrm/civicrm-core/pull/18389))**

- **[REF] Ensure that all bundle container services are public for Symfon…
  ([18368](https://github.com/civicrm/civicrm-core/pull/18368))**

- **[REF] Parse ids before sending to single function (minor simplification)
  ([18630](https://github.com/civicrm/civicrm-core/pull/18630))**

- **[REF] Hide eway extension in UI and only install it if the original e…
  ([18377](https://github.com/civicrm/civicrm-core/pull/18377))**

- **[REF] Simplify logic on calling self::updateContributionStatus
  ([18357](https://github.com/civicrm/civicrm-core/pull/18357))**

- **[REF] Fix adding in the accessKey based on the button array
  ([18674](https://github.com/civicrm/civicrm-core/pull/18674))**

- **[REF] Add in frontend fields for title and description of group Schem…
  ([18599](https://github.com/civicrm/civicrm-core/pull/18599))**

- **[REF] Remove unused taskName variable
  ([18590](https://github.com/civicrm/civicrm-core/pull/18590))**

- **[REF] IPN - move unshared chunk of code out of shared function
  ([18600](https://github.com/civicrm/civicrm-core/pull/18600))**

- **[REF] Paypal std ipn Move not-actually shared-code out of shared code
  function ([18536](https://github.com/civicrm/civicrm-core/pull/18536))**

- **[REF] Remove some unused params, move one to where it is used
  ([18614](https://github.com/civicrm/civicrm-core/pull/18614))**

- **[Ref] Extract getOrderParams
  ([18617](https://github.com/civicrm/civicrm-core/pull/18617))**

- **REF Filter params in completetransaction
  ([18321](https://github.com/civicrm/civicrm-core/pull/18321))**

- **[REF] Fix compatability with Drupal 9 installing of var_dumper
  ([18679](https://github.com/civicrm/civicrm-core/pull/18679))**

- **[REF] Add test for existing Participant batch update cancel and fix to not
  call BaseIPN->cancelled
  ([18318](https://github.com/civicrm/civicrm-core/pull/18318))**

- **[REF] Use helper function to check if multiLingual
  ([604](https://github.com/civicrm/civicrm-drupal/pull/604))**

- **[REF] Update Versions file and remove Net_URL class as doesn't appear…
  ([310](https://github.com/civicrm/civicrm-packages/pull/310))**

- **[REF] Remove Eway Libraries and XML_Util as they are now shipped as p…
  ([306](https://github.com/civicrm/civicrm-packages/pull/306))**

- **[REF] Add in css classes to make the save and preview button on the C…
  ([18647](https://github.com/civicrm/civicrm-core/pull/18647))**

- **[REF] Move daoName generation so we don't need to pass the variable name
  ([18552](https://github.com/civicrm/civicrm-core/pull/18552))**

- **[REF] Very minor cleanup
  ([18604](https://github.com/civicrm/civicrm-core/pull/18604))**

- **[REF] Fix Event location to create it's locations directly rather than via
  shared methods ([18586](https://github.com/civicrm/civicrm-core/pull/18586))**

- **[REF] Consolidate retrieval of searchFormValues
  ([18591](https://github.com/civicrm/civicrm-core/pull/18591))**

- **[REF] Include recently added core extensions into distmaker
  ([18597](https://github.com/civicrm/civicrm-core/pull/18597))**

- **[Ref] Extract getFormValues
  ([18510](https://github.com/civicrm/civicrm-core/pull/18510))**

- **[REF] Remove checks as to whether entityShortName is in the component  array
  ([18538](https://github.com/civicrm/civicrm-core/pull/18538))**

- **[Ref] Merge code - Move determination about location type to the
  getDAOForLocation…
  ([18562](https://github.com/civicrm/civicrm-core/pull/18562))**

- **[REF] Remove unreachable lines
  ([18535](https://github.com/civicrm/civicrm-core/pull/18535))**

- **[REF] Remove wrangling on activityType param
  ([18558](https://github.com/civicrm/civicrm-core/pull/18558))**

- **[REF] Finally remove deprecated ids handling
  ([18557](https://github.com/civicrm/civicrm-core/pull/18557))**

- **[REF] Update composer compile plugin to latest version
  ([18553](https://github.com/civicrm/civicrm-core/pull/18553))**

- **(REF) Make it easier for extensions to define basic bundles
  ([18660](https://github.com/civicrm/civicrm-core/pull/18660))**

- **[REF] Follow up cleanup from Event Location
  ([18608](https://github.com/civicrm/civicrm-core/pull/18608))**

- **(REF) Switch to composer-compile-lib
  ([18646](https://github.com/civicrm/civicrm-core/pull/18646))**

- **[REF] Remove XML_Util dependancy within ewaysingle extension
  ([18676](https://github.com/civicrm/civicrm-core/pull/18676))**

- **Remove long-deprecated hook_civicrm_tabs
  ([18503](https://github.com/civicrm/civicrm-core/pull/18503))**

- **Remove redundant custom field types
  ([18378](https://github.com/civicrm/civicrm-core/pull/18378) and
  ([622](https://github.com/civicrm/civicrm-drupal/pull/622))**

- **Remove unnecessary call to 'validateData' from pdf generator
  ([18367](https://github.com/civicrm/civicrm-core/pull/18367))**

- **Remove unnecessary debug from tests which messes up array output
  ([18446](https://github.com/civicrm/civicrm-core/pull/18446))**

- **Remove error handling from loadObjects
  ([18393](https://github.com/civicrm/civicrm-core/pull/18393))**

- **Remove deprecated code lines
  ([18490](https://github.com/civicrm/civicrm-core/pull/18490))**

- **Remove CRM_Contact_BAO_Contact::getPrimaryOpenId
  ([18424](https://github.com/civicrm/civicrm-core/pull/18424))**

- **Remove inaccessible call to baseIPN failed
  ([18369](https://github.com/civicrm/civicrm-core/pull/18369))**

- **Remove pass-by-ref in PaypalProIPN::single
  ([18337](https://github.com/civicrm/civicrm-core/pull/18337))**

- **Remove obsolete load-bootstrap.js
  ([18551](https://github.com/civicrm/civicrm-core/pull/18551))**

- **Remove deprecated ids param
  ([18375](https://github.com/civicrm/civicrm-core/pull/18375))**

- **Remove unused deprecated handling for partial_amount_to_pay
  ([18328](https://github.com/civicrm/civicrm-core/pull/18328))**

- **Minor test data fix up  - ensure domain contact's email is primary
  ([18561](https://github.com/civicrm/civicrm-core/pull/18561))**

- **Minor test fix
  ([18560](https://github.com/civicrm/civicrm-core/pull/18560))**

- **Preliminary cleanup on test
  ([18346](https://github.com/civicrm/civicrm-core/pull/18346))**

- **Fix test to use validateAllContributions
  ([18348](https://github.com/civicrm/civicrm-core/pull/18348))**

- **Afform Tests - Fix extension tests when run via `civi-test-run`
  ([18511](https://github.com/civicrm/civicrm-core/pull/18511))**

- **Test fix - use valid membership type
  ([18507](https://github.com/civicrm/civicrm-core/pull/18507))**

- **Test cleanup fix
  ([18601](https://github.com/civicrm/civicrm-core/pull/18601))**

- **[Civi\Test] Fix test output noise
  ([18638](https://github.com/civicrm/civicrm-core/pull/18638))**

- **[Test framework] Wrong group id in mailing test setup
  ([18626](https://github.com/civicrm/civicrm-core/pull/18626))**

- **Add test to cover existing v3 api setting of tax_amount on line items
  ([18351](https://github.com/civicrm/civicrm-core/pull/18351))**

- **Add unit test that ultimately failed to hit the desired code but does add
  cover ([18708](https://github.com/civicrm/civicrm-core/pull/18708))**

- **[NFC/Test] Unit test activity-contact variations
  ([18619](https://github.com/civicrm/civicrm-core/pull/18619))**

- **[NFC/Test] Unit test for target contacts on Bulk Email when mailing in
  batches ([18584](https://github.com/civicrm/civicrm-core/pull/18584))**

- **[NFC] Remove trailing whitespace
  ([18476](https://github.com/civicrm/civicrm-core/pull/18476))**

- **[NFC] Aim to reduce memory usage in create single value alter test by…
  ([18394](https://github.com/civicrm/civicrm-core/pull/18394))**

- **[NFC/Test framework] Make class name match file name
  ([18392](https://github.com/civicrm/civicrm-core/pull/18392))**

- **[NFC] Minor cleanup - use strict comparison where possible
  ([18573](https://github.com/civicrm/civicrm-core/pull/18573))**

- **[NFC] Enable APIv4 Testing on the statusPrefence API Tests
  ([18366](https://github.com/civicrm/civicrm-core/pull/18366))**

- **NFC Clarify what CRM_Price_BAO_Priceset::getMembershipCount does
  ([18426](https://github.com/civicrm/civicrm-core/pull/18426))**

- **[NFC] Enable APIv4 testing on the Fin ACL Extension Line Item test
  ([18478](https://github.com/civicrm/civicrm-core/pull/18478))**

- **Enotice fix ([18620](https://github.com/civicrm/civicrm-core/pull/18620))**

- **Enotice fix ([18707](https://github.com/civicrm/civicrm-core/pull/18707))**

- **Update civicrm_handler_field_contact_image.inc
  ([625](https://github.com/civicrm/civicrm-drupal/pull/625))**

  Fixes a notice.

- **Update civicrm_handler_field_pseudo_constant.inc
  ([626](https://github.com/civicrm/civicrm-drupal/pull/626))**

  Fixes a notice.

- **Update composer-download-plugin to v3.0.0 to support usage of composer 2.x
  ([18899](https://github.com/civicrm/civicrm-core/pull/18899))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andrew Hunt; Agileware - Justin Freeman; Bastien
Ho; Blackfly Solutions - Alan Dixon; CEDC - Laryn Kragt Bakker; Christian Wach;
Circle Interactive - Pradeep Nayak; CiviCRM - Coleman Watts, Tim Otten;
CiviDesk - Sunil Pawar; CompuCorp - Camilo Rodriguez, Ivan; Coop SymbioTIC -
Mathieu Lutfy; Dave D; iXiam - Luciano Spiegel; JMA Consulting - Monish Deb,
Seamus Lee; John Kingsnorth; Lighthouse Consulting and Design - Brian
Shaughnessy; Megaphone Technology Consulting - Dennis P. Osorio, Jon Goldberg;
MJW Consulting - Matthew Wire; QED42 - Swastik Pareek; Richard van Oosterhout;
Semper IT - Karin Gerritsen; Squiffle Consulting - Aidan Saunders; Tadpole
Collective - Kevin Cristiano; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Abeilles en Vélo / Bees on a bike; Artful Robot - Rich Lott; Betty Dolfing;
CiviCoop - Jaap Jansma; CiviCRM - Josh Gowans; CiviDesk - Nicolas Ganivet,
Yashodha Chaku; CompuCorp - René Olivo; Freeform Solutions - Herb van den Dool;
Fuzion - Jitendra Purohit, Luke Stewart; Irene Meisel; JMA Consulting - Joe
Murray; Lemniscus - Noah Miller; MJCO - Mikey O'Toole; Tony Maynard-Smith;
Wikimedia Foundation - Maggie Epps

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andrew Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
