#!/bin/sh -e
#
# Removes unwanted content from the upstream sources.
# Called by uscan with '--upstream-version' <version> <file>
#

PACKAGE=$(dpkg-parsechangelog -S Source)
VERSION=$2
TAR=../${PACKAGE}_${VERSION}.orig.tar.xz
DIR=${PACKAGE}-${VERSION}
TAG=$(echo "POOL_$VERSION" | sed -re's/\./_/g')

svn export http://svn.apache.org/repos/asf/commons/proper/pool/tags/${TAG} $DIR
XZ_OPT=--best tar -c -J -f $TAR --exclude '*.jar' --exclude '*.class' $DIR
rm -rf $DIR ../$TAG
