!   Mongolian Cyrillic keyboard.  The arrangement of the keys follows:
!
!   Normal:
!
!   Lat: ` 1           2 3        4      5 6 7 8 9 0 -  =
!   Cyr: = number_sign - dblquote tugric : . _ , % ? ie shch
!   Lat: q w  e r  t y u i  o          p [ ]
!   Cyr: f ts u zh e n g sh straight_u z k hard_sgn
!   Lat: a       s    d f        g h j k l ; apostrophe \
!   Cyr: short_i yeru b barred_o a h r o l d p          (
!   Lat: z  x  c  v b n m ,        . /
!   Cyr: ya ch io s m i t soft_sgn v yu
!
!   Shift:
!
!   Lat: ~ ! @ # $ % ^ & * ( ) _  +
!   Cyr: + 1 2 3 4 5 6 7 8 9 0 Ie Shch
!   Lat: Q W  E R  T Y U I  O          P { }
!   Cyr: F Ts U Zh E N G Sh Straight_U Z K Hard_Sgn
!   Lat: A       S    D F        G H J K L : dblquote |
!   Cyr: Short_I Yeru B Barred_O A H R O L D P        )
!   Lat: Z  X  C  V B N M <        > ?
!   Cyr: Ya Ch Io S M I T Soft_Sgn V Yu
#ifndef ENCODING
# include "pt154.enc"
#endif

#include "macros.inc"

CC(1, Escape, Escape)

PPPPC(2, one, exclam, nomerosign, one, VoidSymbol)
PPPPC(3, two, at, minus, two, nul)
PPPPC(4, three, numbersign, quotedbl, three, Escape)
PPPPC(5, four, dollar, tugrik_sign, four, Control_backslash)
PPPPC(6, five, percent, colon, five, Control_bracketright)
PPPPC(7, six, asciicircum, period, six, Control_asciicircum)
PPPPC(8, seven, ampersand, underscore, seven, Control_underscore)
PPPPC(9, eight, asterisk, comma, eight, Delete)
PPPPC(10, nine, parenleft, percent, nine, VoidSymbol)
PPPPC(11, zero, parenright, question, zero, VoidSymbol)
PPRRC(12, minus, underscore, cyr_ie, CYR_IE, Control_underscore)
PPRRC(13, equal, plus, cyr_shcha, CYR_SHCHA, VoidSymbol)

BACKSPACE_KEY
CC(15, Tab, Tab)

LLRR(16, q, Q, cyr_ef, CYR_EF)
LLRR(17, w, W, cyr_tse, CYR_TSE)
LLRR(18, e, E, cyr_u, CYR_U)
LLRR(19, r, R, cyr_zhe, CYR_ZHE)
LLRR(20, t, T, cyr_e, CYR_E)
LLRR(21, y, Y, cyr_en, CYR_EN)
LLRR(22, u, U, cyr_ghe, CYR_GHE)
LLRR(23, i, I, cyr_sha, CYR_SHA)
LLRR(24, o, O, cyr_straight_u, CYR_STRAIGHT_U)
LLRR(25, p, P, cyr_ze, CYR_ZE)

PPRRC(26, bracketleft, braceleft, cyr_ka, CYR_KA, Escape)
PPRRC(27, bracketright, braceright, cyr_hard_sign, CYR_HARD_SIGN, Control_bracketright)

CC(28, Return, Return)

SPEC(29, LEFT_CONTROL)

LLRR(30, a, A, cyr_short_i, CYR_SHORT_I)
LLRR(31, s, S, cyr_yeru, CYR_YERU)
LLRR(32, d, D, cyr_be, CYR_BE)
LLRR(33, f, F, cyr_barred_o, CYR_BARRED_O)
LLRR(34, g, G, cyr_a, CYR_A)
LLRR(35, h, H, cyr_ha, CYR_HA)
LLRR(36, j, J, cyr_er, CYR_ER)
LLRR(37, k, K, cyr_o, CYR_O)
LLRR(38, l, L, cyr_el, CYR_EL)

PPRRC(39, semicolon, colon, cyr_de, CYR_DE, VoidSymbol)
PPRRC(40, apostrophe, quotedbl, cyr_pe, CYR_PE, Control_g)
PPPPC(41, grave, asciitilde, equal, plus, nul)

SPEC(42, LEFT_SHIFT)

PPPPC(43, backslash, bar, parenleft, parenright, Control_backslash)

LLRR(44, z, Z, cyr_ya, CYR_YA)
LLRR(45, x, X, cyr_che, CYR_CHE)
LLRR(46, c, C, cyr_io, CYR_IO)
LLRR(47, v, V, cyr_es, CYR_ES)
LLRR(48, b, B, cyr_em, CYR_EM)
LLRR(49, n, N, cyr_i, CYR_I)
LLRR(50, m, M, cyr_te, CYR_TE)

PPRRC(51, comma, less, cyr_soft_sign, CYR_SOFT_SIGN, VoidSymbol)

PPRRC(52, period, greater, cyr_ve, CYR_VE, VoidSymbol)
        control         keycode 52 = Compose
        control altgr   keycode 52 = Compose

PPRRC(53, slash, question, cyr_yu, CYR_YU, Delete)

SPEC(54, RIGHT_SHIFT)

SPEC(55, KP_Multiply)

SPEC(56, LEFT_ALT)

CC(57, space, nul)

SPEC(58, Caps_Lock)

FUNC(59, 1, 11)
FUNC(60, 2, 12)
FUNC(61, 3, 13)
FUNC(62, 4, 14)
FUNC(63, 5, 15)
FUNC(64, 6, 16)
FUNC(65, 7, 17)
FUNC(66, 8, 18)
FUNC(67, 9, 19)
FUNC(68, 10, 20)

SPEC(69, Num_Lock)

SPEC(70, Scroll_Lock)
        shift           keycode 70 = Show_Memory
        shift   altgr   keycode 70 = Show_Memory
        control         keycode 70 = Show_State
        control altgr   keycode 70 = Show_State
        alt             keycode 70 = Show_Registers
        alt     altgr   keycode 70 = Show_Registers

SPEC(71, KP_7)
        alt         keycode 71 = Ascii_7
        alt altgr   keycode 71 = Ascii_7

SPEC(72, KP_8)
        alt         keycode 72 = Ascii_8
        alt altgr   keycode 72 = Ascii_8

SPEC(73, KP_9)
        alt         keycode 73 = Ascii_9
        alt altgr   keycode 73 = Ascii_9

SPEC(74, KP_Subtract)

SPEC(75, KP_4)
        alt         keycode 75 = Ascii_4
        alt altgr   keycode 75 = Ascii_4

SPEC(76, KP_5)
        alt         keycode 76 = Ascii_5
        alt altgr   keycode 76 = Ascii_5

SPEC(77, KP_6)
        alt         keycode 77 = Ascii_6
        alt altgr   keycode 77 = Ascii_6

SPEC(78, KP_Add)

SPEC(79, KP_1)
        alt         keycode 79 = Ascii_1
        alt altgr   keycode 79 = Ascii_1

SPEC(80, KP_2)
        alt         keycode 80 = Ascii_2
        alt altgr   keycode 80 = Ascii_2

SPEC(81, KP_3)
        alt         keycode 81 = Ascii_3
        alt altgr   keycode 81 = Ascii_3

SPEC(82, KP_0)
        alt         keycode 82 = Ascii_0
        alt altgr   keycode 82 = Ascii_0

SPEC(83, KP_Period)
        control alt             keycode 83 = Boot
        control alt     altgr   keycode 83 = Boot

SPEC(84, Last_Console)

NONE(85)

PPPPC(86, less, greater, plus, sectionsign, VoidSymbol)

FUNC(87, 11, 11)
FUNC(88, 12, 12)

NONE(89)
NONE(90)
NONE(91)
NONE(92)
NONE(93)
NONE(94)
NONE(95)

SPEC(96, KP_Enter)

SPEC(97, RIGHT_CONTROL)

SPEC(98, KP_Divide)

CC(99, Control_backslash, Control_backslash)

SPEC(100, RIGHT_ALT)

SPEC(101, Break)
SPEC(102, Home)

SPEC(103, Up)

SPEC(104, PageUp)
        shift           keycode 104 = Scroll_Backward
        shift   altgr   keycode 104 = Scroll_Backward

SPEC(105, Left)
        alt         keycode 105 = Decr_Console
        alt altgr   keycode 105 = Decr_Console

SPEC(106, Right)
        alt         keycode 106 = Incr_Console
        alt altgr   keycode 106 = Incr_Console

SPEC(107, End)
SPEC(108, Down)

SPEC(109, PageDown)
        shift           keycode 109 = Scroll_Forward
        shift   altgr   keycode 109 = Scroll_Forward

SPEC(110, Insert)

SPEC(111, Remove)
        control alt         keycode 111 = Boot
        control alt altgr   keycode 111 = Boot

SPEC(112, Macro)
SPEC(113, F13)
SPEC(114, F14)
SPEC(115, Help)
SPEC(116, Do)
SPEC(117, F17)
SPEC(118, KP_MinPlus)
SPEC(119, Pause)

NONE(120)
NONE(121)
NONE(122)
NONE(123)
NONE(124)

SPEC(125, LEFT_WINDOW)
SPEC(126, RIGHT_WINDOW)
SPEC(127, SYSTEM_MENU)

string F1 = "\033[[A"
string F2 = "\033[[B"
string F3 = "\033[[C"
string F4 = "\033[[D"
string F5 = "\033[[E"
string F6 = "\033[17~"
string F7 = "\033[18~"
string F8 = "\033[19~"
string F9 = "\033[20~"
string F10 = "\033[21~"
string F11 = "\033[23~"
string F12 = "\033[24~"
string F13 = "\033[25~"
string F14 = "\033[26~"
string F15 = "\033[28~"
string F16 = "\033[29~"
string F17 = "\033[31~"
string F18 = "\033[32~"
string F19 = "\033[33~"
string F20 = "\033[34~"
string Find = "\033[1~"
string Insert = "\033[2~"
string Remove = "\033[3~"
string Select = "\033[4~"
string Prior = "\033[5~"
string Next = "\033[6~"
string Macro = "\033[M"
string Pause = "\033[P"
