/*
 * Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either 
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>. */

#ifndef DARKROOM_H
#define DARKROOM_H

#include <config-openctl.h>

#include <kxmlguiwindow.h>

class QModelIndex;
class PostProcessor;
class ProcessingOptions;
class HistogramWidget;
class KCurve;

namespace ThreadWeaver {
  class Weaver;
}

/**
 * This class serves as the main window for Darkroom.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author Cyrille Berger <cberger@cberger.net>
 * @version 0.1
 */
class Darkroom : public KXmlGuiWindow
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    Darkroom();

    /**
     * Default Destructor
     */
    virtual ~Darkroom();
    void openUrl(const QString&);
    ProcessingOptions processingOptions();
    void setProcessingOptions(const ProcessingOptions& );
    HistogramWidget* histogramWidget();
  private slots:
    void rawFileActivated ( const QModelIndex & index );
    void fileOpenDir();
    void fileOpen();
    void weaverStatusChanged();
    void applyCurrentSettings();
    void customFileViewContextMenuRequested( const QPoint& pos );
    void slotWhiteBalanceChanged(int);
    void slotHighlightsChanged(int);
    void slotEnableChromaticAberration( bool );
    void slotEnableNoiseReduction( bool );
    void slotHistogramTypeChanged(int);
    void optionsChanged();
    void exportOptionsChanged();
#ifdef HAVE_OPENCTL
    void slotGammaValueChanged(double);
#endif
    void bookmarkCurrentOptions();
    void bookmarkedOptionsActivated ( const QModelIndex & index );
    void deleteCurrentBookmark();
    void optionsBookmarkChanged();
    void exportCodecChanged();
    void errorReceived();
  public slots:
#ifdef HAVE_OPENCTL
    void setIntermediateData( uchar *data, uint w, uint h );
#endif
  protected:
    virtual void closeEvent(QCloseEvent *event);
  private:
    QList<QVariant> curveToList( KCurve * );
    void openDir( const QString& _directory );
    void openFile( const QString& _file );
    void setupActions();
    void setupDockers();
    void observeWeaver( ThreadWeaver::Weaver* weaver );
    bool idling();
    void createCurveWidget( KCurve** curveWidget, const QString& dockTitle, const QString& objectName );
    void cleanUp();
    double computeGamma() const;
    void setGamma( double );
  private:
    struct Private;
    Private* const d;
};

#endif // _DARKROOM_H_
