Configuring ACME Database
=========================

## Overview

This document describes the process to configure a database for ACME responder.
The database configuration is located at /etc/pki/pki-tomcat/acme/database.conf.

The `pki-server acme-database-mod` can be used to configure the database via command-line.
If the command is invoked without any parameters, it will enter an interactive mode, for example:

```
$ pki-server acme-database-mod
The current value is displayed in the square brackets.
To keep the current value, simply press Enter.
To change the current value, enter the new value.
To remove the current value, enter a blank space.

Enter the type of the database. Available types: ds, in-memory, ldap, openldap, postgresql.
  Database Type: ds

Enter the location of the LDAP server (e.g. ldap://localhost.localdomain:389).
  Server URL [ldap://localhost.localdomain:389]:

Enter the authentication type. Available types: BasicAuth, SslClientAuth.
  Authentication Type [BasicAuth]:

Enter the bind DN.
  Bind DN [cn=Directory Manager]:

Enter the bind password.
  Bind Password [********]:

Enter the base DN for the ACME subtree.
  Base DN [dc=acme,dc=pki,dc=example,dc=com]:
```

If the command is invoked with `--type` parameter, it will create a new configuration based on the specified type.
If the command is invoked with other parameters, it will update the specified parameters.

Some ACME configuration properties are stored in the database such that
all ACME responders in the cluster can be configured consistently.
By default the ACME responder will access the database directly
when retrieving or updating the ACME configuration properties,
which may increase the load on the database.
Some databases might provide an ACME configuration monitor to reduce the load on the database.

## Configuring ACME with In-Memory Database

The ACME responder can be configured with an in-memory database.
See [Configuring ACME with In-Memory Database](Configuring-ACME-with-InMemory-Database.adoc).

## Configuring ACME with DS Database

The ACME responder can be configured with a DS database.
See [Configuring ACME with DS Database](Configuring-ACME-with-DS-Database.adoc).

## Configuring ACME with OpenLDAP Database

The ACME responder can be configured with an OpenLDAP database.
See [Configuring ACME with OpenLDAP Database](Configuring-ACME-with-OpenLDAP-Database.adoc).

## Configuring ACME with PostgreSQL Database

The ACME responder can be configured with a PostgreSQL database.
See [Configuring ACME with PostgreSQL Database](Configuring-ACME-with-PostgreSQL-Database.adoc).

## See Also

* [Installing PKI ACME Responder](Installing_PKI_ACME_Responder.md)
