/*******************************************************************************
 * Copyright (c) 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.jsdt.debug.transport;

/**
 * Common constants
 * 
 * @since 1.0
 * 
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 */
public interface Constants {
	/**
	 * Constant representing a colon<br>
	 * <br>
	 * Value is: <code>:</code>
	 */
	public static final String COLON = ":"; //$NON-NLS-1$
	/**
	 * Constant for the text representation of localhost<br>
	 * <br>
	 * Value is: <code>localhost</code>
	 */
	public static final String LOCALHOST = "localhost"; //$NON-NLS-1$
	/**
	 * Constant for the IP address representation of localhost<br>
	 * <br>
	 * Value is: <code>127.0.0.1</code> 
	 */
	public static final String LOCALHOST_IP = "127.0.0.1"; //$NON-NLS-1$
	/**
	 * "port" constant<br>
	 * <br>
	 * Value is: <code>port</code>
	 */
	public static final String PORT = "port"; //$NON-NLS-1$
	/**
	 * UTF-8 encoding constant<br>
	 * <br>
	 * Value is: <code>UTF-8</code>
	 */
	public static final String UTF_8 = "UTF-8"; //$NON-NLS-1$
}
