/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.server;

import com.sun.net.ssl.internal.ssl.Provider;
import com.sun.net.ssl.internal.www.protocol.https.Handler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.Security;
import java.util.Enumeration;
import java.util.Hashtable;
import org.emboss.jemboss.JembossJarUtil;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.programs.ListFile;
import org.emboss.jemboss.soap.JembossRun;
import org.emboss.jemboss.soap.JembossSoapException;
import org.emboss.jemboss.soap.MakeFileSafe;

public class TestPrivateServer {
    private static JembossParams mysettings;
    private static String filename;
    private static String prog;

    public TestPrivateServer() {
        if (mysettings.getPublicSoapURL().startsWith("https")) {
            Provider p = new Provider();
            Security.addProvider((java.security.Provider)p);
            URL.setURLStreamHandlerFactory(new URLStreamHandlerFactory(){

                public URLStreamHandler createURLStreamHandler(String protocol) {
                    if (protocol != null && protocol.compareTo("https") == 0) {
                        return new Handler();
                    }
                    return null;
                }
            });
            System.setProperty("javax.net.ssl.trustStore", "resources/client.keystore");
            String jembossClientKeyStore = System.getProperty("user.home") + "/.jembossClientKeystore";
            try {
                new JembossJarUtil("resources/client.jar").writeByteFile("client.keystore", jembossClientKeyStore);
                System.setProperty("javax.net.ssl.trustStore", jembossClientKeyStore);
            }
            catch (Exception exp) {
                // empty catch block
            }
        }
        Hashtable filesToMove = new Hashtable();
        String embossCommand = prog + " ";
        String val = "sequence";
        embossCommand = this.filesForSoap(filename, embossCommand, val, filesToMove);
        embossCommand = embossCommand.concat(" -auto");
        if (mysettings.getUseAuth() && mysettings.getServiceUserName() == null) {
            System.out.println("OOPS! Authentication required!");
        }
        try {
            JembossRun thisrun = new JembossRun(embossCommand, "", filesToMove, mysettings);
            Hashtable h = thisrun.hash();
            Enumeration enums = h.keys();
            while (enums.hasMoreElements()) {
                String thiskey = enums.nextElement().toString();
                Object res = h.get(thiskey);
                if (res instanceof String) {
                    System.out.println((String)res);
                    continue;
                }
                System.out.println(new String((byte[])h.get(thiskey)));
            }
        }
        catch (JembossSoapException eae) {
            System.out.println("SOAP ERROR :" + embossCommand);
        }
    }

    private String filesForSoap(String fn, String options, String val, Hashtable filesToMove) {
        if (fn.startsWith("@") || fn.startsWith("list::") || fn.startsWith("internalList::")) {
            String lfn = "";
            if (fn.startsWith("@")) {
                lfn = fn.substring(1);
            } else if (fn.startsWith("list::")) {
                lfn = fn.substring(6);
            }
            File inFile = new File(lfn);
            if (inFile.exists() && inFile.canRead() && inFile.isFile() || fn.startsWith("internalList::")) {
                ListFile.parse(fn, filesToMove);
                if (fn.startsWith("internalList::")) {
                    options = options.concat(" -" + val + " list::internalList");
                } else {
                    MakeFileSafe sf = new MakeFileSafe(lfn);
                    String sfs = sf.getSafeFileName();
                    options = options.concat(" -" + val + " list::" + sfs);
                }
            } else {
                options = options.concat(" -" + val + " list::" + lfn);
            }
            String sfn = lfn;
        } else {
            MakeFileSafe sf = new MakeFileSafe(fn);
            String sfn = sf.getSafeFileName();
            File inFile = new File(fn);
            if (inFile.exists() && inFile.canRead() && inFile.isFile()) {
                filesToMove.put(sfn, this.getLocalFile(inFile));
                options = options.concat(" -" + val + " " + sfn);
            } else {
                options = options.concat(" -" + val + " " + fn);
            }
        }
        return options;
    }

    private byte[] getLocalFile(File name) {
        byte[] b = null;
        try {
            long s = name.length();
            b = new byte[(int)s];
            FileInputStream fi = new FileInputStream(name);
            fi.read(b);
            fi.close();
        }
        catch (IOException ioe) {
            System.out.println("Cannot read file: " + name);
        }
        return b;
    }

    public static void main(String[] args) {
        mysettings = new JembossParams();
        mysettings.setServiceUserName(args[0]);
        mysettings.setServicePasswd(args[1].toCharArray());
        prog = args[2];
        filename = args[3];
        new TestPrivateServer();
    }
}

