/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import loci.formats.DataTools;
import loci.formats.IndexedColorModel;
import loci.formats.TwoChannelColorSpace;

public final class ImageTools {
    protected static final Component OBS = new Container();

    private ImageTools() {
    }

    public static BufferedImage makeImage(byte[] data, int w, int h) {
        return ImageTools.makeImage(new byte[][]{data}, w, h);
    }

    public static BufferedImage makeImage(short[] data, int w, int h) {
        return ImageTools.makeImage(new short[][]{data}, w, h);
    }

    public static BufferedImage makeImage(int[] data, int w, int h) {
        return ImageTools.makeImage(new int[][]{data}, w, h);
    }

    public static BufferedImage makeImage(float[] data, int w, int h) {
        return ImageTools.makeImage(new float[][]{data}, w, h);
    }

    public static BufferedImage makeImage(double[] data, int w, int h) {
        return ImageTools.makeImage(new double[][]{data}, w, h);
    }

    public static BufferedImage makeImage(byte[] data, int w, int h, int c, boolean interleaved) {
        if (c == 1) {
            return ImageTools.makeImage(data, w, h);
        }
        int dataType = 0;
        DataBufferByte buffer = new DataBufferByte(data, c * w * h);
        return ImageTools.constructImage(c, dataType, w, h, interleaved, false, buffer);
    }

    public static BufferedImage makeImage(short[] data, int w, int h, int c, boolean interleaved) {
        if (c == 1) {
            return ImageTools.makeImage(data, w, h);
        }
        int dataType = 1;
        DataBufferUShort buffer = new DataBufferUShort(data, c * w * h);
        return ImageTools.constructImage(c, dataType, w, h, interleaved, false, buffer);
    }

    public static BufferedImage makeImage(int[] data, int w, int h, int c, boolean interleaved) {
        if (c == 1) {
            return ImageTools.makeImage(data, w, h);
        }
        int dataType = 3;
        DataBufferInt buffer = new DataBufferInt(data, c * w * h);
        return ImageTools.constructImage(c, dataType, w, h, interleaved, false, buffer);
    }

    public static BufferedImage makeImage(float[] data, int w, int h, int c, boolean interleaved) {
        if (c == 1) {
            return ImageTools.makeImage(data, w, h);
        }
        int dataType = 4;
        DataBufferFloat buffer = new DataBufferFloat(data, c * w * h);
        return ImageTools.constructImage(c, dataType, w, h, interleaved, false, buffer);
    }

    public static BufferedImage makeImage(double[] data, int w, int h, int c, boolean interleaved) {
        if (c == 1) {
            return ImageTools.makeImage(data, w, h);
        }
        int dataType = 5;
        DataBufferDouble buffer = new DataBufferDouble(data, c * w * h);
        return ImageTools.constructImage(c, dataType, w, h, interleaved, false, buffer);
    }

    public static BufferedImage makeImage(byte[][] data, int w, int h) {
        int dataType = 0;
        DataBufferByte buffer = new DataBufferByte(data, data[0].length);
        return ImageTools.constructImage(data.length, dataType, w, h, false, true, buffer);
    }

    public static BufferedImage makeImage(short[][] data, int w, int h) {
        int dataType = 1;
        DataBufferUShort buffer = new DataBufferUShort(data, data[0].length);
        return ImageTools.constructImage(data.length, dataType, w, h, false, true, buffer);
    }

    public static BufferedImage makeImage(int[][] data, int w, int h) {
        int dataType = 3;
        DataBufferInt buffer = new DataBufferInt(data, data[0].length);
        return ImageTools.constructImage(data.length, dataType, w, h, false, true, buffer);
    }

    public static BufferedImage makeImage(float[][] data, int w, int h) {
        int dataType = 4;
        DataBufferFloat buffer = new DataBufferFloat(data, data[0].length);
        return ImageTools.constructImage(data.length, dataType, w, h, false, true, buffer);
    }

    public static BufferedImage makeImage(double[][] data, int w, int h) {
        int dataType = 5;
        DataBufferDouble buffer = new DataBufferDouble(data, data[0].length);
        return ImageTools.constructImage(data.length, dataType, w, h, false, true, buffer);
    }

    public static BufferedImage makeImage(byte[] data, int w, int h, int c, boolean interleaved, int bpp, boolean little) {
        return ImageTools.makeImage(data, w, h, c, interleaved, bpp, false, little);
    }

    public static BufferedImage makeImage(byte[] data, int w, int h, int c, boolean interleaved, int bpp, boolean fp, boolean little) {
        Object pixels = DataTools.makeDataArray(data, bpp % 3 == 0 ? bpp / 3 : bpp, fp, little);
        if (pixels instanceof byte[]) {
            return ImageTools.makeImage((byte[])pixels, w, h, c, interleaved);
        }
        if (pixels instanceof short[]) {
            return ImageTools.makeImage((short[])pixels, w, h, c, interleaved);
        }
        if (pixels instanceof int[]) {
            return ImageTools.makeImage((int[])pixels, w, h, c, interleaved);
        }
        if (pixels instanceof float[]) {
            return ImageTools.makeImage((float[])pixels, w, h, c, interleaved);
        }
        if (pixels instanceof double[]) {
            return ImageTools.makeImage((double[])pixels, w, h, c, interleaved);
        }
        return null;
    }

    public static BufferedImage makeImage(byte[][] data, int w, int h, int bpp, boolean little) {
        return ImageTools.makeImage(data, w, h, bpp, false, little);
    }

    public static BufferedImage makeImage(byte[][] data, int w, int h, int bpp, boolean fp, boolean little) {
        int c = data.length;
        Object v = null;
        for (int i = 0; i < c; ++i) {
            Object pixels = DataTools.makeDataArray(data[i], bpp % 3 == 0 ? bpp / 3 : bpp, fp, little);
            if (pixels instanceof byte[]) {
                if (v == null) {
                    v = new byte[c][];
                }
                ((byte[][])v)[i] = (byte[])pixels;
                continue;
            }
            if (pixels instanceof short[]) {
                if (v == null) {
                    v = new short[c][];
                }
                ((short[][])v)[i] = (short[])pixels;
                continue;
            }
            if (pixels instanceof int[]) {
                if (v == null) {
                    v = new int[c][];
                }
                ((int[][])v)[i] = (int[])pixels;
                continue;
            }
            if (pixels instanceof float[]) {
                if (v == null) {
                    v = new float[c][];
                }
                ((float[][])v)[i] = (float[])pixels;
                continue;
            }
            if (!(pixels instanceof double[])) continue;
            if (v == null) {
                v = new double[c][];
            }
            ((double[][])v)[i] = (double[])pixels;
        }
        if (v instanceof byte[][]) {
            return ImageTools.makeImage(v, w, h);
        }
        if (v instanceof short[][]) {
            return ImageTools.makeImage((short[][])v, w, h);
        }
        if (v instanceof int[][]) {
            return ImageTools.makeImage((int[][])v, w, h);
        }
        if (v instanceof float[][]) {
            return ImageTools.makeImage((float[][])v, w, h);
        }
        if (v instanceof double[][]) {
            return ImageTools.makeImage((double[][])v, w, h);
        }
        return null;
    }

    public static BufferedImage blankImage(int w, int h, int c, int type) {
        switch (type) {
            case 0: 
            case 1: {
                return ImageTools.makeImage(new byte[c][w * h], w, h);
            }
            case 2: 
            case 3: {
                return ImageTools.makeImage(new short[c][w * h], w, h);
            }
            case 4: 
            case 5: {
                return ImageTools.makeImage(new int[c][w * h], w, h);
            }
            case 6: {
                return ImageTools.makeImage(new float[c][w * h], w, h);
            }
            case 7: {
                return ImageTools.makeImage(new double[c][w * h], w, h);
            }
        }
        return null;
    }

    private static BufferedImage constructImage(int c, int type, int w, int h, boolean interleaved, boolean banded, DataBuffer buffer) {
        int[] bandOffsets;
        ComponentSampleModel model;
        ColorModel colorModel = ImageTools.makeColorModel(c, type);
        if (colorModel == null) {
            return null;
        }
        if (banded) {
            model = new BandedSampleModel(type, w, h, c);
        } else if (interleaved) {
            bandOffsets = new int[c];
            for (int i = 0; i < c; ++i) {
                bandOffsets[i] = i;
            }
            model = new PixelInterleavedSampleModel(type, w, h, c, c * w, bandOffsets);
        } else {
            bandOffsets = new int[c];
            for (int i = 0; i < c; ++i) {
                bandOffsets[i] = i * w * h;
            }
            model = new ComponentSampleModel(type, w, h, 1, w, bandOffsets);
        }
        WritableRaster raster = Raster.createWritableRaster(model, buffer, null);
        return new BufferedImage(colorModel, raster, false, null);
    }

    public static Object getPixels(BufferedImage image) {
        WritableRaster raster = image.getRaster();
        int tt = raster.getTransferType();
        if (tt == 0) {
            return ImageTools.getBytes(image);
        }
        if (tt == 1) {
            return ImageTools.getShorts(image);
        }
        if (tt == 3) {
            return ImageTools.getInts(image);
        }
        if (tt == 4) {
            return ImageTools.getFloats(image);
        }
        if (tt == 5) {
            return ImageTools.getDoubles(image);
        }
        return null;
    }

    public static byte[][] getBytes(BufferedImage image) {
        WritableRaster r = image.getRaster();
        if (ImageTools.canUseBankDataDirectly(image, 1, 0, DataBufferByte.class)) {
            return ((DataBufferByte)r.getDataBuffer()).getBankData();
        }
        int w = image.getWidth();
        int h = image.getHeight();
        int c = r.getNumBands();
        byte[][] samples = new byte[c][w * h];
        int[] buf = new int[w * h];
        for (int i = 0; i < c; ++i) {
            r.getSamples(0, 0, w, h, i, buf);
            for (int j = 0; j < buf.length; ++j) {
                samples[i][j] = (byte)buf[j];
            }
        }
        return samples;
    }

    public static short[][] getShorts(BufferedImage image) {
        WritableRaster r = image.getRaster();
        if (ImageTools.canUseBankDataDirectly(image, 2, 1, DataBufferUShort.class)) {
            return ((DataBufferUShort)r.getDataBuffer()).getBankData();
        }
        int w = image.getWidth();
        int h = image.getHeight();
        int c = r.getNumBands();
        short[][] samples = new short[c][w * h];
        int[] buf = new int[w * h];
        for (int i = 0; i < c; ++i) {
            r.getSamples(0, 0, w, h, i, buf);
            for (int j = 0; j < buf.length; ++j) {
                samples[i][j] = (short)buf[j];
            }
        }
        return samples;
    }

    public static int[][] getInts(BufferedImage image) {
        WritableRaster r = image.getRaster();
        if (ImageTools.canUseBankDataDirectly(image, 4, 3, DataBufferInt.class)) {
            return ((DataBufferInt)r.getDataBuffer()).getBankData();
        }
        int w = image.getWidth();
        int h = image.getHeight();
        int c = r.getNumBands();
        int[][] samples = new int[c][w * h];
        for (int i = 0; i < c; ++i) {
            r.getSamples(0, 0, w, h, i, samples[i]);
        }
        return samples;
    }

    public static float[][] getFloats(BufferedImage image) {
        WritableRaster r = image.getRaster();
        if (ImageTools.canUseBankDataDirectly(image, 4, 4, DataBufferFloat.class)) {
            return ((DataBufferFloat)r.getDataBuffer()).getBankData();
        }
        int w = image.getWidth();
        int h = image.getHeight();
        int c = r.getNumBands();
        float[][] samples = new float[c][w * h];
        for (int i = 0; i < c; ++i) {
            r.getSamples(0, 0, w, h, i, samples[i]);
        }
        return samples;
    }

    public static double[][] getDoubles(BufferedImage image) {
        WritableRaster r = image.getRaster();
        if (ImageTools.canUseBankDataDirectly(image, 8, 5, DataBufferDouble.class)) {
            return ((DataBufferDouble)r.getDataBuffer()).getBankData();
        }
        int w = image.getWidth();
        int h = image.getHeight();
        int c = r.getNumBands();
        double[][] samples = new double[c][w * h];
        for (int i = 0; i < c; ++i) {
            r.getSamples(0, 0, w, h, i, samples[i]);
        }
        return samples;
    }

    private static boolean canUseBankDataDirectly(BufferedImage image, int bytesPerPixel, int transferType, Class dataBufferClass) {
        WritableRaster r = image.getRaster();
        int tt = r.getTransferType();
        if (tt != transferType) {
            return false;
        }
        DataBuffer buffer = r.getDataBuffer();
        if (!dataBufferClass.isInstance(buffer)) {
            return false;
        }
        SampleModel model = r.getSampleModel();
        if (!(model instanceof ComponentSampleModel)) {
            return false;
        }
        ComponentSampleModel csm = (ComponentSampleModel)model;
        int pixelStride = csm.getPixelStride();
        if (pixelStride != 1) {
            return false;
        }
        int w = r.getWidth();
        int scanlineStride = csm.getScanlineStride();
        if (scanlineStride != w) {
            return false;
        }
        int c = r.getNumBands();
        int[] bandOffsets = csm.getBandOffsets();
        if (bandOffsets.length != c) {
            return false;
        }
        for (int i = 0; i < bandOffsets.length; ++i) {
            if (bandOffsets[i] == 0) continue;
            return false;
        }
        int[] bankIndices = csm.getBankIndices();
        for (int i = 0; i < bandOffsets.length; ++i) {
            if (bandOffsets[i] == i) continue;
            return false;
        }
        return true;
    }

    public static byte[][] getPixelBytes(BufferedImage img, boolean little) {
        Object pixels = ImageTools.getPixels(img);
        if (pixels instanceof byte[][]) {
            byte[][] b = (byte[][])pixels;
            return (byte[][])pixels;
        }
        if (pixels instanceof short[][]) {
            short[][] s = (short[][])pixels;
            byte[][] b = new byte[s.length][s[0].length * 2];
            for (int i = 0; i < b.length; ++i) {
                for (int j = 0; j < s[0].length; ++j) {
                    short v = s[i][j];
                    if (little) {
                        b[i][j * 2] = (byte)(v & 0xFF);
                        b[i][j * 2 + 1] = (byte)(v >>> 8 & 0xFF);
                        continue;
                    }
                    b[i][j * 2] = (byte)(v >>> 8 & 0xFF);
                    b[i][j * 2 + 1] = (byte)(v & 0xFF);
                }
            }
            return b;
        }
        if (pixels instanceof int[][]) {
            int[][] in = (int[][])pixels;
            byte[][] b = new byte[in.length][in[0].length * 4];
            for (int i = 0; i < b.length; ++i) {
                for (int j = 0; j < in[0].length; ++j) {
                    int v = in[i][j];
                    if (little) {
                        b[i][j * 4] = (byte)(v & 0xFF);
                        b[i][j * 4 + 1] = (byte)(v >> 8 & 0xFF);
                        b[i][j * 4 + 2] = (byte)(v >> 16 & 0xFF);
                        b[i][j * 4 + 3] = (byte)(v >> 24 & 0xFF);
                        continue;
                    }
                    b[i][j * 4] = (byte)(v >> 24 & 0xFF);
                    b[i][j * 4 + 1] = (byte)(v >> 16 & 0xFF);
                    b[i][j * 4 + 2] = (byte)(v >> 8 & 0xFF);
                    b[i][j * 4 + 3] = (byte)(v & 0xFF);
                }
            }
            return b;
        }
        if (pixels instanceof float[][]) {
            float[][] in = (float[][])pixels;
            byte[][] b = new byte[in.length][in[0].length * 4];
            for (int i = 0; i < b.length; ++i) {
                for (int j = 0; j < in[0].length; ++j) {
                    int v = Float.floatToIntBits(in[i][j]);
                    if (little) {
                        b[i][j * 4] = (byte)(v & 0xFF);
                        b[i][j * 4 + 1] = (byte)(v >> 8 & 0xFF);
                        b[i][j * 4 + 2] = (byte)(v >> 16 & 0xFF);
                        b[i][j * 4 + 3] = (byte)(v >> 24 & 0xFF);
                        continue;
                    }
                    b[i][j * 4] = (byte)(v >> 24 & 0xFF);
                    b[i][j * 4 + 1] = (byte)(v >> 16 & 0xFF);
                    b[i][j * 4 + 2] = (byte)(v >> 8 & 0xFF);
                    b[i][j * 4 + 3] = (byte)(v & 0xFF);
                }
            }
            return b;
        }
        if (pixels instanceof double[][]) {
            // empty if block
        }
        return null;
    }

    public static int getPixelType(BufferedImage image) {
        int type = image.getRaster().getDataBuffer().getDataType();
        switch (type) {
            case 0: {
                return 1;
            }
            case 5: {
                return 7;
            }
            case 4: {
                return 6;
            }
            case 3: {
                return 4;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 3;
            }
        }
        return -1;
    }

    public static byte[] getBytes(BufferedImage img, boolean separated, int c) {
        byte[][] p = ImageTools.getBytes(img);
        if (separated || p.length == 1) {
            return p[0];
        }
        byte[] rtn = new byte[p.length * p[0].length];
        for (int i = 0; i < p.length; ++i) {
            System.arraycopy(p[i], 0, rtn, i * p[0].length, p[i].length);
        }
        return rtn;
    }

    public static byte[][] make24Bits(Object pixels, int w, int h, boolean interleaved, boolean reverse) {
        int[] pix = ImageTools.make24Bits(pixels, w, h, interleaved);
        byte[][] rtn = new byte[3][pix.length];
        for (int i = 0; i < pix.length; ++i) {
            byte r = (byte)(pix[i] >> 16 & 0xFF);
            rtn[1][i] = (byte)(pix[i] >> 8 & 0xFF);
            byte b = (byte)(pix[i] & 0xFF);
            rtn[0][i] = reverse ? b : r;
            rtn[2][i] = reverse ? r : b;
        }
        return rtn;
    }

    public static int[] make24Bits(Object pixels, int w, int h, boolean interleaved) {
        int i;
        Object[] s;
        int[] rtn = new int[w * h];
        byte[] b = null;
        if (pixels instanceof byte[]) {
            b = (byte[])pixels;
        } else if (pixels instanceof short[]) {
            s = (short[])pixels;
            b = new byte[s.length];
            for (i = 0; i < s.length; ++i) {
                int v = s[i] & 0xFFFF;
                b[i] = (byte)v;
            }
        } else if (pixels instanceof int[]) {
            s = (int[])pixels;
            b = new byte[s.length];
            for (i = 0; i < s.length; ++i) {
                int value = s[i] & 0xFFFFFFFF;
                b[i] = (byte)value;
            }
        } else if (pixels instanceof float[]) {
            s = (float[])pixels;
            b = new byte[s.length];
            for (i = 0; i < s.length; ++i) {
                short value = s[i];
                b[i] = (byte)(255.0f * value);
            }
        } else if (pixels instanceof double[]) {
            s = (double[])pixels;
            b = new byte[s.length];
            for (i = 0; i < s.length; ++i) {
                short value = s[i];
                b[i] = (byte)Math.round((double)value);
            }
        }
        int c = b.length / rtn.length;
        for (i = 0; i < rtn.length; ++i) {
            int j;
            byte[] a = new byte[4];
            for (j = c - 1; j >= 0; --j) {
                a[j] = b[interleaved ? i * c + j : i + j * w * h];
            }
            if (c == 1) {
                for (j = 1; j < a.length; ++j) {
                    a[j] = a[0];
                }
            }
            byte tmp = a[0];
            a[0] = a[2];
            a[2] = tmp;
            rtn[i] = DataTools.bytesToInt(a, true);
        }
        return rtn;
    }

    public static byte[][] splitChannels(byte[] array, int c, int bytes, boolean reverse, boolean interleaved) {
        byte[][] rtn = new byte[c][array.length / c];
        if (interleaved) {
            if (reverse) {
                int offset = 0;
                for (int i = c - 1; i >= 0; --i) {
                    System.arraycopy(array, offset, rtn[i], 0, rtn[i].length);
                    offset += rtn[c].length;
                }
            } else {
                for (int i = 0; i < c; ++i) {
                    System.arraycopy(array, i * rtn[i].length, rtn[i], 0, rtn[i].length);
                }
            }
        } else if (reverse) {
            int next = 0;
            for (int i = 0; i < array.length; i += c * bytes) {
                for (int j = c - 1; j >= 0; --j) {
                    for (int k = 0; k < bytes; ++k) {
                        if (next < rtn[j].length) {
                            rtn[c - j - 1][next] = array[i + j * bytes + k];
                        }
                        ++next;
                    }
                    next -= bytes;
                }
                next += bytes;
            }
        } else {
            int next = 0;
            for (int i = 0; i < array.length; i += c * bytes) {
                for (int j = 0; j < c; ++j) {
                    for (int k = 0; k < bytes; ++k) {
                        if (next < rtn[j].length) {
                            rtn[j][next] = array[i + j * bytes + k];
                        }
                        ++next;
                    }
                    next -= bytes;
                }
                next += bytes;
            }
        }
        return rtn;
    }

    public static BufferedImage[] splitChannels(BufferedImage image) {
        BufferedImage[] results;
        block7: {
            Object o;
            int c;
            int h;
            int w;
            block10: {
                block9: {
                    block8: {
                        block6: {
                            w = image.getWidth();
                            h = image.getHeight();
                            c = image.getRaster().getNumBands();
                            if (c == 1) {
                                return new BufferedImage[]{image};
                            }
                            results = new BufferedImage[c];
                            o = ImageTools.getPixels(image);
                            if (!(o instanceof byte[][])) break block6;
                            byte[][] pix = (byte[][])o;
                            for (int i = 0; i < c; ++i) {
                                results[i] = ImageTools.makeImage(pix[i], w, h);
                            }
                            break block7;
                        }
                        if (!(o instanceof short[][])) break block8;
                        short[][] pix = (short[][])o;
                        for (int i = 0; i < c; ++i) {
                            results[i] = ImageTools.makeImage(pix[i], w, h);
                        }
                        break block7;
                    }
                    if (!(o instanceof int[][])) break block9;
                    int[][] pix = (int[][])o;
                    for (int i = 0; i < c; ++i) {
                        results[i] = ImageTools.makeImage(pix[i], w, h);
                    }
                    break block7;
                }
                if (!(o instanceof float[][])) break block10;
                float[][] pix = (float[][])o;
                for (int i = 0; i < c; ++i) {
                    results[i] = ImageTools.makeImage(pix[i], w, h);
                }
                break block7;
            }
            if (!(o instanceof double[][])) break block7;
            double[][] pix = (double[][])o;
            for (int i = 0; i < c; ++i) {
                results[i] = ImageTools.makeImage(pix[i], w, h);
            }
        }
        return results;
    }

    public static BufferedImage mergeChannels(BufferedImage[] images) {
        if (images == null || images.length == 0) {
            return null;
        }
        Object[] list = new Object[images.length];
        int c = 0;
        int type = 0;
        for (int i = 0; i < images.length; ++i) {
            Object o = ImageTools.getPixels(images[i]);
            if (o instanceof byte[][]) {
                if (i == 0) {
                    type = 0;
                } else if (type != 0) {
                    return null;
                }
                c += ((byte[][])o).length;
            } else if (o instanceof short[][]) {
                if (i == 0) {
                    type = 1;
                } else if (type != 1) {
                    return null;
                }
                c += ((short[][])o).length;
            } else if (o instanceof int[][]) {
                if (i == 0) {
                    type = 3;
                } else if (type != 3) {
                    return null;
                }
                c += ((int[][])o).length;
            } else if (o instanceof float[][]) {
                if (i == 0) {
                    type = 4;
                } else if (type != 4) {
                    return null;
                }
                c += ((float[][])o).length;
            } else if (o instanceof double[][]) {
                if (i == 0) {
                    type = 5;
                } else if (type != 5) {
                    return null;
                }
                c += ((double[][])o).length;
            }
            if (c > 4) {
                return null;
            }
            list[i] = o;
        }
        if (c < 1 || c > 4) {
            return null;
        }
        int w = images[0].getWidth();
        int h = images[0].getHeight();
        if (type == 0) {
            byte[][] pix = new byte[c][];
            int ndx = 0;
            for (int i = 0; i < list.length; ++i) {
                byte[][] b = (byte[][])list[i];
                for (int j = 0; j < b.length; ++j) {
                    pix[ndx++] = b[j];
                }
            }
            while (ndx < pix.length) {
                pix[ndx++] = new byte[w * h];
            }
            return ImageTools.makeImage(pix, w, h);
        }
        if (type == 1) {
            short[][] pix = new short[c][];
            int ndx = 0;
            for (int i = 0; i < list.length; ++i) {
                short[][] b = (short[][])list[i];
                for (int j = 0; j < b.length; ++j) {
                    pix[ndx++] = b[j];
                }
            }
            while (ndx < pix.length) {
                pix[ndx++] = new short[w * h];
            }
            return ImageTools.makeImage(pix, w, h);
        }
        if (type == 3) {
            int[][] pix = new int[c][];
            int ndx = 0;
            for (int i = 0; i < list.length; ++i) {
                int[][] b = (int[][])list[i];
                for (int j = 0; j < b.length; ++j) {
                    pix[ndx++] = b[j];
                }
            }
            while (ndx < pix.length) {
                pix[ndx++] = new int[w * h];
            }
            return ImageTools.makeImage(pix, w, h);
        }
        if (type == 4) {
            float[][] pix = new float[c][];
            int ndx = 0;
            for (int i = 0; i < list.length; ++i) {
                float[][] b = (float[][])list[i];
                for (int j = 0; j < b.length; ++j) {
                    pix[ndx++] = b[j];
                }
            }
            while (ndx < pix.length) {
                pix[ndx++] = new float[w * h];
            }
            return ImageTools.makeImage(pix, w, h);
        }
        if (type == 5) {
            double[][] pix = new double[c][];
            int ndx = 0;
            for (int i = 0; i < list.length; ++i) {
                double[][] b = (double[][])list[i];
                for (int j = 0; j < b.length; ++j) {
                    pix[ndx++] = b[j];
                }
            }
            while (ndx < pix.length) {
                pix[ndx++] = new double[w * h];
            }
            return ImageTools.makeImage(pix, w, h);
        }
        return null;
    }

    public static BufferedImage padImage(BufferedImage img, int width, int height) {
        boolean needsPadding;
        if (img == null) {
            byte[][] data = new byte[1][width * height];
            return ImageTools.makeImage(data, width, height);
        }
        boolean bl = needsPadding = img.getWidth() != width || img.getHeight() != height;
        if (needsPadding) {
            Object pixels = ImageTools.getPixels(img);
            if (pixels instanceof byte[][]) {
                byte[][] b = (byte[][])pixels;
                byte[][] newBytes = new byte[b.length][width * height];
                for (int i = 0; i < b.length; ++i) {
                    newBytes[i] = ImageTools.padImage(b[i], false, 1, img.getWidth(), width, height);
                }
                return ImageTools.makeImage(newBytes, width, height);
            }
            if (pixels instanceof short[][]) {
                short[][] b = (short[][])pixels;
                short[][] newShorts = new short[b.length][width * height];
                for (int i = 0; i < b.length; ++i) {
                    newShorts[i] = ImageTools.padImage(b[i], false, 1, img.getWidth(), width, height);
                }
                return ImageTools.makeImage(newShorts, width, height);
            }
            if (pixels instanceof int[][]) {
                int[][] b = (int[][])pixels;
                int[][] newInts = new int[b.length][width * height];
                for (int i = 0; i < b.length; ++i) {
                    newInts[i] = ImageTools.padImage(b[i], false, 1, img.getWidth(), width, height);
                }
                return ImageTools.makeImage(newInts, width, height);
            }
            if (pixels instanceof float[][]) {
                float[][] b = (float[][])pixels;
                float[][] newFloats = new float[b.length][width * height];
                for (int i = 0; i < b.length; ++i) {
                    newFloats[i] = ImageTools.padImage(b[i], false, 1, img.getWidth(), width, height);
                }
                return ImageTools.makeImage(newFloats, width, height);
            }
            if (pixels instanceof double[][]) {
                double[][] b = (double[][])pixels;
                double[][] newDoubles = new double[b.length][width * height];
                for (int i = 0; i < b.length; ++i) {
                    newDoubles[i] = ImageTools.padImage(b[i], false, 1, img.getWidth(), width, height);
                }
                return ImageTools.makeImage(newDoubles, width, height);
            }
            return null;
        }
        return img;
    }

    public static byte[] padImage(byte[] b, boolean interleaved, int c, int oldWidth, int width, int height) {
        int h;
        int oldHeight = b.length / (oldWidth * c);
        byte[] padded = new byte[height * width * c];
        int wClip = (width - oldWidth) / 2;
        int hClip = (height - oldHeight) / 2;
        int n = h = height < oldHeight ? height : oldHeight;
        if (interleaved) {
            int len;
            int n2 = len = oldWidth < width ? oldWidth : width;
            if (h == oldHeight) {
                for (int y = 0; y < h * c; ++y) {
                    int oldIndex = oldWidth * y;
                    int index = width * y;
                    System.arraycopy(b, oldIndex, padded, index, len);
                }
            } else {
                for (int ch = 0; ch < c; ++ch) {
                    for (int y = 0; y < h; ++y) {
                        int oldIndex = oldWidth * ch * oldHeight + oldWidth * y;
                        int index = width * ch * height + width * y;
                        System.arraycopy(b, oldIndex, padded, index, len);
                    }
                }
            }
        } else {
            int len = oldWidth < width ? oldWidth * c : width * c;
            int oy = 0;
            int y = 0;
            while (oy < oldHeight) {
                int oldIndex = oldWidth * c * y;
                int index = width * c * (y + hClip) + c * wClip;
                System.arraycopy(b, oldIndex, padded, index, len);
                ++oy;
                ++y;
            }
        }
        return padded;
    }

    public static short[] padImage(short[] b, boolean interleaved, int c, int oldWidth, int width, int height) {
        int h;
        int oldHeight = b.length / (oldWidth * c);
        short[] padded = new short[height * width * c];
        int wClip = (width - oldWidth) / 2;
        int hClip = (height - oldHeight) / 2;
        int n = h = height < oldHeight ? height : oldHeight;
        if (interleaved) {
            int len;
            int n2 = len = oldWidth < width ? oldWidth : width;
            if (h == oldHeight) {
                for (int y = 0; y < h * c; ++y) {
                    int oldIndex = oldWidth * y;
                    int index = width * y;
                    System.arraycopy(b, oldIndex, padded, index, len);
                }
            } else {
                for (int ch = 0; ch < c; ++ch) {
                    for (int y = 0; y < h; ++y) {
                        int oldIndex = oldWidth * ch * oldHeight + oldWidth * y;
                        int index = width * ch * height + width * y;
                        System.arraycopy(b, oldIndex, padded, index, len);
                    }
                }
            }
        } else {
            int len = oldWidth < width ? oldWidth * c : width * c;
            int oy = 0;
            int y = 0;
            while (oy < oldHeight) {
                int oldIndex = oldWidth * c * y;
                int index = width * c * (y + hClip) + c * wClip;
                System.arraycopy(b, oldIndex, padded, index, len);
                ++oy;
                ++y;
            }
        }
        return padded;
    }

    public static int[] padImage(int[] b, boolean interleaved, int c, int oldWidth, int width, int height) {
        int h;
        int oldHeight = b.length / (oldWidth * c);
        int[] padded = new int[height * width * c];
        int wClip = (width - oldWidth) / 2;
        int hClip = (height - oldHeight) / 2;
        int n = h = height < oldHeight ? height : oldHeight;
        if (interleaved) {
            int len;
            int n2 = len = oldWidth < width ? oldWidth : width;
            if (h == oldHeight) {
                for (int y = 0; y < h * c; ++y) {
                    int oldIndex = oldWidth * y;
                    int index = width * y;
                    System.arraycopy(b, oldIndex, padded, index, len);
                }
            } else {
                for (int ch = 0; ch < c; ++ch) {
                    for (int y = 0; y < h; ++y) {
                        int oldIndex = oldWidth * ch * oldHeight + oldWidth * y;
                        int index = width * ch * height + width * y;
                        System.arraycopy(b, oldIndex, padded, index, len);
                    }
                }
            }
        } else {
            int len = oldWidth < width ? oldWidth * c : width * c;
            int oy = 0;
            int y = 0;
            while (oy < oldHeight) {
                int oldIndex = oldWidth * c * y;
                int index = width * c * (y + hClip) + c * wClip;
                System.arraycopy(b, oldIndex, padded, index, len);
                ++oy;
                ++y;
            }
        }
        return padded;
    }

    public static float[] padImage(float[] b, boolean interleaved, int c, int oldWidth, int width, int height) {
        int h;
        int oldHeight = b.length / (oldWidth * c);
        float[] padded = new float[height * width * c];
        int wClip = (width - oldWidth) / 2;
        int hClip = (height - oldHeight) / 2;
        int n = h = height < oldHeight ? height : oldHeight;
        if (interleaved) {
            int len;
            int n2 = len = oldWidth < width ? oldWidth : width;
            if (h == oldHeight) {
                for (int y = 0; y < h * c; ++y) {
                    int oldIndex = oldWidth * y;
                    int index = width * y;
                    System.arraycopy(b, oldIndex, padded, index, len);
                }
            } else {
                for (int ch = 0; ch < c; ++ch) {
                    for (int y = 0; y < h; ++y) {
                        int oldIndex = oldWidth * ch * oldHeight + oldWidth * y;
                        int index = width * ch * height + width * y;
                        System.arraycopy(b, oldIndex, padded, index, len);
                    }
                }
            }
        } else {
            int len = oldWidth < width ? oldWidth * c : width * c;
            int oy = 0;
            int y = 0;
            while (oy < oldHeight) {
                int oldIndex = oldWidth * c * y;
                int index = width * c * (y + hClip) + c * wClip;
                System.arraycopy(b, oldIndex, padded, index, len);
                ++oy;
                ++y;
            }
        }
        return padded;
    }

    public static double[] padImage(double[] b, boolean interleaved, int c, int oldWidth, int width, int height) {
        int h;
        int oldHeight = b.length / (oldWidth * c);
        double[] padded = new double[height * width * c];
        int wClip = (width - oldWidth) / 2;
        int hClip = (height - oldHeight) / 2;
        int n = h = height < oldHeight ? height : oldHeight;
        if (interleaved) {
            int len;
            int n2 = len = oldWidth < width ? oldWidth : width;
            if (h == oldHeight) {
                for (int y = 0; y < h * c; ++y) {
                    int oldIndex = oldWidth * y;
                    int index = width * y;
                    System.arraycopy(b, oldIndex, padded, index, len);
                }
            } else {
                for (int ch = 0; ch < c; ++ch) {
                    for (int y = 0; y < h; ++y) {
                        int oldIndex = oldWidth * ch * oldHeight + oldWidth * y;
                        int index = width * ch * height + width * y;
                        System.arraycopy(b, oldIndex, padded, index, len);
                    }
                }
            }
        } else {
            int len = oldWidth < width ? oldWidth * c : width * c;
            int oy = 0;
            int y = 0;
            while (oy < oldHeight) {
                int oldIndex = oldWidth * c * y;
                int index = width * c * (y + hClip) + c * wClip;
                System.arraycopy(b, oldIndex, padded, index, len);
                ++oy;
                ++y;
            }
        }
        return padded;
    }

    public static short[][] demosaic(short[][] input, int w, int h) {
        int off;
        int m;
        int off2;
        int diff;
        float sum;
        int j;
        int i;
        for (int i2 = 0; i2 < input[0].length; ++i2) {
            int j2;
            int[] indices;
            int count;
            int sum2;
            boolean needsRed = i2 / w % 2 != 1 || i2 % w % 2 != 1;
            boolean needsBlue = i2 / w % 2 != 0 || i2 % w % 2 != 0;
            boolean needsGreen = needsBlue ^ needsRed;
            if (needsRed) {
                sum2 = 0;
                count = 0;
                indices = null;
                indices = !needsBlue ? new int[]{i2 - w - 1, i2 - w + 1, i2 + w - 1, i2 + w + 1} : (i2 / w % 2 == 1 ? new int[]{i2 - 1, i2 + 1} : new int[]{i2 - w, i2 + w});
                for (j2 = 0; j2 < indices.length; ++j2) {
                    if (indices[j2] >= input[0].length || indices[j2] < 0) continue;
                    sum2 += input[0][indices[j2]];
                    ++count;
                }
                if (count > 0) {
                    input[0][i2] = (short)(sum2 / count);
                }
            }
            if (needsGreen) {
                sum2 = 0;
                count = 0;
                indices = new int[]{i2 - w, i2 - 1, i2 + 1, i2 + w};
                for (j2 = 0; j2 < indices.length; ++j2) {
                    if (indices[j2] >= input[0].length || indices[j2] < 0) continue;
                    sum2 += input[1][indices[j2]];
                    ++count;
                }
                if (count > 0) {
                    input[1][i2] = (short)(sum2 / count);
                }
            }
            if (!needsBlue) continue;
            sum2 = 0;
            count = 0;
            indices = null;
            indices = !needsRed ? new int[]{i2 - w - 1, i2 - w + 1, i2 + w - 1, i2 + w + 1} : (i2 / w % 2 == 1 ? new int[]{i2 - w, i2 + w} : new int[]{i2 - 1, i2 + 1});
            for (j2 = 0; j2 < indices.length; ++j2) {
                if (indices[j2] >= input[0].length || indices[j2] < 0) continue;
                sum2 += input[2][indices[j2]];
                ++count;
            }
            if (count <= 0) continue;
            input[2][i2] = (short)(sum2 / count);
        }
        short[] newRed = new short[w * h];
        short[] newGreen = new short[w * h];
        short[] newBlue = new short[w * h];
        float[][] kernel = new float[5][5];
        kernel[0] = new float[]{0.458f, 0.823f, 1.0f, 0.823f, 0.458f};
        kernel[1] = new float[]{0.823f, 1.0f, 1.09f, 1.0f, 0.823f};
        kernel[2] = new float[]{1.0f, 1.09f, 1.135f, 1.09f, 1.0f};
        kernel[3] = new float[]{0.823f, 1.0f, 1.09f, 1.0f, 0.823f};
        kernel[4] = new float[]{0.458f, 0.823f, 1.0f, 0.823f, 0.458f};
        for (i = 0; i < h; ++i) {
            for (j = 0; j < w; ++j) {
                float redRow = 0.0f;
                float greenRow = 0.0f;
                float blueRow = 0.0f;
                float[] kernelRow = kernel[i % 5];
                sum = 0.0f;
                if (diff < 5) {
                    for (diff = w - j; diff > 0; --diff) {
                        off2 = i * w + j + diff - 1;
                        redRow += kernelRow[diff - 1] * (float)input[0][off2];
                        greenRow += kernelRow[diff - 1] * (float)input[1][off2];
                        blueRow += kernelRow[diff - 1] * (float)input[2][off2];
                        sum += kernelRow[diff - 1];
                    }
                } else {
                    for (m = 0; m < 5; ++m) {
                        off = i * w + j + m;
                        redRow += kernelRow[m] * (float)input[0][off];
                        greenRow += kernelRow[m] * (float)input[1][off];
                        blueRow += kernelRow[m] * (float)input[2][off];
                        sum += kernelRow[m];
                    }
                }
                if (sum == 0.0f) {
                    sum = 1.0f;
                }
                newRed[i * w + j] = (short)(redRow / sum);
                newGreen[i * w + j] = (short)(greenRow / sum);
                newBlue[i * w + j] = (short)(blueRow / sum);
            }
        }
        for (i = 0; i < h; ++i) {
            for (j = 0; j < w; ++j) {
                float redCol = 0.0f;
                float greenCol = 0.0f;
                float blueCol = 0.0f;
                float[] kernelCol = kernel[j % 5];
                sum = 0.0f;
                if (diff < 5) {
                    for (diff = h - i; diff > 0; --diff) {
                        off2 = (i + diff - 1) * w + j;
                        redCol += kernelCol[diff - 1] * (float)newRed[off2];
                        greenCol += kernelCol[diff - 1] * (float)newGreen[off2];
                        blueCol += kernelCol[diff - 1] * (float)newBlue[off2];
                        sum += kernelCol[diff - 1];
                    }
                } else {
                    for (m = 0; m < 5; ++m) {
                        off = (i + m) * w + j;
                        redCol += kernelCol[m] * (float)newRed[off];
                        greenCol += kernelCol[m] * (float)newGreen[off];
                        blueCol += kernelCol[m] * (float)newBlue[off];
                        sum += kernelCol[m];
                    }
                }
                if (sum == 0.0f) {
                    sum = 1.0f;
                }
                input[0][i * w + j] = (short)(redCol / sum);
                input[1][i * w + j] = (short)(greenCol / sum);
                input[2][i * w + j] = (short)(blueCol / sum);
            }
        }
        return input;
    }

    public static BufferedImage autoscale(BufferedImage img, int min, int max) {
        Object pixels = ImageTools.getPixels(img);
        if (pixels instanceof byte[][]) {
            return img;
        }
        if (pixels instanceof short[][]) {
            short[][] shorts = (short[][])pixels;
            byte[][] out = new byte[shorts.length][shorts[0].length];
            for (int i = 0; i < out.length; ++i) {
                for (int j = 0; j < out[i].length; ++j) {
                    if (shorts[i][j] < 0) {
                        short[] sArray = shorts[i];
                        int n = j;
                        sArray[n] = (short)(sArray[n] + Short.MAX_VALUE);
                    }
                    float diff = (float)max - (float)min;
                    float dist = (float)(shorts[i][j] - min) / diff;
                    out[i][j] = shorts[i][j] >= max ? -1 : (shorts[i][j] <= min ? 0 : (int)((int)(dist * 256.0f)));
                }
            }
            return ImageTools.makeImage(out, img.getWidth(), img.getHeight());
        }
        if (pixels instanceof int[][]) {
            int[][] ints = (int[][])pixels;
            byte[][] out = new byte[ints.length][ints[0].length];
            for (int i = 0; i < out.length; ++i) {
                for (int j = 0; j < out[i].length; ++j) {
                    if (ints[i][j] >= max) {
                        out[i][j] = -1;
                        continue;
                    }
                    if (ints[i][j] <= min) {
                        out[i][j] = 0;
                        continue;
                    }
                    int diff = max - min;
                    float dist = (ints[i][j] - min) / diff;
                    out[i][j] = (byte)(dist * 256.0f);
                }
            }
            return ImageTools.makeImage(out, img.getWidth(), img.getHeight());
        }
        if (pixels instanceof float[][]) {
            float[][] floats = (float[][])pixels;
            byte[][] out = new byte[floats.length][floats[0].length];
            for (int i = 0; i < out.length; ++i) {
                for (int j = 0; j < out[i].length; ++j) {
                    if (floats[i][j] >= (float)max) {
                        out[i][j] = -1;
                        continue;
                    }
                    if (floats[i][j] <= (float)min) {
                        out[i][j] = 0;
                        continue;
                    }
                    int diff = max - min;
                    float dist = (floats[i][j] - (float)min) / (float)diff;
                    out[i][j] = (byte)(dist * 256.0f);
                }
            }
            return ImageTools.makeImage(out, img.getWidth(), img.getHeight());
        }
        if (pixels instanceof double[][]) {
            double[][] doubles = (double[][])pixels;
            byte[][] out = new byte[doubles.length][doubles[0].length];
            for (int i = 0; i < out.length; ++i) {
                for (int j = 0; j < out[i].length; ++j) {
                    if (doubles[i][j] >= (double)max) {
                        out[i][j] = -1;
                        continue;
                    }
                    if (doubles[i][j] <= (double)min) {
                        out[i][j] = 0;
                        continue;
                    }
                    int diff = max - min;
                    float dist = (float)(doubles[i][j] - (double)min) / (float)diff;
                    out[i][j] = (byte)(dist * 256.0f);
                }
            }
            return ImageTools.makeImage(out, img.getWidth(), img.getHeight());
        }
        return img;
    }

    public static byte[] autoscale(byte[] b, int min, int max, int bpp, boolean little) {
        if (bpp == 1) {
            return b;
        }
        byte[] out = new byte[b.length / bpp];
        for (int i = 0; i < b.length; i += bpp) {
            int s = DataTools.bytesToInt(b, i, bpp, little);
            if (s >= max) {
                s = 255;
            } else if (s <= min) {
                s = 0;
            } else {
                int diff = max - min;
                float dist = (s - min) / diff;
                s = (int)dist * 256;
            }
            out[i / bpp] = (byte)s;
        }
        return out;
    }

    public static Double[] scanData(byte[] plane, int bits, boolean littleEndian) {
        int j;
        int max = 0;
        int min = Integer.MAX_VALUE;
        if (bits <= 8) {
            for (j = 0; j < plane.length; ++j) {
                if (plane[j] < min) {
                    min = plane[j];
                }
                if (plane[j] <= max) continue;
                max = plane[j];
            }
        } else if (bits == 16) {
            for (j = 0; j < plane.length; j += 2) {
                int s = DataTools.bytesToShort(plane, j, 2, littleEndian);
                if (s < min) {
                    min = s;
                }
                if (s <= max) continue;
                max = s;
            }
        } else if (bits == 32) {
            for (j = 0; j < plane.length; j += 4) {
                int s = DataTools.bytesToInt(plane, j, 4, littleEndian);
                if (s < min) {
                    min = s;
                }
                if (s <= max) continue;
                max = s;
            }
        }
        Double[] rtn = new Double[]{new Double(min), new Double(max)};
        return rtn;
    }

    public static BufferedImage copyScaled(BufferedImage source, BufferedImage target, Object hint) {
        if (hint == null) {
            hint = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
        }
        Graphics2D g2 = target.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
        double scalex = (double)target.getWidth() / (double)source.getWidth();
        double scaley = (double)target.getHeight() / (double)source.getHeight();
        AffineTransform xform = AffineTransform.getScaleInstance(scalex, scaley);
        g2.drawRenderedImage(source, xform);
        g2.dispose();
        return target;
    }

    public static BufferedImage scale2D(BufferedImage image, int width, int height, Object hint, GraphicsConfiguration gc) {
        if (gc == null) {
            gc = ImageTools.getDefaultConfiguration();
        }
        int trans = image.getColorModel().getTransparency();
        return ImageTools.copyScaled(image, gc.createCompatibleImage(width, height, trans), hint);
    }

    public static BufferedImage scale2D(BufferedImage image, int width, int height, Object hint, ColorModel cm) {
        WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
        boolean isRasterPremultiplied = cm.isAlphaPremultiplied();
        return ImageTools.copyScaled(image, new BufferedImage(cm, raster, isRasterPremultiplied, null), hint);
    }

    public static Image scaleAWT(BufferedImage source, int width, int height, int hint) {
        return source.getScaledInstance(width, height, hint);
    }

    public static BufferedImage scale(BufferedImage source, int width, int height, boolean pad) {
        int w = source.getWidth();
        int h = source.getHeight();
        if (w == width && h == height) {
            return source;
        }
        int finalWidth = width;
        int finalHeight = height;
        if (pad) {
            double r = (double)w / (double)h;
            double ratio = (double)width / (double)height;
            if (r > ratio) {
                height = h * width / w;
            } else {
                width = w * height / h;
            }
        }
        BufferedImage result = null;
        Image scaled = ImageTools.scaleAWT(source, width, height, 16);
        result = ImageTools.makeBuffered(scaled, source.getColorModel());
        return ImageTools.padImage(result, finalWidth, finalHeight);
    }

    public static BufferedImage makeBuffered(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        ImageTools.loadImage(image);
        BufferedImage img = new BufferedImage(image.getWidth(OBS), image.getHeight(OBS), 1);
        Graphics g = img.getGraphics();
        g.drawImage(image, 0, 0, OBS);
        g.dispose();
        return img;
    }

    public static BufferedImage makeBuffered(Image image, ColorModel cm) {
        BufferedImage bi;
        if (image instanceof BufferedImage && cm.equals((bi = (BufferedImage)image).getColorModel())) {
            return bi;
        }
        ImageTools.loadImage(image);
        int w = image.getWidth(OBS);
        int h = image.getHeight(OBS);
        boolean alphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = cm.createCompatibleWritableRaster(w, h);
        BufferedImage result = new BufferedImage(cm, raster, alphaPremultiplied, null);
        Graphics2D g = result.createGraphics();
        g.drawImage(image, 0, 0, OBS);
        g.dispose();
        return result;
    }

    public static boolean loadImage(Image image) {
        if (image instanceof BufferedImage) {
            return true;
        }
        MediaTracker tracker = new MediaTracker(OBS);
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException exc) {
            return false;
        }
        return 8 == tracker.statusID(0, false);
    }

    public static Dimension getSize(Image image) {
        if (image == null) {
            return new Dimension(0, 0);
        }
        if (image instanceof BufferedImage) {
            BufferedImage bi = (BufferedImage)image;
            return new Dimension(bi.getWidth(), bi.getHeight());
        }
        ImageTools.loadImage(image);
        return new Dimension(image.getWidth(OBS), image.getHeight(OBS));
    }

    public static BufferedImage makeCompatible(BufferedImage image, GraphicsConfiguration gc) {
        if (gc == null) {
            gc = ImageTools.getDefaultConfiguration();
        }
        int w = image.getWidth();
        int h = image.getHeight();
        int trans = image.getColorModel().getTransparency();
        BufferedImage result = gc.createCompatibleImage(w, h, trans);
        Graphics2D g2 = result.createGraphics();
        g2.drawRenderedImage(image, null);
        g2.dispose();
        return result;
    }

    public static GraphicsConfiguration getDefaultConfiguration() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        return gd.getDefaultConfiguration();
    }

    public static ColorModel makeColorModel(int c, int dataType) {
        int type;
        switch (c) {
            case 1: {
                type = 1003;
                break;
            }
            case 2: {
                type = -1;
                break;
            }
            case 3: {
                type = 1000;
                break;
            }
            case 4: {
                type = 1000;
                break;
            }
            default: {
                return null;
            }
        }
        return new ComponentColorModel(TwoChannelColorSpace.getInstance(type), c == 4, false, 3, dataType);
    }

    public static BufferedImage indexedToRGB(BufferedImage img, boolean le) {
        byte[][] indices = ImageTools.getPixelBytes(img, le);
        if (indices.length > 1) {
            return img;
        }
        if (ImageTools.getPixelType(img) == 1) {
            IndexedColorModel model = (IndexedColorModel)img.getColorModel();
            byte[][] b = new byte[3][indices[0].length];
            for (int i = 0; i < indices[0].length; ++i) {
                b[0][i] = (byte)(model.getRed(indices[0][i] & 0xFF) & 0xFF);
                b[1][i] = (byte)(model.getGreen(indices[0][i] & 0xFF) & 0xFF);
                b[2][i] = (byte)(model.getBlue(indices[0][i] & 0xFF) & 0xFF);
            }
            return ImageTools.makeImage(b, img.getWidth(), img.getHeight());
        }
        if (ImageTools.getPixelType(img) == 3) {
            IndexedColorModel model = (IndexedColorModel)img.getColorModel();
            short[][] s = new short[3][indices[0].length / 2];
            for (int i = 0; i < s[0].length; ++i) {
                int ndx = DataTools.bytesToInt(indices[0], i * 2, 2, le) & 0xFFFF;
                s[0][i] = (short)(model.getRed(ndx) & 0xFFFF);
                s[1][i] = (short)(model.getRed(ndx) & 0xFFFF);
                s[2][i] = (short)(model.getRed(ndx) & 0xFFFF);
            }
            return ImageTools.makeImage(s, img.getWidth(), img.getHeight());
        }
        return null;
    }

    public static byte[][] indexedToRGB(byte[][] lut, byte[] b) {
        byte[][] rtn = new byte[lut.length][b.length];
        for (int i = 0; i < b.length; ++i) {
            for (int j = 0; j < lut.length; ++j) {
                rtn[j][i] = lut[j][b[i]];
            }
        }
        return rtn;
    }

    public static short[][] indexedToRGB(short[][] lut, byte[] b, boolean le) {
        short[][] rtn = new short[lut.length][b.length / 2];
        for (int i = 0; i < b.length / 2; ++i) {
            for (int j = 0; j < lut.length; ++j) {
                rtn[j][i] = lut[j][DataTools.bytesToShort(b, i * 2, 2, le)];
            }
        }
        return rtn;
    }
}

