/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ui.context.support;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.HierarchicalMessageSource;
import org.springframework.context.MessageSource;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.ui.context.HierarchicalThemeSource;
import org.springframework.ui.context.Theme;
import org.springframework.ui.context.ThemeSource;
import org.springframework.ui.context.support.SimpleTheme;

public class ResourceBundleThemeSource
implements HierarchicalThemeSource {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ThemeSource parentThemeSource;
    private String basenamePrefix = "";
    private final Map themeCache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParentThemeSource(ThemeSource parent) {
        this.parentThemeSource = parent;
        Map map = this.themeCache;
        synchronized (map) {
            Iterator it = this.themeCache.values().iterator();
            while (it.hasNext()) {
                this.initParent((Theme)it.next());
            }
        }
    }

    public ThemeSource getParentThemeSource() {
        return this.parentThemeSource;
    }

    public void setBasenamePrefix(String basenamePrefix) {
        this.basenamePrefix = basenamePrefix != null ? basenamePrefix : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Theme getTheme(String themeName) {
        if (themeName == null) {
            return null;
        }
        Map map = this.themeCache;
        synchronized (map) {
            Theme theme = (Theme)this.themeCache.get(themeName);
            if (theme == null) {
                String basename = this.basenamePrefix + themeName;
                MessageSource messageSource = this.createMessageSource(basename);
                theme = new SimpleTheme(themeName, messageSource);
                this.initParent(theme);
                this.themeCache.put(themeName, theme);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Theme created: name '" + themeName + "', basename [" + basename + "]");
                }
            }
            return theme;
        }
    }

    protected MessageSource createMessageSource(String basename) {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasename(basename);
        return messageSource;
    }

    protected void initParent(Theme theme) {
        if (theme.getMessageSource() instanceof HierarchicalMessageSource) {
            Theme parentTheme;
            HierarchicalMessageSource messageSource = (HierarchicalMessageSource)theme.getMessageSource();
            if (this.getParentThemeSource() != null && messageSource.getParentMessageSource() == null && (parentTheme = this.getParentThemeSource().getTheme(theme.getName())) != null) {
                messageSource.setParentMessageSource(parentTheme.getMessageSource());
            }
        }
    }
}

