/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdf5;

import java.util.Vector;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import visad.data.hdf5.HDF5DatasetAdapted;
import visad.data.hdf5.HDF5GroupAdapted;
import visad.data.hdf5.hdf5objects.HDF5File;

public class HDF5FileAdapted
extends HDF5File {
    private Vector datas = null;

    public HDF5FileAdapted(String filename, int flags, int create_id, int access_id) throws HDF5Exception {
        super(filename, flags, create_id, access_id);
        try {
            this.init();
        }
        catch (HDF5Exception e) {
            throw new HDF5Exception("HDF5FileAdapted: " + e);
        }
    }

    public HDF5FileAdapted(String filename, int flags, int access_id) throws HDF5Exception {
        super(filename, flags, access_id);
        try {
            this.init();
        }
        catch (HDF5Exception e) {
            throw new HDF5Exception("HDF5FileAdapted: " + e);
        }
    }

    public void init() throws HDF5Exception {
        if (this.id < 0) {
            return;
        }
        this.datas = new Vector();
        int nelems = H5.H5Gn_members(this.id, "/");
        if (nelems <= 0) {
            return;
        }
        int pid = this.id;
        String gname = "/";
        int[] oType = new int[]{0};
        String[] oName = new String[]{" "};
        for (int i = 0; i < nelems; ++i) {
            H5.H5Gget_obj_info_idx(pid, gname, i, oName, oType);
            switch (oType[0]) {
                case 1: {
                    HDF5GroupAdapted g = new HDF5GroupAdapted(pid, "/" + oName[0]);
                    this.datas.add(g);
                    break;
                }
                case 2: {
                    HDF5DatasetAdapted d = new HDF5DatasetAdapted(pid, "/" + oName[0]);
                    this.datas.add(d);
                    break;
                }
            }
            oName[0] = null;
            oType[0] = -1;
        }
    }

    public int getObjectCount() {
        if (this.datas == null) {
            return -1;
        }
        return this.datas.size();
    }

    public Object getDataObject(int index) {
        if (this.datas == null) {
            return null;
        }
        return this.datas.elementAt(index);
    }
}

