package rgbterm_test

import (
	"fmt"
	"github.com/aybabtme/rgbterm"
)

func ExampleBytes() {
	data := []byte("█")

	h, s, l := rgbterm.RGBtoHSL(252, 255, 43)
	for i := 0; i < 80; i++ {
		h += (5.0 / 360.0)
		if h > 1.0 {
			h = 0.0
		}
		r, g, b := rgbterm.HSLtoRGB(h, s, l)
		fmt.Printf("%s", rgbterm.Bytes(data, r, g, b, 0, 0, 0)) //b, g, r))
	}
	fmt.Println()

	// Output:
	// [38;5;190;48;5;16m█[0;00m[38;5;190;48;5;16m█[0;00m[38;5;154;48;5;16m█[0;00m[38;5;154;48;5;16m█[0;00m[38;5;154;48;5;16m█[0;00m[38;5;118;48;5;16m█[0;00m[38;5;118;48;5;16m█[0;00m[38;5;118;48;5;16m█[0;00m[38;5;82;48;5;16m█[0;00m[38;5;82;48;5;16m█[0;00m[38;5;82;48;5;16m█[0;00m[38;5;46;48;5;16m█[0;00m[38;5;47;48;5;16m█[0;00m[38;5;47;48;5;16m█[0;00m[38;5;47;48;5;16m█[0;00m[38;5;48;48;5;16m█[0;00m[38;5;48;48;5;16m█[0;00m[38;5;48;48;5;16m█[0;00m[38;5;49;48;5;16m█[0;00m[38;5;49;48;5;16m█[0;00m[38;5;50;48;5;16m█[0;00m[38;5;50;48;5;16m█[0;00m[38;5;50;48;5;16m█[0;00m[38;5;45;48;5;16m█[0;00m[38;5;45;48;5;16m█[0;00m[38;5;45;48;5;16m█[0;00m[38;5;39;48;5;16m█[0;00m[38;5;39;48;5;16m█[0;00m[38;5;39;48;5;16m█[0;00m[38;5;33;48;5;16m█[0;00m[38;5;33;48;5;16m█[0;00m[38;5;33;48;5;16m█[0;00m[38;5;27;48;5;16m█[0;00m[38;5;27;48;5;16m█[0;00m[38;5;27;48;5;16m█[0;00m[38;5;21;48;5;16m█[0;00m[38;5;57;48;5;16m█[0;00m[38;5;57;48;5;16m█[0;00m[38;5;57;48;5;16m█[0;00m[38;5;93;48;5;16m█[0;00m[38;5;93;48;5;16m█[0;00m[38;5;93;48;5;16m█[0;00m[38;5;129;48;5;16m█[0;00m[38;5;129;48;5;16m█[0;00m[38;5;165;48;5;16m█[0;00m[38;5;165;48;5;16m█[0;00m[38;5;165;48;5;16m█[0;00m[38;5;200;48;5;16m█[0;00m[38;5;200;48;5;16m█[0;00m[38;5;200;48;5;16m█[0;00m[38;5;199;48;5;16m█[0;00m[38;5;199;48;5;16m█[0;00m[38;5;199;48;5;16m█[0;00m[38;5;198;48;5;16m█[0;00m[38;5;198;48;5;16m█[0;00m[38;5;198;48;5;16m█[0;00m[38;5;197;48;5;16m█[0;00m[38;5;197;48;5;16m█[0;00m[38;5;197;48;5;16m█[0;00m[38;5;196;48;5;16m█[0;00m[38;5;202;48;5;16m█[0;00m[38;5;202;48;5;16m█[0;00m[38;5;202;48;5;16m█[0;00m[38;5;208;48;5;16m█[0;00m[38;5;208;48;5;16m█[0;00m[38;5;208;48;5;16m█[0;00m[38;5;214;48;5;16m█[0;00m[38;5;214;48;5;16m█[0;00m[38;5;214;48;5;16m█[0;00m[38;5;220;48;5;16m█[0;00m[38;5;220;48;5;16m█[0;00m[38;5;226;48;5;16m█[0;00m[38;5;190;48;5;16m█[0;00m[38;5;190;48;5;16m█[0;00m[38;5;154;48;5;16m█[0;00m[38;5;154;48;5;16m█[0;00m[38;5;154;48;5;16m█[0;00m[38;5;118;48;5;16m█[0;00m[38;5;118;48;5;16m█[0;00m[38;5;118;48;5;16m█[0;00m

}

func ExampleBgBytes() {
	data := []byte(" ")

	h, s, l := rgbterm.RGBtoHSL(252, 255, 43)
	for i := 0; i < 80; i++ {
		h += (5.0 / 360.0)
		if h > 1.0 {
			h = 0.0
		}
		r, g, b := rgbterm.HSLtoRGB(h, s, l)
		fmt.Printf("%s", rgbterm.BgBytes(data, r, g, b)) //b, g, r))
	}
	fmt.Println()

	// Output:
	// [48;5;190m [0;00m[48;5;190m [0;00m[48;5;154m [0;00m[48;5;154m [0;00m[48;5;154m [0;00m[48;5;118m [0;00m[48;5;118m [0;00m[48;5;118m [0;00m[48;5;82m [0;00m[48;5;82m [0;00m[48;5;82m [0;00m[48;5;46m [0;00m[48;5;47m [0;00m[48;5;47m [0;00m[48;5;47m [0;00m[48;5;48m [0;00m[48;5;48m [0;00m[48;5;48m [0;00m[48;5;49m [0;00m[48;5;49m [0;00m[48;5;50m [0;00m[48;5;50m [0;00m[48;5;50m [0;00m[48;5;45m [0;00m[48;5;45m [0;00m[48;5;45m [0;00m[48;5;39m [0;00m[48;5;39m [0;00m[48;5;39m [0;00m[48;5;33m [0;00m[48;5;33m [0;00m[48;5;33m [0;00m[48;5;27m [0;00m[48;5;27m [0;00m[48;5;27m [0;00m[48;5;21m [0;00m[48;5;57m [0;00m[48;5;57m [0;00m[48;5;57m [0;00m[48;5;93m [0;00m[48;5;93m [0;00m[48;5;93m [0;00m[48;5;129m [0;00m[48;5;129m [0;00m[48;5;165m [0;00m[48;5;165m [0;00m[48;5;165m [0;00m[48;5;200m [0;00m[48;5;200m [0;00m[48;5;200m [0;00m[48;5;199m [0;00m[48;5;199m [0;00m[48;5;199m [0;00m[48;5;198m [0;00m[48;5;198m [0;00m[48;5;198m [0;00m[48;5;197m [0;00m[48;5;197m [0;00m[48;5;197m [0;00m[48;5;196m [0;00m[48;5;202m [0;00m[48;5;202m [0;00m[48;5;202m [0;00m[48;5;208m [0;00m[48;5;208m [0;00m[48;5;208m [0;00m[48;5;214m [0;00m[48;5;214m [0;00m[48;5;214m [0;00m[48;5;220m [0;00m[48;5;220m [0;00m[48;5;226m [0;00m[48;5;190m [0;00m[48;5;190m [0;00m[48;5;154m [0;00m[48;5;154m [0;00m[48;5;154m [0;00m[48;5;118m [0;00m[48;5;118m [0;00m[48;5;118m [0;00m

}

func ExampleString() {
	var r, g, b uint8
	// pick a color
	r, g, b = 252, 255, 43
	// choose a word
	word := "=)"
	// colorize it!
	coloredWord := rgbterm.String(word, r, g, b, 0, 0, 0)

	fmt.Println("Oh!", coloredWord, "hello!")

	// Output:
	// Oh! [38;5;190;48;5;16m=)[0;00m hello!
}
