# gopls documentation

gopls (pronounced: "go please") is the official [language server] for the Go language.

It is currently in **alpha**, so it is **not stable**. You can see more information about the status of gopls and its supported features [here](doc/status.md).

In general you should not need to know anything about gopls, it should be integrated into your editor for you.

See the [installing](doc/user.md) section of the user guide if you need to install or update gopls by hand.

## Issues

If you are having issues with gopls, please first check the [known issues](doc/status.md#known-issues) before following the [troubleshooting](doc/troubleshooting.md#steps) guide.
If that does not give you the information you need, reach out to us.

You can chat with us on:
* the golang-tools [mailing list]
* the #gopls [slack channel] on the gophers slack

If you think you have an issue that needs fixing, or a feature suggestion, then please make sure you follow the steps to [file an issue](doc/troubleshooting.md#file-an-issue) with the right information to allow us to address it.

If you need to talk to us directly (for instance to file an issue with confidential information in it) you can reach out directly to [@stamblerre] or [@ianthehat].

## More information

If you want to know more about it, have an unusual use case, or want to contribute, please read the following documents

* [Using gopls](doc/user.md)
* [Troubleshooting and reporting issues](doc/troubleshooting.md)
* [Integrating gopls with an editor](doc/integrating.md)
* [Contributing to gopls](doc/contributing.md)
* [Design requirements and decisions](doc/design.md)
* [Implementation details](doc/implementation.md)

[language server]: https://langserver.org
[mailing list]: https://groups.google.com/forum/#!forum/golang-tools
[slack channel]: https://gophers.slack.com/messages/CJZH85XCZ
[@stamblerre]: https://github.com/stamblerre "Rebecca Stambler"
[@ianthehat]: https://github.com/ianthehat "Ian Cottrell"