/* Generated by re2c 0.13.5 on Tue Jul  7 22:07:19 2015 */
#line 1 "parse_date.re"
/*
   +----------------------------------------------------------------------+
   | PHP Version 5                                                        |
   +----------------------------------------------------------------------+
   | Copyright (c) 1997-2015 The PHP Group                                |
   +----------------------------------------------------------------------+
   | This source file is subject to version 3.01 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.php.net/license/3_01.txt                                  |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Authors: Derick Rethans <derick@derickrethans.nl>                    |
   +----------------------------------------------------------------------+
 */

/* $Id$ */

#include "timelib.h"

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <assert.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define TIMELIB_UNSET   -99999

#define TIMELIB_SECOND  1
#define TIMELIB_MINUTE  2
#define TIMELIB_HOUR    3
#define TIMELIB_DAY     4
#define TIMELIB_MONTH   5
#define TIMELIB_YEAR    6
#define TIMELIB_WEEKDAY 7
#define TIMELIB_SPECIAL 8

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279
#define TIMELIB_LF_DAY_OF_MONTH 280
#define TIMELIB_WEEK_DAY_OF_MONTH 281

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

/* Some compilers like AIX, defines uchar in sys/types.h */
#undef uchar
typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { add_error(s, "Double time specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { add_error(s, "Double date specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_weekday_relative = 1; }
#define TIMELIB_HAVE_SPECIAL_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_special_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { s->time->have_zone > 1 ? add_error(s, "Double timezone specification") : add_warning(s, "Double timezone specification"); timelib_string_free(str); s->time->have_zone++; return TIMELIB_ERROR; } else { s->time->have_zone++; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x, l) { \
	if (((x) == TIMELIB_UNSET) || ((l) >= 4)) { \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

#include "timelib_structs.h"

typedef struct timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	struct timelib_error_container *errors;

	struct timelib_time *time;
	const timelib_tzdb  *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
    const char *name;
    int         type;
    int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

/* The timezone table. */
const static timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

const static timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

const static timelib_tz_lookup_table timelib_timezone_utc[] = {
	{ "utc", 0, 0, "UTC" },
};

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "mon",         TIMELIB_WEEKDAY, 1 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "tue",         TIMELIB_WEEKDAY, 2 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "wed",         TIMELIB_WEEKDAY, 3 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "thu",         TIMELIB_WEEKDAY, 4 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "fri",         TIMELIB_WEEKDAY, 5 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sat",         TIMELIB_WEEKDAY, 6 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },
	{ "sun",         TIMELIB_WEEKDAY, 0 },

	{ "weekday",     TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ "weekdays",    TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "eighth",   0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ' || ptr[0] == '\t') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static void add_warning(Scanner *s, char *error)
{
	s->errors->warning_count++;
	s->errors->warning_messages = realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].message = strdup(error);
}

static void add_error(Scanner *s, char *error)
{
	s->errors->error_count++;
	s->errors->error_messages = realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->error_messages[s->errors->error_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->error_messages[s->errors->error_count - 1].message = strdup(error);
}

static void add_pbf_warning(Scanner *s, char *error, char *sptr, char *cptr)
{
	s->errors->warning_count++;
	s->errors->warning_messages = realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].position = cptr - sptr;
	s->errors->warning_messages[s->errors->warning_count - 1].character = *cptr;
	s->errors->warning_messages[s->errors->warning_count - 1].message = strdup(error);
}

static void add_pbf_error(Scanner *s, char *error, char *sptr, char *cptr)
{
	s->errors->error_count++;
	s->errors->error_messages = realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].position = cptr - sptr;
	s->errors->error_messages[s->errors->error_count - 1].character = *cptr;
	s->errors->error_messages[s->errors->error_count - 1].message = strdup(error);
}

static timelib_sll timelib_meridian(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		*ptr += 3;
	} else {
		++*ptr;
	}
	return retval;
}

static timelib_sll timelib_meridian_with_check(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (**ptr && !strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if(!**ptr) {
		return TIMELIB_UNSET;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		++*ptr;
		if (**ptr != 'm' && **ptr != 'M') {
			return TIMELIB_UNSET;
		}
		++*ptr;
		if (**ptr != '.' ) {
			return TIMELIB_UNSET;
		}
		++*ptr;
	} else if (**ptr == 'm' || **ptr == 'M') {
		++*ptr;
	} else {
		return TIMELIB_UNSET;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr_ex(char **ptr, int max_length, int *scanned_length)
{
	char *begin, *end, *str;
	timelib_sll tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	if (scanned_length) {
		*scanned_length = end - begin;
	}
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	free(str);
	return tmp_nr;
}

static timelib_sll timelib_get_nr(char **ptr, int max_length)
{
	return timelib_get_nr_ex(ptr, max_length, NULL);
}

static void timelib_skip_day_suffix(char **ptr)
{
	if (isspace(**ptr)) {
		return;
	}
	if (!strncasecmp(*ptr, "nd", 2) || !strncasecmp(*ptr, "rd", 2) ||!strncasecmp(*ptr, "st", 2) || !strncasecmp(*ptr, "th", 2)) {
		*ptr += 2;
	}
}

static double timelib_get_frac_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	double tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr != '.') && (**ptr != ':') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while (((**ptr == '.') || (**ptr == ':') || ((**ptr >= '0') && (**ptr <= '9'))) && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	if (str[0] == ':') {
		str[0] = '.';
	}
	tmp_nr = strtod(str, NULL);
	free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_unsigned_nr(char **ptr, int max_length)
{
	timelib_ull dir = 1;

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}

	while (**ptr == '+' || **ptr == '-')
	{
		if (**ptr == '-') {
			dir *= -1;
		}
		++*ptr;
	}
	return dir * timelib_get_nr(ptr, max_length);
}

static timelib_sll timelib_lookup_relative_text(char **ptr, int *behavior)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static long timelib_lookup_month(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	free(word);
	return value;
}

static long timelib_get_month(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t') {
		++*ptr;
	}
}

static void timelib_eat_until_separator(char **ptr)
{
	++*ptr;
	while (strchr(" \t.,:;/-0123456789", **ptr) == NULL) {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ' && **ptr != ',' && **ptr != '\t' && **ptr != ';' && **ptr != ':' &&
           **ptr != '/' && **ptr != '.' && **ptr != '-' && **ptr != '(' && **ptr != ')' ) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	free(word);
	return value;
}

static void timelib_set_relative(char **ptr, timelib_sll amount, int behavior, Scanner *s)
{
	const timelib_relunit* relunit;

	if (!(relunit = timelib_lookup_relunit(ptr))) {
		return;
	}

	switch (relunit->unit) {
		case TIMELIB_SECOND: s->time->relative.s += amount * relunit->multiplier; break;
		case TIMELIB_MINUTE: s->time->relative.i += amount * relunit->multiplier; break;
		case TIMELIB_HOUR:   s->time->relative.h += amount * relunit->multiplier; break;
		case TIMELIB_DAY:    s->time->relative.d += amount * relunit->multiplier; break;
		case TIMELIB_MONTH:  s->time->relative.m += amount * relunit->multiplier; break;
		case TIMELIB_YEAR:   s->time->relative.y += amount * relunit->multiplier; break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;

		case TIMELIB_SPECIAL:
			TIMELIB_HAVE_SPECIAL_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.special.type = relunit->multiplier;
			s->time->relative.special.amount = amount;
	}
}

const static timelib_tz_lookup_table* abbr_search(const char *word, long gmtoffset, int isdst)
{
	int first_found = 0;
	const timelib_tz_lookup_table  *tp, *first_found_elem = NULL;
	const timelib_tz_lookup_table  *fmp;

	if (strcasecmp("utc", word) == 0 || strcasecmp("gmt", word) == 0) {
		return timelib_timezone_utc;
	}

	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}

	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if ((fmp->gmtoffset * 60) == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static long timelib_lookup_abbr(char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	const timelib_tz_lookup_table *tp;

	while (**ptr != '\0' && **ptr != ')' && **ptr != ' ') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if ((tp = abbr_search(word, -1, 0))) {
		value = -tp->gmtoffset / 60;
		*dst = tp->type;
		value += tp->type * 60;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

long timelib_parse_zone(char **ptr, int *dst, timelib_time *t, int *tz_not_found, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_wrapper)
{
	timelib_tzinfo *res;
	long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '\t' || **ptr == '(') {
		++*ptr;
	}
	if ((*ptr)[0] == 'G' && (*ptr)[1] == 'M' && (*ptr)[2] == 'T' && ((*ptr)[3] == '+' || (*ptr)[3] == '-')) {
		*ptr += 3;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr);
	} else {
		int found = 0;
		long offset = 0;
		char *tz_abbr;

		t->is_localtime = 1;

		/* First, we lookup by abbreviation only */
		offset = timelib_lookup_abbr(ptr, dst, &tz_abbr, &found);
		if (found) {
			t->zone_type = TIMELIB_ZONETYPE_ABBR;
			timelib_time_tz_abbr_update(t, tz_abbr);
		}

		/* Otherwise, we look if we have a TimeZone identifier */
		if (!found || strcmp("UTC", tz_abbr) == 0) {
			if ((res = tz_wrapper(tz_abbr, tzdb)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		free(arg.v[i]);            \
	}                              \
	if (arg.v) {                   \
		free(arg.v);               \
	}                              \
}

static int scan(Scanner *s, timelib_tz_get_wrapper tz_get_wrapper)
{
	uchar *cursor = s->cur;
	char *str, *ptr = NULL;

std:
	s->tok = cursor;
	s->len = 0;
#line 940 "parse_date.re"



#line 822 "parse_date.c"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0, 100,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		100,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0, 128,  64, 160,  96,   0, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   0,   0,   0,   0,   0,   0, 
		  0,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   8,   0,   0,   0,   0,   0, 
		  0,  24,  24,  24,  88,  24,  24,  24, 
		 88,  24,  24,  24,  24,  24,  88,  24, 
		 24,  24,  88,  88,  88,  24,  24,  24, 
		 24,  24,  24,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};

	YYDEBUG(0, *YYCURSOR);
	if ((YYLIMIT - YYCURSOR) < 31) YYFILL(31);
	yych = *YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case 0x00:
	case '\n':	goto yy51;
	case '\t':
	case ' ':	goto yy48;
	case '(':	goto yy45;
	case '+':
	case '-':	goto yy30;
	case ',':
	case '.':	goto yy50;
	case '0':	goto yy25;
	case '1':	goto yy26;
	case '2':	goto yy27;
	case '3':	goto yy28;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy29;
	case '@':	goto yy11;
	case 'A':	goto yy36;
	case 'B':	goto yy17;
	case 'C':
	case 'H':
	case 'K':
	case 'Q':
	case 'R':
	case 'U':
	case 'Z':	goto yy46;
	case 'D':	goto yy40;
	case 'E':	goto yy21;
	case 'F':	goto yy13;
	case 'G':	goto yy44;
	case 'I':	goto yy31;
	case 'J':	goto yy34;
	case 'L':	goto yy15;
	case 'M':	goto yy7;
	case 'N':	goto yy5;
	case 'O':	goto yy38;
	case 'P':	goto yy23;
	case 'S':	goto yy19;
	case 'T':	goto yy9;
	case 'V':	goto yy32;
	case 'W':	goto yy42;
	case 'X':	goto yy33;
	case 'Y':	goto yy2;
	case 'a':	goto yy37;
	case 'b':	goto yy18;
	case 'c':
	case 'g':
	case 'h':
	case 'i':
	case 'k':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy47;
	case 'd':	goto yy41;
	case 'e':	goto yy22;
	case 'f':	goto yy14;
	case 'j':	goto yy35;
	case 'l':	goto yy16;
	case 'm':	goto yy8;
	case 'n':	goto yy6;
	case 'o':	goto yy39;
	case 'p':	goto yy24;
	case 's':	goto yy20;
	case 't':	goto yy10;
	case 'w':	goto yy43;
	case 'y':	goto yy4;
	default:	goto yy53;
	}
yy2:
	YYDEBUG(2, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'E') {
		if (yych <= ')') {
			if (yych >= ')') goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
			goto yy1523;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy140;
			if (yych >= 'a') goto yy145;
		} else {
			if (yych <= 'e') goto yy1532;
			if (yych <= 'z') goto yy145;
		}
	}
yy3:
	YYDEBUG(3, *YYCURSOR);
#line 1620 "parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		TIMELIB_HAVE_TZ();
		s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
		if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
#line 975 "parse_date.c"
yy4:
	YYDEBUG(4, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
			goto yy1523;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'e') goto yy1523;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy5:
	YYDEBUG(5, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1494;
				goto yy140;
			} else {
				if (yych <= 'I') goto yy1495;
				if (yych <= 'N') goto yy140;
				goto yy1493;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy140;
				goto yy3;
			} else {
				if (yych == 'e') goto yy1510;
				goto yy145;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1511;
				goto yy145;
			} else {
				if (yych <= 'o') goto yy1509;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy6:
	YYDEBUG(6, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1494;
				goto yy140;
			} else {
				if (yych <= 'I') goto yy1495;
				if (yych <= 'N') goto yy140;
				goto yy1493;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy140;
				goto yy3;
			} else {
				if (yych == 'e') goto yy1494;
				goto yy140;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1495;
				goto yy140;
			} else {
				if (yych <= 'o') goto yy1493;
				if (yych <= 'z') goto yy140;
				goto yy3;
			}
		}
	}
yy7:
	YYDEBUG(7, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy1463;
		} else {
			if (yych == 'I') goto yy1464;
			if (yych <= 'N') goto yy140;
			goto yy1465;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1478;
			goto yy145;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1479;
				goto yy145;
			} else {
				if (yych <= 'o') goto yy1480;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy8:
	YYDEBUG(8, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy1463;
		} else {
			if (yych == 'I') goto yy1464;
			if (yych <= 'N') goto yy140;
			goto yy1465;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1463;
			goto yy140;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1464;
				goto yy140;
			} else {
				if (yych <= 'o') goto yy1465;
				if (yych <= 'z') goto yy140;
				goto yy3;
			}
		}
	}
yy9:
	YYDEBUG(9, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case ')':	goto yy139;
	case '0':
	case '1':	goto yy1393;
	case '2':	goto yy1394;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1395;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':	goto yy140;
	case 'E':	goto yy1388;
	case 'H':	goto yy1389;
	case 'O':	goto yy1390;
	case 'U':	goto yy1391;
	case 'W':	goto yy1392;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	case 'e':	goto yy1431;
	case 'h':	goto yy1432;
	case 'o':	goto yy1433;
	case 'u':	goto yy1434;
	case 'w':	goto yy1435;
	default:	goto yy3;
	}
yy10:
	YYDEBUG(10, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case ')':	goto yy139;
	case '0':
	case '1':	goto yy1393;
	case '2':	goto yy1394;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1395;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy140;
	case 'E':
	case 'e':	goto yy1388;
	case 'H':
	case 'h':	goto yy1389;
	case 'O':
	case 'o':	goto yy1390;
	case 'U':
	case 'u':	goto yy1391;
	case 'W':
	case 'w':	goto yy1392;
	default:	goto yy3;
	}
yy11:
	YYDEBUG(11, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1384;
	if (yych <= '/') goto yy12;
	if (yych <= '9') goto yy1385;
yy12:
	YYDEBUG(12, *YYCURSOR);
#line 1715 "parse_date.re"
	{
		add_error(s, "Unexpected character");
		goto std;
	}
#line 1291 "parse_date.c"
yy13:
	YYDEBUG(13, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'D') goto yy140;
				goto yy1320;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy1321;
				goto yy140;
			} else {
				if (yych <= 'O') goto yy1322;
				if (yych <= 'Q') goto yy140;
				goto yy1323;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy140;
				if (yych <= '`') goto yy3;
				goto yy145;
			} else {
				if (yych <= 'e') goto yy1361;
				if (yych <= 'h') goto yy145;
				goto yy1362;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy1363;
				goto yy145;
			} else {
				if (yych <= 'r') goto yy1364;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy14:
	YYDEBUG(14, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'D') goto yy140;
				goto yy1320;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy1321;
				goto yy140;
			} else {
				if (yych <= 'O') goto yy1322;
				if (yych <= 'Q') goto yy140;
				goto yy1323;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy140;
				if (yych <= '`') goto yy3;
				goto yy140;
			} else {
				if (yych <= 'e') goto yy1320;
				if (yych <= 'h') goto yy140;
				goto yy1321;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy1322;
				goto yy140;
			} else {
				if (yych <= 'r') goto yy1323;
				if (yych <= 'z') goto yy140;
				goto yy3;
			}
		}
	}
yy15:
	YYDEBUG(15, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
		goto yy1306;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1317;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy16:
	YYDEBUG(16, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
		goto yy1306;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1306;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy17:
	YYDEBUG(17, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
		goto yy1286;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1303;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy18:
	YYDEBUG(18, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
		goto yy1286;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1286;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy19:
	YYDEBUG(19, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'A') goto yy1229;
				goto yy140;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1228;
				goto yy140;
			} else {
				if (yych <= 'I') goto yy1230;
				if (yych <= 'T') goto yy140;
				goto yy1231;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy140;
				goto yy3;
			} else {
				if (yych <= 'a') goto yy1258;
				if (yych <= 'd') goto yy145;
				goto yy1257;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy1259;
				goto yy145;
			} else {
				if (yych <= 'u') goto yy1260;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy20:
	YYDEBUG(20, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'A') goto yy1229;
				goto yy140;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1228;
				goto yy140;
			} else {
				if (yych <= 'I') goto yy1230;
				if (yych <= 'T') goto yy140;
				goto yy1231;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy140;
				goto yy3;
			} else {
				if (yych <= 'a') goto yy1229;
				if (yych <= 'd') goto yy140;
				goto yy1228;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy1230;
				goto yy140;
			} else {
				if (yych <= 'u') goto yy1231;
				if (yych <= 'z') goto yy140;
				goto yy3;
			}
		}
	}
yy21:
	YYDEBUG(21, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1198;
			if (yych <= 'K') goto yy140;
			goto yy1199;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy145;
			goto yy1216;
		} else {
			if (yych == 'l') goto yy1217;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy22:
	YYDEBUG(22, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1198;
			if (yych <= 'K') goto yy140;
			goto yy1199;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy140;
			goto yy1198;
		} else {
			if (yych == 'l') goto yy1199;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy23:
	YYDEBUG(23, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy140;
			goto yy1097;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy145;
		} else {
			if (yych <= 'r') goto yy1191;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy24:
	YYDEBUG(24, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy140;
			goto yy1097;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'r') goto yy1097;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy25:
	YYDEBUG(25, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':	goto yy1051;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'w':
	case 'y':	goto yy1053;
	case '-':	goto yy472;
	case '.':	goto yy1063;
	case '/':	goto yy471;
	case '0':	goto yy1096;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1095;
	case ':':	goto yy1064;
	case 'n':	goto yy469;
	case 'r':	goto yy470;
	case 's':	goto yy463;
	case 't':	goto yy467;
	default:	goto yy12;
	}
yy26:
	YYDEBUG(26, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':	goto yy459;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy461;
	case '-':	goto yy472;
	case '.':	goto yy473;
	case '/':	goto yy471;
	case '0':
	case '1':
	case '2':	goto yy1095;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1062;
	case ':':	goto yy482;
	case 'n':	goto yy469;
	case 'r':	goto yy470;
	case 's':	goto yy463;
	case 't':	goto yy467;
	default:	goto yy12;
	}
yy27:
	YYDEBUG(27, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':	goto yy459;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy461;
	case '-':	goto yy472;
	case '.':	goto yy473;
	case '/':	goto yy471;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':	goto yy1062;
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1049;
	case ':':	goto yy482;
	case 'n':	goto yy469;
	case 'r':	goto yy470;
	case 's':	goto yy463;
	case 't':	goto yy467;
	default:	goto yy12;
	}
yy28:
	YYDEBUG(28, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':	goto yy459;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy461;
	case '-':	goto yy472;
	case '.':	goto yy473;
	case '/':	goto yy471;
	case '0':
	case '1':	goto yy1049;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy468;
	case ':':	goto yy482;
	case 'n':	goto yy469;
	case 'r':	goto yy470;
	case 's':	goto yy463;
	case 't':	goto yy467;
	default:	goto yy12;
	}
yy29:
	YYDEBUG(29, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':	goto yy459;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy461;
	case '-':	goto yy472;
	case '.':	goto yy473;
	case '/':	goto yy471;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy468;
	case ':':	goto yy482;
	case 'n':	goto yy469;
	case 'r':	goto yy470;
	case 's':	goto yy463;
	case 't':	goto yy467;
	default:	goto yy12;
	}
yy30:
	YYDEBUG(30, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	YYDEBUG(-1, yych);
	switch (yych) {
	case '+':
	case '-':	goto yy439;
	case '0':
	case '1':	goto yy436;
	case '2':	goto yy437;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy438;
	default:	goto yy12;
	}
yy31:
	YYDEBUG(31, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy3;
			} else {
				if (yych == '/') goto yy3;
				goto yy195;
			}
		}
	} else {
		if (yych <= 'V') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy3;
				goto yy140;
			} else {
				if (yych <= 'I') goto yy435;
				if (yych <= 'U') goto yy140;
				goto yy434;
			}
		} else {
			if (yych <= 'Z') {
				if (yych == 'X') goto yy434;
				goto yy140;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy32:
	YYDEBUG(32, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy3;
			goto yy195;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy195;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy431;
				goto yy140;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy33:
	YYDEBUG(33, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy3;
			goto yy195;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy195;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy429;
				goto yy140;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy34:
	YYDEBUG(34, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych <= 'A') goto yy412;
			if (yych <= 'T') goto yy140;
			goto yy411;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy421;
		} else {
			if (yych == 'u') goto yy420;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy35:
	YYDEBUG(35, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych <= 'A') goto yy412;
			if (yych <= 'T') goto yy140;
			goto yy411;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy412;
		} else {
			if (yych == 'u') goto yy411;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy36:
	YYDEBUG(36, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy390;
				goto yy140;
			} else {
				if (yych <= 'P') goto yy389;
				if (yych <= 'T') goto yy140;
				goto yy388;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy140;
				goto yy3;
			} else {
				if (yych == 'g') goto yy402;
				goto yy145;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy401;
				goto yy145;
			} else {
				if (yych <= 'u') goto yy400;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy37:
	YYDEBUG(37, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy390;
				goto yy140;
			} else {
				if (yych <= 'P') goto yy389;
				if (yych <= 'T') goto yy140;
				goto yy388;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy140;
				goto yy3;
			} else {
				if (yych == 'g') goto yy390;
				goto yy140;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy389;
				goto yy140;
			} else {
				if (yych <= 'u') goto yy388;
				if (yych <= 'z') goto yy140;
				goto yy3;
			}
		}
	}
yy38:
	YYDEBUG(38, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy140;
			goto yy378;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy145;
		} else {
			if (yych <= 'c') goto yy383;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy39:
	YYDEBUG(39, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy140;
			goto yy378;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'c') goto yy378;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy40:
	YYDEBUG(40, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
			goto yy191;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy145;
		} else {
			if (yych <= 'e') goto yy369;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy41:
	YYDEBUG(41, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
			goto yy191;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'e') goto yy191;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy42:
	YYDEBUG(42, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
			goto yy164;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy145;
		} else {
			if (yych <= 'e') goto yy178;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy43:
	YYDEBUG(43, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
			goto yy164;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'e') goto yy164;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy44:
	YYDEBUG(44, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
		goto yy140;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy156;
			goto yy140;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy45:
	YYDEBUG(45, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy12;
	if (yych <= 'Z') goto yy155;
	if (yych <= '`') goto yy12;
	if (yych <= 'z') goto yy155;
	goto yy12;
yy46:
	YYDEBUG(46, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy140;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy145;
		goto yy3;
	}
yy47:
	YYDEBUG(47, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy140;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy140;
		goto yy3;
	}
yy48:
	YYDEBUG(48, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	if (yych <= '/') goto yy49;
	if (yych <= '9') goto yy54;
yy49:
	YYDEBUG(49, *YYCURSOR);
#line 1704 "parse_date.re"
	{
		goto std;
	}
#line 2352 "parse_date.c"
yy50:
	YYDEBUG(50, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy49;
yy51:
	YYDEBUG(51, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(52, *YYCURSOR);
#line 1709 "parse_date.re"
	{
		s->pos = cursor; s->line++;
		goto std;
	}
#line 2366 "parse_date.c"
yy53:
	YYDEBUG(53, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy12;
yy54:
	YYDEBUG(54, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
	YYDEBUG(55, *YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych >= ' ') goto yy59;
			} else {
				if (yych == 'D') goto yy64;
				if (yych >= 'F') goto yy65;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy63;
				if (yych >= 'M') goto yy62;
			} else {
				if (yych <= 'S') {
					if (yych >= 'S') goto yy61;
				} else {
					if (yych <= 'T') goto yy68;
					if (yych >= 'W') goto yy67;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy66;
				if (yych >= 'd') goto yy64;
			} else {
				if (yych <= 'f') {
					if (yych >= 'f') goto yy65;
				} else {
					if (yych == 'h') goto yy63;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy62;
				if (yych <= 'r') goto yy56;
				if (yych <= 's') goto yy61;
				goto yy68;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy67;
				} else {
					if (yych == 'y') goto yy66;
				}
			}
		}
	}
yy56:
	YYDEBUG(56, *YYCURSOR);
	YYCURSOR = YYMARKER;
	if (yyaccept <= 16) {
		if (yyaccept <= 8) {
			if (yyaccept <= 4) {
				if (yyaccept <= 2) {
					if (yyaccept <= 1) {
						if (yyaccept <= 0) {
							goto yy3;
						} else {
							goto yy12;
						}
					} else {
						goto yy49;
					}
				} else {
					if (yyaccept <= 3) {
						goto yy72;
					} else {
						goto yy166;
					}
				}
			} else {
				if (yyaccept <= 6) {
					if (yyaccept <= 5) {
						goto yy193;
					} else {
						goto yy198;
					}
				} else {
					if (yyaccept <= 7) {
						goto yy222;
					} else {
						goto yy294;
					}
				}
			}
		} else {
			if (yyaccept <= 12) {
				if (yyaccept <= 10) {
					if (yyaccept <= 9) {
						goto yy392;
					} else {
						goto yy475;
					}
				} else {
					if (yyaccept <= 11) {
						goto yy490;
					} else {
						goto yy611;
					}
				}
			} else {
				if (yyaccept <= 14) {
					if (yyaccept <= 13) {
						goto yy656;
					} else {
						goto yy666;
					}
				} else {
					if (yyaccept <= 15) {
						goto yy763;
					} else {
						goto yy783;
					}
				}
			}
		}
	} else {
		if (yyaccept <= 25) {
			if (yyaccept <= 21) {
				if (yyaccept <= 19) {
					if (yyaccept <= 18) {
						if (yyaccept <= 17) {
							goto yy814;
						} else {
							goto yy821;
						}
					} else {
						goto yy848;
					}
				} else {
					if (yyaccept <= 20) {
						goto yy793;
					} else {
						goto yy454;
					}
				}
			} else {
				if (yyaccept <= 23) {
					if (yyaccept <= 22) {
						goto yy973;
					} else {
						goto yy842;
					}
				} else {
					if (yyaccept <= 24) {
						goto yy1067;
					} else {
						goto yy1075;
					}
				}
			}
		} else {
			if (yyaccept <= 29) {
				if (yyaccept <= 27) {
					if (yyaccept <= 26) {
						goto yy1117;
					} else {
						goto yy1141;
					}
				} else {
					if (yyaccept <= 28) {
						goto yy1294;
					} else {
						goto yy1417;
					}
				}
			} else {
				if (yyaccept <= 31) {
					if (yyaccept <= 30) {
						goto yy1420;
					} else {
						goto yy1500;
					}
				} else {
					if (yyaccept <= 32) {
						goto yy1508;
					} else {
						goto yy1531;
					}
				}
			}
		}
	}
yy57:
	YYDEBUG(57, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(58, *YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy54;
	goto yy56;
yy59:
	YYDEBUG(59, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy60:
	YYDEBUG(60, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy56;
				goto yy59;
			} else {
				if (yych == 'D') goto yy64;
				if (yych <= 'E') goto yy56;
				goto yy65;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy63;
				if (yych <= 'L') goto yy56;
				goto yy62;
			} else {
				if (yych <= 'S') {
					if (yych <= 'R') goto yy56;
				} else {
					if (yych <= 'T') goto yy68;
					if (yych <= 'V') goto yy56;
					goto yy67;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy66;
				if (yych <= 'c') goto yy56;
				goto yy64;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy56;
					goto yy65;
				} else {
					if (yych == 'h') goto yy63;
					goto yy56;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy62;
				if (yych <= 'r') goto yy56;
				if (yych >= 't') goto yy68;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy56;
					goto yy67;
				} else {
					if (yych == 'y') goto yy66;
					goto yy56;
				}
			}
		}
	}
yy61:
	YYDEBUG(61, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy126;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy127;
			if (yych <= 'T') goto yy56;
			goto yy125;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy126;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy127;
			if (yych == 'u') goto yy125;
			goto yy56;
		}
	}
yy62:
	YYDEBUG(62, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto yy117;
		if (yych <= 'N') goto yy56;
		goto yy116;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy56;
			goto yy117;
		} else {
			if (yych == 'o') goto yy116;
			goto yy56;
		}
	}
yy63:
	YYDEBUG(63, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy114;
	if (yych == 'o') goto yy114;
	goto yy56;
yy64:
	YYDEBUG(64, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy113;
	if (yych == 'a') goto yy113;
	goto yy56;
yy65:
	YYDEBUG(65, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy98;
		if (yych <= 'Q') goto yy56;
		goto yy97;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy56;
			goto yy98;
		} else {
			if (yych == 'r') goto yy97;
			goto yy56;
		}
	}
yy66:
	YYDEBUG(66, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy94;
	if (yych == 'e') goto yy94;
	goto yy56;
yy67:
	YYDEBUG(67, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy82;
	if (yych == 'e') goto yy82;
	goto yy56;
yy68:
	YYDEBUG(68, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy69;
		if (yych <= 'T') goto yy56;
		goto yy70;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
		} else {
			if (yych == 'u') goto yy70;
			goto yy56;
		}
	}
yy69:
	YYDEBUG(69, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy77;
	if (yych == 'u') goto yy77;
	goto yy56;
yy70:
	YYDEBUG(70, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy71;
	if (yych != 'e') goto yy56;
yy71:
	YYDEBUG(71, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy73;
	if (yych == 's') goto yy73;
yy72:
	YYDEBUG(72, *YYCURSOR);
#line 1688 "parse_date.re"
	{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_unsigned_nr((char **) &ptr, 24);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, 1, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 2768 "parse_date.c"
yy73:
	YYDEBUG(73, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy74;
	if (yych != 'd') goto yy56;
yy74:
	YYDEBUG(74, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy75;
	if (yych != 'a') goto yy56;
yy75:
	YYDEBUG(75, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy76;
	if (yych != 'y') goto yy56;
yy76:
	YYDEBUG(76, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy72;
yy77:
	YYDEBUG(77, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy78;
	if (yych != 'r') goto yy72;
yy78:
	YYDEBUG(78, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy79;
	if (yych != 's') goto yy56;
yy79:
	YYDEBUG(79, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy80;
	if (yych != 'd') goto yy56;
yy80:
	YYDEBUG(80, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy81;
	if (yych != 'a') goto yy56;
yy81:
	YYDEBUG(81, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy76;
	if (yych == 'y') goto yy76;
	goto yy56;
yy82:
	YYDEBUG(82, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy56;
		if (yych <= 'D') goto yy84;
	} else {
		if (yych <= 'c') goto yy56;
		if (yych <= 'd') goto yy84;
		if (yych >= 'f') goto yy56;
	}
	YYDEBUG(83, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy90;
	if (yych == 'k') goto yy90;
	goto yy56;
yy84:
	YYDEBUG(84, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy85;
	if (yych != 'n') goto yy72;
yy85:
	YYDEBUG(85, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy86;
	if (yych != 'e') goto yy56;
yy86:
	YYDEBUG(86, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy87;
	if (yych != 's') goto yy56;
yy87:
	YYDEBUG(87, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy88;
	if (yych != 'd') goto yy56;
yy88:
	YYDEBUG(88, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy89;
	if (yych != 'a') goto yy56;
yy89:
	YYDEBUG(89, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy76;
	if (yych == 'y') goto yy76;
	goto yy56;
yy90:
	YYDEBUG(90, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy91;
		if (yych <= 'R') goto yy72;
		goto yy76;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy72;
		} else {
			if (yych == 's') goto yy76;
			goto yy72;
		}
	}
yy91:
	YYDEBUG(91, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy92;
	if (yych != 'a') goto yy56;
yy92:
	YYDEBUG(92, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy93;
	if (yych != 'y') goto yy56;
yy93:
	YYDEBUG(93, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy76;
	if (yych == 's') goto yy76;
	goto yy72;
yy94:
	YYDEBUG(94, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy95;
	if (yych != 'a') goto yy56;
yy95:
	YYDEBUG(95, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy96;
	if (yych != 'r') goto yy56;
yy96:
	YYDEBUG(96, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy76;
	if (yych == 's') goto yy76;
	goto yy72;
yy97:
	YYDEBUG(97, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy110;
	if (yych == 'i') goto yy110;
	goto yy56;
yy98:
	YYDEBUG(98, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy99;
	if (yych != 'r') goto yy56;
yy99:
	YYDEBUG(99, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy100;
	if (yych != 't') goto yy56;
yy100:
	YYDEBUG(100, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy102;
		if (yych <= 'M') goto yy56;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
			goto yy102;
		} else {
			if (yych != 'n') goto yy56;
		}
	}
	YYDEBUG(101, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy107;
	if (yych == 'i') goto yy107;
	goto yy56;
yy102:
	YYDEBUG(102, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy103;
	if (yych != 'n') goto yy56;
yy103:
	YYDEBUG(103, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy104;
	if (yych != 'i') goto yy56;
yy104:
	YYDEBUG(104, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy105;
	if (yych != 'g') goto yy56;
yy105:
	YYDEBUG(105, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy106;
	if (yych != 'h') goto yy56;
yy106:
	YYDEBUG(106, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy96;
	if (yych == 't') goto yy96;
	goto yy56;
yy107:
	YYDEBUG(107, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy108;
	if (yych != 'g') goto yy56;
yy108:
	YYDEBUG(108, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy109;
	if (yych != 'h') goto yy56;
yy109:
	YYDEBUG(109, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy96;
	if (yych == 't') goto yy96;
	goto yy56;
yy110:
	YYDEBUG(110, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy111;
	if (yych != 'd') goto yy72;
yy111:
	YYDEBUG(111, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy112;
	if (yych != 'a') goto yy56;
yy112:
	YYDEBUG(112, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy76;
	if (yych == 'y') goto yy76;
	goto yy56;
yy113:
	YYDEBUG(113, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy96;
	if (yych == 'y') goto yy96;
	goto yy56;
yy114:
	YYDEBUG(114, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy115;
	if (yych != 'u') goto yy56;
yy115:
	YYDEBUG(115, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy96;
	if (yych == 'r') goto yy96;
	goto yy56;
yy116:
	YYDEBUG(116, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy121;
	if (yych == 'n') goto yy121;
	goto yy56;
yy117:
	YYDEBUG(117, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy118;
	if (yych != 'n') goto yy56;
yy118:
	YYDEBUG(118, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy76;
		if (yych <= 'T') goto yy72;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy72;
			goto yy76;
		} else {
			if (yych != 'u') goto yy72;
		}
	}
	YYDEBUG(119, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy120;
	if (yych != 't') goto yy56;
yy120:
	YYDEBUG(120, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy96;
	if (yych == 'e') goto yy96;
	goto yy56;
yy121:
	YYDEBUG(121, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == 'D') goto yy122;
		if (yych <= 'S') goto yy72;
		goto yy123;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy72;
		} else {
			if (yych == 't') goto yy123;
			goto yy72;
		}
	}
yy122:
	YYDEBUG(122, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy124;
	if (yych == 'a') goto yy124;
	goto yy56;
yy123:
	YYDEBUG(123, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy96;
	if (yych == 'h') goto yy96;
	goto yy56;
yy124:
	YYDEBUG(124, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy76;
	if (yych == 'y') goto yy76;
	goto yy56;
yy125:
	YYDEBUG(125, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy136;
	if (yych == 'n') goto yy136;
	goto yy56;
yy126:
	YYDEBUG(126, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy131;
	if (yych == 't') goto yy131;
	goto yy56;
yy127:
	YYDEBUG(127, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy128;
	if (yych != 'c') goto yy56;
yy128:
	YYDEBUG(128, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy129;
		if (yych <= 'R') goto yy72;
		goto yy76;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy72;
		} else {
			if (yych == 's') goto yy76;
			goto yy72;
		}
	}
yy129:
	YYDEBUG(129, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy130;
	if (yych != 'n') goto yy56;
yy130:
	YYDEBUG(130, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy96;
	if (yych == 'd') goto yy96;
	goto yy56;
yy131:
	YYDEBUG(131, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy132;
	if (yych != 'u') goto yy72;
yy132:
	YYDEBUG(132, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy133;
	if (yych != 'r') goto yy56;
yy133:
	YYDEBUG(133, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy134;
	if (yych != 'd') goto yy56;
yy134:
	YYDEBUG(134, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy135;
	if (yych != 'a') goto yy56;
yy135:
	YYDEBUG(135, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy76;
	if (yych == 'y') goto yy76;
	goto yy56;
yy136:
	YYDEBUG(136, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy137;
	if (yych != 'd') goto yy72;
yy137:
	YYDEBUG(137, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy138;
	if (yych != 'a') goto yy56;
yy138:
	YYDEBUG(138, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy76;
	if (yych == 'y') goto yy76;
	goto yy56;
yy139:
	YYDEBUG(139, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy3;
yy140:
	YYDEBUG(140, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy141;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy141:
	YYDEBUG(141, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy142;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy142:
	YYDEBUG(142, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy143;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy143:
	YYDEBUG(143, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy144;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy144:
	YYDEBUG(144, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy139;
	goto yy3;
yy145:
	YYDEBUG(145, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			goto yy147;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy141;
			goto yy3;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy146:
	YYDEBUG(146, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy142;
			goto yy3;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy147:
	YYDEBUG(147, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy148;
	}
	goto yy56;
yy148:
	YYDEBUG(148, *YYCURSOR);
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(149, *YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy148;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy147;
		goto yy3;
	} else {
		if (yych <= '/') goto yy147;
		if (yych == '_') goto yy147;
		goto yy3;
	}
yy150:
	YYDEBUG(150, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			goto yy147;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy143;
			goto yy3;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy151:
	YYDEBUG(151, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			goto yy147;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy144;
			goto yy3;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy152:
	YYDEBUG(152, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '-') {
		if (yych == ')') goto yy139;
		if (yych <= ',') goto yy3;
		goto yy147;
	} else {
		if (yych <= '/') {
			if (yych <= '.') goto yy3;
			goto yy147;
		} else {
			if (yych == '_') goto yy147;
			goto yy3;
		}
	}
yy153:
	YYDEBUG(153, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy154:
	YYDEBUG(154, *YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy147;
		goto yy56;
	} else {
		if (yych <= '/') goto yy147;
		if (yych == '_') goto yy147;
		goto yy56;
	}
yy155:
	YYDEBUG(155, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy140;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy140;
		goto yy3;
	}
yy156:
	YYDEBUG(156, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
		goto yy141;
	} else {
		if (yych <= 'Z') {
			if (yych >= 'U') goto yy141;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
	YYDEBUG(157, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych != '+') goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy158;
			if (yych <= '@') goto yy3;
			goto yy142;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy158:
	YYDEBUG(158, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy159;
	if (yych <= '2') goto yy160;
	if (yych <= '9') goto yy161;
	goto yy56;
yy159:
	YYDEBUG(159, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '9') goto yy161;
	if (yych <= ':') goto yy162;
	goto yy3;
yy160:
	YYDEBUG(160, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy3;
		if (yych >= '5') goto yy163;
	} else {
		if (yych <= '9') goto yy139;
		if (yych <= ':') goto yy162;
		goto yy3;
	}
yy161:
	YYDEBUG(161, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '5') goto yy163;
	if (yych <= '9') goto yy139;
	if (yych >= ';') goto yy3;
yy162:
	YYDEBUG(162, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '5') goto yy163;
	if (yych <= '9') goto yy139;
	goto yy3;
yy163:
	YYDEBUG(163, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '9') goto yy139;
	goto yy3;
yy164:
	YYDEBUG(164, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych <= 'C') goto yy141;
			if (yych >= 'E') goto yy167;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'd') goto yy165;
			if (yych <= 'e') goto yy167;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy165:
	YYDEBUG(165, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'N') {
		if (yych <= ')') {
			if (yych >= ')') goto yy139;
		} else {
			if (yych <= '@') goto yy166;
			if (yych <= 'M') goto yy142;
			goto yy173;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy142;
			if (yych >= 'a') goto yy142;
		} else {
			if (yych <= 'n') goto yy173;
			if (yych <= 'z') goto yy142;
		}
	}
yy166:
	YYDEBUG(166, *YYCURSOR);
#line 1551 "parse_date.re"
	{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("daytext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();
		relunit = timelib_lookup_relunit((char**) &ptr);
		s->time->relative.weekday = relunit->multiplier;
		if (s->time->relative.weekday_behavior != 2) {
			s->time->relative.weekday_behavior = 1;
		}

		TIMELIB_DEINIT;
		return TIMELIB_WEEKDAY;
	}
#line 3547 "parse_date.c"
yy167:
	YYDEBUG(167, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'J') goto yy142;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'k') goto yy168;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy168:
	YYDEBUG(168, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy143;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'd') goto yy169;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy169:
	YYDEBUG(169, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy144;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy170;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy170:
	YYDEBUG(170, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy171;
		if (yych != 'y') goto yy3;
	}
yy171:
	YYDEBUG(171, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy172;
	if (yych != 's') goto yy166;
yy172:
	YYDEBUG(172, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy166;
yy173:
	YYDEBUG(173, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy143;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'e') goto yy174;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy174:
	YYDEBUG(174, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy144;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 's') goto yy175;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy175:
	YYDEBUG(175, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'D') goto yy176;
		if (yych != 'd') goto yy3;
	}
yy176:
	YYDEBUG(176, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy177;
	if (yych != 'a') goto yy56;
yy177:
	YYDEBUG(177, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy172;
	if (yych == 'y') goto yy172;
	goto yy56;
yy178:
	YYDEBUG(178, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy3;
				goto yy147;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'C') goto yy141;
				goto yy165;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'E') goto yy167;
				goto yy141;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy146;
			} else {
				if (yych <= 'e') goto yy180;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
	YYDEBUG(179, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy166;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy166;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy173;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy166;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy166;
				goto yy150;
			} else {
				if (yych <= 'n') goto yy186;
				if (yych <= 'z') goto yy150;
				goto yy166;
			}
		}
	}
yy180:
	YYDEBUG(180, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'J') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'K') goto yy168;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'j') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'k') goto yy181;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy181:
	YYDEBUG(181, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy169;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'd') goto yy182;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy182:
	YYDEBUG(182, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy170;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy183;
			if (yych <= 'z') goto yy152;
			goto yy3;
		}
	}
yy183:
	YYDEBUG(183, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy171;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'y') goto yy184;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy184:
	YYDEBUG(184, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == '-') goto yy147;
			goto yy166;
		} else {
			if (yych <= '/') goto yy147;
			if (yych <= 'R') goto yy166;
			goto yy172;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy147;
			goto yy166;
		} else {
			if (yych == 's') goto yy185;
			if (yych <= 'z') goto yy153;
			goto yy166;
		}
	}
yy185:
	YYDEBUG(185, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy147;
		goto yy166;
	} else {
		if (yych <= '/') goto yy147;
		if (yych == '_') goto yy147;
		goto yy166;
	}
yy186:
	YYDEBUG(186, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy174;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'e') goto yy187;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy187:
	YYDEBUG(187, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy175;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 's') goto yy188;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy188:
	YYDEBUG(188, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy176;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'd') goto yy189;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy189:
	YYDEBUG(189, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy177;
	if (yych != 'a') goto yy154;
	YYDEBUG(190, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy172;
	if (yych == 'y') goto yy185;
	goto yy154;
yy191:
	YYDEBUG(191, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy141;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'c') goto yy192;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy192:
	YYDEBUG(192, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych >= '\t') goto yy195;
			} else {
				if (yych == ' ') goto yy195;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
			} else {
				if (yych == 'E') goto yy201;
				goto yy142;
			}
		} else {
			if (yych <= 'd') {
				if (yych >= 'a') goto yy142;
			} else {
				if (yych <= 'e') goto yy201;
				if (yych <= 'z') goto yy142;
			}
		}
	}
yy193:
	YYDEBUG(193, *YYCURSOR);
#line 1610 "parse_date.re"
	{
		DEBUG_OUTPUT("monthtext");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_lookup_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 4076 "parse_date.c"
yy194:
	YYDEBUG(194, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 21) YYFILL(21);
	yych = *YYCURSOR;
yy195:
	YYDEBUG(195, *YYCURSOR);
	if (yybm[0+yych] & 32) {
		goto yy194;
	}
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy197;
	if (yych <= '3') goto yy199;
	if (yych <= '9') goto yy200;
	goto yy56;
yy196:
	YYDEBUG(196, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy195;
	if (yych <= '0') goto yy356;
	if (yych <= '2') goto yy357;
	if (yych <= '3') goto yy358;
	goto yy195;
yy197:
	YYDEBUG(197, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy215;
			if (yych <= '0') goto yy297;
			goto yy298;
		} else {
			if (yych <= '2') goto yy354;
			if (yych <= '9') goto yy355;
			goto yy215;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy211;
			if (yych <= 'q') goto yy215;
			goto yy212;
		} else {
			if (yych <= 's') goto yy210;
			if (yych <= 't') goto yy213;
			goto yy215;
		}
	}
yy198:
	YYDEBUG(198, *YYCURSOR);
#line 1356 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 4140 "parse_date.c"
yy199:
	YYDEBUG(199, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy215;
			if (yych <= '0') goto yy297;
			goto yy298;
		} else {
			if (yych <= '2') goto yy208;
			if (yych <= '9') goto yy209;
			goto yy215;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy211;
			if (yych <= 'q') goto yy215;
			goto yy212;
		} else {
			if (yych <= 's') goto yy210;
			if (yych <= 't') goto yy213;
			goto yy215;
		}
	}
yy200:
	YYDEBUG(200, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy215;
			if (yych <= '0') goto yy206;
			goto yy207;
		} else {
			if (yych <= '2') goto yy208;
			if (yych <= '9') goto yy209;
			goto yy215;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy211;
			if (yych <= 'q') goto yy215;
			goto yy212;
		} else {
			if (yych <= 's') goto yy210;
			if (yych <= 't') goto yy213;
			goto yy215;
		}
	}
yy201:
	YYDEBUG(201, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy143;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'm') goto yy202;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy202:
	YYDEBUG(202, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy144;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'b') goto yy203;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy203:
	YYDEBUG(203, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'E') goto yy204;
		if (yych != 'e') goto yy3;
	}
yy204:
	YYDEBUG(204, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy205;
	if (yych != 'r') goto yy56;
yy205:
	YYDEBUG(205, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy195;
		if (yych <= 0x1F) goto yy193;
		goto yy195;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy193;
			goto yy195;
		} else {
			if (yych <= '/') goto yy193;
			if (yych <= '9') goto yy195;
			goto yy193;
		}
	}
yy206:
	YYDEBUG(206, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy220;
		goto yy56;
	} else {
		if (yych <= '0') goto yy295;
		if (yych <= '9') goto yy296;
		if (yych <= ':') goto yy220;
		goto yy56;
	}
yy207:
	YYDEBUG(207, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy263;
		goto yy56;
	} else {
		if (yych <= '2') goto yy296;
		if (yych <= '9') goto yy295;
		if (yych <= ':') goto yy263;
		goto yy56;
	}
yy208:
	YYDEBUG(208, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy263;
		goto yy56;
	} else {
		if (yych <= '4') goto yy295;
		if (yych <= '9') goto yy292;
		if (yych <= ':') goto yy263;
		goto yy56;
	}
yy209:
	YYDEBUG(209, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy263;
		goto yy56;
	} else {
		if (yych <= '9') goto yy292;
		if (yych <= ':') goto yy263;
		goto yy56;
	}
yy210:
	YYDEBUG(210, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy215;
yy211:
	YYDEBUG(211, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy215;
yy212:
	YYDEBUG(212, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy215;
yy213:
	YYDEBUG(213, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy215;
yy214:
	YYDEBUG(214, *YYCURSOR);
	yyaccept = 6;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 18) YYFILL(18);
	yych = *YYCURSOR;
yy215:
	YYDEBUG(215, *YYCURSOR);
	if (yybm[0+yych] & 64) {
		goto yy214;
	}
	if (yych <= '2') {
		if (yych <= '/') goto yy198;
		if (yych <= '0') goto yy258;
		if (yych <= '1') goto yy259;
		goto yy260;
	} else {
		if (yych <= '9') goto yy261;
		if (yych != 'T') goto yy198;
	}
	YYDEBUG(216, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy217;
	if (yych <= '2') goto yy218;
	if (yych <= '9') goto yy219;
	goto yy56;
yy217:
	YYDEBUG(217, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy220;
		goto yy56;
	} else {
		if (yych <= '9') goto yy219;
		if (yych <= ':') goto yy220;
		goto yy56;
	}
yy218:
	YYDEBUG(218, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy220;
		goto yy56;
	} else {
		if (yych <= '4') goto yy219;
		if (yych == ':') goto yy220;
		goto yy56;
	}
yy219:
	YYDEBUG(219, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy220;
	if (yych != ':') goto yy56;
yy220:
	YYDEBUG(220, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy221;
	if (yych <= '9') goto yy223;
	goto yy56;
yy221:
	YYDEBUG(221, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy224;
	} else {
		if (yych <= '9') goto yy223;
		if (yych <= ':') goto yy224;
	}
yy222:
	YYDEBUG(222, *YYCURSOR);
#line 1658 "parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
#line 4438 "parse_date.c"
yy223:
	YYDEBUG(223, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy224;
	if (yych != ':') goto yy222;
yy224:
	YYDEBUG(224, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy225;
	if (yych <= '6') goto yy226;
	if (yych <= '9') goto yy227;
	goto yy56;
yy225:
	YYDEBUG(225, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy222;
	if (yych <= '9') goto yy228;
	goto yy222;
yy226:
	YYDEBUG(226, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy228;
	goto yy222;
yy227:
	YYDEBUG(227, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy222;
yy228:
	YYDEBUG(228, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy230;
			goto yy222;
		} else {
			if (yych <= ' ') goto yy230;
			if (yych == '(') goto yy230;
			goto yy222;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy222;
			if (yych <= '-') goto yy230;
			goto yy222;
		} else {
			if (yych <= 'Z') goto yy230;
			if (yych <= '`') goto yy222;
			if (yych <= 'z') goto yy230;
			goto yy222;
		}
	}
yy229:
	YYDEBUG(229, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy230:
	YYDEBUG(230, *YYCURSOR);
	if (yych <= '+') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy229;
			if (yych <= 0x1F) goto yy56;
			goto yy229;
		} else {
			if (yych == '(') goto yy233;
			if (yych <= '*') goto yy56;
			goto yy232;
		}
	} else {
		if (yych <= 'F') {
			if (yych == '-') goto yy232;
			if (yych <= '@') goto yy56;
			goto yy234;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'H') goto yy234;
			} else {
				if (yych <= '`') goto yy56;
				if (yych <= 'z') goto yy235;
				goto yy56;
			}
		}
	}
yy231:
	YYDEBUG(231, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy227;
		if (yych <= '@') goto yy222;
		goto yy236;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy256;
			goto yy236;
		} else {
			if (yych <= '`') goto yy222;
			if (yych <= 'z') goto yy241;
			goto yy222;
		}
	}
yy232:
	YYDEBUG(232, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy251;
	if (yych <= '2') goto yy252;
	if (yych <= '9') goto yy253;
	goto yy56;
yy233:
	YYDEBUG(233, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy56;
	if (yych <= 'Z') goto yy235;
	if (yych <= '`') goto yy56;
	if (yych <= 'z') goto yy235;
	goto yy56;
yy234:
	YYDEBUG(234, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy227;
		goto yy222;
	} else {
		if (yych <= 'Z') goto yy236;
		if (yych <= '`') goto yy222;
		if (yych <= 'z') goto yy241;
		goto yy222;
	}
yy235:
	YYDEBUG(235, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy227;
		goto yy222;
	} else {
		if (yych <= 'Z') goto yy236;
		if (yych <= '`') goto yy222;
		if (yych >= '{') goto yy222;
	}
yy236:
	YYDEBUG(236, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy227;
		goto yy222;
	} else {
		if (yych <= 'Z') goto yy237;
		if (yych <= '`') goto yy222;
		if (yych >= '{') goto yy222;
	}
yy237:
	YYDEBUG(237, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy227;
		goto yy222;
	} else {
		if (yych <= 'Z') goto yy238;
		if (yych <= '`') goto yy222;
		if (yych >= '{') goto yy222;
	}
yy238:
	YYDEBUG(238, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy227;
		goto yy222;
	} else {
		if (yych <= 'Z') goto yy239;
		if (yych <= '`') goto yy222;
		if (yych >= '{') goto yy222;
	}
yy239:
	YYDEBUG(239, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy227;
		goto yy222;
	} else {
		if (yych <= 'Z') goto yy240;
		if (yych <= '`') goto yy222;
		if (yych >= '{') goto yy222;
	}
yy240:
	YYDEBUG(240, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy227;
	goto yy222;
yy241:
	YYDEBUG(241, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy227;
			goto yy222;
		} else {
			if (yych == '.') goto yy222;
			goto yy243;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy222;
			if (yych <= 'Z') goto yy237;
			goto yy222;
		} else {
			if (yych <= '_') goto yy243;
			if (yych <= '`') goto yy222;
			if (yych >= '{') goto yy222;
		}
	}
yy242:
	YYDEBUG(242, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy227;
			goto yy222;
		} else {
			if (yych == '.') goto yy222;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy222;
			if (yych <= 'Z') goto yy238;
			goto yy222;
		} else {
			if (yych <= '_') goto yy243;
			if (yych <= '`') goto yy222;
			if (yych <= 'z') goto yy246;
			goto yy222;
		}
	}
yy243:
	YYDEBUG(243, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') goto yy56;
	if (yych <= 'Z') goto yy244;
	if (yych <= '`') goto yy56;
	if (yych >= '{') goto yy56;
yy244:
	YYDEBUG(244, *YYCURSOR);
	yyaccept = 7;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(245, *YYCURSOR);
	if (yych <= '@') {
		if (yych <= '-') {
			if (yych <= ',') goto yy222;
			goto yy243;
		} else {
			if (yych == '/') goto yy243;
			goto yy222;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy244;
			if (yych <= '^') goto yy222;
			goto yy243;
		} else {
			if (yych <= '`') goto yy222;
			if (yych <= 'z') goto yy244;
			goto yy222;
		}
	}
yy246:
	YYDEBUG(246, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy227;
			goto yy222;
		} else {
			if (yych == '.') goto yy222;
			goto yy243;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy222;
			if (yych <= 'Z') goto yy239;
			goto yy222;
		} else {
			if (yych <= '_') goto yy243;
			if (yych <= '`') goto yy222;
			if (yych >= '{') goto yy222;
		}
	}
	YYDEBUG(247, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy227;
			goto yy222;
		} else {
			if (yych == '.') goto yy222;
			goto yy243;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy222;
			if (yych <= 'Z') goto yy240;
			goto yy222;
		} else {
			if (yych <= '_') goto yy243;
			if (yych <= '`') goto yy222;
			if (yych >= '{') goto yy222;
		}
	}
	YYDEBUG(248, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ')') {
			if (yych <= '(') goto yy222;
			goto yy227;
		} else {
			if (yych == '-') goto yy243;
			goto yy222;
		}
	} else {
		if (yych <= '_') {
			if (yych <= '/') goto yy243;
			if (yych <= '^') goto yy222;
			goto yy243;
		} else {
			if (yych <= '`') goto yy222;
			if (yych >= '{') goto yy222;
		}
	}
yy249:
	YYDEBUG(249, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(250, *YYCURSOR);
	if (yych <= '/') {
		if (yych == '-') goto yy243;
		if (yych <= '.') goto yy56;
		goto yy243;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy56;
			goto yy243;
		} else {
			if (yych <= '`') goto yy56;
			if (yych <= 'z') goto yy249;
			goto yy56;
		}
	}
yy251:
	YYDEBUG(251, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy222;
	if (yych <= '9') goto yy253;
	if (yych <= ':') goto yy254;
	goto yy222;
yy252:
	YYDEBUG(252, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy222;
		if (yych >= '5') goto yy255;
	} else {
		if (yych <= '9') goto yy227;
		if (yych <= ':') goto yy254;
		goto yy222;
	}
yy253:
	YYDEBUG(253, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy222;
	if (yych <= '5') goto yy255;
	if (yych <= '9') goto yy227;
	if (yych >= ';') goto yy222;
yy254:
	YYDEBUG(254, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy222;
	if (yych <= '5') goto yy255;
	if (yych <= '9') goto yy227;
	goto yy222;
yy255:
	YYDEBUG(255, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy222;
	if (yych <= '9') goto yy227;
	goto yy222;
yy256:
	YYDEBUG(256, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy227;
		if (yych <= '@') goto yy222;
		goto yy237;
	} else {
		if (yych <= 'Z') {
			if (yych >= 'U') goto yy237;
		} else {
			if (yych <= '`') goto yy222;
			if (yych <= 'z') goto yy237;
			goto yy222;
		}
	}
	YYDEBUG(257, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy222;
			goto yy227;
		} else {
			if (yych == '+') goto yy232;
			goto yy222;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy232;
			if (yych <= '@') goto yy222;
			goto yy238;
		} else {
			if (yych <= '`') goto yy222;
			if (yych <= 'z') goto yy238;
			goto yy222;
		}
	}
yy258:
	YYDEBUG(258, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy220;
		goto yy198;
	} else {
		if (yych <= '0') goto yy290;
		if (yych <= '9') goto yy291;
		if (yych <= ':') goto yy220;
		goto yy198;
	}
yy259:
	YYDEBUG(259, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy263;
		goto yy198;
	} else {
		if (yych <= '2') goto yy291;
		if (yych <= '9') goto yy290;
		if (yych <= ':') goto yy263;
		goto yy198;
	}
yy260:
	YYDEBUG(260, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy263;
		goto yy198;
	} else {
		if (yych <= '4') goto yy290;
		if (yych <= '9') goto yy262;
		if (yych <= ':') goto yy263;
		goto yy198;
	}
yy261:
	YYDEBUG(261, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy263;
		goto yy198;
	} else {
		if (yych <= '9') goto yy262;
		if (yych <= ':') goto yy263;
		goto yy198;
	}
yy262:
	YYDEBUG(262, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy198;
	if (yych <= '9') goto yy288;
	goto yy198;
yy263:
	YYDEBUG(263, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy264;
	if (yych <= '9') goto yy265;
	goto yy56;
yy264:
	YYDEBUG(264, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy266;
		goto yy222;
	} else {
		if (yych <= '9') goto yy281;
		if (yych <= ':') goto yy266;
		goto yy222;
	}
yy265:
	YYDEBUG(265, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy266;
	if (yych != ':') goto yy222;
yy266:
	YYDEBUG(266, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy267;
	if (yych <= '6') goto yy268;
	if (yych <= '9') goto yy227;
	goto yy56;
yy267:
	YYDEBUG(267, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy222;
	if (yych <= '9') goto yy269;
	goto yy222;
yy268:
	YYDEBUG(268, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy222;
yy269:
	YYDEBUG(269, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy271;
			goto yy222;
		} else {
			if (yych <= ' ') goto yy271;
			if (yych == '(') goto yy271;
			goto yy222;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy222;
			if (yych <= '-') goto yy271;
			goto yy222;
		} else {
			if (yych <= 'Z') goto yy271;
			if (yych <= '`') goto yy222;
			if (yych <= 'z') goto yy271;
			goto yy222;
		}
	}
yy270:
	YYDEBUG(270, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy271:
	YYDEBUG(271, *YYCURSOR);
	if (yych <= '@') {
		if (yych <= '\'') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy56;
				goto yy270;
			} else {
				if (yych == ' ') goto yy270;
				goto yy56;
			}
		} else {
			if (yych <= '+') {
				if (yych <= '(') goto yy233;
				if (yych <= '*') goto yy56;
				goto yy232;
			} else {
				if (yych == '-') goto yy232;
				goto yy56;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'G') {
				if (yych <= 'A') goto yy272;
				if (yych <= 'F') goto yy234;
				goto yy231;
			} else {
				if (yych != 'P') goto yy234;
			}
		} else {
			if (yych <= 'o') {
				if (yych <= '`') goto yy56;
				if (yych <= 'a') goto yy273;
				goto yy235;
			} else {
				if (yych <= 'p') goto yy273;
				if (yych <= 'z') goto yy235;
				goto yy56;
			}
		}
	}
yy272:
	YYDEBUG(272, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy227;
			goto yy222;
		} else {
			if (yych <= '.') goto yy274;
			if (yych <= '@') goto yy222;
			goto yy236;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy275;
			if (yych <= 'Z') goto yy236;
			goto yy222;
		} else {
			if (yych == 'm') goto yy280;
			if (yych <= 'z') goto yy241;
			goto yy222;
		}
	}
yy273:
	YYDEBUG(273, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy227;
			goto yy222;
		} else {
			if (yych <= '.') goto yy274;
			if (yych <= '@') goto yy222;
			goto yy236;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy275;
			if (yych <= 'Z') goto yy236;
			goto yy222;
		} else {
			if (yych == 'm') goto yy275;
			if (yych <= 'z') goto yy236;
			goto yy222;
		}
	}
yy274:
	YYDEBUG(274, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy279;
	if (yych == 'm') goto yy279;
	goto yy56;
yy275:
	YYDEBUG(275, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy277;
			if (yych <= 0x08) goto yy222;
			goto yy277;
		} else {
			if (yych == ' ') goto yy277;
			if (yych <= '(') goto yy222;
			goto yy227;
		}
	} else {
		if (yych <= '@') {
			if (yych != '.') goto yy222;
		} else {
			if (yych <= 'Z') goto yy237;
			if (yych <= '`') goto yy222;
			if (yych <= 'z') goto yy237;
			goto yy222;
		}
	}
yy276:
	YYDEBUG(276, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy277;
		if (yych <= 0x08) goto yy56;
	} else {
		if (yych != ' ') goto yy56;
	}
yy277:
	YYDEBUG(277, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(278, *YYCURSOR);
#line 1634 "parse_date.re"
	{
		DEBUG_OUTPUT("dateshortwithtimeshort12 | dateshortwithtimelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
#line 5159 "parse_date.c"
yy279:
	YYDEBUG(279, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy277;
		if (yych == '\t') goto yy277;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy277;
		if (yych == '.') goto yy276;
		goto yy56;
	}
yy280:
	YYDEBUG(280, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych <= 0x00) goto yy277;
			if (yych == '\t') goto yy277;
			goto yy222;
		} else {
			if (yych <= '(') {
				if (yych <= ' ') goto yy277;
				goto yy222;
			} else {
				if (yych <= ')') goto yy227;
				if (yych <= ',') goto yy222;
				goto yy243;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '.') goto yy276;
			if (yych <= '/') goto yy243;
			if (yych <= '@') goto yy222;
			goto yy237;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy222;
				goto yy243;
			} else {
				if (yych <= '`') goto yy222;
				if (yych <= 'z') goto yy242;
				goto yy222;
			}
		}
	}
yy281:
	YYDEBUG(281, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy282;
			if (yych <= 0x1F) goto yy222;
		} else {
			if (yych == '.') goto yy266;
			if (yych <= '9') goto yy222;
			goto yy266;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy284;
			if (yych <= 'O') goto yy222;
			goto yy284;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy222;
				goto yy284;
			} else {
				if (yych == 'p') goto yy284;
				goto yy222;
			}
		}
	}
yy282:
	YYDEBUG(282, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(283, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy282;
			goto yy56;
		} else {
			if (yych <= ' ') goto yy282;
			if (yych <= '@') goto yy56;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy56;
		} else {
			if (yych <= 'a') goto yy284;
			if (yych != 'p') goto yy56;
		}
	}
yy284:
	YYDEBUG(284, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy286;
		if (yych == 'm') goto yy286;
		goto yy56;
	}
yy285:
	YYDEBUG(285, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy286;
	if (yych != 'm') goto yy56;
yy286:
	YYDEBUG(286, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy277;
		if (yych == '\t') goto yy277;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy277;
		if (yych != '.') goto yy56;
	}
yy287:
	YYDEBUG(287, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy277;
		if (yych <= 0x08) goto yy56;
		goto yy277;
	} else {
		if (yych == ' ') goto yy277;
		goto yy56;
	}
yy288:
	YYDEBUG(288, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy198;
	if (yych >= ':') goto yy198;
	YYDEBUG(289, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy198;
yy290:
	YYDEBUG(290, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy220;
		goto yy198;
	} else {
		if (yych <= '9') goto yy288;
		if (yych <= ':') goto yy220;
		goto yy198;
	}
yy291:
	YYDEBUG(291, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy263;
		goto yy198;
	} else {
		if (yych <= '9') goto yy288;
		if (yych <= ':') goto yy263;
		goto yy198;
	}
yy292:
	YYDEBUG(292, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy293:
	YYDEBUG(293, *YYCURSOR);
	++YYCURSOR;
yy294:
	YYDEBUG(294, *YYCURSOR);
#line 1328 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 5350 "parse_date.c"
yy295:
	YYDEBUG(295, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy220;
		goto yy56;
	} else {
		if (yych <= '9') goto yy293;
		if (yych <= ':') goto yy220;
		goto yy56;
	}
yy296:
	YYDEBUG(296, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy263;
		goto yy56;
	} else {
		if (yych <= '9') goto yy293;
		if (yych <= ':') goto yy263;
		goto yy56;
	}
yy297:
	YYDEBUG(297, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych == '.') goto yy330;
			goto yy215;
		} else {
			if (yych <= '0') goto yy331;
			if (yych <= '1') goto yy301;
			if (yych <= '2') goto yy302;
			goto yy296;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy220;
			if (yych == 'n') goto yy211;
			goto yy215;
		} else {
			if (yych <= 'r') goto yy212;
			if (yych <= 's') goto yy210;
			if (yych <= 't') goto yy213;
			goto yy215;
		}
	}
yy298:
	YYDEBUG(298, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych != '.') goto yy215;
		} else {
			if (yych <= '0') goto yy300;
			if (yych <= '1') goto yy301;
			if (yych <= '2') goto yy302;
			goto yy296;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy263;
			if (yych == 'n') goto yy211;
			goto yy215;
		} else {
			if (yych <= 'r') goto yy212;
			if (yych <= 's') goto yy210;
			if (yych <= 't') goto yy213;
			goto yy215;
		}
	}
yy299:
	YYDEBUG(299, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '1') {
		if (yych <= '/') goto yy215;
		if (yych <= '0') goto yy305;
		goto yy306;
	} else {
		if (yych <= '2') goto yy307;
		if (yych <= '5') goto yy308;
		if (yych <= '9') goto yy309;
		goto yy215;
	}
yy300:
	YYDEBUG(300, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy263;
		goto yy56;
	} else {
		if (yych <= '0') goto yy303;
		if (yych <= '9') goto yy304;
		if (yych <= ':') goto yy263;
		goto yy56;
	}
yy301:
	YYDEBUG(301, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy263;
		goto yy56;
	} else {
		if (yych <= '2') goto yy304;
		if (yych <= '9') goto yy303;
		if (yych <= ':') goto yy263;
		goto yy56;
	}
yy302:
	YYDEBUG(302, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy263;
		goto yy56;
	} else {
		if (yych <= '4') goto yy303;
		if (yych <= '9') goto yy293;
		if (yych <= ':') goto yy263;
		goto yy56;
	}
yy303:
	YYDEBUG(303, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy220;
	if (yych == ':') goto yy220;
	goto yy294;
yy304:
	YYDEBUG(304, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy263;
	if (yych == ':') goto yy263;
	goto yy294;
yy305:
	YYDEBUG(305, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy325;
		goto yy198;
	} else {
		if (yych <= '0') goto yy324;
		if (yych <= '9') goto yy329;
		if (yych <= ':') goto yy325;
		goto yy198;
	}
yy306:
	YYDEBUG(306, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy310;
		goto yy198;
	} else {
		if (yych <= '2') goto yy329;
		if (yych <= '9') goto yy324;
		if (yych <= ':') goto yy310;
		goto yy198;
	}
yy307:
	YYDEBUG(307, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy310;
		goto yy198;
	} else {
		if (yych <= '4') goto yy324;
		if (yych <= '9') goto yy323;
		if (yych <= ':') goto yy310;
		goto yy198;
	}
yy308:
	YYDEBUG(308, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy310;
		goto yy198;
	} else {
		if (yych <= '9') goto yy323;
		if (yych <= ':') goto yy310;
		goto yy198;
	}
yy309:
	YYDEBUG(309, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych != '.') goto yy198;
	} else {
		if (yych <= '9') goto yy262;
		if (yych >= ';') goto yy198;
	}
yy310:
	YYDEBUG(310, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy311;
	if (yych <= '6') goto yy312;
	if (yych <= '9') goto yy265;
	goto yy56;
yy311:
	YYDEBUG(311, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy266;
		goto yy222;
	} else {
		if (yych <= '9') goto yy313;
		if (yych <= ':') goto yy266;
		goto yy222;
	}
yy312:
	YYDEBUG(312, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy266;
		goto yy222;
	} else {
		if (yych <= '0') goto yy269;
		if (yych == ':') goto yy266;
		goto yy222;
	}
yy313:
	YYDEBUG(313, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy315;
			if (yych <= 0x1F) goto yy222;
			goto yy315;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy222;
				goto yy315;
			} else {
				if (yych == '+') goto yy315;
				goto yy222;
			}
		}
	} else {
		if (yych <= ':') {
			if (yych <= '-') goto yy315;
			if (yych <= '.') goto yy266;
			if (yych <= '9') goto yy222;
			goto yy266;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy222;
				goto yy315;
			} else {
				if (yych <= '`') goto yy222;
				if (yych <= 'z') goto yy315;
				goto yy222;
			}
		}
	}
yy314:
	YYDEBUG(314, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy315:
	YYDEBUG(315, *YYCURSOR);
	if (yych <= '@') {
		if (yych <= '\'') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy56;
				goto yy314;
			} else {
				if (yych == ' ') goto yy314;
				goto yy56;
			}
		} else {
			if (yych <= '+') {
				if (yych <= '(') goto yy233;
				if (yych <= '*') goto yy56;
				goto yy232;
			} else {
				if (yych == '-') goto yy232;
				goto yy56;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'G') {
				if (yych <= 'A') goto yy316;
				if (yych <= 'F') goto yy234;
				goto yy231;
			} else {
				if (yych != 'P') goto yy234;
			}
		} else {
			if (yych <= 'o') {
				if (yych <= '`') goto yy56;
				if (yych <= 'a') goto yy317;
				goto yy235;
			} else {
				if (yych <= 'p') goto yy317;
				if (yych <= 'z') goto yy235;
				goto yy56;
			}
		}
	}
yy316:
	YYDEBUG(316, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy227;
			goto yy222;
		} else {
			if (yych <= '.') goto yy319;
			if (yych <= '@') goto yy222;
			goto yy236;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy318;
			if (yych <= 'Z') goto yy236;
			goto yy222;
		} else {
			if (yych == 'm') goto yy322;
			if (yych <= 'z') goto yy241;
			goto yy222;
		}
	}
yy317:
	YYDEBUG(317, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy227;
			goto yy222;
		} else {
			if (yych <= '.') goto yy319;
			if (yych <= '@') goto yy222;
			goto yy236;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy318;
			if (yych <= 'Z') goto yy236;
			goto yy222;
		} else {
			if (yych == 'm') goto yy318;
			if (yych <= 'z') goto yy236;
			goto yy222;
		}
	}
yy318:
	YYDEBUG(318, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy277;
			if (yych <= 0x08) goto yy222;
			goto yy277;
		} else {
			if (yych == ' ') goto yy277;
			if (yych <= '(') goto yy222;
			goto yy227;
		}
	} else {
		if (yych <= '@') {
			if (yych == '.') goto yy321;
			goto yy222;
		} else {
			if (yych <= 'Z') goto yy237;
			if (yych <= '`') goto yy222;
			if (yych <= 'z') goto yy237;
			goto yy222;
		}
	}
yy319:
	YYDEBUG(319, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy320;
	if (yych != 'm') goto yy56;
yy320:
	YYDEBUG(320, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy277;
		if (yych == '\t') goto yy277;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy277;
		if (yych != '.') goto yy56;
	}
yy321:
	YYDEBUG(321, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy277;
		if (yych <= 0x08) goto yy56;
		goto yy277;
	} else {
		if (yych == ' ') goto yy277;
		goto yy56;
	}
yy322:
	YYDEBUG(322, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych <= 0x00) goto yy277;
			if (yych == '\t') goto yy277;
			goto yy222;
		} else {
			if (yych <= '(') {
				if (yych <= ' ') goto yy277;
				goto yy222;
			} else {
				if (yych <= ')') goto yy227;
				if (yych <= ',') goto yy222;
				goto yy243;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '.') goto yy321;
			if (yych <= '/') goto yy243;
			if (yych <= '@') goto yy222;
			goto yy237;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy222;
				goto yy243;
			} else {
				if (yych <= '`') goto yy222;
				if (yych <= 'z') goto yy242;
				goto yy222;
			}
		}
	}
yy323:
	YYDEBUG(323, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy282;
			if (yych <= 0x1F) goto yy198;
			goto yy282;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy198;
				goto yy266;
			} else {
				if (yych <= '/') goto yy198;
				if (yych <= '9') goto yy288;
				goto yy266;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy284;
			if (yych <= 'O') goto yy198;
			goto yy284;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy198;
				goto yy284;
			} else {
				if (yych == 'p') goto yy284;
				goto yy198;
			}
		}
	}
yy324:
	YYDEBUG(324, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy282;
			if (yych <= 0x1F) goto yy198;
			goto yy282;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy198;
			} else {
				if (yych <= '/') goto yy198;
				if (yych <= '9') goto yy288;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy284;
			if (yych <= 'O') goto yy198;
			goto yy284;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy198;
				goto yy284;
			} else {
				if (yych == 'p') goto yy284;
				goto yy198;
			}
		}
	}
yy325:
	YYDEBUG(325, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy326;
	if (yych <= '6') goto yy327;
	if (yych <= '9') goto yy223;
	goto yy56;
yy326:
	YYDEBUG(326, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy224;
		goto yy222;
	} else {
		if (yych <= '9') goto yy328;
		if (yych <= ':') goto yy224;
		goto yy222;
	}
yy327:
	YYDEBUG(327, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy224;
		goto yy222;
	} else {
		if (yych <= '0') goto yy269;
		if (yych == ':') goto yy224;
		goto yy222;
	}
yy328:
	YYDEBUG(328, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy271;
			if (yych <= 0x1F) goto yy222;
			goto yy271;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy222;
				goto yy271;
			} else {
				if (yych == '+') goto yy271;
				goto yy222;
			}
		}
	} else {
		if (yych <= ':') {
			if (yych <= '-') goto yy271;
			if (yych <= '.') goto yy224;
			if (yych <= '9') goto yy222;
			goto yy224;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy222;
				goto yy271;
			} else {
				if (yych <= '`') goto yy222;
				if (yych <= 'z') goto yy271;
				goto yy222;
			}
		}
	}
yy329:
	YYDEBUG(329, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy282;
			if (yych <= 0x1F) goto yy198;
			goto yy282;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy198;
				goto yy310;
			} else {
				if (yych <= '/') goto yy198;
				if (yych <= '9') goto yy288;
				goto yy310;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy284;
			if (yych <= 'O') goto yy198;
			goto yy284;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy198;
				goto yy284;
			} else {
				if (yych == 'p') goto yy284;
				goto yy198;
			}
		}
	}
yy330:
	YYDEBUG(330, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '1') {
		if (yych <= '/') goto yy215;
		if (yych <= '0') goto yy332;
		goto yy333;
	} else {
		if (yych <= '2') goto yy334;
		if (yych <= '5') goto yy335;
		if (yych <= '9') goto yy336;
		goto yy215;
	}
yy331:
	YYDEBUG(331, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy220;
		goto yy56;
	} else {
		if (yych <= '0') goto yy303;
		if (yych <= '9') goto yy304;
		if (yych <= ':') goto yy220;
		goto yy56;
	}
yy332:
	YYDEBUG(332, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy349;
		goto yy198;
	} else {
		if (yych <= '0') goto yy348;
		if (yych <= '9') goto yy353;
		if (yych <= ':') goto yy349;
		goto yy198;
	}
yy333:
	YYDEBUG(333, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy337;
		goto yy198;
	} else {
		if (yych <= '2') goto yy353;
		if (yych <= '9') goto yy348;
		if (yych <= ':') goto yy337;
		goto yy198;
	}
yy334:
	YYDEBUG(334, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy337;
		goto yy198;
	} else {
		if (yych <= '4') goto yy348;
		if (yych <= '9') goto yy347;
		if (yych <= ':') goto yy337;
		goto yy198;
	}
yy335:
	YYDEBUG(335, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy337;
		goto yy198;
	} else {
		if (yych <= '9') goto yy347;
		if (yych <= ':') goto yy337;
		goto yy198;
	}
yy336:
	YYDEBUG(336, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych != '.') goto yy198;
	} else {
		if (yych <= '9') goto yy262;
		if (yych >= ';') goto yy198;
	}
yy337:
	YYDEBUG(337, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy338;
	if (yych <= '6') goto yy339;
	if (yych <= '9') goto yy265;
	goto yy56;
yy338:
	YYDEBUG(338, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy266;
		goto yy222;
	} else {
		if (yych <= '9') goto yy340;
		if (yych <= ':') goto yy266;
		goto yy222;
	}
yy339:
	YYDEBUG(339, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy266;
		goto yy222;
	} else {
		if (yych <= '0') goto yy228;
		if (yych == ':') goto yy266;
		goto yy222;
	}
yy340:
	YYDEBUG(340, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy342;
			if (yych <= 0x1F) goto yy222;
			goto yy342;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy222;
				goto yy342;
			} else {
				if (yych == '+') goto yy342;
				goto yy222;
			}
		}
	} else {
		if (yych <= ':') {
			if (yych <= '-') goto yy342;
			if (yych <= '.') goto yy266;
			if (yych <= '9') goto yy222;
			goto yy266;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy222;
				goto yy342;
			} else {
				if (yych <= '`') goto yy222;
				if (yych <= 'z') goto yy342;
				goto yy222;
			}
		}
	}
yy341:
	YYDEBUG(341, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy342:
	YYDEBUG(342, *YYCURSOR);
	if (yych <= '@') {
		if (yych <= '\'') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy56;
				goto yy341;
			} else {
				if (yych == ' ') goto yy341;
				goto yy56;
			}
		} else {
			if (yych <= '+') {
				if (yych <= '(') goto yy233;
				if (yych <= '*') goto yy56;
				goto yy232;
			} else {
				if (yych == '-') goto yy232;
				goto yy56;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'G') {
				if (yych <= 'A') goto yy343;
				if (yych <= 'F') goto yy234;
				goto yy231;
			} else {
				if (yych != 'P') goto yy234;
			}
		} else {
			if (yych <= 'o') {
				if (yych <= '`') goto yy56;
				if (yych <= 'a') goto yy344;
				goto yy235;
			} else {
				if (yych <= 'p') goto yy344;
				if (yych <= 'z') goto yy235;
				goto yy56;
			}
		}
	}
yy343:
	YYDEBUG(343, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy227;
			goto yy222;
		} else {
			if (yych <= '.') goto yy285;
			if (yych <= '@') goto yy222;
			goto yy236;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy345;
			if (yych <= 'Z') goto yy236;
			goto yy222;
		} else {
			if (yych == 'm') goto yy346;
			if (yych <= 'z') goto yy241;
			goto yy222;
		}
	}
yy344:
	YYDEBUG(344, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy227;
			goto yy222;
		} else {
			if (yych <= '.') goto yy285;
			if (yych <= '@') goto yy222;
			goto yy236;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy345;
			if (yych <= 'Z') goto yy236;
			goto yy222;
		} else {
			if (yych == 'm') goto yy345;
			if (yych <= 'z') goto yy236;
			goto yy222;
		}
	}
yy345:
	YYDEBUG(345, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy277;
			if (yych <= 0x08) goto yy222;
			goto yy277;
		} else {
			if (yych == ' ') goto yy277;
			if (yych <= '(') goto yy222;
			goto yy227;
		}
	} else {
		if (yych <= '@') {
			if (yych == '.') goto yy287;
			goto yy222;
		} else {
			if (yych <= 'Z') goto yy237;
			if (yych <= '`') goto yy222;
			if (yych <= 'z') goto yy237;
			goto yy222;
		}
	}
yy346:
	YYDEBUG(346, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych <= 0x00) goto yy277;
			if (yych == '\t') goto yy277;
			goto yy222;
		} else {
			if (yych <= '(') {
				if (yych <= ' ') goto yy277;
				goto yy222;
			} else {
				if (yych <= ')') goto yy227;
				if (yych <= ',') goto yy222;
				goto yy243;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '.') goto yy287;
			if (yych <= '/') goto yy243;
			if (yych <= '@') goto yy222;
			goto yy237;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy222;
				goto yy243;
			} else {
				if (yych <= '`') goto yy222;
				if (yych <= 'z') goto yy242;
				goto yy222;
			}
		}
	}
yy347:
	YYDEBUG(347, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy224;
		goto yy198;
	} else {
		if (yych <= '9') goto yy288;
		if (yych <= ':') goto yy224;
		goto yy198;
	}
yy348:
	YYDEBUG(348, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych != '.') goto yy198;
	} else {
		if (yych <= '9') goto yy288;
		if (yych >= ';') goto yy198;
	}
yy349:
	YYDEBUG(349, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy350;
	if (yych <= '6') goto yy351;
	if (yych <= '9') goto yy223;
	goto yy56;
yy350:
	YYDEBUG(350, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy224;
		goto yy222;
	} else {
		if (yych <= '9') goto yy352;
		if (yych <= ':') goto yy224;
		goto yy222;
	}
yy351:
	YYDEBUG(351, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy224;
		goto yy222;
	} else {
		if (yych <= '0') goto yy228;
		if (yych == ':') goto yy224;
		goto yy222;
	}
yy352:
	YYDEBUG(352, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy230;
			if (yych <= 0x1F) goto yy222;
			goto yy230;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy222;
				goto yy230;
			} else {
				if (yych == '+') goto yy230;
				goto yy222;
			}
		}
	} else {
		if (yych <= ':') {
			if (yych <= '-') goto yy230;
			if (yych <= '.') goto yy224;
			if (yych <= '9') goto yy222;
			goto yy224;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy222;
				goto yy230;
			} else {
				if (yych <= '`') goto yy222;
				if (yych <= 'z') goto yy230;
				goto yy222;
			}
		}
	}
yy353:
	YYDEBUG(353, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy337;
		goto yy198;
	} else {
		if (yych <= '9') goto yy288;
		if (yych <= ':') goto yy337;
		goto yy198;
	}
yy354:
	YYDEBUG(354, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych == '.') goto yy299;
			goto yy215;
		} else {
			if (yych <= '0') goto yy331;
			if (yych <= '1') goto yy301;
			if (yych <= '2') goto yy302;
			goto yy296;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy263;
			if (yych == 'n') goto yy211;
			goto yy215;
		} else {
			if (yych <= 'r') goto yy212;
			if (yych <= 's') goto yy210;
			if (yych <= 't') goto yy213;
			goto yy215;
		}
	}
yy355:
	YYDEBUG(355, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych == '.') goto yy299;
			goto yy215;
		} else {
			if (yych <= '0') goto yy331;
			if (yych <= '1') goto yy301;
			if (yych <= '2') goto yy302;
			goto yy296;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy263;
			if (yych == 'n') goto yy211;
			goto yy215;
		} else {
			if (yych <= 'r') goto yy212;
			if (yych <= 's') goto yy210;
			if (yych <= 't') goto yy213;
			goto yy215;
		}
	}
yy356:
	YYDEBUG(356, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy215;
			if (yych <= '0') goto yy359;
			goto yy360;
		} else {
			if (yych <= '2') goto yy367;
			if (yych <= '9') goto yy368;
			goto yy215;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy211;
			if (yych <= 'q') goto yy215;
			goto yy212;
		} else {
			if (yych <= 's') goto yy210;
			if (yych <= 't') goto yy213;
			goto yy215;
		}
	}
yy357:
	YYDEBUG(357, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy215;
			if (yych <= '0') goto yy359;
			goto yy360;
		} else {
			if (yych <= '2') goto yy367;
			if (yych <= '9') goto yy368;
			goto yy215;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy211;
			if (yych <= 'q') goto yy215;
			goto yy212;
		} else {
			if (yych <= 's') goto yy210;
			if (yych <= 't') goto yy213;
			goto yy215;
		}
	}
yy358:
	YYDEBUG(358, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy215;
			if (yych >= '1') goto yy360;
		} else {
			if (yych <= '2') goto yy208;
			if (yych <= '9') goto yy209;
			goto yy215;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy211;
			if (yych <= 'q') goto yy215;
			goto yy212;
		} else {
			if (yych <= 's') goto yy210;
			if (yych <= 't') goto yy213;
			goto yy215;
		}
	}
yy359:
	YYDEBUG(359, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych <= ',') goto yy215;
			if (yych <= '-') goto yy361;
			if (yych <= '.') goto yy330;
			goto yy215;
		} else {
			if (yych <= '0') goto yy331;
			if (yych <= '1') goto yy301;
			if (yych <= '2') goto yy302;
			goto yy296;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy220;
			if (yych == 'n') goto yy211;
			goto yy215;
		} else {
			if (yych <= 'r') goto yy212;
			if (yych <= 's') goto yy210;
			if (yych <= 't') goto yy213;
			goto yy215;
		}
	}
yy360:
	YYDEBUG(360, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych <= ',') goto yy215;
			if (yych <= '-') goto yy361;
			if (yych <= '.') goto yy299;
			goto yy215;
		} else {
			if (yych <= '0') goto yy300;
			if (yych <= '1') goto yy301;
			if (yych <= '2') goto yy302;
			goto yy296;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy263;
			if (yych == 'n') goto yy211;
			goto yy215;
		} else {
			if (yych <= 'r') goto yy212;
			if (yych <= 's') goto yy210;
			if (yych <= 't') goto yy213;
			goto yy215;
		}
	}
yy361:
	YYDEBUG(361, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(362, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy363;
	if (yych <= '9') goto yy364;
yy363:
	YYDEBUG(363, *YYCURSOR);
#line 1472 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 6583 "parse_date.c"
yy364:
	YYDEBUG(364, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy363;
	if (yych >= ':') goto yy363;
	YYDEBUG(365, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy363;
	if (yych >= ':') goto yy363;
	YYDEBUG(366, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy363;
yy367:
	YYDEBUG(367, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych <= ',') goto yy215;
			if (yych <= '-') goto yy361;
			if (yych <= '.') goto yy299;
			goto yy215;
		} else {
			if (yych <= '0') goto yy331;
			if (yych <= '1') goto yy301;
			if (yych <= '2') goto yy302;
			goto yy296;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy263;
			if (yych == 'n') goto yy211;
			goto yy215;
		} else {
			if (yych <= 'r') goto yy212;
			if (yych <= 's') goto yy210;
			if (yych <= 't') goto yy213;
			goto yy215;
		}
	}
yy368:
	YYDEBUG(368, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych <= ',') goto yy215;
			if (yych <= '-') goto yy361;
			if (yych <= '.') goto yy299;
			goto yy215;
		} else {
			if (yych <= '0') goto yy331;
			if (yych <= '1') goto yy301;
			if (yych <= '2') goto yy302;
			goto yy296;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy263;
			if (yych == 'n') goto yy211;
			goto yy215;
		} else {
			if (yych <= 'r') goto yy212;
			if (yych <= 's') goto yy210;
			if (yych <= 't') goto yy213;
			goto yy215;
		}
	}
yy369:
	YYDEBUG(369, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') goto yy192;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'c') goto yy370;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy370:
	YYDEBUG(370, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'E') goto yy201;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'e') goto yy372;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy371:
	YYDEBUG(371, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy148;
	}
	if (yych <= '/') goto yy195;
	if (yych <= '0') goto yy356;
	if (yych <= '2') goto yy357;
	if (yych <= '3') goto yy358;
	goto yy195;
yy372:
	YYDEBUG(372, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy202;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'm') goto yy373;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy373:
	YYDEBUG(373, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy203;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'b') goto yy374;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy374:
	YYDEBUG(374, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'E') goto yy204;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'e') goto yy375;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy375:
	YYDEBUG(375, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy205;
	if (yych != 'r') goto yy154;
yy376:
	YYDEBUG(376, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy195;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy195;
			if (yych <= ',') goto yy193;
		}
	} else {
		if (yych <= '9') {
			if (yych == '/') goto yy147;
			goto yy195;
		} else {
			if (yych == '_') goto yy147;
			goto yy193;
		}
	}
yy377:
	YYDEBUG(377, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy148;
	}
	goto yy195;
yy378:
	YYDEBUG(378, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy141;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 't') goto yy379;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy379:
	YYDEBUG(379, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'O') goto yy142;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'o') goto yy380;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy380:
	YYDEBUG(380, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy143;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'b') goto yy381;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy381:
	YYDEBUG(381, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy144;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'e') goto yy382;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy382:
	YYDEBUG(382, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Q') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'R') goto yy205;
		if (yych == 'r') goto yy205;
		goto yy3;
	}
yy383:
	YYDEBUG(383, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy379;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 't') goto yy384;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy384:
	YYDEBUG(384, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy371;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'N') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'O') goto yy380;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'o') goto yy385;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy385:
	YYDEBUG(385, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy381;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'b') goto yy386;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy386:
	YYDEBUG(386, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy382;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'e') goto yy387;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy387:
	YYDEBUG(387, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy205;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'r') goto yy376;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy388:
	YYDEBUG(388, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy141;
			goto yy396;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'g') goto yy396;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy389:
	YYDEBUG(389, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy141;
			goto yy393;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'r') goto yy393;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy390:
	YYDEBUG(390, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy141;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'o') goto yy391;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy391:
	YYDEBUG(391, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy139;
	} else {
		if (yych <= 'Z') goto yy142;
		if (yych <= '`') goto yy392;
		if (yych <= 'z') goto yy142;
	}
yy392:
	YYDEBUG(392, *YYCURSOR);
#line 1530 "parse_date.re"
	{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		if (s->time->relative.weekday == 0) {
			s->time->relative.weekday = -7;
		}
		if (s->time->relative.have_special_relative && s->time->relative.special.type == TIMELIB_SPECIAL_WEEKDAY) {
			s->time->relative.special.amount = 0 - s->time->relative.special.amount;
		}
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
#line 7241 "parse_date.c"
yy393:
	YYDEBUG(393, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'I') goto yy142;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'i') goto yy394;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy394:
	YYDEBUG(394, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'K') goto yy143;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'l') goto yy395;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy395:
	YYDEBUG(395, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy195;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy195;
			if (yych == ')') goto yy139;
			goto yy193;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy193;
			if (yych <= '9') goto yy195;
			goto yy193;
		} else {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy193;
			if (yych <= 'z') goto yy144;
			goto yy193;
		}
	}
yy396:
	YYDEBUG(396, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'U') goto yy142;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'u') goto yy397;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy397:
	YYDEBUG(397, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy143;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 's') goto yy398;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy398:
	YYDEBUG(398, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy144;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 't') goto yy399;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy399:
	YYDEBUG(399, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy193;
			goto yy195;
		} else {
			if (yych == ' ') goto yy195;
			goto yy193;
		}
	} else {
		if (yych <= '.') {
			if (yych <= ')') goto yy139;
			if (yych <= ',') goto yy193;
			goto yy195;
		} else {
			if (yych <= '/') goto yy193;
			if (yych <= '9') goto yy195;
			goto yy193;
		}
	}
yy400:
	YYDEBUG(400, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy396;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'g') goto yy407;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy401:
	YYDEBUG(401, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy393;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'r') goto yy404;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy402:
	YYDEBUG(402, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy391;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'o') goto yy403;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy403:
	YYDEBUG(403, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy392;
		} else {
			if (yych == '.') goto yy392;
			goto yy147;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy392;
			if (yych <= 'Z') goto yy142;
			goto yy392;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy392;
			if (yych <= 'z') goto yy150;
			goto yy392;
		}
	}
yy404:
	YYDEBUG(404, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy371;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'I') goto yy394;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'i') goto yy405;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy405:
	YYDEBUG(405, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy395;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'l') goto yy406;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy406:
	YYDEBUG(406, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy193;
			goto yy195;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy193;
				goto yy139;
			} else {
				if (yych <= ',') goto yy193;
				if (yych <= '-') goto yy377;
				goto yy195;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy147;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy193;
			goto yy144;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy193;
				goto yy147;
			} else {
				if (yych <= '`') goto yy193;
				if (yych <= 'z') goto yy152;
				goto yy193;
			}
		}
	}
yy407:
	YYDEBUG(407, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy371;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'U') goto yy397;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'u') goto yy408;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy408:
	YYDEBUG(408, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy398;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 's') goto yy409;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy409:
	YYDEBUG(409, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy399;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 't') goto yy410;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy410:
	YYDEBUG(410, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy195;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy195;
			if (yych == ')') goto yy139;
			goto yy193;
		}
	} else {
		if (yych <= '/') {
			if (yych <= '-') goto yy377;
			if (yych <= '.') goto yy195;
			goto yy147;
		} else {
			if (yych <= '9') goto yy195;
			if (yych == '_') goto yy147;
			goto yy193;
		}
	}
yy411:
	YYDEBUG(411, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'L') goto yy418;
			if (yych <= 'M') goto yy141;
			goto yy417;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'k') goto yy141;
			goto yy418;
		} else {
			if (yych == 'n') goto yy417;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy412:
	YYDEBUG(412, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy141;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'n') goto yy413;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy413:
	YYDEBUG(413, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'U') goto yy142;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'u') goto yy414;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy414:
	YYDEBUG(414, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy143;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy415;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy415:
	YYDEBUG(415, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy144;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'r') goto yy416;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy416:
	YYDEBUG(416, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy205;
		if (yych == 'y') goto yy205;
		goto yy3;
	}
yy417:
	YYDEBUG(417, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych == 'E') goto yy419;
				goto yy142;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'e') goto yy419;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy418:
	YYDEBUG(418, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'Y') goto yy142;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'y') goto yy419;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy419:
	YYDEBUG(419, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy195;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy195;
			if (yych == ')') goto yy139;
			goto yy193;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy193;
			if (yych <= '9') goto yy195;
			goto yy193;
		} else {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy193;
			if (yych <= 'z') goto yy143;
			goto yy193;
		}
	}
yy420:
	YYDEBUG(420, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych == '-') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy147;
				goto yy3;
			} else {
				if (yych == 'L') goto yy418;
				goto yy141;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'N') goto yy417;
				goto yy141;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'l') goto yy427;
				goto yy146;
			} else {
				if (yych <= 'n') goto yy426;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy421:
	YYDEBUG(421, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy413;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'n') goto yy422;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy422:
	YYDEBUG(422, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy371;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'U') goto yy414;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'u') goto yy423;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy423:
	YYDEBUG(423, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy415;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy424;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy424:
	YYDEBUG(424, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy416;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'r') goto yy425;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy425:
	YYDEBUG(425, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy205;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'y') goto yy376;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy426:
	YYDEBUG(426, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy371;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'E') goto yy419;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'e') goto yy428;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy427:
	YYDEBUG(427, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy371;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'X') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'Y') goto yy419;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'y') goto yy428;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy428:
	YYDEBUG(428, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy193;
			goto yy195;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy193;
				goto yy139;
			} else {
				if (yych <= ',') goto yy193;
				if (yych <= '-') goto yy377;
				goto yy195;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy147;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy193;
			goto yy143;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy193;
				goto yy147;
			} else {
				if (yych <= '`') goto yy193;
				if (yych <= 'z') goto yy151;
				goto yy193;
			}
		}
	}
yy429:
	YYDEBUG(429, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy3;
			goto yy195;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy195;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy141;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy141;
				goto yy3;
			}
		}
	}
yy430:
	YYDEBUG(430, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy195;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy195;
			if (yych == ')') goto yy139;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy195;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy431:
	YYDEBUG(431, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy3;
			goto yy195;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy195;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy141;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy141;
				goto yy3;
			}
		}
	}
	YYDEBUG(432, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy3;
			goto yy195;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy195;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy142;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy142;
				goto yy3;
			}
		}
	}
	YYDEBUG(433, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy195;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy195;
			if (yych == ')') goto yy139;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy195;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy434:
	YYDEBUG(434, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy195;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy195;
			if (yych == ')') goto yy139;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy195;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy435:
	YYDEBUG(435, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy3;
			goto yy195;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy195;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy430;
				goto yy141;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy141;
				goto yy3;
			}
		}
	}
yy436:
	YYDEBUG(436, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
					goto yy456;
				} else {
					if (yych <= ':') goto yy162;
					if (yych <= 'C') goto yy3;
					goto yy60;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy437:
	YYDEBUG(437, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ':') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '4') {
					if (yych <= '/') goto yy3;
					goto yy456;
				} else {
					if (yych <= '5') goto yy441;
					if (yych <= '9') goto yy442;
					goto yy162;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy3;
					goto yy60;
				} else {
					if (yych == 'F') goto yy60;
					goto yy3;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'M') goto yy60;
					if (yych <= 'R') goto yy3;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy60;
				if (yych <= 'X') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy3;
					goto yy60;
				} else {
					if (yych == 'f') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'm') goto yy60;
					if (yych <= 'r') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy438:
	YYDEBUG(438, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy3;
					goto yy441;
				} else {
					if (yych <= '9') goto yy442;
					if (yych <= ':') goto yy162;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych == 'E') goto yy3;
				if (yych <= 'F') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'M') goto yy60;
					if (yych <= 'R') goto yy3;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy60;
				if (yych <= 'X') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy3;
					goto yy60;
				} else {
					if (yych == 'f') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'm') goto yy60;
					if (yych <= 'r') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy439:
	YYDEBUG(439, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(440, *YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	if (yych <= ',') {
		if (yych == '+') goto yy439;
		goto yy56;
	} else {
		if (yych <= '-') goto yy439;
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy54;
		goto yy56;
	}
yy441:
	YYDEBUG(441, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '/') goto yy3;
				if (yych <= '9') goto yy455;
				if (yych <= 'C') goto yy3;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy442:
	YYDEBUG(442, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '/') goto yy3;
				if (yych <= '9') goto yy443;
				if (yych <= 'C') goto yy3;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy443:
	YYDEBUG(443, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych >= ':') goto yy60;
yy444:
	YYDEBUG(444, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych != '-') goto yy60;
yy445:
	YYDEBUG(445, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy446;
	if (yych <= '1') goto yy447;
	goto yy56;
yy446:
	YYDEBUG(446, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy448;
	goto yy56;
yy447:
	YYDEBUG(447, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '3') goto yy56;
yy448:
	YYDEBUG(448, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy56;
	YYDEBUG(449, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy450;
	if (yych <= '2') goto yy451;
	if (yych <= '3') goto yy452;
	goto yy56;
yy450:
	YYDEBUG(450, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy453;
	goto yy56;
yy451:
	YYDEBUG(451, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy453;
	goto yy56;
yy452:
	YYDEBUG(452, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '2') goto yy56;
yy453:
	YYDEBUG(453, *YYCURSOR);
	++YYCURSOR;
yy454:
	YYDEBUG(454, *YYCURSOR);
#line 1233 "parse_date.re"
	{
		DEBUG_OUTPUT("iso8601date4 | iso8601date2 | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_unsigned_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 9002 "parse_date.c"
yy455:
	YYDEBUG(455, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '/') goto yy3;
				if (yych <= '9') goto yy444;
				if (yych <= 'C') goto yy3;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy456:
	YYDEBUG(456, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy3;
				} else {
					if (yych <= '9') goto yy455;
					if (yych <= ':') goto yy162;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych == 'E') goto yy3;
				if (yych <= 'F') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'M') goto yy60;
					if (yych <= 'R') goto yy3;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy60;
				if (yych <= 'X') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy3;
					goto yy60;
				} else {
					if (yych == 'f') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'm') goto yy60;
					if (yych <= 'r') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
	YYDEBUG(457, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '/') goto yy3;
				if (yych <= '9') goto yy458;
				if (yych <= 'C') goto yy3;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy458:
	YYDEBUG(458, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych == '-') goto yy445;
				if (yych <= 'C') goto yy3;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy459:
	YYDEBUG(459, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy461;
	if (yych <= '0') goto yy735;
	if (yych <= '1') goto yy736;
	if (yych <= '9') goto yy737;
	goto yy461;
yy460:
	YYDEBUG(460, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy461:
	YYDEBUG(461, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':
	case ' ':	goto yy460;
	case '-':
	case '.':	goto yy576;
	case 'A':
	case 'a':	goto yy479;
	case 'D':
	case 'd':	goto yy465;
	case 'F':
	case 'f':	goto yy466;
	case 'H':
	case 'h':	goto yy63;
	case 'I':	goto yy474;
	case 'J':
	case 'j':	goto yy478;
	case 'M':
	case 'm':	goto yy464;
	case 'N':
	case 'n':	goto yy481;
	case 'O':
	case 'o':	goto yy480;
	case 'P':
	case 'p':	goto yy483;
	case 'S':
	case 's':	goto yy462;
	case 'T':
	case 't':	goto yy68;
	case 'V':	goto yy476;
	case 'W':
	case 'w':	goto yy67;
	case 'X':	goto yy477;
	case 'Y':
	case 'y':	goto yy66;
	default:	goto yy56;
	}
yy462:
	YYDEBUG(462, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy126;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy1048;
			if (yych <= 'T') goto yy56;
			goto yy125;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy126;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy1048;
			if (yych == 'u') goto yy125;
			goto yy56;
		}
	}
yy463:
	YYDEBUG(463, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy126;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy1048;
			if (yych == 'U') goto yy125;
			goto yy56;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'a') goto yy126;
			if (yych <= 'd') goto yy56;
			goto yy1048;
		} else {
			if (yych <= 's') goto yy56;
			if (yych <= 't') goto yy728;
			if (yych <= 'u') goto yy125;
			goto yy56;
		}
	}
yy464:
	YYDEBUG(464, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'A') goto yy591;
			goto yy56;
		} else {
			if (yych <= 'I') goto yy117;
			if (yych <= 'N') goto yy56;
			goto yy116;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'a') goto yy591;
			goto yy56;
		} else {
			if (yych <= 'i') goto yy117;
			if (yych == 'o') goto yy116;
			goto yy56;
		}
	}
yy465:
	YYDEBUG(465, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy113;
		if (yych <= 'D') goto yy56;
		goto yy578;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy113;
		} else {
			if (yych == 'e') goto yy578;
			goto yy56;
		}
	}
yy466:
	YYDEBUG(466, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy594;
			goto yy56;
		} else {
			if (yych <= 'O') goto yy98;
			if (yych <= 'Q') goto yy56;
			goto yy97;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy594;
			goto yy56;
		} else {
			if (yych <= 'o') goto yy98;
			if (yych == 'r') goto yy97;
			goto yy56;
		}
	}
yy467:
	YYDEBUG(467, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy69;
		if (yych <= 'T') goto yy56;
		goto yy70;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
			goto yy1047;
		} else {
			if (yych == 'u') goto yy70;
			goto yy56;
		}
	}
yy468:
	YYDEBUG(468, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy741;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy740;
	goto yy60;
yy469:
	YYDEBUG(469, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'c') {
		if (yych == 'O') goto yy529;
		goto yy56;
	} else {
		if (yych <= 'd') goto yy728;
		if (yych == 'o') goto yy529;
		goto yy56;
	}
yy470:
	YYDEBUG(470, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy728;
	goto yy56;
yy471:
	YYDEBUG(471, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy665;
	case '3':	goto yy667;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy668;
	case 'A':
	case 'a':	goto yy672;
	case 'D':
	case 'd':	goto yy676;
	case 'F':
	case 'f':	goto yy670;
	case 'J':
	case 'j':	goto yy669;
	case 'M':
	case 'm':	goto yy671;
	case 'N':
	case 'n':	goto yy675;
	case 'O':
	case 'o':	goto yy674;
	case 'S':
	case 's':	goto yy673;
	default:	goto yy56;
	}
yy472:
	YYDEBUG(472, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case '0':	goto yy615;
	case '1':	goto yy616;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy617;
	case 'A':
	case 'a':	goto yy621;
	case 'D':
	case 'd':	goto yy625;
	case 'F':
	case 'f':	goto yy619;
	case 'J':
	case 'j':	goto yy618;
	case 'M':
	case 'm':	goto yy620;
	case 'N':
	case 'n':	goto yy624;
	case 'O':
	case 'o':	goto yy623;
	case 'S':
	case 's':	goto yy622;
	default:	goto yy577;
	}
yy473:
	YYDEBUG(473, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy577;
		if (yych <= '0') goto yy567;
		goto yy568;
	} else {
		if (yych <= '5') goto yy569;
		if (yych <= '9') goto yy570;
		goto yy577;
	}
yy474:
	YYDEBUG(474, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			if (yych <= '.') goto yy531;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '9') goto yy533;
			if (yych == 'I') goto yy566;
		} else {
			if (yych == 'W') goto yy475;
			if (yych <= 'X') goto yy539;
		}
	}
yy475:
	YYDEBUG(475, *YYCURSOR);
#line 1370 "parse_date.re"
	{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 9573 "parse_date.c"
yy476:
	YYDEBUG(476, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy475;
			goto yy531;
		} else {
			if (yych == ' ') goto yy531;
			goto yy475;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy531;
			if (yych <= '/') goto yy475;
			goto yy533;
		} else {
			if (yych == 'I') goto yy564;
			goto yy475;
		}
	}
yy477:
	YYDEBUG(477, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy475;
			goto yy531;
		} else {
			if (yych == ' ') goto yy531;
			goto yy475;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy531;
			if (yych <= '/') goto yy475;
			goto yy533;
		} else {
			if (yych == 'I') goto yy563;
			goto yy475;
		}
	}
yy478:
	YYDEBUG(478, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy556;
		if (yych <= 'T') goto yy56;
		goto yy555;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy556;
		} else {
			if (yych == 'u') goto yy555;
			goto yy56;
		}
	}
yy479:
	YYDEBUG(479, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= 'L') {
			if (yych == '.') goto yy484;
			goto yy56;
		} else {
			if (yych <= 'M') goto yy485;
			if (yych == 'P') goto yy549;
			goto yy56;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'U') goto yy548;
			if (yych == 'm') goto yy485;
			goto yy56;
		} else {
			if (yych <= 'p') goto yy549;
			if (yych == 'u') goto yy548;
			goto yy56;
		}
	}
yy480:
	YYDEBUG(480, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy543;
	if (yych == 'c') goto yy543;
	goto yy56;
yy481:
	YYDEBUG(481, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy529;
	if (yych == 'o') goto yy529;
	goto yy56;
yy482:
	YYDEBUG(482, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy489;
	if (yych <= '9') goto yy491;
	goto yy56;
yy483:
	YYDEBUG(483, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy485;
		if (yych == 'm') goto yy485;
		goto yy56;
	}
yy484:
	YYDEBUG(484, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy485;
	if (yych != 'm') goto yy56;
yy485:
	YYDEBUG(485, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy487;
		if (yych == '\t') goto yy487;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy487;
		if (yych != '.') goto yy56;
	}
	YYDEBUG(486, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy487;
		if (yych <= 0x08) goto yy56;
	} else {
		if (yych != ' ') goto yy56;
	}
yy487:
	YYDEBUG(487, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(488, *YYCURSOR);
#line 1088 "parse_date.re"
	{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr((char **) &ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr((char **) &ptr, 2);
			}
		}
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
#line 9730 "parse_date.c"
yy489:
	YYDEBUG(489, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy492;
	} else {
		if (yych <= '9') goto yy506;
		if (yych <= ':') goto yy492;
	}
yy490:
	YYDEBUG(490, *YYCURSOR);
#line 1125 "parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
#line 9768 "parse_date.c"
yy491:
	YYDEBUG(491, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy492;
	if (yych != ':') goto yy490;
yy492:
	YYDEBUG(492, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy493;
	if (yych <= '6') goto yy494;
	if (yych <= '9') goto yy495;
	goto yy56;
yy493:
	YYDEBUG(493, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy496;
	if (yych <= '/') goto yy490;
	if (yych <= '9') goto yy499;
	goto yy490;
yy494:
	YYDEBUG(494, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy496;
	if (yych == '0') goto yy499;
	goto yy490;
yy495:
	YYDEBUG(495, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '.') goto yy490;
yy496:
	YYDEBUG(496, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy497:
	YYDEBUG(497, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(498, *YYCURSOR);
	if (yych <= '/') goto yy490;
	if (yych <= '9') goto yy497;
	goto yy490;
yy499:
	YYDEBUG(499, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy490;
		} else {
			if (yych <= ' ') goto yy500;
			if (yych == '.') goto yy496;
			goto yy490;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy502;
			if (yych == 'P') goto yy502;
			goto yy490;
		} else {
			if (yych <= 'a') goto yy502;
			if (yych == 'p') goto yy502;
			goto yy490;
		}
	}
yy500:
	YYDEBUG(500, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(501, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy500;
			goto yy56;
		} else {
			if (yych <= ' ') goto yy500;
			if (yych <= '@') goto yy56;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy56;
		} else {
			if (yych <= 'a') goto yy502;
			if (yych != 'p') goto yy56;
		}
	}
yy502:
	YYDEBUG(502, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy504;
		if (yych == 'm') goto yy504;
		goto yy56;
	}
	YYDEBUG(503, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy504;
	if (yych != 'm') goto yy56;
yy504:
	YYDEBUG(504, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy487;
		if (yych == '\t') goto yy487;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy487;
		if (yych != '.') goto yy56;
	}
	YYDEBUG(505, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy487;
		if (yych <= 0x08) goto yy56;
		goto yy487;
	} else {
		if (yych == ' ') goto yy487;
		goto yy56;
	}
yy506:
	YYDEBUG(506, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy507;
			if (yych <= 0x1F) goto yy490;
		} else {
			if (yych == '.') goto yy492;
			if (yych <= '9') goto yy490;
			goto yy510;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy509;
			if (yych <= 'O') goto yy490;
			goto yy509;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy490;
				goto yy509;
			} else {
				if (yych == 'p') goto yy509;
				goto yy490;
			}
		}
	}
yy507:
	YYDEBUG(507, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(508, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy507;
			goto yy56;
		} else {
			if (yych <= ' ') goto yy507;
			if (yych <= '@') goto yy56;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy56;
		} else {
			if (yych <= 'a') goto yy509;
			if (yych != 'p') goto yy56;
		}
	}
yy509:
	YYDEBUG(509, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy526;
		goto yy56;
	} else {
		if (yych <= 'M') goto yy527;
		if (yych == 'm') goto yy527;
		goto yy56;
	}
yy510:
	YYDEBUG(510, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy511;
	if (yych <= '6') goto yy512;
	if (yych <= '9') goto yy495;
	goto yy56;
yy511:
	YYDEBUG(511, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy496;
	if (yych <= '/') goto yy490;
	if (yych <= '9') goto yy513;
	goto yy490;
yy512:
	YYDEBUG(512, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy496;
	if (yych != '0') goto yy490;
yy513:
	YYDEBUG(513, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy500;
			if (yych <= 0x1F) goto yy490;
			goto yy500;
		} else {
			if (yych == '.') goto yy514;
			if (yych <= '9') goto yy490;
			goto yy515;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy502;
			if (yych <= 'O') goto yy490;
			goto yy502;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy490;
				goto yy502;
			} else {
				if (yych == 'p') goto yy502;
				goto yy490;
			}
		}
	}
yy514:
	YYDEBUG(514, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy524;
	goto yy56;
yy515:
	YYDEBUG(515, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy516:
	YYDEBUG(516, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(517, *YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy56;
			goto yy516;
		} else {
			if (yych != 'A') goto yy56;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy518;
			if (yych <= '`') goto yy56;
		} else {
			if (yych != 'p') goto yy56;
		}
	}
yy518:
	YYDEBUG(518, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy520;
		if (yych == 'm') goto yy520;
		goto yy56;
	}
	YYDEBUG(519, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy520;
	if (yych != 'm') goto yy56;
yy520:
	YYDEBUG(520, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy522;
		if (yych == '\t') goto yy522;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy522;
		if (yych != '.') goto yy56;
	}
	YYDEBUG(521, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy522;
		if (yych <= 0x08) goto yy56;
	} else {
		if (yych != ' ') goto yy56;
	}
yy522:
	YYDEBUG(522, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(523, *YYCURSOR);
#line 1105 "parse_date.re"
	{
		DEBUG_OUTPUT("mssqltime");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == ':' || *ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}
		timelib_eat_spaces((char **) &ptr);
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
#line 10097 "parse_date.c"
yy524:
	YYDEBUG(524, *YYCURSOR);
	yyaccept = 11;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(525, *YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy490;
			goto yy524;
		} else {
			if (yych == 'A') goto yy518;
			goto yy490;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy518;
			if (yych <= '`') goto yy490;
			goto yy518;
		} else {
			if (yych == 'p') goto yy518;
			goto yy490;
		}
	}
yy526:
	YYDEBUG(526, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy527;
	if (yych != 'm') goto yy56;
yy527:
	YYDEBUG(527, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy487;
		if (yych == '\t') goto yy487;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy487;
		if (yych != '.') goto yy56;
	}
	YYDEBUG(528, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy487;
		if (yych <= 0x08) goto yy56;
		goto yy487;
	} else {
		if (yych == ' ') goto yy487;
		goto yy56;
	}
yy529:
	YYDEBUG(529, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy530;
	if (yych != 'v') goto yy56;
yy530:
	YYDEBUG(530, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'E') goto yy535;
			if (yych == 'e') goto yy535;
			goto yy475;
		}
	}
yy531:
	YYDEBUG(531, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
yy532:
	YYDEBUG(532, *YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy531;
		if (yych <= 0x1F) goto yy56;
		goto yy531;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy56;
			goto yy531;
		} else {
			if (yych <= '/') goto yy56;
			if (yych >= ':') goto yy56;
		}
	}
yy533:
	YYDEBUG(533, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy534;
	if (yych <= '9') goto yy540;
yy534:
	YYDEBUG(534, *YYCURSOR);
#line 1287 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
#line 10217 "parse_date.c"
yy535:
	YYDEBUG(535, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy536;
	if (yych != 'm') goto yy56;
yy536:
	YYDEBUG(536, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy537;
	if (yych != 'b') goto yy56;
yy537:
	YYDEBUG(537, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy538;
	if (yych != 'e') goto yy56;
yy538:
	YYDEBUG(538, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy539;
	if (yych != 'r') goto yy56;
yy539:
	YYDEBUG(539, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy531;
		if (yych <= 0x1F) goto yy475;
		goto yy531;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy475;
			goto yy531;
		} else {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		}
	}
yy540:
	YYDEBUG(540, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy534;
	if (yych >= ':') goto yy534;
yy541:
	YYDEBUG(541, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy534;
	if (yych >= ':') goto yy534;
	YYDEBUG(542, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy534;
yy543:
	YYDEBUG(543, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy544;
	if (yych != 't') goto yy56;
yy544:
	YYDEBUG(544, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			goto yy531;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'O') goto yy545;
			if (yych != 'o') goto yy475;
		}
	}
yy545:
	YYDEBUG(545, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy546;
	if (yych != 'b') goto yy56;
yy546:
	YYDEBUG(546, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy547;
	if (yych != 'e') goto yy56;
yy547:
	YYDEBUG(547, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy539;
	if (yych == 'r') goto yy539;
	goto yy56;
yy548:
	YYDEBUG(548, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy552;
	if (yych == 'g') goto yy552;
	goto yy56;
yy549:
	YYDEBUG(549, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy550;
	if (yych != 'r') goto yy56;
yy550:
	YYDEBUG(550, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			goto yy531;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'I') goto yy551;
			if (yych != 'i') goto yy475;
		}
	}
yy551:
	YYDEBUG(551, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy539;
	if (yych == 'l') goto yy539;
	goto yy56;
yy552:
	YYDEBUG(552, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			goto yy531;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'U') goto yy553;
			if (yych != 'u') goto yy475;
		}
	}
yy553:
	YYDEBUG(553, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy554;
	if (yych != 's') goto yy56;
yy554:
	YYDEBUG(554, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy539;
	if (yych == 't') goto yy539;
	goto yy56;
yy555:
	YYDEBUG(555, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy562;
		if (yych <= 'M') goto yy56;
		goto yy561;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy562;
		} else {
			if (yych == 'n') goto yy561;
			goto yy56;
		}
	}
yy556:
	YYDEBUG(556, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy557;
	if (yych != 'n') goto yy56;
yy557:
	YYDEBUG(557, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			goto yy531;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'U') goto yy558;
			if (yych != 'u') goto yy475;
		}
	}
yy558:
	YYDEBUG(558, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy559;
	if (yych != 'a') goto yy56;
yy559:
	YYDEBUG(559, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy560;
	if (yych != 'r') goto yy56;
yy560:
	YYDEBUG(560, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy539;
	if (yych == 'y') goto yy539;
	goto yy56;
yy561:
	YYDEBUG(561, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			goto yy531;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'E') goto yy539;
			if (yych == 'e') goto yy539;
			goto yy475;
		}
	}
yy562:
	YYDEBUG(562, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			goto yy531;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'Y') goto yy539;
			if (yych == 'y') goto yy539;
			goto yy475;
		}
	}
yy563:
	YYDEBUG(563, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy475;
			goto yy531;
		} else {
			if (yych == ' ') goto yy531;
			goto yy475;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy531;
			if (yych <= '/') goto yy475;
			goto yy533;
		} else {
			if (yych == 'I') goto yy539;
			goto yy475;
		}
	}
yy564:
	YYDEBUG(564, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy475;
			goto yy531;
		} else {
			if (yych == ' ') goto yy531;
			goto yy475;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy531;
			if (yych <= '/') goto yy475;
			goto yy533;
		} else {
			if (yych != 'I') goto yy475;
		}
	}
	YYDEBUG(565, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy475;
			goto yy531;
		} else {
			if (yych == ' ') goto yy531;
			goto yy475;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy531;
			if (yych <= '/') goto yy475;
			goto yy533;
		} else {
			if (yych == 'I') goto yy539;
			goto yy475;
		}
	}
yy566:
	YYDEBUG(566, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy475;
			goto yy531;
		} else {
			if (yych == ' ') goto yy531;
			goto yy475;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy531;
			if (yych <= '/') goto yy475;
			goto yy533;
		} else {
			if (yych == 'I') goto yy539;
			goto yy475;
		}
	}
yy567:
	YYDEBUG(567, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy490;
		if (yych <= '-') goto yy601;
		goto yy600;
	} else {
		if (yych <= '/') goto yy490;
		if (yych <= '9') goto yy614;
		if (yych <= ':') goto yy492;
		goto yy490;
	}
yy568:
	YYDEBUG(568, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy490;
		if (yych <= '-') goto yy601;
		if (yych <= '.') goto yy600;
		goto yy490;
	} else {
		if (yych <= '2') goto yy614;
		if (yych <= '9') goto yy613;
		if (yych <= ':') goto yy492;
		goto yy490;
	}
yy569:
	YYDEBUG(569, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy490;
		if (yych <= '-') goto yy601;
		goto yy600;
	} else {
		if (yych <= '/') goto yy490;
		if (yych <= '9') goto yy613;
		if (yych <= ':') goto yy492;
		goto yy490;
	}
yy570:
	YYDEBUG(570, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy490;
		if (yych <= '-') goto yy601;
		goto yy600;
	} else {
		if (yych == ':') goto yy492;
		goto yy490;
	}
yy571:
	YYDEBUG(571, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy594;
	if (yych == 'e') goto yy594;
	goto yy56;
yy572:
	YYDEBUG(572, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy591;
	if (yych == 'a') goto yy591;
	goto yy56;
yy573:
	YYDEBUG(573, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy549;
		if (yych <= 'T') goto yy56;
		goto yy548;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy549;
		} else {
			if (yych == 'u') goto yy548;
			goto yy56;
		}
	}
yy574:
	YYDEBUG(574, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy584;
	if (yych == 'e') goto yy584;
	goto yy56;
yy575:
	YYDEBUG(575, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy578;
	if (yych == 'e') goto yy578;
	goto yy56;
yy576:
	YYDEBUG(576, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy577:
	YYDEBUG(577, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy576;
	case 'A':
	case 'a':	goto yy573;
	case 'D':
	case 'd':	goto yy575;
	case 'F':
	case 'f':	goto yy571;
	case 'I':	goto yy474;
	case 'J':
	case 'j':	goto yy478;
	case 'M':
	case 'm':	goto yy572;
	case 'N':
	case 'n':	goto yy481;
	case 'O':
	case 'o':	goto yy480;
	case 'S':
	case 's':	goto yy574;
	case 'V':	goto yy476;
	case 'X':	goto yy477;
	default:	goto yy56;
	}
yy578:
	YYDEBUG(578, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy579;
	if (yych != 'c') goto yy56;
yy579:
	YYDEBUG(579, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			goto yy531;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'E') goto yy580;
			if (yych != 'e') goto yy475;
		}
	}
yy580:
	YYDEBUG(580, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy581;
	if (yych != 'm') goto yy56;
yy581:
	YYDEBUG(581, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy582;
	if (yych != 'b') goto yy56;
yy582:
	YYDEBUG(582, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy583;
	if (yych != 'e') goto yy56;
yy583:
	YYDEBUG(583, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy539;
	if (yych == 'r') goto yy539;
	goto yy56;
yy584:
	YYDEBUG(584, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy585;
	if (yych != 'p') goto yy56;
yy585:
	YYDEBUG(585, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			goto yy531;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'T') goto yy586;
			if (yych != 't') goto yy475;
		}
	}
yy586:
	YYDEBUG(586, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			goto yy531;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'E') goto yy587;
			if (yych != 'e') goto yy475;
		}
	}
yy587:
	YYDEBUG(587, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy588;
	if (yych != 'm') goto yy56;
yy588:
	YYDEBUG(588, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy589;
	if (yych != 'b') goto yy56;
yy589:
	YYDEBUG(589, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy590;
	if (yych != 'e') goto yy56;
yy590:
	YYDEBUG(590, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy539;
	if (yych == 'r') goto yy539;
	goto yy56;
yy591:
	YYDEBUG(591, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy592;
		if (yych <= 'X') goto yy56;
		goto yy539;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
		} else {
			if (yych == 'y') goto yy539;
			goto yy56;
		}
	}
yy592:
	YYDEBUG(592, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			goto yy531;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'C') goto yy593;
			if (yych != 'c') goto yy475;
		}
	}
yy593:
	YYDEBUG(593, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy539;
	if (yych == 'h') goto yy539;
	goto yy56;
yy594:
	YYDEBUG(594, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy595;
	if (yych != 'b') goto yy56;
yy595:
	YYDEBUG(595, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			goto yy531;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'R') goto yy596;
			if (yych != 'r') goto yy475;
		}
	}
yy596:
	YYDEBUG(596, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy597;
	if (yych != 'u') goto yy56;
yy597:
	YYDEBUG(597, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy598;
	if (yych != 'a') goto yy56;
yy598:
	YYDEBUG(598, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy599;
	if (yych != 'r') goto yy56;
yy599:
	YYDEBUG(599, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy539;
	if (yych == 'y') goto yy539;
	goto yy56;
yy600:
	YYDEBUG(600, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy607;
	if (yych <= '6') goto yy608;
	if (yych <= '9') goto yy609;
	goto yy56;
yy601:
	YYDEBUG(601, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(602, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy603:
	YYDEBUG(603, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy604:
	YYDEBUG(604, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(605, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(606, *YYCURSOR);
#line 1302 "parse_date.re"
	{
		DEBUG_OUTPUT("pointed date YYYY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
#line 10965 "parse_date.c"
yy607:
	YYDEBUG(607, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy496;
	if (yych <= '/') goto yy490;
	if (yych <= '9') goto yy612;
	goto yy490;
yy608:
	YYDEBUG(608, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy496;
		goto yy490;
	} else {
		if (yych <= '0') goto yy612;
		if (yych <= '9') goto yy610;
		goto yy490;
	}
yy609:
	YYDEBUG(609, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy496;
	if (yych <= '/') goto yy490;
	if (yych >= ':') goto yy490;
yy610:
	YYDEBUG(610, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy611;
	if (yych <= '9') goto yy604;
yy611:
	YYDEBUG(611, *YYCURSOR);
#line 1314 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pointed date YY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 2, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
#line 11014 "parse_date.c"
yy612:
	YYDEBUG(612, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy500;
			if (yych <= 0x1F) goto yy490;
			goto yy500;
		} else {
			if (yych == '.') goto yy496;
			if (yych <= '/') goto yy490;
			goto yy604;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy502;
			if (yych <= 'O') goto yy490;
			goto yy502;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy490;
				goto yy502;
			} else {
				if (yych == 'p') goto yy502;
				goto yy490;
			}
		}
	}
yy613:
	YYDEBUG(613, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy507;
			if (yych <= 0x1F) goto yy490;
			goto yy507;
		} else {
			if (yych == '.') goto yy492;
			if (yych <= '9') goto yy490;
			goto yy492;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy509;
			if (yych <= 'O') goto yy490;
			goto yy509;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy490;
				goto yy509;
			} else {
				if (yych == 'p') goto yy509;
				goto yy490;
			}
		}
	}
yy614:
	YYDEBUG(614, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy507;
			if (yych <= 0x1F) goto yy490;
			goto yy507;
		} else {
			if (yych <= '-') {
				if (yych <= ',') goto yy490;
				goto yy601;
			} else {
				if (yych <= '.') goto yy600;
				if (yych <= '9') goto yy490;
				goto yy492;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy509;
			if (yych <= 'O') goto yy490;
			goto yy509;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy490;
				goto yy509;
			} else {
				if (yych == 'p') goto yy509;
				goto yy490;
			}
		}
	}
yy615:
	YYDEBUG(615, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy654;
		goto yy601;
	} else {
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy617;
		goto yy56;
	}
yy616:
	YYDEBUG(616, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy654;
		goto yy601;
	} else {
		if (yych <= '/') goto yy56;
		if (yych >= '3') goto yy56;
	}
yy617:
	YYDEBUG(617, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '-') goto yy654;
	if (yych <= '.') goto yy601;
	goto yy56;
yy618:
	YYDEBUG(618, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy650;
		if (yych <= 'T') goto yy56;
		goto yy649;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy650;
		} else {
			if (yych == 'u') goto yy649;
			goto yy56;
		}
	}
yy619:
	YYDEBUG(619, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy647;
	if (yych == 'e') goto yy647;
	goto yy56;
yy620:
	YYDEBUG(620, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy644;
	if (yych == 'a') goto yy644;
	goto yy56;
yy621:
	YYDEBUG(621, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy641;
		if (yych <= 'T') goto yy56;
		goto yy640;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy641;
		} else {
			if (yych == 'u') goto yy640;
			goto yy56;
		}
	}
yy622:
	YYDEBUG(622, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy637;
	if (yych == 'e') goto yy637;
	goto yy56;
yy623:
	YYDEBUG(623, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy635;
	if (yych == 'c') goto yy635;
	goto yy56;
yy624:
	YYDEBUG(624, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy633;
	if (yych == 'o') goto yy633;
	goto yy56;
yy625:
	YYDEBUG(625, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy626;
	if (yych != 'e') goto yy56;
yy626:
	YYDEBUG(626, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy627;
	if (yych != 'c') goto yy56;
yy627:
	YYDEBUG(627, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			if (yych >= '.') goto yy531;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'E') goto yy580;
			if (yych == 'e') goto yy580;
			goto yy475;
		}
	}
yy628:
	YYDEBUG(628, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy532;
	if (yych <= '0') goto yy629;
	if (yych <= '2') goto yy630;
	if (yych <= '3') goto yy631;
	goto yy532;
yy629:
	YYDEBUG(629, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy534;
	if (yych <= '9') goto yy632;
	goto yy534;
yy630:
	YYDEBUG(630, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy534;
	if (yych <= '9') goto yy632;
	goto yy534;
yy631:
	YYDEBUG(631, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy534;
	if (yych <= '1') goto yy632;
	if (yych <= '9') goto yy540;
	goto yy534;
yy632:
	YYDEBUG(632, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy534;
	if (yych <= '9') goto yy541;
	goto yy534;
yy633:
	YYDEBUG(633, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy634;
	if (yych != 'v') goto yy56;
yy634:
	YYDEBUG(634, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			if (yych <= '-') goto yy628;
			goto yy531;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'E') goto yy535;
			if (yych == 'e') goto yy535;
			goto yy475;
		}
	}
yy635:
	YYDEBUG(635, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy636;
	if (yych != 't') goto yy56;
yy636:
	YYDEBUG(636, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			if (yych <= '-') goto yy628;
			goto yy531;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'O') goto yy545;
			if (yych == 'o') goto yy545;
			goto yy475;
		}
	}
yy637:
	YYDEBUG(637, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy638;
	if (yych != 'p') goto yy56;
yy638:
	YYDEBUG(638, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			if (yych <= '-') goto yy628;
			goto yy531;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'T') goto yy639;
			if (yych != 't') goto yy475;
		}
	}
yy639:
	YYDEBUG(639, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			if (yych <= '-') goto yy628;
			goto yy531;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'E') goto yy587;
			if (yych == 'e') goto yy587;
			goto yy475;
		}
	}
yy640:
	YYDEBUG(640, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy643;
	if (yych == 'g') goto yy643;
	goto yy56;
yy641:
	YYDEBUG(641, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy642;
	if (yych != 'r') goto yy56;
yy642:
	YYDEBUG(642, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			if (yych <= '-') goto yy628;
			goto yy531;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'I') goto yy551;
			if (yych == 'i') goto yy551;
			goto yy475;
		}
	}
yy643:
	YYDEBUG(643, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			if (yych <= '-') goto yy628;
			goto yy531;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'U') goto yy553;
			if (yych == 'u') goto yy553;
			goto yy475;
		}
	}
yy644:
	YYDEBUG(644, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy645;
		if (yych <= 'X') goto yy56;
		goto yy646;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
		} else {
			if (yych == 'y') goto yy646;
			goto yy56;
		}
	}
yy645:
	YYDEBUG(645, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			if (yych <= '-') goto yy628;
			goto yy531;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'C') goto yy593;
			if (yych == 'c') goto yy593;
			goto yy475;
		}
	}
yy646:
	YYDEBUG(646, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy475;
			goto yy531;
		} else {
			if (yych == ' ') goto yy531;
			goto yy475;
		}
	} else {
		if (yych <= '.') {
			if (yych <= '-') goto yy628;
			goto yy531;
		} else {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		}
	}
yy647:
	YYDEBUG(647, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy648;
	if (yych != 'b') goto yy56;
yy648:
	YYDEBUG(648, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			if (yych <= '-') goto yy628;
			goto yy531;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'R') goto yy596;
			if (yych == 'r') goto yy596;
			goto yy475;
		}
	}
yy649:
	YYDEBUG(649, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy653;
		if (yych <= 'M') goto yy56;
		goto yy652;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy653;
		} else {
			if (yych == 'n') goto yy652;
			goto yy56;
		}
	}
yy650:
	YYDEBUG(650, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy651;
	if (yych != 'n') goto yy56;
yy651:
	YYDEBUG(651, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			if (yych <= '-') goto yy628;
			goto yy531;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'U') goto yy558;
			if (yych == 'u') goto yy558;
			goto yy475;
		}
	}
yy652:
	YYDEBUG(652, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			if (yych <= '-') goto yy628;
			goto yy531;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'E') goto yy539;
			if (yych == 'e') goto yy539;
			goto yy475;
		}
	}
yy653:
	YYDEBUG(653, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			if (yych <= '-') goto yy628;
			goto yy531;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'Y') goto yy539;
			if (yych == 'y') goto yy539;
			goto yy475;
		}
	}
yy654:
	YYDEBUG(654, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy655;
	if (yych <= '3') goto yy657;
	if (yych <= '9') goto yy658;
	goto yy56;
yy655:
	YYDEBUG(655, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy656;
		if (yych <= '9') goto yy664;
		if (yych >= 'n') goto yy660;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy661;
		} else {
			if (yych <= 's') goto yy659;
			if (yych <= 't') goto yy662;
		}
	}
yy656:
	YYDEBUG(656, *YYCURSOR);
#line 1273 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 11668 "parse_date.c"
yy657:
	YYDEBUG(657, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy656;
			goto yy664;
		} else {
			if (yych <= '9') goto yy603;
			if (yych <= 'm') goto yy656;
			goto yy660;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy656;
			goto yy661;
		} else {
			if (yych <= 's') goto yy659;
			if (yych <= 't') goto yy662;
			goto yy656;
		}
	}
yy658:
	YYDEBUG(658, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy656;
		if (yych <= '9') goto yy603;
		if (yych <= 'm') goto yy656;
		goto yy660;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy656;
			goto yy661;
		} else {
			if (yych <= 's') goto yy659;
			if (yych <= 't') goto yy662;
			goto yy656;
		}
	}
yy659:
	YYDEBUG(659, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy663;
	goto yy56;
yy660:
	YYDEBUG(660, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy663;
	goto yy56;
yy661:
	YYDEBUG(661, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy663;
	goto yy56;
yy662:
	YYDEBUG(662, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'h') goto yy56;
yy663:
	YYDEBUG(663, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy656;
yy664:
	YYDEBUG(664, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy656;
		if (yych <= '9') goto yy604;
		if (yych <= 'm') goto yy656;
		goto yy660;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy656;
			goto yy661;
		} else {
			if (yych <= 's') goto yy659;
			if (yych <= 't') goto yy662;
			goto yy656;
		}
	}
yy665:
	YYDEBUG(665, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych >= '/') goto yy722;
		} else {
			if (yych <= '9') goto yy668;
			if (yych >= 'n') goto yy719;
		}
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy720;
		} else {
			if (yych <= 's') goto yy718;
			if (yych <= 't') goto yy721;
		}
	}
yy666:
	YYDEBUG(666, *YYCURSOR);
#line 1217 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
			TIMELIB_PROCESS_YEAR(s->time->y, length);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
#line 11789 "parse_date.c"
yy667:
	YYDEBUG(667, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych <= '.') goto yy666;
			goto yy722;
		} else {
			if (yych <= '1') goto yy668;
			if (yych <= 'm') goto yy666;
			goto yy719;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy666;
			goto yy720;
		} else {
			if (yych <= 's') goto yy718;
			if (yych <= 't') goto yy721;
			goto yy666;
		}
	}
yy668:
	YYDEBUG(668, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy722;
		if (yych <= 'm') goto yy666;
		goto yy719;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy666;
			goto yy720;
		} else {
			if (yych <= 's') goto yy718;
			if (yych <= 't') goto yy721;
			goto yy666;
		}
	}
yy669:
	YYDEBUG(669, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy717;
		if (yych <= 'T') goto yy56;
		goto yy716;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy717;
		} else {
			if (yych == 'u') goto yy716;
			goto yy56;
		}
	}
yy670:
	YYDEBUG(670, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy715;
	if (yych == 'e') goto yy715;
	goto yy56;
yy671:
	YYDEBUG(671, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy714;
	if (yych == 'a') goto yy714;
	goto yy56;
yy672:
	YYDEBUG(672, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy713;
		if (yych <= 'T') goto yy56;
		goto yy712;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy713;
		} else {
			if (yych == 'u') goto yy712;
			goto yy56;
		}
	}
yy673:
	YYDEBUG(673, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy710;
	if (yych == 'e') goto yy710;
	goto yy56;
yy674:
	YYDEBUG(674, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy709;
	if (yych == 'c') goto yy709;
	goto yy56;
yy675:
	YYDEBUG(675, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy708;
	if (yych == 'o') goto yy708;
	goto yy56;
yy676:
	YYDEBUG(676, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy677;
	if (yych != 'e') goto yy56;
yy677:
	YYDEBUG(677, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy678;
	if (yych != 'c') goto yy56;
yy678:
	YYDEBUG(678, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '/') goto yy56;
yy679:
	YYDEBUG(679, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(680, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(681, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(682, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(683, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	YYDEBUG(684, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy685;
	if (yych <= '2') goto yy686;
	goto yy56;
yy685:
	YYDEBUG(685, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy687;
	goto yy56;
yy686:
	YYDEBUG(686, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '5') goto yy56;
yy687:
	YYDEBUG(687, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	YYDEBUG(688, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '6') goto yy56;
	YYDEBUG(689, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(690, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	YYDEBUG(691, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy692;
	if (yych <= '6') goto yy693;
	goto yy56;
yy692:
	YYDEBUG(692, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy694;
	goto yy56;
yy693:
	YYDEBUG(693, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy56;
yy694:
	YYDEBUG(694, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy695;
	if (yych != ' ') goto yy56;
yy695:
	YYDEBUG(695, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	YYDEBUG(696, *YYCURSOR);
	if (yych <= '*') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy56;
			goto yy695;
		} else {
			if (yych == ' ') goto yy695;
			goto yy56;
		}
	} else {
		if (yych <= '-') {
			if (yych == ',') goto yy56;
			goto yy698;
		} else {
			if (yych != 'G') goto yy56;
		}
	}
	YYDEBUG(697, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy706;
	goto yy56;
yy698:
	YYDEBUG(698, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy699;
	if (yych <= '2') goto yy701;
	if (yych <= '9') goto yy702;
	goto yy56;
yy699:
	YYDEBUG(699, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy700;
	if (yych <= '9') goto yy702;
	if (yych <= ':') goto yy703;
yy700:
	YYDEBUG(700, *YYCURSOR);
#line 1500 "parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
		if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 12042 "parse_date.c"
yy701:
	YYDEBUG(701, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy700;
		if (yych >= '5') goto yy704;
	} else {
		if (yych <= '9') goto yy705;
		if (yych <= ':') goto yy703;
		goto yy700;
	}
yy702:
	YYDEBUG(702, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy700;
	if (yych <= '5') goto yy704;
	if (yych <= '9') goto yy705;
	if (yych >= ';') goto yy700;
yy703:
	YYDEBUG(703, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy700;
	if (yych <= '5') goto yy704;
	if (yych <= '9') goto yy705;
	goto yy700;
yy704:
	YYDEBUG(704, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy700;
	if (yych >= ':') goto yy700;
yy705:
	YYDEBUG(705, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy700;
yy706:
	YYDEBUG(706, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'T') goto yy56;
	YYDEBUG(707, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '+') goto yy698;
	if (yych == '-') goto yy698;
	goto yy56;
yy708:
	YYDEBUG(708, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy678;
	if (yych == 'v') goto yy678;
	goto yy56;
yy709:
	YYDEBUG(709, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy678;
	if (yych == 't') goto yy678;
	goto yy56;
yy710:
	YYDEBUG(710, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy711;
	if (yych != 'p') goto yy56;
yy711:
	YYDEBUG(711, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '/') goto yy679;
		goto yy56;
	} else {
		if (yych <= 'T') goto yy678;
		if (yych == 't') goto yy678;
		goto yy56;
	}
yy712:
	YYDEBUG(712, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy678;
	if (yych == 'g') goto yy678;
	goto yy56;
yy713:
	YYDEBUG(713, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy678;
	if (yych == 'r') goto yy678;
	goto yy56;
yy714:
	YYDEBUG(714, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy678;
		if (yych <= 'X') goto yy56;
		goto yy678;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
			goto yy678;
		} else {
			if (yych == 'y') goto yy678;
			goto yy56;
		}
	}
yy715:
	YYDEBUG(715, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy678;
	if (yych == 'b') goto yy678;
	goto yy56;
yy716:
	YYDEBUG(716, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy678;
		if (yych <= 'M') goto yy56;
		goto yy678;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy678;
		} else {
			if (yych == 'n') goto yy678;
			goto yy56;
		}
	}
yy717:
	YYDEBUG(717, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy678;
	if (yych == 'n') goto yy678;
	goto yy56;
yy718:
	YYDEBUG(718, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy727;
	goto yy56;
yy719:
	YYDEBUG(719, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy727;
	goto yy56;
yy720:
	YYDEBUG(720, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy727;
	goto yy56;
yy721:
	YYDEBUG(721, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy727;
	goto yy56;
yy722:
	YYDEBUG(722, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(723, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy666;
	if (yych >= ':') goto yy666;
	YYDEBUG(724, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy666;
	if (yych >= ':') goto yy666;
	YYDEBUG(725, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy666;
	if (yych >= ':') goto yy666;
	YYDEBUG(726, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy666;
yy727:
	YYDEBUG(727, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '/') goto yy722;
	goto yy666;
yy728:
	YYDEBUG(728, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') {
		if (yych == '\t') goto yy730;
		goto yy577;
	} else {
		if (yych <= '-') goto yy731;
		if (yych <= '.') goto yy730;
		if (yych >= '0') goto yy577;
	}
yy729:
	YYDEBUG(729, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case 'A':
	case 'a':	goto yy672;
	case 'D':
	case 'd':	goto yy676;
	case 'F':
	case 'f':	goto yy670;
	case 'J':
	case 'j':	goto yy669;
	case 'M':
	case 'm':	goto yy671;
	case 'N':
	case 'n':	goto yy675;
	case 'O':
	case 'o':	goto yy674;
	case 'S':
	case 's':	goto yy673;
	default:	goto yy56;
	}
yy730:
	YYDEBUG(730, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy577;
	if (yych <= '0') goto yy735;
	if (yych <= '1') goto yy736;
	if (yych <= '9') goto yy737;
	goto yy577;
yy731:
	YYDEBUG(731, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy577;
	if (yych <= '0') goto yy732;
	if (yych <= '1') goto yy733;
	if (yych <= '9') goto yy734;
	goto yy577;
yy732:
	YYDEBUG(732, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '.') goto yy601;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy734;
	goto yy56;
yy733:
	YYDEBUG(733, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '.') goto yy601;
	if (yych <= '/') goto yy56;
	if (yych >= '3') goto yy56;
yy734:
	YYDEBUG(734, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '.') goto yy601;
	goto yy56;
yy735:
	YYDEBUG(735, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy601;
		goto yy738;
	} else {
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy737;
		goto yy56;
	}
yy736:
	YYDEBUG(736, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy601;
		goto yy738;
	} else {
		if (yych <= '/') goto yy56;
		if (yych >= '3') goto yy56;
	}
yy737:
	YYDEBUG(737, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '-') goto yy601;
	if (yych >= '/') goto yy56;
yy738:
	YYDEBUG(738, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(739, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy610;
	goto yy56;
yy740:
	YYDEBUG(740, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy784;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy782;
	goto yy60;
yy741:
	YYDEBUG(741, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case '0':	goto yy750;
	case '1':	goto yy751;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy752;
	case 'A':
	case 'a':	goto yy745;
	case 'D':
	case 'd':	goto yy749;
	case 'F':
	case 'f':	goto yy743;
	case 'J':
	case 'j':	goto yy742;
	case 'M':
	case 'm':	goto yy744;
	case 'N':
	case 'n':	goto yy748;
	case 'O':
	case 'o':	goto yy747;
	case 'S':
	case 's':	goto yy746;
	default:	goto yy56;
	}
yy742:
	YYDEBUG(742, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy781;
		if (yych <= 'T') goto yy56;
		goto yy780;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy781;
		} else {
			if (yych == 'u') goto yy780;
			goto yy56;
		}
	}
yy743:
	YYDEBUG(743, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy779;
	if (yych == 'e') goto yy779;
	goto yy56;
yy744:
	YYDEBUG(744, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy778;
	if (yych == 'a') goto yy778;
	goto yy56;
yy745:
	YYDEBUG(745, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy777;
		if (yych <= 'T') goto yy56;
		goto yy776;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy777;
		} else {
			if (yych == 'u') goto yy776;
			goto yy56;
		}
	}
yy746:
	YYDEBUG(746, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy774;
	if (yych == 'e') goto yy774;
	goto yy56;
yy747:
	YYDEBUG(747, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy773;
	if (yych == 'c') goto yy773;
	goto yy56;
yy748:
	YYDEBUG(748, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy772;
	if (yych == 'o') goto yy772;
	goto yy56;
yy749:
	YYDEBUG(749, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy764;
	if (yych == 'e') goto yy764;
	goto yy56;
yy750:
	YYDEBUG(750, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy753;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy757;
	goto yy56;
yy751:
	YYDEBUG(751, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy753;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy757;
	goto yy56;
yy752:
	YYDEBUG(752, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy56;
yy753:
	YYDEBUG(753, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy754;
	if (yych <= '3') goto yy755;
	if (yych <= '9') goto yy756;
	goto yy56;
yy754:
	YYDEBUG(754, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy656;
		if (yych <= '9') goto yy756;
		if (yych <= 'm') goto yy656;
		goto yy660;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy656;
			goto yy661;
		} else {
			if (yych <= 's') goto yy659;
			if (yych <= 't') goto yy662;
			goto yy656;
		}
	}
yy755:
	YYDEBUG(755, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy656;
		if (yych <= '1') goto yy756;
		if (yych <= 'm') goto yy656;
		goto yy660;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy656;
			goto yy661;
		} else {
			if (yych <= 's') goto yy659;
			if (yych <= 't') goto yy662;
			goto yy656;
		}
	}
yy756:
	YYDEBUG(756, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy660;
		goto yy656;
	} else {
		if (yych <= 'r') goto yy661;
		if (yych <= 's') goto yy659;
		if (yych <= 't') goto yy662;
		goto yy656;
	}
yy757:
	YYDEBUG(757, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy56;
	YYDEBUG(758, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy56;
		if (yych >= '1') goto yy760;
	} else {
		if (yych <= '3') goto yy761;
		if (yych <= '9') goto yy756;
		goto yy56;
	}
	YYDEBUG(759, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy656;
		if (yych <= '9') goto yy762;
		if (yych <= 'm') goto yy656;
		goto yy660;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy656;
			goto yy661;
		} else {
			if (yych <= 's') goto yy659;
			if (yych <= 't') goto yy662;
			goto yy656;
		}
	}
yy760:
	YYDEBUG(760, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy656;
		if (yych <= '9') goto yy762;
		if (yych <= 'm') goto yy656;
		goto yy660;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy656;
			goto yy661;
		} else {
			if (yych <= 's') goto yy659;
			if (yych <= 't') goto yy662;
			goto yy656;
		}
	}
yy761:
	YYDEBUG(761, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy656;
		if (yych <= '1') goto yy762;
		if (yych <= 'm') goto yy656;
		goto yy660;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy656;
			goto yy661;
		} else {
			if (yych <= 's') goto yy659;
			if (yych <= 't') goto yy662;
			goto yy656;
		}
	}
yy762:
	YYDEBUG(762, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy660;
	} else {
		if (yych <= 'r') goto yy661;
		if (yych <= 's') goto yy659;
		if (yych <= 't') goto yy662;
	}
yy763:
	YYDEBUG(763, *YYCURSOR);
#line 1245 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("iso8601date2");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 12607 "parse_date.c"
yy764:
	YYDEBUG(764, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy765;
	if (yych != 'c') goto yy56;
yy765:
	YYDEBUG(765, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy56;
yy766:
	YYDEBUG(766, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy767;
	if (yych <= '2') goto yy768;
	if (yych <= '3') goto yy769;
	goto yy56;
yy767:
	YYDEBUG(767, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy770;
	goto yy56;
yy768:
	YYDEBUG(768, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy770;
	goto yy56;
yy769:
	YYDEBUG(769, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '2') goto yy56;
yy770:
	YYDEBUG(770, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(771, *YYCURSOR);
#line 1486 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 12659 "parse_date.c"
yy772:
	YYDEBUG(772, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy765;
	if (yych == 'v') goto yy765;
	goto yy56;
yy773:
	YYDEBUG(773, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy765;
	if (yych == 't') goto yy765;
	goto yy56;
yy774:
	YYDEBUG(774, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy775;
	if (yych != 'p') goto yy56;
yy775:
	YYDEBUG(775, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '-') goto yy766;
		goto yy56;
	} else {
		if (yych <= 'T') goto yy765;
		if (yych == 't') goto yy765;
		goto yy56;
	}
yy776:
	YYDEBUG(776, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy765;
	if (yych == 'g') goto yy765;
	goto yy56;
yy777:
	YYDEBUG(777, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy765;
	if (yych == 'r') goto yy765;
	goto yy56;
yy778:
	YYDEBUG(778, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy765;
		if (yych <= 'X') goto yy56;
		goto yy765;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
			goto yy765;
		} else {
			if (yych == 'y') goto yy765;
			goto yy56;
		}
	}
yy779:
	YYDEBUG(779, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy765;
	if (yych == 'b') goto yy765;
	goto yy56;
yy780:
	YYDEBUG(780, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy765;
		if (yych <= 'M') goto yy56;
		goto yy765;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy765;
		} else {
			if (yych == 'n') goto yy765;
			goto yy56;
		}
	}
yy781:
	YYDEBUG(781, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy765;
	if (yych == 'n') goto yy765;
	goto yy56;
yy782:
	YYDEBUG(782, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'n':
	case 'o':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy790;
	case '-':	goto yy787;
	case '.':	goto yy791;
	case '/':	goto yy788;
	case '0':	goto yy804;
	case '1':	goto yy805;
	case '2':	goto yy807;
	case '3':	goto yy808;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy54;
	case ':':	goto yy806;
	case 'W':	goto yy809;
	default:	goto yy783;
	}
yy783:
	YYDEBUG(783, *YYCURSOR);
#line 1521 "parse_date.re"
	{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 12805 "parse_date.c"
yy784:
	YYDEBUG(784, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case '0':	goto yy785;
	case '1':	goto yy786;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy752;
	case 'A':
	case 'a':	goto yy745;
	case 'D':
	case 'd':	goto yy749;
	case 'F':
	case 'f':	goto yy743;
	case 'J':
	case 'j':	goto yy742;
	case 'M':
	case 'm':	goto yy744;
	case 'N':
	case 'n':	goto yy748;
	case 'O':
	case 'o':	goto yy747;
	case 'S':
	case 's':	goto yy746;
	default:	goto yy56;
	}
yy785:
	YYDEBUG(785, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy753;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy752;
	goto yy56;
yy786:
	YYDEBUG(786, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy753;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy752;
	goto yy56;
yy787:
	YYDEBUG(787, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case '0':	goto yy972;
	case '1':	goto yy974;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy975;
	case 'A':
	case 'a':	goto yy966;
	case 'D':
	case 'd':	goto yy970;
	case 'F':
	case 'f':	goto yy964;
	case 'J':
	case 'j':	goto yy963;
	case 'M':
	case 'm':	goto yy965;
	case 'N':
	case 'n':	goto yy969;
	case 'O':
	case 'o':	goto yy968;
	case 'S':
	case 's':	goto yy967;
	case 'W':	goto yy971;
	default:	goto yy938;
	}
yy788:
	YYDEBUG(788, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy946;
	if (yych <= '1') goto yy947;
	if (yych <= '9') goto yy948;
	goto yy56;
yy789:
	YYDEBUG(789, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy790:
	YYDEBUG(790, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':
	case ' ':	goto yy789;
	case '-':
	case '.':	goto yy937;
	case 'A':
	case 'a':	goto yy799;
	case 'D':
	case 'd':	goto yy803;
	case 'F':
	case 'f':	goto yy797;
	case 'H':
	case 'h':	goto yy63;
	case 'I':	goto yy792;
	case 'J':
	case 'j':	goto yy796;
	case 'M':
	case 'm':	goto yy798;
	case 'N':
	case 'n':	goto yy802;
	case 'O':
	case 'o':	goto yy801;
	case 'S':
	case 's':	goto yy800;
	case 'T':
	case 't':	goto yy68;
	case 'V':	goto yy794;
	case 'W':
	case 'w':	goto yy67;
	case 'X':	goto yy795;
	case 'Y':
	case 'y':	goto yy66;
	default:	goto yy56;
	}
yy791:
	YYDEBUG(791, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy938;
	if (yych <= '0') goto yy930;
	if (yych <= '2') goto yy931;
	if (yych <= '3') goto yy932;
	goto yy938;
yy792:
	YYDEBUG(792, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'U') {
		if (yych == 'I') goto yy929;
	} else {
		if (yych == 'W') goto yy793;
		if (yych <= 'X') goto yy883;
	}
yy793:
	YYDEBUG(793, *YYCURSOR);
#line 1342 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 12969 "parse_date.c"
yy794:
	YYDEBUG(794, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy927;
	goto yy793;
yy795:
	YYDEBUG(795, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy926;
	goto yy793;
yy796:
	YYDEBUG(796, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy919;
		if (yych <= 'T') goto yy56;
		goto yy918;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy919;
		} else {
			if (yych == 'u') goto yy918;
			goto yy56;
		}
	}
yy797:
	YYDEBUG(797, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy912;
			goto yy56;
		} else {
			if (yych <= 'O') goto yy98;
			if (yych <= 'Q') goto yy56;
			goto yy97;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy912;
			goto yy56;
		} else {
			if (yych <= 'o') goto yy98;
			if (yych == 'r') goto yy97;
			goto yy56;
		}
	}
yy798:
	YYDEBUG(798, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'A') goto yy909;
			goto yy56;
		} else {
			if (yych <= 'I') goto yy117;
			if (yych <= 'N') goto yy56;
			goto yy116;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'a') goto yy909;
			goto yy56;
		} else {
			if (yych <= 'i') goto yy117;
			if (yych == 'o') goto yy116;
			goto yy56;
		}
	}
yy799:
	YYDEBUG(799, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy903;
		if (yych <= 'T') goto yy56;
		goto yy902;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy903;
		} else {
			if (yych == 'u') goto yy902;
			goto yy56;
		}
	}
yy800:
	YYDEBUG(800, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy126;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy895;
			if (yych <= 'T') goto yy56;
			goto yy125;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy126;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy895;
			if (yych == 'u') goto yy125;
			goto yy56;
		}
	}
yy801:
	YYDEBUG(801, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy890;
	if (yych == 'c') goto yy890;
	goto yy56;
yy802:
	YYDEBUG(802, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy884;
	if (yych == 'o') goto yy884;
	goto yy56;
yy803:
	YYDEBUG(803, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy113;
		if (yych <= 'D') goto yy56;
		goto yy877;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy113;
		} else {
			if (yych == 'e') goto yy877;
			goto yy56;
		}
	}
yy804:
	YYDEBUG(804, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '0') goto yy874;
	if (yych <= '9') goto yy875;
	goto yy60;
yy805:
	YYDEBUG(805, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '2') goto yy843;
	if (yych <= '9') goto yy822;
	goto yy60;
yy806:
	YYDEBUG(806, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy823;
	if (yych <= '1') goto yy824;
	goto yy56;
yy807:
	YYDEBUG(807, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy822;
	goto yy60;
yy808:
	YYDEBUG(808, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '5') goto yy818;
	if (yych <= '6') goto yy819;
	if (yych <= '9') goto yy54;
	goto yy60;
yy809:
	YYDEBUG(809, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy56;
		if (yych <= '0') goto yy810;
		if (yych <= '4') goto yy811;
		goto yy812;
	} else {
		if (yych <= 'E') {
			if (yych <= 'D') goto yy56;
			goto yy82;
		} else {
			if (yych == 'e') goto yy82;
			goto yy56;
		}
	}
yy810:
	YYDEBUG(810, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy56;
	if (yych <= '9') goto yy813;
	goto yy56;
yy811:
	YYDEBUG(811, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy813;
	goto yy56;
yy812:
	YYDEBUG(812, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '4') goto yy56;
yy813:
	YYDEBUG(813, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy815;
	if (yych <= '/') goto yy814;
	if (yych <= '7') goto yy816;
yy814:
	YYDEBUG(814, *YYCURSOR);
#line 1453 "parse_date.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();

		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 13202 "parse_date.c"
yy815:
	YYDEBUG(815, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '8') goto yy56;
yy816:
	YYDEBUG(816, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(817, *YYCURSOR);
#line 1434 "parse_date.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();

		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = timelib_get_nr((char **) &ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 13230 "parse_date.c"
yy818:
	YYDEBUG(818, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy820;
	goto yy60;
yy819:
	YYDEBUG(819, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '6') goto yy820;
	if (yych <= '9') goto yy54;
	goto yy60;
yy820:
	YYDEBUG(820, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych >= ' ') goto yy60;
			} else {
				if (yych == 'D') goto yy60;
				if (yych >= 'F') goto yy60;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy60;
				if (yych >= 'M') goto yy60;
			} else {
				if (yych <= 'R') goto yy821;
				if (yych <= 'T') goto yy60;
				if (yych >= 'W') goto yy60;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych >= 'd') goto yy60;
			} else {
				if (yych == 'f') goto yy60;
				if (yych >= 'h') goto yy60;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych >= 's') goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy60;
				} else {
					if (yych == 'y') goto yy60;
				}
			}
		}
	}
yy821:
	YYDEBUG(821, *YYCURSOR);
#line 1420 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->d = timelib_get_nr((char **) &ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
#line 13307 "parse_date.c"
yy822:
	YYDEBUG(822, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy820;
	goto yy60;
yy823:
	YYDEBUG(823, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy825;
	goto yy56;
yy824:
	YYDEBUG(824, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '3') goto yy56;
yy825:
	YYDEBUG(825, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	YYDEBUG(826, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy827;
	if (yych <= '2') goto yy828;
	if (yych <= '3') goto yy829;
	goto yy56;
yy827:
	YYDEBUG(827, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy830;
	goto yy56;
yy828:
	YYDEBUG(828, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy830;
	goto yy56;
yy829:
	YYDEBUG(829, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '2') goto yy56;
yy830:
	YYDEBUG(830, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy56;
	YYDEBUG(831, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy832;
	if (yych <= '2') goto yy833;
	goto yy56;
yy832:
	YYDEBUG(832, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy834;
	goto yy56;
yy833:
	YYDEBUG(833, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '5') goto yy56;
yy834:
	YYDEBUG(834, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	YYDEBUG(835, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '6') goto yy56;
	YYDEBUG(836, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(837, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	YYDEBUG(838, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy839;
	if (yych <= '6') goto yy840;
	goto yy56;
yy839:
	YYDEBUG(839, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy841;
	goto yy56;
yy840:
	YYDEBUG(840, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy56;
yy841:
	YYDEBUG(841, *YYCURSOR);
	++YYCURSOR;
yy842:
	YYDEBUG(842, *YYCURSOR);
#line 1394 "parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx | exif");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '.') {
			s->time->f = timelib_get_frac_nr((char **) &ptr, 9);
			if (*ptr) { /* timezone is optional */
				s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
				if (tz_not_found) {
					add_error(s, "The timezone could not be found in the database");
				}
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
#line 13435 "parse_date.c"
yy843:
	YYDEBUG(843, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy60;
		if (yych >= '1') goto yy845;
	} else {
		if (yych <= '3') goto yy846;
		if (yych <= '9') goto yy820;
		goto yy60;
	}
yy844:
	YYDEBUG(844, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy821;
				goto yy60;
			} else {
				if (yych <= '/') goto yy821;
				if (yych <= '9') goto yy847;
				if (yych <= 'C') goto yy821;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy821;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy821;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy821;
					if (yych <= 'T') goto yy60;
					goto yy821;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy821;
				if (yych <= 'Y') goto yy60;
				goto yy821;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy821;
				} else {
					if (yych == 'g') goto yy821;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy821;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy821;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy821;
				}
			}
		}
	}
yy845:
	YYDEBUG(845, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy821;
				goto yy60;
			} else {
				if (yych <= '/') goto yy821;
				if (yych <= '9') goto yy847;
				if (yych <= 'C') goto yy821;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy821;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy821;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy821;
					if (yych <= 'T') goto yy60;
					goto yy821;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy821;
				if (yych <= 'Y') goto yy60;
				goto yy821;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy821;
				} else {
					if (yych == 'g') goto yy821;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy821;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy821;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy821;
				}
			}
		}
	}
yy846:
	YYDEBUG(846, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy821;
				goto yy60;
			} else {
				if (yych <= '1') {
					if (yych <= '/') goto yy821;
				} else {
					if (yych <= '9') goto yy54;
					if (yych <= 'C') goto yy821;
					goto yy60;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy821;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy821;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy821;
					if (yych <= 'T') goto yy60;
					goto yy821;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy821;
				if (yych <= 'Y') goto yy60;
				goto yy821;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy821;
				} else {
					if (yych == 'g') goto yy821;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy821;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy821;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy821;
				}
			}
		}
	}
yy847:
	YYDEBUG(847, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych >= ' ') goto yy59;
			} else {
				if (yych == 'D') goto yy64;
				if (yych >= 'F') goto yy65;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy63;
				if (yych >= 'M') goto yy62;
			} else {
				if (yych <= 'S') {
					if (yych >= 'S') goto yy61;
				} else {
					if (yych <= 'T') goto yy849;
					if (yych >= 'W') goto yy67;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy66;
				if (yych >= 'd') goto yy64;
			} else {
				if (yych <= 'f') {
					if (yych >= 'f') goto yy65;
				} else {
					if (yych == 'h') goto yy63;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy62;
				if (yych <= 'r') goto yy848;
				if (yych <= 's') goto yy61;
				goto yy850;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy67;
				} else {
					if (yych == 'y') goto yy66;
				}
			}
		}
	}
yy848:
	YYDEBUG(848, *YYCURSOR);
#line 1382 "parse_date.re"
	{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
#line 13708 "parse_date.c"
yy849:
	YYDEBUG(849, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy56;
			if (yych <= '1') goto yy864;
			goto yy865;
		} else {
			if (yych <= '9') goto yy866;
			if (yych <= 'G') goto yy56;
			goto yy69;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy70;
			goto yy56;
		} else {
			if (yych <= 'h') goto yy69;
			if (yych == 'u') goto yy70;
			goto yy56;
		}
	}
yy850:
	YYDEBUG(850, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy56;
			if (yych >= '2') goto yy852;
		} else {
			if (yych <= '9') goto yy853;
			if (yych <= 'G') goto yy56;
			goto yy69;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy70;
			goto yy56;
		} else {
			if (yych <= 'h') goto yy69;
			if (yych == 'u') goto yy70;
			goto yy56;
		}
	}
	YYDEBUG(851, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy858;
	if (yych <= '9') goto yy853;
	goto yy56;
yy852:
	YYDEBUG(852, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '4') goto yy858;
	if (yych <= '5') goto yy854;
	goto yy56;
yy853:
	YYDEBUG(853, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '6') goto yy56;
yy854:
	YYDEBUG(854, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy855:
	YYDEBUG(855, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy856;
	if (yych <= '6') goto yy857;
	goto yy56;
yy856:
	YYDEBUG(856, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy841;
	goto yy56;
yy857:
	YYDEBUG(857, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy841;
	goto yy56;
yy858:
	YYDEBUG(858, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy859;
	if (yych <= '9') goto yy855;
	goto yy56;
yy859:
	YYDEBUG(859, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy860;
	if (yych <= '6') goto yy861;
	if (yych <= '9') goto yy855;
	goto yy56;
yy860:
	YYDEBUG(860, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy862;
	if (yych <= '6') goto yy863;
	if (yych <= '9') goto yy841;
	goto yy56;
yy861:
	YYDEBUG(861, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy862;
	if (yych <= '5') goto yy856;
	if (yych <= '6') goto yy857;
	goto yy56;
yy862:
	YYDEBUG(862, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy842;
	if (yych <= '9') goto yy841;
	goto yy842;
yy863:
	YYDEBUG(863, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy841;
	goto yy842;
yy864:
	YYDEBUG(864, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy873;
	if (yych <= '9') goto yy866;
	if (yych <= ':') goto yy867;
	goto yy56;
yy865:
	YYDEBUG(865, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy56;
		if (yych <= '4') goto yy873;
		goto yy854;
	} else {
		if (yych == ':') goto yy867;
		goto yy56;
	}
yy866:
	YYDEBUG(866, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy854;
	if (yych != ':') goto yy56;
yy867:
	YYDEBUG(867, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '6') goto yy56;
	YYDEBUG(868, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(869, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	YYDEBUG(870, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy871;
	if (yych <= '6') goto yy872;
	goto yy56;
yy871:
	YYDEBUG(871, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy841;
	goto yy56;
yy872:
	YYDEBUG(872, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy841;
	goto yy56;
yy873:
	YYDEBUG(873, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy859;
	if (yych <= '9') goto yy855;
	if (yych <= ':') goto yy867;
	goto yy56;
yy874:
	YYDEBUG(874, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy60;
		if (yych <= '0') goto yy876;
		goto yy845;
	} else {
		if (yych <= '3') goto yy846;
		if (yych <= '9') goto yy820;
		goto yy60;
	}
yy875:
	YYDEBUG(875, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy60;
		if (yych <= '0') goto yy844;
		goto yy845;
	} else {
		if (yych <= '3') goto yy846;
		if (yych <= '9') goto yy820;
		goto yy60;
	}
yy876:
	YYDEBUG(876, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy847;
	goto yy60;
yy877:
	YYDEBUG(877, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy878;
	if (yych != 'c') goto yy56;
yy878:
	YYDEBUG(878, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy879;
	if (yych != 'e') goto yy793;
yy879:
	YYDEBUG(879, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy880;
	if (yych != 'm') goto yy56;
yy880:
	YYDEBUG(880, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy881;
	if (yych != 'b') goto yy56;
yy881:
	YYDEBUG(881, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy882;
	if (yych != 'e') goto yy56;
yy882:
	YYDEBUG(882, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy883;
	if (yych != 'r') goto yy56;
yy883:
	YYDEBUG(883, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy793;
yy884:
	YYDEBUG(884, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy885;
	if (yych != 'v') goto yy56;
yy885:
	YYDEBUG(885, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy886;
	if (yych != 'e') goto yy793;
yy886:
	YYDEBUG(886, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy887;
	if (yych != 'm') goto yy56;
yy887:
	YYDEBUG(887, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy888;
	if (yych != 'b') goto yy56;
yy888:
	YYDEBUG(888, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy889;
	if (yych != 'e') goto yy56;
yy889:
	YYDEBUG(889, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy883;
	if (yych == 'r') goto yy883;
	goto yy56;
yy890:
	YYDEBUG(890, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy891;
	if (yych != 't') goto yy56;
yy891:
	YYDEBUG(891, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'O') goto yy892;
	if (yych != 'o') goto yy793;
yy892:
	YYDEBUG(892, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy893;
	if (yych != 'b') goto yy56;
yy893:
	YYDEBUG(893, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy894;
	if (yych != 'e') goto yy56;
yy894:
	YYDEBUG(894, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy883;
	if (yych == 'r') goto yy883;
	goto yy56;
yy895:
	YYDEBUG(895, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy128;
		if (yych <= 'O') goto yy56;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy56;
			goto yy128;
		} else {
			if (yych != 'p') goto yy56;
		}
	}
yy896:
	YYDEBUG(896, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy897;
	if (yych != 't') goto yy793;
yy897:
	YYDEBUG(897, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy898;
	if (yych != 'e') goto yy793;
yy898:
	YYDEBUG(898, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy899;
	if (yych != 'm') goto yy56;
yy899:
	YYDEBUG(899, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy900;
	if (yych != 'b') goto yy56;
yy900:
	YYDEBUG(900, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy901;
	if (yych != 'e') goto yy56;
yy901:
	YYDEBUG(901, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy883;
	if (yych == 'r') goto yy883;
	goto yy56;
yy902:
	YYDEBUG(902, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy906;
	if (yych == 'g') goto yy906;
	goto yy56;
yy903:
	YYDEBUG(903, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy904;
	if (yych != 'r') goto yy56;
yy904:
	YYDEBUG(904, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'I') goto yy905;
	if (yych != 'i') goto yy793;
yy905:
	YYDEBUG(905, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy883;
	if (yych == 'l') goto yy883;
	goto yy56;
yy906:
	YYDEBUG(906, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy907;
	if (yych != 'u') goto yy793;
yy907:
	YYDEBUG(907, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy908;
	if (yych != 's') goto yy56;
yy908:
	YYDEBUG(908, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy883;
	if (yych == 't') goto yy883;
	goto yy56;
yy909:
	YYDEBUG(909, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy910;
		if (yych <= 'X') goto yy56;
		goto yy883;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
		} else {
			if (yych == 'y') goto yy883;
			goto yy56;
		}
	}
yy910:
	YYDEBUG(910, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'C') goto yy911;
	if (yych != 'c') goto yy793;
yy911:
	YYDEBUG(911, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy883;
	if (yych == 'h') goto yy883;
	goto yy56;
yy912:
	YYDEBUG(912, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy913;
	if (yych != 'b') goto yy56;
yy913:
	YYDEBUG(913, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy914;
	if (yych != 'r') goto yy793;
yy914:
	YYDEBUG(914, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy915;
	if (yych != 'u') goto yy56;
yy915:
	YYDEBUG(915, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy916;
	if (yych != 'a') goto yy56;
yy916:
	YYDEBUG(916, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy917;
	if (yych != 'r') goto yy56;
yy917:
	YYDEBUG(917, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy883;
	if (yych == 'y') goto yy883;
	goto yy56;
yy918:
	YYDEBUG(918, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy925;
		if (yych <= 'M') goto yy56;
		goto yy924;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy925;
		} else {
			if (yych == 'n') goto yy924;
			goto yy56;
		}
	}
yy919:
	YYDEBUG(919, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy920;
	if (yych != 'n') goto yy56;
yy920:
	YYDEBUG(920, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy921;
	if (yych != 'u') goto yy793;
yy921:
	YYDEBUG(921, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy922;
	if (yych != 'a') goto yy56;
yy922:
	YYDEBUG(922, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy923;
	if (yych != 'r') goto yy56;
yy923:
	YYDEBUG(923, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy883;
	if (yych == 'y') goto yy883;
	goto yy56;
yy924:
	YYDEBUG(924, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy883;
	if (yych == 'e') goto yy883;
	goto yy793;
yy925:
	YYDEBUG(925, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy883;
	if (yych == 'y') goto yy883;
	goto yy793;
yy926:
	YYDEBUG(926, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy883;
	goto yy793;
yy927:
	YYDEBUG(927, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'I') goto yy793;
	YYDEBUG(928, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy883;
	goto yy793;
yy929:
	YYDEBUG(929, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy883;
	goto yy793;
yy930:
	YYDEBUG(930, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy945;
	if (yych <= '9') goto yy944;
	goto yy56;
yy931:
	YYDEBUG(931, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy943;
	goto yy56;
yy932:
	YYDEBUG(932, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy941;
	if (yych <= '6') goto yy940;
	goto yy56;
yy933:
	YYDEBUG(933, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy912;
	if (yych == 'e') goto yy912;
	goto yy56;
yy934:
	YYDEBUG(934, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy909;
	if (yych == 'a') goto yy909;
	goto yy56;
yy935:
	YYDEBUG(935, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy939;
	if (yych == 'e') goto yy939;
	goto yy56;
yy936:
	YYDEBUG(936, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy877;
	if (yych == 'e') goto yy877;
	goto yy56;
yy937:
	YYDEBUG(937, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy938:
	YYDEBUG(938, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy937;
	case 'A':
	case 'a':	goto yy799;
	case 'D':
	case 'd':	goto yy936;
	case 'F':
	case 'f':	goto yy933;
	case 'I':	goto yy792;
	case 'J':
	case 'j':	goto yy796;
	case 'M':
	case 'm':	goto yy934;
	case 'N':
	case 'n':	goto yy802;
	case 'O':
	case 'o':	goto yy801;
	case 'S':
	case 's':	goto yy935;
	case 'V':	goto yy794;
	case 'X':	goto yy795;
	default:	goto yy56;
	}
yy939:
	YYDEBUG(939, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy896;
	if (yych == 'p') goto yy896;
	goto yy56;
yy940:
	YYDEBUG(940, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '6') goto yy942;
	goto yy56;
yy941:
	YYDEBUG(941, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy942:
	YYDEBUG(942, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy821;
yy943:
	YYDEBUG(943, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy942;
	goto yy56;
yy944:
	YYDEBUG(944, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy942;
	goto yy56;
yy945:
	YYDEBUG(945, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy56;
	if (yych <= '9') goto yy942;
	goto yy56;
yy946:
	YYDEBUG(946, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy56;
	if (yych <= '/') goto yy949;
	if (yych <= '9') goto yy957;
	goto yy56;
yy947:
	YYDEBUG(947, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy56;
	if (yych <= '/') goto yy949;
	if (yych <= '2') goto yy957;
	goto yy56;
yy948:
	YYDEBUG(948, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '/') goto yy56;
yy949:
	YYDEBUG(949, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy950;
	if (yych <= '3') goto yy951;
	if (yych <= '9') goto yy952;
	goto yy56;
yy950:
	YYDEBUG(950, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy454;
		if (yych <= '9') goto yy952;
		if (yych <= 'm') goto yy454;
		goto yy954;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy454;
			goto yy955;
		} else {
			if (yych <= 's') goto yy953;
			if (yych <= 't') goto yy956;
			goto yy454;
		}
	}
yy951:
	YYDEBUG(951, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy454;
		if (yych <= '1') goto yy952;
		if (yych <= 'm') goto yy454;
		goto yy954;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy454;
			goto yy955;
		} else {
			if (yych <= 's') goto yy953;
			if (yych <= 't') goto yy956;
			goto yy454;
		}
	}
yy952:
	YYDEBUG(952, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy954;
		goto yy454;
	} else {
		if (yych <= 'r') goto yy955;
		if (yych <= 's') goto yy953;
		if (yych <= 't') goto yy956;
		goto yy454;
	}
yy953:
	YYDEBUG(953, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy453;
	goto yy56;
yy954:
	YYDEBUG(954, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy453;
	goto yy56;
yy955:
	YYDEBUG(955, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy453;
	goto yy56;
yy956:
	YYDEBUG(956, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy453;
	goto yy56;
yy957:
	YYDEBUG(957, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '/') goto yy56;
	YYDEBUG(958, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy56;
		if (yych >= '1') goto yy960;
	} else {
		if (yych <= '3') goto yy961;
		if (yych <= '9') goto yy952;
		goto yy56;
	}
	YYDEBUG(959, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy454;
		if (yych <= '9') goto yy962;
		if (yych <= 'm') goto yy454;
		goto yy954;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy454;
			goto yy955;
		} else {
			if (yych <= 's') goto yy953;
			if (yych <= 't') goto yy956;
			goto yy454;
		}
	}
yy960:
	YYDEBUG(960, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy454;
		if (yych <= '9') goto yy962;
		if (yych <= 'm') goto yy454;
		goto yy954;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy454;
			goto yy955;
		} else {
			if (yych <= 's') goto yy953;
			if (yych <= 't') goto yy956;
			goto yy454;
		}
	}
yy961:
	YYDEBUG(961, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy454;
		if (yych <= '1') goto yy962;
		if (yych <= 'm') goto yy454;
		goto yy954;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy454;
			goto yy955;
		} else {
			if (yych <= 's') goto yy953;
			if (yych <= 't') goto yy956;
			goto yy454;
		}
	}
yy962:
	YYDEBUG(962, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy453;
		if (yych <= 'm') goto yy454;
		goto yy954;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy454;
			goto yy955;
		} else {
			if (yych <= 's') goto yy953;
			if (yych <= 't') goto yy956;
			goto yy454;
		}
	}
yy963:
	YYDEBUG(963, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy1043;
		if (yych <= 'T') goto yy56;
		goto yy1042;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy1043;
		} else {
			if (yych == 'u') goto yy1042;
			goto yy56;
		}
	}
yy964:
	YYDEBUG(964, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1040;
	if (yych == 'e') goto yy1040;
	goto yy56;
yy965:
	YYDEBUG(965, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1037;
	if (yych == 'a') goto yy1037;
	goto yy56;
yy966:
	YYDEBUG(966, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy1034;
		if (yych <= 'T') goto yy56;
		goto yy1033;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy1034;
		} else {
			if (yych == 'u') goto yy1033;
			goto yy56;
		}
	}
yy967:
	YYDEBUG(967, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1030;
	if (yych == 'e') goto yy1030;
	goto yy56;
yy968:
	YYDEBUG(968, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1028;
	if (yych == 'c') goto yy1028;
	goto yy56;
yy969:
	YYDEBUG(969, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1026;
	if (yych == 'o') goto yy1026;
	goto yy56;
yy970:
	YYDEBUG(970, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1024;
	if (yych == 'e') goto yy1024;
	goto yy56;
yy971:
	YYDEBUG(971, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy810;
	if (yych <= '4') goto yy811;
	if (yych <= '5') goto yy812;
	goto yy56;
yy972:
	YYDEBUG(972, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy976;
	if (yych <= '/') goto yy973;
	if (yych <= '9') goto yy995;
yy973:
	YYDEBUG(973, *YYCURSOR);
#line 1259 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("gnudateshorter");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 14641 "parse_date.c"
yy974:
	YYDEBUG(974, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy976;
	if (yych <= '/') goto yy973;
	if (yych <= '2') goto yy995;
	goto yy973;
yy975:
	YYDEBUG(975, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '-') goto yy973;
yy976:
	YYDEBUG(976, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy977;
	if (yych <= '3') goto yy978;
	if (yych <= '9') goto yy979;
	goto yy56;
yy977:
	YYDEBUG(977, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy656;
			goto yy979;
		} else {
			if (yych == 'T') goto yy984;
			goto yy656;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy981;
			if (yych <= 'q') goto yy656;
			goto yy982;
		} else {
			if (yych <= 's') goto yy980;
			if (yych <= 't') goto yy983;
			goto yy656;
		}
	}
yy978:
	YYDEBUG(978, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy656;
		} else {
			if (yych == 'T') goto yy984;
			goto yy656;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy981;
			if (yych <= 'q') goto yy656;
			goto yy982;
		} else {
			if (yych <= 's') goto yy980;
			if (yych <= 't') goto yy983;
			goto yy656;
		}
	}
yy979:
	YYDEBUG(979, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy984;
		if (yych <= 'm') goto yy656;
		goto yy981;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy656;
			goto yy982;
		} else {
			if (yych <= 's') goto yy980;
			if (yych <= 't') goto yy983;
			goto yy656;
		}
	}
yy980:
	YYDEBUG(980, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy994;
	goto yy56;
yy981:
	YYDEBUG(981, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy994;
	goto yy56;
yy982:
	YYDEBUG(982, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy994;
	goto yy56;
yy983:
	YYDEBUG(983, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy994;
	goto yy56;
yy984:
	YYDEBUG(984, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy985;
	if (yych <= '2') goto yy986;
	if (yych <= '9') goto yy987;
	goto yy56;
yy985:
	YYDEBUG(985, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy987;
	if (yych <= ':') goto yy988;
	goto yy56;
yy986:
	YYDEBUG(986, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '4') goto yy987;
	if (yych == ':') goto yy988;
	goto yy56;
yy987:
	YYDEBUG(987, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
yy988:
	YYDEBUG(988, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy989;
	if (yych <= '9') goto yy990;
	goto yy56;
yy989:
	YYDEBUG(989, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy990;
	if (yych <= ':') goto yy991;
	goto yy56;
yy990:
	YYDEBUG(990, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
yy991:
	YYDEBUG(991, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy992;
	if (yych <= '6') goto yy993;
	if (yych <= '9') goto yy841;
	goto yy56;
yy992:
	YYDEBUG(992, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy842;
	if (yych <= '9') goto yy841;
	goto yy842;
yy993:
	YYDEBUG(993, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy841;
	goto yy842;
yy994:
	YYDEBUG(994, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'T') goto yy984;
	goto yy656;
yy995:
	YYDEBUG(995, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '-') goto yy973;
	YYDEBUG(996, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy56;
		if (yych >= '1') goto yy998;
	} else {
		if (yych <= '3') goto yy999;
		if (yych <= '9') goto yy979;
		goto yy56;
	}
	YYDEBUG(997, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy656;
			goto yy1000;
		} else {
			if (yych == 'T') goto yy984;
			goto yy656;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy981;
			if (yych <= 'q') goto yy656;
			goto yy982;
		} else {
			if (yych <= 's') goto yy980;
			if (yych <= 't') goto yy983;
			goto yy656;
		}
	}
yy998:
	YYDEBUG(998, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy656;
			goto yy1000;
		} else {
			if (yych == 'T') goto yy984;
			goto yy656;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy981;
			if (yych <= 'q') goto yy656;
			goto yy982;
		} else {
			if (yych <= 's') goto yy980;
			if (yych <= 't') goto yy983;
			goto yy656;
		}
	}
yy999:
	YYDEBUG(999, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy656;
		} else {
			if (yych == 'T') goto yy984;
			goto yy656;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy981;
			if (yych <= 'q') goto yy656;
			goto yy982;
		} else {
			if (yych <= 's') goto yy980;
			if (yych <= 't') goto yy983;
			goto yy656;
		}
	}
yy1000:
	YYDEBUG(1000, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy1001;
		if (yych <= 'm') goto yy454;
		goto yy981;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy454;
			goto yy982;
		} else {
			if (yych <= 's') goto yy980;
			if (yych <= 't') goto yy983;
			goto yy454;
		}
	}
yy1001:
	YYDEBUG(1001, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1002;
	if (yych <= '2') goto yy1003;
	if (yych <= '9') goto yy987;
	goto yy56;
yy1002:
	YYDEBUG(1002, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1004;
	if (yych <= ':') goto yy988;
	goto yy56;
yy1003:
	YYDEBUG(1003, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '4') goto yy1004;
	if (yych == ':') goto yy988;
	goto yy56;
yy1004:
	YYDEBUG(1004, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	YYDEBUG(1005, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1006;
	if (yych <= '9') goto yy990;
	goto yy56;
yy1006:
	YYDEBUG(1006, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1007;
	if (yych <= ':') goto yy991;
	goto yy56;
yy1007:
	YYDEBUG(1007, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	YYDEBUG(1008, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1009;
	if (yych <= '6') goto yy1010;
	if (yych <= '9') goto yy841;
	goto yy56;
yy1009:
	YYDEBUG(1009, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy842;
	if (yych <= '9') goto yy1011;
	goto yy842;
yy1010:
	YYDEBUG(1010, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy842;
yy1011:
	YYDEBUG(1011, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '.') goto yy842;
	YYDEBUG(1012, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy1013:
	YYDEBUG(1013, *YYCURSOR);
	yyaccept = 23;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	YYDEBUG(1014, *YYCURSOR);
	if (yych <= '-') {
		if (yych == '+') goto yy1016;
		if (yych <= ',') goto yy842;
		goto yy1016;
	} else {
		if (yych <= '9') {
			if (yych <= '/') goto yy842;
			goto yy1013;
		} else {
			if (yych != 'G') goto yy842;
		}
	}
	YYDEBUG(1015, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1022;
	goto yy56;
yy1016:
	YYDEBUG(1016, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1017;
	if (yych <= '2') goto yy1018;
	if (yych <= '9') goto yy1019;
	goto yy56;
yy1017:
	YYDEBUG(1017, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy842;
	if (yych <= '9') goto yy1019;
	if (yych <= ':') goto yy1020;
	goto yy842;
yy1018:
	YYDEBUG(1018, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy842;
		if (yych >= '5') goto yy1021;
	} else {
		if (yych <= '9') goto yy841;
		if (yych <= ':') goto yy1020;
		goto yy842;
	}
yy1019:
	YYDEBUG(1019, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy842;
	if (yych <= '5') goto yy1021;
	if (yych <= '9') goto yy841;
	if (yych >= ';') goto yy842;
yy1020:
	YYDEBUG(1020, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy842;
	if (yych <= '5') goto yy1021;
	if (yych <= '9') goto yy841;
	goto yy842;
yy1021:
	YYDEBUG(1021, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy842;
	if (yych <= '9') goto yy841;
	goto yy842;
yy1022:
	YYDEBUG(1022, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'T') goto yy56;
	YYDEBUG(1023, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '+') goto yy1016;
	if (yych == '-') goto yy1016;
	goto yy56;
yy1024:
	YYDEBUG(1024, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1025;
	if (yych != 'c') goto yy56;
yy1025:
	YYDEBUG(1025, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy766;
		goto yy793;
	} else {
		if (yych <= 'E') goto yy879;
		if (yych == 'e') goto yy879;
		goto yy793;
	}
yy1026:
	YYDEBUG(1026, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy1027;
	if (yych != 'v') goto yy56;
yy1027:
	YYDEBUG(1027, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy766;
		goto yy793;
	} else {
		if (yych <= 'E') goto yy886;
		if (yych == 'e') goto yy886;
		goto yy793;
	}
yy1028:
	YYDEBUG(1028, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1029;
	if (yych != 't') goto yy56;
yy1029:
	YYDEBUG(1029, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == '-') goto yy766;
		goto yy793;
	} else {
		if (yych <= 'O') goto yy892;
		if (yych == 'o') goto yy892;
		goto yy793;
	}
yy1030:
	YYDEBUG(1030, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy1031;
	if (yych != 'p') goto yy56;
yy1031:
	YYDEBUG(1031, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == '-') goto yy766;
		goto yy793;
	} else {
		if (yych <= 'T') goto yy1032;
		if (yych != 't') goto yy793;
	}
yy1032:
	YYDEBUG(1032, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy766;
		goto yy793;
	} else {
		if (yych <= 'E') goto yy898;
		if (yych == 'e') goto yy898;
		goto yy793;
	}
yy1033:
	YYDEBUG(1033, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1036;
	if (yych == 'g') goto yy1036;
	goto yy56;
yy1034:
	YYDEBUG(1034, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1035;
	if (yych != 'r') goto yy56;
yy1035:
	YYDEBUG(1035, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych == '-') goto yy766;
		goto yy793;
	} else {
		if (yych <= 'I') goto yy905;
		if (yych == 'i') goto yy905;
		goto yy793;
	}
yy1036:
	YYDEBUG(1036, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy766;
		goto yy793;
	} else {
		if (yych <= 'U') goto yy907;
		if (yych == 'u') goto yy907;
		goto yy793;
	}
yy1037:
	YYDEBUG(1037, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy1038;
		if (yych <= 'X') goto yy56;
		goto yy1039;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
		} else {
			if (yych == 'y') goto yy1039;
			goto yy56;
		}
	}
yy1038:
	YYDEBUG(1038, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych == '-') goto yy766;
		goto yy793;
	} else {
		if (yych <= 'C') goto yy911;
		if (yych == 'c') goto yy911;
		goto yy793;
	}
yy1039:
	YYDEBUG(1039, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy766;
	goto yy793;
yy1040:
	YYDEBUG(1040, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1041;
	if (yych != 'b') goto yy56;
yy1041:
	YYDEBUG(1041, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == '-') goto yy766;
		goto yy793;
	} else {
		if (yych <= 'R') goto yy914;
		if (yych == 'r') goto yy914;
		goto yy793;
	}
yy1042:
	YYDEBUG(1042, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy1046;
		if (yych <= 'M') goto yy56;
		goto yy1045;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy1046;
		} else {
			if (yych == 'n') goto yy1045;
			goto yy56;
		}
	}
yy1043:
	YYDEBUG(1043, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1044;
	if (yych != 'n') goto yy56;
yy1044:
	YYDEBUG(1044, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy766;
		goto yy793;
	} else {
		if (yych <= 'U') goto yy921;
		if (yych == 'u') goto yy921;
		goto yy793;
	}
yy1045:
	YYDEBUG(1045, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy766;
		goto yy793;
	} else {
		if (yych <= 'E') goto yy883;
		if (yych == 'e') goto yy883;
		goto yy793;
	}
yy1046:
	YYDEBUG(1046, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych == '-') goto yy766;
		goto yy793;
	} else {
		if (yych <= 'Y') goto yy883;
		if (yych == 'y') goto yy883;
		goto yy793;
	}
yy1047:
	YYDEBUG(1047, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy577;
			goto yy730;
		} else {
			if (yych <= ',') goto yy577;
			if (yych <= '-') goto yy731;
			goto yy730;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '/') goto yy729;
			if (yych <= 'T') goto yy577;
			goto yy77;
		} else {
			if (yych == 'u') goto yy77;
			goto yy577;
		}
	}
yy1048:
	YYDEBUG(1048, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy128;
		if (yych <= 'O') goto yy56;
		goto yy585;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy56;
			goto yy128;
		} else {
			if (yych == 'p') goto yy585;
			goto yy56;
		}
	}
yy1049:
	YYDEBUG(1049, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych == '\t') goto yy1051;
			goto yy1053;
		} else {
			if (yych <= '-') goto yy1050;
			if (yych <= '.') goto yy730;
			if (yych <= '/') goto yy729;
			goto yy740;
		}
	} else {
		if (yych <= 'q') {
			if (yych == 'n') goto yy469;
			goto yy1053;
		} else {
			if (yych <= 'r') goto yy470;
			if (yych <= 's') goto yy463;
			if (yych <= 't') goto yy467;
			goto yy1053;
		}
	}
yy1050:
	YYDEBUG(1050, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case '0':	goto yy1054;
	case '1':	goto yy1055;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy617;
	case 'A':
	case 'a':	goto yy621;
	case 'D':
	case 'd':	goto yy625;
	case 'F':
	case 'f':	goto yy619;
	case 'J':
	case 'j':	goto yy618;
	case 'M':
	case 'm':	goto yy620;
	case 'N':
	case 'n':	goto yy624;
	case 'O':
	case 'o':	goto yy623;
	case 'S':
	case 's':	goto yy622;
	default:	goto yy577;
	}
yy1051:
	YYDEBUG(1051, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1053;
	if (yych <= '0') goto yy735;
	if (yych <= '1') goto yy736;
	if (yych <= '9') goto yy737;
	goto yy1053;
yy1052:
	YYDEBUG(1052, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy1053:
	YYDEBUG(1053, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':
	case ' ':	goto yy1052;
	case '-':
	case '.':	goto yy576;
	case 'A':
	case 'a':	goto yy573;
	case 'D':
	case 'd':	goto yy465;
	case 'F':
	case 'f':	goto yy466;
	case 'H':
	case 'h':	goto yy63;
	case 'I':	goto yy474;
	case 'J':
	case 'j':	goto yy478;
	case 'M':
	case 'm':	goto yy464;
	case 'N':
	case 'n':	goto yy481;
	case 'O':
	case 'o':	goto yy480;
	case 'S':
	case 's':	goto yy462;
	case 'T':
	case 't':	goto yy68;
	case 'V':	goto yy476;
	case 'W':
	case 'w':	goto yy67;
	case 'X':	goto yy477;
	case 'Y':
	case 'y':	goto yy66;
	default:	goto yy56;
	}
yy1054:
	YYDEBUG(1054, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy654;
		goto yy601;
	} else {
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy1056;
		goto yy56;
	}
yy1055:
	YYDEBUG(1055, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy654;
		goto yy601;
	} else {
		if (yych <= '/') goto yy56;
		if (yych >= '3') goto yy56;
	}
yy1056:
	YYDEBUG(1056, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '-') goto yy1057;
	if (yych <= '.') goto yy601;
	goto yy56;
yy1057:
	YYDEBUG(1057, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy56;
		if (yych >= '1') goto yy1059;
	} else {
		if (yych <= '3') goto yy1060;
		if (yych <= '9') goto yy658;
		goto yy56;
	}
	YYDEBUG(1058, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy656;
		if (yych <= '9') goto yy1061;
		if (yych <= 'm') goto yy656;
		goto yy660;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy656;
			goto yy661;
		} else {
			if (yych <= 's') goto yy659;
			if (yych <= 't') goto yy662;
			goto yy656;
		}
	}
yy1059:
	YYDEBUG(1059, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy656;
		if (yych <= '9') goto yy1061;
		if (yych <= 'm') goto yy656;
		goto yy660;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy656;
			goto yy661;
		} else {
			if (yych <= 's') goto yy659;
			if (yych <= 't') goto yy662;
			goto yy656;
		}
	}
yy1060:
	YYDEBUG(1060, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy656;
		} else {
			if (yych <= '9') goto yy603;
			if (yych <= 'm') goto yy656;
			goto yy660;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy656;
			goto yy661;
		} else {
			if (yych <= 's') goto yy659;
			if (yych <= 't') goto yy662;
			goto yy656;
		}
	}
yy1061:
	YYDEBUG(1061, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy763;
		if (yych <= '9') goto yy604;
		if (yych <= 'm') goto yy763;
		goto yy660;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy763;
			goto yy661;
		} else {
			if (yych <= 's') goto yy659;
			if (yych <= 't') goto yy662;
			goto yy763;
		}
	}
yy1062:
	YYDEBUG(1062, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy1051;
			if (yych <= ',') goto yy1053;
			goto yy1050;
		} else {
			if (yych <= '.') goto yy1063;
			if (yych <= '/') goto yy729;
			if (yych <= '5') goto yy1065;
			goto yy740;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy1064;
			if (yych == 'n') goto yy469;
			goto yy1053;
		} else {
			if (yych <= 'r') goto yy470;
			if (yych <= 's') goto yy463;
			if (yych <= 't') goto yy467;
			goto yy1053;
		}
	}
yy1063:
	YYDEBUG(1063, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy577;
		if (yych <= '0') goto yy1087;
		goto yy1088;
	} else {
		if (yych <= '5') goto yy1089;
		if (yych <= '9') goto yy1090;
		goto yy577;
	}
yy1064:
	YYDEBUG(1064, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1082;
	if (yych <= '9') goto yy1083;
	goto yy56;
yy1065:
	YYDEBUG(1065, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy784;
	if (yych <= '/') goto yy60;
	if (yych >= ':') goto yy60;
	YYDEBUG(1066, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'n':
	case 'o':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy790;
	case '-':	goto yy787;
	case '.':	goto yy791;
	case '/':	goto yy788;
	case '0':	goto yy1068;
	case '1':	goto yy1069;
	case '2':	goto yy1070;
	case '3':	goto yy1071;
	case '4':
	case '5':	goto yy1072;
	case '6':	goto yy1073;
	case '7':
	case '8':
	case '9':	goto yy54;
	case ':':	goto yy806;
	case 'W':	goto yy809;
	default:	goto yy1067;
	}
yy1067:
	YYDEBUG(1067, *YYCURSOR);
#line 1151 "parse_date.re"
	{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr((char **) &ptr, 2);
				s->time->i = timelib_get_nr((char **) &ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr((char **) &ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				add_error(s, "Double time specification");
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
#line 15672 "parse_date.c"
yy1068:
	YYDEBUG(1068, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '0') goto yy1080;
	if (yych <= '9') goto yy1081;
	goto yy60;
yy1069:
	YYDEBUG(1069, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '2') goto yy1079;
	if (yych <= '9') goto yy1078;
	goto yy60;
yy1070:
	YYDEBUG(1070, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy1078;
	goto yy60;
yy1071:
	YYDEBUG(1071, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '5') goto yy1076;
	if (yych <= '6') goto yy1077;
	if (yych <= '9') goto yy1074;
	goto yy60;
yy1072:
	YYDEBUG(1072, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy1074;
	goto yy60;
yy1073:
	YYDEBUG(1073, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '0') goto yy1074;
	if (yych <= '9') goto yy54;
	goto yy60;
yy1074:
	YYDEBUG(1074, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych >= ' ') goto yy60;
			} else {
				if (yych == 'D') goto yy60;
				if (yych >= 'F') goto yy60;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy60;
				if (yych >= 'M') goto yy60;
			} else {
				if (yych <= 'R') goto yy1075;
				if (yych <= 'T') goto yy60;
				if (yych >= 'W') goto yy60;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych >= 'd') goto yy60;
			} else {
				if (yych == 'f') goto yy60;
				if (yych >= 'h') goto yy60;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych >= 's') goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy60;
				} else {
					if (yych == 'y') goto yy60;
				}
			}
		}
	}
yy1075:
	YYDEBUG(1075, *YYCURSOR);
#line 1197 "parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
#line 15783 "parse_date.c"
yy1076:
	YYDEBUG(1076, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1075;
				goto yy60;
			} else {
				if (yych <= '/') goto yy1075;
				if (yych <= '9') goto yy820;
				if (yych <= 'C') goto yy1075;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy1075;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1075;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy1075;
					if (yych <= 'T') goto yy60;
					goto yy1075;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1075;
				if (yych <= 'Y') goto yy60;
				goto yy1075;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy1075;
				} else {
					if (yych == 'g') goto yy1075;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy1075;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1075;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy1075;
				}
			}
		}
	}
yy1077:
	YYDEBUG(1077, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1075;
				goto yy60;
			} else {
				if (yych <= '6') {
					if (yych <= '/') goto yy1075;
					goto yy820;
				} else {
					if (yych <= '9') goto yy54;
					if (yych <= 'C') goto yy1075;
					goto yy60;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy1075;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1075;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy1075;
					if (yych <= 'T') goto yy60;
					goto yy1075;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1075;
				if (yych <= 'Y') goto yy60;
				goto yy1075;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy1075;
				} else {
					if (yych == 'g') goto yy1075;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy1075;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1075;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy1075;
				}
			}
		}
	}
yy1078:
	YYDEBUG(1078, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1075;
				goto yy60;
			} else {
				if (yych <= '/') goto yy1075;
				if (yych <= '9') goto yy820;
				if (yych <= 'C') goto yy1075;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy1075;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1075;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy1075;
					if (yych <= 'T') goto yy60;
					goto yy1075;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1075;
				if (yych <= 'Y') goto yy60;
				goto yy1075;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy1075;
				} else {
					if (yych == 'g') goto yy1075;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy1075;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1075;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy1075;
				}
			}
		}
	}
yy1079:
	YYDEBUG(1079, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1075;
				goto yy60;
			} else {
				if (yych <= '0') {
					if (yych <= '/') goto yy1075;
					goto yy844;
				} else {
					if (yych <= '2') goto yy845;
					if (yych <= '3') goto yy846;
					goto yy820;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy1075;
					goto yy60;
				} else {
					if (yych == 'F') goto yy60;
					goto yy1075;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy60;
					goto yy1075;
				} else {
					if (yych <= 'M') goto yy60;
					if (yych <= 'R') goto yy1075;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy60;
				if (yych <= 'X') goto yy1075;
				goto yy60;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy1075;
					goto yy60;
				} else {
					if (yych == 'f') goto yy60;
					goto yy1075;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy60;
					goto yy1075;
				} else {
					if (yych <= 'm') goto yy60;
					if (yych <= 'r') goto yy1075;
					goto yy60;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1075;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy1075;
				}
			}
		}
	}
yy1080:
	YYDEBUG(1080, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1075;
				goto yy60;
			} else {
				if (yych <= '0') {
					if (yych <= '/') goto yy1075;
					goto yy876;
				} else {
					if (yych <= '2') goto yy845;
					if (yych <= '3') goto yy846;
					goto yy820;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy1075;
					goto yy60;
				} else {
					if (yych == 'F') goto yy60;
					goto yy1075;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy60;
					goto yy1075;
				} else {
					if (yych <= 'M') goto yy60;
					if (yych <= 'R') goto yy1075;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy60;
				if (yych <= 'X') goto yy1075;
				goto yy60;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy1075;
					goto yy60;
				} else {
					if (yych == 'f') goto yy60;
					goto yy1075;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy60;
					goto yy1075;
				} else {
					if (yych <= 'm') goto yy60;
					if (yych <= 'r') goto yy1075;
					goto yy60;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1075;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy1075;
				}
			}
		}
	}
yy1081:
	YYDEBUG(1081, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1075;
				goto yy60;
			} else {
				if (yych <= '0') {
					if (yych <= '/') goto yy1075;
					goto yy844;
				} else {
					if (yych <= '2') goto yy845;
					if (yych <= '3') goto yy846;
					goto yy820;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy1075;
					goto yy60;
				} else {
					if (yych == 'F') goto yy60;
					goto yy1075;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy60;
					goto yy1075;
				} else {
					if (yych <= 'M') goto yy60;
					if (yych <= 'R') goto yy1075;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy60;
				if (yych <= 'X') goto yy1075;
				goto yy60;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy1075;
					goto yy60;
				} else {
					if (yych == 'f') goto yy60;
					goto yy1075;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy60;
					goto yy1075;
				} else {
					if (yych <= 'm') goto yy60;
					if (yych <= 'r') goto yy1075;
					goto yy60;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1075;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy1075;
				}
			}
		}
	}
yy1082:
	YYDEBUG(1082, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy1084;
		goto yy490;
	} else {
		if (yych <= '9') goto yy1083;
		if (yych <= ':') goto yy1084;
		goto yy490;
	}
yy1083:
	YYDEBUG(1083, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy1084;
	if (yych != ':') goto yy490;
yy1084:
	YYDEBUG(1084, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1085;
	if (yych <= '6') goto yy1086;
	if (yych <= '9') goto yy495;
	goto yy56;
yy1085:
	YYDEBUG(1085, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy496;
	if (yych <= '/') goto yy490;
	if (yych <= '9') goto yy495;
	goto yy490;
yy1086:
	YYDEBUG(1086, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy496;
	if (yych == '0') goto yy495;
	goto yy490;
yy1087:
	YYDEBUG(1087, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy490;
		if (yych <= '-') goto yy601;
		goto yy1091;
	} else {
		if (yych <= '/') goto yy490;
		if (yych <= '9') goto yy1090;
		if (yych <= ':') goto yy1084;
		goto yy490;
	}
yy1088:
	YYDEBUG(1088, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy490;
		if (yych <= '-') goto yy601;
		if (yych <= '.') goto yy1091;
		goto yy490;
	} else {
		if (yych <= '2') goto yy1090;
		if (yych <= '9') goto yy1083;
		if (yych <= ':') goto yy1084;
		goto yy490;
	}
yy1089:
	YYDEBUG(1089, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy490;
		if (yych <= '-') goto yy601;
		goto yy1091;
	} else {
		if (yych <= '/') goto yy490;
		if (yych <= '9') goto yy1083;
		if (yych <= ':') goto yy1084;
		goto yy490;
	}
yy1090:
	YYDEBUG(1090, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy490;
		if (yych <= '-') goto yy601;
	} else {
		if (yych == ':') goto yy1084;
		goto yy490;
	}
yy1091:
	YYDEBUG(1091, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1092;
	if (yych <= '6') goto yy1093;
	if (yych <= '9') goto yy609;
	goto yy56;
yy1092:
	YYDEBUG(1092, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy496;
	if (yych <= '/') goto yy490;
	if (yych <= '9') goto yy1094;
	goto yy490;
yy1093:
	YYDEBUG(1093, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy496;
		goto yy490;
	} else {
		if (yych <= '0') goto yy1094;
		if (yych <= '9') goto yy610;
		goto yy490;
	}
yy1094:
	YYDEBUG(1094, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy496;
	if (yych <= '/') goto yy490;
	if (yych <= '9') goto yy604;
	goto yy490;
yy1095:
	YYDEBUG(1095, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy459;
			if (yych <= ',') goto yy461;
			goto yy1050;
		} else {
			if (yych <= '.') goto yy473;
			if (yych <= '/') goto yy471;
			if (yych <= '5') goto yy1065;
			goto yy740;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy482;
			if (yych == 'n') goto yy469;
			goto yy461;
		} else {
			if (yych <= 'r') goto yy470;
			if (yych <= 's') goto yy463;
			if (yych <= 't') goto yy467;
			goto yy461;
		}
	}
yy1096:
	YYDEBUG(1096, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy1051;
			if (yych <= ',') goto yy1053;
			goto yy1050;
		} else {
			if (yych <= '.') goto yy1063;
			if (yych <= '/') goto yy471;
			if (yych <= '5') goto yy1065;
			goto yy740;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy1064;
			if (yych == 'n') goto yy469;
			goto yy1053;
		} else {
			if (yych <= 'r') goto yy470;
			if (yych <= 's') goto yy463;
			if (yych <= 't') goto yy467;
			goto yy1053;
		}
	}
yy1097:
	YYDEBUG(1097, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy141;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'e') goto yy1098;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1098:
	YYDEBUG(1098, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'U') goto yy142;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'v') goto yy1099;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1099:
	YYDEBUG(1099, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy143;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'i') goto yy1100;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1100:
	YYDEBUG(1100, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy144;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'o') goto yy1101;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1101:
	YYDEBUG(1101, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'U') goto yy1102;
		if (yych != 'u') goto yy3;
	}
yy1102:
	YYDEBUG(1102, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1103;
	if (yych != 's') goto yy56;
yy1103:
	YYDEBUG(1103, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy1104;
	if (yych != ' ') goto yy56;
yy1104:
	YYDEBUG(1104, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy1105:
	YYDEBUG(1105, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy1104;
				if (yych <= 0x1F) goto yy56;
				goto yy1104;
			} else {
				if (yych == 'D') goto yy1109;
				if (yych <= 'E') goto yy56;
				goto yy1110;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy1108;
				if (yych <= 'L') goto yy56;
				goto yy1107;
			} else {
				if (yych <= 'S') {
					if (yych <= 'R') goto yy56;
				} else {
					if (yych <= 'T') goto yy1113;
					if (yych <= 'V') goto yy56;
					goto yy1112;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy1111;
				if (yych <= 'c') goto yy56;
				goto yy1109;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy56;
					goto yy1110;
				} else {
					if (yych == 'h') goto yy1108;
					goto yy56;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy1107;
				if (yych <= 'r') goto yy56;
				if (yych >= 't') goto yy1113;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy56;
					goto yy1112;
				} else {
					if (yych == 'y') goto yy1111;
					goto yy56;
				}
			}
		}
	}
yy1106:
	YYDEBUG(1106, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy1178;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy1179;
			if (yych <= 'T') goto yy56;
			goto yy1177;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy1178;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy1179;
			if (yych == 'u') goto yy1177;
			goto yy56;
		}
	}
yy1107:
	YYDEBUG(1107, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto yy1169;
		if (yych <= 'N') goto yy56;
		goto yy1168;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy56;
			goto yy1169;
		} else {
			if (yych == 'o') goto yy1168;
			goto yy56;
		}
	}
yy1108:
	YYDEBUG(1108, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1166;
	if (yych == 'o') goto yy1166;
	goto yy56;
yy1109:
	YYDEBUG(1109, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1165;
	if (yych == 'a') goto yy1165;
	goto yy56;
yy1110:
	YYDEBUG(1110, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy1150;
		if (yych <= 'Q') goto yy56;
		goto yy1149;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy56;
			goto yy1150;
		} else {
			if (yych == 'r') goto yy1149;
			goto yy56;
		}
	}
yy1111:
	YYDEBUG(1111, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1146;
	if (yych == 'e') goto yy1146;
	goto yy56;
yy1112:
	YYDEBUG(1112, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1132;
	if (yych == 'e') goto yy1132;
	goto yy56;
yy1113:
	YYDEBUG(1113, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy1114;
		if (yych <= 'T') goto yy56;
		goto yy1115;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
		} else {
			if (yych == 'u') goto yy1115;
			goto yy56;
		}
	}
yy1114:
	YYDEBUG(1114, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1127;
	if (yych == 'u') goto yy1127;
	goto yy56;
yy1115:
	YYDEBUG(1115, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1116;
	if (yych != 'e') goto yy56;
yy1116:
	YYDEBUG(1116, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1118;
		if (yych >= ' ') goto yy1118;
	} else {
		if (yych <= 'S') {
			if (yych >= 'S') goto yy1120;
		} else {
			if (yych == 's') goto yy1120;
		}
	}
yy1117:
	YYDEBUG(1117, *YYCURSOR);
#line 1593 "parse_date.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 16697 "parse_date.c"
yy1118:
	YYDEBUG(1118, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	YYDEBUG(1119, *YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1118;
		if (yych <= 0x1F) goto yy56;
		goto yy1118;
	} else {
		if (yych <= 'O') {
			if (yych <= 'N') goto yy56;
			goto yy1124;
		} else {
			if (yych == 'o') goto yy1124;
			goto yy56;
		}
	}
yy1120:
	YYDEBUG(1120, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1121;
	if (yych != 'd') goto yy56;
yy1121:
	YYDEBUG(1121, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1122;
	if (yych != 'a') goto yy56;
yy1122:
	YYDEBUG(1122, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1123;
	if (yych != 'y') goto yy56;
yy1123:
	YYDEBUG(1123, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '\t') goto yy1118;
	if (yych == ' ') goto yy1118;
	goto yy1117;
yy1124:
	YYDEBUG(1124, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1125;
	if (yych != 'f') goto yy56;
yy1125:
	YYDEBUG(1125, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1126, *YYCURSOR);
#line 1066 "parse_date.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("weekdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_SPECIAL_RELATIVE();

		i = timelib_get_relative_text((char **) &ptr, &behavior);
		timelib_eat_spaces((char **) &ptr);
		if (i > 0) { /* first, second... etc */
			s->time->relative.special.type = TIMELIB_SPECIAL_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative((char **) &ptr, i, 1, s);
		} else { /* last */
			s->time->relative.special.type = TIMELIB_SPECIAL_LAST_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_WEEK_DAY_OF_MONTH;
	}
#line 16769 "parse_date.c"
yy1127:
	YYDEBUG(1127, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1118;
		if (yych <= 0x1F) goto yy1117;
		goto yy1118;
	} else {
		if (yych <= 'R') {
			if (yych <= 'Q') goto yy1117;
		} else {
			if (yych != 'r') goto yy1117;
		}
	}
	YYDEBUG(1128, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1129;
	if (yych != 's') goto yy56;
yy1129:
	YYDEBUG(1129, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1130;
	if (yych != 'd') goto yy56;
yy1130:
	YYDEBUG(1130, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1131;
	if (yych != 'a') goto yy56;
yy1131:
	YYDEBUG(1131, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1123;
	if (yych == 'y') goto yy1123;
	goto yy56;
yy1132:
	YYDEBUG(1132, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy56;
		if (yych <= 'D') goto yy1134;
	} else {
		if (yych <= 'c') goto yy56;
		if (yych <= 'd') goto yy1134;
		if (yych >= 'f') goto yy56;
	}
	YYDEBUG(1133, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1140;
	if (yych == 'k') goto yy1140;
	goto yy56;
yy1134:
	YYDEBUG(1134, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1118;
		if (yych <= 0x1F) goto yy1117;
		goto yy1118;
	} else {
		if (yych <= 'N') {
			if (yych <= 'M') goto yy1117;
		} else {
			if (yych != 'n') goto yy1117;
		}
	}
	YYDEBUG(1135, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1136;
	if (yych != 'e') goto yy56;
yy1136:
	YYDEBUG(1136, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1137;
	if (yych != 's') goto yy56;
yy1137:
	YYDEBUG(1137, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1138;
	if (yych != 'd') goto yy56;
yy1138:
	YYDEBUG(1138, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1139;
	if (yych != 'a') goto yy56;
yy1139:
	YYDEBUG(1139, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1123;
	if (yych == 'y') goto yy1123;
	goto yy56;
yy1140:
	YYDEBUG(1140, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy1143;
		if (yych >= 'S') goto yy1142;
	} else {
		if (yych <= 'd') {
			if (yych >= 'd') goto yy1143;
		} else {
			if (yych == 's') goto yy1142;
		}
	}
yy1141:
	YYDEBUG(1141, *YYCURSOR);
#line 1569 "parse_date.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetextweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
			s->time->relative.weekday_behavior = 2;

			/* to handle the format weekday + last/this/next week */
			if (s->time->relative.have_weekday_relative == 0) {
				TIMELIB_HAVE_WEEKDAY_RELATIVE();
				s->time->relative.weekday = 1;
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 16900 "parse_date.c"
yy1142:
	YYDEBUG(1142, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1117;
yy1143:
	YYDEBUG(1143, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1144;
	if (yych != 'a') goto yy56;
yy1144:
	YYDEBUG(1144, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1145;
	if (yych != 'y') goto yy56;
yy1145:
	YYDEBUG(1145, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1142;
	if (yych == 's') goto yy1142;
	goto yy1117;
yy1146:
	YYDEBUG(1146, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1147;
	if (yych != 'a') goto yy56;
yy1147:
	YYDEBUG(1147, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1148;
	if (yych != 'r') goto yy56;
yy1148:
	YYDEBUG(1148, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1142;
	if (yych == 's') goto yy1142;
	goto yy1117;
yy1149:
	YYDEBUG(1149, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1162;
	if (yych == 'i') goto yy1162;
	goto yy56;
yy1150:
	YYDEBUG(1150, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1151;
	if (yych != 'r') goto yy56;
yy1151:
	YYDEBUG(1151, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1152;
	if (yych != 't') goto yy56;
yy1152:
	YYDEBUG(1152, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy1154;
		if (yych <= 'M') goto yy56;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
			goto yy1154;
		} else {
			if (yych != 'n') goto yy56;
		}
	}
	YYDEBUG(1153, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1159;
	if (yych == 'i') goto yy1159;
	goto yy56;
yy1154:
	YYDEBUG(1154, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1155;
	if (yych != 'n') goto yy56;
yy1155:
	YYDEBUG(1155, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1156;
	if (yych != 'i') goto yy56;
yy1156:
	YYDEBUG(1156, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1157;
	if (yych != 'g') goto yy56;
yy1157:
	YYDEBUG(1157, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1158;
	if (yych != 'h') goto yy56;
yy1158:
	YYDEBUG(1158, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1148;
	if (yych == 't') goto yy1148;
	goto yy56;
yy1159:
	YYDEBUG(1159, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1160;
	if (yych != 'g') goto yy56;
yy1160:
	YYDEBUG(1160, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1161;
	if (yych != 'h') goto yy56;
yy1161:
	YYDEBUG(1161, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1148;
	if (yych == 't') goto yy1148;
	goto yy56;
yy1162:
	YYDEBUG(1162, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1118;
		if (yych <= 0x1F) goto yy1117;
		goto yy1118;
	} else {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy1117;
		} else {
			if (yych != 'd') goto yy1117;
		}
	}
	YYDEBUG(1163, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1164;
	if (yych != 'a') goto yy56;
yy1164:
	YYDEBUG(1164, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1123;
	if (yych == 'y') goto yy1123;
	goto yy56;
yy1165:
	YYDEBUG(1165, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1148;
	if (yych == 'y') goto yy1148;
	goto yy56;
yy1166:
	YYDEBUG(1166, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1167;
	if (yych != 'u') goto yy56;
yy1167:
	YYDEBUG(1167, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1148;
	if (yych == 'r') goto yy1148;
	goto yy56;
yy1168:
	YYDEBUG(1168, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1173;
	if (yych == 'n') goto yy1173;
	goto yy56;
yy1169:
	YYDEBUG(1169, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1170;
	if (yych != 'n') goto yy56;
yy1170:
	YYDEBUG(1170, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy1142;
		if (yych <= 'T') goto yy1117;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy1117;
			goto yy1142;
		} else {
			if (yych != 'u') goto yy1117;
		}
	}
	YYDEBUG(1171, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1172;
	if (yych != 't') goto yy56;
yy1172:
	YYDEBUG(1172, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1148;
	if (yych == 'e') goto yy1148;
	goto yy56;
yy1173:
	YYDEBUG(1173, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1118;
			goto yy1117;
		} else {
			if (yych <= ' ') goto yy1118;
			if (yych <= 'C') goto yy1117;
		}
	} else {
		if (yych <= 'c') {
			if (yych == 'T') goto yy1175;
			goto yy1117;
		} else {
			if (yych <= 'd') goto yy1174;
			if (yych == 't') goto yy1175;
			goto yy1117;
		}
	}
yy1174:
	YYDEBUG(1174, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1176;
	if (yych == 'a') goto yy1176;
	goto yy56;
yy1175:
	YYDEBUG(1175, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1148;
	if (yych == 'h') goto yy1148;
	goto yy56;
yy1176:
	YYDEBUG(1176, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1123;
	if (yych == 'y') goto yy1123;
	goto yy56;
yy1177:
	YYDEBUG(1177, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1188;
	if (yych == 'n') goto yy1188;
	goto yy56;
yy1178:
	YYDEBUG(1178, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1183;
	if (yych == 't') goto yy1183;
	goto yy56;
yy1179:
	YYDEBUG(1179, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1180;
	if (yych != 'c') goto yy56;
yy1180:
	YYDEBUG(1180, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy1181;
		if (yych <= 'R') goto yy1117;
		goto yy1142;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy1117;
		} else {
			if (yych == 's') goto yy1142;
			goto yy1117;
		}
	}
yy1181:
	YYDEBUG(1181, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1182;
	if (yych != 'n') goto yy56;
yy1182:
	YYDEBUG(1182, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1148;
	if (yych == 'd') goto yy1148;
	goto yy56;
yy1183:
	YYDEBUG(1183, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1118;
		if (yych <= 0x1F) goto yy1117;
		goto yy1118;
	} else {
		if (yych <= 'U') {
			if (yych <= 'T') goto yy1117;
		} else {
			if (yych != 'u') goto yy1117;
		}
	}
	YYDEBUG(1184, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1185;
	if (yych != 'r') goto yy56;
yy1185:
	YYDEBUG(1185, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1186;
	if (yych != 'd') goto yy56;
yy1186:
	YYDEBUG(1186, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1187;
	if (yych != 'a') goto yy56;
yy1187:
	YYDEBUG(1187, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1123;
	if (yych == 'y') goto yy1123;
	goto yy56;
yy1188:
	YYDEBUG(1188, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1118;
		if (yych <= 0x1F) goto yy1117;
		goto yy1118;
	} else {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy1117;
		} else {
			if (yych != 'd') goto yy1117;
		}
	}
	YYDEBUG(1189, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1190;
	if (yych != 'a') goto yy56;
yy1190:
	YYDEBUG(1190, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1123;
	if (yych == 'y') goto yy1123;
	goto yy56;
yy1191:
	YYDEBUG(1191, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1098;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'e') goto yy1192;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1192:
	YYDEBUG(1192, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy1099;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'v') goto yy1193;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1193:
	YYDEBUG(1193, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy1100;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'i') goto yy1194;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1194:
	YYDEBUG(1194, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy1101;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'o') goto yy1195;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1195:
	YYDEBUG(1195, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'U') goto yy1102;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'u') goto yy1196;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1196:
	YYDEBUG(1196, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1103;
	if (yych != 's') goto yy154;
	YYDEBUG(1197, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy56;
			goto yy1104;
		} else {
			if (yych == ' ') goto yy1104;
			goto yy56;
		}
	} else {
		if (yych <= '/') {
			if (yych == '.') goto yy56;
			goto yy147;
		} else {
			if (yych == '_') goto yy147;
			goto yy56;
		}
	}
yy1198:
	YYDEBUG(1198, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy141;
			goto yy1212;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'g') goto yy1212;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1199:
	YYDEBUG(1199, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy141;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'e') goto yy1200;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1200:
	YYDEBUG(1200, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'U') goto yy142;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'v') goto yy1201;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1201:
	YYDEBUG(1201, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy143;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'e') goto yy1202;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1202:
	YYDEBUG(1202, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy144;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'n') goto yy1203;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1203:
	YYDEBUG(1203, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'T') goto yy1204;
		if (yych != 't') goto yy3;
	}
yy1204:
	YYDEBUG(1204, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1205;
	if (yych != 'h') goto yy56;
yy1205:
	YYDEBUG(1205, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy1206;
	if (yych != ' ') goto yy56;
yy1206:
	YYDEBUG(1206, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy1207:
	YYDEBUG(1207, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy1206;
				if (yych <= 0x1F) goto yy56;
				goto yy1206;
			} else {
				if (yych == 'D') goto yy1109;
				if (yych <= 'E') goto yy56;
				goto yy1110;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy1108;
				if (yych <= 'L') goto yy56;
				goto yy1107;
			} else {
				if (yych <= 'S') {
					if (yych <= 'R') goto yy56;
					goto yy1106;
				} else {
					if (yych <= 'T') goto yy1113;
					if (yych <= 'V') goto yy56;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy1111;
				if (yych <= 'c') goto yy56;
				goto yy1109;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy56;
					goto yy1110;
				} else {
					if (yych == 'h') goto yy1108;
					goto yy56;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy1107;
				if (yych <= 'r') goto yy56;
				if (yych <= 's') goto yy1106;
				goto yy1113;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy56;
				} else {
					if (yych == 'y') goto yy1111;
					goto yy56;
				}
			}
		}
	}
	YYDEBUG(1208, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1209;
	if (yych != 'e') goto yy56;
yy1209:
	YYDEBUG(1209, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy56;
		if (yych <= 'D') goto yy1134;
	} else {
		if (yych <= 'c') goto yy56;
		if (yych <= 'd') goto yy1134;
		if (yych >= 'f') goto yy56;
	}
	YYDEBUG(1210, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1211;
	if (yych != 'k') goto yy56;
yy1211:
	YYDEBUG(1211, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == 'D') goto yy1143;
		if (yych <= 'R') goto yy56;
		goto yy1142;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy56;
			goto yy1143;
		} else {
			if (yych == 's') goto yy1142;
			goto yy56;
		}
	}
yy1212:
	YYDEBUG(1212, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy142;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'h') goto yy1213;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1213:
	YYDEBUG(1213, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy143;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 't') goto yy1214;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1214:
	YYDEBUG(1214, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1206;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy1206;
			if (yych == ')') goto yy139;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'H') goto yy1215;
			if (yych <= 'Z') goto yy144;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1215;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1215:
	YYDEBUG(1215, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x1F) {
		if (yych == '\t') goto yy1206;
		goto yy3;
	} else {
		if (yych <= ' ') goto yy1206;
		if (yych == ')') goto yy139;
		goto yy3;
	}
yy1216:
	YYDEBUG(1216, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy1212;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'g') goto yy1224;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1217:
	YYDEBUG(1217, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1200;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'e') goto yy1218;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1218:
	YYDEBUG(1218, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy1201;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'v') goto yy1219;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1219:
	YYDEBUG(1219, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1202;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'e') goto yy1220;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1220:
	YYDEBUG(1220, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1203;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'n') goto yy1221;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1221:
	YYDEBUG(1221, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'T') goto yy1204;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 't') goto yy1222;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1222:
	YYDEBUG(1222, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1205;
	if (yych != 'h') goto yy154;
yy1223:
	YYDEBUG(1223, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy56;
			goto yy1206;
		} else {
			if (yych == ' ') goto yy1206;
			goto yy56;
		}
	} else {
		if (yych <= '/') {
			if (yych == '.') goto yy56;
			goto yy147;
		} else {
			if (yych == '_') goto yy147;
			goto yy56;
		}
	}
yy1224:
	YYDEBUG(1224, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1213;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'h') goto yy1225;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1225:
	YYDEBUG(1225, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1214;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 't') goto yy1226;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1226:
	YYDEBUG(1226, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy1206;
			} else {
				if (yych == ' ') goto yy1206;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy3;
			} else {
				if (yych == '.') goto yy3;
				goto yy147;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'G') {
				if (yych <= '@') goto yy3;
				goto yy144;
			} else {
				if (yych <= 'H') goto yy1215;
				if (yych <= 'Z') goto yy144;
				goto yy3;
			}
		} else {
			if (yych <= 'g') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'h') goto yy1227;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1227:
	YYDEBUG(1227, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= ')') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1206;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy1206;
			if (yych <= '(') goto yy3;
			goto yy139;
		}
	} else {
		if (yych <= '.') {
			if (yych == '-') goto yy147;
			goto yy3;
		} else {
			if (yych <= '/') goto yy147;
			if (yych == '_') goto yy147;
			goto yy3;
		}
	}
yy1228:
	YYDEBUG(1228, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= 'B') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'O') {
				if (yych <= 'C') goto yy1244;
				goto yy141;
			} else {
				if (yych <= 'P') goto yy1246;
				if (yych <= 'U') goto yy141;
				goto yy1245;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy141;
				goto yy3;
			} else {
				if (yych == 'c') goto yy1244;
				goto yy141;
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') goto yy1246;
				goto yy141;
			} else {
				if (yych <= 'v') goto yy1245;
				if (yych <= 'z') goto yy141;
				goto yy3;
			}
		}
	}
yy1229:
	YYDEBUG(1229, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy141;
			goto yy1239;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 't') goto yy1239;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1230:
	YYDEBUG(1230, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'W') goto yy141;
			goto yy1236;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'x') goto yy1236;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1231:
	YYDEBUG(1231, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy141;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'n') goto yy1232;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1232:
	YYDEBUG(1232, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy166;
			goto yy139;
		} else {
			if (yych <= '@') goto yy166;
			if (yych <= 'C') goto yy142;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy166;
			goto yy142;
		} else {
			if (yych <= 'd') goto yy1233;
			if (yych <= 'z') goto yy142;
			goto yy166;
		}
	}
yy1233:
	YYDEBUG(1233, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy143;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1234;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1234:
	YYDEBUG(1234, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy144;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'y') goto yy1235;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1235:
	YYDEBUG(1235, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy139;
	goto yy166;
yy1236:
	YYDEBUG(1236, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy142;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 't') goto yy1237;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1237:
	YYDEBUG(1237, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy143;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'h') goto yy1238;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1238:
	YYDEBUG(1238, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1206;
		} else {
			if (yych == ' ') goto yy1206;
			goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1239:
	YYDEBUG(1239, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy166;
			goto yy139;
		} else {
			if (yych <= '@') goto yy166;
			if (yych <= 'T') goto yy142;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy166;
			goto yy142;
		} else {
			if (yych <= 'u') goto yy1240;
			if (yych <= 'z') goto yy142;
			goto yy166;
		}
	}
yy1240:
	YYDEBUG(1240, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy143;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'r') goto yy1241;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1241:
	YYDEBUG(1241, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy144;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'd') goto yy1242;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1242:
	YYDEBUG(1242, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'A') goto yy1243;
		if (yych != 'a') goto yy3;
	}
yy1243:
	YYDEBUG(1243, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy172;
	if (yych == 'y') goto yy172;
	goto yy56;
yy1244:
	YYDEBUG(1244, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy142;
			goto yy1255;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'o') goto yy1255;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1245:
	YYDEBUG(1245, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy142;
			goto yy1252;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'e') goto yy1252;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1246:
	YYDEBUG(1246, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'T') goto yy142;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 't') goto yy1247;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy1247:
	YYDEBUG(1247, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'E') goto yy143;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy193;
				goto yy143;
			} else {
				if (yych <= 'e') goto yy1248;
				if (yych <= 'z') goto yy143;
				goto yy193;
			}
		}
	}
yy1248:
	YYDEBUG(1248, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy144;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'm') goto yy1249;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1249:
	YYDEBUG(1249, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'B') goto yy1250;
		if (yych != 'b') goto yy3;
	}
yy1250:
	YYDEBUG(1250, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1251;
	if (yych != 'e') goto yy56;
yy1251:
	YYDEBUG(1251, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy205;
	if (yych == 'r') goto yy205;
	goto yy56;
yy1252:
	YYDEBUG(1252, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy143;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'n') goto yy1253;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1253:
	YYDEBUG(1253, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy144;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 't') goto yy1254;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1254:
	YYDEBUG(1254, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy1205;
		if (yych == 'h') goto yy1205;
		goto yy3;
	}
yy1255:
	YYDEBUG(1255, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy143;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'n') goto yy1256;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1256:
	YYDEBUG(1256, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy144;
			goto yy1215;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'd') goto yy1215;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1257:
	YYDEBUG(1257, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '/') {
			if (yych <= ',') {
				if (yych == ')') goto yy139;
				goto yy3;
			} else {
				if (yych == '.') goto yy3;
				goto yy147;
			}
		} else {
			if (yych <= 'C') {
				if (yych <= '@') goto yy3;
				if (yych <= 'B') goto yy141;
				goto yy1244;
			} else {
				if (yych == 'P') goto yy1246;
				goto yy141;
			}
		}
	} else {
		if (yych <= 'b') {
			if (yych <= '^') {
				if (yych <= 'V') goto yy1245;
				if (yych <= 'Z') goto yy141;
				goto yy3;
			} else {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy3;
				goto yy146;
			}
		} else {
			if (yych <= 'p') {
				if (yych <= 'c') goto yy1273;
				if (yych <= 'o') goto yy146;
				goto yy1275;
			} else {
				if (yych == 'v') goto yy1274;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1258:
	YYDEBUG(1258, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1239;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 't') goto yy1268;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1259:
	YYDEBUG(1259, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy1236;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'x') goto yy1265;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1260:
	YYDEBUG(1260, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1232;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'n') goto yy1261;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1261:
	YYDEBUG(1261, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy166;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy166;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1233;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy166;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy166;
				goto yy150;
			} else {
				if (yych <= 'd') goto yy1262;
				if (yych <= 'z') goto yy150;
				goto yy166;
			}
		}
	}
yy1262:
	YYDEBUG(1262, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1234;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1263;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy1263:
	YYDEBUG(1263, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1235;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'y') goto yy1264;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1264:
	YYDEBUG(1264, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '-') {
		if (yych == ')') goto yy139;
		if (yych <= ',') goto yy166;
		goto yy147;
	} else {
		if (yych <= '/') {
			if (yych <= '.') goto yy166;
			goto yy147;
		} else {
			if (yych == '_') goto yy147;
			goto yy166;
		}
	}
yy1265:
	YYDEBUG(1265, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1237;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1266;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1266:
	YYDEBUG(1266, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1238;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'h') goto yy1267;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1267:
	YYDEBUG(1267, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1206;
			if (yych <= 0x1F) goto yy3;
			goto yy1206;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy147;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1268:
	YYDEBUG(1268, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy166;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy166;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy1240;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy166;
			goto yy147;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy166;
				goto yy150;
			} else {
				if (yych <= 'u') goto yy1269;
				if (yych <= 'z') goto yy150;
				goto yy166;
			}
		}
	}
yy1269:
	YYDEBUG(1269, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1241;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'r') goto yy1270;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1270:
	YYDEBUG(1270, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1242;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'd') goto yy1271;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1271:
	YYDEBUG(1271, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1243;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1272;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1272:
	YYDEBUG(1272, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy172;
	if (yych == 'y') goto yy185;
	goto yy154;
yy1273:
	YYDEBUG(1273, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy1255;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'o') goto yy1284;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1274:
	YYDEBUG(1274, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1252;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'e') goto yy1281;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1275:
	YYDEBUG(1275, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy371;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'S') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'T') goto yy1247;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1276;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy1276:
	YYDEBUG(1276, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy371;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy193;
				goto yy143;
			} else {
				if (yych <= 'E') goto yy1248;
				if (yych <= 'Z') goto yy143;
				goto yy193;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy151;
			} else {
				if (yych <= 'e') goto yy1277;
				if (yych <= 'z') goto yy151;
				goto yy193;
			}
		}
	}
yy1277:
	YYDEBUG(1277, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy1249;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'm') goto yy1278;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1278:
	YYDEBUG(1278, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'B') goto yy1250;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'b') goto yy1279;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1279:
	YYDEBUG(1279, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1251;
	if (yych != 'e') goto yy154;
	YYDEBUG(1280, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy205;
	if (yych == 'r') goto yy376;
	goto yy154;
yy1281:
	YYDEBUG(1281, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1253;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'n') goto yy1282;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1282:
	YYDEBUG(1282, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1254;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 't') goto yy1283;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1283:
	YYDEBUG(1283, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1205;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1223;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1284:
	YYDEBUG(1284, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1256;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'n') goto yy1285;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1285:
	YYDEBUG(1285, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1215;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'd') goto yy1227;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1286:
	YYDEBUG(1286, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy141;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'c') goto yy1287;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1287:
	YYDEBUG(1287, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'J') goto yy142;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'k') goto yy1288;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1288:
	YYDEBUG(1288, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych == ' ') goto yy1289;
		if (yych <= '(') goto yy3;
		goto yy139;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy3;
			goto yy143;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1289:
	YYDEBUG(1289, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1290;
	if (yych != 'o') goto yy56;
yy1290:
	YYDEBUG(1290, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1291;
	if (yych != 'f') goto yy56;
yy1291:
	YYDEBUG(1291, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy56;
	YYDEBUG(1292, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1293;
	if (yych <= '2') goto yy1295;
	if (yych <= '9') goto yy1296;
	goto yy56;
yy1293:
	YYDEBUG(1293, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1297;
	if (yych <= '9') goto yy1296;
	goto yy1297;
yy1294:
	YYDEBUG(1294, *YYCURSOR);
#line 1043 "parse_date.re"
	{
		DEBUG_OUTPUT("backof | frontof");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();

		if (*ptr == 'b') {
			s->time->h = timelib_get_nr((char **) &ptr, 2);
			s->time->i = 15;
		} else {
			s->time->h = timelib_get_nr((char **) &ptr, 2) - 1;
			s->time->i = 45;
		}
		if (*ptr != '\0' ) {
			timelib_eat_spaces((char **) &ptr);
			s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
#line 19599 "parse_date.c"
yy1295:
	YYDEBUG(1295, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1297;
	if (yych >= '5') goto yy1297;
yy1296:
	YYDEBUG(1296, *YYCURSOR);
	yyaccept = 28;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
yy1297:
	YYDEBUG(1297, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1296;
			goto yy1294;
		} else {
			if (yych <= ' ') goto yy1296;
			if (yych <= '@') goto yy1294;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy1294;
		} else {
			if (yych <= 'a') goto yy1298;
			if (yych != 'p') goto yy1294;
		}
	}
yy1298:
	YYDEBUG(1298, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy1300;
		if (yych == 'm') goto yy1300;
		goto yy56;
	}
	YYDEBUG(1299, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1300;
	if (yych != 'm') goto yy56;
yy1300:
	YYDEBUG(1300, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1302;
		if (yych == '\t') goto yy1302;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy1302;
		if (yych != '.') goto yy56;
	}
	YYDEBUG(1301, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1302;
		if (yych <= 0x08) goto yy56;
	} else {
		if (yych != ' ') goto yy56;
	}
yy1302:
	YYDEBUG(1302, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1294;
yy1303:
	YYDEBUG(1303, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') goto yy1287;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'c') goto yy1304;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1304:
	YYDEBUG(1304, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'J') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'K') goto yy1288;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'j') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'k') goto yy1305;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1305:
	YYDEBUG(1305, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= '(') {
			if (yych == ' ') goto yy1289;
			goto yy3;
		} else {
			if (yych <= ')') goto yy139;
			if (yych == '-') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy147;
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy143;
			goto yy3;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy1306:
	YYDEBUG(1306, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy141;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 's') goto yy1307;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1307:
	YYDEBUG(1307, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy142;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 't') goto yy1308;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1308:
	YYDEBUG(1308, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1104;
		} else {
			if (yych != ' ') goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy143;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1309:
	YYDEBUG(1309, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1310;
	if (yych != 'd') goto yy1105;
yy1310:
	YYDEBUG(1310, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1311;
	if (yych != 'a') goto yy56;
yy1311:
	YYDEBUG(1311, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1312;
	if (yych != 'y') goto yy56;
yy1312:
	YYDEBUG(1312, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych != ' ') goto yy1117;
	} else {
		if (yych <= 'S') goto yy1142;
		if (yych == 's') goto yy1142;
		goto yy1117;
	}
	YYDEBUG(1313, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1314;
	if (yych != 'o') goto yy56;
yy1314:
	YYDEBUG(1314, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1315;
	if (yych != 'f') goto yy56;
yy1315:
	YYDEBUG(1315, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1316, *YYCURSOR);
#line 1026 "parse_date.re"
	{
		DEBUG_OUTPUT("firstdayof | lastdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		/* skip "last day of" or "first day of" */
		if (*ptr == 'l' || *ptr == 'L') {
			s->time->relative.first_last_day_of = TIMELIB_SPECIAL_LAST_DAY_OF_MONTH;
		} else {
			s->time->relative.first_last_day_of = TIMELIB_SPECIAL_FIRST_DAY_OF_MONTH;
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
#line 19876 "parse_date.c"
yy1317:
	YYDEBUG(1317, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1307;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 's') goto yy1318;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1318:
	YYDEBUG(1318, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1308;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1319;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1319:
	YYDEBUG(1319, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1104;
			if (yych <= 0x1F) goto yy3;
			goto yy1309;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy147;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1320:
	YYDEBUG(1320, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy141;
			goto yy1356;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'b') goto yy1356;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1321:
	YYDEBUG(1321, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'F') goto yy1346;
			if (yych <= 'Q') goto yy141;
			goto yy1345;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'e') goto yy141;
			goto yy1346;
		} else {
			if (yych == 'r') goto yy1345;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1322:
	YYDEBUG(1322, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'T') goto yy141;
			goto yy1342;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'u') goto yy1342;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1323:
	YYDEBUG(1323, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1325;
			if (yych <= 'N') goto yy141;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy141;
			goto yy1325;
		} else {
			if (yych == 'o') goto yy1324;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1324:
	YYDEBUG(1324, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy142;
			goto yy1328;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'n') goto yy1328;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1325:
	YYDEBUG(1325, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy166;
			goto yy139;
		} else {
			if (yych <= '@') goto yy166;
			if (yych <= 'C') goto yy142;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy166;
			goto yy142;
		} else {
			if (yych <= 'd') goto yy1326;
			if (yych <= 'z') goto yy142;
			goto yy166;
		}
	}
yy1326:
	YYDEBUG(1326, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy143;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1327;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1327:
	YYDEBUG(1327, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy144;
			goto yy1235;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'y') goto yy1235;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1328:
	YYDEBUG(1328, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy143;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 't') goto yy1329;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1329:
	YYDEBUG(1329, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych == ' ') goto yy1330;
		if (yych <= '(') goto yy3;
		goto yy139;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1330:
	YYDEBUG(1330, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1331;
	if (yych != 'o') goto yy56;
yy1331:
	YYDEBUG(1331, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1332;
	if (yych != 'f') goto yy56;
yy1332:
	YYDEBUG(1332, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy56;
	YYDEBUG(1333, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1334;
	if (yych <= '2') goto yy1335;
	if (yych <= '9') goto yy1336;
	goto yy56;
yy1334:
	YYDEBUG(1334, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1337;
	if (yych <= '9') goto yy1336;
	goto yy1337;
yy1335:
	YYDEBUG(1335, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1337;
	if (yych >= '5') goto yy1337;
yy1336:
	YYDEBUG(1336, *YYCURSOR);
	yyaccept = 28;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
yy1337:
	YYDEBUG(1337, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1336;
			goto yy1294;
		} else {
			if (yych <= ' ') goto yy1336;
			if (yych <= '@') goto yy1294;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy1294;
		} else {
			if (yych <= 'a') goto yy1338;
			if (yych != 'p') goto yy1294;
		}
	}
yy1338:
	YYDEBUG(1338, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy1340;
		if (yych == 'm') goto yy1340;
		goto yy56;
	}
	YYDEBUG(1339, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1340;
	if (yych != 'm') goto yy56;
yy1340:
	YYDEBUG(1340, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1302;
		if (yych == '\t') goto yy1302;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy1302;
		if (yych != '.') goto yy56;
	}
	YYDEBUG(1341, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1302;
		if (yych <= 0x08) goto yy56;
		goto yy1302;
	} else {
		if (yych == ' ') goto yy1302;
		goto yy56;
	}
yy1342:
	YYDEBUG(1342, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy142;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'r') goto yy1343;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1343:
	YYDEBUG(1343, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy143;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 't') goto yy1344;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1344:
	YYDEBUG(1344, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy144;
			goto yy1215;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'h') goto yy1215;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1345:
	YYDEBUG(1345, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy142;
			goto yy1348;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 's') goto yy1348;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1346:
	YYDEBUG(1346, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy142;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 't') goto yy1347;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1347:
	YYDEBUG(1347, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy143;
			goto yy1238;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'h') goto yy1238;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1348:
	YYDEBUG(1348, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy143;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 't') goto yy1349;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1349:
	YYDEBUG(1349, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1206;
		} else {
			if (yych != ' ') goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1350:
	YYDEBUG(1350, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1351;
	if (yych != 'd') goto yy1207;
yy1351:
	YYDEBUG(1351, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1352;
	if (yych != 'a') goto yy56;
yy1352:
	YYDEBUG(1352, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1353;
	if (yych != 'y') goto yy56;
yy1353:
	YYDEBUG(1353, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych != ' ') goto yy1117;
	} else {
		if (yych <= 'S') goto yy1142;
		if (yych == 's') goto yy1142;
		goto yy1117;
	}
	YYDEBUG(1354, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1355;
	if (yych != 'o') goto yy56;
yy1355:
	YYDEBUG(1355, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1315;
	if (yych == 'f') goto yy1315;
	goto yy56;
yy1356:
	YYDEBUG(1356, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'R') goto yy142;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'r') goto yy1357;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy1357:
	YYDEBUG(1357, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'T') goto yy143;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'u') goto yy1358;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1358:
	YYDEBUG(1358, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy144;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1359;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1359:
	YYDEBUG(1359, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'R') goto yy1360;
		if (yych != 'r') goto yy3;
	}
yy1360:
	YYDEBUG(1360, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy205;
	if (yych == 'y') goto yy205;
	goto yy56;
yy1361:
	YYDEBUG(1361, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy1356;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'b') goto yy1379;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1362:
	YYDEBUG(1362, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych == '-') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy147;
				goto yy3;
			} else {
				if (yych == 'F') goto yy1346;
				goto yy141;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'R') goto yy1345;
				goto yy141;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'f') goto yy1375;
				goto yy146;
			} else {
				if (yych <= 'r') goto yy1374;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1363:
	YYDEBUG(1363, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy1342;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'u') goto yy1371;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1364:
	YYDEBUG(1364, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych == '-') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy147;
				goto yy3;
			} else {
				if (yych == 'I') goto yy1325;
				goto yy141;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'O') goto yy1324;
				goto yy141;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy1366;
				goto yy146;
			} else {
				if (yych <= 'o') goto yy1365;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1365:
	YYDEBUG(1365, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1328;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'n') goto yy1369;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1366:
	YYDEBUG(1366, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy166;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy166;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1326;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy166;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy166;
				goto yy150;
			} else {
				if (yych <= 'd') goto yy1367;
				if (yych <= 'z') goto yy150;
				goto yy166;
			}
		}
	}
yy1367:
	YYDEBUG(1367, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1327;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1368;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy1368:
	YYDEBUG(1368, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1235;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'y') goto yy1264;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1369:
	YYDEBUG(1369, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1329;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 't') goto yy1370;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1370:
	YYDEBUG(1370, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= '(') {
			if (yych == ' ') goto yy1330;
			goto yy3;
		} else {
			if (yych <= ')') goto yy139;
			if (yych == '-') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy147;
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy144;
			goto yy3;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy152;
			goto yy3;
		}
	}
yy1371:
	YYDEBUG(1371, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1343;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'r') goto yy1372;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1372:
	YYDEBUG(1372, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1344;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 't') goto yy1373;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1373:
	YYDEBUG(1373, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1215;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'h') goto yy1227;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1374:
	YYDEBUG(1374, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1348;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 's') goto yy1377;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1375:
	YYDEBUG(1375, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1347;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1376;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1376:
	YYDEBUG(1376, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1238;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'h') goto yy1267;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1377:
	YYDEBUG(1377, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1349;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 't') goto yy1378;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1378:
	YYDEBUG(1378, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1206;
			if (yych <= 0x1F) goto yy3;
			goto yy1350;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy147;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1379:
	YYDEBUG(1379, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy371;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'Q') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'R') goto yy1357;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'r') goto yy1380;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy1380:
	YYDEBUG(1380, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy1358;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'u') goto yy1381;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1381:
	YYDEBUG(1381, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1359;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1382;
			if (yych <= 'z') goto yy152;
			goto yy3;
		}
	}
yy1382:
	YYDEBUG(1382, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy1360;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'r') goto yy1383;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1383:
	YYDEBUG(1383, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy205;
	if (yych == 'y') goto yy376;
	goto yy154;
yy1384:
	YYDEBUG(1384, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy1385:
	YYDEBUG(1385, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(1386, *YYCURSOR);
	if (yych <= '/') goto yy1387;
	if (yych <= '9') goto yy1385;
yy1387:
	YYDEBUG(1387, *YYCURSOR);
#line 1000 "parse_date.re"
	{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TZ();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->f = 0.0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;
		s->time->dst = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 21332 "parse_date.c"
yy1388:
	YYDEBUG(1388, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy141;
			goto yy1429;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'n') goto yy1429;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1389:
	YYDEBUG(1389, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1421;
			if (yych <= 'T') goto yy141;
			goto yy1422;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy141;
			goto yy1421;
		} else {
			if (yych == 'u') goto yy1422;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1390:
	YYDEBUG(1390, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'D') goto yy1410;
			if (yych <= 'L') goto yy141;
			goto yy1411;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'c') goto yy141;
			goto yy1410;
		} else {
			if (yych == 'm') goto yy1411;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1391:
	YYDEBUG(1391, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy141;
			goto yy1406;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'e') goto yy1406;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1392:
	YYDEBUG(1392, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy141;
			goto yy1402;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'e') goto yy1402;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1393:
	YYDEBUG(1393, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1064;
		goto yy56;
	} else {
		if (yych <= '9') goto yy1396;
		if (yych <= ':') goto yy1064;
		goto yy56;
	}
yy1394:
	YYDEBUG(1394, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1064;
		goto yy56;
	} else {
		if (yych <= '4') goto yy1396;
		if (yych == ':') goto yy1064;
		goto yy56;
	}
yy1395:
	YYDEBUG(1395, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy1064;
	if (yych == ':') goto yy1064;
	goto yy56;
yy1396:
	YYDEBUG(1396, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1064;
		goto yy56;
	} else {
		if (yych <= '5') goto yy1397;
		if (yych == ':') goto yy1064;
		goto yy56;
	}
yy1397:
	YYDEBUG(1397, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(1398, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1067;
	if (yych <= '5') goto yy1399;
	if (yych <= '6') goto yy1400;
	goto yy1067;
yy1399:
	YYDEBUG(1399, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1401;
	goto yy56;
yy1400:
	YYDEBUG(1400, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy56;
yy1401:
	YYDEBUG(1401, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1075;
yy1402:
	YYDEBUG(1402, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'K') goto yy142;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'l') goto yy1403;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1403:
	YYDEBUG(1403, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'F') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'E') goto yy143;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'f') goto yy1404;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1404:
	YYDEBUG(1404, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy144;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 't') goto yy1405;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1405:
	YYDEBUG(1405, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy1205;
		if (yych == 'h') goto yy1205;
		goto yy3;
	}
yy1406:
	YYDEBUG(1406, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy166;
			goto yy139;
		} else {
			if (yych <= '@') goto yy166;
			if (yych <= 'R') goto yy142;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy166;
			goto yy142;
		} else {
			if (yych <= 's') goto yy1407;
			if (yych <= 'z') goto yy142;
			goto yy166;
		}
	}
yy1407:
	YYDEBUG(1407, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy143;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'd') goto yy1408;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1408:
	YYDEBUG(1408, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy144;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1409;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1409:
	YYDEBUG(1409, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy172;
		if (yych == 'y') goto yy172;
		goto yy3;
	}
yy1410:
	YYDEBUG(1410, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
		goto yy1418;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy142;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1418;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1411:
	YYDEBUG(1411, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy142;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'o') goto yy1412;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1412:
	YYDEBUG(1412, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy143;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'r') goto yy1413;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1413:
	YYDEBUG(1413, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy144;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'r') goto yy1414;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1414:
	YYDEBUG(1414, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'O') goto yy1415;
		if (yych != 'o') goto yy3;
	}
yy1415:
	YYDEBUG(1415, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1416;
	if (yych != 'w') goto yy56;
yy1416:
	YYDEBUG(1416, *YYCURSOR);
	++YYCURSOR;
yy1417:
	YYDEBUG(1417, *YYCURSOR);
#line 988 "parse_date.re"
	{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 21779 "parse_date.c"
yy1418:
	YYDEBUG(1418, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy143;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'y') goto yy1419;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1419:
	YYDEBUG(1419, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy139;
	} else {
		if (yych <= 'Z') goto yy144;
		if (yych <= '`') goto yy1420;
		if (yych <= 'z') goto yy144;
	}
yy1420:
	YYDEBUG(1420, *YYCURSOR);
#line 978 "parse_date.re"
	{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 21823 "parse_date.c"
yy1421:
	YYDEBUG(1421, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych <= 'Q') goto yy142;
			if (yych <= 'R') goto yy1427;
			goto yy1428;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'r') goto yy1427;
			if (yych <= 's') goto yy1428;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1422:
	YYDEBUG(1422, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy166;
			goto yy139;
		} else {
			if (yych <= '@') goto yy166;
			if (yych <= 'Q') goto yy142;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy166;
			goto yy142;
		} else {
			if (yych <= 'r') goto yy1423;
			if (yych <= 'z') goto yy142;
			goto yy166;
		}
	}
yy1423:
	YYDEBUG(1423, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy143;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 's') goto yy1424;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1424:
	YYDEBUG(1424, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy144;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'd') goto yy1425;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1425:
	YYDEBUG(1425, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'A') goto yy1426;
		if (yych != 'a') goto yy3;
	}
yy1426:
	YYDEBUG(1426, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy172;
	if (yych == 'y') goto yy172;
	goto yy56;
yy1427:
	YYDEBUG(1427, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy143;
			goto yy1238;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'd') goto yy1238;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1428:
	YYDEBUG(1428, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1104;
		} else {
			if (yych == ' ') goto yy1104;
			goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy143;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1429:
	YYDEBUG(1429, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy142;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 't') goto yy1430;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1430:
	YYDEBUG(1430, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy143;
			goto yy1238;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'h') goto yy1238;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1431:
	YYDEBUG(1431, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1429;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'n') goto yy1461;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1432:
	YYDEBUG(1432, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych == '-') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy147;
				goto yy3;
			} else {
				if (yych == 'I') goto yy1421;
				goto yy141;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'U') goto yy1422;
				goto yy141;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy1453;
				goto yy146;
			} else {
				if (yych <= 'u') goto yy1454;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1433:
	YYDEBUG(1433, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych == '-') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy147;
				goto yy3;
			} else {
				if (yych == 'D') goto yy1410;
				goto yy141;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'M') goto yy1411;
				goto yy141;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'l') {
				if (yych == 'd') goto yy1444;
				goto yy146;
			} else {
				if (yych <= 'm') goto yy1445;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1434:
	YYDEBUG(1434, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1406;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'e') goto yy1440;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1435:
	YYDEBUG(1435, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1402;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'e') goto yy1436;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1436:
	YYDEBUG(1436, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy1403;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'l') goto yy1437;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1437:
	YYDEBUG(1437, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'F') goto yy1404;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'e') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'f') goto yy1438;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1438:
	YYDEBUG(1438, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1405;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 't') goto yy1439;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1439:
	YYDEBUG(1439, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1205;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1223;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1440:
	YYDEBUG(1440, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy166;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy166;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1407;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy166;
			goto yy147;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy166;
				goto yy150;
			} else {
				if (yych <= 's') goto yy1441;
				if (yych <= 'z') goto yy150;
				goto yy166;
			}
		}
	}
yy1441:
	YYDEBUG(1441, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1408;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'd') goto yy1442;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1442:
	YYDEBUG(1442, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1409;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1443;
			if (yych <= 'z') goto yy152;
			goto yy3;
		}
	}
yy1443:
	YYDEBUG(1443, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy172;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'y') goto yy185;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1444:
	YYDEBUG(1444, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1418;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1451;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy1445:
	YYDEBUG(1445, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy1412;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'o') goto yy1446;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1446:
	YYDEBUG(1446, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1413;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'r') goto yy1447;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1447:
	YYDEBUG(1447, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1414;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'r') goto yy1448;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1448:
	YYDEBUG(1448, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'O') goto yy1415;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'o') goto yy1449;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1449:
	YYDEBUG(1449, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1416;
	if (yych != 'w') goto yy154;
	YYDEBUG(1450, *YYCURSOR);
	yyaccept = 29;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy147;
		goto yy1417;
	} else {
		if (yych <= '/') goto yy147;
		if (yych == '_') goto yy147;
		goto yy1417;
	}
yy1451:
	YYDEBUG(1451, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1419;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'y') goto yy1452;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1452:
	YYDEBUG(1452, *YYCURSOR);
	yyaccept = 30;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy1420;
		} else {
			if (yych == '.') goto yy1420;
			goto yy147;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1420;
			if (yych <= 'Z') goto yy144;
			goto yy1420;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy1420;
			if (yych <= 'z') goto yy152;
			goto yy1420;
		}
	}
yy1453:
	YYDEBUG(1453, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy3;
				goto yy147;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'Q') goto yy142;
				goto yy1427;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'S') goto yy1428;
				goto yy142;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy150;
				goto yy1459;
			} else {
				if (yych <= 's') goto yy1460;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1454:
	YYDEBUG(1454, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy166;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy166;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1423;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy166;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy166;
				goto yy150;
			} else {
				if (yych <= 'r') goto yy1455;
				if (yych <= 'z') goto yy150;
				goto yy166;
			}
		}
	}
yy1455:
	YYDEBUG(1455, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1424;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 's') goto yy1456;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1456:
	YYDEBUG(1456, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1425;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'd') goto yy1457;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1457:
	YYDEBUG(1457, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1426;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1458;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1458:
	YYDEBUG(1458, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy172;
	if (yych == 'y') goto yy185;
	goto yy154;
yy1459:
	YYDEBUG(1459, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1238;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'd') goto yy1267;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1460:
	YYDEBUG(1460, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1104;
			if (yych <= 0x1F) goto yy3;
			goto yy1104;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy147;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1461:
	YYDEBUG(1461, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1430;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1462;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1462:
	YYDEBUG(1462, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1238;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'h') goto yy1267;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1463:
	YYDEBUG(1463, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'R') goto yy1475;
			if (yych <= 'X') goto yy141;
			goto yy1476;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'q') goto yy141;
			goto yy1475;
		} else {
			if (yych == 'y') goto yy1476;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1464:
	YYDEBUG(1464, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy141;
			goto yy1469;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'd') goto yy1469;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1465:
	YYDEBUG(1465, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy141;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'n') goto yy1466;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1466:
	YYDEBUG(1466, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy166;
			goto yy139;
		} else {
			if (yych <= '@') goto yy166;
			if (yych <= 'C') goto yy142;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy166;
			goto yy142;
		} else {
			if (yych <= 'd') goto yy1467;
			if (yych <= 'z') goto yy142;
			goto yy166;
		}
	}
yy1467:
	YYDEBUG(1467, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy143;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1468;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1468:
	YYDEBUG(1468, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy144;
			goto yy1235;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'y') goto yy1235;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1469:
	YYDEBUG(1469, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy142;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'n') goto yy1470;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1470:
	YYDEBUG(1470, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy143;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'i') goto yy1471;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1471:
	YYDEBUG(1471, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy144;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'g') goto yy1472;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1472:
	YYDEBUG(1472, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy1473;
		if (yych != 'h') goto yy3;
	}
yy1473:
	YYDEBUG(1473, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1474;
	if (yych != 't') goto yy56;
yy1474:
	YYDEBUG(1474, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1420;
yy1475:
	YYDEBUG(1475, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych == 'C') goto yy1477;
				goto yy142;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'c') goto yy1477;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy1476:
	YYDEBUG(1476, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy193;
			goto yy195;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy193;
			goto yy196;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy193;
			if (yych <= '9') goto yy195;
			goto yy193;
		} else {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy193;
			if (yych <= 'z') goto yy142;
			goto yy193;
		}
	}
yy1477:
	YYDEBUG(1477, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy143;
			goto yy395;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'h') goto yy395;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1478:
	YYDEBUG(1478, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych == '-') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy147;
				goto yy3;
			} else {
				if (yych == 'R') goto yy1475;
				goto yy141;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'Y') goto yy1476;
				goto yy141;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'x') {
				if (yych == 'r') goto yy1490;
				goto yy146;
			} else {
				if (yych <= 'y') goto yy1491;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1479:
	YYDEBUG(1479, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1469;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'd') goto yy1484;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1480:
	YYDEBUG(1480, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1466;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'n') goto yy1481;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1481:
	YYDEBUG(1481, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy166;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy166;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1467;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy166;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy166;
				goto yy150;
			} else {
				if (yych <= 'd') goto yy1482;
				if (yych <= 'z') goto yy150;
				goto yy166;
			}
		}
	}
yy1482:
	YYDEBUG(1482, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1468;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1483;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy1483:
	YYDEBUG(1483, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1235;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'y') goto yy1264;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1484:
	YYDEBUG(1484, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1470;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'n') goto yy1485;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1485:
	YYDEBUG(1485, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy1471;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'i') goto yy1486;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1486:
	YYDEBUG(1486, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy1472;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'g') goto yy1487;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1487:
	YYDEBUG(1487, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1473;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1488;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1488:
	YYDEBUG(1488, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1474;
	if (yych != 't') goto yy154;
	YYDEBUG(1489, *YYCURSOR);
	yyaccept = 30;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy147;
		goto yy1420;
	} else {
		if (yych <= '/') goto yy147;
		if (yych == '_') goto yy147;
		goto yy1420;
	}
yy1490:
	YYDEBUG(1490, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy371;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'B') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'C') goto yy1477;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'c') goto yy1492;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy1491:
	YYDEBUG(1491, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy193;
			goto yy195;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy193;
				goto yy139;
			} else {
				if (yych <= ',') goto yy193;
				if (yych <= '-') goto yy371;
				goto yy195;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy147;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy193;
			goto yy142;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy193;
				goto yy147;
			} else {
				if (yych <= '`') goto yy193;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy1492:
	YYDEBUG(1492, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy395;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'h') goto yy406;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1493:
	YYDEBUG(1493, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'W') {
		if (yych <= 'N') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'O') goto yy1501;
			if (yych <= 'U') goto yy141;
			if (yych <= 'V') goto yy1502;
			goto yy1499;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'n') goto yy141;
			goto yy1501;
		} else {
			if (yych <= 'v') {
				if (yych <= 'u') goto yy141;
				goto yy1502;
			} else {
				if (yych <= 'w') goto yy1499;
				if (yych <= 'z') goto yy141;
				goto yy3;
			}
		}
	}
yy1494:
	YYDEBUG(1494, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'W') goto yy141;
			goto yy1498;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'x') goto yy1498;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1495:
	YYDEBUG(1495, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy141;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'n') goto yy1496;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1496:
	YYDEBUG(1496, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy142;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 't') goto yy1497;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1497:
	YYDEBUG(1497, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy143;
			goto yy1238;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'h') goto yy1238;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1498:
	YYDEBUG(1498, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy142;
			goto yy1428;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 't') goto yy1428;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1499:
	YYDEBUG(1499, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy139;
	} else {
		if (yych <= 'Z') goto yy142;
		if (yych <= '`') goto yy1500;
		if (yych <= 'z') goto yy142;
	}
yy1500:
	YYDEBUG(1500, *YYCURSOR);
#line 957 "parse_date.re"
	{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 23843 "parse_date.c"
yy1501:
	YYDEBUG(1501, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy142;
			goto yy1507;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'n') goto yy1507;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1502:
	YYDEBUG(1502, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'E') goto yy142;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'e') goto yy1503;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy1503:
	YYDEBUG(1503, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy143;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'm') goto yy1504;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1504:
	YYDEBUG(1504, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy144;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'b') goto yy1505;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1505:
	YYDEBUG(1505, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'E') goto yy1506;
		if (yych != 'e') goto yy3;
	}
yy1506:
	YYDEBUG(1506, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy205;
	if (yych == 'r') goto yy205;
	goto yy56;
yy1507:
	YYDEBUG(1507, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy139;
	} else {
		if (yych <= 'Z') goto yy143;
		if (yych <= '`') goto yy1508;
		if (yych <= 'z') goto yy143;
	}
yy1508:
	YYDEBUG(1508, *YYCURSOR);
#line 966 "parse_date.re"
	{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 23993 "parse_date.c"
yy1509:
	YYDEBUG(1509, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych == '-') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'N') {
				if (yych <= '/') goto yy147;
				if (yych <= '@') goto yy3;
				goto yy141;
			} else {
				if (yych <= 'O') goto yy1501;
				if (yych <= 'U') goto yy141;
				goto yy1502;
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= '^') {
				if (yych <= 'W') goto yy1499;
				if (yych <= 'Z') goto yy141;
				goto yy3;
			} else {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy3;
				goto yy146;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'o') goto yy1516;
				if (yych <= 'u') goto yy146;
				goto yy1517;
			} else {
				if (yych <= 'w') goto yy1515;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1510:
	YYDEBUG(1510, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy1498;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'x') goto yy1514;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1511:
	YYDEBUG(1511, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1496;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'n') goto yy1512;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1512:
	YYDEBUG(1512, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1497;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1513;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1513:
	YYDEBUG(1513, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1238;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'h') goto yy1267;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1514:
	YYDEBUG(1514, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1428;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1460;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1515:
	YYDEBUG(1515, *YYCURSOR);
	yyaccept = 31;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy1500;
		} else {
			if (yych == '.') goto yy1500;
			goto yy147;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1500;
			if (yych <= 'Z') goto yy142;
			goto yy1500;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy1500;
			if (yych <= 'z') goto yy150;
			goto yy1500;
		}
	}
yy1516:
	YYDEBUG(1516, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1507;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'n') goto yy1522;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1517:
	YYDEBUG(1517, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy371;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'E') goto yy1503;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'e') goto yy1518;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy1518:
	YYDEBUG(1518, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy1504;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'm') goto yy1519;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1519:
	YYDEBUG(1519, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy1505;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'b') goto yy1520;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1520:
	YYDEBUG(1520, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'E') goto yy1506;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'e') goto yy1521;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1521:
	YYDEBUG(1521, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy205;
	if (yych == 'r') goto yy376;
	goto yy154;
yy1522:
	YYDEBUG(1522, *YYCURSOR);
	yyaccept = 32;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy1508;
		} else {
			if (yych == '.') goto yy1508;
			goto yy147;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1508;
			if (yych <= 'Z') goto yy143;
			goto yy1508;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy1508;
			if (yych <= 'z') goto yy151;
			goto yy1508;
		}
	}
yy1523:
	YYDEBUG(1523, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy141;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 's') goto yy1524;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1524:
	YYDEBUG(1524, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy142;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 't') goto yy1525;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1525:
	YYDEBUG(1525, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy143;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'e') goto yy1526;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1526:
	YYDEBUG(1526, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy144;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'r') goto yy1527;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1527:
	YYDEBUG(1527, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'D') goto yy1528;
		if (yych != 'd') goto yy3;
	}
yy1528:
	YYDEBUG(1528, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1529;
	if (yych != 'a') goto yy56;
yy1529:
	YYDEBUG(1529, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1530;
	if (yych != 'y') goto yy56;
yy1530:
	YYDEBUG(1530, *YYCURSOR);
	++YYCURSOR;
yy1531:
	YYDEBUG(1531, *YYCURSOR);
#line 945 "parse_date.re"
	{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 24537 "parse_date.c"
yy1532:
	YYDEBUG(1532, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1524;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 's') goto yy1533;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1533:
	YYDEBUG(1533, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1525;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1534;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1534:
	YYDEBUG(1534, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1526;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'e') goto yy1535;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1535:
	YYDEBUG(1535, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1527;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'r') goto yy1536;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1536:
	YYDEBUG(1536, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy1528;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'd') goto yy1537;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1537:
	YYDEBUG(1537, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1529;
	if (yych != 'a') goto yy154;
	YYDEBUG(1538, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1530;
	if (yych != 'y') goto yy154;
	YYDEBUG(1539, *YYCURSOR);
	yyaccept = 33;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy147;
		goto yy1531;
	} else {
		if (yych <= '/') goto yy147;
		if (yych == '_') goto yy147;
		goto yy1531;
	}
}
#line 1719 "parse_date.re"

}

#define YYMAXFILL 31

timelib_time* timelib_strtotime(char *s, int len, struct timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper)
{
	Scanner in;
	int t;
	char *e = s + len - 1;

	memset(&in, 0, sizeof(in));
	in.errors = malloc(sizeof(struct timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	if (len > 0) {
		while (isspace(*s) && s < e) {
			s++;
		}
		while (isspace(*e) && e > s) {
			e--;
		}
	}
	if (e - s < 0) {
		in.time = timelib_time_ctor();
		add_error(&in, "Empty string");
		if (errors) {
			*errors = in.errors;
		} else {
			timelib_error_container_dtor(in.errors);
		}
		in.time->y = in.time->d = in.time->m = in.time->h = in.time->i = in.time->s = in.time->f = in.time->dst = in.time->z = TIMELIB_UNSET;
		in.time->is_localtime = in.time->zone_type = 0;
		return in.time;
	}
	e++;

	in.str = malloc((e - s) + YYMAXFILL);
	memset(in.str, 0, (e - s) + YYMAXFILL);
	memcpy(in.str, s, (e - s));
	in.lim = in.str + (e - s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->f = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;
	in.time->relative.days = TIMELIB_UNSET;

	do {
		t = scan(&in, tz_get_wrapper);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	/* do funky checking whether the parsed time was valid time */
	if (in.time->have_time && !timelib_valid_time( in.time->h, in.time->i, in.time->s)) {
		add_warning(&in, "The parsed time was invalid");
	}
	/* do funky checking whether the parsed date was valid date */
	if (in.time->have_date && !timelib_valid_date( in.time->y, in.time->m, in.time->d)) {
		add_warning(&in, "The parsed date was invalid");
	}

	free(in.str);
	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

#define TIMELIB_CHECK_NUMBER                                           \
		if (strchr("0123456789", *ptr) == NULL)                        \
		{                                                              \
			add_pbf_error(s, "Unexpected data found.", string, begin); \
		}

static void timelib_time_reset_fields(timelib_time *time)
{
	assert(time != NULL);

	time->y = 1970;
	time->m = 1;
	time->d = 1;
	time->h = time->i = time->s = 0;
	time->f = 0.0;
	time->tz_info = NULL;
}

static void timelib_time_reset_unset_fields(timelib_time *time)
{
	assert(time != NULL);

	if (time->y == TIMELIB_UNSET ) time->y = 1970;
	if (time->m == TIMELIB_UNSET ) time->m = 1;
	if (time->d == TIMELIB_UNSET ) time->d = 1;
	if (time->h == TIMELIB_UNSET ) time->h = 0;
	if (time->i == TIMELIB_UNSET ) time->i = 0;
	if (time->s == TIMELIB_UNSET ) time->s = 0;
	if (time->f == TIMELIB_UNSET ) time->f = 0.0;
}

timelib_time *timelib_parse_from_format(char *format, char *string, int len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper)
{
	char       *fptr = format;
	char       *ptr = string;
	char       *begin;
	timelib_sll tmp;
	Scanner in;
	Scanner *s = &in;
	int allow_extra = 0;

	memset(&in, 0, sizeof(in));
	in.errors = malloc(sizeof(struct timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->f = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	/* Loop over the format string */
	while (*fptr && *ptr) {
		begin = ptr;
		switch (*fptr) {
			case 'D': /* three letter day */
			case 'l': /* full day */
				{
					const timelib_relunit* tmprel = 0;

					tmprel = timelib_lookup_relunit((char **) &ptr);
					if (!tmprel) {
						add_pbf_error(s, "A textual day could not be found", string, begin);
						break;
					} else {
						in.time->have_relative = 1;
						in.time->relative.have_weekday_relative = 1;
						in.time->relative.weekday = tmprel->multiplier;
						in.time->relative.weekday_behavior = 1;
					}
				}
				break;
			case 'd': /* two digit day, with leading zero */
			case 'j': /* two digit day, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->d = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit day could not be found", string, begin);
				}
				break;
			case 'S': /* day suffix, ignored, nor checked */
				timelib_skip_day_suffix((char **) &ptr);
				break;
			case 'z': /* day of year - resets month (0 based) - also initializes everything else to !TIMELIB_UNSET */
				TIMELIB_CHECK_NUMBER;
				if ((tmp = timelib_get_nr((char **) &ptr, 3)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A three digit day-of-year could not be found", string, begin);
				} else {
					s->time->m = 1;
					s->time->d = tmp + 1;
					timelib_do_normalize(s->time);
				}
				break;

			case 'm': /* two digit month, with leading zero */
			case 'n': /* two digit month, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->m = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit month could not be found", string, begin);
				}
				break;
			case 'M': /* three letter month */
			case 'F': /* full month */
				tmp = timelib_lookup_month((char **) &ptr);
				if (!tmp) {
					add_pbf_error(s, "A textual month could not be found", string, begin);
				} else {
					s->time->m = tmp;
				}
				break;
			case 'y': /* two digit year */
				{
					int length = 0;
					TIMELIB_CHECK_NUMBER;
					if ((s->time->y = timelib_get_nr_ex((char **) &ptr, 2, &length)) == TIMELIB_UNSET) {
						add_pbf_error(s, "A two digit year could not be found", string, begin);
					}
					TIMELIB_PROCESS_YEAR(s->time->y, length);
				}
				break;
			case 'Y': /* four digit year */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->y = timelib_get_nr((char **) &ptr, 4)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A four digit year could not be found", string, begin);
				}
				break;
			case 'g': /* two digit hour, with leading zero */
			case 'h': /* two digit hour, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit hour could not be found", string, begin);
				}
				if (s->time->h > 12) {
					add_pbf_error(s, "Hour can not be higher than 12", string, begin);
				}
				break;
			case 'G': /* two digit hour, with leading zero */
			case 'H': /* two digit hour, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit hour could not be found", string, begin);
				}
				break;
			case 'a': /* am/pm/a.m./p.m. */
			case 'A': /* AM/PM/A.M./P.M. */
				if (s->time->h == TIMELIB_UNSET) {
					add_pbf_error(s, "Meridian can only come after an hour has been found", string, begin);
				} else if ((tmp = timelib_meridian_with_check((char **) &ptr, s->time->h)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A meridian could not be found", string, begin);
				} else {
					s->time->h += tmp;
				}
				break;
			case 'i': /* two digit minute, with leading zero */
				{
					int length;
					timelib_sll min;

					TIMELIB_CHECK_NUMBER;
					min = timelib_get_nr_ex((char **) &ptr, 2, &length);
					if (min == TIMELIB_UNSET || length != 2) {
						add_pbf_error(s, "A two digit minute could not be found", string, begin);
					} else {
						s->time->i = min;
					}
				}
				break;
			case 's': /* two digit second, with leading zero */
				{
					int length;
					timelib_sll sec;

					TIMELIB_CHECK_NUMBER;
					sec = timelib_get_nr_ex((char **) &ptr, 2, &length);
					if (sec == TIMELIB_UNSET || length != 2) {
						add_pbf_error(s, "A two digit second could not be found", string, begin);
					} else {
						s->time->s = sec;
					}
				}
				break;
			case 'u': /* up to six digit millisecond */
				{
					double f;
					char *tptr;

					TIMELIB_CHECK_NUMBER;
					tptr = ptr;
					if ((f = timelib_get_nr((char **) &ptr, 6)) == TIMELIB_UNSET || (ptr - tptr < 1)) {
						add_pbf_error(s, "A six digit millisecond could not be found", string, begin);
					} else {
						s->time->f = (f / pow(10, (ptr - tptr)));
					}
				}
				break;
			case ' ': /* any sort of whitespace (' ' and \t) */
				timelib_eat_spaces((char **) &ptr);
				break;
			case 'U': /* epoch seconds */
				TIMELIB_CHECK_NUMBER;
				TIMELIB_HAVE_RELATIVE();
				tmp = timelib_get_unsigned_nr((char **) &ptr, 24);
				s->time->y = 1970;
				s->time->m = 1;
				s->time->d = 1;
				s->time->h = s->time->i = s->time->s = 0;
				s->time->f = 0.0;
				s->time->relative.s += tmp;
				s->time->is_localtime = 1;
				s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
				s->time->z = 0;
				s->time->dst = 0;
				break;

			case 'e': /* timezone */
			case 'P': /* timezone */
			case 'T': /* timezone */
			case 'O': /* timezone */
				{
					int tz_not_found;
					s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
					if (tz_not_found) {
						add_pbf_error(s, "The timezone could not be found in the database", string, begin);
					}
				}
				break;

			case '#': /* separation symbol */
				if (*ptr == ';' || *ptr == ':' || *ptr == '/' || *ptr == '.' || *ptr == ',' || *ptr == '-' || *ptr == '(' || *ptr == ')') {
					++ptr;
				} else {
					add_pbf_error(s, "The separation symbol ([;:/.,-]) could not be found", string, begin);
				}
				break;

			case ';':
			case ':':
			case '/':
			case '.':
			case ',':
			case '-':
			case '(':
			case ')':
				if (*ptr == *fptr) {
					++ptr;
				} else {
					add_pbf_error(s, "The separation symbol could not be found", string, begin);
				}
				break;

			case '!': /* reset all fields to default */
				timelib_time_reset_fields(s->time);
				break; /* break intentionally not missing */

			case '|': /* reset all fields to default when not set */
				timelib_time_reset_unset_fields(s->time);
				break; /* break intentionally not missing */

			case '?': /* random char */
				++ptr;
				break;

			case '\\': /* escaped char */
				if(!fptr[1]) {
					add_pbf_error(s, "Escaped character expected", string, begin);
					break;
				}
				fptr++;
				if (*ptr == *fptr) {
					++ptr;
				} else {
					add_pbf_error(s, "The escaped character could not be found", string, begin);
				}
				break;

			case '*': /* random chars until a separator or number ([ \t.,:;/-0123456789]) */
				timelib_eat_until_separator((char **) &ptr);
				break;

			case '+': /* allow extra chars in the format */
				allow_extra = 1;
				break;

			default:
				if (*fptr != *ptr) {
					add_pbf_error(s, "The format separator does not match", string, begin);
				}
				ptr++;
		}
		fptr++;
	}
	if (*ptr) {
		if (allow_extra) {
			add_pbf_warning(s, "Trailing data", string, ptr);
		} else {
			add_pbf_error(s, "Trailing data", string, ptr);
		}
	}
	/* ignore trailing +'s */
	while (*fptr == '+') {
		fptr++;
	}
	if (*fptr) {
		/* Trailing | and ! specifiers are valid. */
		int done = 0;
		while (*fptr && !done) {
			switch (*fptr++) {
				case '!': /* reset all fields to default */
					timelib_time_reset_fields(s->time);
					break;

				case '|': /* reset all fields to default when not set */
					timelib_time_reset_unset_fields(s->time);
					break;

				default:
					add_pbf_error(s, "Data missing", string, ptr);
					done = 1;
			}
		}
	}

	/* clean up a bit */
	if (s->time->h != TIMELIB_UNSET || s->time->i != TIMELIB_UNSET || s->time->s != TIMELIB_UNSET) {
		if (s->time->h == TIMELIB_UNSET ) {
			s->time->h = 0;
		}
		if (s->time->i == TIMELIB_UNSET ) {
			s->time->i = 0;
		}
		if (s->time->s == TIMELIB_UNSET ) {
			s->time->s = 0;
		}
	}

	/* do funky checking whether the parsed time was valid time */
	if (s->time->h != TIMELIB_UNSET && s->time->i != TIMELIB_UNSET &&
		s->time->s != TIMELIB_UNSET &&
		!timelib_valid_time( s->time->h, s->time->i, s->time->s)) {
		add_pbf_warning(s, "The parsed time was invalid", string, ptr);
	}
	/* do funky checking whether the parsed date was valid date */
	if (s->time->y != TIMELIB_UNSET && s->time->m != TIMELIB_UNSET &&
		s->time->d != TIMELIB_UNSET &&
		!timelib_valid_date( s->time->y, s->time->m, s->time->d)) {
		add_pbf_warning(s, "The parsed date was invalid", string, ptr);
	}

	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options & TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->f = 0;
	}
	if (parsed->y == TIMELIB_UNSET) parsed->y = now->y != TIMELIB_UNSET ? now->y : 0;
	if (parsed->d == TIMELIB_UNSET) parsed->d = now->d != TIMELIB_UNSET ? now->d : 0;
	if (parsed->m == TIMELIB_UNSET) parsed->m = now->m != TIMELIB_UNSET ? now->m : 0;
	if (parsed->h == TIMELIB_UNSET) parsed->h = now->h != TIMELIB_UNSET ? now->h : 0;
	if (parsed->i == TIMELIB_UNSET) parsed->i = now->i != TIMELIB_UNSET ? now->i : 0;
	if (parsed->s == TIMELIB_UNSET) parsed->s = now->s != TIMELIB_UNSET ? now->s : 0;
	if (parsed->f == TIMELIB_UNSET) parsed->f = now->f != TIMELIB_UNSET ? now->f : 0;
	if (parsed->z == TIMELIB_UNSET) parsed->z = now->z != TIMELIB_UNSET ? now->z : 0;
	if (parsed->dst == TIMELIB_UNSET) parsed->dst = now->dst != TIMELIB_UNSET ? now->dst : 0;

	if (!parsed->tz_abbr) {
		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
	}
	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? (!(options & TIMELIB_NO_CLONE) ? timelib_tzinfo_clone(now->tz_info) : now->tz_info) : NULL;
	}
	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

char *timelib_timezone_id_from_abbr(const char *abbr, long gmtoffset, int isdst)
{
	const timelib_tz_lookup_table *tp;

	tp = abbr_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

const timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS",
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;
}
#endif

/*
 * vim: syntax=c
 */
