#!/bin/sh

test_description="simple tests for mmpfb - part of LCDF Typetools"

. /usr/share/sharness/sharness.sh

OTF=/usr/share/fonts/truetype/noto/NotoSans-Regular.ttf

test_expect_success "mmpfb version" "
    mmpfb --version > out &&
    grep -x 'mmpfb (LCDF typetools) [0-9.]\+' out
"

test_expect_success "mmpfb help" "
    mmpfb --help > out &&
    grep -Fx 'Usage: mmpfb [OPTION]... FONT' out
"

test_expect_success "mmpfb fail parse OpenType" "
    test_expect_code 1 mmpfb $OTF
"

test_done
