#!/usr/bin/python
# -*- coding: utf-8 -*-
### BEGIN LICENSE
# Copyright (C) 2009 Jono Bacon <jono@ubuntu.com>
# Copyright (C) 2010 Michael Budde <mbudde@gmail.com>
#
#This program is free software: you can redistribute it and/or modify it
#under the terms of the GNU General Public License version 3, as published
#by the Free Software Foundation.
#
#This program is distributed in the hope that it will be useful, but
#WITHOUT ANY WARRANTY; without even the implied warranties of
#MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
#PURPOSE.  See the GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License along
#with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE


import optparse

from lernid.lernidconfig import VERSION

_instance = None

class Options(object):

    def __init__(self):
        self.option_list = []

    @classmethod
    def get_instance(cls):
        global _instance
        if not _instance:
            _instance = cls()
        return _instance

    @classmethod
    def add_option(cls, *args, **kwargs):
        opt = optparse.make_option(*args, **kwargs)
        cls.get_instance().option_list.append(opt)

    @classmethod
    def parse_args(cls):
        inst = cls.get_instance()
        parser = optparse.OptionParser(version='%prog {0}'.format(VERSION), option_list=inst.option_list)
        options, args = parser.parse_args()
        inst.options = options
        inst.args = args

    @classmethod
    def get(cls, name, default=None):
        val = getattr(cls.get_instance().options, name.replace('-', '_'))
        if val == None:
            return default
        return val

