; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-unknown \
; RUN:   -mcpu=pwr8 -ppc-asm-full-reg-names -ppc-track-subreg-liveness \
; RUN:   -ppc-quadword-atomics < %s | FileCheck --check-prefix=P8 %s

define dso_local i128 @lq_unordered(i128* %src) {
; P8-LABEL: lq_unordered:
; P8:       # %bb.0: # %entry
; P8-NEXT:    lq r4, 0(r3)
; P8-NEXT:    mr r3, r4
; P8-NEXT:    mr r4, r5
; P8-NEXT:    blr
entry:
  %0 = load atomic i128, i128* %src unordered, align 16
  ret i128 %0
}

define dso_local i128 @lqx_unordered(i128* %src, i64 %idx) {
; P8-LABEL: lqx_unordered:
; P8:       # %bb.0: # %entry
; P8-NEXT:    sldi r4, r4, 4
; P8-NEXT:    add r3, r3, r4
; P8-NEXT:    lq r4, 0(r3)
; P8-NEXT:    mr r3, r4
; P8-NEXT:    mr r4, r5
; P8-NEXT:    blr
entry:
  %0 = getelementptr i128, i128* %src, i64 %idx
  %1 = load atomic i128, i128* %0 unordered, align 16
  ret i128 %1
}

define dso_local i128 @lq_big_offset_unordered(i128* %src) {
; P8-LABEL: lq_big_offset_unordered:
; P8:       # %bb.0: # %entry
; P8-NEXT:    lis r4, 32
; P8-NEXT:    add r3, r3, r4
; P8-NEXT:    lq r4, 0(r3)
; P8-NEXT:    mr r3, r4
; P8-NEXT:    mr r4, r5
; P8-NEXT:    blr
entry:
  %0 = getelementptr i128, i128* %src, i64 131072
  %1 = load atomic i128, i128* %0 unordered, align 16
  ret i128 %1
}

define dso_local i128 @lq_monotonic(i128* %src) {
; P8-LABEL: lq_monotonic:
; P8:       # %bb.0: # %entry
; P8-NEXT:    lq r4, 0(r3)
; P8-NEXT:    mr r3, r4
; P8-NEXT:    mr r4, r5
; P8-NEXT:    blr
entry:
  %0 = load atomic i128, i128* %src monotonic, align 16
  ret i128 %0
}

define dso_local i128 @lq_acquire(i128* %src) {
; P8-LABEL: lq_acquire:
; P8:       # %bb.0: # %entry
; P8-NEXT:    lq r4, 0(r3)
; P8-NEXT:    cmpd cr7, r5, r5
; P8-NEXT:    mr r3, r4
; P8-NEXT:    mr r4, r5
; P8-NEXT:    bne- cr7, .+4
; P8-NEXT:    isync
; P8-NEXT:    blr
entry:
  %0 = load atomic i128, i128* %src acquire, align 16
  ret i128 %0
}

define dso_local i128 @lq_seqcst(i128* %src) {
; P8-LABEL: lq_seqcst:
; P8:       # %bb.0: # %entry
; P8-NEXT:    sync
; P8-NEXT:    lq r4, 0(r3)
; P8-NEXT:    cmpd cr7, r5, r5
; P8-NEXT:    mr r3, r4
; P8-NEXT:    mr r4, r5
; P8-NEXT:    bne- cr7, .+4
; P8-NEXT:    isync
; P8-NEXT:    blr
entry:
  %0 = load atomic i128, i128* %src seq_cst, align 16
  ret i128 %0
}

define dso_local void @stq_unordered(i128 %val, i128* %dst) {
; P8-LABEL: stq_unordered:
; P8:       # %bb.0: # %entry
; P8-NEXT:    mr r7, r4
; P8-NEXT:    mr r6, r3
; P8-NEXT:    stq r6, 0(r5)
; P8-NEXT:    blr
entry:
  store atomic i128 %val, i128* %dst unordered, align 16
  ret void
}

define dso_local void @stqx_unordered(i128 %val, i128* %dst, i64 %idx) {
; P8-LABEL: stqx_unordered:
; P8:       # %bb.0: # %entry
; P8-NEXT:    sldi r6, r6, 4
; P8-NEXT:    mr r9, r4
; P8-NEXT:    mr r8, r3
; P8-NEXT:    add r3, r5, r6
; P8-NEXT:    stq r8, 0(r3)
; P8-NEXT:    blr
entry:
  %0 = getelementptr i128, i128* %dst, i64 %idx
  store atomic i128 %val, i128* %0 unordered, align 16
  ret void
}

define dso_local void @stq_big_offset_unordered(i128 %val, i128* %dst) {
; P8-LABEL: stq_big_offset_unordered:
; P8:       # %bb.0: # %entry
; P8-NEXT:    lis r6, 32
; P8-NEXT:    mr r9, r4
; P8-NEXT:    mr r8, r3
; P8-NEXT:    add r3, r5, r6
; P8-NEXT:    stq r8, 0(r3)
; P8-NEXT:    blr
entry:
  %0 = getelementptr i128, i128* %dst, i64 131072
  store atomic i128 %val, i128* %0 unordered, align 16
  ret void
}

define dso_local void @stq_monotonic(i128 %val, i128* %dst) {
; P8-LABEL: stq_monotonic:
; P8:       # %bb.0: # %entry
; P8-NEXT:    mr r7, r4
; P8-NEXT:    mr r6, r3
; P8-NEXT:    stq r6, 0(r5)
; P8-NEXT:    blr
entry:
  store atomic i128 %val, i128* %dst monotonic, align 16
  ret void
}

define dso_local void @stq_release(i128 %val, i128* %dst) {
; P8-LABEL: stq_release:
; P8:       # %bb.0: # %entry
; P8-NEXT:    lwsync
; P8-NEXT:    mr r7, r4
; P8-NEXT:    mr r6, r3
; P8-NEXT:    stq r6, 0(r5)
; P8-NEXT:    blr
entry:
  store atomic i128 %val, i128* %dst release, align 16
  ret void
}

define dso_local void @stq_seqcst(i128 %val, i128* %dst) {
; P8-LABEL: stq_seqcst:
; P8:       # %bb.0: # %entry
; P8-NEXT:    sync
; P8-NEXT:    mr r7, r4
; P8-NEXT:    mr r6, r3
; P8-NEXT:    stq r6, 0(r5)
; P8-NEXT:    blr
entry:
  store atomic i128 %val, i128* %dst seq_cst, align 16
  ret void
}
