; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -instcombine -S  < %s | FileCheck %s

target datalayout = "e-p:32:32:32-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:32:32-f32:32:32-f64:32:32-v64:64:64-v128:128:128-a0:0:64"

define i32 *@test1(i32* %A, i32 %Offset) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    [[RHS_IDX:%.*]] = phi i32 [ [[RHS_ADD:%.*]], [[BB]] ], [ [[OFFSET:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[RHS_ADD]] = add nsw i32 [[RHS_IDX]], 1
; CHECK-NEXT:    [[COND:%.*]] = icmp sgt i32 [[RHS_IDX]], 100
; CHECK-NEXT:    br i1 [[COND]], label [[BB2:%.*]], label [[BB]]
; CHECK:       bb2:
; CHECK-NEXT:    [[RHS_PTR:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i32 [[RHS_IDX]]
; CHECK-NEXT:    ret i32* [[RHS_PTR]]
;
entry:
  %tmp = getelementptr inbounds i32, i32* %A, i32 %Offset
  br label %bb

bb:
  %RHS = phi i32* [ %RHS.next, %bb ], [ %tmp, %entry ]
  %LHS = getelementptr inbounds i32, i32* %A, i32 100
  %RHS.next = getelementptr inbounds i32, i32* %RHS, i64 1
  %cond = icmp ult i32 * %LHS, %RHS
  br i1 %cond, label %bb2, label %bb

bb2:
  ret i32* %RHS
}

define i32 *@test2(i32 %A, i32 %Offset) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    [[RHS_IDX:%.*]] = phi i32 [ [[RHS_ADD:%.*]], [[BB]] ], [ [[OFFSET:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[RHS_ADD]] = add nsw i32 [[RHS_IDX]], 1
; CHECK-NEXT:    [[COND:%.*]] = icmp sgt i32 [[RHS_IDX]], 100
; CHECK-NEXT:    br i1 [[COND]], label [[BB2:%.*]], label [[BB]]
; CHECK:       bb2:
; CHECK-NEXT:    [[RHSTO_PTR:%.*]] = inttoptr i32 [[A:%.*]] to i32*
; CHECK-NEXT:    [[RHS_PTR:%.*]] = getelementptr inbounds i32, i32* [[RHSTO_PTR]], i32 [[RHS_IDX]]
; CHECK-NEXT:    ret i32* [[RHS_PTR]]
;
entry:
  %A.ptr = inttoptr i32 %A to i32*
  %tmp = getelementptr inbounds i32, i32* %A.ptr, i32 %Offset
  br label %bb

bb:
  %RHS = phi i32* [ %RHS.next, %bb ], [ %tmp, %entry ]
  %LHS = getelementptr inbounds i32, i32* %A.ptr, i32 100
  %RHS.next = getelementptr inbounds i32, i32* %RHS, i64 1
  %cmp0 = ptrtoint i32 *%LHS to i32
  %cmp1 = ptrtoint i32 *%RHS to i32
  %cond = icmp ult i32 %cmp0, %cmp1
  br i1 %cond, label %bb2, label %bb

bb2:
  ret i32* %RHS
}

; Perform the transformation only if we know that the GEPs used are inbounds.
define i32 *@test3(i32* %A, i32 %Offset) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP:%.*]] = getelementptr i32, i32* [[A:%.*]], i32 [[OFFSET:%.*]]
; CHECK-NEXT:    br label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    [[RHS:%.*]] = phi i32* [ [[RHS_NEXT:%.*]], [[BB]] ], [ [[TMP]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[LHS:%.*]] = getelementptr i32, i32* [[A]], i32 100
; CHECK-NEXT:    [[RHS_NEXT]] = getelementptr i32, i32* [[RHS]], i32 1
; CHECK-NEXT:    [[COND:%.*]] = icmp ult i32* [[LHS]], [[RHS]]
; CHECK-NEXT:    br i1 [[COND]], label [[BB2:%.*]], label [[BB]]
; CHECK:       bb2:
; CHECK-NEXT:    ret i32* [[RHS]]
;
entry:
  %tmp = getelementptr i32, i32* %A, i32 %Offset
  br label %bb

bb:
  %RHS = phi i32* [ %RHS.next, %bb ], [ %tmp, %entry ]
  %LHS = getelementptr i32, i32* %A, i32 100
  %RHS.next = getelementptr i32, i32* %RHS, i64 1
  %cond = icmp ult i32 * %LHS, %RHS
  br i1 %cond, label %bb2, label %bb

bb2:
  ret i32* %RHS
}

; An inttoptr that requires an extension or truncation will be opaque when determining
; the base pointer. In this case we can still perform the transformation by considering
; A.ptr as being the base pointer.
define i32 *@test4(i16 %A, i32 %Offset) {
; CHECK-LABEL: @test4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    [[RHS_IDX:%.*]] = phi i32 [ [[RHS_ADD:%.*]], [[BB]] ], [ [[OFFSET:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[RHS_ADD]] = add nsw i32 [[RHS_IDX]], 1
; CHECK-NEXT:    [[COND:%.*]] = icmp sgt i32 [[RHS_IDX]], 100
; CHECK-NEXT:    br i1 [[COND]], label [[BB2:%.*]], label [[BB]]
; CHECK:       bb2:
; CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[A:%.*]] to i32
; CHECK-NEXT:    [[RHSTO_PTR:%.*]] = inttoptr i32 [[TMP0]] to i32*
; CHECK-NEXT:    [[RHS_PTR:%.*]] = getelementptr inbounds i32, i32* [[RHSTO_PTR]], i32 [[RHS_IDX]]
; CHECK-NEXT:    ret i32* [[RHS_PTR]]
;
entry:
  %A.ptr = inttoptr i16 %A to i32*
  %tmp = getelementptr inbounds i32, i32* %A.ptr, i32 %Offset
  br label %bb

bb:
  %RHS = phi i32* [ %RHS.next, %bb ], [ %tmp, %entry ]
  %LHS = getelementptr inbounds i32, i32* %A.ptr, i32 100
  %RHS.next = getelementptr inbounds i32, i32* %RHS, i64 1
  %cmp0 = ptrtoint i32 *%LHS to i32
  %cmp1 = ptrtoint i32 *%RHS to i32
  %cond = icmp ult i32 %cmp0, %cmp1
  br i1 %cond, label %bb2, label %bb

bb2:
  ret i32* %RHS
}

declare i32* @fun_ptr()

define i32 *@test5(i32 %Offset) personality i8* bitcast (i32 (...)* @__gxx_personality_v0 to i8*) {
; CHECK-LABEL: @test5(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = invoke i32* @fun_ptr()
; CHECK-NEXT:    to label [[CONT:%.*]] unwind label [[LPAD:%.*]]
; CHECK:       cont:
; CHECK-NEXT:    br label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    [[RHS_IDX:%.*]] = phi i32 [ [[RHS_ADD:%.*]], [[BB]] ], [ [[OFFSET:%.*]], [[CONT]] ]
; CHECK-NEXT:    [[RHS_ADD]] = add nsw i32 [[RHS_IDX]], 1
; CHECK-NEXT:    [[COND:%.*]] = icmp sgt i32 [[RHS_IDX]], 100
; CHECK-NEXT:    br i1 [[COND]], label [[BB2:%.*]], label [[BB]]
; CHECK:       bb2:
; CHECK-NEXT:    [[RHS_PTR:%.*]] = getelementptr inbounds i32, i32* [[A]], i32 [[RHS_IDX]]
; CHECK-NEXT:    ret i32* [[RHS_PTR]]
; CHECK:       lpad:
; CHECK-NEXT:    [[L:%.*]] = landingpad { i8*, i32 }
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    ret i32* null
;
entry:
  %A = invoke i32 *@fun_ptr() to label %cont unwind label %lpad

cont:
  %tmp = getelementptr inbounds i32, i32* %A, i32 %Offset
  br label %bb

bb:
  %RHS = phi i32* [ %RHS.next, %bb ], [ %tmp, %cont ]
  %LHS = getelementptr inbounds i32, i32* %A, i32 100
  %RHS.next = getelementptr inbounds i32, i32* %RHS, i64 1
  %cond = icmp ult i32 * %LHS, %RHS
  br i1 %cond, label %bb2, label %bb

bb2:
  ret i32* %RHS

lpad:
  %l = landingpad { i8*, i32 } cleanup
  ret i32* null
}

declare i32 @fun_i32()

define i32 *@test6(i32 %Offset) personality i8* bitcast (i32 (...)* @__gxx_personality_v0 to i8*) {
; CHECK-LABEL: @test6(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = invoke i32 @fun_i32()
; CHECK-NEXT:    to label [[CONT:%.*]] unwind label [[LPAD:%.*]]
; CHECK:       cont:
; CHECK-NEXT:    br label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    [[RHS_IDX:%.*]] = phi i32 [ [[RHS_ADD:%.*]], [[BB]] ], [ [[OFFSET:%.*]], [[CONT]] ]
; CHECK-NEXT:    [[RHS_ADD]] = add nsw i32 [[RHS_IDX]], 1
; CHECK-NEXT:    [[COND:%.*]] = icmp sgt i32 [[RHS_IDX]], 100
; CHECK-NEXT:    br i1 [[COND]], label [[BB2:%.*]], label [[BB]]
; CHECK:       bb2:
; CHECK-NEXT:    [[RHSTO_PTR:%.*]] = inttoptr i32 [[A]] to i32*
; CHECK-NEXT:    [[RHS_PTR:%.*]] = getelementptr inbounds i32, i32* [[RHSTO_PTR]], i32 [[RHS_IDX]]
; CHECK-NEXT:    ret i32* [[RHS_PTR]]
; CHECK:       lpad:
; CHECK-NEXT:    [[L:%.*]] = landingpad { i8*, i32 }
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    ret i32* null
;
entry:
  %A = invoke i32 @fun_i32() to label %cont unwind label %lpad

cont:
  %A.ptr = inttoptr i32 %A to i32*
  %tmp = getelementptr inbounds i32, i32* %A.ptr, i32 %Offset
  br label %bb

bb:
  %RHS = phi i32* [ %RHS.next, %bb ], [ %tmp, %cont ]
  %LHS = getelementptr inbounds i32, i32* %A.ptr, i32 100
  %RHS.next = getelementptr inbounds i32, i32* %RHS, i64 1
  %cond = icmp ult i32 * %LHS, %RHS
  br i1 %cond, label %bb2, label %bb

bb2:
  ret i32* %RHS

lpad:
  %l = landingpad { i8*, i32 } cleanup
  ret i32* null
}


@pr30402 = constant i64 3
define i1 @test7() {
; CHECK-LABEL: @test7(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[BB7:%.*]]
; CHECK:       bb7:
; CHECK-NEXT:    [[CMP:%.*]] = phi i1 [ true, [[BB7]] ], [ false, [[ENTRY:%.*]] ]
; CHECK-NEXT:    br i1 [[CMP]], label [[BB10:%.*]], label [[BB7]]
; CHECK:       bb10:
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  br label %bb7

bb7:                                              ; preds = %bb10, %entry-block
  %phi = phi i64* [ @pr30402, %entry ], [ getelementptr inbounds (i64, i64* @pr30402, i32 1), %bb7 ]
  %cmp = icmp eq i64* %phi, getelementptr inbounds (i64, i64* @pr30402, i32 1)
  br i1 %cmp, label %bb10, label %bb7

bb10:
  ret i1 %cmp
}

; It is not generally safe to hoist an expression (sdiv) that may trap.

define i1 @PR50906() {
; CHECK-LABEL: @PR50906(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[PHI:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ 1, [[NEXT:%.*]] ]
; CHECK-NEXT:    br label [[NEXT]]
; CHECK:       next:
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[PHI]], sdiv (i32 7, i32 ptrtoint (i1 ()* @PR50906 to i32))
; CHECK-NEXT:    br i1 [[CMP]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  br label %loop

loop:
  %phi = phi i32 [ 0, %entry ], [ 1, %next ]
  br label %next

next:
  %cmp = icmp sgt i32 sdiv (i32 7, i32 ptrtoint (i1 ()* @PR50906 to i32)), %phi
  br i1 %cmp, label %exit, label %loop

exit:
  ret i1 %cmp
}

declare i32 @__gxx_personality_v0(...)

define i1 @test8(i64* %in, i64 %offset) {
; CHECK-LABEL: @test8(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[LD:%.*]] = load i64, i64* [[IN:%.*]], align 8
; CHECK-NEXT:    [[TMP0:%.*]] = trunc i64 [[LD]] to i32
; CHECK-NEXT:    [[CASTI8:%.*]] = inttoptr i32 [[TMP0]] to i8*
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i64 [[OFFSET:%.*]] to i32
; CHECK-NEXT:    [[GEPI8:%.*]] = getelementptr inbounds i8, i8* [[CASTI8]], i32 [[TMP1]]
; CHECK-NEXT:    [[CAST:%.*]] = bitcast i8* [[GEPI8]] to i32**
; CHECK-NEXT:    [[TMP2:%.*]] = trunc i64 [[LD]] to i32
; CHECK-NEXT:    [[PTRCAST:%.*]] = inttoptr i32 [[TMP2]] to i32**
; CHECK-NEXT:    [[GEPI32:%.*]] = getelementptr inbounds i32*, i32** [[PTRCAST]], i32 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32** [[GEPI32]], [[CAST]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
entry:
  %ld = load i64, i64* %in, align 8
  %casti8 = inttoptr i64 %ld to i8*
  %gepi8 = getelementptr inbounds i8, i8* %casti8, i64 %offset
  %cast = bitcast i8* %gepi8 to i32**
  %ptrcast = inttoptr i64 %ld to i32**
  %gepi32 = getelementptr inbounds i32*, i32** %ptrcast, i64 1
  %cmp = icmp eq i32** %gepi32, %cast
  ret i1 %cmp
}

define void @test_zero_offset_cycle({ i64, i64 }* %arg) {
; CHECK-LABEL: @test_zero_offset_cycle(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    br i1 true, label [[LOOP]], label [[LOOP_CONT:%.*]]
; CHECK:       loop.cont:
; CHECK-NEXT:    br label [[LOOP]]
;
entry:
  %gep = getelementptr inbounds { i64, i64 }, { i64, i64 }* %arg, i32 0, i32 1
  %gep.int = ptrtoint i64* %gep to i32
  br label %loop

loop:
  %phi = phi i32 [ %gep.int, %entry ], [ %gep.int2, %loop.cont ], [ %phi, %loop ]
  %phi.ptr = inttoptr i32 %phi to i64*
  %cmp = icmp eq i64* %gep, %phi.ptr
  br i1 %cmp, label %loop, label %loop.cont

loop.cont:
  %gep.int2 = ptrtoint i64* %gep to i32
  br label %loop
}
