; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -march=mipsel -mcpu=mips32   < %s | FileCheck -check-prefixes=MIPS-GT-R1,MIPS32-R1-R2 %s
; RUN: llc -march=mipsel -mcpu=mips32r2 < %s | FileCheck -check-prefixes=MIPS-GT-R1,MIPS32-R1-R2 %s
; RUN: llc -march=mipsel -mcpu=mips32r6 < %s | FileCheck -check-prefixes=MIPS-GT-R1,MIPS32-R6 %s
; RUN: llc -march=mips64el -mcpu=mips64   < %s | FileCheck -check-prefixes=MIPS-GT-R1,MIPS64-GT-R1 %s
; RUN: llc -march=mips64el -mcpu=mips64r2 < %s | FileCheck -check-prefixes=MIPS-GT-R1,MIPS64-GT-R1 %s
; RUN: llc -march=mips64el -mcpu=mips64r6 < %s | FileCheck -check-prefixes=MIPS-GT-R1,MIPS64-GT-R1 %s
; RUN: llc -march=mips64el -mcpu=mips4    < %s | FileCheck -check-prefixes=MIPS4 %s

; Prefixes:
;   ALL      - All
;   MIPS-GT-R1 - MIPS32r1/MIPS64r1 and above
;   MIPS64-GT-R1 - MIPS64r1 and above

define i32 @ctlz_i32(i32 signext %X) nounwind readnone {
; MIPS-GT-R1-LABEL: ctlz_i32:
; MIPS-GT-R1:       # %bb.0: # %entry
; MIPS-GT-R1-NEXT:    jr $ra
; MIPS-GT-R1-NEXT:    clz $2, $4
;
; MIPS4-LABEL: ctlz_i32:
; MIPS4:       # %bb.0: # %entry
; MIPS4-NEXT:    srl $1, $4, 1
; MIPS4-NEXT:    or $1, $4, $1
; MIPS4-NEXT:    srl $2, $1, 2
; MIPS4-NEXT:    or $1, $1, $2
; MIPS4-NEXT:    srl $2, $1, 4
; MIPS4-NEXT:    lui $3, 21845
; MIPS4-NEXT:    lui $4, 13107
; MIPS4-NEXT:    lui $5, 3855
; MIPS4-NEXT:    or $1, $1, $2
; MIPS4-NEXT:    ori $2, $5, 3855
; MIPS4-NEXT:    ori $4, $4, 13107
; MIPS4-NEXT:    ori $3, $3, 21845
; MIPS4-NEXT:    srl $5, $1, 8
; MIPS4-NEXT:    or $1, $1, $5
; MIPS4-NEXT:    srl $5, $1, 16
; MIPS4-NEXT:    nor $1, $1, $5
; MIPS4-NEXT:    srl $5, $1, 1
; MIPS4-NEXT:    and $3, $5, $3
; MIPS4-NEXT:    subu $1, $1, $3
; MIPS4-NEXT:    and $3, $1, $4
; MIPS4-NEXT:    srl $1, $1, 2
; MIPS4-NEXT:    and $1, $1, $4
; MIPS4-NEXT:    addu $1, $3, $1
; MIPS4-NEXT:    srl $3, $1, 4
; MIPS4-NEXT:    addu $1, $1, $3
; MIPS4-NEXT:    and $1, $1, $2
; MIPS4-NEXT:    sll $2, $1, 8
; MIPS4-NEXT:    addu $2, $2, $1
; MIPS4-NEXT:    sll $3, $1, 16
; MIPS4-NEXT:    addu $2, $3, $2
; MIPS4-NEXT:    sll $1, $1, 24
; MIPS4-NEXT:    addu $1, $1, $2
; MIPS4-NEXT:    jr $ra
; MIPS4-NEXT:    srl $2, $1, 24
entry:
  %tmp1 = tail call i32 @llvm.ctlz.i32(i32 %X, i1 true)
  ret i32 %tmp1
}

declare i32 @llvm.ctlz.i32(i32, i1) nounwind readnone

define i32 @ctlo_i32(i32 signext %X) nounwind readnone {
; MIPS-GT-R1-LABEL: ctlo_i32:
; MIPS-GT-R1:       # %bb.0: # %entry
; MIPS-GT-R1-NEXT:    jr $ra
; MIPS-GT-R1-NEXT:    clo $2, $4
;
; MIPS4-LABEL: ctlo_i32:
; MIPS4:       # %bb.0: # %entry
; MIPS4-NEXT:    not $1, $4
; MIPS4-NEXT:    srl $2, $1, 1
; MIPS4-NEXT:    or $1, $1, $2
; MIPS4-NEXT:    srl $2, $1, 2
; MIPS4-NEXT:    or $1, $1, $2
; MIPS4-NEXT:    lui $2, 21845
; MIPS4-NEXT:    lui $3, 13107
; MIPS4-NEXT:    lui $4, 3855
; MIPS4-NEXT:    srl $5, $1, 4
; MIPS4-NEXT:    ori $4, $4, 3855
; MIPS4-NEXT:    ori $3, $3, 13107
; MIPS4-NEXT:    ori $2, $2, 21845
; MIPS4-NEXT:    or $1, $1, $5
; MIPS4-NEXT:    srl $5, $1, 8
; MIPS4-NEXT:    or $1, $1, $5
; MIPS4-NEXT:    srl $5, $1, 16
; MIPS4-NEXT:    nor $1, $1, $5
; MIPS4-NEXT:    srl $5, $1, 1
; MIPS4-NEXT:    and $2, $5, $2
; MIPS4-NEXT:    subu $1, $1, $2
; MIPS4-NEXT:    and $2, $1, $3
; MIPS4-NEXT:    srl $1, $1, 2
; MIPS4-NEXT:    and $1, $1, $3
; MIPS4-NEXT:    addu $1, $2, $1
; MIPS4-NEXT:    srl $2, $1, 4
; MIPS4-NEXT:    addu $1, $1, $2
; MIPS4-NEXT:    and $1, $1, $4
; MIPS4-NEXT:    sll $2, $1, 8
; MIPS4-NEXT:    addu $2, $2, $1
; MIPS4-NEXT:    sll $3, $1, 16
; MIPS4-NEXT:    addu $2, $3, $2
; MIPS4-NEXT:    sll $1, $1, 24
; MIPS4-NEXT:    addu $1, $1, $2
; MIPS4-NEXT:    jr $ra
; MIPS4-NEXT:    srl $2, $1, 24
entry:
  %neg = xor i32 %X, -1
  %tmp1 = tail call i32 @llvm.ctlz.i32(i32 %neg, i1 true)
  ret i32 %tmp1
}

define i64 @ctlz_i64(i64 %X) nounwind readnone {
; MIPS32-R1-R2-LABEL: ctlz_i64:
; MIPS32-R1-R2:       # %bb.0: # %entry
; MIPS32-R1-R2-NEXT:    clz $1, $5
; MIPS32-R1-R2-NEXT:    clz $2, $4
; MIPS32-R1-R2-NEXT:    addiu $2, $2, 32
; MIPS32-R1-R2-NEXT:    movn $2, $1, $5
; MIPS32-R1-R2-NEXT:    jr $ra
; MIPS32-R1-R2-NEXT:    addiu $3, $zero, 0
;
; MIPS32-R6-LABEL: ctlz_i64:
; MIPS32-R6:       # %bb.0: # %entry
; MIPS32-R6-NEXT:    clz $1, $5
; MIPS32-R6-NEXT:    selnez $1, $1, $5
; MIPS32-R6-NEXT:    clz $2, $4
; MIPS32-R6-NEXT:    addiu $2, $2, 32
; MIPS32-R6-NEXT:    seleqz $2, $2, $5
; MIPS32-R6-NEXT:    or $2, $1, $2
; MIPS32-R6-NEXT:    jr $ra
; MIPS32-R6-NEXT:    addiu $3, $zero, 0
;
; MIPS64-GT-R1-LABEL: ctlz_i64:
; MIPS64-GT-R1:       # %bb.0: # %entry
; MIPS64-GT-R1-NEXT:    jr $ra
; MIPS64-GT-R1-NEXT:    dclz $2, $4
;
; MIPS4-LABEL: ctlz_i64:
; MIPS4:       # %bb.0: # %entry
; MIPS4-NEXT:    dsrl $1, $4, 1
; MIPS4-NEXT:    or $1, $4, $1
; MIPS4-NEXT:    dsrl $2, $1, 2
; MIPS4-NEXT:    or $1, $1, $2
; MIPS4-NEXT:    dsrl $2, $1, 4
; MIPS4-NEXT:    or $1, $1, $2
; MIPS4-NEXT:    lui $2, 13107
; MIPS4-NEXT:    dsrl $3, $1, 8
; MIPS4-NEXT:    daddiu $2, $2, 13107
; MIPS4-NEXT:    or $1, $1, $3
; MIPS4-NEXT:    dsll $2, $2, 16
; MIPS4-NEXT:    lui $3, 3855
; MIPS4-NEXT:    daddiu $3, $3, 3855
; MIPS4-NEXT:    dsll $3, $3, 16
; MIPS4-NEXT:    daddiu $3, $3, 3855
; MIPS4-NEXT:    daddiu $2, $2, 13107
; MIPS4-NEXT:    lui $4, 21845
; MIPS4-NEXT:    daddiu $4, $4, 21845
; MIPS4-NEXT:    dsll $4, $4, 16
; MIPS4-NEXT:    dsrl $5, $1, 16
; MIPS4-NEXT:    or $1, $1, $5
; MIPS4-NEXT:    dsll $2, $2, 16
; MIPS4-NEXT:    dsll $3, $3, 16
; MIPS4-NEXT:    lui $5, 257
; MIPS4-NEXT:    daddiu $5, $5, 257
; MIPS4-NEXT:    dsll $5, $5, 16
; MIPS4-NEXT:    daddiu $5, $5, 257
; MIPS4-NEXT:    dsll $5, $5, 16
; MIPS4-NEXT:    dsrl $6, $1, 32
; MIPS4-NEXT:    daddiu $5, $5, 257
; MIPS4-NEXT:    daddiu $3, $3, 3855
; MIPS4-NEXT:    daddiu $2, $2, 13107
; MIPS4-NEXT:    daddiu $4, $4, 21845
; MIPS4-NEXT:    dsll $4, $4, 16
; MIPS4-NEXT:    daddiu $4, $4, 21845
; MIPS4-NEXT:    nor $1, $1, $6
; MIPS4-NEXT:    dsrl $6, $1, 1
; MIPS4-NEXT:    and $4, $6, $4
; MIPS4-NEXT:    dsubu $1, $1, $4
; MIPS4-NEXT:    and $4, $1, $2
; MIPS4-NEXT:    dsrl $1, $1, 2
; MIPS4-NEXT:    and $1, $1, $2
; MIPS4-NEXT:    daddu $1, $4, $1
; MIPS4-NEXT:    dsrl $2, $1, 4
; MIPS4-NEXT:    daddu $1, $1, $2
; MIPS4-NEXT:    and $1, $1, $3
; MIPS4-NEXT:    dmult $1, $5
; MIPS4-NEXT:    mflo $1
; MIPS4-NEXT:    jr $ra
; MIPS4-NEXT:    dsrl $2, $1, 56
entry:
  %tmp1 = tail call i64 @llvm.ctlz.i64(i64 %X, i1 true)
  ret i64 %tmp1
}

declare i64 @llvm.ctlz.i64(i64, i1) nounwind readnone

define i64 @ctlo_i64(i64 %X) nounwind readnone {
; MIPS32-R1-R2-LABEL: ctlo_i64:
; MIPS32-R1-R2:       # %bb.0: # %entry
; MIPS32-R1-R2-NEXT:    not $1, $5
; MIPS32-R1-R2-NEXT:    clo $3, $5
; MIPS32-R1-R2-NEXT:    clo $2, $4
; MIPS32-R1-R2-NEXT:    addiu $2, $2, 32
; MIPS32-R1-R2-NEXT:    movn $2, $3, $1
; MIPS32-R1-R2-NEXT:    jr $ra
; MIPS32-R1-R2-NEXT:    addiu $3, $zero, 0
;
; MIPS32-R6-LABEL: ctlo_i64:
; MIPS32-R6:       # %bb.0: # %entry
; MIPS32-R6-NEXT:    not $1, $5
; MIPS32-R6-NEXT:    clo $2, $5
; MIPS32-R6-NEXT:    selnez $2, $2, $1
; MIPS32-R6-NEXT:    clo $3, $4
; MIPS32-R6-NEXT:    addiu $3, $3, 32
; MIPS32-R6-NEXT:    seleqz $1, $3, $1
; MIPS32-R6-NEXT:    or $2, $2, $1
; MIPS32-R6-NEXT:    jr $ra
; MIPS32-R6-NEXT:    addiu $3, $zero, 0
;
; MIPS64-GT-R1-LABEL: ctlo_i64:
; MIPS64-GT-R1:       # %bb.0: # %entry
; MIPS64-GT-R1-NEXT:    jr $ra
; MIPS64-GT-R1-NEXT:    dclo $2, $4
;
; MIPS4-LABEL: ctlo_i64:
; MIPS4:       # %bb.0: # %entry
; MIPS4-NEXT:    daddiu $1, $zero, -1
; MIPS4-NEXT:    xor $1, $4, $1
; MIPS4-NEXT:    dsrl $2, $1, 1
; MIPS4-NEXT:    or $1, $1, $2
; MIPS4-NEXT:    dsrl $2, $1, 2
; MIPS4-NEXT:    or $1, $1, $2
; MIPS4-NEXT:    dsrl $2, $1, 4
; MIPS4-NEXT:    lui $3, 13107
; MIPS4-NEXT:    or $1, $1, $2
; MIPS4-NEXT:    daddiu $2, $3, 13107
; MIPS4-NEXT:    dsrl $3, $1, 8
; MIPS4-NEXT:    dsll $2, $2, 16
; MIPS4-NEXT:    lui $4, 3855
; MIPS4-NEXT:    daddiu $4, $4, 3855
; MIPS4-NEXT:    dsll $4, $4, 16
; MIPS4-NEXT:    or $1, $1, $3
; MIPS4-NEXT:    daddiu $3, $4, 3855
; MIPS4-NEXT:    daddiu $2, $2, 13107
; MIPS4-NEXT:    lui $4, 21845
; MIPS4-NEXT:    daddiu $4, $4, 21845
; MIPS4-NEXT:    dsll $4, $4, 16
; MIPS4-NEXT:    daddiu $4, $4, 21845
; MIPS4-NEXT:    dsrl $5, $1, 16
; MIPS4-NEXT:    dsll $2, $2, 16
; MIPS4-NEXT:    dsll $3, $3, 16
; MIPS4-NEXT:    lui $6, 257
; MIPS4-NEXT:    daddiu $6, $6, 257
; MIPS4-NEXT:    dsll $6, $6, 16
; MIPS4-NEXT:    daddiu $6, $6, 257
; MIPS4-NEXT:    dsll $6, $6, 16
; MIPS4-NEXT:    or $1, $1, $5
; MIPS4-NEXT:    daddiu $5, $6, 257
; MIPS4-NEXT:    daddiu $3, $3, 3855
; MIPS4-NEXT:    daddiu $2, $2, 13107
; MIPS4-NEXT:    dsll $4, $4, 16
; MIPS4-NEXT:    daddiu $4, $4, 21845
; MIPS4-NEXT:    dsrl $6, $1, 32
; MIPS4-NEXT:    nor $1, $1, $6
; MIPS4-NEXT:    dsrl $6, $1, 1
; MIPS4-NEXT:    and $4, $6, $4
; MIPS4-NEXT:    dsubu $1, $1, $4
; MIPS4-NEXT:    and $4, $1, $2
; MIPS4-NEXT:    dsrl $1, $1, 2
; MIPS4-NEXT:    and $1, $1, $2
; MIPS4-NEXT:    daddu $1, $4, $1
; MIPS4-NEXT:    dsrl $2, $1, 4
; MIPS4-NEXT:    daddu $1, $1, $2
; MIPS4-NEXT:    and $1, $1, $3
; MIPS4-NEXT:    dmult $1, $5
; MIPS4-NEXT:    mflo $1
; MIPS4-NEXT:    jr $ra
; MIPS4-NEXT:    dsrl $2, $1, 56
entry:
  %neg = xor i64 %X, -1
  %tmp1 = tail call i64 @llvm.ctlz.i64(i64 %neg, i1 true)
  ret i64 %tmp1
}
