; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=instcombine < %s | FileCheck %s

declare float @llvm.fma.f32(float, float, float)
declare <2 x float> @llvm.fma.v2f32(<2 x float>, <2 x float>, <2 x float>)
declare <3 x float> @llvm.fma.v3f32(<3 x float>, <3 x float>, <3 x float>)
declare <8 x half> @llvm.fma.v8f16(<8 x half>, <8 x half>, <8 x half>)
declare <2 x double> @llvm.fma.v2f64(<2 x double>, <2 x double>, <2 x double>)

declare float @llvm.fmuladd.f32(float, float, float)
declare <2 x double> @llvm.fmuladd.v2f64(<2 x double>, <2 x double>, <2 x double>)
declare float @llvm.fabs.f32(float)
declare <2 x double> @llvm.sqrt.v2f64(<2 x double>)
declare void @use_vec(<2 x float>)
declare void @use_vec3(<3 x float>)

@external = external global i32

define float @fma_fneg_x_fneg_y(float %x, float %y, float %z) {
; CHECK-LABEL: @fma_fneg_x_fneg_y(
; CHECK-NEXT:    [[FMA:%.*]] = call float @llvm.fma.f32(float [[X:%.*]], float [[Y:%.*]], float [[Z:%.*]])
; CHECK-NEXT:    ret float [[FMA]]
;
  %x.fneg = fsub float -0.0, %x
  %y.fneg = fsub float -0.0, %y
  %fma = call float @llvm.fma.f32(float %x.fneg, float %y.fneg, float %z)
  ret float %fma
}

define float @fma_unary_fneg_x_unary_fneg_y(float %x, float %y, float %z) {
; CHECK-LABEL: @fma_unary_fneg_x_unary_fneg_y(
; CHECK-NEXT:    [[FMA:%.*]] = call float @llvm.fma.f32(float [[X:%.*]], float [[Y:%.*]], float [[Z:%.*]])
; CHECK-NEXT:    ret float [[FMA]]
;
  %x.fneg = fneg float %x
  %y.fneg = fneg float %y
  %fma = call float @llvm.fma.f32(float %x.fneg, float %y.fneg, float %z)
  ret float %fma
}

define <2 x float> @fma_fneg_x_fneg_y_vec(<2 x float> %x, <2 x float> %y, <2 x float> %z) {
; CHECK-LABEL: @fma_fneg_x_fneg_y_vec(
; CHECK-NEXT:    [[FMA:%.*]] = call <2 x float> @llvm.fma.v2f32(<2 x float> [[X:%.*]], <2 x float> [[Y:%.*]], <2 x float> [[Z:%.*]])
; CHECK-NEXT:    ret <2 x float> [[FMA]]
;
  %xn = fsub <2 x float> <float -0.0, float -0.0>, %x
  %yn = fsub <2 x float> <float -0.0, float -0.0>, %y
  %fma = call <2 x float> @llvm.fma.v2f32(<2 x float> %xn, <2 x float> %yn, <2 x float> %z)
  ret <2 x float> %fma
}

define <2 x float> @fma_unary_fneg_x_unary_fneg_y_vec(<2 x float> %x, <2 x float> %y, <2 x float> %z) {
; CHECK-LABEL: @fma_unary_fneg_x_unary_fneg_y_vec(
; CHECK-NEXT:    [[FMA:%.*]] = call <2 x float> @llvm.fma.v2f32(<2 x float> [[X:%.*]], <2 x float> [[Y:%.*]], <2 x float> [[Z:%.*]])
; CHECK-NEXT:    ret <2 x float> [[FMA]]
;
  %xn = fneg <2 x float> %x
  %yn = fneg <2 x float> %y
  %fma = call <2 x float> @llvm.fma.v2f32(<2 x float> %xn, <2 x float> %yn, <2 x float> %z)
  ret <2 x float> %fma
}

define <2 x float> @fma_fneg_x_fneg_y_vec_undef(<2 x float> %x, <2 x float> %y, <2 x float> %z) {
; CHECK-LABEL: @fma_fneg_x_fneg_y_vec_undef(
; CHECK-NEXT:    [[FMA:%.*]] = call <2 x float> @llvm.fma.v2f32(<2 x float> [[X:%.*]], <2 x float> [[Y:%.*]], <2 x float> [[Z:%.*]])
; CHECK-NEXT:    ret <2 x float> [[FMA]]
;
  %xn = fsub <2 x float> <float -0.0, float undef>, %x
  %yn = fsub <2 x float> <float undef, float -0.0>, %y
  %fma = call <2 x float> @llvm.fma.v2f32(<2 x float> %xn, <2 x float> %yn, <2 x float> %z)
  ret <2 x float> %fma
}

define float @fma_fneg_x_fneg_y_fast(float %x, float %y, float %z) {
; CHECK-LABEL: @fma_fneg_x_fneg_y_fast(
; CHECK-NEXT:    [[FMA:%.*]] = call fast float @llvm.fma.f32(float [[X:%.*]], float [[Y:%.*]], float [[Z:%.*]])
; CHECK-NEXT:    ret float [[FMA]]
;
  %x.fneg = fsub float -0.0, %x
  %y.fneg = fsub float -0.0, %y
  %fma = call fast float @llvm.fma.f32(float %x.fneg, float %y.fneg, float %z)
  ret float %fma
}

define float @fma_unary_fneg_x_unary_fneg_y_fast(float %x, float %y, float %z) {
; CHECK-LABEL: @fma_unary_fneg_x_unary_fneg_y_fast(
; CHECK-NEXT:    [[FMA:%.*]] = call fast float @llvm.fma.f32(float [[X:%.*]], float [[Y:%.*]], float [[Z:%.*]])
; CHECK-NEXT:    ret float [[FMA]]
;
  %x.fneg = fneg float %x
  %y.fneg = fneg float %y
  %fma = call fast float @llvm.fma.f32(float %x.fneg, float %y.fneg, float %z)
  ret float %fma
}

define float @fma_fneg_const_fneg_y(float %y, float %z) {
; CHECK-LABEL: @fma_fneg_const_fneg_y(
; CHECK-NEXT:    [[FMA:%.*]] = call float @llvm.fma.f32(float [[Y:%.*]], float bitcast (i32 ptrtoint (i32* @external to i32) to float), float [[Z:%.*]])
; CHECK-NEXT:    ret float [[FMA]]
;
  %y.fneg = fsub float -0.0, %y
  %fsub = fsub float -0.0, bitcast (i32 ptrtoint (i32* @external to i32) to float)
  %fma = call float @llvm.fma.f32(float %fsub, float %y.fneg, float %z)
  ret float %fma
}

define float @fma_unary_fneg_const_unary_fneg_y(float %y, float %z) {
; CHECK-LABEL: @fma_unary_fneg_const_unary_fneg_y(
; CHECK-NEXT:    [[FMA:%.*]] = call float @llvm.fma.f32(float [[Y:%.*]], float bitcast (i32 ptrtoint (i32* @external to i32) to float), float [[Z:%.*]])
; CHECK-NEXT:    ret float [[FMA]]
;
  %y.fneg = fneg float %y
  %fma = call float @llvm.fma.f32(float fneg (float bitcast (i32 ptrtoint (i32* @external to i32) to float)), float %y.fneg, float %z)
  ret float %fma
}

define float @fma_fneg_x_fneg_const(float %x, float %z) {
; CHECK-LABEL: @fma_fneg_x_fneg_const(
; CHECK-NEXT:    [[FMA:%.*]] = call float @llvm.fma.f32(float [[X:%.*]], float bitcast (i32 ptrtoint (i32* @external to i32) to float), float [[Z:%.*]])
; CHECK-NEXT:    ret float [[FMA]]
;
  %x.fneg = fsub float -0.0, %x
  %fsub = fsub float -0.0, bitcast (i32 ptrtoint (i32* @external to i32) to float)
  %fma = call float @llvm.fma.f32(float %x.fneg, float %fsub, float %z)
  ret float %fma
}

define float @fma_unary_fneg_x_unary_fneg_const(float %x, float %z) {
; CHECK-LABEL: @fma_unary_fneg_x_unary_fneg_const(
; CHECK-NEXT:    [[FMA:%.*]] = call float @llvm.fma.f32(float [[X:%.*]], float bitcast (i32 ptrtoint (i32* @external to i32) to float), float [[Z:%.*]])
; CHECK-NEXT:    ret float [[FMA]]
;
  %x.fneg = fneg float %x
  %fma = call float @llvm.fma.f32(float %x.fneg, float fneg (float bitcast (i32 ptrtoint (i32* @external to i32) to float)), float %z)
  ret float %fma
}

define float @fma_fabs_x_fabs_y(float %x, float %y, float %z) {
; CHECK-LABEL: @fma_fabs_x_fabs_y(
; CHECK-NEXT:    [[X_FABS:%.*]] = call float @llvm.fabs.f32(float [[X:%.*]])
; CHECK-NEXT:    [[Y_FABS:%.*]] = call float @llvm.fabs.f32(float [[Y:%.*]])
; CHECK-NEXT:    [[FMA:%.*]] = call float @llvm.fma.f32(float [[X_FABS]], float [[Y_FABS]], float [[Z:%.*]])
; CHECK-NEXT:    ret float [[FMA]]
;
  %x.fabs = call float @llvm.fabs.f32(float %x)
  %y.fabs = call float @llvm.fabs.f32(float %y)
  %fma = call float @llvm.fma.f32(float %x.fabs, float %y.fabs, float %z)
  ret float %fma
}

define float @fma_fabs_x_fabs_x(float %x, float %z) {
; CHECK-LABEL: @fma_fabs_x_fabs_x(
; CHECK-NEXT:    [[FMA:%.*]] = call float @llvm.fma.f32(float [[X:%.*]], float [[X]], float [[Z:%.*]])
; CHECK-NEXT:    ret float [[FMA]]
;
  %x.fabs = call float @llvm.fabs.f32(float %x)
  %fma = call float @llvm.fma.f32(float %x.fabs, float %x.fabs, float %z)
  ret float %fma
}

define float @fma_fabs_x_fabs_x_fast(float %x, float %z) {
; CHECK-LABEL: @fma_fabs_x_fabs_x_fast(
; CHECK-NEXT:    [[FMA:%.*]] = call fast float @llvm.fma.f32(float [[X:%.*]], float [[X]], float [[Z:%.*]])
; CHECK-NEXT:    ret float [[FMA]]
;
  %x.fabs = call float @llvm.fabs.f32(float %x)
  %fma = call fast float @llvm.fma.f32(float %x.fabs, float %x.fabs, float %z)
  ret float %fma
}

define float @fmuladd_fneg_x_fneg_y(float %x, float %y, float %z) {
; CHECK-LABEL: @fmuladd_fneg_x_fneg_y(
; CHECK-NEXT:    [[FMULADD:%.*]] = call float @llvm.fmuladd.f32(float [[X:%.*]], float [[Y:%.*]], float [[Z:%.*]])
; CHECK-NEXT:    ret float [[FMULADD]]
;
  %x.fneg = fsub float -0.0, %x
  %y.fneg = fsub float -0.0, %y
  %fmuladd = call float @llvm.fmuladd.f32(float %x.fneg, float %y.fneg, float %z)
  ret float %fmuladd
}

define float @fmuladd_unary_fneg_x_unary_fneg_y(float %x, float %y, float %z) {
; CHECK-LABEL: @fmuladd_unary_fneg_x_unary_fneg_y(
; CHECK-NEXT:    [[FMULADD:%.*]] = call float @llvm.fmuladd.f32(float [[X:%.*]], float [[Y:%.*]], float [[Z:%.*]])
; CHECK-NEXT:    ret float [[FMULADD]]
;
  %x.fneg = fneg float %x
  %y.fneg = fneg float %y
  %fmuladd = call float @llvm.fmuladd.f32(float %x.fneg, float %y.fneg, float %z)
  ret float %fmuladd
}

define float @fmuladd_fneg_x_fneg_y_fast(float %x, float %y, float %z) {
; CHECK-LABEL: @fmuladd_fneg_x_fneg_y_fast(
; CHECK-NEXT:    [[TMP1:%.*]] = fmul fast float [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[FMULADD:%.*]] = fadd fast float [[TMP1]], [[Z:%.*]]
; CHECK-NEXT:    ret float [[FMULADD]]
;
  %x.fneg = fsub float -0.0, %x
  %y.fneg = fsub float -0.0, %y
  %fmuladd = call fast float @llvm.fmuladd.f32(float %x.fneg, float %y.fneg, float %z)
  ret float %fmuladd
}

define float @fmuladd_unary_fneg_x_unary_fneg_y_fast(float %x, float %y, float %z) {
; CHECK-LABEL: @fmuladd_unary_fneg_x_unary_fneg_y_fast(
; CHECK-NEXT:    [[TMP1:%.*]] = fmul fast float [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[FMULADD:%.*]] = fadd fast float [[TMP1]], [[Z:%.*]]
; CHECK-NEXT:    ret float [[FMULADD]]
;
  %x.fneg = fneg float %x
  %y.fneg = fneg float %y
  %fmuladd = call fast float @llvm.fmuladd.f32(float %x.fneg, float %y.fneg, float %z)
  ret float %fmuladd
}

define float @fmuladd_fneg_const_fneg_y(float %y, float %z) {
; CHECK-LABEL: @fmuladd_fneg_const_fneg_y(
; CHECK-NEXT:    [[FMULADD:%.*]] = call float @llvm.fmuladd.f32(float [[Y:%.*]], float bitcast (i32 ptrtoint (i32* @external to i32) to float), float [[Z:%.*]])
; CHECK-NEXT:    ret float [[FMULADD]]
;
  %y.fneg = fsub float -0.0, %y
  %fsub = fsub float -0.0, bitcast (i32 ptrtoint (i32* @external to i32) to float)
  %fmuladd = call float @llvm.fmuladd.f32(float %fsub, float %y.fneg, float %z)
  ret float %fmuladd
}

define float @fmuladd_unary_fneg_const_unary_fneg_y(float %y, float %z) {
; CHECK-LABEL: @fmuladd_unary_fneg_const_unary_fneg_y(
; CHECK-NEXT:    [[FMULADD:%.*]] = call float @llvm.fmuladd.f32(float [[Y:%.*]], float bitcast (i32 ptrtoint (i32* @external to i32) to float), float [[Z:%.*]])
; CHECK-NEXT:    ret float [[FMULADD]]
;
  %y.fneg = fneg float %y
  %fmuladd = call float @llvm.fmuladd.f32(float fneg (float bitcast (i32 ptrtoint (i32* @external to i32) to float)), float %y.fneg, float %z)
  ret float %fmuladd
}

define float @fmuladd_fneg_x_fneg_const(float %x, float %z) {
; CHECK-LABEL: @fmuladd_fneg_x_fneg_const(
; CHECK-NEXT:    [[FMULADD:%.*]] = call float @llvm.fmuladd.f32(float [[X:%.*]], float bitcast (i32 ptrtoint (i32* @external to i32) to float), float [[Z:%.*]])
; CHECK-NEXT:    ret float [[FMULADD]]
;
  %x.fneg = fsub float -0.0, %x
  %fsub = fsub float -0.0, bitcast (i32 ptrtoint (i32* @external to i32) to float)
  %fmuladd = call float @llvm.fmuladd.f32(float %x.fneg, float %fsub, float %z)
  ret float %fmuladd
}

define float @fmuladd_unary_fneg_x_unary_fneg_const(float %x, float %z) {
; CHECK-LABEL: @fmuladd_unary_fneg_x_unary_fneg_const(
; CHECK-NEXT:    [[FMULADD:%.*]] = call float @llvm.fmuladd.f32(float [[X:%.*]], float bitcast (i32 ptrtoint (i32* @external to i32) to float), float [[Z:%.*]])
; CHECK-NEXT:    ret float [[FMULADD]]
;
  %x.fneg = fneg float %x
  %fmuladd = call float @llvm.fmuladd.f32(float %x.fneg, float fneg (float bitcast (i32 ptrtoint (i32* @external to i32) to float)), float %z)
  ret float %fmuladd
}

define float @fmuladd_fabs_x_fabs_y(float %x, float %y, float %z) {
; CHECK-LABEL: @fmuladd_fabs_x_fabs_y(
; CHECK-NEXT:    [[X_FABS:%.*]] = call float @llvm.fabs.f32(float [[X:%.*]])
; CHECK-NEXT:    [[Y_FABS:%.*]] = call float @llvm.fabs.f32(float [[Y:%.*]])
; CHECK-NEXT:    [[FMULADD:%.*]] = call float @llvm.fmuladd.f32(float [[X_FABS]], float [[Y_FABS]], float [[Z:%.*]])
; CHECK-NEXT:    ret float [[FMULADD]]
;
  %x.fabs = call float @llvm.fabs.f32(float %x)
  %y.fabs = call float @llvm.fabs.f32(float %y)
  %fmuladd = call float @llvm.fmuladd.f32(float %x.fabs, float %y.fabs, float %z)
  ret float %fmuladd
}

define float @fmuladd_fabs_x_fabs_x(float %x, float %z) {
; CHECK-LABEL: @fmuladd_fabs_x_fabs_x(
; CHECK-NEXT:    [[FMULADD:%.*]] = call float @llvm.fmuladd.f32(float [[X:%.*]], float [[X]], float [[Z:%.*]])
; CHECK-NEXT:    ret float [[FMULADD]]
;
  %x.fabs = call float @llvm.fabs.f32(float %x)
  %fmuladd = call float @llvm.fmuladd.f32(float %x.fabs, float %x.fabs, float %z)
  ret float %fmuladd
}

define float @fmuladd_fabs_x_fabs_x_fast(float %x, float %z) {
; CHECK-LABEL: @fmuladd_fabs_x_fabs_x_fast(
; CHECK-NEXT:    [[TMP1:%.*]] = fmul fast float [[X:%.*]], [[X]]
; CHECK-NEXT:    [[FMULADD:%.*]] = fadd fast float [[TMP1]], [[Z:%.*]]
; CHECK-NEXT:    ret float [[FMULADD]]
;
  %x.fabs = call float @llvm.fabs.f32(float %x)
  %fmuladd = call fast float @llvm.fmuladd.f32(float %x.fabs, float %x.fabs, float %z)
  ret float %fmuladd
}

define float @fma_k_y_z(float %y, float %z) {
; CHECK-LABEL: @fma_k_y_z(
; CHECK-NEXT:    [[FMA:%.*]] = call float @llvm.fma.f32(float [[Y:%.*]], float 4.000000e+00, float [[Z:%.*]])
; CHECK-NEXT:    ret float [[FMA]]
;
  %fma = call float @llvm.fma.f32(float 4.0, float %y, float %z)
  ret float %fma
}

define float @fma_k_y_z_fast(float %y, float %z) {
; CHECK-LABEL: @fma_k_y_z_fast(
; CHECK-NEXT:    [[FMA:%.*]] = call fast float @llvm.fma.f32(float [[Y:%.*]], float 4.000000e+00, float [[Z:%.*]])
; CHECK-NEXT:    ret float [[FMA]]
;
  %fma = call fast float @llvm.fma.f32(float 4.0, float %y, float %z)
  ret float %fma
}

define float @fmuladd_k_y_z_fast(float %y, float %z) {
; CHECK-LABEL: @fmuladd_k_y_z_fast(
; CHECK-NEXT:    [[TMP1:%.*]] = fmul fast float [[Y:%.*]], 4.000000e+00
; CHECK-NEXT:    [[FMULADD:%.*]] = fadd fast float [[TMP1]], [[Z:%.*]]
; CHECK-NEXT:    ret float [[FMULADD]]
;
  %fmuladd = call fast float @llvm.fmuladd.f32(float 4.0, float %y, float %z)
  ret float %fmuladd
}

define float @fma_1_y_z(float %y, float %z) {
; CHECK-LABEL: @fma_1_y_z(
; CHECK-NEXT:    [[FMA:%.*]] = fadd float [[Y:%.*]], [[Z:%.*]]
; CHECK-NEXT:    ret float [[FMA]]
;
  %fma = call float @llvm.fma.f32(float 1.0, float %y, float %z)
  ret float %fma
}

define float @fma_x_1_z(float %x, float %z) {
; CHECK-LABEL: @fma_x_1_z(
; CHECK-NEXT:    [[FMA:%.*]] = fadd float [[X:%.*]], [[Z:%.*]]
; CHECK-NEXT:    ret float [[FMA]]
;
  %fma = call float @llvm.fma.f32(float %x, float 1.0, float %z)
  ret float %fma
}

define <2 x float> @fma_x_1_z_v2f32(<2 x float> %x, <2 x float> %z) {
; CHECK-LABEL: @fma_x_1_z_v2f32(
; CHECK-NEXT:    [[FMA:%.*]] = fadd <2 x float> [[X:%.*]], [[Z:%.*]]
; CHECK-NEXT:    ret <2 x float> [[FMA]]
;
  %fma = call <2 x float> @llvm.fma.v2f32(<2 x float> %x, <2 x float> <float 1.0, float 1.0>, <2 x float> %z)
  ret <2 x float> %fma
}

define <2 x float> @fma_x_1_2_z_v2f32(<2 x float> %x, <2 x float> %z) {
; CHECK-LABEL: @fma_x_1_2_z_v2f32(
; CHECK-NEXT:    [[FMA:%.*]] = call <2 x float> @llvm.fma.v2f32(<2 x float> [[X:%.*]], <2 x float> <float 1.000000e+00, float 2.000000e+00>, <2 x float> [[Z:%.*]])
; CHECK-NEXT:    ret <2 x float> [[FMA]]
;
  %fma = call <2 x float> @llvm.fma.v2f32(<2 x float> %x, <2 x float> <float 1.0, float 2.0>, <2 x float> %z)
  ret <2 x float> %fma
}

define float @fma_x_1_z_fast(float %x, float %z) {
; CHECK-LABEL: @fma_x_1_z_fast(
; CHECK-NEXT:    [[FMA:%.*]] = fadd fast float [[X:%.*]], [[Z:%.*]]
; CHECK-NEXT:    ret float [[FMA]]
;
  %fma = call fast float @llvm.fma.f32(float %x, float 1.0, float %z)
  ret float %fma
}

define float @fma_1_1_z(float %z) {
; CHECK-LABEL: @fma_1_1_z(
; CHECK-NEXT:    [[FMA:%.*]] = fadd float [[Z:%.*]], 1.000000e+00
; CHECK-NEXT:    ret float [[FMA]]
;
  %fma = call float @llvm.fma.f32(float 1.0, float 1.0, float %z)
  ret float %fma
}

define float @fma_x_y_0(float %x, float %y) {
; CHECK-LABEL: @fma_x_y_0(
; CHECK-NEXT:    [[FMA:%.*]] = call float @llvm.fma.f32(float [[X:%.*]], float [[Y:%.*]], float 0.000000e+00)
; CHECK-NEXT:    ret float [[FMA]]
;
  %fma = call float @llvm.fma.f32(float %x, float %y, float 0.0)
  ret float %fma
}

define float @fma_x_y_0_nsz(float %x, float %y) {
; CHECK-LABEL: @fma_x_y_0_nsz(
; CHECK-NEXT:    [[FMA:%.*]] = fmul nsz float [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret float [[FMA]]
;
  %fma = call nsz float @llvm.fma.f32(float %x, float %y, float 0.0)
  ret float %fma
}

define <8 x half> @fma_x_y_0_v(<8 x half> %x, <8 x half> %y) {
; CHECK-LABEL: @fma_x_y_0_v(
; CHECK-NEXT:    [[FMA:%.*]] = call <8 x half> @llvm.fma.v8f16(<8 x half> [[X:%.*]], <8 x half> [[Y:%.*]], <8 x half> zeroinitializer)
; CHECK-NEXT:    ret <8 x half> [[FMA]]
;
  %fma = call <8 x half> @llvm.fma.v8f16(<8 x half> %x, <8 x half> %y, <8 x half> zeroinitializer)
  ret <8 x half> %fma
}

define <8 x half> @fma_x_y_0_nsz_v(<8 x half> %x, <8 x half> %y) {
; CHECK-LABEL: @fma_x_y_0_nsz_v(
; CHECK-NEXT:    [[FMA:%.*]] = fmul nsz <8 x half> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret <8 x half> [[FMA]]
;
  %fma = call nsz <8 x half> @llvm.fma.v8f16(<8 x half> %x, <8 x half> %y, <8 x half> zeroinitializer)
  ret <8 x half> %fma
}

define float @fmuladd_x_y_0(float %x, float %y) {
; CHECK-LABEL: @fmuladd_x_y_0(
; CHECK-NEXT:    [[FMA:%.*]] = call float @llvm.fmuladd.f32(float [[X:%.*]], float [[Y:%.*]], float 0.000000e+00)
; CHECK-NEXT:    ret float [[FMA]]
;
  %fma = call float @llvm.fmuladd.f32(float %x, float %y, float 0.0)
  ret float %fma
}

define float @fmuladd_x_y_0_nsz(float %x, float %y) {
; CHECK-LABEL: @fmuladd_x_y_0_nsz(
; CHECK-NEXT:    [[FMA:%.*]] = fmul nsz float [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret float [[FMA]]
;
  %fma = call nsz float @llvm.fmuladd.f32(float %x, float %y, float 0.0)
  ret float %fma
}

define float @fma_x_y_m0(float %x, float %y) {
; CHECK-LABEL: @fma_x_y_m0(
; CHECK-NEXT:    [[FMA:%.*]] = fmul float [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret float [[FMA]]
;
  %fma = call float @llvm.fma.f32(float %x, float %y, float -0.0)
  ret float %fma
}

define <8 x half> @fma_x_y_m0_v(<8 x half> %x, <8 x half> %y) {
; CHECK-LABEL: @fma_x_y_m0_v(
; CHECK-NEXT:    [[FMA:%.*]] = fmul <8 x half> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret <8 x half> [[FMA]]
;
  %fma = call <8 x half> @llvm.fma.v8f16(<8 x half> %x, <8 x half> %y, <8 x half> <half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0>)
  ret <8 x half> %fma
}

define float @fmuladd_x_y_m0(float %x, float %y) {
; CHECK-LABEL: @fmuladd_x_y_m0(
; CHECK-NEXT:    [[FMA:%.*]] = fmul float [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret float [[FMA]]
;
  %fma = call float @llvm.fmuladd.f32(float %x, float %y, float -0.0)
  ret float %fma
}

define float @fmuladd_x_1_z_fast(float %x, float %z) {
; CHECK-LABEL: @fmuladd_x_1_z_fast(
; CHECK-NEXT:    [[FMULADD:%.*]] = fadd fast float [[X:%.*]], [[Z:%.*]]
; CHECK-NEXT:    ret float [[FMULADD]]
;
  %fmuladd = call fast float @llvm.fmuladd.f32(float %x, float 1.0, float %z)
  ret float %fmuladd
}

define <2 x double> @fmuladd_a_0_b(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: @fmuladd_a_0_b(
; CHECK-NEXT:    ret <2 x double> [[B:%.*]]
;
  %res = call nnan nsz <2 x double> @llvm.fmuladd.v2f64(<2 x double> %a, <2 x double> zeroinitializer, <2 x double> %b)
  ret <2 x double> %res
}

define <2 x double> @fmuladd_0_a_b(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: @fmuladd_0_a_b(
; CHECK-NEXT:    ret <2 x double> [[B:%.*]]
;
  %res = call nnan nsz <2 x double> @llvm.fmuladd.v2f64(<2 x double> zeroinitializer, <2 x double> %a, <2 x double> %b)
  ret <2 x double> %res
}

define <2 x double> @fmuladd_a_0_b_missing_flags(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: @fmuladd_a_0_b_missing_flags(
; CHECK-NEXT:    [[RES:%.*]] = call nnan <2 x double> @llvm.fmuladd.v2f64(<2 x double> [[A:%.*]], <2 x double> zeroinitializer, <2 x double> [[B:%.*]])
; CHECK-NEXT:    ret <2 x double> [[RES]]
;
  %res = call nnan <2 x double> @llvm.fmuladd.v2f64(<2 x double> %a, <2 x double> zeroinitializer, <2 x double> %b)
  ret <2 x double> %res
}

define <2 x double> @fma_a_0_b(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: @fma_a_0_b(
; CHECK-NEXT:    ret <2 x double> [[B:%.*]]
;
  %res = call nnan nsz <2 x double> @llvm.fma.v2f64(<2 x double> %a, <2 x double> zeroinitializer, <2 x double> %b)
  ret <2 x double> %res
}

define <2 x double> @fma_0_a_b(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: @fma_0_a_b(
; CHECK-NEXT:    ret <2 x double> [[B:%.*]]
;
  %res = call nnan nsz <2 x double> @llvm.fma.v2f64(<2 x double> zeroinitializer, <2 x double> %a, <2 x double> %b)
  ret <2 x double> %res
}

define <2 x double> @fma_0_a_b_missing_flags(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: @fma_0_a_b_missing_flags(
; CHECK-NEXT:    [[RES:%.*]] = call nsz <2 x double> @llvm.fma.v2f64(<2 x double> [[A:%.*]], <2 x double> zeroinitializer, <2 x double> [[B:%.*]])
; CHECK-NEXT:    ret <2 x double> [[RES]]
;
  %res = call nsz <2 x double> @llvm.fma.v2f64(<2 x double> zeroinitializer, <2 x double> %a, <2 x double> %b)
  ret <2 x double> %res
}

define <2 x double> @fma_sqrt(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: @fma_sqrt(
; CHECK-NEXT:    [[RES:%.*]] = fadd fast <2 x double> [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret <2 x double> [[RES]]
;
  %sqrt = call fast <2 x double> @llvm.sqrt.v2f64(<2 x double> %a)
  %res = call fast <2 x double> @llvm.fma.v2f64(<2 x double> %sqrt, <2 x double> %sqrt, <2 x double> %b)
  ret <2 x double> %res
}

; We do not fold constant multiplies in FMAs, as they could require rounding, unless either constant is 0.0 or 1.0.
define <2 x double> @fma_const_fmul(<2 x double> %b) {
; CHECK-LABEL: @fma_const_fmul(
; CHECK-NEXT:    [[RES:%.*]] = call nnan nsz <2 x double> @llvm.fma.v2f64(<2 x double> <double 0x4131233302898702, double 0x40C387800000D6C0>, <2 x double> <double 1.291820e-08, double 9.123000e-06>, <2 x double> [[B:%.*]])
; CHECK-NEXT:    ret <2 x double> [[RES]]
;
  %res = call nnan nsz <2 x double> @llvm.fma.v2f64(<2 x double> <double 1123123.0099110012314, double 9999.0000001>, <2 x double> <double 0.0000000129182, double 0.000009123>, <2 x double> %b)
  ret <2 x double> %res
}

define <2 x double> @fma_const_fmul_zero(<2 x double> %b) {
; CHECK-LABEL: @fma_const_fmul_zero(
; CHECK-NEXT:    ret <2 x double> [[B:%.*]]
;
  %res = call nnan nsz <2 x double> @llvm.fma.v2f64(<2 x double> <double 0.0, double 0.0>, <2 x double> <double 1123123.0099110012314, double 9999.0000001>, <2 x double> %b)
  ret <2 x double> %res
}

define <2 x double> @fma_const_fmul_zero2(<2 x double> %b) {
; CHECK-LABEL: @fma_const_fmul_zero2(
; CHECK-NEXT:    ret <2 x double> [[B:%.*]]
;
  %res = call nnan nsz <2 x double> @llvm.fma.v2f64(<2 x double> <double 1123123.0099110012314, double 9999.0000001>, <2 x double> <double 0.0, double 0.0>, <2 x double> %b)
  ret <2 x double> %res
}

define <2 x double> @fma_const_fmul_one(<2 x double> %b) {
; CHECK-LABEL: @fma_const_fmul_one(
; CHECK-NEXT:    [[RES:%.*]] = fadd nnan nsz <2 x double> [[B:%.*]], <double 0x4131233302898702, double 0x40C387800000D6C0>
; CHECK-NEXT:    ret <2 x double> [[RES]]
;
  %res = call nnan nsz <2 x double> @llvm.fma.v2f64(<2 x double> <double 1.0, double 1.0>, <2 x double> <double 1123123.0099110012314, double 9999.0000001>, <2 x double> %b)
  ret <2 x double> %res
}

define <2 x double> @fma_const_fmul_one2(<2 x double> %b) {
; CHECK-LABEL: @fma_const_fmul_one2(
; CHECK-NEXT:    [[RES:%.*]] = fadd nnan nsz <2 x double> [[B:%.*]], <double 0x4131233302898702, double 0x40C387800000D6C0>
; CHECK-NEXT:    ret <2 x double> [[RES]]
;
  %res = call nnan nsz <2 x double> @llvm.fma.v2f64(<2 x double> <double 1123123.0099110012314, double 9999.0000001>, <2 x double> <double 1.0, double 1.0>, <2 x double> %b)
  ret <2 x double> %res
}

define <2 x double> @fma_nan_and_const_0(<2 x double> %b) {
; CHECK-LABEL: @fma_nan_and_const_0(
; CHECK-NEXT:    ret <2 x double> <double 0x7FF8000000000000, double 0x7FF8000000000000>
;
  %res = call nnan nsz <2 x double> @llvm.fma.v2f64(<2 x double> <double 0x7FF8000000000000, double 0x7FF8000000000000>, <2 x double> <double 0.0000000129182, double 0.000009123>, <2 x double> %b)
  ret <2 x double> %res
}

define <2 x double> @fma_nan_and_const_1(<2 x double> %b) {
; CHECK-LABEL: @fma_nan_and_const_1(
; CHECK-NEXT:    ret <2 x double> <double 0x7FF8000000000000, double 0x7FF8000000000000>
;
  %res = call nnan nsz <2 x double> @llvm.fma.v2f64(<2 x double> <double 0.0000000129182, double 0.000009123>, <2 x double> <double 0x7FF8000000000000, double 0x7FF8000000000000>, <2 x double> %b)
  ret <2 x double> %res
}

define <2 x double> @fma_nan_and_const_2(<2 x double> %b) {
; CHECK-LABEL: @fma_nan_and_const_2(
; CHECK-NEXT:    ret <2 x double> <double 0x7FF8000000000000, double 0x7FF8000000000000>
;
  %res = call nnan nsz <2 x double> @llvm.fma.v2f64(<2 x double> <double 0.0000000129182, double 0.000009123>, <2 x double> %b, <2 x double> <double 0x7FF8000000000000, double 0x7FF8000000000000>)
  ret <2 x double> %res
}

define <2 x double> @fma_undef_0(<2 x double> %b, <2 x double> %c) {
; CHECK-LABEL: @fma_undef_0(
; CHECK-NEXT:    ret <2 x double> <double 0x7FF8000000000000, double 0x7FF8000000000000>
;
  %res = call nnan nsz <2 x double> @llvm.fma.v2f64(<2 x double> <double undef, double undef>, <2 x double> %b, <2 x double> %c)
  ret <2 x double> %res
}

define <2 x double> @fma_undef_1(<2 x double> %b, <2 x double> %c) {
; CHECK-LABEL: @fma_undef_1(
; CHECK-NEXT:    ret <2 x double> <double 0x7FF8000000000000, double 0x7FF8000000000000>
;
  %res = call nnan nsz <2 x double> @llvm.fma.v2f64(<2 x double> %b, <2 x double> <double undef, double undef>, <2 x double> %c)
  ret <2 x double> %res
}

define <2 x double> @fma_undef_2(<2 x double> %b, <2 x double> %c) {
; CHECK-LABEL: @fma_undef_2(
; CHECK-NEXT:    ret <2 x double> <double 0x7FF8000000000000, double 0x7FF8000000000000>
;
  %res = call nnan nsz <2 x double> @llvm.fma.v2f64(<2 x double> %b, <2 x double> %c, <2 x double> <double undef, double undef>)
  ret <2 x double> %res
}

define <2 x double> @fma_partial_undef_0(<2 x double> %b, <2 x double> %c) {
; CHECK-LABEL: @fma_partial_undef_0(
; CHECK-NEXT:    [[RES:%.*]] = call nnan nsz <2 x double> @llvm.fma.v2f64(<2 x double> [[B:%.*]], <2 x double> <double undef, double 0x4068E00A137F38C5>, <2 x double> [[C:%.*]])
; CHECK-NEXT:    ret <2 x double> [[RES]]
;
  %res = call nnan nsz <2 x double> @llvm.fma.v2f64(<2 x double> <double undef, double 199.00123>, <2 x double> %b, <2 x double> %c)
  ret <2 x double> %res
}

define <2 x double> @fma_partial_undef_1(<2 x double> %b, <2 x double> %c) {
; CHECK-LABEL: @fma_partial_undef_1(
; CHECK-NEXT:    [[RES:%.*]] = call nnan nsz <2 x double> @llvm.fma.v2f64(<2 x double> [[B:%.*]], <2 x double> <double 0x4068E00A137F38C5, double undef>, <2 x double> [[C:%.*]])
; CHECK-NEXT:    ret <2 x double> [[RES]]
;
  %res = call nnan nsz <2 x double> @llvm.fma.v2f64(<2 x double> %b, <2 x double> <double 199.00123, double undef>, <2 x double> %c)
  ret <2 x double> %res
}

define <2 x double> @fma_partial_undef_2(<2 x double> %b, <2 x double> %c) {
; CHECK-LABEL: @fma_partial_undef_2(
; CHECK-NEXT:    [[RES:%.*]] = call nnan nsz <2 x double> @llvm.fma.v2f64(<2 x double> [[B:%.*]], <2 x double> [[C:%.*]], <2 x double> <double 0x4068E00A137F38C5, double undef>)
; CHECK-NEXT:    ret <2 x double> [[RES]]
;
  %res = call nnan nsz <2 x double> @llvm.fma.v2f64(<2 x double> %b, <2 x double> %c, <2 x double> <double 199.00123, double undef>)
  ret <2 x double> %res
}


define <2 x double> @fma_nan_0(<2 x double> %b, <2 x double> %c) {
; CHECK-LABEL: @fma_nan_0(
; CHECK-NEXT:    ret <2 x double> <double 0x7FF8000000000000, double 0x7FF8000000000000>
;
  %res = call nnan nsz <2 x double> @llvm.fma.v2f64(<2 x double> <double 0x7FF8000000000000, double 0x7FF8000000000000>, <2 x double> %b, <2 x double> %c)
  ret <2 x double> %res
}
define <2 x double> @fma_nan_1(<2 x double> %b, <2 x double> %c) {
; CHECK-LABEL: @fma_nan_1(
; CHECK-NEXT:    ret <2 x double> <double 0x7FF8000000000000, double 0x7FF8000000000000>
;
  %res = call nnan nsz <2 x double> @llvm.fma.v2f64(<2 x double> %b, <2 x double> <double 0x7FF8000000000000, double 0x7FF8000000000000>, <2 x double> %c)
  ret <2 x double> %res
}

define <2 x double> @fma_nan_2(<2 x double> %b, <2 x double> %c) {
; CHECK-LABEL: @fma_nan_2(
; CHECK-NEXT:    ret <2 x double> <double 0x7FF8000000000000, double 0x7FF8000000000000>
;
  %res = call nnan nsz <2 x double> @llvm.fma.v2f64(<2 x double> %b, <2 x double> %c, <2 x double> <double 0x7FF8000000000000, double 0x7FF8000000000000>)
  ret <2 x double> %res
}

define <2 x double> @fmuladd_const_fmul(<2 x double> %b) {
; CHECK-LABEL: @fmuladd_const_fmul(
; CHECK-NEXT:    [[RES:%.*]] = fadd nnan nsz <2 x double> [[B:%.*]], <double 0x3F8DB6C076AD949B, double 0x3FB75A405B6E6D69>
; CHECK-NEXT:    ret <2 x double> [[RES]]
;
  %res = call nnan nsz <2 x double> @llvm.fmuladd.v2f64(<2 x double> <double 1123123.0099110012314, double 9999.0000001>, <2 x double> <double 0.0000000129182, double 0.000009123>, <2 x double> %b)
  ret <2 x double> %res
}

define <2 x double> @fmuladd_nan_and_const_0(<2 x double> %b) {
; CHECK-LABEL: @fmuladd_nan_and_const_0(
; CHECK-NEXT:    ret <2 x double> <double 0x7FF8000000000000, double 0x7FF8000000000000>
;
  %res = call nnan nsz <2 x double> @llvm.fmuladd.v2f64(<2 x double> <double 0x7FF8000000000000, double 0x7FF8000000000000>, <2 x double> <double 0.0000000129182, double 0.000009123>, <2 x double> %b)
  ret <2 x double> %res
}

define <2 x double> @fmuladd_nan_and_const_1(<2 x double> %b) {
; CHECK-LABEL: @fmuladd_nan_and_const_1(
; CHECK-NEXT:    ret <2 x double> <double 0x7FF8000000000000, double 0x7FF8000000000000>
;
  %res = call nnan nsz <2 x double> @llvm.fmuladd.v2f64(<2 x double> <double 0.0000000129182, double 0.000009123>, <2 x double> <double 0x7FF8000000000000, double 0x7FF8000000000000>, <2 x double> %b)
  ret <2 x double> %res
}

define <2 x double> @fmuladd_nan_and_const_2(<2 x double> %b) {
; CHECK-LABEL: @fmuladd_nan_and_const_2(
; CHECK-NEXT:    ret <2 x double> <double 0x7FF8000000000000, double 0x7FF8000000000000>
;
  %res = call nnan nsz <2 x double> @llvm.fmuladd.v2f64(<2 x double> <double 0.0000000129182, double 0.000009123>, <2 x double> %b, <2 x double> <double 0x7FF8000000000000, double 0x7FF8000000000000>)
  ret <2 x double> %res
}

define <2 x double> @fmuladd_nan_0(<2 x double> %b, <2 x double> %c) {
; CHECK-LABEL: @fmuladd_nan_0(
; CHECK-NEXT:    ret <2 x double> <double 0x7FF8000000000000, double 0x7FF8000000000000>
;
  %res = call nnan nsz <2 x double> @llvm.fmuladd.v2f64(<2 x double> <double 0x7FF8000000000000, double 0x7FF8000000000000>, <2 x double> %b, <2 x double> %c)
  ret <2 x double> %res
}

define <2 x double> @fmuladd_nan_1(<2 x double> %b, <2 x double> %c) {
; CHECK-LABEL: @fmuladd_nan_1(
; CHECK-NEXT:    ret <2 x double> <double 0x7FF8000000000000, double 0x7FF8000000000000>
;
  %res = call nnan nsz <2 x double> @llvm.fmuladd.v2f64(<2 x double> %b, <2 x double> <double 0x7FF8000000000000, double 0x7FF8000000000000>, <2 x double> %c)
  ret <2 x double> %res
}

define <2 x double> @fmuladd_undef_0(<2 x double> %b, <2 x double> %c) {
; CHECK-LABEL: @fmuladd_undef_0(
; CHECK-NEXT:    ret <2 x double> <double 0x7FF8000000000000, double 0x7FF8000000000000>
;
  %res = call nnan nsz <2 x double> @llvm.fmuladd.v2f64(<2 x double> <double undef, double undef>, <2 x double> %b, <2 x double> %c)
  ret <2 x double> %res
}

define <2 x double> @fmuladd_undef_1(<2 x double> %b, <2 x double> %c) {
; CHECK-LABEL: @fmuladd_undef_1(
; CHECK-NEXT:    ret <2 x double> <double 0x7FF8000000000000, double 0x7FF8000000000000>
;
  %res = call nnan nsz <2 x double> @llvm.fmuladd.v2f64(<2 x double> %b, <2 x double> <double undef, double undef>, <2 x double> %c)
  ret <2 x double> %res
}

define <2 x double> @fmuladd_undef_2(<2 x double> %b, <2 x double> %c) {
; CHECK-LABEL: @fmuladd_undef_2(
; CHECK-NEXT:    ret <2 x double> <double 0x7FF8000000000000, double 0x7FF8000000000000>
;
  %res = call nnan nsz <2 x double> @llvm.fmuladd.v2f64(<2 x double> %b, <2 x double> %c, <2 x double> <double 0x7FF8000000000000, double 0x7FF8000000000000>)
  ret <2 x double> %res
}

define <2 x float> @fma_unary_shuffle_ops(<2 x float> %x, <2 x float> %y, <2 x float> %z) {
; CHECK-LABEL: @fma_unary_shuffle_ops(
; CHECK-NEXT:    [[TMP1:%.*]] = call <2 x float> @llvm.fma.v2f32(<2 x float> [[X:%.*]], <2 x float> [[Y:%.*]], <2 x float> [[Z:%.*]])
; CHECK-NEXT:    [[R:%.*]] = shufflevector <2 x float> [[TMP1]], <2 x float> poison, <2 x i32> <i32 1, i32 0>
; CHECK-NEXT:    ret <2 x float> [[R]]
;
  %a = shufflevector <2 x float> %x, <2 x float> poison, <2 x i32> <i32 1, i32 0>
  %b = shufflevector <2 x float> %y, <2 x float> poison, <2 x i32> <i32 1, i32 0>
  %c = shufflevector <2 x float> %z, <2 x float> poison, <2 x i32> <i32 1, i32 0>
  %r = call <2 x float> @llvm.fma.v2f32(<2 x float> %a, <2 x float> %b, <2 x float> %c)
  ret <2 x float> %r
}

define <3 x float> @fma_unary_shuffle_ops_widening(<2 x float> %x, <2 x float> %y, <2 x float> %z) {
; CHECK-LABEL: @fma_unary_shuffle_ops_widening(
; CHECK-NEXT:    [[A:%.*]] = shufflevector <2 x float> [[X:%.*]], <2 x float> poison, <3 x i32> <i32 1, i32 0, i32 1>
; CHECK-NEXT:    call void @use_vec3(<3 x float> [[A]])
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <2 x float> @llvm.fma.v2f32(<2 x float> [[X]], <2 x float> [[Y:%.*]], <2 x float> [[Z:%.*]])
; CHECK-NEXT:    [[R:%.*]] = shufflevector <2 x float> [[TMP1]], <2 x float> poison, <3 x i32> <i32 1, i32 0, i32 1>
; CHECK-NEXT:    ret <3 x float> [[R]]
;
  %a = shufflevector <2 x float> %x, <2 x float> poison, <3 x i32> <i32 1, i32 0, i32 1>
  call void @use_vec3(<3 x float> %a)
  %b = shufflevector <2 x float> %y, <2 x float> poison, <3 x i32> <i32 1, i32 0, i32 1>
  %c = shufflevector <2 x float> %z, <2 x float> poison, <3 x i32> <i32 1, i32 0, i32 1>
  %r = call fast <3 x float> @llvm.fma.v3f32(<3 x float> %a, <3 x float> %b, <3 x float> %c)
  ret <3 x float> %r
}

define <2 x float> @fma_unary_shuffle_ops_narrowing(<3 x float> %x, <3 x float> %y, <3 x float> %z) {
; CHECK-LABEL: @fma_unary_shuffle_ops_narrowing(
; CHECK-NEXT:    [[B:%.*]] = shufflevector <3 x float> [[Y:%.*]], <3 x float> poison, <2 x i32> <i32 1, i32 0>
; CHECK-NEXT:    call void @use_vec(<2 x float> [[B]])
; CHECK-NEXT:    [[TMP1:%.*]] = call nnan nsz <3 x float> @llvm.fma.v3f32(<3 x float> [[X:%.*]], <3 x float> [[Y]], <3 x float> [[Z:%.*]])
; CHECK-NEXT:    [[R:%.*]] = shufflevector <3 x float> [[TMP1]], <3 x float> poison, <2 x i32> <i32 1, i32 0>
; CHECK-NEXT:    ret <2 x float> [[R]]
;
  %a = shufflevector <3 x float> %x, <3 x float> poison, <2 x i32> <i32 1, i32 0>
  %b = shufflevector <3 x float> %y, <3 x float> poison, <2 x i32> <i32 1, i32 0>
  call void @use_vec(<2 x float> %b)
  %c = shufflevector <3 x float> %z, <3 x float> poison, <2 x i32> <i32 1, i32 0>
  %r = call nnan nsz <2 x float> @llvm.fma.v2f32(<2 x float> %a, <2 x float> %b, <2 x float> %c)
  ret <2 x float> %r
}

; negative test - must have 3 shuffles

define <2 x float> @fma_unary_shuffle_ops_unshuffled(<2 x float> %x, <2 x float> %y, <2 x float> %z) {
; CHECK-LABEL: @fma_unary_shuffle_ops_unshuffled(
; CHECK-NEXT:    [[A:%.*]] = shufflevector <2 x float> [[X:%.*]], <2 x float> poison, <2 x i32> <i32 1, i32 0>
; CHECK-NEXT:    [[B:%.*]] = shufflevector <2 x float> [[Y:%.*]], <2 x float> poison, <2 x i32> <i32 1, i32 0>
; CHECK-NEXT:    [[R:%.*]] = call <2 x float> @llvm.fma.v2f32(<2 x float> [[A]], <2 x float> [[B]], <2 x float> [[Z:%.*]])
; CHECK-NEXT:    ret <2 x float> [[R]]
;
  %a = shufflevector <2 x float> %x, <2 x float> poison, <2 x i32> <i32 1, i32 0>
  %b = shufflevector <2 x float> %y, <2 x float> poison, <2 x i32> <i32 1, i32 0>
  %r = call <2 x float> @llvm.fma.v2f32(<2 x float> %a, <2 x float> %b, <2 x float> %z)
  ret <2 x float> %r
}

; negative test - must have identical masks

define <2 x float> @fma_unary_shuffle_ops_wrong_mask(<2 x float> %x, <2 x float> %y, <2 x float> %z) {
; CHECK-LABEL: @fma_unary_shuffle_ops_wrong_mask(
; CHECK-NEXT:    [[A:%.*]] = shufflevector <2 x float> [[X:%.*]], <2 x float> poison, <2 x i32> <i32 1, i32 0>
; CHECK-NEXT:    [[B:%.*]] = shufflevector <2 x float> [[Y:%.*]], <2 x float> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[C:%.*]] = shufflevector <2 x float> [[Z:%.*]], <2 x float> poison, <2 x i32> <i32 1, i32 0>
; CHECK-NEXT:    [[R:%.*]] = call <2 x float> @llvm.fma.v2f32(<2 x float> [[A]], <2 x float> [[B]], <2 x float> [[C]])
; CHECK-NEXT:    ret <2 x float> [[R]]
;
  %a = shufflevector <2 x float> %x, <2 x float> poison, <2 x i32> <i32 1, i32 0>
  %b = shufflevector <2 x float> %y, <2 x float> poison, <2 x i32> <i32 0, i32 0>
  %c = shufflevector <2 x float> %z, <2 x float> poison, <2 x i32> <i32 1, i32 0>
  %r = call <2 x float> @llvm.fma.v2f32(<2 x float> %a, <2 x float> %b, <2 x float> %c)
  ret <2 x float> %r
}

; negative test - too many uses

define <2 x float> @fma_unary_shuffle_ops_uses(<2 x float> %x, <2 x float> %y, <2 x float> %z) {
; CHECK-LABEL: @fma_unary_shuffle_ops_uses(
; CHECK-NEXT:    [[A:%.*]] = shufflevector <2 x float> [[X:%.*]], <2 x float> poison, <2 x i32> <i32 1, i32 0>
; CHECK-NEXT:    call void @use_vec(<2 x float> [[A]])
; CHECK-NEXT:    [[B:%.*]] = shufflevector <2 x float> [[Y:%.*]], <2 x float> poison, <2 x i32> <i32 1, i32 0>
; CHECK-NEXT:    call void @use_vec(<2 x float> [[B]])
; CHECK-NEXT:    [[C:%.*]] = shufflevector <2 x float> [[Z:%.*]], <2 x float> poison, <2 x i32> <i32 1, i32 0>
; CHECK-NEXT:    call void @use_vec(<2 x float> [[C]])
; CHECK-NEXT:    [[R:%.*]] = call <2 x float> @llvm.fma.v2f32(<2 x float> [[A]], <2 x float> [[B]], <2 x float> [[C]])
; CHECK-NEXT:    ret <2 x float> [[R]]
;
  %a = shufflevector <2 x float> %x, <2 x float> poison, <2 x i32> <i32 1, i32 0>
  call void @use_vec(<2 x float> %a)
  %b = shufflevector <2 x float> %y, <2 x float> poison, <2 x i32> <i32 1, i32 0>
  call void @use_vec(<2 x float> %b)
  %c = shufflevector <2 x float> %z, <2 x float> poison, <2 x i32> <i32 1, i32 0>
  call void @use_vec(<2 x float> %c)
  %r = call <2 x float> @llvm.fma.v2f32(<2 x float> %a, <2 x float> %b, <2 x float> %c)
  ret <2 x float> %r
}
