; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --filter-out "\b(sp)\b" --filter "^\s*(ld[^r]|st[^r]|swp|cas|bl|add|and|eor|orn|orr|sub|mvn|sxt|cmp|ccmp|csel|dmb)"
; The base test file was generated by ./llvm/test/CodeGen/AArch64/Atomics/generate-tests.py
; RUN: llc %s -o - -verify-machineinstrs -mtriple=aarch64_be -mattr=+lse128 -O0 | FileCheck %s --check-prefixes=CHECK,-O0
; RUN: llc %s -o - -verify-machineinstrs -mtriple=aarch64_be -mattr=+lse128 -O1 | FileCheck %s --check-prefixes=CHECK,-O1

define dso_local i8 @cmpxchg_i8_aligned_monotonic_monotonic(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_aligned_monotonic_monotonic:
; CHECK:    casb w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i8 %expected, i8 %new monotonic monotonic, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_aligned_monotonic_monotonic_weak(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_aligned_monotonic_monotonic_weak:
; CHECK:    casb w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i8 %expected, i8 %new monotonic monotonic, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_aligned_monotonic_acquire(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_aligned_monotonic_acquire:
; CHECK:    casab w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i8 %expected, i8 %new monotonic acquire, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_aligned_monotonic_acquire_weak(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_aligned_monotonic_acquire_weak:
; CHECK:    casab w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i8 %expected, i8 %new monotonic acquire, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_aligned_monotonic_seq_cst(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_aligned_monotonic_seq_cst:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i8 %expected, i8 %new monotonic seq_cst, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_aligned_monotonic_seq_cst_weak(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_aligned_monotonic_seq_cst_weak:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i8 %expected, i8 %new monotonic seq_cst, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_aligned_acquire_monotonic(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_aligned_acquire_monotonic:
; CHECK:    casab w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i8 %expected, i8 %new acquire monotonic, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_aligned_acquire_monotonic_weak(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_aligned_acquire_monotonic_weak:
; CHECK:    casab w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i8 %expected, i8 %new acquire monotonic, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_aligned_acquire_acquire(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_aligned_acquire_acquire:
; CHECK:    casab w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i8 %expected, i8 %new acquire acquire, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_aligned_acquire_acquire_weak(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_aligned_acquire_acquire_weak:
; CHECK:    casab w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i8 %expected, i8 %new acquire acquire, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_aligned_acquire_seq_cst(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_aligned_acquire_seq_cst:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i8 %expected, i8 %new acquire seq_cst, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_aligned_acquire_seq_cst_weak(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_aligned_acquire_seq_cst_weak:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i8 %expected, i8 %new acquire seq_cst, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_aligned_release_monotonic(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_aligned_release_monotonic:
; CHECK:    caslb w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i8 %expected, i8 %new release monotonic, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_aligned_release_monotonic_weak(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_aligned_release_monotonic_weak:
; CHECK:    caslb w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i8 %expected, i8 %new release monotonic, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_aligned_release_acquire(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_aligned_release_acquire:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i8 %expected, i8 %new release acquire, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_aligned_release_acquire_weak(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_aligned_release_acquire_weak:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i8 %expected, i8 %new release acquire, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_aligned_release_seq_cst(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_aligned_release_seq_cst:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i8 %expected, i8 %new release seq_cst, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_aligned_release_seq_cst_weak(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_aligned_release_seq_cst_weak:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i8 %expected, i8 %new release seq_cst, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_aligned_acq_rel_monotonic(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_aligned_acq_rel_monotonic:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i8 %expected, i8 %new acq_rel monotonic, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_aligned_acq_rel_monotonic_weak(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_aligned_acq_rel_monotonic_weak:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i8 %expected, i8 %new acq_rel monotonic, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_aligned_acq_rel_acquire(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_aligned_acq_rel_acquire:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i8 %expected, i8 %new acq_rel acquire, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_aligned_acq_rel_acquire_weak(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_aligned_acq_rel_acquire_weak:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i8 %expected, i8 %new acq_rel acquire, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_aligned_acq_rel_seq_cst(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_aligned_acq_rel_seq_cst:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i8 %expected, i8 %new acq_rel seq_cst, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_aligned_acq_rel_seq_cst_weak(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_aligned_acq_rel_seq_cst_weak:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i8 %expected, i8 %new acq_rel seq_cst, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_aligned_seq_cst_monotonic(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_aligned_seq_cst_monotonic:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i8 %expected, i8 %new seq_cst monotonic, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_aligned_seq_cst_monotonic_weak(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_aligned_seq_cst_monotonic_weak:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i8 %expected, i8 %new seq_cst monotonic, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_aligned_seq_cst_acquire(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_aligned_seq_cst_acquire:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i8 %expected, i8 %new seq_cst acquire, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_aligned_seq_cst_acquire_weak(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_aligned_seq_cst_acquire_weak:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i8 %expected, i8 %new seq_cst acquire, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_aligned_seq_cst_seq_cst(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_aligned_seq_cst_seq_cst:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i8 %expected, i8 %new seq_cst seq_cst, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_aligned_seq_cst_seq_cst_weak(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_aligned_seq_cst_seq_cst_weak:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i8 %expected, i8 %new seq_cst seq_cst, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i16 @cmpxchg_i16_aligned_monotonic_monotonic(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_aligned_monotonic_monotonic:
; CHECK:    cash w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i16 %expected, i16 %new monotonic monotonic, align 2
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_aligned_monotonic_monotonic_weak(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_aligned_monotonic_monotonic_weak:
; CHECK:    cash w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i16 %expected, i16 %new monotonic monotonic, align 2
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_aligned_monotonic_acquire(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_aligned_monotonic_acquire:
; CHECK:    casah w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i16 %expected, i16 %new monotonic acquire, align 2
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_aligned_monotonic_acquire_weak(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_aligned_monotonic_acquire_weak:
; CHECK:    casah w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i16 %expected, i16 %new monotonic acquire, align 2
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_aligned_monotonic_seq_cst(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_aligned_monotonic_seq_cst:
; CHECK:    casalh w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i16 %expected, i16 %new monotonic seq_cst, align 2
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_aligned_monotonic_seq_cst_weak(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_aligned_monotonic_seq_cst_weak:
; CHECK:    casalh w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i16 %expected, i16 %new monotonic seq_cst, align 2
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_aligned_acquire_monotonic(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_aligned_acquire_monotonic:
; CHECK:    casah w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i16 %expected, i16 %new acquire monotonic, align 2
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_aligned_acquire_monotonic_weak(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_aligned_acquire_monotonic_weak:
; CHECK:    casah w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i16 %expected, i16 %new acquire monotonic, align 2
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_aligned_acquire_acquire(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_aligned_acquire_acquire:
; CHECK:    casah w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i16 %expected, i16 %new acquire acquire, align 2
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_aligned_acquire_acquire_weak(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_aligned_acquire_acquire_weak:
; CHECK:    casah w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i16 %expected, i16 %new acquire acquire, align 2
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_aligned_acquire_seq_cst(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_aligned_acquire_seq_cst:
; CHECK:    casalh w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i16 %expected, i16 %new acquire seq_cst, align 2
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_aligned_acquire_seq_cst_weak(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_aligned_acquire_seq_cst_weak:
; CHECK:    casalh w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i16 %expected, i16 %new acquire seq_cst, align 2
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_aligned_release_monotonic(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_aligned_release_monotonic:
; CHECK:    caslh w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i16 %expected, i16 %new release monotonic, align 2
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_aligned_release_monotonic_weak(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_aligned_release_monotonic_weak:
; CHECK:    caslh w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i16 %expected, i16 %new release monotonic, align 2
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_aligned_release_acquire(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_aligned_release_acquire:
; CHECK:    casalh w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i16 %expected, i16 %new release acquire, align 2
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_aligned_release_acquire_weak(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_aligned_release_acquire_weak:
; CHECK:    casalh w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i16 %expected, i16 %new release acquire, align 2
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_aligned_release_seq_cst(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_aligned_release_seq_cst:
; CHECK:    casalh w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i16 %expected, i16 %new release seq_cst, align 2
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_aligned_release_seq_cst_weak(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_aligned_release_seq_cst_weak:
; CHECK:    casalh w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i16 %expected, i16 %new release seq_cst, align 2
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_aligned_acq_rel_monotonic(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_aligned_acq_rel_monotonic:
; CHECK:    casalh w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i16 %expected, i16 %new acq_rel monotonic, align 2
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_aligned_acq_rel_monotonic_weak(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_aligned_acq_rel_monotonic_weak:
; CHECK:    casalh w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i16 %expected, i16 %new acq_rel monotonic, align 2
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_aligned_acq_rel_acquire(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_aligned_acq_rel_acquire:
; CHECK:    casalh w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i16 %expected, i16 %new acq_rel acquire, align 2
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_aligned_acq_rel_acquire_weak(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_aligned_acq_rel_acquire_weak:
; CHECK:    casalh w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i16 %expected, i16 %new acq_rel acquire, align 2
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_aligned_acq_rel_seq_cst(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_aligned_acq_rel_seq_cst:
; CHECK:    casalh w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i16 %expected, i16 %new acq_rel seq_cst, align 2
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_aligned_acq_rel_seq_cst_weak(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_aligned_acq_rel_seq_cst_weak:
; CHECK:    casalh w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i16 %expected, i16 %new acq_rel seq_cst, align 2
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_aligned_seq_cst_monotonic(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_aligned_seq_cst_monotonic:
; CHECK:    casalh w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i16 %expected, i16 %new seq_cst monotonic, align 2
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_aligned_seq_cst_monotonic_weak(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_aligned_seq_cst_monotonic_weak:
; CHECK:    casalh w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i16 %expected, i16 %new seq_cst monotonic, align 2
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_aligned_seq_cst_acquire(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_aligned_seq_cst_acquire:
; CHECK:    casalh w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i16 %expected, i16 %new seq_cst acquire, align 2
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_aligned_seq_cst_acquire_weak(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_aligned_seq_cst_acquire_weak:
; CHECK:    casalh w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i16 %expected, i16 %new seq_cst acquire, align 2
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_aligned_seq_cst_seq_cst(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_aligned_seq_cst_seq_cst:
; CHECK:    casalh w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i16 %expected, i16 %new seq_cst seq_cst, align 2
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_aligned_seq_cst_seq_cst_weak(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_aligned_seq_cst_seq_cst_weak:
; CHECK:    casalh w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i16 %expected, i16 %new seq_cst seq_cst, align 2
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i32 @cmpxchg_i32_aligned_monotonic_monotonic(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_aligned_monotonic_monotonic:
; CHECK:    cas w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i32 %expected, i32 %new monotonic monotonic, align 4
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_aligned_monotonic_monotonic_weak(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_aligned_monotonic_monotonic_weak:
; CHECK:    cas w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i32 %expected, i32 %new monotonic monotonic, align 4
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_aligned_monotonic_acquire(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_aligned_monotonic_acquire:
; CHECK:    casa w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i32 %expected, i32 %new monotonic acquire, align 4
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_aligned_monotonic_acquire_weak(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_aligned_monotonic_acquire_weak:
; CHECK:    casa w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i32 %expected, i32 %new monotonic acquire, align 4
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_aligned_monotonic_seq_cst(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_aligned_monotonic_seq_cst:
; CHECK:    casal w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i32 %expected, i32 %new monotonic seq_cst, align 4
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_aligned_monotonic_seq_cst_weak(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_aligned_monotonic_seq_cst_weak:
; CHECK:    casal w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i32 %expected, i32 %new monotonic seq_cst, align 4
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_aligned_acquire_monotonic(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_aligned_acquire_monotonic:
; CHECK:    casa w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i32 %expected, i32 %new acquire monotonic, align 4
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_aligned_acquire_monotonic_weak(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_aligned_acquire_monotonic_weak:
; CHECK:    casa w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i32 %expected, i32 %new acquire monotonic, align 4
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_aligned_acquire_acquire(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_aligned_acquire_acquire:
; CHECK:    casa w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i32 %expected, i32 %new acquire acquire, align 4
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_aligned_acquire_acquire_weak(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_aligned_acquire_acquire_weak:
; CHECK:    casa w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i32 %expected, i32 %new acquire acquire, align 4
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_aligned_acquire_seq_cst(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_aligned_acquire_seq_cst:
; CHECK:    casal w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i32 %expected, i32 %new acquire seq_cst, align 4
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_aligned_acquire_seq_cst_weak(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_aligned_acquire_seq_cst_weak:
; CHECK:    casal w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i32 %expected, i32 %new acquire seq_cst, align 4
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_aligned_release_monotonic(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_aligned_release_monotonic:
; CHECK:    casl w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i32 %expected, i32 %new release monotonic, align 4
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_aligned_release_monotonic_weak(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_aligned_release_monotonic_weak:
; CHECK:    casl w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i32 %expected, i32 %new release monotonic, align 4
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_aligned_release_acquire(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_aligned_release_acquire:
; CHECK:    casal w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i32 %expected, i32 %new release acquire, align 4
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_aligned_release_acquire_weak(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_aligned_release_acquire_weak:
; CHECK:    casal w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i32 %expected, i32 %new release acquire, align 4
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_aligned_release_seq_cst(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_aligned_release_seq_cst:
; CHECK:    casal w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i32 %expected, i32 %new release seq_cst, align 4
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_aligned_release_seq_cst_weak(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_aligned_release_seq_cst_weak:
; CHECK:    casal w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i32 %expected, i32 %new release seq_cst, align 4
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_aligned_acq_rel_monotonic(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_aligned_acq_rel_monotonic:
; CHECK:    casal w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i32 %expected, i32 %new acq_rel monotonic, align 4
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_aligned_acq_rel_monotonic_weak(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_aligned_acq_rel_monotonic_weak:
; CHECK:    casal w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i32 %expected, i32 %new acq_rel monotonic, align 4
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_aligned_acq_rel_acquire(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_aligned_acq_rel_acquire:
; CHECK:    casal w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i32 %expected, i32 %new acq_rel acquire, align 4
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_aligned_acq_rel_acquire_weak(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_aligned_acq_rel_acquire_weak:
; CHECK:    casal w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i32 %expected, i32 %new acq_rel acquire, align 4
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_aligned_acq_rel_seq_cst(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_aligned_acq_rel_seq_cst:
; CHECK:    casal w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i32 %expected, i32 %new acq_rel seq_cst, align 4
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_aligned_acq_rel_seq_cst_weak(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_aligned_acq_rel_seq_cst_weak:
; CHECK:    casal w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i32 %expected, i32 %new acq_rel seq_cst, align 4
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_aligned_seq_cst_monotonic(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_aligned_seq_cst_monotonic:
; CHECK:    casal w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i32 %expected, i32 %new seq_cst monotonic, align 4
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_aligned_seq_cst_monotonic_weak(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_aligned_seq_cst_monotonic_weak:
; CHECK:    casal w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i32 %expected, i32 %new seq_cst monotonic, align 4
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_aligned_seq_cst_acquire(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_aligned_seq_cst_acquire:
; CHECK:    casal w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i32 %expected, i32 %new seq_cst acquire, align 4
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_aligned_seq_cst_acquire_weak(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_aligned_seq_cst_acquire_weak:
; CHECK:    casal w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i32 %expected, i32 %new seq_cst acquire, align 4
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_aligned_seq_cst_seq_cst(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_aligned_seq_cst_seq_cst:
; CHECK:    casal w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i32 %expected, i32 %new seq_cst seq_cst, align 4
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_aligned_seq_cst_seq_cst_weak(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_aligned_seq_cst_seq_cst_weak:
; CHECK:    casal w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i32 %expected, i32 %new seq_cst seq_cst, align 4
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i64 @cmpxchg_i64_aligned_monotonic_monotonic(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_aligned_monotonic_monotonic:
; CHECK:    cas x0, x1, [x2]
    %pair = cmpxchg ptr %ptr, i64 %expected, i64 %new monotonic monotonic, align 8
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_aligned_monotonic_monotonic_weak(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_aligned_monotonic_monotonic_weak:
; CHECK:    cas x0, x1, [x2]
    %pair = cmpxchg weak ptr %ptr, i64 %expected, i64 %new monotonic monotonic, align 8
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_aligned_monotonic_acquire(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_aligned_monotonic_acquire:
; CHECK:    casa x0, x1, [x2]
    %pair = cmpxchg ptr %ptr, i64 %expected, i64 %new monotonic acquire, align 8
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_aligned_monotonic_acquire_weak(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_aligned_monotonic_acquire_weak:
; CHECK:    casa x0, x1, [x2]
    %pair = cmpxchg weak ptr %ptr, i64 %expected, i64 %new monotonic acquire, align 8
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_aligned_monotonic_seq_cst(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_aligned_monotonic_seq_cst:
; CHECK:    casal x0, x1, [x2]
    %pair = cmpxchg ptr %ptr, i64 %expected, i64 %new monotonic seq_cst, align 8
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_aligned_monotonic_seq_cst_weak(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_aligned_monotonic_seq_cst_weak:
; CHECK:    casal x0, x1, [x2]
    %pair = cmpxchg weak ptr %ptr, i64 %expected, i64 %new monotonic seq_cst, align 8
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_aligned_acquire_monotonic(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_aligned_acquire_monotonic:
; CHECK:    casa x0, x1, [x2]
    %pair = cmpxchg ptr %ptr, i64 %expected, i64 %new acquire monotonic, align 8
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_aligned_acquire_monotonic_weak(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_aligned_acquire_monotonic_weak:
; CHECK:    casa x0, x1, [x2]
    %pair = cmpxchg weak ptr %ptr, i64 %expected, i64 %new acquire monotonic, align 8
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_aligned_acquire_acquire(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_aligned_acquire_acquire:
; CHECK:    casa x0, x1, [x2]
    %pair = cmpxchg ptr %ptr, i64 %expected, i64 %new acquire acquire, align 8
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_aligned_acquire_acquire_weak(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_aligned_acquire_acquire_weak:
; CHECK:    casa x0, x1, [x2]
    %pair = cmpxchg weak ptr %ptr, i64 %expected, i64 %new acquire acquire, align 8
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_aligned_acquire_seq_cst(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_aligned_acquire_seq_cst:
; CHECK:    casal x0, x1, [x2]
    %pair = cmpxchg ptr %ptr, i64 %expected, i64 %new acquire seq_cst, align 8
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_aligned_acquire_seq_cst_weak(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_aligned_acquire_seq_cst_weak:
; CHECK:    casal x0, x1, [x2]
    %pair = cmpxchg weak ptr %ptr, i64 %expected, i64 %new acquire seq_cst, align 8
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_aligned_release_monotonic(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_aligned_release_monotonic:
; CHECK:    casl x0, x1, [x2]
    %pair = cmpxchg ptr %ptr, i64 %expected, i64 %new release monotonic, align 8
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_aligned_release_monotonic_weak(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_aligned_release_monotonic_weak:
; CHECK:    casl x0, x1, [x2]
    %pair = cmpxchg weak ptr %ptr, i64 %expected, i64 %new release monotonic, align 8
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_aligned_release_acquire(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_aligned_release_acquire:
; CHECK:    casal x0, x1, [x2]
    %pair = cmpxchg ptr %ptr, i64 %expected, i64 %new release acquire, align 8
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_aligned_release_acquire_weak(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_aligned_release_acquire_weak:
; CHECK:    casal x0, x1, [x2]
    %pair = cmpxchg weak ptr %ptr, i64 %expected, i64 %new release acquire, align 8
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_aligned_release_seq_cst(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_aligned_release_seq_cst:
; CHECK:    casal x0, x1, [x2]
    %pair = cmpxchg ptr %ptr, i64 %expected, i64 %new release seq_cst, align 8
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_aligned_release_seq_cst_weak(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_aligned_release_seq_cst_weak:
; CHECK:    casal x0, x1, [x2]
    %pair = cmpxchg weak ptr %ptr, i64 %expected, i64 %new release seq_cst, align 8
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_aligned_acq_rel_monotonic(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_aligned_acq_rel_monotonic:
; CHECK:    casal x0, x1, [x2]
    %pair = cmpxchg ptr %ptr, i64 %expected, i64 %new acq_rel monotonic, align 8
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_aligned_acq_rel_monotonic_weak(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_aligned_acq_rel_monotonic_weak:
; CHECK:    casal x0, x1, [x2]
    %pair = cmpxchg weak ptr %ptr, i64 %expected, i64 %new acq_rel monotonic, align 8
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_aligned_acq_rel_acquire(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_aligned_acq_rel_acquire:
; CHECK:    casal x0, x1, [x2]
    %pair = cmpxchg ptr %ptr, i64 %expected, i64 %new acq_rel acquire, align 8
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_aligned_acq_rel_acquire_weak(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_aligned_acq_rel_acquire_weak:
; CHECK:    casal x0, x1, [x2]
    %pair = cmpxchg weak ptr %ptr, i64 %expected, i64 %new acq_rel acquire, align 8
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_aligned_acq_rel_seq_cst(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_aligned_acq_rel_seq_cst:
; CHECK:    casal x0, x1, [x2]
    %pair = cmpxchg ptr %ptr, i64 %expected, i64 %new acq_rel seq_cst, align 8
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_aligned_acq_rel_seq_cst_weak(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_aligned_acq_rel_seq_cst_weak:
; CHECK:    casal x0, x1, [x2]
    %pair = cmpxchg weak ptr %ptr, i64 %expected, i64 %new acq_rel seq_cst, align 8
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_aligned_seq_cst_monotonic(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_aligned_seq_cst_monotonic:
; CHECK:    casal x0, x1, [x2]
    %pair = cmpxchg ptr %ptr, i64 %expected, i64 %new seq_cst monotonic, align 8
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_aligned_seq_cst_monotonic_weak(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_aligned_seq_cst_monotonic_weak:
; CHECK:    casal x0, x1, [x2]
    %pair = cmpxchg weak ptr %ptr, i64 %expected, i64 %new seq_cst monotonic, align 8
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_aligned_seq_cst_acquire(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_aligned_seq_cst_acquire:
; CHECK:    casal x0, x1, [x2]
    %pair = cmpxchg ptr %ptr, i64 %expected, i64 %new seq_cst acquire, align 8
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_aligned_seq_cst_acquire_weak(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_aligned_seq_cst_acquire_weak:
; CHECK:    casal x0, x1, [x2]
    %pair = cmpxchg weak ptr %ptr, i64 %expected, i64 %new seq_cst acquire, align 8
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_aligned_seq_cst_seq_cst(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_aligned_seq_cst_seq_cst:
; CHECK:    casal x0, x1, [x2]
    %pair = cmpxchg ptr %ptr, i64 %expected, i64 %new seq_cst seq_cst, align 8
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_aligned_seq_cst_seq_cst_weak(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_aligned_seq_cst_seq_cst_weak:
; CHECK:    casal x0, x1, [x2]
    %pair = cmpxchg weak ptr %ptr, i64 %expected, i64 %new seq_cst seq_cst, align 8
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i128 @cmpxchg_i128_aligned_monotonic_monotonic(i128 %expected, i128 %new, ptr %ptr) {
; -O0-LABEL: cmpxchg_i128_aligned_monotonic_monotonic:
; -O0:    casp x2, x3, x0, x1, [x4]
;
; -O1-LABEL: cmpxchg_i128_aligned_monotonic_monotonic:
; -O1:    casp x0, x1, x2, x3, [x4]
    %pair = cmpxchg ptr %ptr, i128 %expected, i128 %new monotonic monotonic, align 16
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_aligned_monotonic_monotonic_weak(i128 %expected, i128 %new, ptr %ptr) {
; -O0-LABEL: cmpxchg_i128_aligned_monotonic_monotonic_weak:
; -O0:    casp x2, x3, x0, x1, [x4]
;
; -O1-LABEL: cmpxchg_i128_aligned_monotonic_monotonic_weak:
; -O1:    casp x0, x1, x2, x3, [x4]
    %pair = cmpxchg weak ptr %ptr, i128 %expected, i128 %new monotonic monotonic, align 16
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_aligned_monotonic_acquire(i128 %expected, i128 %new, ptr %ptr) {
; -O0-LABEL: cmpxchg_i128_aligned_monotonic_acquire:
; -O0:    caspa x2, x3, x0, x1, [x4]
;
; -O1-LABEL: cmpxchg_i128_aligned_monotonic_acquire:
; -O1:    caspa x0, x1, x2, x3, [x4]
    %pair = cmpxchg ptr %ptr, i128 %expected, i128 %new monotonic acquire, align 16
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_aligned_monotonic_acquire_weak(i128 %expected, i128 %new, ptr %ptr) {
; -O0-LABEL: cmpxchg_i128_aligned_monotonic_acquire_weak:
; -O0:    caspa x2, x3, x0, x1, [x4]
;
; -O1-LABEL: cmpxchg_i128_aligned_monotonic_acquire_weak:
; -O1:    caspa x0, x1, x2, x3, [x4]
    %pair = cmpxchg weak ptr %ptr, i128 %expected, i128 %new monotonic acquire, align 16
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_aligned_monotonic_seq_cst(i128 %expected, i128 %new, ptr %ptr) {
; -O0-LABEL: cmpxchg_i128_aligned_monotonic_seq_cst:
; -O0:    caspal x2, x3, x0, x1, [x4]
;
; -O1-LABEL: cmpxchg_i128_aligned_monotonic_seq_cst:
; -O1:    caspal x0, x1, x2, x3, [x4]
    %pair = cmpxchg ptr %ptr, i128 %expected, i128 %new monotonic seq_cst, align 16
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_aligned_monotonic_seq_cst_weak(i128 %expected, i128 %new, ptr %ptr) {
; -O0-LABEL: cmpxchg_i128_aligned_monotonic_seq_cst_weak:
; -O0:    caspal x2, x3, x0, x1, [x4]
;
; -O1-LABEL: cmpxchg_i128_aligned_monotonic_seq_cst_weak:
; -O1:    caspal x0, x1, x2, x3, [x4]
    %pair = cmpxchg weak ptr %ptr, i128 %expected, i128 %new monotonic seq_cst, align 16
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_aligned_acquire_monotonic(i128 %expected, i128 %new, ptr %ptr) {
; -O0-LABEL: cmpxchg_i128_aligned_acquire_monotonic:
; -O0:    caspa x2, x3, x0, x1, [x4]
;
; -O1-LABEL: cmpxchg_i128_aligned_acquire_monotonic:
; -O1:    caspa x0, x1, x2, x3, [x4]
    %pair = cmpxchg ptr %ptr, i128 %expected, i128 %new acquire monotonic, align 16
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_aligned_acquire_monotonic_weak(i128 %expected, i128 %new, ptr %ptr) {
; -O0-LABEL: cmpxchg_i128_aligned_acquire_monotonic_weak:
; -O0:    caspa x2, x3, x0, x1, [x4]
;
; -O1-LABEL: cmpxchg_i128_aligned_acquire_monotonic_weak:
; -O1:    caspa x0, x1, x2, x3, [x4]
    %pair = cmpxchg weak ptr %ptr, i128 %expected, i128 %new acquire monotonic, align 16
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_aligned_acquire_acquire(i128 %expected, i128 %new, ptr %ptr) {
; -O0-LABEL: cmpxchg_i128_aligned_acquire_acquire:
; -O0:    caspa x2, x3, x0, x1, [x4]
;
; -O1-LABEL: cmpxchg_i128_aligned_acquire_acquire:
; -O1:    caspa x0, x1, x2, x3, [x4]
    %pair = cmpxchg ptr %ptr, i128 %expected, i128 %new acquire acquire, align 16
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_aligned_acquire_acquire_weak(i128 %expected, i128 %new, ptr %ptr) {
; -O0-LABEL: cmpxchg_i128_aligned_acquire_acquire_weak:
; -O0:    caspa x2, x3, x0, x1, [x4]
;
; -O1-LABEL: cmpxchg_i128_aligned_acquire_acquire_weak:
; -O1:    caspa x0, x1, x2, x3, [x4]
    %pair = cmpxchg weak ptr %ptr, i128 %expected, i128 %new acquire acquire, align 16
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_aligned_acquire_seq_cst(i128 %expected, i128 %new, ptr %ptr) {
; -O0-LABEL: cmpxchg_i128_aligned_acquire_seq_cst:
; -O0:    caspal x2, x3, x0, x1, [x4]
;
; -O1-LABEL: cmpxchg_i128_aligned_acquire_seq_cst:
; -O1:    caspal x0, x1, x2, x3, [x4]
    %pair = cmpxchg ptr %ptr, i128 %expected, i128 %new acquire seq_cst, align 16
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_aligned_acquire_seq_cst_weak(i128 %expected, i128 %new, ptr %ptr) {
; -O0-LABEL: cmpxchg_i128_aligned_acquire_seq_cst_weak:
; -O0:    caspal x2, x3, x0, x1, [x4]
;
; -O1-LABEL: cmpxchg_i128_aligned_acquire_seq_cst_weak:
; -O1:    caspal x0, x1, x2, x3, [x4]
    %pair = cmpxchg weak ptr %ptr, i128 %expected, i128 %new acquire seq_cst, align 16
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_aligned_release_monotonic(i128 %expected, i128 %new, ptr %ptr) {
; -O0-LABEL: cmpxchg_i128_aligned_release_monotonic:
; -O0:    caspl x2, x3, x0, x1, [x4]
;
; -O1-LABEL: cmpxchg_i128_aligned_release_monotonic:
; -O1:    caspl x0, x1, x2, x3, [x4]
    %pair = cmpxchg ptr %ptr, i128 %expected, i128 %new release monotonic, align 16
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_aligned_release_monotonic_weak(i128 %expected, i128 %new, ptr %ptr) {
; -O0-LABEL: cmpxchg_i128_aligned_release_monotonic_weak:
; -O0:    caspl x2, x3, x0, x1, [x4]
;
; -O1-LABEL: cmpxchg_i128_aligned_release_monotonic_weak:
; -O1:    caspl x0, x1, x2, x3, [x4]
    %pair = cmpxchg weak ptr %ptr, i128 %expected, i128 %new release monotonic, align 16
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_aligned_release_acquire(i128 %expected, i128 %new, ptr %ptr) {
; -O0-LABEL: cmpxchg_i128_aligned_release_acquire:
; -O0:    caspal x2, x3, x0, x1, [x4]
;
; -O1-LABEL: cmpxchg_i128_aligned_release_acquire:
; -O1:    caspal x0, x1, x2, x3, [x4]
    %pair = cmpxchg ptr %ptr, i128 %expected, i128 %new release acquire, align 16
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_aligned_release_acquire_weak(i128 %expected, i128 %new, ptr %ptr) {
; -O0-LABEL: cmpxchg_i128_aligned_release_acquire_weak:
; -O0:    caspal x2, x3, x0, x1, [x4]
;
; -O1-LABEL: cmpxchg_i128_aligned_release_acquire_weak:
; -O1:    caspal x0, x1, x2, x3, [x4]
    %pair = cmpxchg weak ptr %ptr, i128 %expected, i128 %new release acquire, align 16
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_aligned_release_seq_cst(i128 %expected, i128 %new, ptr %ptr) {
; -O0-LABEL: cmpxchg_i128_aligned_release_seq_cst:
; -O0:    caspal x2, x3, x0, x1, [x4]
;
; -O1-LABEL: cmpxchg_i128_aligned_release_seq_cst:
; -O1:    caspal x0, x1, x2, x3, [x4]
    %pair = cmpxchg ptr %ptr, i128 %expected, i128 %new release seq_cst, align 16
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_aligned_release_seq_cst_weak(i128 %expected, i128 %new, ptr %ptr) {
; -O0-LABEL: cmpxchg_i128_aligned_release_seq_cst_weak:
; -O0:    caspal x2, x3, x0, x1, [x4]
;
; -O1-LABEL: cmpxchg_i128_aligned_release_seq_cst_weak:
; -O1:    caspal x0, x1, x2, x3, [x4]
    %pair = cmpxchg weak ptr %ptr, i128 %expected, i128 %new release seq_cst, align 16
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_aligned_acq_rel_monotonic(i128 %expected, i128 %new, ptr %ptr) {
; -O0-LABEL: cmpxchg_i128_aligned_acq_rel_monotonic:
; -O0:    caspal x2, x3, x0, x1, [x4]
;
; -O1-LABEL: cmpxchg_i128_aligned_acq_rel_monotonic:
; -O1:    caspal x0, x1, x2, x3, [x4]
    %pair = cmpxchg ptr %ptr, i128 %expected, i128 %new acq_rel monotonic, align 16
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_aligned_acq_rel_monotonic_weak(i128 %expected, i128 %new, ptr %ptr) {
; -O0-LABEL: cmpxchg_i128_aligned_acq_rel_monotonic_weak:
; -O0:    caspal x2, x3, x0, x1, [x4]
;
; -O1-LABEL: cmpxchg_i128_aligned_acq_rel_monotonic_weak:
; -O1:    caspal x0, x1, x2, x3, [x4]
    %pair = cmpxchg weak ptr %ptr, i128 %expected, i128 %new acq_rel monotonic, align 16
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_aligned_acq_rel_acquire(i128 %expected, i128 %new, ptr %ptr) {
; -O0-LABEL: cmpxchg_i128_aligned_acq_rel_acquire:
; -O0:    caspal x2, x3, x0, x1, [x4]
;
; -O1-LABEL: cmpxchg_i128_aligned_acq_rel_acquire:
; -O1:    caspal x0, x1, x2, x3, [x4]
    %pair = cmpxchg ptr %ptr, i128 %expected, i128 %new acq_rel acquire, align 16
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_aligned_acq_rel_acquire_weak(i128 %expected, i128 %new, ptr %ptr) {
; -O0-LABEL: cmpxchg_i128_aligned_acq_rel_acquire_weak:
; -O0:    caspal x2, x3, x0, x1, [x4]
;
; -O1-LABEL: cmpxchg_i128_aligned_acq_rel_acquire_weak:
; -O1:    caspal x0, x1, x2, x3, [x4]
    %pair = cmpxchg weak ptr %ptr, i128 %expected, i128 %new acq_rel acquire, align 16
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_aligned_acq_rel_seq_cst(i128 %expected, i128 %new, ptr %ptr) {
; -O0-LABEL: cmpxchg_i128_aligned_acq_rel_seq_cst:
; -O0:    caspal x2, x3, x0, x1, [x4]
;
; -O1-LABEL: cmpxchg_i128_aligned_acq_rel_seq_cst:
; -O1:    caspal x0, x1, x2, x3, [x4]
    %pair = cmpxchg ptr %ptr, i128 %expected, i128 %new acq_rel seq_cst, align 16
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_aligned_acq_rel_seq_cst_weak(i128 %expected, i128 %new, ptr %ptr) {
; -O0-LABEL: cmpxchg_i128_aligned_acq_rel_seq_cst_weak:
; -O0:    caspal x2, x3, x0, x1, [x4]
;
; -O1-LABEL: cmpxchg_i128_aligned_acq_rel_seq_cst_weak:
; -O1:    caspal x0, x1, x2, x3, [x4]
    %pair = cmpxchg weak ptr %ptr, i128 %expected, i128 %new acq_rel seq_cst, align 16
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_aligned_seq_cst_monotonic(i128 %expected, i128 %new, ptr %ptr) {
; -O0-LABEL: cmpxchg_i128_aligned_seq_cst_monotonic:
; -O0:    caspal x2, x3, x0, x1, [x4]
;
; -O1-LABEL: cmpxchg_i128_aligned_seq_cst_monotonic:
; -O1:    caspal x0, x1, x2, x3, [x4]
    %pair = cmpxchg ptr %ptr, i128 %expected, i128 %new seq_cst monotonic, align 16
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_aligned_seq_cst_monotonic_weak(i128 %expected, i128 %new, ptr %ptr) {
; -O0-LABEL: cmpxchg_i128_aligned_seq_cst_monotonic_weak:
; -O0:    caspal x2, x3, x0, x1, [x4]
;
; -O1-LABEL: cmpxchg_i128_aligned_seq_cst_monotonic_weak:
; -O1:    caspal x0, x1, x2, x3, [x4]
    %pair = cmpxchg weak ptr %ptr, i128 %expected, i128 %new seq_cst monotonic, align 16
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_aligned_seq_cst_acquire(i128 %expected, i128 %new, ptr %ptr) {
; -O0-LABEL: cmpxchg_i128_aligned_seq_cst_acquire:
; -O0:    caspal x2, x3, x0, x1, [x4]
;
; -O1-LABEL: cmpxchg_i128_aligned_seq_cst_acquire:
; -O1:    caspal x0, x1, x2, x3, [x4]
    %pair = cmpxchg ptr %ptr, i128 %expected, i128 %new seq_cst acquire, align 16
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_aligned_seq_cst_acquire_weak(i128 %expected, i128 %new, ptr %ptr) {
; -O0-LABEL: cmpxchg_i128_aligned_seq_cst_acquire_weak:
; -O0:    caspal x2, x3, x0, x1, [x4]
;
; -O1-LABEL: cmpxchg_i128_aligned_seq_cst_acquire_weak:
; -O1:    caspal x0, x1, x2, x3, [x4]
    %pair = cmpxchg weak ptr %ptr, i128 %expected, i128 %new seq_cst acquire, align 16
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_aligned_seq_cst_seq_cst(i128 %expected, i128 %new, ptr %ptr) {
; -O0-LABEL: cmpxchg_i128_aligned_seq_cst_seq_cst:
; -O0:    caspal x2, x3, x0, x1, [x4]
;
; -O1-LABEL: cmpxchg_i128_aligned_seq_cst_seq_cst:
; -O1:    caspal x0, x1, x2, x3, [x4]
    %pair = cmpxchg ptr %ptr, i128 %expected, i128 %new seq_cst seq_cst, align 16
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_aligned_seq_cst_seq_cst_weak(i128 %expected, i128 %new, ptr %ptr) {
; -O0-LABEL: cmpxchg_i128_aligned_seq_cst_seq_cst_weak:
; -O0:    caspal x2, x3, x0, x1, [x4]
;
; -O1-LABEL: cmpxchg_i128_aligned_seq_cst_seq_cst_weak:
; -O1:    caspal x0, x1, x2, x3, [x4]
    %pair = cmpxchg weak ptr %ptr, i128 %expected, i128 %new seq_cst seq_cst, align 16
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i8 @cmpxchg_i8_unaligned_monotonic_monotonic(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_unaligned_monotonic_monotonic:
; CHECK:    casb w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i8 %expected, i8 %new monotonic monotonic, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_unaligned_monotonic_monotonic_weak(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_unaligned_monotonic_monotonic_weak:
; CHECK:    casb w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i8 %expected, i8 %new monotonic monotonic, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_unaligned_monotonic_acquire(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_unaligned_monotonic_acquire:
; CHECK:    casab w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i8 %expected, i8 %new monotonic acquire, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_unaligned_monotonic_acquire_weak(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_unaligned_monotonic_acquire_weak:
; CHECK:    casab w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i8 %expected, i8 %new monotonic acquire, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_unaligned_monotonic_seq_cst(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_unaligned_monotonic_seq_cst:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i8 %expected, i8 %new monotonic seq_cst, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_unaligned_monotonic_seq_cst_weak(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_unaligned_monotonic_seq_cst_weak:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i8 %expected, i8 %new monotonic seq_cst, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_unaligned_acquire_monotonic(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_unaligned_acquire_monotonic:
; CHECK:    casab w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i8 %expected, i8 %new acquire monotonic, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_unaligned_acquire_monotonic_weak(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_unaligned_acquire_monotonic_weak:
; CHECK:    casab w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i8 %expected, i8 %new acquire monotonic, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_unaligned_acquire_acquire(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_unaligned_acquire_acquire:
; CHECK:    casab w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i8 %expected, i8 %new acquire acquire, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_unaligned_acquire_acquire_weak(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_unaligned_acquire_acquire_weak:
; CHECK:    casab w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i8 %expected, i8 %new acquire acquire, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_unaligned_acquire_seq_cst(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_unaligned_acquire_seq_cst:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i8 %expected, i8 %new acquire seq_cst, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_unaligned_acquire_seq_cst_weak(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_unaligned_acquire_seq_cst_weak:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i8 %expected, i8 %new acquire seq_cst, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_unaligned_release_monotonic(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_unaligned_release_monotonic:
; CHECK:    caslb w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i8 %expected, i8 %new release monotonic, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_unaligned_release_monotonic_weak(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_unaligned_release_monotonic_weak:
; CHECK:    caslb w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i8 %expected, i8 %new release monotonic, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_unaligned_release_acquire(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_unaligned_release_acquire:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i8 %expected, i8 %new release acquire, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_unaligned_release_acquire_weak(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_unaligned_release_acquire_weak:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i8 %expected, i8 %new release acquire, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_unaligned_release_seq_cst(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_unaligned_release_seq_cst:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i8 %expected, i8 %new release seq_cst, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_unaligned_release_seq_cst_weak(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_unaligned_release_seq_cst_weak:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i8 %expected, i8 %new release seq_cst, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_unaligned_acq_rel_monotonic(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_unaligned_acq_rel_monotonic:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i8 %expected, i8 %new acq_rel monotonic, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_unaligned_acq_rel_monotonic_weak(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_unaligned_acq_rel_monotonic_weak:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i8 %expected, i8 %new acq_rel monotonic, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_unaligned_acq_rel_acquire(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_unaligned_acq_rel_acquire:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i8 %expected, i8 %new acq_rel acquire, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_unaligned_acq_rel_acquire_weak(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_unaligned_acq_rel_acquire_weak:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i8 %expected, i8 %new acq_rel acquire, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_unaligned_acq_rel_seq_cst(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_unaligned_acq_rel_seq_cst:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i8 %expected, i8 %new acq_rel seq_cst, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_unaligned_acq_rel_seq_cst_weak(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_unaligned_acq_rel_seq_cst_weak:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i8 %expected, i8 %new acq_rel seq_cst, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_unaligned_seq_cst_monotonic(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_unaligned_seq_cst_monotonic:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i8 %expected, i8 %new seq_cst monotonic, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_unaligned_seq_cst_monotonic_weak(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_unaligned_seq_cst_monotonic_weak:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i8 %expected, i8 %new seq_cst monotonic, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_unaligned_seq_cst_acquire(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_unaligned_seq_cst_acquire:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i8 %expected, i8 %new seq_cst acquire, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_unaligned_seq_cst_acquire_weak(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_unaligned_seq_cst_acquire_weak:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i8 %expected, i8 %new seq_cst acquire, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_unaligned_seq_cst_seq_cst(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_unaligned_seq_cst_seq_cst:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg ptr %ptr, i8 %expected, i8 %new seq_cst seq_cst, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i8 @cmpxchg_i8_unaligned_seq_cst_seq_cst_weak(i8 %expected, i8 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i8_unaligned_seq_cst_seq_cst_weak:
; CHECK:    casalb w0, w1, [x2]
    %pair = cmpxchg weak ptr %ptr, i8 %expected, i8 %new seq_cst seq_cst, align 1
    %r = extractvalue { i8, i1 } %pair, 0
    ret i8 %r
}

define dso_local i16 @cmpxchg_i16_unaligned_monotonic_monotonic(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_unaligned_monotonic_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i16 %expected, i16 %new monotonic monotonic, align 1
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_unaligned_monotonic_monotonic_weak(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_unaligned_monotonic_monotonic_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i16 %expected, i16 %new monotonic monotonic, align 1
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_unaligned_monotonic_acquire(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_unaligned_monotonic_acquire:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i16 %expected, i16 %new monotonic acquire, align 1
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_unaligned_monotonic_acquire_weak(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_unaligned_monotonic_acquire_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i16 %expected, i16 %new monotonic acquire, align 1
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_unaligned_monotonic_seq_cst(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_unaligned_monotonic_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i16 %expected, i16 %new monotonic seq_cst, align 1
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_unaligned_monotonic_seq_cst_weak(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_unaligned_monotonic_seq_cst_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i16 %expected, i16 %new monotonic seq_cst, align 1
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_unaligned_acquire_monotonic(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_unaligned_acquire_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i16 %expected, i16 %new acquire monotonic, align 1
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_unaligned_acquire_monotonic_weak(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_unaligned_acquire_monotonic_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i16 %expected, i16 %new acquire monotonic, align 1
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_unaligned_acquire_acquire(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_unaligned_acquire_acquire:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i16 %expected, i16 %new acquire acquire, align 1
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_unaligned_acquire_acquire_weak(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_unaligned_acquire_acquire_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i16 %expected, i16 %new acquire acquire, align 1
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_unaligned_acquire_seq_cst(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_unaligned_acquire_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i16 %expected, i16 %new acquire seq_cst, align 1
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_unaligned_acquire_seq_cst_weak(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_unaligned_acquire_seq_cst_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i16 %expected, i16 %new acquire seq_cst, align 1
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_unaligned_release_monotonic(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_unaligned_release_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i16 %expected, i16 %new release monotonic, align 1
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_unaligned_release_monotonic_weak(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_unaligned_release_monotonic_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i16 %expected, i16 %new release monotonic, align 1
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_unaligned_release_acquire(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_unaligned_release_acquire:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i16 %expected, i16 %new release acquire, align 1
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_unaligned_release_acquire_weak(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_unaligned_release_acquire_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i16 %expected, i16 %new release acquire, align 1
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_unaligned_release_seq_cst(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_unaligned_release_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i16 %expected, i16 %new release seq_cst, align 1
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_unaligned_release_seq_cst_weak(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_unaligned_release_seq_cst_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i16 %expected, i16 %new release seq_cst, align 1
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_unaligned_acq_rel_monotonic(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_unaligned_acq_rel_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i16 %expected, i16 %new acq_rel monotonic, align 1
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_unaligned_acq_rel_monotonic_weak(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_unaligned_acq_rel_monotonic_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i16 %expected, i16 %new acq_rel monotonic, align 1
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_unaligned_acq_rel_acquire(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_unaligned_acq_rel_acquire:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i16 %expected, i16 %new acq_rel acquire, align 1
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_unaligned_acq_rel_acquire_weak(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_unaligned_acq_rel_acquire_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i16 %expected, i16 %new acq_rel acquire, align 1
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_unaligned_acq_rel_seq_cst(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_unaligned_acq_rel_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i16 %expected, i16 %new acq_rel seq_cst, align 1
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_unaligned_acq_rel_seq_cst_weak(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_unaligned_acq_rel_seq_cst_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i16 %expected, i16 %new acq_rel seq_cst, align 1
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_unaligned_seq_cst_monotonic(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_unaligned_seq_cst_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i16 %expected, i16 %new seq_cst monotonic, align 1
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_unaligned_seq_cst_monotonic_weak(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_unaligned_seq_cst_monotonic_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i16 %expected, i16 %new seq_cst monotonic, align 1
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_unaligned_seq_cst_acquire(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_unaligned_seq_cst_acquire:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i16 %expected, i16 %new seq_cst acquire, align 1
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_unaligned_seq_cst_acquire_weak(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_unaligned_seq_cst_acquire_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i16 %expected, i16 %new seq_cst acquire, align 1
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_unaligned_seq_cst_seq_cst(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_unaligned_seq_cst_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i16 %expected, i16 %new seq_cst seq_cst, align 1
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i16 @cmpxchg_i16_unaligned_seq_cst_seq_cst_weak(i16 %expected, i16 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i16_unaligned_seq_cst_seq_cst_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i16 %expected, i16 %new seq_cst seq_cst, align 1
    %r = extractvalue { i16, i1 } %pair, 0
    ret i16 %r
}

define dso_local i32 @cmpxchg_i32_unaligned_monotonic_monotonic(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_unaligned_monotonic_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i32 %expected, i32 %new monotonic monotonic, align 1
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_unaligned_monotonic_monotonic_weak(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_unaligned_monotonic_monotonic_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i32 %expected, i32 %new monotonic monotonic, align 1
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_unaligned_monotonic_acquire(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_unaligned_monotonic_acquire:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i32 %expected, i32 %new monotonic acquire, align 1
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_unaligned_monotonic_acquire_weak(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_unaligned_monotonic_acquire_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i32 %expected, i32 %new monotonic acquire, align 1
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_unaligned_monotonic_seq_cst(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_unaligned_monotonic_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i32 %expected, i32 %new monotonic seq_cst, align 1
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_unaligned_monotonic_seq_cst_weak(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_unaligned_monotonic_seq_cst_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i32 %expected, i32 %new monotonic seq_cst, align 1
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_unaligned_acquire_monotonic(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_unaligned_acquire_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i32 %expected, i32 %new acquire monotonic, align 1
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_unaligned_acquire_monotonic_weak(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_unaligned_acquire_monotonic_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i32 %expected, i32 %new acquire monotonic, align 1
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_unaligned_acquire_acquire(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_unaligned_acquire_acquire:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i32 %expected, i32 %new acquire acquire, align 1
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_unaligned_acquire_acquire_weak(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_unaligned_acquire_acquire_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i32 %expected, i32 %new acquire acquire, align 1
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_unaligned_acquire_seq_cst(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_unaligned_acquire_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i32 %expected, i32 %new acquire seq_cst, align 1
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_unaligned_acquire_seq_cst_weak(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_unaligned_acquire_seq_cst_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i32 %expected, i32 %new acquire seq_cst, align 1
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_unaligned_release_monotonic(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_unaligned_release_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i32 %expected, i32 %new release monotonic, align 1
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_unaligned_release_monotonic_weak(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_unaligned_release_monotonic_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i32 %expected, i32 %new release monotonic, align 1
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_unaligned_release_acquire(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_unaligned_release_acquire:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i32 %expected, i32 %new release acquire, align 1
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_unaligned_release_acquire_weak(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_unaligned_release_acquire_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i32 %expected, i32 %new release acquire, align 1
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_unaligned_release_seq_cst(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_unaligned_release_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i32 %expected, i32 %new release seq_cst, align 1
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_unaligned_release_seq_cst_weak(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_unaligned_release_seq_cst_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i32 %expected, i32 %new release seq_cst, align 1
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_unaligned_acq_rel_monotonic(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_unaligned_acq_rel_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i32 %expected, i32 %new acq_rel monotonic, align 1
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_unaligned_acq_rel_monotonic_weak(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_unaligned_acq_rel_monotonic_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i32 %expected, i32 %new acq_rel monotonic, align 1
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_unaligned_acq_rel_acquire(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_unaligned_acq_rel_acquire:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i32 %expected, i32 %new acq_rel acquire, align 1
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_unaligned_acq_rel_acquire_weak(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_unaligned_acq_rel_acquire_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i32 %expected, i32 %new acq_rel acquire, align 1
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_unaligned_acq_rel_seq_cst(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_unaligned_acq_rel_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i32 %expected, i32 %new acq_rel seq_cst, align 1
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_unaligned_acq_rel_seq_cst_weak(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_unaligned_acq_rel_seq_cst_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i32 %expected, i32 %new acq_rel seq_cst, align 1
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_unaligned_seq_cst_monotonic(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_unaligned_seq_cst_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i32 %expected, i32 %new seq_cst monotonic, align 1
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_unaligned_seq_cst_monotonic_weak(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_unaligned_seq_cst_monotonic_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i32 %expected, i32 %new seq_cst monotonic, align 1
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_unaligned_seq_cst_acquire(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_unaligned_seq_cst_acquire:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i32 %expected, i32 %new seq_cst acquire, align 1
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_unaligned_seq_cst_acquire_weak(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_unaligned_seq_cst_acquire_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i32 %expected, i32 %new seq_cst acquire, align 1
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_unaligned_seq_cst_seq_cst(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_unaligned_seq_cst_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i32 %expected, i32 %new seq_cst seq_cst, align 1
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i32 @cmpxchg_i32_unaligned_seq_cst_seq_cst_weak(i32 %expected, i32 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i32_unaligned_seq_cst_seq_cst_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i32 %expected, i32 %new seq_cst seq_cst, align 1
    %r = extractvalue { i32, i1 } %pair, 0
    ret i32 %r
}

define dso_local i64 @cmpxchg_i64_unaligned_monotonic_monotonic(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_unaligned_monotonic_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i64 %expected, i64 %new monotonic monotonic, align 1
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_unaligned_monotonic_monotonic_weak(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_unaligned_monotonic_monotonic_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i64 %expected, i64 %new monotonic monotonic, align 1
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_unaligned_monotonic_acquire(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_unaligned_monotonic_acquire:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i64 %expected, i64 %new monotonic acquire, align 1
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_unaligned_monotonic_acquire_weak(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_unaligned_monotonic_acquire_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i64 %expected, i64 %new monotonic acquire, align 1
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_unaligned_monotonic_seq_cst(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_unaligned_monotonic_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i64 %expected, i64 %new monotonic seq_cst, align 1
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_unaligned_monotonic_seq_cst_weak(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_unaligned_monotonic_seq_cst_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i64 %expected, i64 %new monotonic seq_cst, align 1
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_unaligned_acquire_monotonic(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_unaligned_acquire_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i64 %expected, i64 %new acquire monotonic, align 1
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_unaligned_acquire_monotonic_weak(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_unaligned_acquire_monotonic_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i64 %expected, i64 %new acquire monotonic, align 1
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_unaligned_acquire_acquire(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_unaligned_acquire_acquire:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i64 %expected, i64 %new acquire acquire, align 1
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_unaligned_acquire_acquire_weak(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_unaligned_acquire_acquire_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i64 %expected, i64 %new acquire acquire, align 1
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_unaligned_acquire_seq_cst(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_unaligned_acquire_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i64 %expected, i64 %new acquire seq_cst, align 1
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_unaligned_acquire_seq_cst_weak(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_unaligned_acquire_seq_cst_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i64 %expected, i64 %new acquire seq_cst, align 1
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_unaligned_release_monotonic(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_unaligned_release_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i64 %expected, i64 %new release monotonic, align 1
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_unaligned_release_monotonic_weak(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_unaligned_release_monotonic_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i64 %expected, i64 %new release monotonic, align 1
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_unaligned_release_acquire(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_unaligned_release_acquire:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i64 %expected, i64 %new release acquire, align 1
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_unaligned_release_acquire_weak(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_unaligned_release_acquire_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i64 %expected, i64 %new release acquire, align 1
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_unaligned_release_seq_cst(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_unaligned_release_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i64 %expected, i64 %new release seq_cst, align 1
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_unaligned_release_seq_cst_weak(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_unaligned_release_seq_cst_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i64 %expected, i64 %new release seq_cst, align 1
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_unaligned_acq_rel_monotonic(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_unaligned_acq_rel_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i64 %expected, i64 %new acq_rel monotonic, align 1
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_unaligned_acq_rel_monotonic_weak(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_unaligned_acq_rel_monotonic_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i64 %expected, i64 %new acq_rel monotonic, align 1
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_unaligned_acq_rel_acquire(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_unaligned_acq_rel_acquire:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i64 %expected, i64 %new acq_rel acquire, align 1
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_unaligned_acq_rel_acquire_weak(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_unaligned_acq_rel_acquire_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i64 %expected, i64 %new acq_rel acquire, align 1
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_unaligned_acq_rel_seq_cst(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_unaligned_acq_rel_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i64 %expected, i64 %new acq_rel seq_cst, align 1
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_unaligned_acq_rel_seq_cst_weak(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_unaligned_acq_rel_seq_cst_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i64 %expected, i64 %new acq_rel seq_cst, align 1
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_unaligned_seq_cst_monotonic(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_unaligned_seq_cst_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i64 %expected, i64 %new seq_cst monotonic, align 1
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_unaligned_seq_cst_monotonic_weak(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_unaligned_seq_cst_monotonic_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i64 %expected, i64 %new seq_cst monotonic, align 1
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_unaligned_seq_cst_acquire(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_unaligned_seq_cst_acquire:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i64 %expected, i64 %new seq_cst acquire, align 1
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_unaligned_seq_cst_acquire_weak(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_unaligned_seq_cst_acquire_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i64 %expected, i64 %new seq_cst acquire, align 1
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_unaligned_seq_cst_seq_cst(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_unaligned_seq_cst_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i64 %expected, i64 %new seq_cst seq_cst, align 1
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i64 @cmpxchg_i64_unaligned_seq_cst_seq_cst_weak(i64 %expected, i64 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i64_unaligned_seq_cst_seq_cst_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i64 %expected, i64 %new seq_cst seq_cst, align 1
    %r = extractvalue { i64, i1 } %pair, 0
    ret i64 %r
}

define dso_local i128 @cmpxchg_i128_unaligned_monotonic_monotonic(i128 %expected, i128 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i128_unaligned_monotonic_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i128 %expected, i128 %new monotonic monotonic, align 1
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_unaligned_monotonic_monotonic_weak(i128 %expected, i128 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i128_unaligned_monotonic_monotonic_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i128 %expected, i128 %new monotonic monotonic, align 1
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_unaligned_monotonic_acquire(i128 %expected, i128 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i128_unaligned_monotonic_acquire:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i128 %expected, i128 %new monotonic acquire, align 1
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_unaligned_monotonic_acquire_weak(i128 %expected, i128 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i128_unaligned_monotonic_acquire_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i128 %expected, i128 %new monotonic acquire, align 1
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_unaligned_monotonic_seq_cst(i128 %expected, i128 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i128_unaligned_monotonic_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i128 %expected, i128 %new monotonic seq_cst, align 1
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_unaligned_monotonic_seq_cst_weak(i128 %expected, i128 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i128_unaligned_monotonic_seq_cst_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i128 %expected, i128 %new monotonic seq_cst, align 1
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_unaligned_acquire_monotonic(i128 %expected, i128 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i128_unaligned_acquire_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i128 %expected, i128 %new acquire monotonic, align 1
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_unaligned_acquire_monotonic_weak(i128 %expected, i128 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i128_unaligned_acquire_monotonic_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i128 %expected, i128 %new acquire monotonic, align 1
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_unaligned_acquire_acquire(i128 %expected, i128 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i128_unaligned_acquire_acquire:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i128 %expected, i128 %new acquire acquire, align 1
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_unaligned_acquire_acquire_weak(i128 %expected, i128 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i128_unaligned_acquire_acquire_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i128 %expected, i128 %new acquire acquire, align 1
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_unaligned_acquire_seq_cst(i128 %expected, i128 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i128_unaligned_acquire_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i128 %expected, i128 %new acquire seq_cst, align 1
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_unaligned_acquire_seq_cst_weak(i128 %expected, i128 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i128_unaligned_acquire_seq_cst_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i128 %expected, i128 %new acquire seq_cst, align 1
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_unaligned_release_monotonic(i128 %expected, i128 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i128_unaligned_release_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i128 %expected, i128 %new release monotonic, align 1
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_unaligned_release_monotonic_weak(i128 %expected, i128 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i128_unaligned_release_monotonic_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i128 %expected, i128 %new release monotonic, align 1
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_unaligned_release_acquire(i128 %expected, i128 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i128_unaligned_release_acquire:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i128 %expected, i128 %new release acquire, align 1
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_unaligned_release_acquire_weak(i128 %expected, i128 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i128_unaligned_release_acquire_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i128 %expected, i128 %new release acquire, align 1
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_unaligned_release_seq_cst(i128 %expected, i128 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i128_unaligned_release_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i128 %expected, i128 %new release seq_cst, align 1
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_unaligned_release_seq_cst_weak(i128 %expected, i128 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i128_unaligned_release_seq_cst_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i128 %expected, i128 %new release seq_cst, align 1
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_unaligned_acq_rel_monotonic(i128 %expected, i128 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i128_unaligned_acq_rel_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i128 %expected, i128 %new acq_rel monotonic, align 1
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_unaligned_acq_rel_monotonic_weak(i128 %expected, i128 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i128_unaligned_acq_rel_monotonic_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i128 %expected, i128 %new acq_rel monotonic, align 1
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_unaligned_acq_rel_acquire(i128 %expected, i128 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i128_unaligned_acq_rel_acquire:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i128 %expected, i128 %new acq_rel acquire, align 1
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_unaligned_acq_rel_acquire_weak(i128 %expected, i128 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i128_unaligned_acq_rel_acquire_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i128 %expected, i128 %new acq_rel acquire, align 1
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_unaligned_acq_rel_seq_cst(i128 %expected, i128 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i128_unaligned_acq_rel_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i128 %expected, i128 %new acq_rel seq_cst, align 1
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_unaligned_acq_rel_seq_cst_weak(i128 %expected, i128 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i128_unaligned_acq_rel_seq_cst_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i128 %expected, i128 %new acq_rel seq_cst, align 1
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_unaligned_seq_cst_monotonic(i128 %expected, i128 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i128_unaligned_seq_cst_monotonic:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i128 %expected, i128 %new seq_cst monotonic, align 1
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_unaligned_seq_cst_monotonic_weak(i128 %expected, i128 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i128_unaligned_seq_cst_monotonic_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i128 %expected, i128 %new seq_cst monotonic, align 1
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_unaligned_seq_cst_acquire(i128 %expected, i128 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i128_unaligned_seq_cst_acquire:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i128 %expected, i128 %new seq_cst acquire, align 1
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_unaligned_seq_cst_acquire_weak(i128 %expected, i128 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i128_unaligned_seq_cst_acquire_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i128 %expected, i128 %new seq_cst acquire, align 1
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_unaligned_seq_cst_seq_cst(i128 %expected, i128 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i128_unaligned_seq_cst_seq_cst:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg ptr %ptr, i128 %expected, i128 %new seq_cst seq_cst, align 1
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}

define dso_local i128 @cmpxchg_i128_unaligned_seq_cst_seq_cst_weak(i128 %expected, i128 %new, ptr %ptr) {
; CHECK-LABEL: cmpxchg_i128_unaligned_seq_cst_seq_cst_weak:
; CHECK:    bl __atomic_compare_exchange
    %pair = cmpxchg weak ptr %ptr, i128 %expected, i128 %new seq_cst seq_cst, align 1
    %r = extractvalue { i128, i1 } %pair, 0
    ret i128 %r
}
