; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d -verify-machineinstrs < %s \
; RUN:   -target-abi=ilp32d | FileCheck -check-prefixes=CHECKIFD,RV32IFD %s
; RUN: llc -mtriple=riscv64 -mattr=+d -verify-machineinstrs < %s \
; RUN:   -target-abi=lp64d | FileCheck -check-prefixes=CHECKIFD,RV64IFD %s

define dso_local double @fld(ptr %a) nounwind {
; CHECKIFD-LABEL: fld:
; CHECKIFD:       # %bb.0:
; CHECKIFD-NEXT:    fld ft0, 0(a0)
; CHECKIFD-NEXT:    fld ft1, 24(a0)
; CHECKIFD-NEXT:    fadd.d fa0, ft0, ft1
; CHECKIFD-NEXT:    ret
  %1 = load double, ptr %a
  %2 = getelementptr double, ptr %a, i32 3
  %3 = load double, ptr %2
; Use both loaded values in an FP op to ensure an fld is used, even for the
; soft float ABI
  %4 = fadd double %1, %3
  ret double %4
}

define dso_local void @fsd(ptr %a, double %b, double %c) nounwind {
; CHECKIFD-LABEL: fsd:
; CHECKIFD:       # %bb.0:
; CHECKIFD-NEXT:    fadd.d ft0, fa0, fa1
; CHECKIFD-NEXT:    fsd ft0, 0(a0)
; CHECKIFD-NEXT:    fsd ft0, 64(a0)
; CHECKIFD-NEXT:    ret
; Use %b and %c in an FP op to ensure floating point registers are used, even
; for the soft float ABI
  %1 = fadd double %b, %c
  store double %1, ptr %a
  %2 = getelementptr double, ptr %a, i32 8
  store double %1, ptr %2
  ret void
}

; Check load and store to a global
@G = dso_local global double 0.0

define dso_local double @fld_fsd_global(double %a, double %b) nounwind {
; CHECKIFD-LABEL: fld_fsd_global:
; CHECKIFD:       # %bb.0:
; CHECKIFD-NEXT:    fadd.d fa0, fa0, fa1
; CHECKIFD-NEXT:    lui a0, %hi(G)
; CHECKIFD-NEXT:    fld ft0, %lo(G)(a0)
; CHECKIFD-NEXT:    addi a1, a0, %lo(G)
; CHECKIFD-NEXT:    fsd fa0, %lo(G)(a0)
; CHECKIFD-NEXT:    fld ft0, 72(a1)
; CHECKIFD-NEXT:    fsd fa0, 72(a1)
; CHECKIFD-NEXT:    ret
; Use %a and %b in an FP op to ensure floating point registers are used, even
; for the soft float ABI
  %1 = fadd double %a, %b
  %2 = load volatile double, ptr @G
  store double %1, ptr @G
  %3 = getelementptr double, ptr @G, i32 9
  %4 = load volatile double, ptr %3
  store double %1, ptr %3
  ret double %1
}

; Ensure that 1 is added to the high 20 bits if bit 11 of the low part is 1
define dso_local double @fld_fsd_constant(double %a) nounwind {
; RV32IFD-LABEL: fld_fsd_constant:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    lui a0, 912092
; RV32IFD-NEXT:    fld ft0, -273(a0)
; RV32IFD-NEXT:    fadd.d fa0, fa0, ft0
; RV32IFD-NEXT:    fsd fa0, -273(a0)
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: fld_fsd_constant:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    lui a0, 228023
; RV64IFD-NEXT:    slli a0, a0, 2
; RV64IFD-NEXT:    fld ft0, -273(a0)
; RV64IFD-NEXT:    fadd.d fa0, fa0, ft0
; RV64IFD-NEXT:    fsd fa0, -273(a0)
; RV64IFD-NEXT:    ret
  %1 = inttoptr i32 3735928559 to ptr
  %2 = load volatile double, ptr %1
  %3 = fadd double %a, %2
  store double %3, ptr %1
  ret double %3
}

declare void @notdead(ptr)

define dso_local double @fld_stack(double %a) nounwind {
; RV32IFD-LABEL: fld_stack:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -32
; RV32IFD-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    fsd fs0, 16(sp) # 8-byte Folded Spill
; RV32IFD-NEXT:    fmv.d fs0, fa0
; RV32IFD-NEXT:    addi a0, sp, 8
; RV32IFD-NEXT:    call notdead@plt
; RV32IFD-NEXT:    fld ft0, 8(sp)
; RV32IFD-NEXT:    fadd.d fa0, ft0, fs0
; RV32IFD-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    fld fs0, 16(sp) # 8-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 32
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: fld_stack:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -32
; RV64IFD-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    fsd fs0, 16(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    fmv.d fs0, fa0
; RV64IFD-NEXT:    addi a0, sp, 8
; RV64IFD-NEXT:    call notdead@plt
; RV64IFD-NEXT:    fld ft0, 8(sp)
; RV64IFD-NEXT:    fadd.d fa0, ft0, fs0
; RV64IFD-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    fld fs0, 16(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 32
; RV64IFD-NEXT:    ret
  %1 = alloca double, align 8
  call void @notdead(ptr %1)
  %2 = load double, ptr %1
  %3 = fadd double %2, %a ; force load in to FPR64
  ret double %3
}

define dso_local void @fsd_stack(double %a, double %b) nounwind {
; RV32IFD-LABEL: fsd_stack:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    fadd.d ft0, fa0, fa1
; RV32IFD-NEXT:    fsd ft0, 0(sp)
; RV32IFD-NEXT:    mv a0, sp
; RV32IFD-NEXT:    call notdead@plt
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: fsd_stack:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -16
; RV64IFD-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    fadd.d ft0, fa0, fa1
; RV64IFD-NEXT:    fsd ft0, 0(sp)
; RV64IFD-NEXT:    mv a0, sp
; RV64IFD-NEXT:    call notdead@plt
; RV64IFD-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 16
; RV64IFD-NEXT:    ret
  %1 = fadd double %a, %b ; force store from FPR64
  %2 = alloca double, align 8
  store double %1, ptr %2
  call void @notdead(ptr %2)
  ret void
}

; Test selection of store<ST4[%a], trunc to f32>, ..
define dso_local void @fsd_trunc(ptr %a, double %b) nounwind noinline optnone {
; CHECKIFD-LABEL: fsd_trunc:
; CHECKIFD:       # %bb.0:
; CHECKIFD-NEXT:    fcvt.s.d ft0, fa0
; CHECKIFD-NEXT:    fsw ft0, 0(a0)
; CHECKIFD-NEXT:    ret
  %1 = fptrunc double %b to float
  store float %1, ptr %a, align 4
  ret void
}
