; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature
; RUN: opt -passes=ipsccp -S %s -o -| FileCheck %s

define void @caller.1(ptr %arg) {
; CHECK-LABEL: define {{[^@]+}}@caller.1
; CHECK-SAME: (ptr [[ARG:%.*]]) {
; CHECK-NEXT:    [[R_1:%.*]] = tail call i32 @callee.1(i32 4)
; CHECK-NEXT:    [[R_2:%.*]] = tail call i32 @callee.1(i32 2)
; CHECK-NEXT:    call void @use(i32 20)
; CHECK-NEXT:    ret void
;
  %r.1 = tail call i32 @callee.1(i32 4)
  %r.2 = tail call i32 @callee.1(i32 2)
  %r.3 = add i32 %r.1, %r.2
  call void @use(i32 %r.3)
  ret void
}

define internal i32 @callee.1(i32 %arg) {
; CHECK-LABEL: define {{[^@]+}}@callee.1
; CHECK-SAME: (i32 [[ARG:%.*]]) {
; CHECK-NEXT:    [[SEL:%.*]] = select i1 false, i32 16, i32 [[ARG]]
; CHECK-NEXT:    br label [[BB10:%.*]]
; CHECK:       bb10:
; CHECK-NEXT:    ret i32 undef
;
  %c.1 = icmp slt i32 %arg, 0
  %sel = select i1 %c.1, i32 16, i32 %arg
  %c.2 = icmp eq i32 %sel, 0
  br i1 %c.2, label %bb12, label %bb10

bb10:                                             ; preds = %bb8
  ret i32 10

bb12:                                             ; preds = %bb8, %bb3, %bb
  ret i32 12
}

declare void @use(i32)

define internal i1 @f1(i32 %x, i32 %y, i1 %cmp) {
; CHECK-LABEL: define {{[^@]+}}@f1
; CHECK-SAME: (i32 [[X:%.*]], i32 [[Y:%.*]], i1 [[CMP:%.*]]) {
; CHECK-NEXT:    [[SEL_1:%.*]] = select i1 [[CMP]], i32 [[X]], i32 [[Y]]
; CHECK-NEXT:    [[C_2:%.*]] = icmp sgt i32 [[SEL_1]], 100
; CHECK-NEXT:    [[C_3:%.*]] = icmp eq i32 [[SEL_1]], 50
; CHECK-NEXT:    [[RES_1:%.*]] = add i1 false, [[C_2]]
; CHECK-NEXT:    [[RES_2:%.*]] = add i1 [[RES_1]], [[C_3]]
; CHECK-NEXT:    [[RES_3:%.*]] = add i1 [[RES_2]], false
; CHECK-NEXT:    ret i1 [[RES_3]]
;
  %sel.1 = select i1 %cmp, i32 %x, i32 %y
  %c.1 = icmp sgt i32 %sel.1, 300
  %c.2 = icmp sgt i32 %sel.1, 100
  %c.3 = icmp eq i32 %sel.1, 50
  %c.4 = icmp slt i32 %sel.1, 9
  %res.1 = add i1 %c.1, %c.2
  %res.2 = add i1 %res.1, %c.3
  %res.3 = add i1 %res.2, %c.4
  ret i1 %res.3
}

define i1 @caller1(i1 %cmp) {
; CHECK-LABEL: define {{[^@]+}}@caller1
; CHECK-SAME: (i1 [[CMP:%.*]]) {
; CHECK-NEXT:    [[CALL_1:%.*]] = tail call i1 @f1(i32 10, i32 100, i1 [[CMP]])
; CHECK-NEXT:    [[CALL_2:%.*]] = tail call i1 @f1(i32 20, i32 200, i1 [[CMP]])
; CHECK-NEXT:    [[RES:%.*]] = and i1 [[CALL_1]], [[CALL_2]]
; CHECK-NEXT:    ret i1 [[RES]]
;
  %call.1 = tail call i1 @f1(i32 10, i32 100, i1 %cmp)
  %call.2 = tail call i1 @f1(i32 20, i32 200, i1 %cmp)
  %res = and i1 %call.1, %call.2
  ret i1 %res
}


define i1 @f2(i32 %x, i32 %y, i1 %cmp) {
; CHECK-LABEL: define {{[^@]+}}@f2
; CHECK-SAME: (i32 [[X:%.*]], i32 [[Y:%.*]], i1 [[CMP:%.*]]) {
; CHECK-NEXT:    [[SEL_1:%.*]] = select i1 [[CMP]], i32 [[X]], i32 [[Y]]
; CHECK-NEXT:    [[C_1:%.*]] = icmp sgt i32 [[SEL_1]], 300
; CHECK-NEXT:    [[C_2:%.*]] = icmp sgt i32 [[SEL_1]], 100
; CHECK-NEXT:    [[C_3:%.*]] = icmp eq i32 [[SEL_1]], 50
; CHECK-NEXT:    [[C_4:%.*]] = icmp slt i32 [[SEL_1]], 9
; CHECK-NEXT:    [[RES_1:%.*]] = add i1 [[C_1]], [[C_2]]
; CHECK-NEXT:    [[RES_2:%.*]] = add i1 [[RES_1]], [[C_3]]
; CHECK-NEXT:    [[RES_3:%.*]] = add i1 [[RES_2]], [[C_4]]
; CHECK-NEXT:    ret i1 [[RES_3]]
;
  %sel.1 = select i1 %cmp, i32 %x, i32 %y
  %c.1 = icmp sgt i32 %sel.1, 300
  %c.2 = icmp sgt i32 %sel.1, 100
  %c.3 = icmp eq i32 %sel.1, 50
  %c.4 = icmp slt i32 %sel.1, 9
  %res.1 = add i1 %c.1, %c.2
  %res.2 = add i1 %res.1, %c.3
  %res.3 = add i1 %res.2, %c.4
  ret i1 %res.3
}

define i1 @caller2(i32 %y, i1 %cmp) {
; CHECK-LABEL: define {{[^@]+}}@caller2
; CHECK-SAME: (i32 [[Y:%.*]], i1 [[CMP:%.*]]) {
; CHECK-NEXT:    [[CALL_1:%.*]] = tail call i1 @f2(i32 10, i32 [[Y]], i1 [[CMP]])
; CHECK-NEXT:    [[CALL_2:%.*]] = tail call i1 @f2(i32 20, i32 [[Y]], i1 [[CMP]])
; CHECK-NEXT:    [[RES:%.*]] = and i1 [[CALL_1]], [[CALL_2]]
; CHECK-NEXT:    ret i1 [[RES]]
;
  %call.1 = tail call i1 @f2(i32 10, i32 %y, i1 %cmp)
  %call.2 = tail call i1 @f2(i32 20, i32 %y, i1 %cmp)
  %res = and i1 %call.1, %call.2
  ret i1 %res
}

@GV = common global i32 0, align 4

define i32 @f3_constantexpr_cond(i32 %x, i32 %y) {
; CHECK-LABEL: define {{[^@]+}}@f3_constantexpr_cond
; CHECK-SAME: (i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[SEL_1:%.*]] = select i1 icmp eq (ptr @f3_constantexpr_cond, ptr @GV), i32 [[X]], i32 [[Y]]
; CHECK-NEXT:    ret i32 [[SEL_1]]
;
  %sel.1 = select i1 icmp eq (ptr @f3_constantexpr_cond, ptr @GV), i32 %x, i32 %y
  ret i32 %sel.1
}

define i32 @caller3(i32 %y) {
; CHECK-LABEL: define {{[^@]+}}@caller3
; CHECK-SAME: (i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[CALL_1:%.*]] = tail call i32 @f3_constantexpr_cond(i32 10, i32 [[Y]])
; CHECK-NEXT:    [[CALL_2:%.*]] = tail call i32 @f3_constantexpr_cond(i32 20, i32 [[Y]])
; CHECK-NEXT:    [[RES:%.*]] = and i32 [[CALL_1]], [[CALL_2]]
; CHECK-NEXT:    ret i32 [[RES]]
;
  %call.1 = tail call i32 @f3_constantexpr_cond(i32 10, i32 %y)
  %call.2 = tail call i32 @f3_constantexpr_cond(i32 20, i32 %y)
  %res = and i32 %call.1, %call.2
  ret i32 %res
}
