; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s
;
; Verify that the result of memrchr calls used in equality expressions
; with the first argument aren't folded like the corresponding calls
; to memchr might be.
; Folding of equality expressions with the first argument plus the bound
; -1, i.e., memrchr(S, C, N) == N && S[N - 1] == C is not implemented.

declare ptr @memrchr(ptr, i32, i64)


@a5 = constant [5 x i8] c"12345";

; Do not fold memrchr(a5, c, 9) == a5.  The corresponding call to memchr
; is folded so this test verifies that the memrchr folder doesn't make
; the wrong assumption.  The bound of 9 tries to avoid having to adjust
; the test if the call is folded into a series of ORs as in D128011.

define i1 @call_memrchr_a_c_9_eq_a(i32 %c) {
; CHECK-LABEL: @call_memrchr_a_c_9_eq_a(
; CHECK-NEXT:    [[Q:%.*]] = call ptr @memrchr(ptr noundef nonnull dereferenceable(9) @a5, i32 [[C:%.*]], i64 9)
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq ptr [[Q]], @a5
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %q = call ptr @memrchr(ptr @a5, i32 %c, i64 9)
  %cmp = icmp eq ptr %q, @a5
  ret i1 %cmp
}


; Do not fold memrchr(a5, c, n).

define i1 @call_memrchr_a_c_n_eq_a(i32 %c, i64 %n) {
; CHECK-LABEL: @call_memrchr_a_c_n_eq_a(
; CHECK-NEXT:    [[Q:%.*]] = call ptr @memrchr(ptr nonnull @a5, i32 [[C:%.*]], i64 [[N:%.*]])
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq ptr [[Q]], @a5
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %q = call ptr @memrchr(ptr @a5, i32 %c, i64 %n)
  %cmp = icmp eq ptr %q, @a5
  ret i1 %cmp
}


; Do not fold memrchr(s, c, 17).

define i1 @call_memrchr_s_c_17_eq_s(ptr %s, i32 %c) {
; CHECK-LABEL: @call_memrchr_s_c_17_eq_s(
; CHECK-NEXT:    [[P:%.*]] = call ptr @memrchr(ptr noundef nonnull dereferenceable(17) [[S:%.*]], i32 [[C:%.*]], i64 17)
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq ptr [[P]], [[S]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %p = call ptr @memrchr(ptr %s, i32 %c, i64 17)
  %cmp = icmp eq ptr %p, %s
  ret i1 %cmp
}


; Do not fold memrchr(s, c, 9).

define i1 @call_memrchr_s_c_9_neq_s(ptr %s, i32 %c) {
; CHECK-LABEL: @call_memrchr_s_c_9_neq_s(
; CHECK-NEXT:    [[P:%.*]] = call ptr @memrchr(ptr noundef nonnull dereferenceable(7) [[S:%.*]], i32 [[C:%.*]], i64 7)
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne ptr [[P]], [[S]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %p = call ptr @memrchr(ptr %s, i32 %c, i64 7)
  %cmp = icmp ne ptr %p, %s
  ret i1 %cmp
}


; Do not fold memrchr(s, c, n).

define i1 @fold_memrchr_s_c_n_eq_s(ptr %s, i32 %c, i64 %n) {
; CHECK-LABEL: @fold_memrchr_s_c_n_eq_s(
; CHECK-NEXT:    [[P:%.*]] = call ptr @memrchr(ptr [[S:%.*]], i32 [[C:%.*]], i64 [[N:%.*]])
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq ptr [[P]], [[S]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %p = call ptr @memrchr(ptr %s, i32 %c, i64 %n)
  %cmp = icmp eq ptr %p, %s
  ret i1 %cmp
}
