; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=slp-vectorizer -S -mtriple=aarch64-unknown-unknown | FileCheck %s

; This test is reduced from the TSVC evaluation of vectorizers:
; https://github.com/llvm/llvm-test-suite/commits/main/MultiSource/Benchmarks/TSVC/LoopRerolling-flt/tsc.c

; FIXME
; This test is currently getting vectorized with VF=2. We should be able
; to vectorize it with VF=4. Specifically, we should be able to have 1 load of
; <4 x float> instead of 2 loads of <2 x float>, and there should be no need
; for shufflevectors.
; The current issue comes from the Left-Hand-Side fmul operands.
; These operands are coming from 4 loads which are not
; contiguous. The score estimation needs to be corrected, so that these 4 loads
; are not selected for vectorization. Instead we should vectorize with
; contiguous loads, from %a plus offsets 0 to 3, or offsets 1 to 4.

define void @s116_modified(ptr %a) {
; CHECK-LABEL: @s116_modified(
; CHECK-NEXT:    [[GEP1:%.*]] = getelementptr inbounds float, ptr [[A:%.*]], i64 1
; CHECK-NEXT:    [[GEP3:%.*]] = getelementptr inbounds float, ptr [[A]], i64 3
; CHECK-NEXT:    [[LD0:%.*]] = load float, ptr [[A]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = load <2 x float>, ptr [[GEP1]], align 4
; CHECK-NEXT:    [[TMP4:%.*]] = load <2 x float>, ptr [[GEP3]], align 4
; CHECK-NEXT:    [[TMP5:%.*]] = insertelement <4 x float> poison, float [[LD0]], i32 0
; CHECK-NEXT:    [[TMP6:%.*]] = shufflevector <2 x float> [[TMP2]], <2 x float> poison, <4 x i32> <i32 0, i32 1, i32 1, i32 poison>
; CHECK-NEXT:    [[TMP7:%.*]] = shufflevector <4 x float> [[TMP5]], <4 x float> [[TMP6]], <4 x i32> <i32 0, i32 5, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP8:%.*]] = shufflevector <2 x float> [[TMP4]], <2 x float> poison, <4 x i32> <i32 0, i32 1, i32 poison, i32 poison>
; CHECK-NEXT:    [[TMP9:%.*]] = shufflevector <4 x float> [[TMP7]], <4 x float> [[TMP8]], <4 x i32> <i32 0, i32 1, i32 4, i32 5>
; CHECK-NEXT:    [[TMP10:%.*]] = shufflevector <4 x float> [[TMP6]], <4 x float> [[TMP8]], <4 x i32> <i32 0, i32 poison, i32 2, i32 4>
; CHECK-NEXT:    [[TMP11:%.*]] = shufflevector <4 x float> [[TMP10]], <4 x float> poison, <4 x i32> <i32 0, i32 0, i32 2, i32 3>
; CHECK-NEXT:    [[TMP12:%.*]] = fmul fast <4 x float> [[TMP9]], [[TMP11]]
; CHECK-NEXT:    store <4 x float> [[TMP12]], ptr [[A]], align 4
; CHECK-NEXT:    ret void
;
  %gep1 = getelementptr inbounds float, ptr %a, i64 1
  %gep2 = getelementptr inbounds float, ptr %a, i64 2
  %gep3 = getelementptr inbounds float, ptr %a, i64 3
  %gep4 = getelementptr inbounds float, ptr %a, i64 4
  %ld0 = load float, ptr %a
  %ld1 = load float, ptr %gep1
  %ld2 = load float, ptr %gep2
  %ld3 = load float, ptr %gep3
  %ld4 = load float, ptr %gep4
  %mul0 = fmul fast float %ld0, %ld1
  %mul1 = fmul fast float %ld2, %ld1
  %mul2 = fmul fast float %ld3, %ld2
  %mul3 = fmul fast float %ld4, %ld3
  store float %mul0, ptr %a
  store float %mul1, ptr %gep1
  store float %mul2, ptr %gep2
  store float %mul3, ptr %gep3
  ret void
}


