; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=gvn < %s | FileCheck %s

; Phi translation of %gep.j cannot use %gep.i, which is located in a context
; where %i != 0, and would result in incorrect NoAlias results in a context
; where %i == 0 may hold.

define i32 @test(i64 %i, i1 %c1, i1 %c2) {
; CHECK-LABEL: @test(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[PTR:%.*]] = alloca [2 x i32], align 4
; CHECK-NEXT:    br i1 [[C1:%.*]], label [[IF:%.*]], label [[ELSE:%.*]]
; CHECK:       if:
; CHECK-NEXT:    br i1 [[C2:%.*]], label [[IF2:%.*]], label [[ELSE2:%.*]]
; CHECK:       if2:
; CHECK-NEXT:    store i32 1, ptr [[PTR]], align 4
; CHECK-NEXT:    [[GEP_J_PHI_TRANS_INSERT:%.*]] = getelementptr inbounds i32, ptr [[PTR]], i64 [[I:%.*]]
; CHECK-NEXT:    [[V_PRE:%.*]] = load i32, ptr [[GEP_J_PHI_TRANS_INSERT]], align 4
; CHECK-NEXT:    br label [[JOIN:%.*]]
; CHECK:       else2:
; CHECK-NEXT:    store i32 2, ptr [[PTR]], align 4
; CHECK-NEXT:    br label [[JOIN]]
; CHECK:       join:
; CHECK-NEXT:    [[V:%.*]] = phi i32 [ [[V_PRE]], [[IF2]] ], [ 2, [[ELSE2]] ]
; CHECK-NEXT:    [[J:%.*]] = phi i64 [ [[I]], [[IF2]] ], [ 0, [[ELSE2]] ]
; CHECK-NEXT:    [[GEP_J:%.*]] = getelementptr inbounds i32, ptr [[PTR]], i64 [[J]]
; CHECK-NEXT:    ret i32 [[V]]
; CHECK:       else:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i64 [[I]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[CMP]])
; CHECK-NEXT:    [[GEP_I:%.*]] = getelementptr inbounds i32, ptr [[PTR]], i64 [[I]]
; CHECK-NEXT:    ret i32 0
;
entry:
  %ptr = alloca [2 x i32]
  br i1 %c1, label %if, label %else

if:
  br i1 %c2, label %if2, label %else2

if2:
  store i32 1, ptr %ptr
  br label %join

else2:
  store i32 2, ptr %ptr
  br label %join

join:
  %j = phi i64 [ %i, %if2 ], [ 0, %else2 ]
  %gep.j = getelementptr inbounds i32, ptr %ptr, i64 %j
  %v = load i32, ptr %gep.j
  ret i32 %v

else:
  %cmp = icmp ne i64 %i, 0
  call void @llvm.assume(i1 %cmp)
  %gep.i = getelementptr inbounds i32, ptr %ptr, i64 %i
  ret i32 0
}

declare void @llvm.assume(i1)
