/***************************************************************************
 *                             Ada Web Server                              *
 *                                                                         *
 *                    Copyright (C) 2009-2012, AdaCore                     *
 *                                                                         *
 * This library is free software;  you can redistribute it and/or modify   *
 * it under terms of the  GNU General Public License  as published by the  *
 * Free Software  Foundation;  either version 3,  or (at your  option) any *
 * later version. This library is distributed in the hope that it will be  *
 * useful, but WITHOUT ANY WARRANTY;  without even the implied warranty of *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                    *
 *                                                                         *
 *                                                                          * 
 *                                                                          * 
 *                                                                          * 
 *                                                                         *
 * You should have received a copy of the GNU General Public License and   *
 * a copy of the GCC Runtime Library Exception along with this program;    *
 * see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see   *
 * <http://www.gnu.org/licenses/>.                                         *
 *                                                                         *
 *                                                                          * 
 *                                                                          * 
 *                                                                          * 
 *                                                                          * 
 *                                                                          * 
 *                                                                          * 
 ***************************************************************************/

/* Wrapper around some C macros */

#if defined(__vxworks)
#include <vxWorks.h>
#else
#include <sys/select.h>
#endif

#define SOCKET int

int
__aws_is_socket_in_set (SOCKET socket, fd_set *set)
{
  return FD_ISSET (socket, set);
}

void
__aws_set_socket_in_set (SOCKET socket, fd_set *set)
{
  FD_SET (socket, set);
}

void
__aws_clear_socket_set (fd_set *set)
{
  FD_ZERO (set);
}
