## Related projects

Here are links to a number of projects related to **Joda-Time**.
These projects are independent - no guarantees of quality are given!

* [Extended Hibernate support](http://usertype.sourceforge.net/) - A set of classes to link Joda-Time to databases using Hibernate.
* [Original Hibernate support](http://www.joda.org/joda-time-hibernate/) - The original set of classes to link Joda-Time to databases using Hibernate (UserType project is newer and better maintained).
* [JSP tag support](http://www.joda.org/joda-time-jsptags/) - A tag library in the style of JSTL to allow Joda-Time classes to be used in JSP.
* [I18N support](http://www.joda.org/joda-time-i18n/) - A simple library that provides additional internationalization data for Joda-Time.
* [ObjectLab Holiday calculation](http://objectlabkit.sourceforge.net/) - Support for working and non-working days, plus how to calculate and resolve holidays, from a finance industry perspective.
* [Jollyday holiday calculation](http://jollyday.sourceforge.net/) - Provides classes to handle calculation of holidays.
* [Recurrance (RFC 2445)](http://code.google.com/p/google-rfc-2445/) - Support for the RFC2445 recurrence specification, as found in iCal.
* [DataNucleus support](https://github.com/datanucleus/datanucleus-jodatime) - A library providing persistence via the DataNucleus platform.
* [JAXB](http://blog.bdoughan.com/2011/05/jaxb-and-joda-time-dates-and-times.html) - Notes on Joda-Time and JAXB.
* [P2 update site](https://github.com/muuki88/joda-osgi) - Eclipse P2 update site.
* [External Study Trails user guide](http://www.studytrails.com/java/jodatime/)
* [Humanize](https://github.com/mfornos/humanize) - Human stylized text for date and time.
* [Joda-Time for Android](https://github.com/dlew/joda-time-android) -
Version for Android.

If your open source library provides a value added feature on top of Joda-Time,
then let us know! Just send a pull request to edit this page.
