/*
 * Copyright 2012-2017 Brian Campbell
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jose4j.jwt.consumer;

import org.jose4j.jwt.MalformedClaimException;

/**
 *
 */
public class ErrorCodeValidatorAdapter implements ErrorCodeValidator
{
    private Validator validator;

    public ErrorCodeValidatorAdapter(Validator validator)
    {
        this.validator = validator;
    }

    @Override
    public Error validate(JwtContext jwtContext) throws MalformedClaimException
    {
        String result = validator.validate(jwtContext);
        return (result == null) ? null : new Error(ErrorCodes.MISCELLANEOUS, result);
    }
}
